#!/usr/bin/env python
import numpy as np
import netCDF4
from netCDF4 import Dataset

class ncload():
  def __init__(self,fname):
    """
    Load netcdf file.
  
    This function will load a netcdf file using Netcdf4 standard (absolute address or relative address supported). 
    
    Instance attributes:
    -------  
    self.nc             : current netcdf file  
    """
    if fname[-3:]=='.nc':
      ncfile=fname
    else:
      ncfile=fname+'.nc'
    self.nc=Dataset(ncfile,'r')
    self.name=ncfile
  
  def _getvar(self,vname):
    """
    Choose a variable in the nc file.
    
    This function will read the variable named 'varname'.
   
    Returns
    -------
    var : netCDF.Variable object
    """
    return self.nc.variables[vname]

  def get(self,*vnames):
    """
    Choose a variable or a list of variales.
    
    Parameters
    ----------
    varnames : list or string
           Names of variables. Could be string (one variable) or list (several variables)

    Returns
    -------
    varlist: netCDF4.Variable objects
    """
    varlist=[self._getvar(vname) for vname in vnames]
    self._refvar=varlist[0]
    return varlist[0] if len(vnames)==1 else varlist
  
  def close(self):
    self.nc.close()
