#!/usr/bin/env python
import numpy as np
from netCDF4 import Dataset
from ncload import ncload
import ss_Anal

path=''

landnc=ncload(path+'Land')
land=landnc.get('land')
PFTnc=ncload(path+'PFTmap/MainPFT.nc')
PFT=PFTnc.get('PFTindex')
carbnc=ncload(path+'CARDAMOM.nc')
NPP,LEAF,ROOT,WOOD,LITTER,SOM,RT_LEAF,RT_ROOT,RT_WOOD,RT_LITTER,RT_SOM,GPP,\
 AF_FOL,AF_ROOT,AF_WOOD,ETAC,FRAC_Fire_LEAF,FRAC_Fire_ROOT,FRAC_Fire_WOOD,FRAC_Fire_LITTER,FRAC_Fire_SOM\
  =carbnc.get('Mean_FL_NPP','Mean_CP_FOL','Mean_CP_ROO','Mean_CP_WOO','Mean_CP_LIT','Mean_CP_SOM',\
              'Mean_RT_FOL','Mean_RT_ROO','Mean_RT_WOO','Mean_RT_LIT','Mean_RT_SOM','Mean_FL_GPP',\
              'Mean_AF_FOL','Mean_AF_ROO','Mean_AF_WOO','Mean_ETAC',\
              'Mean_FRAC_Fire_FOL','Mean_FRAC_Fire_ROO','Mean_FRAC_Fire_WOO','Mean_FRAC_Fire_LIT','Mean_FRAC_Fire_SOM')
std_NPP,std_LEAF,std_ROOT,std_WOOD,std_LITTER,std_SOM,\
 std_RT_LEAF,std_RT_ROOT,std_RT_WOOD,std_RT_LITTER,std_RT_SOM,std_GPP,\
 std_AF_FOL,std_AF_ROOT,std_AF_WOOD,std_ETAC,\
 std_FRAC_Fire_LEAF,std_FRAC_Fire_ROOT,std_FRAC_Fire_WOOD,std_FRAC_Fire_LITTER,std_FRAC_Fire_SOM\
  =carbnc.get('STD_FL_NPP','STD_CP_FOL','STD_CP_ROO','STD_CP_WOO','STD_CP_LIT','STD_CP_SOM',\
              'STD_RT_FOL','STD_RT_ROO','STD_RT_WOO','STD_RT_LIT','STD_RT_SOM','STD_FL_GPP',\
              'STD_AF_FOL','STD_AF_ROO','STD_AF_WOO','STD_ETAC',\
              'STD_FRAC_Fire_FOL','STD_FRAC_Fire_ROO','STD_FRAC_Fire_WOO','STD_FRAC_Fire_LIT','STD_FRAC_Fire_SOM')
deponc=ncload(path+'NP_deposition.nc')
Nd,Pd=deponc.get('N_dep','P_dep')
Nfixnc=ncload(path+'Nfix.nc')
Nfix=Nfixnc.get('Nfix')
gfracnc=ncload(path+'fgas.nc')
gfrac=gfracnc.get('fgas_N')
Pwnc=ncload(path+'Pw.nc')
Pw=Pwnc.get('Pw')
Leachingnc=ncload(path+'LeachingRatio_GRDCrunoff_ERASW.nc')
LeachingRatio=Leachingnc.get('LeachingRatio')
DissfracPnc=ncload(path+'DissFracP.nc')
Dissfrac,Dissfrac_unc=DissfracPnc.get('Frac','unc')
# N stoichiometries
s1={0:1./25. *14./12.,1:1./25. *14./12.,2:1./59. *14./12.,3:1./49. *14./12.,\
    4:1./39. *14./12.,5:1./25. *14./12.,6:1./49. *14./12.}
s2={0:1./47. *14./12.,1:1./59. *14./12.,2:1./67. *14./12.,3:1./57. *14./12.,\
    4:1./39. *14./12.,5:1./88. *14./12.,6:1./54. *14./12.}
s3={0:1./148.*14./12.,1:1./471.*14./12.,2:1./844.*14./12.,3:1./525.*14./12.,\
    4:0.     *14./12.,5:0.     *14./12.,6:0      *14./12.}
s5={0:1./16. *14./12.,1:1./19. *14./12.,2:1./20. *14./12.,3:1./32. *14./12.,\
    4:1./25. *14./12.,5:1./10. *14./12.,6:1./13. *14./12.}
eps1={0:1.-25./49,1:1.-25./65,2:1.-59./87.5,3:1.-49./56,4:1.-39./85,5:1.-25./63,6:1.-49./71}
eps2={0:0.,1:0.,2:0.,3:0.,4:0.,5:0.,6:0.}
eps3={0:0.,1:0.,2:0.,3:0.,4:0.,5:0.,6:0.}
# P stoichiometries
l1={0:1./1027. *31./12.,1:1./867.  *31./12.,2:1./1232. *31./12.,3:1./1049. *31./12.,\
    4:1./753.  *31./12.,5:1./1278. *31./12.,6:1./2167. *31./12.}
l2={0:1./3125. *31./12.,1:1./1962. *31./12.,2:1./1186. *31./12.,3:1./1574. *31./12.,\
    4:1./1300. *31./12.,5:1./2829. *31./12.,6:1./1300. *31./12.}
l3={0:1./13574.*31./12.,1:1./11179.*31./12.,2:1./24297.*31./12.,3:1./19734.*31./12.,\
    4:0.       *31./12.,5:0.       *31./12.,6:0        *31./12.}
l5={0:1./159.  *31./12.,1:1./366.  *31./12.,2:1./302.  *31./12.,3:1./960.  *31./12.,\
    4:1./509.  *31./12.,5:1./130.  *31./12.,6:1./138.  *31./12.}
tht1={0:1.-1027./3924,1:1.-867./2715,2:1.-1232./2350,3:1.-1049./2692,4:1.-753./2441,5:1.-1278./5065,6:1.-2167./3262}
tht2={0:0.,1:0.,2:0.,3:0.,4:0.,5:0.,6:0.}
tht3={0:0.,1:0.,2:0.,3:0.,4:0.,5:0.,6:0.}

X_tl=np.diag(np.ones(39))
resultnc=Dataset(path+'results_ss.nc','w')
resultnc.createDimension('latitude',580)
resultnc.createDimension('longitude',1440)
resultnc.createDimension('ninput',39)
resultnc.createDimension('noutput',45)

varlat=resultnc.createVariable('latitude','f',('latitude',))
varlat[:]=np.arange(89.875,-55.,-0.25)
varlat.units='degrees_north'
varlon=resultnc.createVariable('longitude','f',('longitude',))
varlon[:]=np.arange(-179.875,180.,0.25)
varlon.units='degrees_east'
varin=resultnc.createVariable('inputs','f',('ninput','latitude','longitude'))
varout=resultnc.createVariable('outputs','f',('noutput','latitude','longitude'))
varin_unc=resultnc.createVariable('inputs_unc','f',('ninput','latitude','longitude'))
varout_unc=resultnc.createVariable('outputs_unc','f',('noutput','latitude','longitude'))
varsen=resultnc.createVariable('sensitivity','f',('noutput','ninput','latitude','longitude'))
varin[:]=-999.;varin.missing_value=-999.
varout[:]=-999.;varout.missing_value=-999.
varin_unc[:]=-999.;varin_unc.missing_value=-999.
varout_unc[:]=-999.;varout_unc.missing_value=-999.
varsen[:]=-999.;varsen.missing_value=-999.

for ii in range(49,580):  # loop through latitudes for land 
  for jj in range(1440):
    if Pw[ii,jj]>-1:Pw_pix=Pw[ii,jj]/1000.   # kg km-2 a-1 -> g m-2 a-1
    else:Pw_pix=0.                           # assign undefined value as 0.
    if NPP[ii,jj]>0:
      if PFT[ii,jj]<4:    # tree biomes
        X=np.array([GPP[ii,jj],AF_FOL[ii,jj],AF_ROOT[ii,jj],AF_WOOD[ii,jj],ETAC[ii,jj],\
                    RT_LEAF[ii,jj],RT_ROOT[ii,jj],RT_WOOD[ii,jj],\
                    RT_LITTER[ii,jj],RT_SOM[ii,jj],\
                    FRAC_Fire_LEAF[ii,jj],FRAC_Fire_ROOT[ii,jj],FRAC_Fire_WOOD[ii,jj],\
                    FRAC_Fire_LITTER[ii,jj],FRAC_Fire_SOM[ii,jj],\
                    s1[PFT[ii,jj]],s2[PFT[ii,jj]],s3[PFT[ii,jj]],\
                    s5[PFT[ii,jj]],\
                    eps1[PFT[ii,jj]],eps2[PFT[ii,jj]],eps3[PFT[ii,jj]],\
                    Nd[ii,jj],Nfix[ii,jj],\
                    LeachingRatio[ii,jj],gfrac[ii,jj]/100.,\
                    l1[PFT[ii,jj]],l2[PFT[ii,jj]],l3[PFT[ii,jj]],\
                    l5[PFT[ii,jj]],\
                    tht1[PFT[ii,jj]],tht2[PFT[ii,jj]],tht3[PFT[ii,jj]],\
                    Pw_pix,Pd[ii,jj],Dissfrac[ii,jj],1./25.,NPP[ii,jj],0.75])
        # uncertainty (10% for variables whose uncertainties were not reported in original literature)
        B=np.diag([std_GPP[ii,jj],std_AF_FOL[ii,jj],std_AF_ROOT[ii,jj],std_AF_WOOD[ii,jj],std_ETAC[ii,jj],\
                   std_RT_LEAF[ii,jj],std_RT_ROOT[ii,jj],std_RT_WOOD[ii,jj],\
                   std_RT_LITTER[ii,jj],std_RT_SOM[ii,jj],\
                   std_FRAC_Fire_LEAF[ii,jj],std_FRAC_Fire_ROOT[ii,jj],std_FRAC_Fire_WOOD[ii,jj],\
                   std_FRAC_Fire_LITTER[ii,jj],std_FRAC_Fire_SOM[ii,jj]]\
                  +[0.1*X[i] for i in range(15,22)]\
                  +[Nd[ii,jj]*0.6]\
                  +[0.1*X[i] for i in range(23,34)]\
                  +[Pd[ii,jj]]+[Dissfrac_unc[ii,jj]]+[X[-3]*0.1]\
                  +[std_NPP[ii,jj],0.075])
        y,H,sigma=ss_Anal.tree(X,X_tl,B**2) # B**2: variances
        varin[:,ii,jj]=X
        varin_unc[:,ii,jj]=np.diag(B)
        varout[:,ii,jj]=y
        varout_unc[:,ii,jj]=np.sqrt(np.diag(sigma))
        varsen[:,:,ii,jj]=H
      else:               # grass biomes   
        X=np.array([GPP[ii,jj],AF_FOL[ii,jj]+AF_WOOD[ii,jj]/2.,AF_ROOT[ii,jj]+AF_WOOD[ii,jj]/2.,0.,\
                    ETAC[ii,jj],RT_LEAF[ii,jj],RT_ROOT[ii,jj],RT_WOOD[ii,jj],\
                    RT_LITTER[ii,jj],RT_SOM[ii,jj],\
                    FRAC_Fire_LEAF[ii,jj],FRAC_Fire_ROOT[ii,jj],FRAC_Fire_WOOD[ii,jj],\
                    FRAC_Fire_LITTER[ii,jj],FRAC_Fire_SOM[ii,jj],\
                    s1[PFT[ii,jj]],s2[PFT[ii,jj]],s3[PFT[ii,jj]],\
                    s5[PFT[ii,jj]],\
                    eps1[PFT[ii,jj]],eps2[PFT[ii,jj]],eps3[PFT[ii,jj]],\
                    Nd[ii,jj],Nfix[ii,jj],\
                    LeachingRatio[ii,jj],gfrac[ii,jj]/100.,\
                    l1[PFT[ii,jj]],l2[PFT[ii,jj]],l3[PFT[ii,jj]],\
                    l5[PFT[ii,jj]],\
                    tht1[PFT[ii,jj]],tht2[PFT[ii,jj]],tht3[PFT[ii,jj]],\
                    Pw_pix,Pd[ii,jj],Dissfrac[ii,jj],1./25.,NPP[ii,jj],0.75])
        # uncertainty (10% for variables whose uncertainties were not reported in original literature)
        B=np.diag([std_GPP[ii,jj],np.sqrt(std_AF_FOL[ii,jj]**2+std_AF_WOOD[ii,jj]**2/4.),\
                   np.sqrt(std_AF_ROOT[ii,jj]**2+std_AF_WOOD[ii,jj]**2/4.),0.,std_ETAC[ii,jj],\
                   std_RT_LEAF[ii,jj],std_RT_ROOT[ii,jj],std_RT_WOOD[ii,jj],\
                   std_RT_LITTER[ii,jj],std_RT_SOM[ii,jj],\
                   std_FRAC_Fire_LEAF[ii,jj],std_FRAC_Fire_ROOT[ii,jj],std_FRAC_Fire_WOOD[ii,jj],\
                   std_FRAC_Fire_LITTER[ii,jj],std_FRAC_Fire_SOM[ii,jj]]\
                  +[0.1*X[i] for i in range(15,22)]\
                  +[Nd[ii,jj]*0.6]\
                  +[0.1*X[i] for i in range(23,34)]\
                  +[Pd[ii,jj]]+[Dissfrac_unc[ii,jj]]+[X[-3]*0.1]\
                  +[std_NPP[ii,jj],0.075])
        y,H,sigma=ss_Anal.grass(X,X_tl,B**2) # B**2: variances
        varin[:,ii,jj]=X
        varin_unc[:,ii,jj]=np.diag(B)
        varout[:,ii,jj]=y
        varout_unc[:,ii,jj]=np.sqrt(np.diag(sigma))
        varsen[:,:,ii,jj]=H
resultnc.close()
