!
! FA/lfi 2 GRIB translation table
!
! TYPE trans
!         CHARACTER(LEN=clen) :: full_name =' '       ! Full FA/lfi name
!         CHARACTER(LEN=clen) :: cpar =' '            ! FA prefix for fanion
!         CHARACTER(LEN=clen) :: ctyp =' '            ! FA suffix for fanion
!         INTEGER(KIND=jpim)             :: flev = 1  ! FA level  for fanion
!         INTEGER(KIND=jpim)             :: tab = 0   ! GRIB table
!         INTEGER(KIND=jpim)             :: par = 0   ! GRIB parameter
!         INTEGER(KIND=jpim)             :: lev = 0   ! GRIB level
!         INTEGER(KIND=jpim)             :: typ = 0   ! GRIB type
!         CHARACTER(LEN=full_name_len)   :: txt =' '  ! Description
!         CHARACTER(LEN=clen)            :: unit =' ' ! Unit
! END TYPE trans
!
! NB Grib definitions may be duplicated !
!  glkind, only: jpim,jprb
! Use 'gl -q to check'
! Use 'gl -t to print table'
! Use 'gl -tp to print all used GRIB table 2 versions'
! For  FA conversion search from top
! For lfi conversion search from bottom
!

!
! Surface
!

! INT

i = i + 1
trans_tab( i ) = trans('INTSURFGEOPOTENT','INT' ,'SURFGEOPOTENT',1,253,6,0,105,0,'Interpolated geopotential',geop)

! SPEC

i = i + 1
trans_tab( i ) = trans('SPECSURFGEOPOTEN','SPEC','SURFGEOPOTEN' ,1,253,6,0,105,0,'Geopotential',geop)

! PROF

i = i + 1
trans_tab( i ) = trans('PROFTEMPERATURE','PROF','TEMPERATURE'   ,1,253,085, 0,112,0,'Deep soil temperature',temp)
i = i + 1
trans_tab( i ) = trans('PROFRESERV.EAU' ,'PROF','RESERV.EAU'    ,1,253,086, 0,112,0,'Deep soil wetness',water)
i = i + 1
trans_tab( i ) = trans('PROFRESERV.GLACE','PROF','RESERV.GLACE' ,1,253,193 ,0,112,0,'Deep soil ice',water)
i = i + 1
trans_tab( i ) = trans('PROFPROP.RMAX.EA','PROF','PROP.RMAX.EA' ,1,253,238 ,0,112,0,'Climate relaxed deep soil wetness',water)

! SURF

i = i + 1
trans_tab( i ) = trans('SURFGEOPOTENTIEL','SURF','GEOPOTENTIEL' ,1,253,6,0,105,0,'Output geopotential',geop)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.NEIGE','SURF','RESERV.NEIGE' ,1,253,65,0,105,0,'Snow depth water eqiv.',water)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.EAU',  'SURF','RESERV.EAU',1,253,086,0,105,0,'Surface soil wetness',water)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.INTER','SURF','RESERV.INTER',1,253,192 ,0,105,0,&
                       'Water on canopy (Interception content)',water)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.GLACE','SURF','RESERV.GLACE',1,253,193 ,0,105,0,'Surface soil ice',water)
i = i + 1
trans_tab( i ) = trans('SURFALBEDO NEIGE','SURF','ALBEDO NEIGE',1,253,190,000,105,0,'Snow Albedo',water)
i = i + 1
trans_tab( i ) = trans('SURFIND.TERREMER','SURF','IND.TERREMER',1,253,81,0,105,0,'Fraction of land',frac)
i = i + 1
trans_tab( i ) = trans('SURFZ0.FOIS.G'   ,'SURF','Z0.FOIS.G',1,253,83,0,105,0,'Surface roughness x g',hgt)
i = i + 1
trans_tab( i ) = trans('SURFALBEDO','SURF','ALBEDO',1,253,84,0,105,0,'Albedo  ',frac)
i = i + 1
trans_tab( i ) = trans('SURFPROP.VEGETAT','SURF','PROP.VEGETAT',1,253,87,0,105,0,'Fraction of vegetation',frac)
i = i + 1
trans_tab( i ) = trans('SURFTEMPERATURE','SURF','TEMPERATURE',1,253,11,0,105,0,'Surface temperature',temp)
i = i + 1
trans_tab( i ) = trans('SURFPRESSION','SURF','PRESSION',1,253,1,0,105,0,'Surface pressure',pres)
i = i + 1
trans_tab( i ) = trans('SURFISOTPW0.MALT','SURF','ISOTPW0.MALT',1,253,8,0,5,0,'Altitude of iso-tprimw=0',hgt)
i = i + 1
trans_tab( i ) = trans('SURFTOT.WAT.VAPO','SURF','TOT.WAT.VAPO',1,253,054,0,200,0,'Precipitable water',water)
i = i + 1
trans_tab( i ) = trans('SURFFL.COND.L.GE','SURF','FL.COND.L.GE',1,253,62,0,105,0,'Stratiform precipitation flux','')
i = i + 1
trans_tab( i ) = trans('SURFFL.COND.L.CO','SURF','FL.COND.L.CO',1,253,63,0,105,0,'Convective precipitation flux','')
i = i + 1
trans_tab( i ) = trans('SURFFL.COND.N.CO','SURF','FL.COND.N.CO',1,253,78,0,105,0,'Convective snow flux','')
i = i + 1
trans_tab( i ) = trans('SURFFL.COND.N.GE','SURF','FL.COND.N.GE',1,253,79,0,105,0,'Stratiform snow flux','')
i = i + 1
trans_tab( i ) = trans('SURFPREC.EAU.CON','SURF','PREC.EAU.CON',1,253,183,0,105,4,'Accumulated convective rain',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.NEI.CON','SURF','PREC.NEI.CON',1,253,78,0,105,4,'Accumulated convective snow',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.GRA.CON','SURF','PREC.GRA.CON',1,253,203,0,105,4,'Accumulated convective graupel',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.GRE.CON','SURF','PREC.GRE.CON',1,253,206,0,105,4,'Accumulated convective hail',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.EAU.GEC','SURF','PREC.EAU.GEC',1,253,182,0,105,4,'Accumulated stratiform rain',water)
i = i + 1
trans_tab( i ) = trans('SURFINSPLUIE'    ,'SURF','INSPLUIE'    ,1,253,181,0,105,0,'Instantaneous rain',water)
i = i + 1
trans_tab( i ) = trans('SURFINSNEIGE'    ,'SURF','INSNEIGE'    ,1,253,184,0,105,0,'Instantaneous snow',water)
i = i + 1
trans_tab( i ) = trans('SURFINSGRAUPEL'  ,'SURF','INSGRAUPEL'  ,1,253,201,0,105,0,'Instantaneous graupel',water)
i = i + 1
trans_tab( i ) = trans('SURFACCPLUIE'    ,'SURF','ACCPLUIE'    ,1,253,181,0,105,4,'Accumulated rain',water)
i = i + 1
trans_tab( i ) = trans('SURFACCNEIGE'    ,'SURF','ACCNEIGE'    ,1,253,184,0,105,4,'Accumulated snow',water)
i = i + 1
trans_tab( i ) = trans('SURFACCGRAUPEL'  ,'SURF','ACCGRAUPEL'  ,1,253,201,0,105,4,'Accumulated graupel',water)
i = i + 1
trans_tab( i ) = trans('SURFACCHAIL'     ,'SURF','ACCHAIL'     ,1,253,204,0,105,4,'Accumulated hail',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.NEI.GEC','SURF','PREC.NEI.GEC',1,253,79,0,105,4,'Stratiform Snow',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.GRA.GEC','SURF','PREC.GRA.GEC',1,253,201,0,105,4,'Stratiform Graupel',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.GRE.GEC','SURF','PREC.GRE.GEC',1,253,205,0,105,4,'Stratiform Hail',water)
!!!i = i + 1
!!!trans_tab( i ) = trans('ATMONEBUL.TOTALE','SURF','NEBUL.TOTALE',1,253,71,0,105,4,'Accumulated Total Cloud','')
!!!i = i + 1
!!!trans_tab( i ) = trans('ATMONEBUL.CONVEC','SURF','NEBUL.CONVEC',1,253,72,0,105,4,'Accumulated Convetive Cloud','')
!!!i = i + 1
!!!trans_tab( i ) = trans('ATMONEBUL.BASSE' ,'SURF','NEBUL.BASSE' ,1,253,73,0,105,4,'Accumulated Low Cloud','')
!!!i = i + 1
!!!trans_tab( i ) = trans('ATMONEBUL.MOYENN','SURF','NEBUL.MOYENN',1,253,74,0,105,4,'Accumulated Mid Cloud','')
!!!i = i + 1
!!!trans_tab( i ) = trans('ATMONEBUL.HAUTE' ,'SURF','NEBUL.HAUTE',1,253,75,0,105,4,'Accumulated High Cloud','')
i = i + 1
trans_tab( i ) = trans('SURFNEBUL.TOTALE','SURF','NEBUL.TOTALE',1,253,71,0,105,0,'Total Cloud',frac)
i = i + 1
trans_tab( i ) = trans('SURFNEBUL.CONVEC','SURF','NEBUL.CONVEC',1,253,72,0,105,0,'Convetive Cloud',frac)
i = i + 1
trans_tab( i ) = trans('SURFNEBUL.BASSE' ,'SURF','NEBUL.BASSE' ,1,253,73,0,105,0,'Low Cloud',frac)
i = i + 1
trans_tab( i ) = trans('SURFNEBUL.MOYENN','SURF','NEBUL.MOYENN',1,253,74,0,105,0,'Mid Cloud',frac)
i = i + 1
trans_tab( i ) = trans('SURFNEBUL.HAUTE' ,'SURF','NEBUL.HAUTE',1,253,75,0,105,0,'High Cloud',frac)
i = i + 1
trans_tab( i ) = trans('SURFCAPE.MOD.XFU','SURF','CAPE.MOD.XFU',1,253,160,0,105,0,'CAPE',j_kg_1)
i = i + 1
trans_tab( i ) = trans('SURFCAPE.POS.F00','SURF','CAPE.POS.F00',1,253,160,0,105,0,'CAPE',j_kg_1)
i = i + 1
trans_tab( i ) = trans('SURFDIAGHAIL','SURF','DIAGHAIL',1,253,161,0,105,0,'Hail diagnostic',frac)
i = i + 1
trans_tab( i ) = trans('SURFFLU.RAY.SOLA','SURF','FLU.RAY.SOLA',1,253,111,0,105,4,'Surface SW net radiation',energy)
i = i + 1
trans_tab( i ) = trans('SURFFLU.RAY.THER','SURF','FLU.RAY.THER',1,253,112,0,105,4,'Surface LW net radiation',energy)
i = i + 1
trans_tab( i ) = trans('SURFRAYT THER DE','SURF','RAYT THER DE',1,253,115,0,105,4,'Surface LW down radiation',energy)
i = i + 1
trans_tab( i ) = trans('SURFRAYT DIR SUR','SURF','RAYT DIR SUR',1,253,116,0,105,4,'Surface SW direct radiation',energy)
i = i + 1
trans_tab( i ) = trans('SURFRAYT SOLA DE','SURF','RAYT SOLA DE',1,253,117,0,105,4,'Surface SW global radiation',energy)
i = i + 1
trans_tab( i ) = trans('SURFRAYT.LUNE.DE','SURF','RAYT.LUNE.DE',1,253,158,0,105,4,'Surface downward moon radiation',energy)
i = i + 1
trans_tab( i ) = trans('SURFRAYT.TERREST','SURF','RAYT.TERREST',1,253,115,0,105,0,'Surface Instantaneous thermal radiation',effect)
i = i + 1
trans_tab( i ) = trans('SURFDIR NORM IRR','SURF','DIR NORM IRR',1,253,140,0,105,4,'Surface direct normal irradiance',energy)
i = i + 1
trans_tab( i ) = trans('SURFRAYT.SOLAIRE','SURF','RAYT.SOLAIRE',1,253,116,0,105,0,'Surface Instantaneous solar radiation',effect)
i = i + 1
trans_tab( i ) = trans('SURFETA.GEOPOTEN','SURF','ETA.GEOPOTEN',1,253,128,0,105,0,'Analysed RMS of PHI (CANARI)',geop)
i = i + 1
trans_tab( i ) = trans('SURFETP.GEOPOTEN','SURF','ETP.GEOPOTEN',1,253,129,0,105,0,'Forecasted RMS of PHI (CANARI)',geop)
i = i + 1
trans_tab( i ) = trans('SURFFLU.CHA.SENS','SURF','FLU.CHA.SENS',1,253,122,0,105,4,'Sensible heat flux',energy)
i = i + 1
trans_tab( i ) = trans('SURFFLU.LAT.MEVA','SURF','FLU.LAT.MEVA',1,253,132,0,105,4,'Latent heat evaporation',energy)
i = i + 1
trans_tab( i ) = trans('SURFCHAL LATENTE','SURF','CHAL LATENTE',1,253,121,0,105,4,'Latent heat flux',energy)
i = i + 1
trans_tab( i ) = trans('SURFFLU.LAT.MSUB','SURF','FLU.LAT.MSUB',1,253,244,0,105,4,'Latent Heat Sublimation',energy)
i = i + 1
trans_tab( i ) = trans('SURFFLU.MEVAP.EA','SURF','FLU.MEVAP.EA',1,253,245,0,105,4,'Water evaporation',energy)
i = i + 1
trans_tab( i ) = trans('SURFFLU.MSUBL.NE','SURF','FLU.MSUBL.NE',1,253,246,0,105,4,'Snow sublimation',energy)
i = i + 1
trans_tab( i ) = trans('SURFTENS.DMOG.ZO','SURF','TENS.DMOG.ZO',1,253,195,0,105,4,'Gravity Wave Stress U-comp',kg_m_1_s_1)
i = i + 1
trans_tab( i ) = trans('SURFTENS.TURB.ZO','SURF','TENS.TURB.ZO',1,253,125,0,105,4,'Momentum flux V-comp',kg_m_1_s_1)
i = i + 1
trans_tab( i ) = trans('SURFTENS.DMOG.ME','SURF','TENS.DMOG.ME',1,253,196,0,105,4,'Gravity Wave Stress V-comp',kg_m_1_s_1)
i = i + 1
trans_tab( i ) = trans('SURFTENS.TURB.ME','SURF','TENS.TURB.ME',1,253,124,0,105,4,'Momentum flux U-comp',kg_m_1_s_1)
i = i + 1
trans_tab( i ) = trans('SURFTC03','SURF','TC03',1,159, 10,0,1,0,'','')
i = i + 1
trans_tab( i ) = trans('SURFNO_TOT','SURF','NO_TOT',1,159, 22,0,1,0,'','')
i = i + 1
trans_tab( i ) = trans('SURFNO2_TOT','SURF','NO2_TOT',1,159, 23,0,1,0,'','')
i = i + 1
trans_tab( i ) = trans('SURFCO_TOT','SURF','CO_TOT',1,159, 24,0,1,0,'','')
i = i + 1
trans_tab( i ) = trans('SURFCH4_TOT','SURF','CH4_TOT',1,159, 21 ,0,1,0,'','')
i = i + 1
trans_tab( i ) = trans('SURFET.GEOPOTENT','SURF','ET.GEOPOTENT',1,253,220,0,105,0,'Standard deviation of orography * g',j_kg_1)
i = i + 1
trans_tab( i ) = trans('SURFVAR.GEOP.ANI','SURF','VAR.GEOP.ANI',1,253,221,0,105,0,'Anisotropy coeff of topography','')
i = i + 1
trans_tab( i ) = trans('SURFVAR.GEOP.DIR','SURF','VAR.GEOP.DIR',1,253,222,0,105,0,'Direction of main axis of topography',rad)
i = i + 1
trans_tab( i ) = trans('SURFZ0REL.FOIS.G','SURF','Z0REL.FOIS.G',1,253,223,0,105,0,'Roughness length of bare surface * g',geop)
i = i + 1
trans_tab( i ) = trans('SURFZ0VEG.FOIS.G','SURF','Z0VEG.FOIS.G',1,253,224,0,105,0,'Roughness length for vegetation * g',geop)
i = i + 1
trans_tab( i ) = trans('SURFPROP.TERRE','SURF','PROP.TERRE',1,253,81,0,105,0,'Fr. Land',frac)
i = i + 1
trans_tab( i ) = trans('SURFPROP.URBANIS','SURF','PROP.URBANIS',1,253,188,0,105,0,'Fraction of urban land',frac)
i = i + 1
trans_tab( i ) = trans('SURFPROP.ARGILE','SURF','PROP.ARGILE',1,253,225,0,112,0,'Fraction of clay within soil',frac)
i = i + 1
trans_tab( i ) = trans('SURFPROP.SABLE','SURF','PROP.SABLE',1,253,226,0,112,0,'Fraction of sand within soil',frac)
i = i + 1
trans_tab( i ) = trans('SURFPROP.VEG.MAX','SURF','PROP.VEG.MAX',1,253,227,0,105,0,'Maximum proportion of vegetation','')
i = i + 1
trans_tab( i ) = trans('SURFALBEDO.COMPL','SURF','ALBEDO.COMPL',1,253,219,0,105,0,'Surface albedo for non snow covered areas',frac)
i = i + 1
trans_tab( i ) = trans('SURFALBEDO.SOLNU','SURF','ALBEDO.SOLNU',1,253,229,0,105,0,'Albedo of bare ground',frac)
i = i + 1
trans_tab( i ) = trans('SURFALBEDO.VEG','SURF','ALBEDO.VEG',1,253,230,0,105,0,'Albedo of vegetation',frac)
i = i + 1
trans_tab( i ) = trans('SURFIND.VEG.DOMI','SURF','IND.VEG.DOMI',1,253,231,0,105,0,'Stomata minimal resistance',s_m)
i = i + 1
trans_tab( i ) = trans('SURFIND.FOLIAIRE','SURF','IND.FOLIAIRE',1,253,232,0,105,0,'Leaf area index',m2_m_2)
i = i + 1
trans_tab( i ) = trans('SURFRESI.STO.MIN','SURF','RESI.STO.MIN',1,253,234,0,105,0,'Dominant vegetation index','')
i = i + 1
trans_tab( i ) = trans('SURFEMISSIVITE','SURF','EMISSIVITE',1,253,235,0,105,0,'Surface emissivity','')
i = i + 1
trans_tab( i ) = trans('SURFEPAI.SOL.MAX','SURF','EPAI.SOL.MAX',1,253,236,0,105,0,'Maximum soil depth',hgt)
i = i + 1
trans_tab( i ) = trans('SURFEPAIS.SOL','SURF','EPAIS.SOL',1,253,237,0,105,0,'Soil depth',hgt)
i = i + 1
trans_tab( i ) = trans('SURFPROP.RMAX.EA','SURF','PROP.RMAX.EA',1,253,238,0,105,0,'Deep soil wetness',water)
i = i + 1
trans_tab( i ) = trans('SURFGZ0.THERM','SURF','GZ0.THERM',1,253,239,0,105,0,'Thermal roughness length * g',geop)
i = i + 1
trans_tab( i ) = trans('SURFRES.EVAPOTRA','SURF','RES.EVAPOTRA',1,253,240,0,105,0,'Resistance to evapotransiration',s_m)
i = i + 1
trans_tab( i ) = trans('SURFTIME.PREC.TO','SURF','TIME.PREC.TO',1,253,243,0,105,4,'Duration of total precipitations',sec)
i = i + 1
trans_tab( i ) = trans('SURFDENSIT.NEIGE','SURF','DENSIT.NEIGE',1,253, 191,0,105,0,'Snow density',dens)
i = i + 1
trans_tab( i ) = trans('SURFALBEDO HISTO','SURF','ALBEDO HISTO',1,253, 247,0,105,0,'Snow history','')
i = i + 1
trans_tab( i ) = trans('SURFAEROS.SEA','SURF','AEROS.SEA',1,253, 251,0,105,0,'Surface aerosol sea','')
i = i + 1
trans_tab( i ) = trans('SURFAEROS.LAND','SURF','AEROS.LAND',1,253, 252,0,105,0,'Surface aerosol land','')
i = i + 1
trans_tab( i ) = trans('SURFAEROS.SOOT','SURF','AEROS.SOOT',1,253, 253,0,105,0,'Surface aerosol soot','')
i = i + 1
trans_tab( i ) = trans('SURFAEROS.DESERT','SURF','AEROS.DESERT',1,253, 254,0,105,0,'Surface aerosol desert','')
i = i + 1
trans_tab( i ) = trans('SURFA.OF.OZONE','SURF','A.OF.OZONE',1,253, 248,0,105,0,'SURFA OZONE','')
i = i + 1
trans_tab( i ) = trans('SURFB.OF.OZONE','SURF','B.OF.OZONE',1,253, 249,0,105,0,'SURFB OZONE','')
i = i + 1
trans_tab( i ) = trans('SURFC.OF.OZONE','SURF','C.OF.OZONE',1,253, 250,0,105,0,'SURFC OZONE','')
i = i + 1
trans_tab( i ) = trans('SEASURFTEMPERATU','SEA','SURFTEMPERATU',1,253, 011,0,102,0,'SST',temp)
i = i + 1
trans_tab( i ) = trans('MSLPRESSURE','MSL','PRESSURE',1,253,1,0,103,0,'MSLP',pres)

!
! Screen level parameters
!

i = i + 1
trans_tab( i ) = trans('CLSTEMPERATURE','CLS','TEMPERATURE',1,253,11,2,105,0,'T2m',temp)
i = i + 1
trans_tab( i ) = trans('CLSVENT.ZONAL','CLS','VENT.ZONAL',1,253,33,10,105,0,'U10m',m_s)
i = i + 1
trans_tab( i ) = trans('CLSVENT.MERIDIEN','CLS','VENT.MERIDIEN',1,253,34,10,105,0,'V10m',m_s)
i = i + 1
trans_tab( i ) = trans('CLSU.RAF.MOD.XFU','CLS','U.RAF.MOD.XFU',1,253,162,10,105,2,'Gust U-component',m_s)
i = i + 1
trans_tab( i ) = trans('CLSV.RAF.MOD.XFU','CLS','V.RAF.MOD.XFU',1,253,163,10,105,2,'Gust V-component',m_s)
i = i + 1
trans_tab( i ) = trans('CLSRAFALES.POS','CLS','RAFALES.POS',1,253,228,10,105,2,'gust wind speed',m_s)
i = i + 1
trans_tab( i ) = trans('CLSMINI.TEMPERAT','CLS','MINI.TEMPERAT',1,253,16,2,105,2,'Min Temp',temp)
i = i + 1
trans_tab( i ) = trans('CLSMAXI.TEMPERAT','CLS','MAXI.TEMPERAT',1,253,15,2,105,2,'Max Temp',temp)
i = i + 1
trans_tab( i ) = trans('CLSHUMI.RELATIVE','CLS','HUMI.RELATIVE',1,253,52,2,105,0,'RH2m',frac)
i = i + 1
trans_tab( i ) = trans('CLSHUMI.SPECIFIQ','CLS','HUMI.SPECIFIQ',1,253,51,2,105,0,'Q2m ',kg_kg_1)
i = i + 1
trans_tab( i ) = trans('CLSMINI.HUMI.REL','CLS','MINI.HUMI.REL',1,253,241,2,105,2,'Minimum relative moisture at 2 meters',frac)
i = i + 1
trans_tab( i ) = trans('CLSMAXI.HUMI.REL','CLS','MAXI.HUMI.REL',1,253,242,2,105,2,'Maximum relative moisture at 2 meters',frac)
i = i + 1
trans_tab( i ) = trans('CLPMHAUT.MOD.XFU','CLP','MHAUT.MOD.XFU',1,253,67,0,105,0, &
                       'Height (in meters) of the PBL',hgt)
i = i + 1
trans_tab( i ) = trans('CLPMOCON.MOD.XFU','CLP','MOCON.MOD.XFU',1,253,166,0,105,0,'MOCON',kg_kg_s_1)
i = i + 1
trans_tab( i ) = trans('CLSWIND.VELOCITY','CLS','WIND.VELOCITY',1,253,32,10,105,0,'WinSpeed10m',m_s)

!
! Altitude of X-deegree isotherm, level type 20
!

i = i + 1
trans_tab( i ) = trans('KT273ISOT_ALTIT','KT273','ISOT_ALTIT',1,253,8,27315,020,0,'Altitude of 0-degree isotherm',hgt)
i = i + 1
trans_tab( i ) = trans('KT263ISOT_ALTIT','KT263','ISOT_ALTIT',1,253,8,26315,020,0,'Altitude of -10-degree isotherm',hgt)
i = i + 1
trans_tab( i ) = trans('KT253ISOT_ALTIT','KT253','ISOT_ALTIT',1,253,8,25315,020,0,'Altitude of -20-degree isotherm',hgt)

!
! Top Of Atmosphere
!

i = i + 1
trans_tab( i ) = trans('SOMMFLU.RAY.SOLA','SOMM','FLU.RAY.SOLA',1,253,113,0,008,4,'TOA SW net radiation',energy)
i = i + 1
trans_tab( i ) = trans('SOMMFLU.RAY.THER','SOMM','FLU.RAY.THER',1,253,114,0,008,4,'TOA LW net radiation',energy)
i = i + 1
trans_tab( i ) = trans('TOPRAYT DIR SOM' ,'TOP','RAYT DIR SOM' ,1,253,116,0,008,4,'TOA SW direct radiation',energy)
i = i + 1
trans_tab( i ) = trans('SOMMRAYT.SOLAIRE','SOMM','RAYT.SOLAIRE',1,253,113,0,008,0,'TOA Instantaneous SW radiation',effect)
i = i + 1
trans_tab( i ) = trans('SOMMRAYT.TERREST','SOMM','RAYT.TERREST',1,253,114,0,008,0,'TOA Instantaneous LW radiation',effect)
i = i + 1
trans_tab( i ) = trans('SOMMTB_OZ_CLEAR' ,'SOMM','TB_OZ_CLEAR' ,1,253,170,0,008,0,'Brightness temperature OZ clear',temp)
i = i + 1
trans_tab( i ) = trans('SOMMTB_OZ_CLOUD' ,'SOMM','TB_OZ_CLOUD' ,1,253,171,0,008,0,'Brightness temperature OZ cloud',temp)
i = i + 1
trans_tab( i ) = trans('SOMMTB_IR_CLEAR' ,'SOMM','TB_IR_CLEAR' ,1,253,172,0,008,0,'Brightness temperature IR clear',temp)
i = i + 1
trans_tab( i ) = trans('SOMMTB_IR_CLOUD' ,'SOMM','TB_IR_CLOUD' ,1,253,173,0,008,0,'Brightness temperature IR cloud',temp)
i = i + 1
trans_tab( i ) = trans('SOMMTB_WV_CLEAR' ,'SOMM','TB_WV_CLEAR' ,1,253,174,0,008,0,'Brightness temperature WV clear',temp)
i = i + 1
trans_tab( i ) = trans('SOMMTB_WV_CLOUD' ,'SOMM','TB_WV_CLOUD' ,1,253,175,0,008,0,'Brightness temperature WV cloud',temp)

!
! Model levels
!

i = i + 1
trans_tab( i ) = trans('SNNNTKE','S','TKE',1,253, 200,1,109,0,'TKE',geop)
i = i + 1
trans_tab( i ) = trans('SNNNGRAUPEL','S','GRAUPEL',1,253,201,1,109,0,'Graupel',water)
i = i + 1
trans_tab( i ) = trans('SNNNRAIN','S','RAIN',1,253,181,1,109,0,'Rain',water)
i = i + 1
trans_tab( i ) = trans('SNNNSNOW'        ,'S','SNOW',        1,253,184,1,109,0,'Snow',water)
i = i + 1
trans_tab( i ) = trans('SNNNCLOUD_FRACTI','S','CLOUD_FRACTI',1,253,71,1,109,0,'Cloud fraction',frac)
i = i + 1
trans_tab( i ) = trans('SNNN CLOUD_FRACT','S',' CLOUD_FRACT',1,253,71,1,109,0,'Cloud fraction',frac)
i = i + 1
trans_tab( i ) = trans('SNNN CLOUD FRACT','S',' CLOUD FRACT',1,253,71,1,109,0,'Cloud fraction',frac)
i = i + 1
trans_tab( i ) = trans('SNNNNEBULOSI.TOT','S','NEBULOSI.TOT',1,253,71,1,109,0,'Cloud fraction',frac)
i = i + 1
trans_tab( i ) = trans('SNNNNEBULOSI.XFU','S','NEBULOSI.XFU',1,253,71,1,109,0,'Cloud fraction',frac)
i = i + 1
trans_tab( i ) = trans('SNNNSOLID_WATER','S','SOLID_WATER'  ,1,253, 058,1,109,0,'Cloud ice',water)
i = i + 1
trans_tab( i ) = trans('SNNNICE_CRYSTAL','S','ICE_CRYSTAL'  ,1,253, 058,1,109,0,'Cloud ice',water)
i = i + 1
trans_tab( i ) = trans('SNNNFONC.COURANT','S','FONC.COURANT',1,253,35,1,109,0,'Stream function',m2_s_1)
i = i + 1
trans_tab( i ) = trans('SNNNPOT.VITESSE','S','POT.VITESSE',1,253,36,1,109,0,'Velocity potential',m2_s_1)
i = i + 1
trans_tab( i ) = trans('SNNNPRESSURE'    ,'S','PRESSURE'    ,1,253, 1,1,109,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('SNNNGEOPOTENTIEL','S','GEOPOTENTIEL',1,253, 6,1,109,0,'Geopotential',geop)
i = i + 1
trans_tab( i ) = trans('SNNNTEMPERATURE' ,'S','TEMPERATURE' ,1,253,11,1,109,0,'Temperature   ',temp)
i = i + 1
trans_tab( i ) = trans('SNNNTEMPE_POTENT' ,'S','TEMPE_POTENT',1,253,13,1,109,0,'Potential Temperature',temp)
i = i + 1
trans_tab( i ) = trans('SNNNHUMI.SPECIFI','S','HUMI.SPECIFI',1,253,51,1,109,0,'Specific Humidity ',kg_kg_1)
i = i + 1
trans_tab( i ) = trans('SNNNHUMI_RELATIV','S','HUMI_RELATIV',1,253,52,1,109,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('SNNNHUMI_RELAT'  ,'S','HUMI_RELAT'  ,1,253,52,1,109,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('SNNNWIND.U.PHYS' ,'S','WIND.U.PHYS' ,1,253,33,1,109,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNWIND.V.PHYS' ,'S','WIND.V.PHYS' ,1,253,34,1,109,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNVENT_ZONAL'  ,'S','VENT_ZONAL'  ,1,253,33,1,109,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNVENT_MERIDIE','S','VENT_MERIDIE',1,253,34,1,109,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNVITESSE_VERT','S','VITESSE_VERT',1,253,39,1,109,0,'Press. coord. Vertical Velocity',pa_s_1)
i = i + 1
trans_tab( i ) = trans('SNNNVERT.VELOCIT','S','VERT.VELOCIT',1,253,40,1,109,0,'Vertical Velocity',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNVORTICITY'   ,'S','VORTICITY'   ,1,253,43,1,109,0,'Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('SNNNDIVERGENCE'  ,'S','DIVERGENCE'  ,1,253,44,1,109,0,'Divergence',pers)
i = i + 1
trans_tab( i ) = trans('SNNNPRESS.DEPART','S','PRESS.DEPART',1,253,212,1,109,0,'Pressure departure',pres)
i = i + 1
trans_tab( i ) = trans('SNNNVERTIC.DIVER','S','VERTIC.DIVER',1,253,213,1,109,0,'Vertical Divergence',pers)
i = i + 1
trans_tab( i ) = trans('SNNNO3'          ,'S','O3'          ,1,159, 1,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNNO2','S','NO2',1,159, 2,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNNO','S','NO',1,159, 3,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNPAN','S','PAN',1,159, 4,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNHNO3','S','HNO3',1,159, 5,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNSO2','S','SO2',1,159, 6,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNCO','S','CO',1,159, 7,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNCH4','S','CH4',1,159, 8,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNC2H6','S','C2H6',1,159, 9,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNNC4H10','S','NC4H10',1,159, 10,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNC2H4','S','C2H4',1,159, 11,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNC3H6','S','C3H6',1,159, 12,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNOXYL','S','OXYL',1,159, 13,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNC5H8','S','C5H8',1,159, 14,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNAPINEN','S','APINEN',1,159, 15,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNHCHO','S','HCHO',1,159, 16,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNCH3CHO','S','CH3CHO',1,159, 17,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNGLYOX','S','GLYOX',1,159, 18,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNMGLYOX','S','MGLYOX',1,159, 19,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNCH3COE','S','CH3COE',1,159 , 20,1,109,0,'','')
i = i + 1
trans_tab( i ) = trans('SNNNLIQUID_WATER','S','LIQUID_WATER',1,253,076,1,109,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('SNNNCLOUD_WATER' ,'S','CLOUD_WATER' ,1,253,076,1,109,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('SNNNUD_OMEGA'    ,'S','UD_OMEGA'    ,1,253,214,1,109,0,'Updraft omega',frac)
i = i + 1
trans_tab( i ) = trans('SNNNDD_OMEGA'    ,'S','DD_OMEGA'    ,1,253,215,1,109,0,'Downdraft omega',frac)
i = i + 1
trans_tab( i ) = trans('SNNNUD_MESH_FRAC','S','UD_MESH_FRAC',1,253,216,1,109,0,'Updraft frac',frac)
i = i + 1
trans_tab( i ) = trans('SNNNDD_MESH_FRAC','S','DD_MESH_FRAC',1,253,217,1,109,0,'Updraft frac',frac)
i = i + 1
trans_tab( i ) = trans('SNNNPSHI_CONV_CL','S','PSHI_CONV_CL',1,253,218,1,109,0,'PSHI_CONV_CL frac',frac)
i = i + 1
trans_tab( i ) = trans('SNNNSIM_REFLECTI','S','SIM_REFLECTI',1,253,210,1,109,0,'Sim reflec.',dbz)

!
! Semi model levels
!

i = i + 1
trans_tab( i ) = trans('SNNNRAYT SOL CL' ,'S','RAYT SOL CL' ,1,253,130,0,105,4,'Surface SW net clear sky rad',energy)
i = i + 1
trans_tab( i ) = trans('SNNNRAYT THER CL','S','RAYT THER CL',1,253,131,0,105,4,'Surface LW net clear sky rad',energy)
i = i + 1
trans_tab( i ) = trans('S001RAYT SOL CL' ,'S001','RAYT SOL CL' ,1,253,130,0,008,4,'TOA SW net clear sky rad',energy)
i = i + 1
trans_tab( i ) = trans('S001RAYT THER CL','S001','RAYT THER CL',1,253,131,0,008,4,'TOA LW net clear sky rad',energy)

!
! ICAO
!

i = i + 1
trans_tab( i ) = trans('ICAOTROP.PRESSUR','ICAO','TROP.PRESSUR',1,253,1,0,7,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('ICAOTROP.TEMPERA','ICAO','TROP.TEMPERA',1,253,11,0,7,0,'Temperature   ',temp)

i = i + 1
trans_tab( i ) = trans('RELATEMPERATURE','RELA','TEMPERATURE',1,253,11,0,200,0,'Temperature   ',temp)
i = i + 1
trans_tab( i ) = trans('RELAPROP.RMAX.EA','RELA','PROP.RMAX.EA',1,253,238,0,200,0,'Deep soil wetness',water)

i = i + 1
trans_tab( i ) = trans('JETPRESSURE','JET','PRESSURE',1,253,1,0,6,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('JETVENT_ZONAL','JET','VENT_ZONAL',1,253,33,0,6,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('JETVENT_MERIDIEN','JET','VENT_MERIDIEN',1,253,34,0,6,0,'V-component ',m_s)


!
! Theta levels
!

i = i + 1
trans_tab( i ) = trans('TNNNGEOPOTENTIEL','T','GEOPOTENTIEL',1,253,6,1,113,0,'Geopotential',geop)
i = i + 1
trans_tab( i ) = trans('TNNNTEMPERATURE','T','TEMPERATURE',1,253,11,1,113,0,'Temperature   ',temp)
i = i + 1
trans_tab( i ) = trans('TNNNPRESSURE','T','PRESSURE',1,253,1,1,113,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('TNNNHUMI_RELATIV','T','HUMI_RELATIV',1,253,52,1,113,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('TNNNHUMI.SPECIFI','T','HUMI.SPECIFI',1,253,51,1,113,0,'Specific Humidity ',water)
i = i + 1
trans_tab( i ) = trans('TNNNWIND.U.PHYS','T','WIND.U.PHYS',1,253,33,1,113,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('TNNNWIND.V.PHYS','T','WIND.V.PHYS',1,253,34,1,113,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('TNNNVENT_ZONAL','T','VENT_ZONAL',1,253,33,1,113,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('TNNNVENT_MERIDIE','T','VENT_MERIDIE',1,253,34,1,113,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('TNNNVITESSE_VERT','T','VITESSE_VERT',1,253,39,1,113,0,'Vertical Velocity','Pa s-1')
i = i + 1
trans_tab( i ) = trans('TNNNVERT.VELOCIT','T','VERT.VELOCIT',1,253,40,1,113,0,'Vertical Velocity',m_s)
i = i + 1
trans_tab( i ) = trans('TNNNABS_VORTICIT','T','ABS_VORTICIT',1,253,41,1,113,0,'Absolute Vorticity ',pers)
i = i + 1
trans_tab( i ) = trans('TNNNPOT_VORTICIT','T','POT_VORTICIT',1,253,4,1,113,0,'Potential Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('TNNNDIVERGENCE','T','DIVERGENCE',1,253,44,1,113,0,'Divergence',pers)

!
! Derived quantities names
!

i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,20,0,105,0,'Visibility',hgt)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,31,10,105,0,'Wind direction screen level','Deg')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,61,0,105,4,'Total precipitation',water)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,185,0,105,4,'Total solid precipitation',water)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,133,0,200,0,'Mask of significant cloud amount','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,135,0,105,0,'Icing index','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,136,0,105,0,'Cloud top temperature (infrared)',temp)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,137,0,105,0,'Water vapour brightness temperature',temp)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,138,0,105,0,'Water vapour br. temp. + cloud corr.',temp)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,139,0,105,0,'Cloud water reflectivity (visible)','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,144,0,105,0,'Precipitation type','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,186,0,200,0,'Cloud base',hgt)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,187,0,200,0,'Cloud top',hgt)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,253,209,0,200,0,'Lightning intensity','')

!
! Pure HIRLAM names
!

i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,011,998,105,0,'Deep soil temperature',temp)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,086,998,105,0,'Deep soil moisture','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,071,1,109,0,'Total cloud cover','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,072,1,109,0,'Conv cloud cover','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,091,0,102,0,'Ice concentration','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,017,2,105,0,'Dew point',temp)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,117,0,8,0,'TOA total radiation','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,199,0,105,0,'Vegetation type','')
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,076,1,100,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('#',' ',' ',1,1,017,1,100,0,'Dew point',temp)

!
! Pressure levels
!

i = i + 1
trans_tab( i ) = trans('PNNNNNPOT_VORTIC','P','POT_VORTIC',1,253,  4,1,100,0,'Potential Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('PNNNNNGEOPOTENTI','P','GEOPOTENTI',1,253,  6,1,100,0,'Geopotential',temp)
i = i + 1
trans_tab( i ) = trans('PNNNNNTEMPERATUR','P','TEMPERATUR',1,253, 11,1,100,0,'Temperature',temp)
i = i + 1
trans_tab( i ) = trans('PNNNNNTEMPE_POTE','P','TEMPE_POTE',1,253, 13,1,100,0,'Potential Temperature',temp)
i = i + 1
trans_tab( i ) = trans('PNNNNNTHETA_PRIM','P','THETA_PRIM',1,253, 14,1,100,0,'EqP. Temperature',temp)
i = i + 1
trans_tab( i ) = trans('PNNNNNWIND_VELOC','P','WIND_VELOC',1,253, 32,1,100,0,'WinSpeed',m_s)
i = i + 1
trans_tab( i ) = trans('PNNNNNVENT_ZONAL','P','VENT_ZONAL',1,253, 33,1,100,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('PNNNNNWIND.U.PHY','P','WIND.U.PHY',1,253, 33,1,100,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('PNNNNNVENT_MERID','P','VENT_MERID',1,253, 34,1,100,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('PNNNNNWIND.V.PHY','P','WIND.V.PHY',1,253, 34,1,100,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('PNNNNNFONC.COURA','P','FONC.COURA',1,253, 35,1,100,0,'Stream function',pers)
i = i + 1
trans_tab( i ) = trans('PNNNNNPOT.VITESS','P','POT.VITESS',1,253, 36,1,100,0,'Velocity potential',m2_s_1)
i = i + 1
trans_tab( i ) = trans('PNNNNNVITESSE_VE','P','VITESSE_VE',1,253, 39,1,100,0,'Vertical Velocity',pa_s_1)
i = i + 1
trans_tab( i ) = trans('PNNNNNABS_VORTIC','P','ABS_VORTIC',1,253, 41,1,100,0,'Absolute Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('PNNNNNVORTICITY' ,'P','VORTICITY' ,1,253, 43,1,100,0,'Relative Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('PNNNNNDIVERGENCE','P','DIVERGENCE',1,253, 44,1,100,0,'Divergence',pers)
i = i + 1
trans_tab( i ) = trans('PNNNNNHUMI.SPECI','P','HUMI.SPECI',1,253, 51,1,100,0,'Specific Humidity ',kg_kg_1)
i = i + 1
trans_tab( i ) = trans('PNNNNNHUMI_RELAT','P','HUMI_RELAT',1,253, 52,1,100,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('PNNNNNICE_CRYSTA','P','ICE_CRYSTA',1,253, 58,1,100,0,'Cloud ice',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNCLOUD_WATE','P','CLOUD_WATE',1,253, 76,1,100,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNGRAUPEL'   ,'P','GRAUPEL'   ,1,253,201,1,100,0,'Graupel',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNSIM_REFLEC','P','SIM_REFLEC',1,253,210,1,100,0,'Simulated reflectivity',dbz)
i = i + 1
trans_tab( i ) = trans('PNNNNNSURFMOCON' ,'P','SURFMOCON' ,1,253,166,0,1,0,'MOCON',kg_kg_s_1)
i = i + 1
trans_tab( i ) = trans('PNNNNNO3','P','O3',1,159, 1,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNNO2','P','NO2',1,159, 2,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNNO','P','NO',1,159, 3,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNPAN','P','PAN',1,159, 4,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNHNO3','P','HNO3',1,159, 5,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNSO2','P','SO2',1,159, 6,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNCO','P','CO',1,159, 7,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNCH4','P','CH4',1,159, 8,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNC2H6','P','C2H6',1,159, 9,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNNC4H10','P','NC4H10',1,159, 10,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNC2H4','P','C2H4',1,159, 11,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNC3H6','P','C3H6',1,159, 12,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNOXYL','P','OXYL',1,159, 13,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNC5H8','P','C5H8',1,159, 14,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNAPINEN','P','APINEN',1,159, 15,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNHCHO','P','HCHO',1,159, 16,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNCH3CHO','P','CH3CHO',1,159, 17,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNGLYOX','P','GLYOX',1,159, 18,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNMGLYOX','P','MGLYOX',1,159, 19,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNCH3COE','P','CH3COE',1,159, 20,1,100,0,'','')
i = i + 1
trans_tab( i ) = trans('PNNNNNCLOUD_FRAC','P','CLOUD_FRAC',1,253,71,1,100,0,'Cloud fraction',frac)
i = i + 1
trans_tab( i ) = trans('PNNNNNVERT.VELOC','P','VERT.VELOC',1,253,40,1,100,0,'Vertical Velocity',m_s)
i = i + 1
trans_tab( i ) = trans('PNNNNNLIQUID_WAT','P','LIQUID_WAT',1,253,76,1,100,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNSOLID_WATE','P','SOLID_WATE',1,253,58,1,100,0,'Cloud ice',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNSNOW','P','SNOW',1,253,184,1,100,0,'Snow',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNRAIN','P','RAIN',1,253,181,1,100,0,'Rain',water)
i = i + 1
trans_tab( i ) = trans('PNNNNNTKE','P','TKE',1,253, 200,1,100,0,'TKE',geop)


!
! Height levels
!

i = i + 1
trans_tab( i ) = trans('HNNNNNPRESSURE','H','PRESSURE',1,253,1,1,105,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('HNNNNNTEMPERATUR','H','TEMPERATUR',1,253,11,1,105,0,'Temperature   ',temp)
i = i + 1
trans_tab( i ) = trans('HNNNNNHUMI_RELAT','H','HUMI_RELAT',1,253,52,1,105,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('HNNNNNHUMI.SPECI','H','HUMI.SPECI',1,253,51,1,105,0,'Specific Humidity ',kg_kg_1)
i = i + 1
trans_tab( i ) = trans('HNNNNNVENT_ZONAL','H','VENT_ZONAL',1,253,33,1,105,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('HNNNNNVENT_MERID','H','VENT_MERID',1,253,34,1,105,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('HNNNNNWIND.U.PHY','H','WIND.U.PHY',1,253,33,1,105,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('HNNNNNWIND.V.PHY','H','WIND.V.PHY',1,253,34,1,105,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('HNNNNNTHETA_PRIM','H','THETA_PRIM',1,253,14,1,105,0,'EqP. Temperature',temp)
i = i + 1
trans_tab( i ) = trans('HNNNNNTEMPE_POTE','H','TEMPE_POTE',1,253,13,1,105,0,'Potential Temperature',temp)
i = i + 1
trans_tab( i ) = trans('HNNNNNVERT.VELOC','H','VERT.VELOC',1,253,40,1,105,0,'Vertical Velocity',m_s)
i = i + 1
trans_tab( i ) = trans('HNNNNNPRESS.DEPA','H','PRESS.DEPA',1,253,212,1,105,0,'Pressure departure',pdep)
i = i + 1
trans_tab( i ) = trans('HNNNNNABS_VORTIC','H','ABS_VORTIC',1,253,41,1,105,0,'Absolute Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('HNNNNNPOT_VORTIC','H','POT_VORTIC',1,253,4,1,105,0,'Potential Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('HNNNNNDIVERGENCE','H','DIVERGENCE',1,253,44,1,105,0,'Divergence',pers)
i = i + 1
trans_tab( i ) = trans('HNNNNNVORTICITY','H','VORTICITY',1,253,43,1,105,0,'Relative Vorticity',pers)
i = i + 1
trans_tab( i ) = trans('HNNNNNFONC.COURA','H','FONC.COURA',1,253,35,1,105,0,'Stream function',pers)
i = i + 1
trans_tab( i ) = trans('HNNNNNPOT.VITESS','H','POT.VITESS',1,253,36,1,105,0,'Velocity potential','')
i = i + 1
trans_tab( i ) = trans('HNNNNNWIND_VELOC','H','WIND_VELOC',1,253,32,1,105,0,'WinSpeed',m_s)
i = i + 1
trans_tab( i ) = trans('HNNNNNGRAUPEL','H','GRAUPEL',1,253,201,1,105,0,'Graupel',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNSIM_REFLEC','H','SIM_REFLEC',1,253,210,1,105,0,'Simulated reflectivity',dbz)
i = i + 1
trans_tab( i ) = trans('HNNNNNRAIN','H','RAIN',1,253,181,1,105,0,'Rain',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNSNOW','H','SNOW',1,253,184,1,105,0,'Snow',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNSOLID_WATE','H','SOLID_WATE',1,253, 58,1,105,0,'Cloud ice',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNICE_CRYSTA','H','ICE_CRYSTA',1,253, 58,1,105,0,'Cloud ice',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNCLOUD_WATE','H','CLOUD_WATE',1,253, 76,1,105,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNLIQUID_WAT','H','LIQUID_WAT',1,253, 76,1,105,0,'Cloud water',water)
i = i + 1
trans_tab( i ) = trans('HNNNNNO3','H','O3',1,159, 1,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNNO2','H','NO2',1,159, 2,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNNO','H','NO',1,159, 3,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNPAN','H','PAN',1,159, 4,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNHNO3','H','HNO3',1,159, 5,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNSO2','H','SO2',1,159, 6,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNCO','H','CO',1,159, 7,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNCH4','H','CH4',1,159, 8,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNC2H6','H','C2H6',1,159, 9,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNNC4H10','H','NC4H10',1,159, 10,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNC2H4','H','C2H4',1,159, 11,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNC3H6','H','C3H6',1,159, 12,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNOXYL','H','OXYL',1,159, 13,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNC5H8','H','C5H8',1,159, 14,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNAPINEN','H','APINEN',1,159, 15,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNHCHO','H','HCHO',1,159, 16,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNCH3CHO','H','CH3CHO',1,159, 17,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNGLYOX','H','GLYOX',1,159, 18,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNMGLYOX','H','MGLYOX',1,159, 19,1,105,0,'','')
i = i + 1
trans_tab( i ) = trans('HNNNNNCH3COE','H','CH3COE',1,159, 20,1,105,0,'','')

!
! PV levels, NNN in deci-PVU, GRIB should be in milli-PVU; 1PVU=10^{-6}.K.m^{2}.{kg.s}^{-1}
! eg 2PVU <-> NNN=020 <-> GRIB LEVEL=2000
!

i = i + 1
trans_tab( i ) = trans('VNNNGEOPOTENTIEL','V','GEOPOTENTIEL',1,253,6,1,117,0,'Geopotential',geop)
i = i + 1
trans_tab( i ) = trans('VNNNTEMPERATURE','V','TEMPERATURE',1,253,11,1,117,0,'Temperature   ',temp)
i = i + 1
trans_tab( i ) = trans('VNNNPRESSURE','V','PRESSURE',1,253,1,1,117,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('VNNNHUMI_RELAT','V','HUMI_RELAT',1,253,52,1,117,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('VNNNHUMI_RELATIV','V','HUMI_RELATIV',1,253,52,1,117,0,'Relative Humidity',frac)
i = i + 1
trans_tab( i ) = trans('VNNNHUMI.SPECI','V','HUMI.SPECI',1,253,51,1,117,0,'Specific Humidity ',water)
i = i + 1
trans_tab( i ) = trans('VNNNHUMI.SPECIFI','V','HUMI.SPECIFI',1,253,51,1,117,0,'Specific Humidity ',water)
i = i + 1
trans_tab( i ) = trans('VNNNWIND.U.PHYS','V','WIND.U.PHYS',1,253,33,1,117,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('VNNNWIND.V.PHYS','V','WIND.V.PHYS',1,253,34,1,117,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('VNNNVENT_ZONAL','V','VENT_ZONAL',1,253,33,1,117,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('VNNNVENT_MERIDIE','V','VENT_MERIDIE',1,253,34,1,117,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('VNNNVITESSE_VERT','V','VITESSE_VERT',1,253,39,1,117,0,'Vertical Velocity',pa_s_1)
i = i + 1
trans_tab( i ) = trans('VNNNVERT.VELOCIT','V','VERT.VELOCIT',1,253,39,1,117,0,'Vertical Velocity',m_s)
i = i + 1
trans_tab( i ) = trans('VNNNTEMPE_POTENT','V','TEMPE_POTENT',1,253,13,1,117,0,'Potential Temperature',temp)
i = i + 1
trans_tab( i ) = trans('VNNNABS_VORTICIT','V','ABS_VORTICIT',1,253,41,1,117,0,'Absolute Vorticity ',pers)
i = i + 1
trans_tab( i ) = trans('VNNNDIVERGENCE','V','DIVERGENCE',1,253,44,1,117,0,'Divergence',pers)
i = i + 1
trans_tab( i ) = trans('VNNNTHETA_PRIM_W','V','THETA_PRIM_W',1,253,14,1,117,0,'EqP. Temperature',temp)
i = i + 1
trans_tab( i ) = trans('VNNNWIND_VELOC','V','WIND_VELOC',1,253,32,1,117,0,'WinSpeed',m_s)

!
! TABLE 128 (ECMWF) equivalents, used when converting ECMWF to FA
!

i = i + 1
trans_tab( i ) = trans('SPECSURFGEOPOTEN','SPEC','SURFGEOPOTEN',1,128,129,001,109,0,'Geopotential height',geop)
i = i + 1
trans_tab( i ) = trans('SURFPRESSION','SURF','PRESSION'        ,1,128,152,001,109,0,'Pressure',pres)
i = i + 1
trans_tab( i ) = trans('SURFTEMPERATURE','SURF','TEMPERATURE'  ,1,128,235,000,001,0,'Surface Temperature',temp)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.EAU','SURF','RESERV.EAU'    ,1,128,039,000,112,0,'Soil Wetness',water)
i = i + 1
trans_tab( i ) = trans('PROFTEMPERATURE','PROF','TEMPERATURE'  ,1,128,170,007,112,0,'Deep Temperature',temp)
i = i + 1
trans_tab( i ) = trans('PROFRESERV.EAU','PROF','RESERV.EAU'    ,1,128,040,007,112,0,'Deep Soil Wetness',water)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.INTER','SURF','RESERV.INTER',1,128,198,000,001,0,'Water on canopy',water)
i = i + 1
trans_tab( i ) = trans('SURFRESERV.NEIGE','SURF','RESERV.NEIGE',1,128,141,000,001,4,'Snow depth',water)
i = i + 1
trans_tab( i ) = trans('SURFALBEDO NEIGE','SURF','ALBEDO NEIGE',1,128,032,000,001,0,'Snow Albedo',frac)
i = i + 1
trans_tab( i ) = trans('SURFDENSIT.NEIGE','SURF','DENSIT.NEIGE',1,128,033,000,001,0,'Snow density',dens)
i = i + 1
trans_tab( i ) = trans('SURFSEA.TERREMER','SURF','IND.TERREMER'  ,1,128,172,000,001,0,'LSM',frac)
i = i + 1
trans_tab( i ) = trans('SURFSEA.ICECONC','SURF','SEA.ICECONC'  ,1,128,031,000,001,0,'SIC',frac)
i = i + 1
trans_tab( i ) = trans('SURFSEA.TEMPERA','SURF','SEA.TEMPERA'  ,1,128,034,000,001,0,'SST',temp)
i = i + 1
trans_tab( i ) = trans('SNNNTEMPERATURE','S','TEMPERATURE'     ,1,128,130,001,109,0,'Temperature',temp)
i = i + 1
trans_tab( i ) = trans('SNNNWIND.U.PHYS','S','WIND.U.PHYS'     ,1,128,131,001,109,0,'U-component ',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNWIND.V.PHYS','S','WIND.V.PHYS'     ,1,128,132,001,109,0,'V-component ',m_s)
i = i + 1
trans_tab( i ) = trans('SNNNHUMI.SPECIFI','S','HUMI.SPECIFI'   ,1,128,133,001,109,0,'Specific Humidity ',water)
i = i + 1
trans_tab( i ) = trans('SNNNLIQUID_WATER','S','LIQUID_WATER'   ,1,128,246,001,109,0,'Liquid water',water)
i = i + 1
trans_tab( i ) = trans('SNNNSOLID_WATER','S','SOLID_WATER'     ,1,128,247,001,109,0,'Solid water',water)
i = i + 1
trans_tab( i ) = trans('SNNNPRESS.DEPART','S','PRESS.DEPART'   ,1,128,212,001,109,0,'Pressure departure',pdep)
i = i + 1
trans_tab( i ) = trans('SNNNVERTIC.DIVER','S','VERTIC.DIVER'   ,1,128,213,001,109,0,'Vertical Divergence',pers)

! Screen level & Co
! 2 m
i = i + 1
trans_tab( i ) = trans('CLSTEMPERATURE','CLS','TEMPERATURE',1,128,167,000,001,0,'T2m',temp)
i = i + 1
trans_tab( i ) = trans('CLSHUMI.RELATIVE','CLS','HUMI.RELATIVE',1,128,168,000,001,0,'RH2m',frac)
! 10 m
i = i + 1
trans_tab( i ) = trans('CLSVENT.ZONAL','CLS','VENT.ZONAL',1,128,165,000,001,0,'U10m',m_s)
i = i + 1
trans_tab( i ) = trans('CLSVENT.MERIDIEN','CLS','VENT.MERIDIEN',1,128,166,000,001,0,'V10m',m_s)
!
i = i + 1
trans_tab( i ) = trans('SURFPREC.EAU.CON','SURF','PREC.EAU.CON',1,128,143,000,001,4,'Conective Precipitation',water)
i = i + 1
trans_tab( i ) = trans('SURFPREC.EAU.GEC','SURF','PREC.EAU.GEC',1,128,142,000,001,4,'Stratiform Precipitation',water)
!
i = i + 1
trans_tab( i ) = trans('SURFNEBUL.TOTALE','SURF','NEBUL.TOTALE',1,128,164,000,001,0,'TotCloud',frac)

!---------------------

!
! SURFEX
!

! Beginning of Ecoclimap

i = i + 1
trans_tab( i ) = trans('COVER001',' ',' ',1,001,001,000,113,0,'LAND SEA MASK','')
i = i + 1
trans_tab( i ) = trans('COVER002',' ',' ',1,001,002,000,113,0,'INLAND_WATERS','')
i = i + 1
trans_tab( i ) = trans('COVER003',' ',' ',1,001,003,000,113,0,'RIVERS','')
i = i + 1
trans_tab( i ) = trans('COVER004',' ',' ',1,001,004,000,113,0,'BARE_LAND','')
i = i + 1
trans_tab( i ) = trans('COVER005',' ',' ',1,001,005,000,113,0,'ROCKS','')
i = i + 1
trans_tab( i ) = trans('COVER006',' ',' ',1,001,006,000,113,0,'PERMANENT_SNOW','')
i = i + 1
trans_tab( i ) = trans('COVER007',' ',' ',1,001,007,000,113,0,'URBAN','')
i = i + 1
trans_tab( i ) = trans('COVER008',' ',' ',1,001,008,000,113,0,'TROPICAL_UNDEFINED','')
i = i + 1
trans_tab( i ) = trans('COVER009',' ',' ',1,001,009,000,113,0,'SUBPOLAR_UNDEFINED','')
i = i + 1
trans_tab( i ) = trans('COVER010',' ',' ',1,001,010,000,113,0,'PATAGONIA_CF','')
i = i + 1
trans_tab( i ) = trans('COVER011',' ',' ',1,001,011,000,113,0,'TAIGA','')
i = i + 1
trans_tab( i ) = trans('COVER012',' ',' ',1,001,012,000,113,0,'CHINESE_CF','')
i = i + 1
trans_tab( i ) = trans('COVER013',' ',' ',1,001,013,000,113,0,'AM_CONT_CF','')
i = i + 1
trans_tab( i ) = trans('COVER014',' ',' ',1,001,014,000,113,0,'SUBTROP_CF','')
i = i + 1
trans_tab( i ) = trans('COVER015',' ',' ',1,001,015,000,113,0,'RAIN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER016',' ',' ',1,001,016,000,113,0,'EQ_AFRICAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER017',' ',' ',1,001,017,000,113,0,'MADAGASCAR_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER018',' ',' ',1,001,018,000,113,0,'EQ_OCEANIAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER019',' ',' ',1,001,019,000,113,0,'MONSOON_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER020',' ',' ',1,001,020,000,113,0,'TROP_OCEANIAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER021',' ',' ',1,001,021,000,113,0,'AMAZONIAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER022',' ',' ',1,001,022,000,113,0,'NEW_ZEALAND_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER023',' ',' ',1,001,023,000,113,0,'PANAMERICAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER024',' ',' ',1,001,024,000,113,0,'DECIDUOUS_TAIGA','')
i = i + 1
trans_tab( i ) = trans('COVER025',' ',' ',1,001,025,000,113,0,'SUBAMAZONIAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER026',' ',' ',1,001,026,000,113,0,'AM_DECIDUOUS_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER027',' ',' ',1,001,027,000,113,0,'YUCATAN_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER028',' ',' ',1,001,028,000,113,0,'BRAZIL_TROP_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER029',' ',' ',1,001,029,000,113,0,'AF_DRY_MF','')
i = i + 1
trans_tab( i ) = trans('COVER030',' ',' ',1,001,030,000,113,0,'PATAGONIA_MF','')
i = i + 1
trans_tab( i ) = trans('COVER031',' ',' ',1,001,031,000,113,0,'SUBPOLAR_MF','')
i = i + 1
trans_tab( i ) = trans('COVER032',' ',' ',1,001,032,000,113,0,'SUBTROP_MF','')
i = i + 1
trans_tab( i ) = trans('COVER033',' ',' ',1,001,033,000,113,0,'CONT_MF','')
i = i + 1
trans_tab( i ) = trans('COVER034',' ',' ',1,001,034,000,113,0,'SAHELIAN_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER035',' ',' ',1,001,035,000,113,0,'MER_AF_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER036',' ',' ',1,001,036,000,113,0,'EVERGREEN_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER037',' ',' ',1,001,037,000,113,0,'EQ_OCEANIAN_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER038',' ',' ',1,001,038,000,113,0,'MONSOON_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER039',' ',' ',1,001,039,000,113,0,'CERRADAO','')
i = i + 1
trans_tab( i ) = trans('COVER040',' ',' ',1,001,040,000,113,0,'ARGENTINIAN_CERRADAO','')
i = i + 1
trans_tab( i ) = trans('COVER041',' ',' ',1,001,041,000,113,0,'POLAR_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER042',' ',' ',1,001,042,000,113,0,'CONTINENTAL_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER043',' ',' ',1,001,043,000,113,0,'CHINESE_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER044',' ',' ',1,001,044,000,113,0,'SEMI_ARID_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER045',' ',' ',1,001,045,000,113,0,'ROCKIES_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER046',' ',' ',1,001,046,000,113,0,'PATAGONIAN_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER047',' ',' ',1,001,047,000,113,0,'SOUTH_US_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER048',' ',' ',1,001,048,000,113,0,'SUB_SAHARA_WG','')
i = i + 1
trans_tab( i ) = trans('COVER049',' ',' ',1,001,049,000,113,0,'SAHELIAN_WG','')
i = i + 1
trans_tab( i ) = trans('COVER050',' ',' ',1,001,050,000,113,0,'EQ_AFRICAN_WG','')
i = i + 1
trans_tab( i ) = trans('COVER051',' ',' ',1,001,051,000,113,0,'SUBTROP_AF_WG','')
i = i + 1
trans_tab( i ) = trans('COVER052',' ',' ',1,001,052,000,113,0,'AUSTRALIA_WG','')
i = i + 1
trans_tab( i ) = trans('COVER053',' ',' ',1,001,053,000,113,0,'ARID_AUSTRALIAN_WG','')
i = i + 1
trans_tab( i ) = trans('COVER054',' ',' ',1,001,054,000,113,0,'NEW_ZEALAND_WG','')
i = i + 1
trans_tab( i ) = trans('COVER055',' ',' ',1,001,055,000,113,0,'FAR_EAST_WG','')
i = i + 1
trans_tab( i ) = trans('COVER056',' ',' ',1,001,056,000,113,0,'CERRADO','')
i = i + 1
trans_tab( i ) = trans('COVER057',' ',' ',1,001,057,000,113,0,'COASTAL_CERRADO','')
i = i + 1
trans_tab( i ) = trans('COVER058',' ',' ',1,001,058,000,113,0,'SERTAO','')
i = i + 1
trans_tab( i ) = trans('COVER059',' ',' ',1,001,059,000,113,0,'POLAR_WG','')
i = i + 1
trans_tab( i ) = trans('COVER060',' ',' ',1,001,060,000,113,0,'CONTINENTAL_WG','')
i = i + 1
trans_tab( i ) = trans('COVER061',' ',' ',1,001,061,000,113,0,'MONSOON_WG','')
i = i + 1
trans_tab( i ) = trans('COVER062',' ',' ',1,001,062,000,113,0,'PANAMERICAN_WG','')
i = i + 1
trans_tab( i ) = trans('COVER063',' ',' ',1,001,063,000,113,0,'SOUTH_US_WG','')
i = i + 1
trans_tab( i ) = trans('COVER064',' ',' ',1,001,064,000,113,0,'CORDILLERA_WG','')
i = i + 1
trans_tab( i ) = trans('COVER065',' ',' ',1,001,065,000,113,0,'AMAZONIAN_WG','')
i = i + 1
trans_tab( i ) = trans('COVER066',' ',' ',1,001,066,000,113,0,'MAGHREBIAN_WG','')
i = i + 1
trans_tab( i ) = trans('COVER067',' ',' ',1,001,067,000,113,0,'ETHIOPIAN_CS','')
i = i + 1
trans_tab( i ) = trans('COVER068',' ',' ',1,001,068,000,113,0,'SAHELIAN_CS','')
i = i + 1
trans_tab( i ) = trans('COVER069',' ',' ',1,001,069,000,113,0,'AFRICAN_CS','')
i = i + 1
trans_tab( i ) = trans('COVER070',' ',' ',1,001,070,000,113,0,'AUSTRALIAN_CS','')
i = i + 1
trans_tab( i ) = trans('COVER071',' ',' ',1,001,071,000,113,0,'SEMI_DESERTIC_CS','')
i = i + 1
trans_tab( i ) = trans('COVER072',' ',' ',1,001,072,000,113,0,'OCEANIAN_CS','')
i = i + 1
trans_tab( i ) = trans('COVER073',' ',' ',1,001,073,000,113,0,'SOUTH_AUSTRALIA_CS','')
i = i + 1
trans_tab( i ) = trans('COVER074',' ',' ',1,001,074,000,113,0,'ASIAN_POLAR_CS','')
i = i + 1
trans_tab( i ) = trans('COVER075',' ',' ',1,001,075,000,113,0,'ASIAN_CONT_CS','')
i = i + 1
trans_tab( i ) = trans('COVER076',' ',' ',1,001,076,000,113,0,'MONSOON_CS','')
i = i + 1
trans_tab( i ) = trans('COVER077',' ',' ',1,001,077,000,113,0,'AM_POLAR_CS','')
i = i + 1
trans_tab( i ) = trans('COVER078',' ',' ',1,001,078,000,113,0,'ROCKIES_CS','')
i = i + 1
trans_tab( i ) = trans('COVER079',' ',' ',1,001,079,000,113,0,'MAGHREBIAN_CS','')
i = i + 1
trans_tab( i ) = trans('COVER080',' ',' ',1,001,080,000,113,0,'DESERTIC_OS','')
i = i + 1
trans_tab( i ) = trans('COVER081',' ',' ',1,001,081,000,113,0,'SAHELIAN_SAVANNA','')
i = i + 1
trans_tab( i ) = trans('COVER082',' ',' ',1,001,082,000,113,0,'BUSHLAND','')
i = i + 1
trans_tab( i ) = trans('COVER083',' ',' ',1,001,083,000,113,0,'BUSH_AND_PAMPA','')
i = i + 1
trans_tab( i ) = trans('COVER084',' ',' ',1,001,084,000,113,0,'MONSOON_OS','')
i = i + 1
trans_tab( i ) = trans('COVER085',' ',' ',1,001,085,000,113,0,'POLAR_OS','')
i = i + 1
trans_tab( i ) = trans('COVER086',' ',' ',1,001,086,000,113,0,'SUBPOLAR_OS','')
i = i + 1
trans_tab( i ) = trans('COVER087',' ',' ',1,001,087,000,113,0,'ROCKIES_OS','')
i = i + 1
trans_tab( i ) = trans('COVER088',' ',' ',1,001,088,000,113,0,'TROP_AF_GR','')
i = i + 1
trans_tab( i ) = trans('COVER089',' ',' ',1,001,089,000,113,0,'ARID_AF_GR','')
i = i + 1
trans_tab( i ) = trans('COVER090',' ',' ',1,001,090,000,113,0,'MER_AF_GR','')
i = i + 1
trans_tab( i ) = trans('COVER091',' ',' ',1,001,091,000,113,0,'COAST_EQ_GR','')
i = i + 1
trans_tab( i ) = trans('COVER092',' ',' ',1,001,092,000,113,0,'DESERTIC_GR','')
i = i + 1
trans_tab( i ) = trans('COVER093',' ',' ',1,001,093,000,113,0,'NEW_ZEALAND_GR','')
i = i + 1
trans_tab( i ) = trans('COVER094',' ',' ',1,001,094,000,113,0,'MONSOON_GR','')
i = i + 1
trans_tab( i ) = trans('COVER095',' ',' ',1,001,095,000,113,0,'VENEZUELIAN_GR','')
i = i + 1
trans_tab( i ) = trans('COVER096',' ',' ',1,001,096,000,113,0,'SUB_AMAZONIAN_GR','')
i = i + 1
trans_tab( i ) = trans('COVER097',' ',' ',1,001,097,000,113,0,'PAMPA','')
i = i + 1
trans_tab( i ) = trans('COVER098',' ',' ',1,001,098,000,113,0,'PATAGONIAN_GR','')
i = i + 1
trans_tab( i ) = trans('COVER099',' ',' ',1,001,099,000,113,0,'CONTINENTAL_GR','')
i = i + 1
trans_tab( i ) = trans('COVER100',' ',' ',1,001,100,000,113,0,'GRASS_TUNDRA','')
i = i + 1
trans_tab( i ) = trans('COVER101',' ',' ',1,001,101,000,113,0,'EAST_ASIAN_GR','')
i = i + 1
trans_tab( i ) = trans('COVER102',' ',' ',1,001,102,000,113,0,'INDIAN_GR','')
i = i + 1
trans_tab( i ) = trans('COVER103',' ',' ',1,001,103,000,113,0,'ROCKIES_GR','')
i = i + 1
trans_tab( i ) = trans('COVER104',' ',' ',1,001,104,000,113,0,'CHINESE_GR','')
i = i + 1
trans_tab( i ) = trans('COVER105',' ',' ',1,001,105,000,113,0,'NIL_VALLEY_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER106',' ',' ',1,001,106,000,113,0,'TROP_SAHELIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER107',' ',' ',1,001,107,000,113,0,'TROP_AF_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER108',' ',' ',1,001,108,000,113,0,'COAST_AF_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER109',' ',' ',1,001,109,000,113,0,'SOUTH_AUSTRALIA_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER110',' ',' ',1,001,110,000,113,0,'PANAMERICAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER111',' ',' ',1,001,111,000,113,0,'PARANA_PLAIN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER112',' ',' ',1,001,112,000,113,0,'SUB_AMAZONIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER113',' ',' ',1,001,113,000,113,0,'TRANS_SIBERIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER114',' ',' ',1,001,114,000,113,0,'MANDCHOURIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER115',' ',' ',1,001,115,000,113,0,'CHINESE_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER116',' ',' ',1,001,116,000,113,0,'COLD_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER117',' ',' ',1,001,117,000,113,0,'SUB_HIMALAYAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER118',' ',' ',1,001,118,000,113,0,'GREAT_PLAINS_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER119',' ',' ',1,001,119,000,113,0,'SOUTH_US_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER120',' ',' ',1,001,120,000,113,0,'CALIFORNIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER121',' ',' ',1,001,121,000,113,0,'MAGHREBIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER122',' ',' ',1,001,122,000,113,0,'SOUTH_AFRICA_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER123',' ',' ',1,001,123,000,113,0,'SPARSE_TUNDRA','')
i = i + 1
trans_tab( i ) = trans('COVER124',' ',' ',1,001,124,000,113,0,'WARM_WETLANDS','')
i = i + 1
trans_tab( i ) = trans('COVER125',' ',' ',1,001,125,000,113,0,'POLAR_WETLANDS','')
i = i + 1
trans_tab( i ) = trans('COVER151',' ',' ',1,001,151,000,113,0,'URBAN','')
i = i + 1
trans_tab( i ) = trans('COVER152',' ',' ',1,001,152,000,113,0,'WARM_SUBURBAN','')
i = i + 1
trans_tab( i ) = trans('COVER153',' ',' ',1,001,153,000,113,0,'TEMPERATE_SUBURBAN','')
i = i + 1
trans_tab( i ) = trans('COVER154',' ',' ',1,001,154,000,113,0,'COLD_SUBURBAN','')
i = i + 1
trans_tab( i ) = trans('COVER155',' ',' ',1,001,155,000,113,0,'INDUSTRIES','')
i = i + 1
trans_tab( i ) = trans('COVER156',' ',' ',1,001,156,000,113,0,'ROAD_AND_RAIL','')
i = i + 1
trans_tab( i ) = trans('COVER157',' ',' ',1,001,157,000,113,0,'PORT_FACILITIES','')
i = i + 1
trans_tab( i ) = trans('COVER158',' ',' ',1,001,158,000,113,0,'AIRPORTS','')
i = i + 1
trans_tab( i ) = trans('COVER159',' ',' ',1,001,159,000,113,0,'MINES','')
i = i + 1
trans_tab( i ) = trans('COVER160',' ',' ',1,001,160,000,113,0,'PARKS','')
i = i + 1
trans_tab( i ) = trans('COVER161',' ',' ',1,001,161,000,113,0,'LEISURE','')
i = i + 1
trans_tab( i ) = trans('COVER162',' ',' ',1,001,162,000,113,0,'SPANISH_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER163',' ',' ',1,001,163,000,113,0,'ESTREMADURA_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER164',' ',' ',1,001,164,000,113,0,'MEDITER_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER165',' ',' ',1,001,165,000,113,0,'ATLANTIC_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER166',' ',' ',1,001,166,000,113,0,'TEMPERATE_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER167',' ',' ',1,001,167,000,113,0,'PO_PLAIN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER168',' ',' ',1,001,168,000,113,0,'FRENCH_BALKAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER169',' ',' ',1,001,169,000,113,0,'UKRAINIAN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER170',' ',' ',1,001,170,000,113,0,'SUBPOLAR_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER171',' ',' ',1,001,171,000,113,0,'MOUNTAIN_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER172',' ',' ',1,001,172,000,113,0,'CENTRAL_EUROPE_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER173',' ',' ',1,001,173,000,113,0,'TURKISH_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER174',' ',' ',1,001,174,000,113,0,'MEDITER_IRR_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER175',' ',' ',1,001,175,000,113,0,'IRRIGATED_CROPS','')
i = i + 1
trans_tab( i ) = trans('COVER176',' ',' ',1,001,176,000,113,0,'RICE_FIELDS','')
i = i + 1
trans_tab( i ) = trans('COVER177',' ',' ',1,001,177,000,113,0,'MEDITER_VINEYARDS','')
i = i + 1
trans_tab( i ) = trans('COVER178',' ',' ',1,001,178,000,113,0,'TEMPERATE_VINEYARDS','')
i = i + 1
trans_tab( i ) = trans('COVER179',' ',' ',1,001,179,000,113,0,'MEDITER_FRUIT_TREES','')
i = i + 1
trans_tab( i ) = trans('COVER180',' ',' ',1,001,180,000,113,0,'TEMPERATE_FRUIT_TREES','')
i = i + 1
trans_tab( i ) = trans('COVER181',' ',' ',1,001,181,000,113,0,'OLIVE_GROVES','')
i = i + 1
trans_tab( i ) = trans('COVER182',' ',' ',1,001,182,000,113,0,'NORTH_EUROPE_PASTURES','')
i = i + 1
trans_tab( i ) = trans('COVER183',' ',' ',1,001,183,000,113,0,'ATLANTIC_PASTURES','')
i = i + 1
trans_tab( i ) = trans('COVER184',' ',' ',1,001,184,000,113,0,'EAST_EUROPE_PASTURES','')
i = i + 1
trans_tab( i ) = trans('COVER185',' ',' ',1,001,185,000,113,0,'UKRAINIAN_PASTURES','')
i = i + 1
trans_tab( i ) = trans('COVER186',' ',' ',1,001,186,000,113,0,'SUBPOLAR_PASTURES','')
i = i + 1
trans_tab( i ) = trans('COVER187',' ',' ',1,001,187,000,113,0,'SPANISH_COMPLEX','')
i = i + 1
trans_tab( i ) = trans('COVER188',' ',' ',1,001,188,000,113,0,'MEDITER_COMPLEX','')
i = i + 1
trans_tab( i ) = trans('COVER189',' ',' ',1,001,189,000,113,0,'TEMPERATE_COMPLEX','')
i = i + 1
trans_tab( i ) = trans('COVER190',' ',' ',1,001,190,000,113,0,'FRENCH_COMPLEX','')
i = i + 1
trans_tab( i ) = trans('COVER191',' ',' ',1,001,191,000,113,0,'BALKAN_COMPLEX','')
i = i + 1
trans_tab( i ) = trans('COVER192',' ',' ',1,001,192,000,113,0,'MEDITER_CW','')
i = i + 1
trans_tab( i ) = trans('COVER193',' ',' ',1,001,193,000,113,0,'TEMPERATE_CW','')
i = i + 1
trans_tab( i ) = trans('COVER194',' ',' ',1,001,194,000,113,0,'FRENCH_CW','')
i = i + 1
trans_tab( i ) = trans('COVER195',' ',' ',1,001,195,000,113,0,'BALKAN_CW','')
i = i + 1
trans_tab( i ) = trans('COVER196',' ',' ',1,001,196,000,113,0,'SPANISH_CW','')
i = i + 1
trans_tab( i ) = trans('COVER197',' ',' ',1,001,197,000,113,0,'BALTIC_CW','')
i = i + 1
trans_tab( i ) = trans('COVER198',' ',' ',1,001,198,000,113,0,'AGRO_FORESTRY_AREAS','')
i = i + 1
trans_tab( i ) = trans('COVER199',' ',' ',1,001,199,000,113,0,'SPANISH_BF','')
i = i + 1
trans_tab( i ) = trans('COVER200',' ',' ',1,001,200,000,113,0,'ESTREMADURA_BF','')
i = i + 1
trans_tab( i ) = trans('COVER201',' ',' ',1,001,201,000,113,0,'MEDITER_BF','')
i = i + 1
trans_tab( i ) = trans('COVER202',' ',' ',1,001,202,000,113,0,'ATLANTIC_COAST_BF','')
i = i + 1
trans_tab( i ) = trans('COVER203',' ',' ',1,001,203,000,113,0,'TEMPERATE_BF','')
i = i + 1
trans_tab( i ) = trans('COVER204',' ',' ',1,001,204,000,113,0,'MOUNTAIN_BF','')
i = i + 1
trans_tab( i ) = trans('COVER205',' ',' ',1,001,205,000,113,0,'BALKAN_BF','')
i = i + 1
trans_tab( i ) = trans('COVER206',' ',' ',1,001,206,000,113,0,'SUBPOLAR_BF','')
i = i + 1
trans_tab( i ) = trans('COVER207',' ',' ',1,001,207,000,113,0,'BLACK_SEA_BF','')
i = i + 1
trans_tab( i ) = trans('COVER208',' ',' ',1,001,208,000,113,0,'MEDITER_PINES','')
i = i + 1
trans_tab( i ) = trans('COVER209',' ',' ',1,001,209,000,113,0,'LANDES_FOREST','')
i = i + 1
trans_tab( i ) = trans('COVER210',' ',' ',1,001,210,000,113,0,'MOUNTAIN_CF','')
i = i + 1
trans_tab( i ) = trans('COVER211',' ',' ',1,001,211,000,113,0,'TEMPERATE_CF','')
i = i + 1
trans_tab( i ) = trans('COVER212',' ',' ',1,001,212,000,113,0,'SUBPOLAR_TAIGA','')
i = i + 1
trans_tab( i ) = trans('COVER213',' ',' ',1,001,213,000,113,0,'RUSSIAN_TAIGA','')
i = i + 1
trans_tab( i ) = trans('COVER214',' ',' ',1,001,214,000,113,0,'TURKISH_CF','')
i = i + 1
trans_tab( i ) = trans('COVER215',' ',' ',1,001,215,000,113,0,'MEDITER_MF','')
i = i + 1
trans_tab( i ) = trans('COVER216',' ',' ',1,001,216,000,113,0,'ATLANTIC_MF','')
i = i + 1
trans_tab( i ) = trans('COVER217',' ',' ',1,001,217,000,113,0,'SUBPOLAR_MF','')
i = i + 1
trans_tab( i ) = trans('COVER218',' ',' ',1,001,218,000,113,0,'MOUNTAIN_MF','')
i = i + 1
trans_tab( i ) = trans('COVER219',' ',' ',1,001,219,000,113,0,'EAST_EUROPE_MF','')
i = i + 1
trans_tab( i ) = trans('COVER220',' ',' ',1,001,220,000,113,0,'MEDITER_GR','')
i = i + 1
trans_tab( i ) = trans('COVER221',' ',' ',1,001,221,000,113,0,'ATLANTIC_GR','')
i = i + 1
trans_tab( i ) = trans('COVER222',' ',' ',1,001,222,000,113,0,'BALKAN_GR','')
i = i + 1
trans_tab( i ) = trans('COVER223',' ',' ',1,001,223,000,113,0,'ESTREMADURA_GR','')
i = i + 1
trans_tab( i ) = trans('COVER224',' ',' ',1,001,224,000,113,0,'SUBPOLAR_GR','')
i = i + 1
trans_tab( i ) = trans('COVER225',' ',' ',1,001,225,000,113,0,'TUNDRA','')
i = i + 1
trans_tab( i ) = trans('COVER226',' ',' ',1,001,226,000,113,0,'TURKISH_MOORS','')
i = i + 1
trans_tab( i ) = trans('COVER227',' ',' ',1,001,227,000,113,0,'MEDITER_MOORS','')
i = i + 1
trans_tab( i ) = trans('COVER228',' ',' ',1,001,228,000,113,0,'MOUNTAIN_MOORS','')
i = i + 1
trans_tab( i ) = trans('COVER229',' ',' ',1,001,229,000,113,0,'ATLANTIC_MOORS','')
i = i + 1
trans_tab( i ) = trans('COVER230',' ',' ',1,001,230,000,113,0,'TURKISH_SHRUBLAND','')
i = i + 1
trans_tab( i ) = trans('COVER231',' ',' ',1,001,231,000,113,0,'MEDITER_MAQUIS','')
i = i + 1
trans_tab( i ) = trans('COVER232',' ',' ',1,001,232,000,113,0,'MOUNTAIN_MAQUIS','')
i = i + 1
trans_tab( i ) = trans('COVER233',' ',' ',1,001,233,000,113,0,'SPANISH_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER234',' ',' ',1,001,234,000,113,0,'MEDITER_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER235',' ',' ',1,001,235,000,113,0,'TEMPERATE_WOODLAND','')
i = i + 1
trans_tab( i ) = trans('COVER236',' ',' ',1,001,236,000,113,0,'SPARSE_VEGETATION','')
i = i + 1
trans_tab( i ) = trans('COVER237',' ',' ',1,001,237,000,113,0,'BURNT_AREAS','')
i = i + 1
trans_tab( i ) = trans('COVER238',' ',' ',1,001,238,000,113,0,'TEMPERATE_WETLANDS','')
i = i + 1
trans_tab( i ) = trans('COVER239',' ',' ',1,001,239,000,113,0,'SUBPOLAR_WETLANDS','')
i = i + 1
trans_tab( i ) = trans('COVER240',' ',' ',1,001,240,000,113,0,'PEAT_BOGS','')
i = i + 1
trans_tab( i ) = trans('COVER241',' ',' ',1,001,241,000,113,0,'SALT_MARSHES','')
i = i + 1
trans_tab( i ) = trans('COVER242',' ',' ',1,001,242,000,113,0,'INTERTIDAL_FLATS','')
i = i + 1
trans_tab( i ) = trans('COVER243',' ',' ',1,001,243,000,113,0,'COASTAL_LAGOONS','')
i = i + 1
trans_tab( i ) = trans('COVER255',' ',' ',1,001,244,000,113,0,'MY_COVER','')

! Ecoclimap II covers

i = i + 1
trans_tab( i ) = trans('COVER301',' ',' ',1,001,001,000,114,0,'N SCANDINAVIA TUNDRA1','')
i = i + 1
trans_tab( i ) = trans('COVER302',' ',' ',1,001,002,000,114,0,'OURAL BF1','')
i = i + 1
trans_tab( i ) = trans('COVER303',' ',' ',1,001,003,000,114,0,'CARELIE BF1','')
i = i + 1
trans_tab( i ) = trans('COVER304',' ',' ',1,001,004,000,114,0,'NORTH RUSSIAN TAIGA1','')
i = i + 1
trans_tab( i ) = trans('COVER305',' ',' ',1,001,005,000,114,0,'NORTH RUSSIAN TAIGA2','')
i = i + 1
trans_tab( i ) = trans('COVER306',' ',' ',1,001,006,000,114,0,'CARELIE BF2','')
i = i + 1
trans_tab( i ) = trans('COVER307',' ',' ',1,001,007,000,114,0,'RUSSIAN TAIGA3','')
i = i + 1
trans_tab( i ) = trans('COVER308',' ',' ',1,001,008,000,114,0,'RUSSIAN BF1','')
i = i + 1
trans_tab( i ) = trans('COVER309',' ',' ',1,001,009,000,114,0,'RUSSIAN TAIGA4','')
i = i + 1
trans_tab( i ) = trans('COVER310',' ',' ',1,001,010,000,114,0,'S SCANDINAVIA TAIGA1','')
i = i + 1
trans_tab( i ) = trans('COVER311',' ',' ',1,001,011,000,114,0,'SOUTH FINLANDIA MF1','')
i = i + 1
trans_tab( i ) = trans('COVER312',' ',' ',1,001,012,000,114,0,'SOUTH NORWAY MF1','')
i = i + 1
trans_tab( i ) = trans('COVER313',' ',' ',1,001,013,000,114,0,'BALTIC BF1','')
i = i + 1
trans_tab( i ) = trans('COVER314',' ',' ',1,001,014,000,114,0,'BALTIC MF1','')
i = i + 1
trans_tab( i ) = trans('COVER315',' ',' ',1,001,015,000,114,0,'SOUTH SWEDEN CF1','')
i = i + 1
trans_tab( i ) = trans('COVER316',' ',' ',1,001,016,000,114,0,'BALTIC MF2','')
i = i + 1
trans_tab( i ) = trans('COVER317',' ',' ',1,001,017,000,114,0,'SOUTH SWEDEN CF2','')
i = i + 1
trans_tab( i ) = trans('COVER318',' ',' ',1,001,018,000,114,0,'SOUTH SWEDEN CF3','')
i = i + 1
trans_tab( i ) = trans('COVER319',' ',' ',1,001,019,000,114,0,'SOUTH SWEDEN MF1','')
i = i + 1
trans_tab( i ) = trans('COVER320',' ',' ',1,001,020,000,114,0,'MOUNTAIN MF1','')
i = i + 1
trans_tab( i ) = trans('COVER321',' ',' ',1,001,021,000,114,0,'MOUNTAIN BF1','')
i = i + 1
trans_tab( i ) = trans('COVER322',' ',' ',1,001,022,000,114,0,'TEMPERATE BF1','')
i = i + 1
trans_tab( i ) = trans('COVER323',' ',' ',1,001,023,000,114,0,'TEMPERATE COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER324',' ',' ',1,001,024,000,114,0,'MOUNTAIN CF1','')
i = i + 1
trans_tab( i ) = trans('COVER325',' ',' ',1,001,025,000,114,0,'TEMP HERBACEOUS CF1','')
i = i + 1
trans_tab( i ) = trans('COVER326',' ',' ',1,001,026,000,114,0,'ATLANTIC COAST BF1','')
i = i + 1
trans_tab( i ) = trans('COVER327',' ',' ',1,001,027,000,114,0,'TURKISH CF1','')
i = i + 1
trans_tab( i ) = trans('COVER328',' ',' ',1,001,028,000,114,0,'BALKAN CF1','')
i = i + 1
trans_tab( i ) = trans('COVER329',' ',' ',1,001,029,000,114,0,'N SPAIN HERBAC MF1','')
i = i + 1
trans_tab( i ) = trans('COVER330',' ',' ',1,001,030,000,114,0,'TEMP SW HERBAC CF1','')
i = i + 1
trans_tab( i ) = trans('COVER331',' ',' ',1,001,031,000,114,0,'ATLANTIC COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER332',' ',' ',1,001,032,000,114,0,'N SPAIN HERBAC MF2','')
i = i + 1
trans_tab( i ) = trans('COVER333',' ',' ',1,001,033,000,114,0,'MEDITER COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER334',' ',' ',1,001,034,000,114,0,'MEDITER COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER335',' ',' ',1,001,035,000,114,0,'MEDITER COMPLEX3','')
i = i + 1
trans_tab( i ) = trans('COVER336',' ',' ',1,001,036,000,114,0,'MEDITER COMPLEX4','')
i = i + 1
trans_tab( i ) = trans('COVER337',' ',' ',1,001,037,000,114,0,'MEDITER COMPLEX5','')
i = i + 1
trans_tab( i ) = trans('COVER338',' ',' ',1,001,038,000,114,0,'BURNT PORT HERBAC CF1','')
i = i + 1
trans_tab( i ) = trans('COVER339',' ',' ',1,001,039,000,114,0,'BURNT PORT HERBAC BF1','')
i = i + 1
trans_tab( i ) = trans('COVER340',' ',' ',1,001,040,000,114,0,'EGEE COAST COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER341',' ',' ',1,001,041,000,114,0,'W MED COAST COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER342',' ',' ',1,001,042,000,114,0,'MAGHR HERBACEOUS MF1','')
i = i + 1
trans_tab( i ) = trans('COVER343',' ',' ',1,001,043,000,114,0,'ESTREM HERBACEOUS MF1','')
i = i + 1
trans_tab( i ) = trans('COVER344',' ',' ',1,001,044,000,114,0,'POLAR MOUNT TUNDRA1','')
i = i + 1
trans_tab( i ) = trans('COVER345',' ',' ',1,001,045,000,114,0,'POLAR MOUNT TUNDRA2','')
i = i + 1
trans_tab( i ) = trans('COVER346',' ',' ',1,001,046,000,114,0,'S SCANDINAVIA TUNDRA1','')
i = i + 1
trans_tab( i ) = trans('COVER347',' ',' ',1,001,047,000,114,0,'NORTH TUNDRA1','')
i = i + 1
trans_tab( i ) = trans('COVER348',' ',' ',1,001,048,000,114,0,'S SCANDINAVIA TUNDRA2','')
i = i + 1
trans_tab( i ) = trans('COVER349',' ',' ',1,001,049,000,114,0,'NORTH RUSSIA TUNDRA1','')
i = i + 1
trans_tab( i ) = trans('COVER350',' ',' ',1,001,050,000,114,0,'ARAL CONTINENTAL GR1','')
i = i + 1
trans_tab( i ) = trans('COVER351',' ',' ',1,001,051,000,114,0,'MOUNTAIN TAIGA MOORS1','')
i = i + 1
trans_tab( i ) = trans('COVER352',' ',' ',1,001,052,000,114,0,'SCOTTISH SWAMP MOORS1','')
i = i + 1
trans_tab( i ) = trans('COVER353',' ',' ',1,001,053,000,114,0,'ATLANTIC COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER354',' ',' ',1,001,054,000,114,0,'ATLANTIC GR1','')
i = i + 1
trans_tab( i ) = trans('COVER355',' ',' ',1,001,055,000,114,0,'IR SCOT SWAMP MOORS1','')
i = i + 1
trans_tab( i ) = trans('COVER356',' ',' ',1,001,056,000,114,0,'ASIAN SPARSE GR1','')
i = i + 1
trans_tab( i ) = trans('COVER357',' ',' ',1,001,057,000,114,0,'AS SPARSE SW COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER358',' ',' ',1,001,058,000,114,0,'N CASPIAN DES OS1','')
i = i + 1
trans_tab( i ) = trans('COVER359',' ',' ',1,001,059,000,114,0,'ATLAS AS SPARSE COMP1','')
i = i + 1
trans_tab( i ) = trans('COVER360',' ',' ',1,001,060,000,114,0,'SPARSE SCO CEN EU GR1','')
i = i + 1
trans_tab( i ) = trans('COVER361',' ',' ',1,001,061,000,114,0,'TEMPERATE COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER362',' ',' ',1,001,062,000,114,0,'ATLANTIC COMPLEX3','')
i = i + 1
trans_tab( i ) = trans('COVER363',' ',' ',1,001,063,000,114,0,'ATLANTIC COMPLEX4','')
i = i + 1
trans_tab( i ) = trans('COVER364',' ',' ',1,001,064,000,114,0,'N ATLANTIC PASTURES1','')
i = i + 1
trans_tab( i ) = trans('COVER365',' ',' ',1,001,065,000,114,0,'SPARSE SCO CEN EU GR2','')
i = i + 1
trans_tab( i ) = trans('COVER366',' ',' ',1,001,066,000,114,0,'SPARSE MOUNT E EU GR1','')
i = i + 1
trans_tab( i ) = trans('COVER367',' ',' ',1,001,067,000,114,0,'TUR N CASP CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER368',' ',' ',1,001,068,000,114,0,'N CASPIAN CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER369',' ',' ',1,001,069,000,114,0,'IRA N CASP CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER370',' ',' ',1,001,070,000,114,0,'TUR IRA MOUNT CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER371',' ',' ',1,001,071,000,114,0,'E CASPIAN DES OS1','')
i = i + 1
trans_tab( i ) = trans('COVER372',' ',' ',1,001,072,000,114,0,'N CASPIAN COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER373',' ',' ',1,001,073,000,114,0,'IRAN MOUNT CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER374',' ',' ',1,001,074,000,114,0,'ASIAN SPARSE DES OS1','')
i = i + 1
trans_tab( i ) = trans('COVER375',' ',' ',1,001,075,000,114,0,'E CASPIAN DES OS2','')
i = i + 1
trans_tab( i ) = trans('COVER376',' ',' ',1,001,076,000,114,0,'N MEDITER COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER377',' ',' ',1,001,077,000,114,0,'N MEDITER COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER378',' ',' ',1,001,078,000,114,0,'ASIAN MEDIT CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER379',' ',' ',1,001,079,000,114,0,'SOUTH RUSSIA CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER380',' ',' ',1,001,080,000,114,0,'BLSEA SPARSE CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER381',' ',' ',1,001,081,000,114,0,'BLSEA SPARSE CONT GR2','')
i = i + 1
trans_tab( i ) = trans('COVER382',' ',' ',1,001,082,000,114,0,'TURK MOUNT CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER383',' ',' ',1,001,083,000,114,0,'TURKISH COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER384',' ',' ',1,001,084,000,114,0,'CAUCASIAN COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER385',' ',' ',1,001,085,000,114,0,'N CASPIAN CONT GR2','')
i = i + 1
trans_tab( i ) = trans('COVER386',' ',' ',1,001,086,000,114,0,'VOLGA VALLEY CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER387',' ',' ',1,001,087,000,114,0,'VOLGA VALLEY CONT GR2','')
i = i + 1
trans_tab( i ) = trans('COVER388',' ',' ',1,001,088,000,114,0,'W CASPIAN CONT GR1','')
i = i + 1
trans_tab( i ) = trans('COVER389',' ',' ',1,001,089,000,114,0,'CAUCASIAN COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER390',' ',' ',1,001,090,000,114,0,'CAUCASIAN COMPLEX3','')
i = i + 1
trans_tab( i ) = trans('COVER391',' ',' ',1,001,091,000,114,0,'BLSEA SPARSE CONT GR3','')
i = i + 1
trans_tab( i ) = trans('COVER392',' ',' ',1,001,092,000,114,0,'CENT MASSIF COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER393',' ',' ',1,001,093,000,114,0,'CENT MASSIF COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER394',' ',' ',1,001,094,000,114,0,'TURK COAST COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER395',' ',' ',1,001,095,000,114,0,'MESOPOTAMIA GR1','')
i = i + 1
trans_tab( i ) = trans('COVER396',' ',' ',1,001,096,000,114,0,'TURK CILICIA COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER397',' ',' ',1,001,097,000,114,0,'ASIAN COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER398',' ',' ',1,001,098,000,114,0,'N MED SPARSE COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER399',' ',' ',1,001,099,000,114,0,'MEDITER COMPLEX6','')
i = i + 1
trans_tab( i ) = trans('COVER400',' ',' ',1,001,100,000,114,0,'MEDIT SPARSE COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER401',' ',' ',1,001,101,000,114,0,'MEDIT SPARSE COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER402',' ',' ',1,001,102,000,114,0,'MEDIT SPARSE COMPLEX3','')
i = i + 1
trans_tab( i ) = trans('COVER403',' ',' ',1,001,103,000,114,0,'MEDIT SPARSE COMPLEX4','')
i = i + 1
trans_tab( i ) = trans('COVER404',' ',' ',1,001,104,000,114,0,'N MED HERBACEOUS CF1','')
i = i + 1
trans_tab( i ) = trans('COVER405',' ',' ',1,001,105,000,114,0,'ESTREMADURA GR1','')
i = i + 1
trans_tab( i ) = trans('COVER406',' ',' ',1,001,106,000,114,0,'TUNISIA COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER407',' ',' ',1,001,107,000,114,0,'TUNISIA HERBACEOUS1','')
i = i + 1
trans_tab( i ) = trans('COVER408',' ',' ',1,001,108,000,114,0,'ALGERIA HERBACEOUS1','')
i = i + 1
trans_tab( i ) = trans('COVER409',' ',' ',1,001,109,000,114,0,'DESERTIC HERBACEOUS1','')
i = i + 1
trans_tab( i ) = trans('COVER410',' ',' ',1,001,110,000,114,0,'DESERTIC HERBACEOUS2','')
i = i + 1
trans_tab( i ) = trans('COVER411',' ',' ',1,001,111,000,114,0,'SPAIN DES COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER412',' ',' ',1,001,112,000,114,0,'MED SPARSE COMPLEX5','')
i = i + 1
trans_tab( i ) = trans('COVER413',' ',' ',1,001,113,000,114,0,'MED SPARSE COMPLEX6','')
i = i + 1
trans_tab( i ) = trans('COVER414',' ',' ',1,001,114,000,114,0,'MED SPARSE COMPLEX7','')
i = i + 1
trans_tab( i ) = trans('COVER415',' ',' ',1,001,115,000,114,0,'ME SPARSE DES COMPL1','')
i = i + 1
trans_tab( i ) = trans('COVER416',' ',' ',1,001,116,000,114,0,'NORTH ARABIA GR1','')
i = i + 1
trans_tab( i ) = trans('COVER417',' ',' ',1,001,117,000,114,0,'N ARABIA DES COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER418',' ',' ',1,001,118,000,114,0,'N ARABIA DESERTIC GR1','')
i = i + 1
trans_tab( i ) = trans('COVER419',' ',' ',1,001,119,000,114,0,'MOROCCO HERBACEOUS1','')
i = i + 1
trans_tab( i ) = trans('COVER420',' ',' ',1,001,120,000,114,0,'S MED COAST HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER421',' ',' ',1,001,121,000,114,0,'W MEDITER WOODLAND1','')
i = i + 1
trans_tab( i ) = trans('COVER422',' ',' ',1,001,122,000,114,0,'S MED COAST HERBAC2','')
i = i + 1
trans_tab( i ) = trans('COVER423',' ',' ',1,001,123,000,114,0,'MESOP DES HERBACEOUS1','')
i = i + 1
trans_tab( i ) = trans('COVER424',' ',' ',1,001,124,000,114,0,'MAG COAST DES HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER425',' ',' ',1,001,125,000,114,0,'TU AR SPARSE HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER426',' ',' ',1,001,126,000,114,0,'MEDIT SPARSE COMPLEX8','')
i = i + 1
trans_tab( i ) = trans('COVER427',' ',' ',1,001,127,000,114,0,'MED SPARSE HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER428',' ',' ',1,001,128,000,114,0,'MEDIT SPARSE COMPLEX9','')
i = i + 1
trans_tab( i ) = trans('COVER429',' ',' ',1,001,129,000,114,0,'SPAIN SPARSE COMPLEX1','')
i = i + 1
trans_tab( i ) = trans('COVER430',' ',' ',1,001,130,000,114,0,'N MED SPARSE COMPLEX2','')
i = i + 1
trans_tab( i ) = trans('COVER431',' ',' ',1,001,131,000,114,0,'N MED SPARSE COMPLEX3','')
i = i + 1
trans_tab( i ) = trans('COVER432',' ',' ',1,001,132,000,114,0,'MAGHRE DES HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER433',' ',' ',1,001,133,000,114,0,'MAGHRE DES HERBAC2','')
i = i + 1
trans_tab( i ) = trans('COVER434',' ',' ',1,001,134,000,114,0,'MAGHRE DES HERBAC3','')
i = i + 1
trans_tab( i ) = trans('COVER435',' ',' ',1,001,135,000,114,0,'N ARAB DES HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER436',' ',' ',1,001,136,000,114,0,'MESOPO DES HERBAC2','')
i = i + 1
trans_tab( i ) = trans('COVER437',' ',' ',1,001,137,000,114,0,'TOURAN DES HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER438',' ',' ',1,001,138,000,114,0,'MESOPO DES HERBAC2','')
i = i + 1
trans_tab( i ) = trans('COVER439',' ',' ',1,001,139,000,114,0,'TOURAN DES HERBAC2','')
i = i + 1
trans_tab( i ) = trans('COVER440',' ',' ',1,001,140,000,114,0,'NEW ZEMBLE HERBAC1','')
i = i + 1
trans_tab( i ) = trans('COVER441',' ',' ',1,001,141,000,114,0,'NEW ZEMBLE HERBAC2','')
i = i + 1
trans_tab( i ) = trans('COVER442',' ',' ',1,001,142,000,114,0,'TRANS SIBERIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER443',' ',' ',1,001,143,000,114,0,'PO PLAIN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER444',' ',' ',1,001,144,000,114,0,'PO PLAIN CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER445',' ',' ',1,001,145,000,114,0,'SPANISH FRENCH CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER446',' ',' ',1,001,146,000,114,0,'SPANISH FR ITAL CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER447',' ',' ',1,001,147,000,114,0,'DANUBE PLAIN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER448',' ',' ',1,001,148,000,114,0,'N MED SPARSE COMPLEX4','')
i = i + 1
trans_tab( i ) = trans('COVER449',' ',' ',1,001,149,000,114,0,'BALKAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER450',' ',' ',1,001,150,000,114,0,'SPAIN FR ITAL CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER451',' ',' ',1,001,151,000,114,0,'ATLANTIC CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER452',' ',' ',1,001,152,000,114,0,'FR MED SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER453',' ',' ',1,001,153,000,114,0,'FR MED SPARSE CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER454',' ',' ',1,001,154,000,114,0,'ATL MED SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER455',' ',' ',1,001,155,000,114,0,'BENE BLACK SEA CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER456',' ',' ',1,001,156,000,114,0,'FRENCH ITALIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER457',' ',' ',1,001,157,000,114,0,'FR MED SPARSE CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER458',' ',' ',1,001,158,000,114,0,'MEDITER SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER459',' ',' ',1,001,159,000,114,0,'ATLANTIC CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER460',' ',' ',1,001,160,000,114,0,'NORTH ATLANTIC CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER461',' ',' ',1,001,161,000,114,0,'SOUTH RUSSIA CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER462',' ',' ',1,001,162,000,114,0,'S RUSSIA BALTIC CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER463',' ',' ',1,001,163,000,114,0,'UKRAINIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER464',' ',' ',1,001,164,000,114,0,'EAST CARPATES CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER465',' ',' ',1,001,165,000,114,0,'E CENT EUROPE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER466',' ',' ',1,001,166,000,114,0,'W CENT EU SW CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER467',' ',' ',1,001,167,000,114,0,'HUNGARIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER468',' ',' ',1,001,168,000,114,0,'N BLACK SEA CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER469',' ',' ',1,001,169,000,114,0,'HUNG BULG CAUC CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER470',' ',' ',1,001,170,000,114,0,'SOUTH SWEDEN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER471',' ',' ',1,001,171,000,114,0,'SW RUSSIA CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER472',' ',' ',1,001,172,000,114,0,'SOUTH RUSSIA CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER473',' ',' ',1,001,173,000,114,0,'IRAN N CASPIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER474',' ',' ',1,001,174,000,114,0,'FR TEMP SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER475',' ',' ',1,001,175,000,114,0,'BULGARIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER476',' ',' ',1,001,176,000,114,0,'BULGARIAN CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER477',' ',' ',1,001,177,000,114,0,'SP TURK SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER478',' ',' ',1,001,178,000,114,0,'FRENCH CENT EU CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER479',' ',' ',1,001,179,000,114,0,'N BLACK SEA CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER480',' ',' ',1,001,180,000,114,0,'BULGARIAN CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER481',' ',' ',1,001,181,000,114,0,'POLE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER482',' ',' ',1,001,182,000,114,0,'POLE CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER483',' ',' ',1,001,183,000,114,0,'N BLACK SEA CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER484',' ',' ',1,001,184,000,114,0,'CENT EU SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER485',' ',' ',1,001,185,000,114,0,'GERMAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER486',' ',' ',1,001,186,000,114,0,'BEAUCE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER487',' ',' ',1,001,187,000,114,0,'DANE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER488',' ',' ',1,001,188,000,114,0,'DANE CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER489',' ',' ',1,001,189,000,114,0,'NEU ATL SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER490',' ',' ',1,001,190,000,114,0,'SYRIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER491',' ',' ',1,001,191,000,114,0,'GERMAN CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER492',' ',' ',1,001,192,000,114,0,'CHANNEL CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER493',' ',' ',1,001,193,000,114,0,'CHANNEL CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER494',' ',' ',1,001,194,000,114,0,'ITALIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER495',' ',' ',1,001,195,000,114,0,'TURKISH CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER496',' ',' ',1,001,196,000,114,0,'N MEDIT SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER497',' ',' ',1,001,197,000,114,0,'SPAIN TUR ARAB CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER498',' ',' ',1,001,198,000,114,0,'NORTH SPAIN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER499',' ',' ',1,001,199,000,114,0,'MOROCCO TUNIS CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER500',' ',' ',1,001,200,000,114,0,'MOROCCO CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER501',' ',' ',1,001,201,000,114,0,'MOROCCO CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER502',' ',' ',1,001,202,000,114,0,'ALGERIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER503',' ',' ',1,001,203,000,114,0,'MOROCCO CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER504',' ',' ',1,001,204,000,114,0,'WEST SPAIN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER505',' ',' ',1,001,205,000,114,0,'MOROCCO CROPS4','')
i = i + 1
trans_tab( i ) = trans('COVER506',' ',' ',1,001,206,000,114,0,'NORTH MEDITER CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER507',' ',' ',1,001,207,000,114,0,'SOUTH SPANISH CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER508',' ',' ',1,001,208,000,114,0,'SICILIAN CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER509',' ',' ',1,001,209,000,114,0,'MAGHREB SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER510',' ',' ',1,001,210,000,114,0,'N MEDIT SPARSE CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER511',' ',' ',1,001,211,000,114,0,'N MEDIT SPARSE CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER512',' ',' ',1,001,212,000,114,0,'SP IT WCOAST CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER513',' ',' ',1,001,213,000,114,0,'ESTREMADURA CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER514',' ',' ',1,001,214,000,114,0,'ESTREMADURA CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER515',' ',' ',1,001,215,000,114,0,'SP IT WCOAST CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER516',' ',' ',1,001,216,000,114,0,'ESTREMADURA CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER517',' ',' ',1,001,217,000,114,0,'MEDIT ISLANDS CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER518',' ',' ',1,001,218,000,114,0,'SPAIN W COAST CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER519',' ',' ',1,001,219,000,114,0,'ESTREMADURA CROPS4','')
i = i + 1
trans_tab( i ) = trans('COVER520',' ',' ',1,001,220,000,114,0,'MECOAST SPARSE CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER521',' ',' ',1,001,221,000,114,0,'BRITTANY CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER522',' ',' ',1,001,222,000,114,0,'SYRIAN CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER523',' ',' ',1,001,223,000,114,0,'NIL VALLEY CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER524',' ',' ',1,001,224,000,114,0,'NIL VALLEY CROPS2','')
i = i + 1
trans_tab( i ) = trans('COVER525',' ',' ',1,001,225,000,114,0,'NIL VALLEY CROPS3','')
i = i + 1
trans_tab( i ) = trans('COVER526',' ',' ',1,001,226,000,114,0,'NIL VALLEY CROPS4','')
i = i + 1
trans_tab( i ) = trans('COVER527',' ',' ',1,001,227,000,114,0,'SPANISH IRR CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER528',' ',' ',1,001,228,000,114,0,'NIL VALLEY CROPS5','')
i = i + 1
trans_tab( i ) = trans('COVER529',' ',' ',1,001,229,000,114,0,'EGEE IRR CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER530',' ',' ',1,001,230,000,114,0,'MEDITER IRR CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER531',' ',' ',1,001,231,000,114,0,'S SPAIN IRR CROPS1','')
i = i + 1
trans_tab( i ) = trans('COVER532',' ',' ',1,001,232,000,114,0,'NIL VALLEY CROPS6','')
i = i + 1
trans_tab( i ) = trans('COVER533',' ',' ',1,001,233,000,114,0,'BARE ROCK1','')
i = i + 1
trans_tab( i ) = trans('COVER534',' ',' ',1,001,234,000,114,0,'BARE ROCK2','')
i = i + 1
trans_tab( i ) = trans('COVER535',' ',' ',1,001,235,000,114,0,'SANDY DESERT1','')
i = i + 1
trans_tab( i ) = trans('COVER536',' ',' ',1,001,236,000,114,0,'BARE LAND1','')
i = i + 1
trans_tab( i ) = trans('COVER537',' ',' ',1,001,237,000,114,0,'BARE LAND2','')
i = i + 1
trans_tab( i ) = trans('COVER538',' ',' ',1,001,238,000,114,0,'BARE LAND3','')
i = i + 1
trans_tab( i ) = trans('COVER539',' ',' ',1,001,239,000,114,0,'BARE LAND4','')
i = i + 1
trans_tab( i ) = trans('COVER540',' ',' ',1,001,240,000,114,0,'BARE LAND5','')
i = i + 1
trans_tab( i ) = trans('COVER541',' ',' ',1,001,241,000,114,0,'BARE LAND6','')
i = i + 1
trans_tab( i ) = trans('COVER542',' ',' ',1,001,242,000,114,0,'BARE LAND7','')
i = i + 1
trans_tab( i ) = trans('COVER543',' ',' ',1,001,243,000,114,0,'BARE LAND8','')
i = i + 1
trans_tab( i ) = trans('COVER544',' ',' ',1,001,244,000,114,0,'BARE LAND9','')
i = i + 1
trans_tab( i ) = trans('COVER545',' ',' ',1,001,245,000,114,0,'BARE LAND10','')
i = i + 1
trans_tab( i ) = trans('COVER546',' ',' ',1,001,246,000,114,0,'BARE LAND11','')
i = i + 1
trans_tab( i ) = trans('COVER547',' ',' ',1,001,247,000,114,0,'BARE LAND12','')
i = i + 1
trans_tab( i ) = trans('COVER548',' ',' ',1,001,248,000,114,0,'PERMANENT SNOW1','')
i = i + 1
trans_tab( i ) = trans('COVER549',' ',' ',1,001,249,000,114,0,'INLAND WATERS1','')
i = i + 1
trans_tab( i ) = trans('COVER550',' ',' ',1,001,250,000,114,0,'UNDEFINED1','')
i = i + 1
trans_tab( i ) = trans('COVER551',' ',' ',1,001,251,000,114,0,'INLAND WATERS2','')
i = i + 1
trans_tab( i ) = trans('COVER552',' ',' ',1,001,252,000,114,0,'POLAR WETLANDS1','')
i = i + 1
trans_tab( i ) = trans('COVER553',' ',' ',1,001,253,000,114,0,'INLAND WATERS3','')
i = i + 1
trans_tab( i ) = trans('COVER554',' ',' ',1,001,254,000,114,0,'INLAND WATERS4','')
i = i + 1
trans_tab( i ) = trans('COVER555',' ',' ',1,001,019,000,115,0,'INLAND WATERS5','')
i = i + 1
trans_tab( i ) = trans('COVER556',' ',' ',1,001,001,000,115,0,'INLAND WATERS6','')
i = i + 1
trans_tab( i ) = trans('COVER557',' ',' ',1,001,002,000,115,0,'POLAR WETLANDS2','')
i = i + 1
trans_tab( i ) = trans('COVER558',' ',' ',1,001,003,000,115,0,'SUBPOLAR WETLANDS1','')
i = i + 1
trans_tab( i ) = trans('COVER559',' ',' ',1,001,004,000,115,0,'SUBPOLAR WETLANDS2','')
i = i + 1
trans_tab( i ) = trans('COVER560',' ',' ',1,001,005,000,115,0,'SUBPOLAR WETLANDS3','')
i = i + 1
trans_tab( i ) = trans('COVER561',' ',' ',1,001,006,000,115,0,'TEMPERATE SUBURBAN1','')
i = i + 1
trans_tab( i ) = trans('COVER562',' ',' ',1,001,007,000,115,0,'TEMPERATE SUBURBAN2','')
i = i + 1
trans_tab( i ) = trans('COVER563',' ',' ',1,001,008,000,115,0,'TEMPERATE SUBURBAN3','')
i = i + 1
trans_tab( i ) = trans('COVER564',' ',' ',1,001,009,000,115,0,'TEMPERATE SUBURBAN4','')
i = i + 1
trans_tab( i ) = trans('COVER565',' ',' ',1,001,010,000,115,0,'TEMPERATE SUBURBAN5','')
i = i + 1
trans_tab( i ) = trans('COVER566',' ',' ',1,001,011,000,115,0,'COLD SUBURBAN1','')
i = i + 1
trans_tab( i ) = trans('COVER567',' ',' ',1,001,012,000,115,0,'WARM SUBURBAN1','')
i = i + 1
trans_tab( i ) = trans('COVER568',' ',' ',1,001,013,000,115,0,'WARM SUBURBAN2','')
i = i + 1
trans_tab( i ) = trans('COVER569',' ',' ',1,001,014,000,115,0,'TEMPERATE SUBURBAN6','')
i = i + 1
trans_tab( i ) = trans('COVER570',' ',' ',1,001,015,000,115,0,'TEMPERATE SUBURBAN7','')
i = i + 1
trans_tab( i ) = trans('COVER571',' ',' ',1,001,016,000,115,0,'WARM SUBURBAN3','')
i = i + 1
trans_tab( i ) = trans('COVER572',' ',' ',1,001,017,000,115,0,'SPANISH VINEYARDS1','')
i = i + 1
trans_tab( i ) = trans('COVER573',' ',' ',1,001,018,000,115,0,'LANGUEDOC VINEYARDS1','')

! End of Ecoclimap

t%lev = 600

i = i + 1
trans_tab( i ) = trans('ZS'       ,' ',' ',1,001,008,000,105,0,'Oro hgt.','')
i = i + 1
trans_tab( i ) = trans('AVG_ZS'   ,' ',' ',1,001,001,t%lev,105,0,'Average oro','')
i = i + 1
trans_tab( i ) = trans('SIL_ZS'   ,' ',' ',1,001,002,t%lev,105,0,'Silhouette oro','')
i = i + 1
trans_tab( i ) = trans('MIN_ZS'   ,' ',' ',1,001,003,t%lev,105,0,'Min subgrid oro','')
i = i + 1
trans_tab( i ) = trans('MAX_ZS'   ,' ',' ',1,001,004,t%lev,105,0,'Max subgrid oro','')
i = i + 1
trans_tab( i ) = trans('SSO_STDEV',' ',' ',1,001,005,t%lev,105,0,'Stdv SSO','')
i = i + 1
trans_tab( i ) = trans('SSO_ANIS' ,' ',' ',1,001,006,t%lev,105,0,'Aniso SSO','')
i = i + 1
trans_tab( i ) = trans('SSO_DIR'  ,' ',' ',1,001,007,t%lev,105,0,'Direction SSO','')
i = i + 1
trans_tab( i ) = trans('SSO_SLOPE',' ',' ',1,001,008,t%lev,105,0,'Slop SSO','')
i = i + 1
trans_tab( i ) = trans('HO2IP'    ,' ',' ',1,001,009,t%lev,105,0,'h/2 i+','')
i = i + 1
trans_tab( i ) = trans('HO2JP'    ,' ',' ',1,001,010,t%lev,105,0,'h/2 j+','')
i = i + 1
trans_tab( i ) = trans('HO2IM'    ,' ',' ',1,001,011,t%lev,105,0,'h/2 i-','')
i = i + 1
trans_tab( i ) = trans('HO2JM'    ,' ',' ',1,001,012,t%lev,105,0,'h/2 j-','')
i = i + 1
trans_tab( i ) = trans('AOSIP'    ,' ',' ',1,001,013,t%lev,105,0,'A/S i+','')
i = i + 1
trans_tab( i ) = trans('AOSJP'    ,' ',' ',1,001,014,t%lev,105,0,'A/S j+','')
i = i + 1
trans_tab( i ) = trans('AOSIM'    ,' ',' ',1,001,015,t%lev,105,0,'A/S i-','')
i = i + 1
trans_tab( i ) = trans('AOSJM'    ,' ',' ',1,001,016,t%lev,105,0,'A/S j-','')
i = i + 1
trans_tab( i ) = trans('CLAY'     ,' ',' ',1,001,225,000,105,0,'Fraction of clay','')
i = i + 1
trans_tab( i ) = trans('SAND'     ,' ',' ',1,001,226,000,105,0,'Fraction of Sand','')
i = i + 1
trans_tab( i ) = trans('RUNOFFB'  ,' ',' ',1,001,090,000,105,0,'Slope of the runoff curve','')
i = i + 1
trans_tab( i ) = trans('SST      ',' ',' ',1,001,011,000,102,0,'SST','')

!
! More SURFEX
!

 t%lev = 755
i = i + 1
trans_tab( i ) = trans('INPRR           ',' ',' ',1,001,059,t%lev,105,0,'Liquid precipitation','')
i = i + 1
trans_tab( i ) = trans('INPRS           ',' ',' ',1,001,064,t%lev,105,0,'Snow precipitation','')
i = i + 1
trans_tab( i ) = trans('INPRG           ',' ',' ',1,001,202,t%lev,105,0,'Graupel precipitation','')
i = i + 1
trans_tab( i ) = trans('ACPRR           ',' ',' ',1,001,062,t%lev,105,4,'Acc. Liquid precipitation','')
i = i + 1
trans_tab( i ) = trans('ACPRS           ',' ',' ',1,001,079,t%lev,105,4,'Acc. Snow precipitation','')
i = i + 1
trans_tab( i ) = trans('ACPRG           ',' ',' ',1,001,201,t%lev,105,4,'Acc. Graupel precipitation','')

!
!  Sea ice
!

 t%lev = 720

i = i + 1
trans_tab( i ) = trans('SIC             ',' ',' ',1,001,011,t%lev,105,0,'Sea ice fraction','')
i = i + 1
trans_tab( i ) = trans('ASNOW_ICE       ',' ',' ',1,001,190,t%lev,105,0,'Albedo of snow on sea ice','')
i = i + 1
trans_tab( i ) = trans('TSNOW_ICE_01    ',' ',' ',1,001,011,t%lev+1,105,0,'Snow on sea ice temperature in layer 1','')
i = i + 1
trans_tab( i ) = trans('TSNOW_ICE_02    ',' ',' ',1,001,011,t%lev+2,105,0,'Snow on sea ice temperature in layer 2','')
i = i + 1
trans_tab( i ) = trans('TSNOW_ICE_03    ',' ',' ',1,001,011,t%lev+3,105,0,'Snow on sea ice temperature in layer 3','')
i = i + 1
trans_tab( i ) = trans('TSNOW_ICE_04    ',' ',' ',1,001,011,t%lev+4,105,0,'Snow on sea ice temperature in layer 4','')


i = i + 1
trans_tab( i ) = trans('WSNOW_ICE_01    ',' ',' ',1,001,013,t%lev+1,105,0,'Snow on sea ice water equivalent in layer 1','')
i = i + 1
trans_tab( i ) = trans('WSNOW_ICE_02    ',' ',' ',1,001,013,t%lev+2,105,0,'Snow on sea ice water equivalent in layer 2','')
i = i + 1
trans_tab( i ) = trans('WSNOW_ICE_03    ',' ',' ',1,001,013,t%lev+3,105,0,'Snow on sea ice water equivalent in layer 3','')
i = i + 1
trans_tab( i ) = trans('WSNOW_ICE_04    ',' ',' ',1,001,013,t%lev+4,105,0,'Snow on sea ice water equivalent in layer 4','')

i = i + 1
trans_tab( i ) = trans('DSNOW_ICE_01    ',' ',' ',1,001,014,t%lev+1,105,0,'Snow on sea ice depth in layer 1','m')
i = i + 1
trans_tab( i ) = trans('DSNOW_ICE_02    ',' ',' ',1,001,014,t%lev+2,105,0,'Snow on sea ice depth in layer 2','m')
i = i + 1
trans_tab( i ) = trans('DSNOW_ICE_03    ',' ',' ',1,001,014,t%lev+3,105,0,'Snow on sea ice depth in layer 3','m')
i = i + 1
trans_tab( i ) = trans('DSNOW_ICE_04    ',' ',' ',1,001,014,t%lev+4,105,0,'Snow on sea ice depth in layer 4','m')

i = i + 1
trans_tab( i ) = trans('HSNOW_ICE_01    ',' ',' ',1,001,015,t%lev+1,105,0,'Snow on sea ice heat content in layer 1','')
i = i + 1
trans_tab( i ) = trans('HSNOW_ICE_02    ',' ',' ',1,001,015,t%lev+2,105,0,'Snow on sea ice heat content in layer 2','')
i = i + 1
trans_tab( i ) = trans('HSNOW_ICE_03    ',' ',' ',1,001,015,t%lev+3,105,0,'Snow on sea ice heat content in layer 3','')
i = i + 1
trans_tab( i ) = trans('HSNOW_ICE_04    ',' ',' ',1,001,015,t%lev+4,105,0,'Snow on sea ice heat content in layer 4','')

i = i + 1
trans_tab( i ) = trans('RSNOW_ICE_01    ',' ',' ',1,001,191,t%lev+1,105,0,'Snow on sea ice density in layer 1','')
i = i + 1
trans_tab( i ) = trans('RSNOW_ICE_02    ',' ',' ',1,001,191,t%lev+2,105,0,'Snow on sea ice density in layer 2','')
i = i + 1
trans_tab( i ) = trans('RSNOW_ICE_03    ',' ',' ',1,001,191,t%lev+3,105,0,'Snow on sea ice density in layer 3','')
i = i + 1
trans_tab( i ) = trans('RSNOW_ICE_04    ',' ',' ',1,001,191,t%lev+4,105,0,'Snow on sea ice density in layer 4','')


 t%lev = 730

i = i + 1
trans_tab( i ) = trans('TICE_01         ',' ',' ',1,001,011,t%lev+1,105,0,'Sea ice temperature in layer 1','')
i = i + 1
trans_tab( i ) = trans('TICE_02         ',' ',' ',1,001,011,t%lev+2,105,0,'Sea ice temperature in layer 2','')
i = i + 1
trans_tab( i ) = trans('TICE_03         ',' ',' ',1,001,011,t%lev+3,105,0,'Sea ice temperature in layer 3','')
i = i + 1
trans_tab( i ) = trans('TICE_04         ',' ',' ',1,001,011,t%lev+4,105,0,'Sea ice temperature in layer 4','')
i = i + 1
trans_tab( i ) = trans('TICE_05         ',' ',' ',1,001,011,t%lev+5,105,0,'Sea ice temperature in layer 5','')
i = i + 1
trans_tab( i ) = trans('TICE_06         ',' ',' ',1,001,011,t%lev+6,105,0,'Sea ice temperature in layer 6','')
i = i + 1
trans_tab( i ) = trans('TICE_07         ',' ',' ',1,001,011,t%lev+7,105,0,'Sea ice temperature in layer 7','')
i = i + 1
trans_tab( i ) = trans('TICE_08         ',' ',' ',1,001,011,t%lev+8,105,0,'Sea ice temperature in layer 8','')
i = i + 1
trans_tab( i ) = trans('TICE_09         ',' ',' ',1,001,011,t%lev+9,105,0,'Sea ice temperature in layer 9','')
i = i + 1
trans_tab( i ) = trans('TICE_10         ',' ',' ',1,001,011,t%lev+10,105,0,'Sea ice temperature in layer 10','')

!
!  Sea
!

 t%lev = 760

i = i + 1
trans_tab( i ) = trans('RI_SEA          ',' ',' ',1,001,001,t%lev,105,0,'Ri num sea','')
i = i + 1
trans_tab( i ) = trans('RNC_SEA          ',' ',' ',1,001,002,t%lev,105,4,'Net radiation sea','')
i = i + 1
trans_tab( i ) = trans('RN_SEA          ',' ',' ',1,001,002,t%lev,105,0,'Net radiation sea','')
i = i + 1
trans_tab( i ) = trans('HC_SEA           ',' ',' ',1,001,122,t%lev,105,4,'Sens heat flux sea','')
i = i + 1
trans_tab( i ) = trans('H_SEA           ',' ',' ',1,001,122,t%lev,105,0,'Sens heat flux sea','')
i = i + 1
trans_tab( i ) = trans('LEC_SEA          ',' ',' ',1,001,121,t%lev,105,4,'Latent heat flux sea','')
i = i + 1
trans_tab( i ) = trans('LE_SEA          ',' ',' ',1,001,121,t%lev,105,0,'Latent heat flux sea','')
i = i + 1
trans_tab( i ) = trans('GFLUXC_SEA       ',' ',' ',1,001,005,t%lev,105,4,'Conduct flux sea','')
i = i + 1
trans_tab( i ) = trans('GFLUX_SEA       ',' ',' ',1,001,005,t%lev,105,0,'Conduct flux sea','')
i = i + 1
trans_tab( i ) = trans('CD_SEA          ',' ',' ',1,001,006,t%lev,105,0,'Drag coefficient for momentum (sea)','')
i = i + 1
trans_tab( i ) = trans('CH_SEA          ',' ',' ',1,001,007,t%lev,105,0,'Drag coefficient for heat (sea)','')
i = i + 1
trans_tab( i ) = trans('CE_SEA          ',' ',' ',1,001,008,t%lev,105,0,'Drag coefficient for evaporation (sea)','')
i = i + 1
trans_tab( i ) = trans('T2M_SEA         ',' ',' ',1,001,011,t%lev,105,0,'T2m sea','')
i = i + 1
trans_tab( i ) = trans('HU2M_SEA        ',' ',' ',1,001,052,t%lev,105,0,'RH2m','')
i = i + 1
trans_tab( i ) = trans('Q2M_SEA         ',' ',' ',1,001,051,t%lev,105,0,'Q2m sea','')
i = i + 1
trans_tab( i ) = trans('MER10M_SEA      ',' ',' ',1,001,034,t%lev,105,0,'V10m sea','')
i = i + 1
trans_tab( i ) = trans('ZON10M_SEA      ',' ',' ',1,001,033,t%lev,105,0,'U10m sea','')
i = i + 1
trans_tab( i ) = trans('FMUC_SEA         ',' ',' ',1,001,124,t%lev,105,4,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMU_SEA         ',' ',' ',1,001,124,t%lev,105,0,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMVC_SEA         ',' ',' ',1,001,125,t%lev,105,4,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('FMV_SEA         ',' ',' ',1,001,125,t%lev,105,0,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('SWDC_SEA         ',' ',' ',1,001,117,t%lev,105,4,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA         ',' ',' ',1,001,117,t%lev,105,0,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWDC_SEA         ',' ',' ',1,001,118,t%lev,105,4,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWD_SEA         ',' ',' ',1,001,118,t%lev,105,0,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWUC_SEA         ',' ',' ',1,001,119,t%lev,105,4,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA         ',' ',' ',1,001,119,t%lev,105,0,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWUC_SEA         ',' ',' ',1,001,120,t%lev,105,4,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWU_SEA         ',' ',' ',1,001,120,t%lev,105,0,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('Z0SEA           ',' ',' ',1,001,083,t%lev,105,0,'Roughness length (sea)','')
i = i + 1
trans_tab( i ) = trans('Z0_SEA          ',' ',' ',1,001,083,t%lev+1,105,0,'Roughness length (sea)','')
i = i + 1
trans_tab( i ) = trans('Z0H_SEA          ',' ',' ',1,001,083,t%lev+2,105,0,'Thermal roughness length (sea)','')
i = i + 1
trans_tab( i ) = trans('SWDC_SEA_1      ',' ',' ',1,001,117,t%lev+1,105,4,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA_1      ',' ',' ',1,001,117,t%lev+1,105,0,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWDC_SEA_2      ',' ',' ',1,001,117,t%lev+2,105,4,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA_2      ',' ',' ',1,001,117,t%lev+2,105,0,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWDC_SEA_3      ',' ',' ',1,001,117,t%lev+3,105,4,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA_3      ',' ',' ',1,001,117,t%lev+3,105,0,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWDC_SEA_4      ',' ',' ',1,001,117,t%lev+4,105,4,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA_4      ',' ',' ',1,001,117,t%lev+4,105,0,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWDC_SEA_5      ',' ',' ',1,001,117,t%lev+5,105,4,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA_5      ',' ',' ',1,001,117,t%lev+5,105,0,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_SEA_6      ',' ',' ',1,001,117,t%lev+6,105,0,'SW down band 6','')
i = i + 1
trans_tab( i ) = trans('SWUC_SEA_1      ',' ',' ',1,001,119,t%lev+1,105,4,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA_1      ',' ',' ',1,001,119,t%lev+1,105,0,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWUC_SEA_2      ',' ',' ',1,001,119,t%lev+2,105,4,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA_2      ',' ',' ',1,001,119,t%lev+2,105,0,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWUC_SEA_3      ',' ',' ',1,001,119,t%lev+3,105,4,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA_3      ',' ',' ',1,001,119,t%lev+3,105,0,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWUC_SEA_4      ',' ',' ',1,001,119,t%lev+4,105,4,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA_4      ',' ',' ',1,001,119,t%lev+4,105,0,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWUC_SEA_5      ',' ',' ',1,001,119,t%lev+5,105,4,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA_5      ',' ',' ',1,001,119,t%lev+5,105,0,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_SEA_6      ',' ',' ',1,001,119,t%lev+6,105,0,'SW up band 6','')

!
! Water bodies, not sea
!

 t%lev = 770
i = i + 1
trans_tab( i ) = trans('RI_WAT          ',' ',' ',1,001,001,t%lev,105,0,'Ri num water','')
i = i + 1
trans_tab( i ) = trans('RNC_WAT          ',' ',' ',1,001,002,t%lev,105,4,'Net radiation water','')
i = i + 1
trans_tab( i ) = trans('RN_WAT          ',' ',' ',1,001,002,t%lev,105,0,'Net radiation water','')
i = i + 1
trans_tab( i ) = trans('HC_WAT           ',' ',' ',1,001,122,t%lev,105,4,'Sens heat flux water','')
i = i + 1
trans_tab( i ) = trans('H_WAT           ',' ',' ',1,001,122,t%lev,105,0,'Sens heat flux water','')
i = i + 1
trans_tab( i ) = trans('LEC_WAT          ',' ',' ',1,001,121,t%lev,105,4,'Latent heat flux water','')
i = i + 1
trans_tab( i ) = trans('LE_WAT          ',' ',' ',1,001,121,t%lev,105,0,'Latent heat flux water','')
i = i + 1
trans_tab( i ) = trans('GFLUXC_WAT       ',' ',' ',1,001,005,t%lev,105,4,'Conduct flux water','')
i = i + 1
trans_tab( i ) = trans('GFLUX_WAT       ',' ',' ',1,001,005,t%lev,105,0,'Conduct flux water','')
i = i + 1
trans_tab( i ) = trans('CD_WAT          ',' ',' ',1,001,006,t%lev,105,0,'Drag coefficient for momentum (water)','')
i = i + 1
trans_tab( i ) = trans('CH_WAT          ',' ',' ',1,001,007,t%lev,105,0,'Drag coefficient for heat (water)','')
i = i + 1
trans_tab( i ) = trans('CE_WAT          ',' ',' ',1,001,008,t%lev,105,0,'Drag coefficient for evaporation (water)','')
i = i + 1
trans_tab( i ) = trans('T2M_WAT         ',' ',' ',1,001,011,t%lev+2,105,0,'T2m water','')
i = i + 1
trans_tab( i ) = trans('HU2M_WAT        ',' ',' ',1,001,052,t%lev+2,105,0,'RH2m','')
i = i + 1
trans_tab( i ) = trans('Q2M_WAT         ',' ',' ',1,001,051,t%lev,105,0,'Q2m water','')
i = i + 1
trans_tab( i ) = trans('MER10M_WAT      ',' ',' ',1,001,034,t%lev,105,0,'V10m water','')
i = i + 1
trans_tab( i ) = trans('ZON10M_WAT      ',' ',' ',1,001,033,t%lev,105,0,'U10m water','')
i = i + 1
trans_tab( i ) = trans('FMUC_WAT         ',' ',' ',1,001,124,t%lev,105,4,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMU_WAT         ',' ',' ',1,001,124,t%lev,105,0,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMVC_WAT         ',' ',' ',1,001,125,t%lev,105,4,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('FMV_WAT         ',' ',' ',1,001,125,t%lev,105,0,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('TS_WATER        ',' ',' ',1,001,011,t%lev,105,0,'TS_WATER','')
i = i + 1
trans_tab( i ) = trans('Z0WATER         ',' ',' ',1,001,083,t%lev,105,0,'Roughness length (water)','')
i = i + 1
trans_tab( i ) = trans('Z0_WAT          ',' ',' ',1,001,083,t%lev+1,105,0,'Roughness length (water)','')
i = i + 1
trans_tab( i ) = trans('Z0H_WAT         ',' ',' ',1,001,083,t%lev+2,105,0,'Thermal roughness length (water)','')
i = i + 1
trans_tab( i ) = trans('SWDC_WAT         ',' ',' ',1,001,117,t%lev,105,4,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT         ',' ',' ',1,001,117,t%lev,105,0,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWDC_WAT         ',' ',' ',1,001,118,t%lev,105,4,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWD_WAT         ',' ',' ',1,001,118,t%lev,105,0,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWUC_WAT         ',' ',' ',1,001,119,t%lev,105,4,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT         ',' ',' ',1,001,119,t%lev,105,0,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWUC_WAT         ',' ',' ',1,001,120,t%lev,105,4,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWU_WAT         ',' ',' ',1,001,120,t%lev,105,0,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWDC_WAT_1      ',' ',' ',1,001,117,t%lev+1,105,4,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT_1      ',' ',' ',1,001,117,t%lev+1,105,0,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWDC_WAT_2      ',' ',' ',1,001,117,t%lev+2,105,4,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT_2      ',' ',' ',1,001,117,t%lev+2,105,0,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWDC_WAT_3      ',' ',' ',1,001,117,t%lev+3,105,4,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT_3      ',' ',' ',1,001,117,t%lev+3,105,0,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWDC_WAT_4      ',' ',' ',1,001,117,t%lev+4,105,4,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT_4      ',' ',' ',1,001,117,t%lev+4,105,0,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWDC_WAT_5      ',' ',' ',1,001,117,t%lev+5,105,4,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT_5      ',' ',' ',1,001,117,t%lev+5,105,0,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_WAT_6      ',' ',' ',1,001,117,t%lev+6,105,0,'SW down band 6','')
i = i + 1
trans_tab( i ) = trans('SWUC_WAT_1      ',' ',' ',1,001,119,t%lev+1,105,4,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT_1      ',' ',' ',1,001,119,t%lev+1,105,0,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWUC_WAT_2      ',' ',' ',1,001,119,t%lev+2,105,4,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT_2      ',' ',' ',1,001,119,t%lev+2,105,0,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWUC_WAT_3      ',' ',' ',1,001,119,t%lev+3,105,4,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT_3      ',' ',' ',1,001,119,t%lev+3,105,0,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWUC_WAT_4      ',' ',' ',1,001,119,t%lev+4,105,4,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT_4      ',' ',' ',1,001,119,t%lev+4,105,0,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWUC_WAT_5      ',' ',' ',1,001,119,t%lev+5,105,4,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT_5      ',' ',' ',1,001,119,t%lev+5,105,0,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_WAT_6      ',' ',' ',1,001,119,t%lev+6,105,0,'SW up band 6','')


!
! ISBA
!

t%lev = 800

i = i + 1
trans_tab( i ) = trans('RI_ISBA          ',' ',' ',1,001,001,t%lev,105,0,'Ri num isba','')
i = i + 1
trans_tab( i ) = trans('RNC_ISBA          ',' ',' ',1,001,002,t%lev,105,4,'Net radiation isba','')
i = i + 1
trans_tab( i ) = trans('RN_ISBA          ',' ',' ',1,001,002,t%lev,105,0,'Net radiation isba','')
i = i + 1
trans_tab( i ) = trans('HC_ISBA           ',' ',' ',1,001,122,t%lev,105,4,'Sens heat flux isba','')
i = i + 1
trans_tab( i ) = trans('H_ISBA           ',' ',' ',1,001,122,t%lev,105,0,'Sens heat flux isba','')
i = i + 1
trans_tab( i ) = trans('LEC_ISBA          ',' ',' ',1,001,121,t%lev,105,4,'Latent heat flux isba','')
i = i + 1
trans_tab( i ) = trans('LE_ISBA          ',' ',' ',1,001,121,t%lev,105,0,'Latent heat flux isba','')
i = i + 1
trans_tab( i ) = trans('GFLUXC_ISBA       ',' ',' ',1,001,005,t%lev,105,4,'Conduct flux isba','')
i = i + 1
trans_tab( i ) = trans('GFLUX_ISBA       ',' ',' ',1,001,005,t%lev,105,0,'Conduct flux isba','')
i = i + 1
trans_tab( i ) = trans('CD_ISBA          ',' ',' ',1,001,006,t%lev,105,0,'Drag coefficient for momentum (isba)','')
i = i + 1
trans_tab( i ) = trans('CH_ISBA          ',' ',' ',1,001,007,t%lev,105,0,'Drag coefficient for heat (isba)','')
i = i + 1
trans_tab( i ) = trans('CE_ISBA          ',' ',' ',1,001,008,t%lev,105,0,'Drag coefficient for evaporation (isba)','')
i = i + 1
trans_tab( i ) = trans('T2M_ISBA         ',' ',' ',1,001,011,t%lev+2,105,0,'T2m isba','')
i = i + 1
trans_tab( i ) = trans('HU2M_ISBA       ',' ',' ',1,001,052,t%lev+2,105,0,'RH2m','')
i = i + 1
trans_tab( i ) = trans('Q2M_ISBA         ',' ',' ',1,001,051,t%lev+2,105,0,'Q2m isba','')
i = i + 1
trans_tab( i ) = trans('MER10M_ISBA      ',' ',' ',1,001,034,t%lev,105,0,'V10m isba','')
i = i + 1
trans_tab( i ) = trans('ZON10M_ISBA      ',' ',' ',1,001,033,t%lev,105,0,'U10m isba','')
i = i + 1
trans_tab( i ) = trans('FMUC_ISBA        ',' ',' ',1,001,124,t%lev,105,4,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMU_ISBA        ',' ',' ',1,001,124,t%lev,105,0,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMVC_ISBA        ',' ',' ',1,001,125,t%lev,105,4,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('FMV_ISBA        ',' ',' ',1,001,125,t%lev,105,0,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('Z0_ISBA         ',' ',' ',1,001,083,t%lev,105,0,'Roughness length (isba)','')
i = i + 1
trans_tab( i ) = trans('Z0H_ISBA        ',' ',' ',1,001,083,t%lev+1,105,0,'Thermal roughness length (isba)','')
i = i + 1
trans_tab( i ) = trans('SWDC_ISBA        ',' ',' ',1,001,117,t%lev,105,4,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA        ',' ',' ',1,001,117,t%lev,105,0,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWDC_ISBA        ',' ',' ',1,001,118,t%lev,105,4,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWD_ISBA        ',' ',' ',1,001,118,t%lev,105,0,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWUC_ISBA        ',' ',' ',1,001,119,t%lev,105,4,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA        ',' ',' ',1,001,119,t%lev,105,0,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWUC_ISBA        ',' ',' ',1,001,120,t%lev,105,4,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWU_ISBA        ',' ',' ',1,001,120,t%lev,105,0,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('TG1             ',' ',' ',1,001,011,t%lev,105,0,'Surface temperature (isba)','')
i = i + 1
trans_tab( i ) = trans('TG2             ',' ',' ',1,001,011,t%lev+1,105,0,'Deep soil temperature (isba)','')
i = i + 1
trans_tab( i ) = trans('TG3             ',' ',' ',1,001,011,t%lev+3,105,0,'Third layer temperature (isba)','')
i = i + 1
trans_tab( i ) = trans('WG1             ',' ',' ',1,001,086,t%lev,105,0,'Sfc liq. vol. wat. cont. (isba)','')
i = i + 1
trans_tab( i ) = trans('WG2             ',' ',' ',1,001,086,t%lev+1,105,0,'Root liq. vol. wat. cont. (isba)','')
i = i + 1
trans_tab( i ) = trans('WG3             ',' ',' ',1,001,086,t%lev+2,105,0,'Deep liq. vol. wat. cont. (isba)','')
i = i + 1
trans_tab( i ) = trans('WGI1            ',' ',' ',1,001,193,t%lev,105,0,'Sfc frozen vol. wat. cont. (isba)','')
i = i + 1
trans_tab( i ) = trans('WGI2            ',' ',' ',1,001,193,t%lev+1,105,0,'Root frozen vol. wat. cont. (isba)','')
i = i + 1
trans_tab( i ) = trans('WGI3            ',' ',' ',1,001,193,t%lev+2,105,0,'3rd layer frozen vol. wat. cont. (isba)','')
i = i + 1
trans_tab( i ) = trans('WR              ',' ',' ',1,001,012,t%lev,105,0,'Liq wat. retained by foliage (isba)','')
i = i + 1
trans_tab( i ) = trans('WSNOW_VEG1      ',' ',' ',1,001,013,t%lev,105,0,'1st layer snow wat. eq. (isba)','')
i = i + 1
trans_tab( i ) = trans('RSNOW_VEG1      ',' ',' ',1,001,191,t%lev,105,0,'1st layer snow density (isba)','')
i = i + 1
trans_tab( i ) = trans('TSNOW_VEG1      ',' ',' ',1,001,011,t%lev,105,0,'1st layer snow temperature (isba)','')
i = i + 1
trans_tab( i ) = trans('HSNOW_VEG1      ',' ',' ',1,001,015,t%lev,105,0,'1st layer snow heat content (isba)','')
i = i + 1
trans_tab( i ) = trans('WSNOW_VEG2      ',' ',' ',1,001,013,t%lev+1,105,0,'2nd layer snow water equivalent (isba)','')
i = i + 1
trans_tab( i ) = trans('RSNOW_VEG2      ',' ',' ',1,001,191,t%lev+1,105,0,'2nd layer snow density (isba)','')
i = i + 1
trans_tab( i ) = trans('HSNOW_VEG2      ',' ',' ',1,001,015,t%lev+1,105,0,'2nd layer snow heat content (isba)','')
i = i + 1
trans_tab( i ) = trans('WSNOW_VEG3      ',' ',' ',1,001,013,t%lev+2,105,0,'3rd layer snow water equivalent (isba)','')
i = i + 1
trans_tab( i ) = trans('RSNOW_VEG3      ',' ',' ',1,001,191,t%lev+2,105,0,'3rd layer snow density (isba)','')
i = i + 1
trans_tab( i ) = trans('HSNOW_VEG3      ',' ',' ',1,001,015,t%lev+2,105,0,'3rd layer snow heat content (isba)','')
i = i + 1
trans_tab( i ) = trans('ASNOW_VEG       ',' ',' ',1,001,190,t%lev,105,0,'Snow albedo (isba)','')
i = i + 1
trans_tab( i ) = trans('PSNG_ISBA       ',' ',' ',1,001,055,t%lev,105,0,'Snow fraction over ground','')
i = i + 1
trans_tab( i ) = trans('PSNV_ISBA       ',' ',' ',1,001,056,t%lev,105,0,'Snow fraction over veg','')
i = i + 1
trans_tab( i ) = trans('PSN_ISBA        ',' ',' ',1,001,057,t%lev,105,0,'Snow fraction total','')
i = i + 1
trans_tab( i ) = trans('TALB_ISBA       ',' ',' ',1,001,084,t%lev,105,0,'Total albedo','')
i = i + 1
trans_tab( i ) = trans('EMIS_ISBA       ',' ',' ',1,001,021,t%lev,105,0,'Surface emissivity (isba)','')
i = i + 1
trans_tab( i ) = trans('RESA            ',' ',' ',1,001,016,t%lev,105,0,'Aerodynamic resistence (isba)','')
i = i + 1
trans_tab( i ) = trans('SWDC_ISBA_1      ',' ',' ',1,001,117,t%lev+1,105,4,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA_1      ',' ',' ',1,001,117,t%lev+1,105,0,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWDC_ISBA_2      ',' ',' ',1,001,117,t%lev+2,105,4,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA_2      ',' ',' ',1,001,117,t%lev+2,105,0,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWDC_ISBA_3      ',' ',' ',1,001,117,t%lev+3,105,4,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA_3      ',' ',' ',1,001,117,t%lev+3,105,0,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWDC_ISBA_4      ',' ',' ',1,001,117,t%lev+4,105,4,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA_4      ',' ',' ',1,001,117,t%lev+4,105,0,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWDC_ISBA_5      ',' ',' ',1,001,117,t%lev+5,105,4,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA_5      ',' ',' ',1,001,117,t%lev+5,105,0,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_ISBA_6      ',' ',' ',1,001,117,t%lev+6,105,0,'SW down band 6','')
i = i + 1
trans_tab( i ) = trans('SWUC_ISBA_1      ',' ',' ',1,001,119,t%lev+1,105,4,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA_1      ',' ',' ',1,001,119,t%lev+1,105,0,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWUC_ISBA_2      ',' ',' ',1,001,119,t%lev+2,105,4,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA_2      ',' ',' ',1,001,119,t%lev+2,105,0,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWUC_ISBA_3      ',' ',' ',1,001,119,t%lev+3,105,4,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA_3      ',' ',' ',1,001,119,t%lev+3,105,0,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWUC_ISBA_4      ',' ',' ',1,001,119,t%lev+4,105,4,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA_4      ',' ',' ',1,001,119,t%lev+4,105,0,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWUC_ISBA_5      ',' ',' ',1,001,119,t%lev+5,105,4,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA_5      ',' ',' ',1,001,119,t%lev+5,105,0,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_ISBA_6      ',' ',' ',1,001,119,t%lev+6,105,0,'SW up band 6','')
i = i + 1
trans_tab( i ) = trans('RUNOFF_ISBA     ',' ',' ',1,001,128,t%lev,105,0,'Runoff','')
i = i + 1
trans_tab( i ) = trans('DRAIN_ISBA      ',' ',' ',1,001,129,t%lev+1,105,0,'Drainage - exceedence of field capacity','')
i = i + 1
trans_tab( i ) = trans('SNOMLT_ISBA     ',' ',' ',1,001,099,t%lev,105,0,'Snow melt','')

!
! Town Energy Balance model
!

 t%lev = 950
i = i + 1
trans_tab( i ) = trans('CD_TEB          ',' ',' ',1,001,006,t%lev,105,0,'Drag coefficient for momentum (teb)','')
i = i + 1
trans_tab( i ) = trans('CH_TEB          ',' ',' ',1,001,007,t%lev,105,0,'Drag coefficient for heat (teb)','')
i = i + 1
trans_tab( i ) = trans('CE_TEB          ',' ',' ',1,001,008,t%lev,105,0,'Drag coefficient for evaporation (teb)','')
i = i + 1
trans_tab( i ) = trans('T_ROOF1         ',' ',' ',1,001,017,t%lev,105,0,'T_ROOF1','')
i = i + 1
trans_tab( i ) = trans('T_ROOF2         ',' ',' ',1,001,018,t%lev,105,0,'T_ROOF2','')
i = i + 1
trans_tab( i ) = trans('T_ROOF3         ',' ',' ',1,001,019,t%lev,105,0,'T_ROOF3','')
i = i + 1
trans_tab( i ) = trans('WS_ROOF         ',' ',' ',1,001,020,t%lev,105,0,'WS_ROOF','')
i = i + 1
trans_tab( i ) = trans('T_ROAD1         ',' ',' ',1,001,021,t%lev,105,0,'T_ROAD1','')
i = i + 1
trans_tab( i ) = trans('T_ROAD2         ',' ',' ',1,001,022,t%lev,105,0,'T_ROAD2','')
i = i + 1
trans_tab( i ) = trans('T_ROAD3         ',' ',' ',1,001,023,t%lev,105,0,'T_ROAD3','')
i = i + 1
trans_tab( i ) = trans('WS_ROAD         ',' ',' ',1,001,024,t%lev,105,0,'WS_ROAD','')
i = i + 1
trans_tab( i ) = trans('T_WALL1         ',' ',' ',1,001,025,t%lev,105,0,'T_WALL1','')
i = i + 1
trans_tab( i ) = trans('T_WALL2         ',' ',' ',1,001,026,t%lev,105,0,'T_WALL2','')
i = i + 1
trans_tab( i ) = trans('T_WALL3         ',' ',' ',1,001,027,t%lev,105,0,'T_WALL3','')
i = i + 1
trans_tab( i ) = trans('TI_BLD          ',' ',' ',1,001,028,t%lev,105,0,'TI_BLD','')
i = i + 1
trans_tab( i ) = trans('TI_ROAD         ',' ',' ',1,001,029,t%lev,105,0,'TI_ROAD','')
i = i + 1
trans_tab( i ) = trans('WSNOW_ROOF1     ',' ',' ',1,001,030,t%lev,105,0,'WSNOW_ROOF1','')
i = i + 1
trans_tab( i ) = trans('RSNOW_ROOF1     ',' ',' ',1,001,031,t%lev,105,0,'RSNOW_ROOF1','')
i = i + 1
trans_tab( i ) = trans('TSNOW_ROOF1     ',' ',' ',1,001,032,t%lev,105,0,'TSNOW_ROOF1','')
i = i + 1
trans_tab( i ) = trans('ASNOW_ROOF      ',' ',' ',1,001,233,t%lev,105,0,'ASNOW_ROOF','')
i = i + 1
trans_tab( i ) = trans('WSNOW_ROAD1     ',' ',' ',1,001,234,t%lev,105,0,'WSNOW_ROAD1','')
i = i + 1
trans_tab( i ) = trans('RSNOW_ROAD1     ',' ',' ',1,001,035,t%lev,105,0,'RSNOW_ROAD1','')
i = i + 1
trans_tab( i ) = trans('TSNOW_ROAD1     ',' ',' ',1,001,036,t%lev,105,0,'TSNOW_ROAD1','')
i = i + 1
trans_tab( i ) = trans('ASNOW_ROAD      ',' ',' ',1,001,037,t%lev,105,0,'ASNOW_ROAD','')
i = i + 1
trans_tab( i ) = trans('T_CANYON        ',' ',' ',1,001,038,t%lev,105,0,'T_CANYON','')
i = i + 1
trans_tab( i ) = trans('Q_CANYON        ',' ',' ',1,001,039,t%lev,105,0,'Q_CANYON','')
i = i + 1
trans_tab( i ) = trans('RI_TEB          ',' ',' ',1,001,001,t%lev,105,0,'Ri num town','')
i = i + 1
trans_tab( i ) = trans('RNC_TEB          ',' ',' ',1,001,002,t%lev,105,4,'Net radiation town','')
i = i + 1
trans_tab( i ) = trans('RN_TEB          ',' ',' ',1,001,002,t%lev,105,0,'Net radiation town','')
i = i + 1
trans_tab( i ) = trans('HC_TEB           ',' ',' ',1,001,122,t%lev,105,4,'Sens heat flux town','')
i = i + 1
trans_tab( i ) = trans('H_TEB           ',' ',' ',1,001,122,t%lev,105,0,'Sens heat flux town','')
i = i + 1
trans_tab( i ) = trans('LEC_TEB          ',' ',' ',1,001,121,t%lev,105,4,'Latent heat flux town','')
i = i + 1
trans_tab( i ) = trans('LE_TEB          ',' ',' ',1,001,121,t%lev,105,0,'Latent heat flux town','')
i = i + 1
trans_tab( i ) = trans('GFLUXC_TEB       ',' ',' ',1,001,005,t%lev,105,4,'Conduct flux town','')
i = i + 1
trans_tab( i ) = trans('GFLUX_TEB       ',' ',' ',1,001,005,t%lev,105,0,'Conduct flux town','')
i = i + 1
trans_tab( i ) = trans('T2M_TEB         ',' ',' ',1,001,011,t%lev,105,0,'T2m town','')
i = i + 1
trans_tab( i ) = trans('HU2M_TEB        ',' ',' ',1,001,052,t%lev,105,0,'RH2m','')
i = i + 1
trans_tab( i ) = trans('Q2M_TEB         ',' ',' ',1,001,051,t%lev,105,0,'Q2m town','')
i = i + 1
trans_tab( i ) = trans('MER10M_TEB      ',' ',' ',1,001,034,t%lev,105,0,'V10m town','')
i = i + 1
trans_tab( i ) = trans('ZON10M_TEB      ',' ',' ',1,001,033,t%lev,105,0,'U10m town','')
i = i + 1
trans_tab( i ) = trans('FMUC_TEB         ',' ',' ',1,001,124,t%lev,105,4,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMU_TEB         ',' ',' ',1,001,124,t%lev,105,0,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMVC_TEB         ',' ',' ',1,001,125,t%lev,105,4,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('FMV_TEB         ',' ',' ',1,001,125,t%lev,105,0,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('Z0_TEB          ',' ',' ',1,001,083,t%lev,105,0,'Roughness length (teb)','')
i = i + 1
trans_tab( i ) = trans('Z0H_TEB         ',' ',' ',1,001,083,t%lev+1,105,0,'Thermal roughness length (teb)','')
i = i + 1
trans_tab( i ) = trans('SWDC_TEB         ',' ',' ',1,001,117,t%lev,105,4,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB         ',' ',' ',1,001,117,t%lev,105,0,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWDC_TEB         ',' ',' ',1,001,118,t%lev,105,4,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWD_TEB         ',' ',' ',1,001,118,t%lev,105,0,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWUC_TEB         ',' ',' ',1,001,119,t%lev,105,4,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB         ',' ',' ',1,001,119,t%lev,105,0,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWUC_TEB         ',' ',' ',1,001,120,t%lev,105,4,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWU_TEB         ',' ',' ',1,001,120,t%lev,105,0,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWDC_TEB_1       ',' ',' ',1,001,117,t%lev+1,105,4,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB_1       ',' ',' ',1,001,117,t%lev+1,105,0,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWDC_TEB_2       ',' ',' ',1,001,117,t%lev+2,105,4,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB_2       ',' ',' ',1,001,117,t%lev+2,105,0,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWDC_TEB_3       ',' ',' ',1,001,117,t%lev+3,105,4,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB_3       ',' ',' ',1,001,117,t%lev+3,105,0,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWDC_TEB_4       ',' ',' ',1,001,117,t%lev+4,105,4,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB_4       ',' ',' ',1,001,117,t%lev+4,105,0,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWDC_TEB_5       ',' ',' ',1,001,117,t%lev+5,105,4,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB_5       ',' ',' ',1,001,117,t%lev+5,105,0,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_TEB_6       ',' ',' ',1,001,117,t%lev+6,105,0,'SW down band 6','')
i = i + 1
trans_tab( i ) = trans('SWUC_TEB_1       ',' ',' ',1,001,119,t%lev+1,105,4,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB_1       ',' ',' ',1,001,119,t%lev+1,105,0,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWUC_TEB_2       ',' ',' ',1,001,119,t%lev+2,105,4,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB_2       ',' ',' ',1,001,119,t%lev+2,105,0,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWUC_TEB_3       ',' ',' ',1,001,119,t%lev+3,105,4,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB_3       ',' ',' ',1,001,119,t%lev+3,105,0,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWUC_TEB_4       ',' ',' ',1,001,119,t%lev+4,105,4,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB_4       ',' ',' ',1,001,119,t%lev+4,105,0,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWUC_TEB_5       ',' ',' ',1,001,119,t%lev+5,105,4,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB_5       ',' ',' ',1,001,119,t%lev+5,105,0,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_TEB_6       ',' ',' ',1,001,119,t%lev+6,105,0,'SW up band 6','')

!
! Patch is ????????
!

 t%lev = 790
i = i + 1
trans_tab( i ) = trans('RI_PATCH          ',' ',' ',1,001,001,t%lev,105,0,'Ri num patch','')
i = i + 1
trans_tab( i ) = trans('RNC_PATCH          ',' ',' ',1,001,002,t%lev,105,4,'Net radiation patch','')
i = i + 1
trans_tab( i ) = trans('RN_PATCH          ',' ',' ',1,001,002,t%lev,105,0,'Net radiation patch','')
i = i + 1
trans_tab( i ) = trans('HC_PATCH           ',' ',' ',1,001,122,t%lev,105,4,'Sens heat flux patch','')
i = i + 1
trans_tab( i ) = trans('H_PATCH           ',' ',' ',1,001,122,t%lev,105,0,'Sens heat flux patch','')
i = i + 1
trans_tab( i ) = trans('LEC_PATCH          ',' ',' ',1,001,121,t%lev,105,4,'Latent heat flux patch','')
i = i + 1
trans_tab( i ) = trans('LE_PATCH          ',' ',' ',1,001,121,t%lev,105,0,'Latent heat flux patch','')
i = i + 1
trans_tab( i ) = trans('GFLUXC_PATCH       ',' ',' ',1,001,005,t%lev,105,4,'Conduct flux patch','')
i = i + 1
trans_tab( i ) = trans('GFLUX_PATCH       ',' ',' ',1,001,005,t%lev,105,0,'Conduct flux patch','')
i = i + 1
trans_tab( i ) = trans('T2M_PATCH         ',' ',' ',1,001,011,t%lev,105,0,'T2m patch','')
i = i + 1
trans_tab( i ) = trans('Q2M_PATCH         ',' ',' ',1,001,051,t%lev,105,0,'Q2m patch','')
i = i + 1
trans_tab( i ) = trans('MER10M_PATCH      ',' ',' ',1,001,034,t%lev,105,0,'V10m patch','')
i = i + 1
trans_tab( i ) = trans('ZON10M_PATCH      ',' ',' ',1,001,033,t%lev,105,0,'U10m patch','')

!
! Gridpoint average
!

t%lev = 810

i = i + 1
trans_tab( i ) = trans('RI                ',' ',' ',1,001,001,t%lev,105,0,'Ri num','')
i = i + 1
trans_tab( i ) = trans('RNC                ',' ',' ',1,001,002,t%lev,105,4,'Net radiation','')
i = i + 1
trans_tab( i ) = trans('RN                ',' ',' ',1,001,002,t%lev,105,0,'Net radiation','')
i = i + 1
trans_tab( i ) = trans('HC                 ',' ',' ',1,001,122,000,105,4,'Sens heat flux','')
i = i + 1
trans_tab( i ) = trans('H                 ',' ',' ',1,001,122,000,105,0,'Sens heat flux','')
i = i + 1
trans_tab( i ) = trans('LEC                ',' ',' ',1,001,121,000,105,4,'Latent heat flux','')
i = i + 1
trans_tab( i ) = trans('LE                ',' ',' ',1,001,121,000,105,0,'Latent heat flux','')
i = i + 1
trans_tab( i ) = trans('GFLUXC             ',' ',' ',1,001,005,t%lev,105,4,'Conduct flux','')
i = i + 1
trans_tab( i ) = trans('GFLUX             ',' ',' ',1,001,005,t%lev,105,0,'Conduct flux','')
i = i + 1
trans_tab( i ) = trans('CD                ',' ',' ',1,001,006,t%lev,105,0,'Drag coefficient for momentum','')
i = i + 1
trans_tab( i ) = trans('CH                ',' ',' ',1,001,007,t%lev,105,0,'Drag coefficient for heat','')
i = i + 1
trans_tab( i ) = trans('CE                ',' ',' ',1,001,008,t%lev,105,0,'Drag coefficient for evaporation','')
i = i + 1
trans_tab( i ) = trans('EMIS              ',' ',' ',1,001,021,t%lev,105,0,'Surface emissivity','')
i = i + 1
trans_tab( i ) = trans('T2M               ',' ',' ',1,001,011,002,105,0,'T2m','')
i = i + 1
trans_tab( i ) = trans('HU2M               ',' ',' ',1,001,052,002,105,0,'RH2m','')
i = i + 1
trans_tab( i ) = trans('Q2M               ',' ',' ',1,001,051,002,105,0,'Q2m','')
i = i + 1
trans_tab( i ) = trans('MER10M            ',' ',' ',1,001,034,010,105,0,'V10m','')
i = i + 1
trans_tab( i ) = trans('ZON10M            ',' ',' ',1,001,033,010,105,0,'U10m','')
i = i + 1
trans_tab( i ) = trans('FMUC               ',' ',' ',1,001,124,000,105,4,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMU               ',' ',' ',1,001,124,000,105,0,'Momentum flux U-comp','')
i = i + 1
trans_tab( i ) = trans('FMVC               ',' ',' ',1,001,125,000,105,4,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('FMV               ',' ',' ',1,001,125,000,105,0,'Momentum flux V-comp','')
i = i + 1
trans_tab( i ) = trans('Z0                ',' ',' ',1,001,083,t%lev,105,0,'Roughness length','')
i = i + 1
trans_tab( i ) = trans('Z0H               ',' ',' ',1,001,083,t%lev+1,105,0,'Thermal roughness length','')
i = i + 1
trans_tab( i ) = trans('SWDC               ',' ',' ',1,001,117,000,105,4,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWD               ',' ',' ',1,001,117,000,105,0,'Surface down SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWDC               ',' ',' ',1,001,118,000,105,4,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWD               ',' ',' ',1,001,118,000,105,0,'Surface down LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWUC               ',' ',' ',1,001,119,000,105,4,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('SWU               ',' ',' ',1,001,119,000,105,0,'Surface up SW radiation','')
i = i + 1
trans_tab( i ) = trans('LWUC               ',' ',' ',1,001,120,000,105,4,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('LWU               ',' ',' ',1,001,120,000,105,0,'Surface up LW radiation','')
i = i + 1
trans_tab( i ) = trans('SWDC_1             ',' ',' ',1,001,117,001,105,4,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWD_1             ',' ',' ',1,001,117,001,105,0,'SW down band 1','')
i = i + 1
trans_tab( i ) = trans('SWDC_2             ',' ',' ',1,001,117,002,105,4,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWD_2             ',' ',' ',1,001,117,002,105,0,'SW down band 2','')
i = i + 1
trans_tab( i ) = trans('SWDC_3             ',' ',' ',1,001,117,003,105,4,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWD_3             ',' ',' ',1,001,117,003,105,0,'SW down band 3','')
i = i + 1
trans_tab( i ) = trans('SWDC_4             ',' ',' ',1,001,117,004,105,4,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWD_4             ',' ',' ',1,001,117,004,105,0,'SW down band 4','')
i = i + 1
trans_tab( i ) = trans('SWDC_5             ',' ',' ',1,001,117,005,105,4,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_5             ',' ',' ',1,001,117,005,105,0,'SW down band 5','')
i = i + 1
trans_tab( i ) = trans('SWD_6             ',' ',' ',1,001,117,006,105,0,'SW down band 6','')
i = i + 1
trans_tab( i ) = trans('SWUC_1             ',' ',' ',1,001,119,001,105,4,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWU_1             ',' ',' ',1,001,119,001,105,0,'SW up band 1','')
i = i + 1
trans_tab( i ) = trans('SWUC_2             ',' ',' ',1,001,119,002,105,4,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWU_2             ',' ',' ',1,001,119,002,105,0,'SW up band 2','')
i = i + 1
trans_tab( i ) = trans('SWUC_3             ',' ',' ',1,001,119,003,105,4,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWU_3             ',' ',' ',1,001,119,003,105,0,'SW up band 3','')
i = i + 1
trans_tab( i ) = trans('SWUC_4             ',' ',' ',1,001,119,004,105,4,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWU_4             ',' ',' ',1,001,119,004,105,0,'SW up band 4','')
i = i + 1
trans_tab( i ) = trans('SWUC_5             ',' ',' ',1,001,119,005,105,4,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_5             ',' ',' ',1,001,119,005,105,0,'SW up band 5','')
i = i + 1
trans_tab( i ) = trans('SWU_6             ',' ',' ',1,001,119,006,105,0,'SW up band 6','')
i = i + 1
trans_tab( i ) = trans('RUNOFF            ',' ',' ',1,001,128,t%lev,105,0,'Runoff','')
i = i + 1
trans_tab( i ) = trans('DRAIN             ',' ',' ',1,001,129,t%lev+1,105,0,'Drainage - exceedence of field capacity','')
i = i + 1
trans_tab( i ) = trans('SNOMLT            ',' ',' ',1,001,099,t%lev,105,0,'Snow melt','')

! Extra yet unknown SURFEX variables
i = i + 1
trans_tab( i ) = trans('LAI               ',' ',' ',1,001,001,300,105,0,'Leaf area index','')
i = i + 1
trans_tab( i ) = trans('VEG               ',' ',' ',1,001,002,300,105,0,'Vegetation fraction',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P1        ',' ',' ',1,001,003,300,105,0,'Fraction of vegetation type 1',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P2        ',' ',' ',1,001,004,300,105,0,'Fraction of vegetation type 2',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P3        ',' ',' ',1,001,005,300,105,0,'Fraction of vegetation type 3',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P4        ',' ',' ',1,001,006,300,105,0,'Fraction of vegetation type 4',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P5        ',' ',' ',1,001,007,300,105,0,'Fraction of vegetation type 5',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P6        ',' ',' ',1,001,008,300,105,0,'Fraction of vegetation type 6',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P7        ',' ',' ',1,001,009,300,105,0,'Fraction of vegetation type 7',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P8        ',' ',' ',1,001,010,300,105,0,'Fraction of vegetation type 8',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P9        ',' ',' ',1,001,011,300,105,0,'Fraction of vegetation type 9',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P10       ',' ',' ',1,001,012,300,105,0,'Fraction of vegetation type 10',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P11       ',' ',' ',1,001,013,300,105,0,'Fraction of vegetation type 11',frac)
i = i + 1
trans_tab( i ) = trans('VEGTYPE_P12       ',' ',' ',1,001,014,300,105,0,'Fraction of vegetation type 12',frac)
i = i + 1
trans_tab( i ) = trans('Z0REL             ',' ',' ',1,001,016,300,105,0,'Orographic roughness','')
i = i + 1
trans_tab( i ) = trans('RSMIN             ',' ',' ',1,001,017,300,105,0,'Min stomatal res','')
i = i + 1
trans_tab( i ) = trans('GAMMA             ',' ',' ',1,001,018,300,105,0,'Coef for RSMIN calc','')
i = i + 1
trans_tab( i ) = trans('CV                ',' ',' ',1,001,019,300,105,0,'Veg thermal inertia coef','')
i = i + 1
trans_tab( i ) = trans('RGL               ',' ',' ',1,001,020,300,105,0,'Max solar rad for photosynthesis','')
i = i + 1
trans_tab( i ) = trans('WRMAX_CF          ',' ',' ',1,001,022,300,105,0,'Coef for max water interception','')
i = i + 1
trans_tab( i ) = trans('DG1               ',' ',' ',1,001,023,300,105,0,'Soil depth',hgt)
i = i + 1
trans_tab( i ) = trans('DG2               ',' ',' ',1,001,024,300,105,0,'Soil depth',hgt)
i = i + 1
trans_tab( i ) = trans('DG3               ',' ',' ',1,001,025,300,105,0,'Soil depth',hgt)
i = i + 1
trans_tab( i ) = trans('ALBNIR_SOIL       ',' ',' ',1,001,026,300,105,0,'Soil near-IR albedo',frac)
i = i + 1
trans_tab( i ) = trans('ALBVIS_SOIL       ',' ',' ',1,001,027,300,105,0,'Soil vis albedo',frac)
i = i + 1
trans_tab( i ) = trans('ALBUV_SOIL        ',' ',' ',1,001,028,300,105,0,'Soil UV albedo',frac)
i = i + 1
trans_tab( i ) = trans('ALBNIR_ISBA       ',' ',' ',1,001,029,300,105,0,'Total near-IR albedo',frac)
i = i + 1
trans_tab( i ) = trans('ALBVIS_ISBA       ',' ',' ',1,001,030,300,105,0,'Total vis albedo',frac)
i = i + 1
trans_tab( i ) = trans('ALBUV_ISBA        ',' ',' ',1,001,031,300,105,0,'Total UV albedo',frac)
i = i + 1
trans_tab( i ) = trans('FRAC_SEA          ',' ',' ',1,001,032,300,105,0,'Fraction of sea',frac)
i = i + 1
trans_tab( i ) = trans('FRAC_WATER        ',' ',' ',1,001,033,300,105,0,'Fraction of water',frac)
i = i + 1
trans_tab( i ) = trans('FRAC_NATURE       ',' ',' ',1,001,034,300,105,0,'Fraction of nature',frac)
i = i + 1
trans_tab( i ) = trans('FRAC_TOWN         ',' ',' ',1,001,035,300,105,0,'Fraction of town',frac)
!------------------
