!     #########
      SUBROUTINE WRITESURF_SEAFLUX_n(HPROGRAM,HWRITE)
!     ########################################
!
!!****  *WRITE_SEAFLUX_n* - writes SEAFLUX fields
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003
!!      Y. Batrak   04/2014 Write sea ice prognostics to output files.
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_SEAFLUX_n,      ONLY : XSST, XZ0, TTIME,        &
                                LINTERPOL_SST, XSST_MTH, &
                                CSEA_ICE, NICE_LAYER, XICE, XSIC, LHANDLE_SIC, LSIC_FROM_FILE
!
USE MODI_WRITE_SURF
USE MODI_WRITESURF_OCEAN_n

USE ABSTRACT_MODEL, ONLY: MODEL_FIELD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
CHARACTER(LEN=6),    INTENT(IN)  :: HPROGRAM  ! program calling
CHARACTER(LEN=3),    INTENT(IN)  :: HWRITE    ! 'PREP' : does not write TICE XUNDEF fields

!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: JMTH, INMTH, JLAYER
CHARACTER(LEN=2 ) :: YMTH
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=16) :: YRECFM         ! Name of the article to be read
CHARACTER(LEN=4 ) :: YLVL
CHARACTER(LEN=100):: YCOMMENT       ! Comment string
CHARACTER(LEN=25) :: YFORM          ! Writing format

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_SEAFLUX_N',0,ZHOOK_HANDLE)
CALL WRITESURF_OCEAN_n(HPROGRAM)
!
!*       3.     Prognostic fields:
!               -----------------
!
!* water temperature
!
IF(LINTERPOL_SST)THEN
!
  INMTH=SIZE(XSST_MTH,2)
!
  DO JMTH=1,INMTH
     WRITE(YMTH,'(I2)') (JMTH-1)
     YRECFM='SST_MTH'//ADJUSTL(YMTH(:LEN_TRIM(YMTH)))
     YCOMMENT='SST month t'//ADJUSTL(YMTH(:LEN_TRIM(YMTH)))
     CALL WRITE_SURF(HPROGRAM,YRECFM,XSST_MTH(:,JMTH),IRESP,HCOMMENT=YCOMMENT)
  ENDDO
!
ENDIF

IF (LHANDLE_SIC .AND. LSIC_FROM_FILE) THEN
  YRECFM   = 'SIC'
  YCOMMENT = 'SIC'
  CALL WRITE_SURF(HPROGRAM,YRECFM,XSIC(:),IRESP,HCOMMENT = YCOMMENT)
END IF

!
YRECFM   = 'SST'
YCOMMENT = 'SST'
CALL WRITE_SURF(HPROGRAM,YRECFM,XSST(:),IRESP,HCOMMENT=YCOMMENT)
!
!* Sea ice temperature
call XICE%IO( XICE%MF, HPROGRAM )
!
!-------------------------------------------------------------------------------
!
!*       4.     Semi-prognostic fields:
!               ----------------------
!
!* roughness length
!
YRECFM='Z0SEA'
YCOMMENT='Z0SEA (m)'
CALL WRITE_SURF(HPROGRAM,YRECFM,XZ0(:),IRESP,HCOMMENT=YCOMMENT)
!
!-------------------------------------------------------------------------------
!
!*       5.  Time
!            ----
!
YRECFM='DTCUR'
YCOMMENT='s'
CALL WRITE_SURF(HPROGRAM,YRECFM,TTIME,IRESP,HCOMMENT=YCOMMENT)
IF (LHOOK) CALL DR_HOOK('WRITESURF_SEAFLUX_N',1,ZHOOK_HANDLE)
!
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_SEAFLUX_n
