!     #########
      SUBROUTINE WRITE_DIAG_SEB_SEAFLUX_n(HPROGRAM)
!     #################################
!
!!****  *WRITE_DIAG_SEB_SEAFLUX_n* - write the SEAFLUX diagnostic fields
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!      Modified    08/2009 : cumulated diag
!!      B. Decharme 06/2013 : Add evap and sublimation diag
!!                            Delete LPROVAR_TO_DIAG here
!!      S.Senesi    01/2014 : add diags on seaice
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DIAG_SURF_ATM_n,ONLY : LRESET_BUDGETC
!
USE MODD_SURF_PAR,      ONLY : XUNDEF
!
USE MODD_SEAFLUX_n,     ONLY : LHANDLE_SIC, XICE, LSIC_FROM_FILE
!
USE MODD_DIAG_SEAFLUX_n,ONLY : N2M, LRAD_BUDGET, LSURF_BUDGET,           &
                                 LCOEF, LSURF_VARS, XTS, XTSRAD,           &
                                 XRN, XH, XLE, XLEI, XGFLUX,               &
                                 XRI, XCD, XCH, XCE, XZ0, XZ0H,            &
                                 XT2M, XQ2M, XHU2M, XT2M_MIN, XT2M_MAX,    &
                                 XZON10M, XMER10M, XQS,                    &
                                 XSWD, XSWU, XLWD, XLWU, XSWBD, XSWBU,     &
                                 XFMU, XFMV, LSURF_BUDGETC,                &
                                 XRNC, XHC, XLEC, XLEIC, XGFLUXC, XSWDC,   &
                                 XSWUC, XLWDC, XLWUC, XFMUC, XFMVC,        &
                                 XHU2M_MIN, XHU2M_MAX, XWIND10M,           &
                                 XWIND10M_MAX, XEVAP, XEVAPC, XSUBL, XSUBLC,&
                                 XT2M_ICE, XQ2M_ICE, XHU2M_ICE,         &
                                 XZON10M_ICE, XMER10M_ICE, XWIND10M_ICE,&
                                 XRN_ICE, XH_ICE, XGFLUX_ICE, XRI_ICE,  &
                                 XCD_ICE, XCH_ICE,                      &
                                 XZ0_ICE, XZ0H_ICE, XQS_ICE, XSWU_ICE,  &
                                 XLWU_ICE, XSWBU_ICE, XFMU_ICE, XFMV_ICE,&
                                 XRN_ICEC, XH_ICEC, XGFLUX_ICEC,        &
                                 XSWU_ICEC, XLWU_ICEC, XFMU_ICEC,       &
                                 XFMV_ICEC, XSIC
USE MODN_SEAFLUX_n, ONLY:  LDIAG_SEAICE
!
USE MODD_CH_SEAFLUX_n,  ONLY : XDEP, CCH_DRY_DEP, CCH_NAMES, NBEQ
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODI_END_IO_SURF_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
CHARACTER(LEN=100):: YCOMMENT       ! Comment string
CHARACTER(LEN=2)  :: YNUM
!
INTEGER           :: JSV, JSW
LOGICAL           :: GMISC
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_SEAFLUX_N',0,ZHOOK_HANDLE)
!
!         Initialisation for IO
!
 CALL INIT_IO_SURF_n(HPROGRAM,'SEA   ','SEAFLX','WRITE')
!
!
!*       1.     Surface temperature :
!               ---------------------
!
GMISC=(N2M>=1.OR.LSURF_BUDGET.OR.LSURF_BUDGETC)
!
IF (GMISC.AND.LHANDLE_SIC) THEN
    !
    YRECFM='TS_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XTS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='TSRAD_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XTSRAD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF(.NOT. LSIC_FROM_FILE) THEN
      YRECFM='SIC'
      YCOMMENT='X_Y_'//YRECFM//' (-)'
      CALL WRITE_SURF(HPROGRAM,YRECFM,XSIC(:),IRESP,HCOMMENT=YCOMMENT)
    END IF
ENDIF
!
!*       2.     Richardson number :
!               -----------------
!
 IF (N2M>=1) THEN
    !
    YRECFM='RI_SEA'
    YCOMMENT='X_Y_'//YRECFM
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XRI(:),IRESP,HCOMMENT=YCOMMENT)
    !
 ENDIF
 !
 !*       3.     Energy fluxes :
 !               -------------
 !
call XICE%IO( XICE%MF, HPROGRAM, IS_DIAG = .TRUE. )

 IF (LSURF_BUDGET) THEN
    !
    YRECFM='RN_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XRN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XLE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LEI_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XLEI(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='EVAP_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XEVAP(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SUBL_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XSUBL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (LRAD_BUDGET) THEN
       !
       YRECFM='SWD_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XSWD(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='SWU_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XSWU(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='LWD_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XLWD(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='LWU_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XLWU(:),IRESP,HCOMMENT=YCOMMENT)
       !
       DO JSW=1, SIZE(XSWBD,2)
          YNUM=ACHAR(48+JSW)
          !
          YRECFM='SWD_SEA_'//YNUM
          YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
          !
          CALL WRITE_SURF(HPROGRAM,YRECFM,XSWBD(:,JSW),IRESP,HCOMMENT=YCOMMENT)
          !
          YRECFM='SWU_SEA_'//YNUM
          YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
          !
          CALL WRITE_SURF(HPROGRAM,YRECFM,XSWBU(:,JSW),IRESP,HCOMMENT=YCOMMENT)
          !
       ENDDO
       !
    ENDIF
    !
    YRECFM='FMU_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XFMU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='FMV_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XFMV(:),IRESP,HCOMMENT=YCOMMENT)
    !
 END IF
 !
 IF (LSURF_BUDGETC) THEN

    YRECFM='RNC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XRNC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XHC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LEC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XLEC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LEIC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XLEIC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUXC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XGFLUXC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='EVAPC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XEVAPC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SUBLC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XSUBLC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (LRAD_BUDGET .OR. (LSURF_BUDGETC .AND. .NOT.LRESET_BUDGETC)) THEN
       !
       YRECFM='SWDC_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XSWDC(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='SWUC_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XSWUC(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='LWDC_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XLWDC(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='LWUC_SEA'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XLWUC(:),IRESP,HCOMMENT=YCOMMENT)
       !
    ENDIF
    !
    YRECFM='FMUC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XFMUC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='FMVC_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XFMVC(:),IRESP,HCOMMENT=YCOMMENT)
    !
 END IF
 !
 !*       4.     transfer coefficients
 !               ---------------------
 !
 IF (LCOEF) THEN

    YRECFM='CD_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/s2)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XCD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='CH_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/s)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XCH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='CE_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (W/s/K)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XCE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='Z0_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (M)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XZ0(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='Z0H_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (M)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XZ0H(:),IRESP,HCOMMENT=YCOMMENT)
    !
 END IF
 !
 !
 !*       5.     Surface humidity
 !               ----------------
 !
 IF (LSURF_VARS) THEN

    YRECFM='QS_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XQS(:),IRESP,HCOMMENT=YCOMMENT)
    !
 ENDIF
 !

 !
 !*       6.     parameters at 2 and 10 meters :
 !               -----------------------------
 !
 IF (N2M>=1) THEN
    !
    YRECFM='T2M_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XT2M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='T2MMIN_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XT2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
    XT2M_MIN(:)=XUNDEF
    !
    YRECFM='T2MMAX_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XT2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
    XT2M_MAX(:)=0.0
    !
    YRECFM='Q2M_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XQ2M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HU2M_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XHU2M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HU2MMIN_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XHU2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
    XHU2M_MIN(:)=XUNDEF
    !
    YRECFM='HU2MMAX_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XHU2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
    XHU2M_MAX(:)=-XUNDEF
    !
    YRECFM='ZON10M_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XZON10M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='MER10M_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XMER10M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='W10M_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XWIND10M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='W10MMAX_SEA'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    !
    CALL WRITE_SURF(HPROGRAM,YRECFM,XWIND10M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
    XWIND10M_MAX(:)=0.0
    !
 END IF
 !
 !
 !*       7.     chemical diagnostics:
 !               --------------------
 !
 IF (NBEQ>0 .AND. CCH_DRY_DEP=="WES89 ") THEN
    DO JSV = 1,SIZE(CCH_NAMES,1)
       YRECFM='DV_SEA_'//TRIM(CCH_NAMES(JSV))
       WRITE(YCOMMENT,'(A13,I3.3)')'(m/s) DV_SEA_',JSV
       CALL WRITE_SURF(HPROGRAM,YRECFM,XDEP(:,JSV),IRESP,HCOMMENT=YCOMMENT)
    END DO
 ENDIF
 !
 !
 IF (LDIAG_SEAICE .AND. LHANDLE_SIC) THEN
    !
    !*       8.       Parameters on seaice
    !        ==================================
    !
    !*       8.2.     Richardson number :
    !               -----------------
    IF (N2M>=1) THEN
       !
       YRECFM='RI_SEAICE'
       YCOMMENT='X_Y_'//YRECFM
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XRI_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
    END IF
    !
    !*       8.3     Energy fluxes :
    !               -------------
    !
    IF (LSURF_BUDGET) THEN

       YRECFM='RN_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XRN_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='H_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XH_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='GFLUX_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XGFLUX_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       IF (LRAD_BUDGET) THEN
          !
          YRECFM='SWU_SEAICE'
          YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
          !
          CALL WRITE_SURF(HPROGRAM,YRECFM,XSWU_ICE(:),IRESP,HCOMMENT=YCOMMENT)
          !
          YRECFM='LWU_SEAICE'
          YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
          !
          CALL WRITE_SURF(HPROGRAM,YRECFM,XLWU_ICE(:),IRESP,HCOMMENT=YCOMMENT)
          !
          DO JSW=1, SIZE(XSWBD,2)
             YNUM=ACHAR(48+JSW)
             !
             YRECFM='SWU_SEAICE_'//YNUM
             YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
             !
             CALL WRITE_SURF(HPROGRAM,YRECFM,XSWBU_ICE(:,JSW),IRESP,HCOMMENT=YCOMMENT)
             !
          ENDDO
          !
       ENDIF
       !
       YRECFM='FMU_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XFMU_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='FMV_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XFMV_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
    END IF
    !
    IF (LSURF_BUDGETC) THEN
       !
       YRECFM='RNC_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XRN_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='HC_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XH_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='GFLUXC_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XGFLUX_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
       IF (LRAD_BUDGET .OR. (LSURF_BUDGETC .AND. .NOT.LRESET_BUDGETC)) THEN
          !
          YRECFM='SWUC_SEAICE'
          YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
          !
          CALL WRITE_SURF(HPROGRAM,YRECFM,XSWU_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
          !
          YRECFM='LWUC_SEAICE'
          YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
          !
          CALL WRITE_SURF(HPROGRAM,YRECFM,XLWU_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
          !
       ENDIF
       !
       YRECFM='FMUC_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XFMU_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='FMVC_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XFMV_ICEC(:),IRESP,HCOMMENT=YCOMMENT)
       !
    END IF
    !
    !*       8.4     transfer coefficients
    !               ---------------------
    !
    IF (LCOEF) THEN
       !
       YRECFM='CD_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (W/s2)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XCD_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='CH_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (W/s)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XCH_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='Z0_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (M)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XZ0_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='Z0H_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (M)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XZ0H_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
    END IF
    !
    !
    !*       8.5     Surface humidity
    !               ----------------
    !
    IF (LSURF_VARS) THEN
       YRECFM='QS_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XQS_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
    ENDIF
    !

    !
    !*       8.6.     parameters at 2 and 10 meters :
    !               -----------------------------
    !
    IF (N2M>=1) THEN
       !
       YRECFM='T2M_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (K)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XT2M_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='Q2M_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XQ2M_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='HU2M_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (-)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XHU2M_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='ZON10M_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (M/S)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XZON10M_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='MER10M_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (M/S)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XMER10M_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
       YRECFM='W10M_SEAICE'
       YCOMMENT='X_Y_'//YRECFM//' (M/S)'
       !
       CALL WRITE_SURF(HPROGRAM,YRECFM,XWIND10M_ICE(:),IRESP,HCOMMENT=YCOMMENT)
       !
    END IF
    !
 ENDIF
 !
!------------------------------------------------------------------------------
!
!         End of IO
!
CALL END_IO_SURF_n(HPROGRAM)
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_SEAFLUX_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE WRITE_DIAG_SEB_SEAFLUX_n
