subroutine signed_distance_field( h_fld, p_dst )
! Distance from current point to the nearest edge point.
!
! AUTHOR
! Y. Batrak
!
! MODIFICATIONS
! Original  07/2014
  implicit none
    logical, intent( in  ) :: h_fld( :, : )
    real,    intent( out ) :: p_dst( size(h_fld,1), size(h_fld,2) )

    real  :: z_inverse_dst( size(h_fld,1), size(h_fld,2) )

    call distance_field(       h_fld, p_dst         )
    call distance_field( .NOT. h_fld, z_inverse_dst )

    where( h_fld ) p_dst = -z_inverse_dst

contains
    subroutine distance_field( h_fld, p_dst )
      implicit none
        logical, intent( in  ) :: h_fld( :, : )
        real,    intent( out ) :: p_dst( size(h_fld,1), size(h_fld,2) )

        integer :: i_m, i_n, i_inf, i_q, i_w
        integer :: j_x, j_y, j_u
        integer :: i_g( size(h_fld,1), size(h_fld,2) ), &
                   i_s( size(h_fld,1) ),                &
                   i_t( size(h_fld,1) )

        i_m = size( h_fld, 1 )
        i_n = size( h_fld, 2 )

        i_inf = i_m + i_n

        p_dst = 0.

        !First phase
        do j_x = 1, i_m
            if( h_fld( j_x, 1 ) ) then
                i_g( j_x, 1 ) = 1
            else
                i_g( j_x, 1 ) = i_inf
            end if
            do j_y = 2, i_n
                if( h_fld( j_x, j_y ) ) then
                    i_g( j_x, j_y ) = 1
                else
                    i_g( j_x, j_y ) = 1 + i_g( j_x, j_y - 1 )
                end if
            end do

            do j_y = i_n - 1, 1, -1
                if( i_g( j_x, j_y + 1 ) < i_g( j_x, j_y ) ) &
                    i_g( j_x, j_y ) = 1 + i_g( j_x, j_y + 1 )
            end do
        end do

        !Second phase
#define FUNC( x, i, g ) ((x-i)**2 + g**2)
#define SEP( i, u, g_i, g_u ) (u**2 - i**2 + g_u**2 - g_i**2)/( 2*(u - i) )
        do j_y = 1, i_n
            i_q    = 1
            i_s(1) = 1
            i_t(1) = 1

            do j_u = 2, i_m
                do while( i_q > 1 .AND.                                     &
                          FUNC( i_t(i_q), i_s(i_q), i_g(i_s(i_q),j_y) ) >   &
                          FUNC( i_t(i_q), j_u,      i_g(j_u,     j_y) ) )
                    i_q = i_q - 1
                end do
                if( i_q < 1 ) then
                    i_q    = 1
                    i_s(1) = j_u
                else
                    i_w = 1 + SEP( i_s(i_q), j_u, i_g(i_s(i_q),j_y), i_g(j_u,j_y) )
                    if( i_w < i_m ) then
                        i_q        = i_q + 1
                        i_s( i_q ) = j_u
                        i_t( i_q ) = i_w
                    end if
                end if
            end do

            do j_u = i_m, 1, -1
                p_dst( j_u, j_y ) = sqrt(real( FUNC( j_u, i_s(i_q), i_g(i_s(i_q),j_y) ) ))
                if( j_u == i_t(i_q) ) i_q = i_q - 1
            end do
        end do

        print*, maxval(p_dst), minval(p_dst)
    end subroutine distance_field
end subroutine signed_distance_field
