!===============================================================================
!> Subroutine fills arrays, which define vertical grid for SOIL_HEATDIF routine.
!
! AUTHOR
! Y. Batrak
!
! MODIFICATIONS
! Original  04/2014
!===============================================================================
subroutine set_grid( zMin, zMax, z, dz, z_diff )
  use MODD_SURF_PAR, only: XUNDEF

  use MODI_LIN_SPACE

  use YOMHOOK,    only: LHOOK, DR_HOOK
  use PARKIND1,   only: JPRB
  implicit none
    real, intent( in  )    :: zMin,    & !< Skin layer depth, m
                              zMax       !< Total depth of vertical grid, m
    real, intent( in out ) :: z( :, : )  !< Depth of lower boundary for each vertical layer, m
    real, dimension( size(z,1), size(z,2) ), intent( out ) :: &
                              dz, &      !< Thickness of each layer, m
                              z_diff     !< Distanse between consecutive layer middle points, m

    integer :: i, n, nPoints, nLayer

    real( KIND = JPRB ) :: ZHOOK_HANDLE

    if( LHOOK ) call DR_HOOK( 'SET_GRID', 0, ZHOOK_HANDLE )

    nPoints = size( z, 1 )
    nLayer  = size( z, 2 )

    if( abs(z( 1, 1 ) - XUNDEF) < 1.E-2 ) then
        do i = 1, nPoints
            call lin_space( zMin, zMax, [( real(n), n = 1, nLayer )], z( i, : ) )
        end do
    end if

    dz    ( :, 1 ) =     z( :, 1 )
    z_diff( :, 1 ) = 0.5*z( :, 2 )

    do i = 2, size( z, 2 ) - 1
        dz    ( :, i ) =       z( :, i     ) - z( :, i - 1 )
        z_diff( :, i ) = 0.5*( z( :, i + 1 ) - z( :, i - 1 ) )
    end do

    n = nLayer
    dz    ( :, n ) =       z( :, n ) - z( :, n - 1 )
    z_diff( :, n ) = 0.5*( z( :, n ) - z( :, n - 1 ) )

    if( LHOOK ) call DR_HOOK( 'SET_GRID', 1, ZHOOK_HANDLE )
end subroutine
