module modn_simpl_ice
! SIMPLE_ICE ice scheme parameters
!
! AUTHOR
! Y. Batrak
!
! MODIFICATIONS
! Original  04/2014
  use MODD_SURF_PAR,   ONLY: XUNDEF
  use MODE_ICE_ALBEDO, ONLY: REMO
  implicit none

    character( LEN = 4 ), parameter :: simpl_ice     = 'SICE'

    real, save ::                           &
        XICE_THICKNESS          = 1.5,      &   !< Ice thickness, [m]
        XICE_DENSITY            = 900.,     &   !< Ice density,   [kg/m3]
        XICE_THERMAL_RESISTANCE = XUNDEF,   &   !< Thermal inertia of sea ice
        XICE_HEAT_CAPACITY      = XUNDEF,   &   !< Sea ice volumetric heat capacity, 2.E6 [J/(m3 K)]
        XICE_HEAT_CONDUCTIVITY  = XUNDEF,   &   !< Sea ice thermal conductivity,  2.0 [W/(K m)]
        XSIC_DRIVEN_MIN_SIC      = 0.25,    &
        XSIC_DRIVEN_MAX_SIC      = 0.75,    &
        XSIC_DRIVEN_MAX_THICKNESS= 1.5
    logical, save ::                        &
        LICE_HAS_SNOW           = .FALSE.,  &   !< Snow upon the ice swith on/off
        LSIC_DRIVEN_THICKNESS   = .FALSE.,  &
        LINIT_3L_SNOW_ISBA_UNIF = .FALSE.
    integer, save ::                        &
        NICE_SNOW_NLAYERS       = 3,        &   !< Number of snow layers for S-D snow scheme
        NICE_ALBEDO             = REMO          !< Ice albedo parameterization
    real,    save ::                        &
        XICE_SNOW_HEIGHT        = 0.1           !< Prescribed snow depth for S-D snow scheme, [m]
    character( LEN = 3 ), save ::           &
        CICE_SNOW               = 'S-D'         !< Snow scheme, 'S-D'|'3-L'

    namelist /NAM_SIMPLE_ICE/               &
        XICE_THICKNESS,                     &
        XICE_DENSITY,                       &
        XICE_THERMAL_RESISTANCE,            &
        XICE_HEAT_CAPACITY,                 &
        XICE_HEAT_CONDUCTIVITY,             &
        LICE_HAS_SNOW,                      &
        LINIT_3L_SNOW_ISBA_UNIF,            &
        NICE_ALBEDO,                        &
        NICE_SNOW_NLAYERS,                  &
        XICE_SNOW_HEIGHT,                   &
        CICE_SNOW,                          &
        LSIC_DRIVEN_THICKNESS,              &
        XSIC_DRIVEN_MIN_SIC,                &
        XSIC_DRIVEN_MAX_SIC,                &
        XSIC_DRIVEN_MAX_THICKNESS
end module
