!     ##################
      MODULE MODN_SEAFLUX_n
!     ##################
!
!!****  *MODN_SEAFLUX_n* - declaration of namelist NAM_SEAFLUXn
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_SEAFLUX_n
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!      Modified    08/2009 : LSURF_BUDGETC
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!

USE MODD_CH_SEAFLUX_n, ONLY:   &
           CCH_DRY_DEP_n    => CCH_DRY_DEP
USE MODD_SEAFLUX_n, ONLY:      &
           XTSTEP_n         => XTSTEP,          &
           XOUT_TSTEP_n     => XOUT_TSTEP,      &
           CSEA_FLUX_n      => CSEA_FLUX,       &
           CSEA_ALB_n       => CSEA_ALB,        &
           LPWG_n           => LPWG,            &
           LPRECIP_n        => LPRECIP,         &
           CINTERPOL_SST_n  => CINTERPOL_SST,   &
           LPWEBB_n         => LPWEBB,          &
           NGRVWAVES_n      => NGRVWAVES,       &
           XICHCE_n         => XICHCE,          &
           CSEA_ICE_n       => CSEA_ICE,        &
           NICE_LAYER_n     => NICE_LAYER,      &
           LHANDLE_SIC_n    => LHANDLE_SIC,     &
           LSIC_FROM_FILE_n => LSIC_FROM_FILE,  &
           XSIC_MAX_n       => XSIC_MAX,        &
           XSIC_MIN_n       => XSIC_MIN,        &
           LMISSING_ICE_VARIABLES_n => LMISSING_ICE_VARIABLES
USE MODD_DIAG_SEAFLUX_n, ONLY: &
           XDIAG_TSTEP_n    => XDIAG_TSTEP,     &
           N2M_n            => N2M,             &
           L2M_MIN_ZS_n     => L2M_MIN_ZS,      &
           LSURF_BUDGET_n   => LSURF_BUDGET,    &
           LRAD_BUDGET_n    => LRAD_BUDGET,     &
           LSURF_BUDGETC_n  => LSURF_BUDGETC,   &
           LRESET_BUDGETC_n => LRESET_BUDGETC,  &
           LCOEF_n          => LCOEF, &
           LSURF_VARS_n     => LSURF_VARS
USE MODD_OCEAN_n, ONLY: &
           LPROGSST_n       => LPROGSST,        &
           NTIME_COUPLING_n => NTIME_COUPLING
USE MODD_DIAG_OCEAN_n, ONLY:   &
           LDIAG_OCEAN_n    => LDIAG_OCEAN
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
CHARACTER(LEN=6)    :: CSEA_FLUX
CHARACTER(LEN=4)    :: CSEA_ALB
CHARACTER(LEN=6)    :: CSEA_ICE
REAL                :: XTSTEP
REAL                :: XOUT_TSTEP
REAL                :: XDIAG_TSTEP
INTEGER             :: N2M
LOGICAL             :: L2M_MIN_ZS
LOGICAL             :: LSURF_BUDGET
LOGICAL             :: LRAD_BUDGET
LOGICAL             :: LSURF_BUDGETC
LOGICAL             :: LRESET_BUDGETC
LOGICAL             :: LCOEF
LOGICAL             :: LSURF_VARS
LOGICAL             :: LPWG
LOGICAL             :: LPRECIP
LOGICAL             :: LPWEBB
LOGICAL             :: LDIAG_OCEAN
INTEGER             :: NGRVWAVES
REAL                :: XICHCE
CHARACTER(LEN=6)    :: CCH_DRY_DEP
LOGICAL             :: LPROGSST
INTEGER             :: NTIME_COUPLING
CHARACTER(LEN=6)    :: CINTERPOL_SST
INTEGER             :: NICE_LAYER
LOGICAL             :: LHANDLE_SIC
LOGICAL             :: LSIC_FROM_FILE
REAL                :: XSIC_MAX
REAL                :: XSIC_MIN
LOGICAL             :: LDIAG_SEAICE
LOGICAL             :: LNEW_AVG_DRAG
LOGICAL             :: LMISSING_ICE_VARIABLES

!
NAMELIST/NAM_SEAFLUXn/CSEA_FLUX,CSEA_ALB, LPWG, LPRECIP, LPWEBB, NGRVWAVES, &
                        LPROGSST, NTIME_COUPLING, XICHCE, CINTERPOL_SST, &
                        CSEA_ICE,NICE_LAYER, LHANDLE_SIC, LSIC_FROM_FILE, &
                        XSIC_MAX, XSIC_MIN, LMISSING_ICE_VARIABLES
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                          LSURF_BUDGETC,LRESET_BUDGETC,LCOEF,LSURF_VARS
NAMELIST/NAM_CH_SEAFLUXn/CCH_DRY_DEP
NAMELIST/NAM_DIAG_OCEANn/LDIAG_OCEAN
NAMELIST/NAM_DIAG_SEAICEn/LDIAG_SEAICE,LNEW_AVG_DRAG
!
CONTAINS
!
SUBROUTINE INIT_NAM_SEAFLUXn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_SEAFLUXN',0,ZHOOK_HANDLE)
  XTSTEP            = XTSTEP_n
  XOUT_TSTEP        = XOUT_TSTEP_n
  CSEA_FLUX         = CSEA_FLUX_n
  CSEA_ALB          = CSEA_ALB_n
  LPWG              = LPWG_n
  LPRECIP           = LPRECIP_n
  CINTERPOL_SST     = CINTERPOL_SST_n
  LPWEBB            = LPWEBB_n
  NGRVWAVES         = NGRVWAVES_n
  LPROGSST          = LPROGSST_n
  NTIME_COUPLING    = NTIME_COUPLING_n
  XICHCE            = XICHCE_n
  CSEA_ICE          = CSEA_ICE_n
  NICE_LAYER        = NICE_LAYER_n
  LHANDLE_SIC       = LHANDLE_SIC_n
  LSIC_FROM_FILE    = LSIC_FROM_FILE_n
  XSIC_MAX          = XSIC_MAX_n
  XSIC_MIN          = XSIC_MIN_n
  LMISSING_ICE_VARIABLES = LMISSING_ICE_VARIABLES_n
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SEAFLUXn

SUBROUTINE UPDATE_NAM_SEAFLUXn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_SEAFLUXN',0,ZHOOK_HANDLE)
  XTSTEP_n          = XTSTEP
  XOUT_TSTEP_n      = XOUT_TSTEP
  CSEA_FLUX_n       = CSEA_FLUX
  CSEA_ALB_n        = CSEA_ALB
  LPWG_n            = LPWG
  LPRECIP_n         = LPRECIP
  CINTERPOL_SST_n   = CINTERPOL_SST
  LPWEBB_n          = LPWEBB
  NGRVWAVES_n       = NGRVWAVES
  LPROGSST_n        = LPROGSST
  NTIME_COUPLING_n  = NTIME_COUPLING
  XICHCE_n          = XICHCE
  CSEA_ICE_n        = CSEA_ICE
  NICE_LAYER_n      = NICE_LAYER
  LHANDLE_SIC_n     = LHANDLE_SIC
  LSIC_FROM_FILE_n  = LSIC_FROM_FILE
  XSIC_MAX_n        = XSIC_MAX
  XSIC_MIN_n        = XSIC_MIN
  LMISSING_ICE_VARIABLES_n = LMISSING_ICE_VARIABLES
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SEAFLUXn
!
SUBROUTINE INIT_NAM_DIAG_SURFn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP       = XDIAG_TSTEP_n
  N2M               = N2M_n
  L2M_MIN_ZS        = L2M_MIN_ZS_n
  LSURF_BUDGET      = LSURF_BUDGET_n
  LRAD_BUDGET       = LRAD_BUDGET_n
  LSURF_BUDGETC     = LSURF_BUDGETC_n
  LRESET_BUDGETC    = LRESET_BUDGETC_n
  LCOEF             = LCOEF_n
  LSURF_VARS        = LSURF_VARS_n
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP_n     = XDIAG_TSTEP
  N2M_n             = N2M
  L2M_MIN_ZS_n      = L2M_MIN_ZS
  LSURF_BUDGET_n    = LSURF_BUDGET
  LRAD_BUDGET_n     = LRAD_BUDGET
  LSURF_BUDGETC_n   = LSURF_BUDGETC
  LRESET_BUDGETC_n  = LRESET_BUDGETC
  LCOEF_n           = LCOEF
  LSURF_VARS_n      = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn
!
SUBROUTINE INIT_NAM_CH_SEAFLUXn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_CH_SEAFLUXN',0,ZHOOK_HANDLE)
  CCH_DRY_DEP       = CCH_DRY_DEP_n
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_CH_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_SEAFLUXn

SUBROUTINE UPDATE_NAM_CH_SEAFLUXn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_CH_SEAFLUXN',0,ZHOOK_HANDLE)
  CCH_DRY_DEP_n     = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_CH_SEAFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_SEAFLUXn

SUBROUTINE INIT_NAM_DIAG_OCEANn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_OCEANN',0,ZHOOK_HANDLE)
  LDIAG_OCEAN       = LDIAG_OCEAN_n
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:INIT_NAM_DIAG_OCEANN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_OCEANn

SUBROUTINE UPDATE_NAM_DIAG_OCEANn

  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_OCEANN',0,ZHOOK_HANDLE)
  LDIAG_OCEAN_n     = LDIAG_OCEAN
IF (LHOOK) CALL DR_HOOK('MODN_SEAFLUX_N:UPDATE_NAM_DIAG_OCEANN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_OCEANn

END MODULE MODN_SEAFLUX_n
