module mode_ice_albedo
! Number of parametrizations for bare ice albedo.
  use YOMHOOK,    only: LHOOK, DR_HOOK
  use PARKIND1,   only: JPRB
  implicit none
    private

    integer, parameter, public ::       &
        SIMPLE   = 0, &
        REMO     = 1, &
        HADCM3   = 2, &
        HIRHAM   = 3, &
        PEROVICH = 4

    interface ice_albedo
        module procedure ice_albedo_simple
        module procedure ice_albedo_ts
    end interface

    public :: ice_albedo
  contains

  function ice_albedo_simple() result( albedo )
  implicit none
    real :: albedo

    real( KIND = JPRB ) :: ZHOOK_HANDLE

    if( LHOOK ) call DR_HOOK( 'ICE_ALBEDO:SIMPLE', 0, ZHOOK_HANDLE )

    albedo = 0.5

    if( LHOOK ) call DR_HOOK( 'ICE_ALBEDO:SIMPLE', 1, ZHOOK_HANDLE )
  end function

  elemental function ice_albedo_ts( T_surf, scheme ) result( albedo )
  use MODD_CSTS, only: XTTSI
  implicit none
    real,    intent( in ) :: T_surf
    integer, intent( in ) :: scheme
    real                  :: albedo

    real                  :: T_surf_cels

    real( KIND = JPRB ) :: ZHOOK_HANDLE

    !if( LHOOK ) call DR_HOOK( 'ICE_ALBEDO:TS', 0, ZHOOK_HANDLE )

    T_surf_cels = T_surf - 273.15

    select case( scheme )
      case( SIMPLE   )
        albedo = 0.5
      case( REMO     )
        if( T_surf_cels <= -3. ) then
            albedo = 0.85
        else
            albedo = 0.55 - 0.1*T_surf_cels
        end if
      case( HIRHAM   )
#define ALBEDO_MAX 0.7
#define ALBEDO_MIN 0.3
        albedo = ALBEDO_MAX - exp( -0.5*( XTTSI - T_surf ) )*(ALBEDO_MAX - ALBEDO_MIN)
#undef  ALBEDO_MAX
#undef  ALBEDO_MIN
      case( HADCM3   )
        if( T_surf_cels <= -10. ) then
            albedo = 0.8
        else if( T_surf_cels > 0. ) then
            albedo = 0.5
        else
            albedo = 0.8 - 0.03*( T_surf_cels + 10. )
        end if
      case( PEROVICH )
        if( T_surf < XTTSI ) then
            albedo = 0.71
        else
            albedo = 0.61
        end if
    end select

    !if( LHOOK ) call DR_HOOK( 'ICE_ALBEDO:TS', 1, ZHOOK_HANDLE )
  end function
end module
