!     #################
      MODULE MODD_SEAFLUX_n
!     #################
!
!!****  *MODD_SEAFLUX_n - declaration of surface parameters for sea surface
!!
!!    PURPOSE
!!    -------
!     Declaration of surface parameters
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!	V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       01/2004
!!      Y. Batrak      04/2014  Add sea ice model to SEAFLUX_t content
!
!*       0.   DECLARATIONS
!             ------------
!
USE abstract_ice, only: tAbstract_ice

USE MODD_TYPE_DATE_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

TYPE SEAFLUX_t
!
! General surface:
!
  REAL, POINTER, DIMENSION(:)     :: XZS                      !< orography
  REAL, POINTER, DIMENSION(:,:)   :: XCOVER                   !< fraction of each ecosystem       (-)
  LOGICAL, POINTER, DIMENSION(:)  :: LCOVER                   !< GCOVER(i)=T --> ith cover field is not 0.
  LOGICAL                         :: LSBL                     !< T: SBL scheme between sea and atm. forcing level
                                                              !! F: no atmospheric layers below forcing level
  REAL, POINTER, DIMENSION(:)     :: XSEABATHY                !< bathymetry
!
  LOGICAL                         :: LINTERPOL_SST            !< Quadratic interpotalation of monthly SST
  CHARACTER(LEN=6)                :: CINTERPOL_SST            !< Quadratic interpotalation of monthly SST
!
! Type of formulation for the fluxes
!
  CHARACTER(LEN=6)                :: CSEA_FLUX                !< type of flux computation
  CHARACTER(LEN=4)                :: CSEA_ALB                 !< type of albedo
  LOGICAL                         :: LPWG                     !< flag for gust
  LOGICAL                         :: LPRECIP                  !< flag for precip correction
  LOGICAL                         :: LPWEBB                   !< flag for heat flux correction
  INTEGER                         :: NGRVWAVES                !< set to 0,1 or 2 according to the
                                                              !< gravity waves model used in coare30_flux
  REAL                            :: XICHCE                   !< CE coef calculation for ECUME
!
! Sea ice
  CHARACTER(LEN=6)                :: CSEA_ICE                 !< type of sea ice scheme
  INTEGER                         :: NICE_LAYER               !< number of ice layers
  LOGICAL                         :: LHANDLE_SIC
  LOGICAL                         :: LSIC_FROM_FILE = .FALSE. !< Read sea ice concentration from boundary file.
  LOGICAL                         :: LMISSING_ICE_VARIABLES   !< if PREP output contains no ice fields, we can just skip reading of the missing fields to avoid
!

!
! Sea/Ocean:
!
  REAL, POINTER, DIMENSION(:)     :: XSST                     !< sea surface temperature
  REAL, POINTER, DIMENSION(:,:)   :: XTICE                    !< sea ice temperature
  REAL, POINTER, DIMENSION(:)     :: XSST_INI                 !< initial sea surface temperature
  REAL, POINTER, DIMENSION(:)     :: XZ0                      !< roughness length
  REAL, POINTER, DIMENSION(:)     :: XZ0H                     !< roughness length for heat
  REAL, POINTER, DIMENSION(:)     :: XEMIS                    !< emissivity
  REAL, POINTER, DIMENSION(:)     :: XDIR_ALB                 !< direct albedo
  REAL, POINTER, DIMENSION(:)     :: XSCA_ALB                 !< diffuse albedo
  REAL, POINTER, DIMENSION(:)     :: XICE_ALB                 !< sea-ice albedo from GELATO (for ESM coupling)
  REAL, POINTER, DIMENSION(:)     :: XUMER                    !< U composant of sea current (for ESM coupling)
  REAL, POINTER, DIMENSION(:)     :: XVMER                    !< V composant of sea current (for ESM coupling)
!
  REAL, POINTER, DIMENSION(:,:)   :: XSST_MTH                 !< monthly sea surface temperature (precedent, current and next)
!
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_WIND            !< 10m wind speed for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_FWSU            !< zonal wind stress for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_FWSV            !< meridian wind stress for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_SNET            !< Solar net heat flux
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_HEAT            !< Non solar net heat flux
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_EVAP            !< Evaporation for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_RAIN            !< Rainfall for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_SNOW            !< Snowfall for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_FWSM            !< wind stress for ESM coupling
!
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEAICE_SNET         !< Solar net heat flux for ESM coupling
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEAICE_HEAT         !< Non solar net heat flux
  REAL, POINTER, DIMENSION(:)     :: XCPL_SEAICE_EVAP         !< Ice sublimation for ESM coupling
!
! Date:
!
  TYPE (DATE_TIME)                :: TTIME                    !< current date and time
  TYPE (DATE_TIME)                :: TZTIME
  LOGICAL                         :: LTZTIME_DONE
  INTEGER                         :: JSX
!
! Time-step:
!
  REAL                            :: XTSTEP                   !< time step
!
  REAL                            :: XOUT_TSTEP               !< output writing time step
!
!
!
  CLASS( tAbstract_ice ), pointer :: XICE
  REAL, POINTER, DIMENSION(:)     :: XSIC                     !< Sea ice concentration.

  REAL                            :: XSIC_MAX = 1.0
  REAL                            :: XSIC_MIN = 0.0
END TYPE SEAFLUX_t

TYPE(SEAFLUX_t), ALLOCATABLE, TARGET, SAVE :: SEAFLUX_MODEL(:)

REAL, POINTER, DIMENSION(:)     :: XZS              => NULL()
!$OMP THREADPRIVATE(XZS)
REAL, POINTER, DIMENSION(:,:)   :: XCOVER           => NULL()
!$OMP THREADPRIVATE(XCOVER)
LOGICAL, POINTER, DIMENSION(:)  :: LCOVER           => NULL()
!$OMP THREADPRIVATE(LCOVER)
LOGICAL, POINTER                :: LSBL             => NULL()
!$OMP THREADPRIVATE(LSBL)
REAL, POINTER, DIMENSION(:)     :: XSEABATHY        => NULL()
!$OMP THREADPRIVATE(XSEABATHY)
CHARACTER(LEN=6), POINTER       :: CSEA_FLUX        => NULL()
!$OMP THREADPRIVATE(CSEA_FLUX)
CHARACTER(LEN=4), POINTER       :: CSEA_ALB         => NULL()
!$OMP THREADPRIVATE(CSEA_ALB)
LOGICAL, POINTER                :: LPWG             => NULL()
!$OMP THREADPRIVATE(LPWG)
LOGICAL, POINTER                :: LPRECIP          => NULL()
!$OMP THREADPRIVATE(LPRECIP)
LOGICAL, POINTER                :: LPWEBB           => NULL()
!$OMP THREADPRIVATE(LPWEBB)
INTEGER, POINTER                :: NGRVWAVES        => NULL()
!$OMP THREADPRIVATE(NGRVWAVES)
LOGICAL, POINTER                :: LINTERPOL_SST    => NULL()
!$OMP THREADPRIVATE(LINTERPOL_SST)
CHARACTER(LEN=6), POINTER       :: CINTERPOL_SST    => NULL()
!$OMP THREADPRIVATE(CINTERPOL_SST)
REAL, POINTER                   :: XICHCE           => NULL()
!$OMP THREADPRIVATE(XICHCE)
CHARACTER(LEN=6), POINTER       :: CSEA_ICE         => NULL()
!$OMP THREADPRIVATE(CSEA_ICE)
INTEGER, POINTER                :: NICE_LAYER       => NULL()
!$OMP THREADPRIVATE(NICE_LAYER)
LOGICAL, POINTER                :: LHANDLE_SIC      => NULL()
!$OMP THREADPRIVATE(LHANDLE_SIC)
LOGICAL, POINTER                :: LSIC_FROM_FILE   => NULL()
!$OMP THREADPRIVATE(LSIC_FROM_FILE)
LOGICAL, POINTER                :: LMISSING_ICE_VARIABLES => NULL()
!$OMP THREADPRIVATE(LMISSING_ICE_VARIABLES)
REAL, POINTER, DIMENSION(:)     :: XSST             => NULL()
!$OMP THREADPRIVATE(XSST)
REAL, POINTER, DIMENSION(:,:)   :: XTICE            => NULL()
!$OMP THREADPRIVATE(XTICE)
REAL, POINTER, DIMENSION(:,:)   :: XSST_MTH         => NULL()
!$OMP THREADPRIVATE(XSST_MTH)
REAL, POINTER, DIMENSION(:)     :: XSST_INI         => NULL()
!$OMP THREADPRIVATE(XSST_INI)
REAL, POINTER, DIMENSION(:)     :: XZ0              => NULL()
!$OMP THREADPRIVATE(XZ0)
REAL, POINTER, DIMENSION(:)     :: XZ0H             => NULL()
!$OMP THREADPRIVATE(XZ0H)
REAL, POINTER, DIMENSION(:)     :: XEMIS            => NULL()
!$OMP THREADPRIVATE(XEMIS)
REAL, POINTER, DIMENSION(:)     :: XDIR_ALB         => NULL()
!$OMP THREADPRIVATE(XDIR_ALB)
REAL, POINTER, DIMENSION(:)     :: XSCA_ALB         => NULL()
!$OMP THREADPRIVATE(XSCA_ALB)
REAL, POINTER, DIMENSION(:)     :: XICE_ALB         => NULL()
!$OMP THREADPRIVATE(XICE_ALB)
REAL, POINTER, DIMENSION(:)     :: XUMER            => NULL()
!$OMP THREADPRIVATE(XUMER)
REAL, POINTER, DIMENSION(:)     :: XVMER            => NULL()
!$OMP THREADPRIVATE(XVMER)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_WIND    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_WIND)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_FWSU    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_FWSU)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_FWSV    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_FWSV)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_SNET    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_SNET)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_HEAT    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_HEAT)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_EVAP    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_EVAP)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_RAIN    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_RAIN)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_SNOW    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_SNOW)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEA_FWSM    => NULL()
!$OMP THREADPRIVATE(XCPL_SEA_FWSM)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEAICE_SNET => NULL()
!$OMP THREADPRIVATE(XCPL_SEAICE_SNET)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEAICE_HEAT => NULL()
!$OMP THREADPRIVATE(XCPL_SEAICE_HEAT)
REAL, POINTER, DIMENSION(:)     :: XCPL_SEAICE_EVAP => NULL()
!$OMP THREADPRIVATE(XCPL_SEAICE_EVAP)
TYPE (DATE_TIME), POINTER       :: TTIME            => NULL()
!$OMP THREADPRIVATE(TTIME)
TYPE (DATE_TIME), POINTER       :: TZTIME           => NULL()
!$OMP THREADPRIVATE(TZTIME)
LOGICAL, POINTER                :: LTZTIME_DONE     => NULL()
!$OMP THREADPRIVATE(LTZTIME_DONE)
INTEGER, POINTER                :: JSX              => NULL()
!$OMP THREADPRIVATE(JSX)
REAL, POINTER                   :: XTSTEP           => NULL()
!$OMP THREADPRIVATE(XTSTEP)
REAL, POINTER                   :: XOUT_TSTEP       => NULL()
!$OMP THREADPRIVATE(XOUT_TSTEP)

class( tAbstract_ice ), pointer :: XICE             => NULL()
!$OMP THREADPRIVATE(XICE)
REAL, POINTER, DIMENSION(:)     :: XSIC             => NULL()
!$OMP THREADPRIVATE(XSIC)
REAL, POINTER, save             :: XSIC_MAX         => NULL()
!$OMP THREADPRIVATE(XSIC_MAX)
REAL, POINTER, save             :: XSIC_MIN         => NULL()
!$OMP THREADPRIVATE(XSIC_MIN)

CONTAINS

SUBROUTINE SEAFLUX_GOTO_MODEL(KFROM, KTO, LKFROM)
LOGICAL, INTENT(IN) :: LKFROM
INTEGER, INTENT(IN) :: KFROM, KTO
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! Save current state for allocated arrays
IF (LKFROM) THEN
SEAFLUX_MODEL(KFROM)%XZS              => XZS
SEAFLUX_MODEL(KFROM)%XCOVER           => XCOVER
SEAFLUX_MODEL(KFROM)%LCOVER           => LCOVER
SEAFLUX_MODEL(KFROM)%XSEABATHY        => XSEABATHY
SEAFLUX_MODEL(KFROM)%XSST             => XSST
SEAFLUX_MODEL(KFROM)%XTICE            => XTICE
SEAFLUX_MODEL(KFROM)%XSST_MTH         => XSST_MTH
SEAFLUX_MODEL(KFROM)%XSST_INI         => XSST_INI
SEAFLUX_MODEL(KFROM)%XZ0              => XZ0
SEAFLUX_MODEL(KFROM)%XZ0H             => XZ0H
SEAFLUX_MODEL(KFROM)%XEMIS            => XEMIS
SEAFLUX_MODEL(KFROM)%XDIR_ALB         => XDIR_ALB
SEAFLUX_MODEL(KFROM)%XSCA_ALB         => XSCA_ALB
SEAFLUX_MODEL(KFROM)%XICE_ALB         => XICE_ALB
SEAFLUX_MODEL(KFROM)%XUMER            => XUMER
SEAFLUX_MODEL(KFROM)%XVMER            => XVMER
SEAFLUX_MODEL(KFROM)%XCPL_SEA_WIND    => XCPL_SEA_WIND
SEAFLUX_MODEL(KFROM)%XCPL_SEA_FWSU    => XCPL_SEA_FWSU
SEAFLUX_MODEL(KFROM)%XCPL_SEA_FWSV    => XCPL_SEA_FWSV
SEAFLUX_MODEL(KFROM)%XCPL_SEA_SNET    => XCPL_SEA_SNET
SEAFLUX_MODEL(KFROM)%XCPL_SEA_HEAT    => XCPL_SEA_HEAT
SEAFLUX_MODEL(KFROM)%XCPL_SEA_EVAP    => XCPL_SEA_EVAP
SEAFLUX_MODEL(KFROM)%XCPL_SEA_RAIN    => XCPL_SEA_RAIN
SEAFLUX_MODEL(KFROM)%XCPL_SEA_SNOW    => XCPL_SEA_SNOW
SEAFLUX_MODEL(KFROM)%XCPL_SEA_FWSM    => XCPL_SEA_FWSM
SEAFLUX_MODEL(KFROM)%XCPL_SEAICE_SNET => XCPL_SEAICE_SNET
SEAFLUX_MODEL(KFROM)%XCPL_SEAICE_HEAT => XCPL_SEAICE_HEAT
SEAFLUX_MODEL(KFROM)%XCPL_SEAICE_EVAP => XCPL_SEAICE_EVAP

SEAFLUX_MODEL(KFROM)%XICE             => XICE
SEAFLUX_MODEL(KFROM)%XSIC             => XSIC

ENDIF
!
! Current model is set to model KTO
IF (LHOOK) CALL DR_HOOK('MODD_SEAFLUX_N:SEAFLUX_GOTO_MODEL',0,ZHOOK_HANDLE)



 XZS                    => SEAFLUX_MODEL(KTO)%  XZS
 XCOVER                 => SEAFLUX_MODEL(KTO)%  XCOVER
 LCOVER                 => SEAFLUX_MODEL(KTO)%  LCOVER
 LSBL                   => SEAFLUX_MODEL(KTO)%  LSBL
 XSEABATHY              => SEAFLUX_MODEL(KTO)%  XSEABATHY
 CSEA_FLUX              => SEAFLUX_MODEL(KTO)%  CSEA_FLUX
 CSEA_ALB               => SEAFLUX_MODEL(KTO)%  CSEA_ALB
 LPWG                   => SEAFLUX_MODEL(KTO)%  LPWG
 LPRECIP                => SEAFLUX_MODEL(KTO)%  LPRECIP
 LINTERPOL_SST          => SEAFLUX_MODEL(KTO)%  LINTERPOL_SST
 CINTERPOL_SST          => SEAFLUX_MODEL(KTO)%  CINTERPOL_SST
 LPWEBB                 => SEAFLUX_MODEL(KTO)%  LPWEBB
 NGRVWAVES              => SEAFLUX_MODEL(KTO)%  NGRVWAVES
 XICHCE                 => SEAFLUX_MODEL(KTO)%  XICHCE
 CSEA_ICE               => SEAFLUX_MODEL(KTO)%  CSEA_ICE
 NICE_LAYER             => SEAFLUX_MODEL(KTO)%  NICE_LAYER
 LHANDLE_SIC            => SEAFLUX_MODEL(KTO)%  LHANDLE_SIC
 LSIC_FROM_FILE         => SEAFLUX_MODEL(KTO)%  LSIC_FROM_FILE
 LMISSING_ICE_VARIABLES => SEAFLUX_MODEL(KTO)%  LMISSING_ICE_VARIABLES
 XSST                   => SEAFLUX_MODEL(KTO)%  XSST
 XTICE                  => SEAFLUX_MODEL(KTO)%  XTICE
 XSST_MTH               => SEAFLUX_MODEL(KTO)%  XSST_MTH
 XSST_INI               => SEAFLUX_MODEL(KTO)%  XSST_INI
 XZ0                    => SEAFLUX_MODEL(KTO)%  XZ0
 XZ0H                   => SEAFLUX_MODEL(KTO)%  XZ0H
 XEMIS                  => SEAFLUX_MODEL(KTO)%  XEMIS
 XDIR_ALB               => SEAFLUX_MODEL(KTO)%  XDIR_ALB
 XSCA_ALB               => SEAFLUX_MODEL(KTO)%  XSCA_ALB
 XICE_ALB               => SEAFLUX_MODEL(KTO)%  XICE_ALB
 XUMER                  => SEAFLUX_MODEL(KTO)%  XUMER
 XVMER                  => SEAFLUX_MODEL(KTO)%  XVMER
 XCPL_SEA_WIND          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_WIND
 XCPL_SEA_FWSU          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_FWSU
 XCPL_SEA_FWSV          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_FWSV
 XCPL_SEA_SNET          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_SNET
 XCPL_SEA_HEAT          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_HEAT
 XCPL_SEA_EVAP          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_EVAP
 XCPL_SEA_RAIN          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_RAIN
 XCPL_SEA_SNOW          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_SNOW
 XCPL_SEA_FWSM          => SEAFLUX_MODEL(KTO)%  XCPL_SEA_FWSM
 XCPL_SEAICE_SNET       => SEAFLUX_MODEL(KTO)%  XCPL_SEAICE_SNET
 XCPL_SEAICE_HEAT       => SEAFLUX_MODEL(KTO)%  XCPL_SEAICE_HEAT
 XCPL_SEAICE_EVAP       => SEAFLUX_MODEL(KTO)%  XCPL_SEAICE_EVAP
 TTIME                  => SEAFLUX_MODEL(KTO)%  TTIME
 TZTIME                 => SEAFLUX_MODEL(KTO)%  TZTIME
 LTZTIME_DONE           => SEAFLUX_MODEL(KTO)%  LTZTIME_DONE
 JSX                    => SEAFLUX_MODEL(KTO)%  JSX
 XTSTEP                 => SEAFLUX_MODEL(KTO)%  XTSTEP
 XOUT_TSTEP             => SEAFLUX_MODEL(KTO)%  XOUT_TSTEP

 XICE                   => SEAFLUX_MODEL(KTO)%  XICE
 XSIC                   => SEAFLUX_MODEL(KTO)%  XSIC
 XSIC_MAX               => SEAFLUX_MODEL(KTO)%  XSIC_MAX
 XSIC_MIN               => SEAFLUX_MODEL(KTO)%  XSIC_MIN

IF (LHOOK) CALL DR_HOOK('MODD_SEAFLUX_N:SEAFLUX_GOTO_MODEL',1,ZHOOK_HANDLE)

END SUBROUTINE SEAFLUX_GOTO_MODEL

SUBROUTINE SEAFLUX_ALLOC(KMODEL)
INTEGER, INTENT(IN) :: KMODEL
INTEGER :: J
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_SEAFLUX_N:SEAFLUX_ALLOC",0,ZHOOK_HANDLE)
ALLOCATE(SEAFLUX_MODEL(KMODEL))
DO J=1,KMODEL
    NULLIFY(                                  &
        SEAFLUX_MODEL(J)%XZS,                 &
        SEAFLUX_MODEL(J)%XCOVER,              &
        SEAFLUX_MODEL(J)%LCOVER,              &
        SEAFLUX_MODEL(J)%XSEABATHY,           &
        SEAFLUX_MODEL(J)%XSST,                &
        SEAFLUX_MODEL(J)%XTICE,               &
        SEAFLUX_MODEL(J)%XSST_INI,            &
        SEAFLUX_MODEL(J)%XZ0,                 &
        SEAFLUX_MODEL(J)%XZ0H,                &
        SEAFLUX_MODEL(J)%XEMIS,               &
        SEAFLUX_MODEL(J)%XDIR_ALB,            &
        SEAFLUX_MODEL(J)%XSCA_ALB,            &
        SEAFLUX_MODEL(J)%XICE_ALB,            &
        SEAFLUX_MODEL(J)%XUMER,               &
        SEAFLUX_MODEL(J)%XVMER,               &
        SEAFLUX_MODEL(J)%XSST_MTH,            &
        SEAFLUX_MODEL(J)%XCPL_SEA_WIND,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_FWSU,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_FWSV,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_SNET,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_HEAT,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_EVAP,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_RAIN,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_SNOW,       &
        SEAFLUX_MODEL(J)%XCPL_SEA_FWSM,       &
        SEAFLUX_MODEL(J)%XCPL_SEAICE_SNET,    &
        SEAFLUX_MODEL(J)%XCPL_SEAICE_HEAT,    &
        SEAFLUX_MODEL(J)%XCPL_SEAICE_EVAP,    &

        SEAFLUX_MODEL(J)%XICE,                &
        SEAFLUX_MODEL(J)%XSIC                 )
ENDDO
SEAFLUX_MODEL(:)%LSBL                   = .FALSE.
SEAFLUX_MODEL(:)%LINTERPOL_SST          = .FALSE.
SEAFLUX_MODEL(:)%CINTERPOL_SST          = ' '
SEAFLUX_MODEL(:)%CSEA_FLUX              = ' '
SEAFLUX_MODEL(:)%CSEA_ALB               = ' '
SEAFLUX_MODEL(:)%CSEA_ICE               = ' '
SEAFLUX_MODEL(:)%LPWG                   = .FALSE.
SEAFLUX_MODEL(:)%LPRECIP                = .FALSE.
SEAFLUX_MODEL(:)%LPWEBB                 = .FALSE.
SEAFLUX_MODEL(:)%NGRVWAVES              = 0
SEAFLUX_MODEL(:)%NICE_LAYER             = 0
SEAFLUX_MODEL(:)%XICHCE                 = 0.
SEAFLUX_MODEL(:)%JSX                    = 0
SEAFLUX_MODEL(:)%LTZTIME_DONE           = .FALSE.
SEAFLUX_MODEL(:)%XTSTEP                 = 0.
SEAFLUX_MODEL(:)%XOUT_TSTEP             = 0.
SEAFLUX_MODEL(:)%LHANDLE_SIC            = .FALSE.
SEAFLUX_MODEL(:)%LSIC_FROM_FILE         = .FALSE.
SEAFLUX_MODEL(:)%LMISSING_ICE_VARIABLES = .FALSE.
SEAFLUX_MODEL(:)%XSIC_MAX               = 1.
SEAFLUX_MODEL(:)%XSIC_MAX               = 0.
IF (LHOOK) CALL DR_HOOK("MODD_SEAFLUX_N:SEAFLUX_ALLOC",1,ZHOOK_HANDLE)
END SUBROUTINE SEAFLUX_ALLOC

SUBROUTINE SEAFLUX_DEALLO
USE MODI_DEALLOC_SEAFLUX_n
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_SEAFLUX_N:SEAFLUX_DEALLO",0,ZHOOK_HANDLE)
!TODO: Check deallock seaflux contents, seems like it deallocates not all seaflux variables.
call DEALLOC_SEAFLUX_n
IF (ALLOCATED(SEAFLUX_MODEL)) DEALLOCATE(SEAFLUX_MODEL)
!FIXME: correct deallocation of SEAFLUX_MODEL's components should occur.
IF (LHOOK) CALL DR_HOOK("MODD_SEAFLUX_N:SEAFLUX_DEALLO",1,ZHOOK_HANDLE)
END SUBROUTINE SEAFLUX_DEALLO

END MODULE MODD_SEAFLUX_n
