!     ######################
      MODULE MODD_DIAG_SEAFLUX_n
!     ######################
!
!!****  *MODD_DIAG_SEAFLUX - declaration of diagnostics for SEAFLUX scheme
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!	V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!      S.Senesi    01/2014 : add diags on seaice
!
!*       0.   DECLARATIONS
!             ------------
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

TYPE DIAG_SEAFLUX_t
!------------------------------------------------------------------------------
!
  REAL    :: XDIAG_TSTEP                    !< time step for diagnostics writing
!
  INTEGER :: N2M                            !< flag for 2 meters (and 10 meters) quantities
  LOGICAL :: L2M_MIN_ZS                     !< flag for 2 meters quantities evaluated on
                                            !! the minimum orographyy of the grid
  LOGICAL :: LSURF_BUDGET                   !< flag for surface energy budget
  LOGICAL :: LRAD_BUDGET                    !< flag for radiative energy budget
  LOGICAL :: LCOEF                          !< flag for transfer coefficients
  LOGICAL :: LSURF_VARS                     !< flag for surface variables
  LOGICAL :: LSURF_BUDGETC                  !< flag for surface cumulated energy budget
  LOGICAL :: LRESET_BUDGETC                 !< flag for surface cumulated energy budget

  REAL, POINTER, DIMENSION(:)   :: XSIC     !< Sea ice concentratione.
!
!* averaged variables
!
  REAL, POINTER, DIMENSION(:)   :: XRI      !< Bulk-Richardson number           (-)
  REAL, POINTER, DIMENSION(:)   :: XRI_ICE  !< Seaice Bulk-Richardson number    (-)
  REAL, POINTER, DIMENSION(:)   :: XCD      !< drag coefficient for wind        (W/s2)
  REAL, POINTER, DIMENSION(:)   :: XCD_ICE  !< Seaice drag coefficient for wind (W/s2)
  REAL, POINTER, DIMENSION(:)   :: XCH      !< drag coefficient for heat        (W/s)
  REAL, POINTER, DIMENSION(:)   :: XCH_ICE  !< Seaice drag coefficient for heat (W/s)
  REAL, POINTER, DIMENSION(:)   :: XCE      !< drag coefficient for vapor       (W/s/K)
  REAL, POINTER, DIMENSION(:)   :: XZ0      !< roughness length for momentum    (m)
  REAL, POINTER, DIMENSION(:)   :: XZ0_ICE  !< Seaice roughness length for momentum (m)
  REAL, POINTER, DIMENSION(:)   :: XZ0H     !< roughness length for heat        (m)
  REAL, POINTER, DIMENSION(:)   :: XZ0H_ICE !< Seaice roughness length for heat (m)
  REAL, POINTER, DIMENSION(:)   :: XRN      !< net radiation at surface         (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_ICE  !< Seaice net radiation at surface  (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH       !< sensible heat flux               (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_ICE   !< Seaice  sensible heat flux       (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLE      !< total latent heat flux           (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLEI     !< sublimation latent heat flux     (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX   !< net soil-vegetation flux         (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_ICE !< net soil-vegetation flux (seaice) (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XEVAP    !< total evaporation                (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XSUBL    !< sublimation                      (kg/m2/s)
  REAL, POINTER, DIMENSION(:)   :: XT2M     !< air temperature at 2 meters      (K)
  REAL, POINTER, DIMENSION(:)   :: XT2M_ICE !< Seaice air temperature at 2 meters (K)
  REAL, POINTER, DIMENSION(:)   :: XT2M_MIN !< Minimum air temperature at 2 meters (K)
  REAL, POINTER, DIMENSION(:)   :: XT2M_MAX !< Maximum air temperature at 2 meters (K)
  REAL, POINTER, DIMENSION(:)   :: XQ2M     !< air humidity at 2 meters         (kg/kg)
  REAL, POINTER, DIMENSION(:)   :: XQ2M_ICE !< Seaice air humidity at 2 meters  (kg/kg)
  REAL, POINTER, DIMENSION(:)   :: XHU2M    !< air relative humidity at 2 meters(-)
  REAL, POINTER, DIMENSION(:)   :: XHU2M_ICE!< Seaice air relative humidity at 2 meters(-)
  REAL, POINTER, DIMENSION(:)   :: XHU2M_MIN!< Minimum relative humidity at 2 meters (-)
  REAL, POINTER, DIMENSION(:)   :: XHU2M_MAX!< Maximum relative humidity at 2 meters (-)
  REAL, POINTER, DIMENSION(:)   :: XQS      !< air humidity at surface          (kg/kg)
  REAL, POINTER, DIMENSION(:)   :: XQS_ICE  !< Seaice air humidity at surface   (kg/kg)
  REAL, POINTER, DIMENSION(:)   :: XZON10M  !< zonal wind at 10 meters          (m/s)
  REAL, POINTER, DIMENSION(:)   :: XZON10M_ICE !< Seaice zonal wind at 10 meters(m/s)
  REAL, POINTER, DIMENSION(:)   :: XMER10M  !< meridian wind at 10 meters       (m/s)
  REAL, POINTER, DIMENSION(:)   :: XMER10M_ICE !< Seaice meridian wind at 10 meters (m/s)
  REAL, POINTER, DIMENSION(:)   :: XWIND10M !< wind at 10 meters                (m/s)
  REAL, POINTER, DIMENSION(:)   :: XWIND10M_ICE !< Seaice wind at 10 meters     (m/s)
  REAL, POINTER, DIMENSION(:)   :: XWIND10M_MAX!< Maximum wind at 10 meters     (m/s)
  REAL, POINTER, DIMENSION(:)   :: XLWD     !< downward long wave radiation     (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLWU     !< upward long wave radiation       (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XLWU_ICE !< Seaice upward long wave radiation (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XSWD     !< downward short wave radiation    (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XSWU     !< upward short wave radiation      (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XSWU_ICE !< Seaice upward short wave radiation (W/m2)
  REAL, POINTER, DIMENSION(:,:) :: XSWBD    !< downward short wave radiation by spectral band (W/m2)
  REAL, POINTER, DIMENSION(:,:) :: XSWBU    !< upward short wave radiation by spectral band (W/m2)
  REAL, POINTER, DIMENSION(:,:) :: XSWBU_ICE!< Seaice upward short wave radiation by spectral band (W/m2)
  REAL, POINTER, DIMENSION(:)   :: XFMU     !< horizontal momentum flux zonal    (kg/ms2)
  REAL, POINTER, DIMENSION(:)   :: XFMU_ICE !< Seaice horizontal momentum flux zonal (kg/ms2)
  REAL, POINTER, DIMENSION(:)   :: XFMV     !< horizontal momentum flux meridian (kg/ms2)
  REAL, POINTER, DIMENSION(:)   :: XFMV_ICE !< Seaice horizontal momentum flux meridian (kg/ms2)
!
  REAL, POINTER, DIMENSION(:)   :: XTS     !< surface temperature              (K)
  REAL, POINTER, DIMENSION(:)   :: XTSRAD  !< surface radiative temperature    (K)
!
!* cumulated averaged variables
!
  REAL, POINTER, DIMENSION(:)   :: XRNC     !< net radiation at surface         (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XRN_ICEC !< Seaice net radiation at surface  (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XHC      !< sensible heat flux               (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XH_ICEC  !< Seaice sensible heat flux        (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XLEC     !< total latent heat flux           (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XLEIC    !< sublimation latent heat flux     (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUXC  !< net soil-vegetation flux         (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XGFLUX_ICEC !< Seaice net soil-vegetation flux(J/m2)
  REAL, POINTER, DIMENSION(:)   :: XEVAPC   !< total evaporation                (kg/m2)
  REAL, POINTER, DIMENSION(:)   :: XSUBLC   !< sublimation                      (kg/m2)
  REAL, POINTER, DIMENSION(:)   :: XLWDC    !< downward long wave radiation     (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XLWUC    !< upward long wave radiation       (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XLWU_ICEC!< Seaice upward long wave radiation(J/m2)
  REAL, POINTER, DIMENSION(:)   :: XSWDC    !< downward short wave radiation    (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XSWUC    !< upward short wave radiation      (J/m2)
  REAL, POINTER, DIMENSION(:)   :: XSWU_ICEC!< Seaice upward short wave radiation(J/m2)
  REAL, POINTER, DIMENSION(:)   :: XFMUC    !< horizontal momentum flux zonal    (kg/ms)
  REAL, POINTER, DIMENSION(:)   :: XFMU_ICEC!< Seaice horizontal momentum flux zonal (kg/ms)
  REAL, POINTER, DIMENSION(:)   :: XFMVC    !< horizontal momentum flux meridian (kg/ms)
  REAL, POINTER, DIMENSION(:)   :: XFMV_ICEC!< Seaice horizontal momentum flux meridian (kg/ms)
!
!------------------------------------------------------------------------------
!
END TYPE DIAG_SEAFLUX_t

TYPE (DIAG_SEAFLUX_t), ALLOCATABLE, TARGET, SAVE :: DIAG_SEAFLUX_MODEL(:)

REAL, POINTER :: XDIAG_TSTEP=>NULL()
!$OMP THREADPRIVATE(XDIAG_TSTEP)
INTEGER, POINTER :: N2M=>NULL()
!$OMP THREADPRIVATE(N2M)
LOGICAL, POINTER :: L2M_MIN_ZS=>NULL()
!$OMP THREADPRIVATE(L2M_MIN_ZS)
LOGICAL, POINTER :: LSURF_BUDGET=>NULL()
!$OMP THREADPRIVATE(LSURF_BUDGET)
LOGICAL, POINTER :: LRAD_BUDGET=>NULL()
!$OMP THREADPRIVATE(LRAD_BUDGET)
LOGICAL, POINTER :: LCOEF=>NULL()
!$OMP THREADPRIVATE(LCOEF)
LOGICAL, POINTER :: LSURF_VARS=>NULL()
!$OMP THREADPRIVATE(LSURF_VARS)
LOGICAL, POINTER :: LSURF_BUDGETC=>NULL()
!$OMP THREADPRIVATE(LSURF_BUDGETC)
LOGICAL, POINTER :: LRESET_BUDGETC=>NULL()
!$OMP THREADPRIVATE(LRESET_BUDGETC)
REAL, POINTER, DIMENSION(:)   :: XRI            =>NULL()
!$OMP THREADPRIVATE(XRI)
REAL, POINTER, DIMENSION(:)   :: XRI_ICE        =>NULL()
!$OMP THREADPRIVATE(XRI_ICE)
REAL, POINTER, DIMENSION(:)   :: XCD            =>NULL()
!$OMP THREADPRIVATE(XCD)
REAL, POINTER, DIMENSION(:)   :: XCD_ICE        =>NULL()
!$OMP THREADPRIVATE(XCD_ICE)
REAL, POINTER, DIMENSION(:)   :: XCH            =>NULL()
!$OMP THREADPRIVATE(XCH)
REAL, POINTER, DIMENSION(:)   :: XCH_ICE        =>NULL()
!$OMP THREADPRIVATE(XCH_ICE)
REAL, POINTER, DIMENSION(:)   :: XCE            =>NULL()
!$OMP THREADPRIVATE(XCE)
REAL, POINTER, DIMENSION(:)   :: XZ0            =>NULL()
!$OMP THREADPRIVATE(XZ0)
REAL, POINTER, DIMENSION(:)   :: XZ0_ICE        =>NULL()
!$OMP THREADPRIVATE(XZ0_ICE)
REAL, POINTER, DIMENSION(:)   :: XZ0H           =>NULL()
!$OMP THREADPRIVATE(XZ0H)
REAL, POINTER, DIMENSION(:)   :: XZ0H_ICE       =>NULL()
!$OMP THREADPRIVATE(XZ0H_ICE)
REAL, POINTER, DIMENSION(:)   :: XRN            =>NULL()
!$OMP THREADPRIVATE(XRN)
REAL, POINTER, DIMENSION(:)   :: XRN_ICE        =>NULL()
!$OMP THREADPRIVATE(XRN_ICE)
REAL, POINTER, DIMENSION(:)   :: XH             =>NULL()
!$OMP THREADPRIVATE(XH)
REAL, POINTER, DIMENSION(:)   :: XH_ICE         =>NULL()
!$OMP THREADPRIVATE(XH_ICE)
REAL, POINTER, DIMENSION(:)   :: XLE            =>NULL()
!$OMP THREADPRIVATE(XLE)
REAL, POINTER, DIMENSION(:)   :: XLEI           =>NULL()
!$OMP THREADPRIVATE(XLEI)
REAL, POINTER, DIMENSION(:)   :: XGFLUX         =>NULL()
!$OMP THREADPRIVATE(XGFLUX)
REAL, POINTER, DIMENSION(:)   :: XGFLUX_ICE     =>NULL()
!$OMP THREADPRIVATE(XGFLUX_ICE)
REAL, POINTER, DIMENSION(:)   :: XEVAP          =>NULL()
!$OMP THREADPRIVATE(XEVAP)
REAL, POINTER, DIMENSION(:)   :: XSUBL          =>NULL()
!$OMP THREADPRIVATE(XSUBL)
REAL, POINTER, DIMENSION(:)   :: XT2M           =>NULL()
!$OMP THREADPRIVATE(XT2M)
REAL, POINTER, DIMENSION(:)   :: XT2M_ICE       =>NULL()
!$OMP THREADPRIVATE(XT2M_ICE)
REAL, POINTER, DIMENSION(:)   :: XT2M_MIN       =>NULL()
!$OMP THREADPRIVATE(XT2M_MIN)
REAL, POINTER, DIMENSION(:)   :: XT2M_MAX       =>NULL()
!$OMP THREADPRIVATE(XT2M_MAX)
REAL, POINTER, DIMENSION(:)   :: XQ2M           =>NULL()
!$OMP THREADPRIVATE(XQ2M)
REAL, POINTER, DIMENSION(:)   :: XQ2M_ICE       =>NULL()
!$OMP THREADPRIVATE(XQ2M_ICE)
REAL, POINTER, DIMENSION(:)   :: XHU2M          =>NULL()
!$OMP THREADPRIVATE(XHU2M)
REAL, POINTER, DIMENSION(:)   :: XHU2M_ICE      =>NULL()
!$OMP THREADPRIVATE(XHU2M_ICE)
REAL, POINTER, DIMENSION(:)   :: XHU2M_MIN      =>NULL()
!$OMP THREADPRIVATE(XHU2M_MIN)
REAL, POINTER, DIMENSION(:)   :: XHU2M_MAX      =>NULL()
!$OMP THREADPRIVATE(XHU2M_MAX)
REAL, POINTER, DIMENSION(:)   :: XQS            =>NULL()
!$OMP THREADPRIVATE(XQS)
REAL, POINTER, DIMENSION(:)   :: XQS_ICE        =>NULL()
!$OMP THREADPRIVATE(XQS_ICE)
REAL, POINTER, DIMENSION(:)   :: XZON10M        =>NULL()
!$OMP THREADPRIVATE(XZON10M)
REAL, POINTER, DIMENSION(:)   :: XZON10M_ICE    =>NULL()
!$OMP THREADPRIVATE(XZON10M_ICE)
REAL, POINTER, DIMENSION(:)   :: XMER10M        =>NULL()
!$OMP THREADPRIVATE(XMER10M)
REAL, POINTER, DIMENSION(:)   :: XMER10M_ICE    =>NULL()
!$OMP THREADPRIVATE(XMER10M_ICE)
REAL, POINTER, DIMENSION(:)   :: XWIND10M       =>NULL()
!$OMP THREADPRIVATE(XWIND10M)
REAL, POINTER, DIMENSION(:)   :: XWIND10M_ICE   =>NULL()
!$OMP THREADPRIVATE(XWIND10M_ICE)
REAL, POINTER, DIMENSION(:)   :: XWIND10M_MAX   =>NULL()
!$OMP THREADPRIVATE(XWIND10M_MAX)
REAL, POINTER, DIMENSION(:)   :: XLWD           =>NULL()
!$OMP THREADPRIVATE(XLWD)
REAL, POINTER, DIMENSION(:)   :: XLWU           =>NULL()
!$OMP THREADPRIVATE(XLWU)
REAL, POINTER, DIMENSION(:)   :: XLWU_ICE       =>NULL()
!$OMP THREADPRIVATE(XLWU_ICE)
REAL, POINTER, DIMENSION(:)   :: XSWD           =>NULL()
!$OMP THREADPRIVATE(XSWD)
REAL, POINTER, DIMENSION(:)   :: XSWU           =>NULL()
!$OMP THREADPRIVATE(XSWU)
REAL, POINTER, DIMENSION(:)   :: XSWU_ICE       =>NULL()
!$OMP THREADPRIVATE(XSWU_ICE)
REAL, POINTER, DIMENSION(:,:) :: XSWBD          =>NULL()
!$OMP THREADPRIVATE(XSWBD)
REAL, POINTER, DIMENSION(:,:) :: XSWBU          =>NULL()
!$OMP THREADPRIVATE(XSWBU)
REAL, POINTER, DIMENSION(:,:) :: XSWBU_ICE      =>NULL()
!$OMP THREADPRIVATE(XSWBU_ICE)
REAL, POINTER, DIMENSION(:)   :: XFMU           =>NULL()
!$OMP THREADPRIVATE(XFMU)
REAL, POINTER, DIMENSION(:)   :: XFMU_ICE       =>NULL()
!$OMP THREADPRIVATE(XFMU_ICE)
REAL, POINTER, DIMENSION(:)   :: XFMV           =>NULL()
!$OMP THREADPRIVATE(XFMV)
REAL, POINTER, DIMENSION(:)   :: XFMV_ICE       =>NULL()
!$OMP THREADPRIVATE(XFMV_ICE)
REAL, POINTER, DIMENSION(:)   :: XRNC           =>NULL()
!$OMP THREADPRIVATE(XRNC)
REAL, POINTER, DIMENSION(:)   :: XRN_ICEC       =>NULL()
!$OMP THREADPRIVATE(XRN_ICEC)
REAL, POINTER, DIMENSION(:)   :: XHC            =>NULL()
!$OMP THREADPRIVATE(XHC)
REAL, POINTER, DIMENSION(:)   :: XH_ICEC        =>NULL()
!$OMP THREADPRIVATE(XH_ICEC)
REAL, POINTER, DIMENSION(:)   :: XLEC           =>NULL()
!$OMP THREADPRIVATE(XLEC)
REAL, POINTER, DIMENSION(:)   :: XLEIC          =>NULL()
!$OMP THREADPRIVATE(XLEIC)
REAL, POINTER, DIMENSION(:)   :: XGFLUXC        =>NULL()
!$OMP THREADPRIVATE(XGFLUXC)
REAL, POINTER, DIMENSION(:)   :: XGFLUX_ICEC    =>NULL()
!$OMP THREADPRIVATE(XGFLUX_ICEC)
REAL, POINTER, DIMENSION(:)   :: XEVAPC         =>NULL()
!$OMP THREADPRIVATE(XEVAPC)
REAL, POINTER, DIMENSION(:)   :: XSUBLC         =>NULL()
!$OMP THREADPRIVATE(XSUBLC)
REAL, POINTER, DIMENSION(:)   :: XLWDC          =>NULL()
!$OMP THREADPRIVATE(XLWDC)
REAL, POINTER, DIMENSION(:)   :: XLWUC          =>NULL()
!$OMP THREADPRIVATE(XLWUC)
REAL, POINTER, DIMENSION(:)   :: XLWU_ICEC      =>NULL()
!$OMP THREADPRIVATE(XLWU_ICEC)
REAL, POINTER, DIMENSION(:)   :: XSWDC          =>NULL()
!$OMP THREADPRIVATE(XSWDC)
REAL, POINTER, DIMENSION(:)   :: XSWUC          =>NULL()
!$OMP THREADPRIVATE(XSWUC)
REAL, POINTER, DIMENSION(:)   :: XSWU_ICEC      =>NULL()
!$OMP THREADPRIVATE(XSWU_ICEC)
REAL, POINTER, DIMENSION(:)   :: XFMUC          =>NULL()
!$OMP THREADPRIVATE(XFMUC)
REAL, POINTER, DIMENSION(:)   :: XFMU_ICEC      =>NULL()
!$OMP THREADPRIVATE(XFMU_ICEC)
REAL, POINTER, DIMENSION(:)   :: XFMVC          =>NULL()
!$OMP THREADPRIVATE(XFMVC)
REAL, POINTER, DIMENSION(:)   :: XFMV_ICEC      =>NULL()
!$OMP THREADPRIVATE(XFMV_ICEC)
REAL, POINTER, DIMENSION(:)   :: XTS            =>NULL()
!$OMP THREADPRIVATE(XTS)
REAL, POINTER, DIMENSION(:)   :: XTSRAD         =>NULL()
!$OMP THREADPRIVATE(XTSRAD)
REAL, POINTER, DIMENSION(:)   :: XSIC           =>NULL()
!$OMP THREADPRIVATE(XSIC)

CONTAINS

SUBROUTINE DIAG_SEAFLUX_GOTO_MODEL(KFROM, KTO, LKFROM)
LOGICAL, INTENT(IN) :: LKFROM
INTEGER, INTENT(IN) :: KFROM, KTO
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! Save current state for allocated arrays
IF (LKFROM) THEN
DIAG_SEAFLUX_MODEL(KFROM)%XRI           => XRI
DIAG_SEAFLUX_MODEL(KFROM)%XRI_ICE       => XRI_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XCD           => XCD
DIAG_SEAFLUX_MODEL(KFROM)%XCD_ICE       => XCD_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XCH           => XCH
DIAG_SEAFLUX_MODEL(KFROM)%XCH_ICE       => XCH_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XCE           => XCE
DIAG_SEAFLUX_MODEL(KFROM)%XZ0           => XZ0
DIAG_SEAFLUX_MODEL(KFROM)%XZ0_ICE       => XZ0_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XZ0H          => XZ0H
DIAG_SEAFLUX_MODEL(KFROM)%XZ0H_ICE      => XZ0H_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XRN           => XRN
DIAG_SEAFLUX_MODEL(KFROM)%XRN_ICE       => XRN_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XH            => XH
DIAG_SEAFLUX_MODEL(KFROM)%XH_ICE        => XH_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XLE           => XLE
DIAG_SEAFLUX_MODEL(KFROM)%XLEI          => XLEI
DIAG_SEAFLUX_MODEL(KFROM)%XGFLUX        => XGFLUX
DIAG_SEAFLUX_MODEL(KFROM)%XGFLUX_ICE    => XGFLUX_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XEVAP         => XEVAP
DIAG_SEAFLUX_MODEL(KFROM)%XSUBL         => XSUBL
DIAG_SEAFLUX_MODEL(KFROM)%XT2M          => XT2M
DIAG_SEAFLUX_MODEL(KFROM)%XT2M_ICE      => XT2M_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XT2M_MIN      => XT2M_MIN
DIAG_SEAFLUX_MODEL(KFROM)%XT2M_MAX      => XT2M_MAX
DIAG_SEAFLUX_MODEL(KFROM)%XQ2M          => XQ2M
DIAG_SEAFLUX_MODEL(KFROM)%XQ2M_ICE      => XQ2M_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XHU2M         => XHU2M
DIAG_SEAFLUX_MODEL(KFROM)%XHU2M_ICE     => XHU2M_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XHU2M_MIN     => XHU2M_MIN
DIAG_SEAFLUX_MODEL(KFROM)%XHU2M_MAX     => XHU2M_MAX
DIAG_SEAFLUX_MODEL(KFROM)%XQS           => XQS
DIAG_SEAFLUX_MODEL(KFROM)%XQS_ICE       => XQS_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XZON10M       => XZON10M
DIAG_SEAFLUX_MODEL(KFROM)%XZON10M_ICE   => XZON10M_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XMER10M       => XMER10M
DIAG_SEAFLUX_MODEL(KFROM)%XMER10M_ICE   => XMER10M_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XWIND10M      => XWIND10M
DIAG_SEAFLUX_MODEL(KFROM)%XWIND10M_ICE  => XWIND10M_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XWIND10M_MAX  => XWIND10M_MAX
DIAG_SEAFLUX_MODEL(KFROM)%XLWD          => XLWD
DIAG_SEAFLUX_MODEL(KFROM)%XLWU          => XLWU
DIAG_SEAFLUX_MODEL(KFROM)%XLWU_ICE      => XLWU_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XSWD          => XSWD
DIAG_SEAFLUX_MODEL(KFROM)%XSWU          => XSWU
DIAG_SEAFLUX_MODEL(KFROM)%XSWU_ICE      => XSWU_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XSWBD         => XSWBD
DIAG_SEAFLUX_MODEL(KFROM)%XSWBU         => XSWBU
DIAG_SEAFLUX_MODEL(KFROM)%XSWBU_ICE     => XSWBU_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XFMU          => XFMU
DIAG_SEAFLUX_MODEL(KFROM)%XFMU_ICE      => XFMU_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XFMV          => XFMV
DIAG_SEAFLUX_MODEL(KFROM)%XFMV_ICE      => XFMV_ICE
DIAG_SEAFLUX_MODEL(KFROM)%XRNC          => XRNC
DIAG_SEAFLUX_MODEL(KFROM)%XRN_ICEC      => XRN_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XHC           => XHC
DIAG_SEAFLUX_MODEL(KFROM)%XH_ICEC       => XH_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XLEC          => XLEC
DIAG_SEAFLUX_MODEL(KFROM)%XLEIC         => XLEIC
DIAG_SEAFLUX_MODEL(KFROM)%XGFLUXC       => XGFLUXC
DIAG_SEAFLUX_MODEL(KFROM)%XGFLUX_ICEC   => XGFLUX_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XEVAPC        => XEVAPC
DIAG_SEAFLUX_MODEL(KFROM)%XSUBLC        => XSUBLC
DIAG_SEAFLUX_MODEL(KFROM)%XLWDC         => XLWDC
DIAG_SEAFLUX_MODEL(KFROM)%XLWUC         => XLWUC
DIAG_SEAFLUX_MODEL(KFROM)%XLWU_ICEC     => XLWU_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XSWDC         => XSWDC
DIAG_SEAFLUX_MODEL(KFROM)%XSWUC         => XSWUC
DIAG_SEAFLUX_MODEL(KFROM)%XSWU_ICEC     => XSWU_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XFMUC         => XFMUC
DIAG_SEAFLUX_MODEL(KFROM)%XFMU_ICEC     => XFMU_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XFMVC         => XFMVC
DIAG_SEAFLUX_MODEL(KFROM)%XFMV_ICEC     => XFMV_ICEC
DIAG_SEAFLUX_MODEL(KFROM)%XTS           => XTS
DIAG_SEAFLUX_MODEL(KFROM)%XTSRAD        => XTSRAD
DIAG_SEAFLUX_MODEL(KFROM)%XSIC          => XSIC
ENDIF
!
! Current model is set to model KTO
IF (LHOOK) CALL DR_HOOK('MODD_DIAG_SEAFLUX_N:DIAG_SEAFLUX_GOTO_MODEL',0,ZHOOK_HANDLE)

XDIAG_TSTEP     =>DIAG_SEAFLUX_MODEL(KTO)%XDIAG_TSTEP
N2M             =>DIAG_SEAFLUX_MODEL(KTO)%N2M
L2M_MIN_ZS      =>DIAG_SEAFLUX_MODEL(KTO)%L2M_MIN_ZS
LSURF_BUDGET    =>DIAG_SEAFLUX_MODEL(KTO)%LSURF_BUDGET
LRAD_BUDGET     =>DIAG_SEAFLUX_MODEL(KTO)%LRAD_BUDGET
LCOEF           =>DIAG_SEAFLUX_MODEL(KTO)%LCOEF
LSURF_VARS      =>DIAG_SEAFLUX_MODEL(KTO)%LSURF_VARS
LSURF_BUDGETC   =>DIAG_SEAFLUX_MODEL(KTO)%LSURF_BUDGETC
LRESET_BUDGETC  =>DIAG_SEAFLUX_MODEL(KTO)%LRESET_BUDGETC
XRI             =>DIAG_SEAFLUX_MODEL(KTO)%XRI
XRI_ICE         =>DIAG_SEAFLUX_MODEL(KTO)%XRI_ICE
XCD             =>DIAG_SEAFLUX_MODEL(KTO)%XCD
XCD_ICE         =>DIAG_SEAFLUX_MODEL(KTO)%XCD_ICE
XCH             =>DIAG_SEAFLUX_MODEL(KTO)%XCH
XCH_ICE         =>DIAG_SEAFLUX_MODEL(KTO)%XCH_ICE
XCE             =>DIAG_SEAFLUX_MODEL(KTO)%XCE
XZ0             =>DIAG_SEAFLUX_MODEL(KTO)%XZ0
XZ0_ICE         =>DIAG_SEAFLUX_MODEL(KTO)%XZ0_ICE
XZ0H            =>DIAG_SEAFLUX_MODEL(KTO)%XZ0H
XZ0H_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XZ0H_ICE
XRN             =>DIAG_SEAFLUX_MODEL(KTO)%XRN
XRN_ICE         =>DIAG_SEAFLUX_MODEL(KTO)%XRN_ICE
XH              =>DIAG_SEAFLUX_MODEL(KTO)%XH
XH_ICE          =>DIAG_SEAFLUX_MODEL(KTO)%XH_ICE
XLE             =>DIAG_SEAFLUX_MODEL(KTO)%XLE
XLEI            =>DIAG_SEAFLUX_MODEL(KTO)%XLEI
XGFLUX          =>DIAG_SEAFLUX_MODEL(KTO)%XGFLUX
XGFLUX_ICE      =>DIAG_SEAFLUX_MODEL(KTO)%XGFLUX_ICE
XEVAP           =>DIAG_SEAFLUX_MODEL(KTO)%XEVAP
XSUBL           =>DIAG_SEAFLUX_MODEL(KTO)%XSUBL
XT2M            =>DIAG_SEAFLUX_MODEL(KTO)%XT2M
XT2M_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XT2M_ICE
XT2M_MIN        =>DIAG_SEAFLUX_MODEL(KTO)%XT2M_MIN
XT2M_MAX        =>DIAG_SEAFLUX_MODEL(KTO)%XT2M_MAX
XQ2M            =>DIAG_SEAFLUX_MODEL(KTO)%XQ2M
XQ2M_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XQ2M_ICE
XHU2M           =>DIAG_SEAFLUX_MODEL(KTO)%XHU2M
XHU2M_ICE       =>DIAG_SEAFLUX_MODEL(KTO)%XHU2M_ICE
XHU2M_MIN       =>DIAG_SEAFLUX_MODEL(KTO)%XHU2M_MIN
XHU2M_MAX       =>DIAG_SEAFLUX_MODEL(KTO)%XHU2M_MAX
XQS             =>DIAG_SEAFLUX_MODEL(KTO)%XQS
XQS_ICE         =>DIAG_SEAFLUX_MODEL(KTO)%XQS_ICE
XZON10M         =>DIAG_SEAFLUX_MODEL(KTO)%XZON10M
XZON10M_ICE     =>DIAG_SEAFLUX_MODEL(KTO)%XZON10M_ICE
XMER10M         =>DIAG_SEAFLUX_MODEL(KTO)%XMER10M
XMER10M_ICE     =>DIAG_SEAFLUX_MODEL(KTO)%XMER10M_ICE
XWIND10M        =>DIAG_SEAFLUX_MODEL(KTO)%XWIND10M
XWIND10M_ICE    =>DIAG_SEAFLUX_MODEL(KTO)%XWIND10M_ICE
XWIND10M_MAX    =>DIAG_SEAFLUX_MODEL(KTO)%XWIND10M_MAX
XLWD            =>DIAG_SEAFLUX_MODEL(KTO)%XLWD
XLWU            =>DIAG_SEAFLUX_MODEL(KTO)%XLWU
XLWU_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XLWU_ICE
XSWD            =>DIAG_SEAFLUX_MODEL(KTO)%XSWD
XSWU            =>DIAG_SEAFLUX_MODEL(KTO)%XSWU
XSWU_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XSWU_ICE
XSWBD           =>DIAG_SEAFLUX_MODEL(KTO)%XSWBD
XSWBU           =>DIAG_SEAFLUX_MODEL(KTO)%XSWBU
XSWBU_ICE       =>DIAG_SEAFLUX_MODEL(KTO)%XSWBU_ICE
XFMU            =>DIAG_SEAFLUX_MODEL(KTO)%XFMU
XFMU_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XFMU_ICE
XFMV            =>DIAG_SEAFLUX_MODEL(KTO)%XFMV
XFMV_ICE        =>DIAG_SEAFLUX_MODEL(KTO)%XFMV_ICE
XRNC            =>DIAG_SEAFLUX_MODEL(KTO)%XRNC
XRN_ICEC        =>DIAG_SEAFLUX_MODEL(KTO)%XRN_ICEC
XHC             =>DIAG_SEAFLUX_MODEL(KTO)%XHC
XH_ICEC         =>DIAG_SEAFLUX_MODEL(KTO)%XH_ICEC
XLEC            =>DIAG_SEAFLUX_MODEL(KTO)%XLEC
XLEIC           =>DIAG_SEAFLUX_MODEL(KTO)%XLEIC
XGFLUXC         =>DIAG_SEAFLUX_MODEL(KTO)%XGFLUXC
XGFLUX_ICEC     =>DIAG_SEAFLUX_MODEL(KTO)%XGFLUX_ICEC
XEVAPC          =>DIAG_SEAFLUX_MODEL(KTO)%XEVAPC
XSUBLC          =>DIAG_SEAFLUX_MODEL(KTO)%XSUBLC
XLWDC           =>DIAG_SEAFLUX_MODEL(KTO)%XLWDC
XLWUC           =>DIAG_SEAFLUX_MODEL(KTO)%XLWUC
XLWU_ICEC       =>DIAG_SEAFLUX_MODEL(KTO)%XLWU_ICEC
XSWDC           =>DIAG_SEAFLUX_MODEL(KTO)%XSWDC
XSWUC           =>DIAG_SEAFLUX_MODEL(KTO)%XSWUC
XSWU_ICEC       =>DIAG_SEAFLUX_MODEL(KTO)%XSWU_ICEC
XFMUC           =>DIAG_SEAFLUX_MODEL(KTO)%XFMUC
XFMU_ICEC       =>DIAG_SEAFLUX_MODEL(KTO)%XFMU_ICEC
XFMVC           =>DIAG_SEAFLUX_MODEL(KTO)%XFMVC
XFMV_ICEC       =>DIAG_SEAFLUX_MODEL(KTO)%XFMV_ICEC
XTS             =>DIAG_SEAFLUX_MODEL(KTO)%XTS
XTSRAD          =>DIAG_SEAFLUX_MODEL(KTO)%XTSRAD
XSIC            =>DIAG_SEAFLUX_MODEL(KTO)%XSIC
IF (LHOOK) CALL DR_HOOK('MODD_DIAG_SEAFLUX_N:DIAG_SEAFLUX_GOTO_MODEL',1,ZHOOK_HANDLE)


END SUBROUTINE DIAG_SEAFLUX_GOTO_MODEL

SUBROUTINE DIAG_SEAFLUX_ALLOC(KMODEL)
INTEGER, INTENT(IN) :: KMODEL
INTEGER :: J
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_SEAFLUX_N:DIAG_SEAFLUX_ALLOC",0,ZHOOK_HANDLE)
ALLOCATE(DIAG_SEAFLUX_MODEL(KMODEL))
DO J=1,KMODEL
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XRI)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XRI_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XCD)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XCD_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XCH)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XCH_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XCE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XZ0)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XZ0_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XZ0H)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XZ0H_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XRN)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XRN_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XH)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XH_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLEI)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XGFLUX)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XGFLUX_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XEVAP)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSUBL)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XT2M)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XT2M_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XT2M_MIN)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XT2M_MAX)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XQ2M)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XQ2M_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XHU2M)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XHU2M_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XHU2M_MIN)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XHU2M_MAX)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XQS)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XQS_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XZON10M)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XZON10M_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XMER10M)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XMER10M_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XWIND10M)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XWIND10M_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XWIND10M_MAX)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLWD)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLWU)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLWU_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWD)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWU)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWU_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWBD)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWBU)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWBU_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMU)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMU_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMV)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMV_ICE)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XTS)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XTSRAD)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XRNC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XRN_ICEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XHC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XH_ICEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLEIC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XGFLUXC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XGFLUX_ICEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XEVAPC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSUBLC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLWDC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLWUC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XLWU_ICEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWDC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWUC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSWU_ICEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMUC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMU_ICEC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMVC)
  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XFMV_ICEC)

  NULLIFY(DIAG_SEAFLUX_MODEL(J)%XSIC)
ENDDO
DIAG_SEAFLUX_MODEL(:)%XDIAG_TSTEP=0.
DIAG_SEAFLUX_MODEL(:)%N2M=0
DIAG_SEAFLUX_MODEL(:)%L2M_MIN_ZS=.FALSE.
DIAG_SEAFLUX_MODEL(:)%LSURF_BUDGET=.FALSE.
DIAG_SEAFLUX_MODEL(:)%LRAD_BUDGET=.FALSE.
DIAG_SEAFLUX_MODEL(:)%LCOEF=.FALSE.
DIAG_SEAFLUX_MODEL(:)%LSURF_VARS=.FALSE.
DIAG_SEAFLUX_MODEL(:)%LSURF_BUDGETC=.FALSE.
DIAG_SEAFLUX_MODEL(:)%LRESET_BUDGETC=.FALSE.
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_SEAFLUX_N:DIAG_SEAFLUX_ALLOC",1,ZHOOK_HANDLE)
END SUBROUTINE DIAG_SEAFLUX_ALLOC

SUBROUTINE DIAG_SEAFLUX_DEALLO
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_SEAFLUX_N:DIAG_SEAFLUX_DEALLO",0,ZHOOK_HANDLE)
IF (ALLOCATED(DIAG_SEAFLUX_MODEL)) DEALLOCATE(DIAG_SEAFLUX_MODEL)
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_SEAFLUX_N:DIAG_SEAFLUX_DEALLO",1,ZHOOK_HANDLE)
END SUBROUTINE DIAG_SEAFLUX_DEALLO

END MODULE MODD_DIAG_SEAFLUX_n
