!===============================================================================
!> Linear interpolate between two points. Interpolated array also contains values
!! from the boundaries.
!
! AUTHOR
! Y. Batrak
!
! MODIFICATIONS
! Original  04/2014
!===============================================================================
subroutine lin_space( a, b, x, y )
  use YOMHOOK,    only: LHOOK, DR_HOOK
  use PARKIND1,   only: JPRB
  implicit none
    real, intent( in  ) :: a, &         !< Lower boundary value
                           b            !< Upper boundary value
    real, intent( in  ) :: x( :       ) !< Grid
    real, intent( out ) :: y( size(x) ) !< Interpolated values in gridpoints

    real                :: k
    integer             :: i, n

    real( KIND = JPRB ) :: ZHOOK_HANDLE

    if( LHOOK ) call DR_HOOK( 'LIN_SPACE', 0, ZHOOK_HANDLE )

    n = size( x )

    k = (b - a)/( x( n ) - x( 1 ) )

    do i = 1, n
        y( i ) = k*( x( i ) - x( 1 ) ) + a
    end do

    if( LHOOK ) call DR_HOOK( 'LIN_SPACE', 1, ZHOOK_HANDLE )
end subroutine
