!     #########
SUBROUTINE DIAG_INLINE_SEAFLUX_n(PTSTEP, PTA, PSST, PQA, &
     PPA, PPS, PRHOA, PZONA,                             &
     PMERA, PHT, PHW, PCD, PCDN, PCH, PCE, PRI, PHU,     &
     PZ0, PZ0H, PQSAT, PSFTH, PSFTQ, PSFZON, PSFMER,     &
     PDIR_SW, PSCA_SW, PLW, PDIR_ALB, PSCA_ALB, PICE_ALB,&
     PEMIS, PTRAD, PRAIN, PSNOW,                         &
     PSIC, OHANDLE_SIC, PTICE,                           &
     PCD_ICE, PCDN_ICE, PCH_ICE, PCE_ICE, PRI_ICE,       &
     PZ0_ICE, PZ0H_ICE, PQSAT_ICE, PSFTH_ICE, PSFTQ_ICE, &
     PSFZON_ICE, PSFMER_ICE )

!     #####################################################################################
!
!!****  *DIAG_INLINE_SEAFLUX_n * - computes diagnostics during SEAFLUX time-step
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!     V. Masson
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!      B. Decharme 08/2009 : Diag for Earth System Model Coupling
!!      S. Riette   06/2009 CLS_2M becomes CLS_TQ, CLS_TQ and CLS_WIND have one
!!                          more argument (height of diagnostic)
!!      B. Decharme 04/2013 : Add EVAP and SUBL diag
!!      S. Senesi   01/2014 ! introduce fractional seaice and sea-ice model
!!      Y. Batrak   06/2014 : correct case of empty ice mask
!!------------------------------------------------------------------
!

!
!
USE MODD_CSTS,           ONLY : XTTS
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_SURF_ATM,       ONLY : LCPL_ESM
USE MODD_SEAFLUX_n,      ONLY : LSBL
USE MODD_DIAG_SEAFLUX_n, ONLY : N2M, LSURF_BUDGET, LCOEF, LSURF_VARS,       &
                                       XT2M, XQ2M, XHU2M, XZON10M, XMER10M,   &
                                       XRN, XH, XLE, XGFLUX, XRI, XCD, XCH,   &
                                       XCE, XZ0, XZ0H, XQS, XSWD, XSWU, XLWD, &
                                       XLWU, XSWBD, XSWBU, XFMU, XFMV, XLEI,  &
                                       LSURF_BUDGETC, XT2M_MIN, XT2M_MAX,     &
                                       XTS, XTSRAD, XHU2M_MIN, XHU2M_MAX,     &
                                       XWIND10M, XWIND10M_MAX, XEVAP, XSUBL,  &
                                       XT2M_ICE, XQ2M_ICE, XHU2M_ICE,         &
                                       XZON10M_ICE, XMER10M_ICE, XWIND10M_ICE,&
                                       XRN_ICE, XH_ICE, XGFLUX_ICE, XRI_ICE,  &
                                       XCD_ICE, XCH_ICE,                      &
                                       XZ0_ICE, XZ0H_ICE, XQS_ICE, XSWU_ICE,  &
                                       XLWU_ICE, XSWBU_ICE, XFMU_ICE, XFMV_ICE, XSIC
!
USE MODN_SEAFLUX_n, ONLY : LNEW_AVG_DRAG
!USE MODD_DIAG_SEAICE_n, ONLY : LDIAG_SEAICE, XSIT, XSND, XMLT
!USE MODE_GLT_STATS , ONLY : GLT_AVHICEM, GLT_AVHSNWM
USE MODI_PARAM_CLS
USE MODI_CLS_TQ
USE MODI_CLS_WIND
USE MODI_DIAG_SURF_BUDGET_SEA
USE MODI_DIAG_SURF_BUDGETC_SEA
USE MODI_DIAG_CPL_ESM_SEA
!USE MODD_TYPES_GLT,   ONLY : T_GLT
USE MODI_AVG_DRAG
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
REAL,                INTENT(IN) :: PTSTEP      !< atmospheric time-step                 (s)
REAL, DIMENSION(:),  INTENT(IN) :: PTA         !< atmospheric temperature
REAL, DIMENSION(:),  INTENT(IN) :: PSST        !< sea surface temperature
REAL, DIMENSION(:),  INTENT(IN) :: PQA         !< atmospheric specific humidity
REAL, DIMENSION(:),  INTENT(IN) :: PPA         !< atmospheric level pressure
REAL, DIMENSION(:),  INTENT(IN) :: PPS         !< surface pressure
REAL, DIMENSION(:),  INTENT(IN) :: PRHOA       !< air density
REAL, DIMENSION(:),  INTENT(IN) :: PZONA       !< zonal wind
REAL, DIMENSION(:),  INTENT(IN) :: PMERA       !< meridian wind
REAL, DIMENSION(:),  INTENT(IN) :: PHT         !< atmospheric level height
REAL, DIMENSION(:),  INTENT(IN) :: PHW         !< atmospheric level height for wind
REAL, DIMENSION(:),  INTENT(IN) :: PCD         !< drag coefficient for momentum
REAL, DIMENSION(:),  INTENT(IN) :: PCDN        !< neutral drag coefficient
REAL, DIMENSION(:),  INTENT(IN) :: PCH         !< drag coefficient for heat
REAL, DIMENSION(:),  INTENT(IN) :: PCE         !< drag coefficient for vapor
REAL, DIMENSION(:),  INTENT(IN) :: PRI         !< Richardson number
REAL, DIMENSION(:),  INTENT(IN) :: PHU         !< near-surface humidity
REAL, DIMENSION(:),  INTENT(IN) :: PZ0         !< roughness length for momentum
REAL, DIMENSION(:),  INTENT(IN) :: PZ0H        !< roughness length for heat
REAL, DIMENSION(:),  INTENT(IN) :: PQSAT       !< humidity at saturation
REAL, DIMENSION(:),  INTENT(IN) :: PSFZON      !< zonal friction
REAL, DIMENSION(:),  INTENT(IN) :: PSFMER      !< meridian friction
REAL, DIMENSION(:),  INTENT(IN) :: PSFTH       !< heat flux  (W/m2)
REAL, DIMENSION(:),  INTENT(IN) :: PSFTQ       !< water flux (kg/m2/s)
REAL, DIMENSION(:,:),INTENT(IN) :: PDIR_SW     !< direct  solar radiation (on horizontal surf.)
                                               !!                                       (W/m2)
REAL, DIMENSION(:,:),INTENT(IN) :: PSCA_SW     !< diffuse solar radiation (on horizontal surf.)
                                               !!                                       (W/m2)
REAL, DIMENSION(:),  INTENT(IN) :: PLW         !< longwave radiation (on horizontal surf.)
REAL, DIMENSION(:),  INTENT(IN) :: PTRAD       !< radiative temperature                 (K)
REAL, DIMENSION(:,:),INTENT(IN) :: PDIR_ALB    !< direct albedo for each spectral band  (-)
REAL, DIMENSION(:,:),INTENT(IN) :: PSCA_ALB    !< diffuse albedo for each spectral band (-)
REAL, DIMENSION(:)  ,INTENT(IN) :: PICE_ALB    !< seaice albedo
REAL, DIMENSION(:),  INTENT(IN) :: PEMIS       !< emissivity                            (-)

REAL, DIMENSION(:),  INTENT(IN) :: PRAIN       !< Rainfall (kg/m2/s)
REAL, DIMENSION(:),  INTENT(IN) :: PSNOW       !< Snowfall (kg/m2/s)

REAL, DIMENSION(:),  INTENT(IN) :: PSIC        !< Sea-ice cover

LOGICAL,             INTENT(IN) :: OHANDLE_SIC !< Do we weight seaice and open sea fluxes
REAL, DIMENSION(:),  INTENT(IN) :: PTICE       !< Seaice Surface Temperature
REAL, DIMENSION(:),  INTENT(IN) :: PCD_ICE     !< drag coefficient for momentum
REAL, DIMENSION(:),  INTENT(IN) :: PCDN_ICE    !< neutral drag coefficient
REAL, DIMENSION(:),  INTENT(IN) :: PCH_ICE     !< drag coefficient for heat
REAL, DIMENSION(:),  INTENT(IN) :: PCE_ICE     !< drag coefficient for vapor
REAL, DIMENSION(:),  INTENT(IN) :: PRI_ICE     !< Richardson number
REAL, DIMENSION(:),  INTENT(IN) :: PZ0_ICE     !< roughness length for momentum
REAL, DIMENSION(:),  INTENT(IN) :: PZ0H_ICE    !< roughness length for heat
REAL, DIMENSION(:),  INTENT(IN) :: PQSAT_ICE   !< humidity at saturation
REAL, DIMENSION(:),  INTENT(IN) :: PSFTH_ICE   !< heat flux  (W/m2)
REAL, DIMENSION(:),  INTENT(IN) :: PSFTQ_ICE   !< water flux (kg/m2/s)
REAL, DIMENSION(:),  INTENT(IN) :: PSFZON_ICE  !< zonal friction
REAL, DIMENSION(:),  INTENT(IN) :: PSFMER_ICE  !< meridian friction
!
!*      0.2    declarations of local variables
!
LOGICAL                         :: GSIC
REAL, DIMENSION(SIZE(PTA))      :: ZZ0W
REAL, DIMENSION(SIZE(PTA))      :: ZH
REAL, DIMENSION(SIZE(PTA))      :: ZRI, ZSST, ZCD_AVG, ZCDN_AVG

INTEGER                         :: I_NUM
INTEGER                         :: J_POINT
INTEGER                         :: I_ICE_MASK( SIZE(PTA) )
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DIAG_INLINE_SEAFLUX_N',0,ZHOOK_HANDLE)
!
! * Mean surface temperature need to couple with AGCM
!
IF (OHANDLE_SIC) THEN
   XSIC  (:) = PSIC(:)
   XTS   (:) = (1 - PSIC(:)) * PSST(:) + PSIC(:) * PTICE(:)
   XTSRAD(:) = PTRAD(:)
ELSE
   XTS   (:) = PSST (:)
   WHERE( PTICE(:) /= XUNDEF ) XTS(:) = PTICE(:)
   XTSRAD(:) = PTRAD(:)
ENDIF

ZSST = XTS
!
IF (.NOT. LSBL) THEN
!
  IF (N2M==1) THEN
    CALL PARAM_CLS(PTA, ZSST, PQA, PPA, PRHOA, PZONA, PMERA, PHT, PHW, &
         PSFTH, PSFTQ, PSFZON, PSFMER,                                 &
         XT2M, XQ2M, XHU2M, XZON10M, XMER10M )
    IF (OHANDLE_SIC) THEN
       CALL PARAM_CLS(PTA, PTICE, PQA, PPA, PRHOA, PZONA, PMERA, PHT, PHW, &
            PSFTH_ICE, PSFTQ_ICE, PSFZON_ICE, PSFMER_ICE,                  &
            XT2M_ICE, XQ2M_ICE, XHU2M_ICE, XZON10M_ICE, XMER10M_ICE  )
    ENDIF
  ELSE IF (N2M==2) THEN
    ZH(:)=2.
    CALL CLS_TQ(PTA, PQA, PPA, PPS, PHT,          &
                  PCD, PCH, PRI,                  &
                  ZSST, PHU, PZ0H, ZH,            &
                  XT2M, XQ2M, XHU2M)
    ZH(:)=10.
    CALL CLS_WIND(PZONA, PMERA, PHW,              &
                    PCD, PCDN, PRI, ZH,           &
                    XZON10M, XMER10M)
    IF (OHANDLE_SIC) THEN
        I_NUM = 0
        DO J_POINT = 1, SIZE(PSIC)
            IF( PSIC(J_POINT) > 0. ) THEN
                I_NUM = I_NUM + 1
                I_ICE_MASK(I_NUM) = J_POINT
            END IF
        END DO
        ZH(:)=2.

        CALL CLS_TQ(                          &
            PTA     ( I_ICE_MASK( :I_NUM ) ), &
            PQA     ( I_ICE_MASK( :I_NUM ) ), &
            PPA     ( I_ICE_MASK( :I_NUM ) ), &
            PPS     ( I_ICE_MASK( :I_NUM ) ), &
            PHT     ( I_ICE_MASK( :I_NUM ) ), &
            PCD_ICE ( I_ICE_MASK( :I_NUM ) ), &
            PCH_ICE ( I_ICE_MASK( :I_NUM ) ), &
            PRI_ICE ( I_ICE_MASK( :I_NUM ) ), &
            PTICE   ( I_ICE_MASK( :I_NUM ) ), &
            PHU     ( I_ICE_MASK( :I_NUM ) ), &
            PZ0H_ICE( I_ICE_MASK( :I_NUM ) ), &
            ZH      ( I_ICE_MASK( :I_NUM ) ), &

            XT2M_ICE ( :I_NUM ),    &
            XQ2M_ICE ( :I_NUM ),    &
            XHU2M_ICE( :I_NUM )     )

        ZH(:)=10.
        CALL CLS_WIND(              &
            PZONA   ( I_ICE_MASK( :I_NUM ) ), &
            PMERA   ( I_ICE_MASK( :I_NUM ) ), &
            PHW     ( I_ICE_MASK( :I_NUM ) ), &
            PCD_ICE ( I_ICE_MASK( :I_NUM ) ), &
            PCDN_ICE( I_ICE_MASK( :I_NUM ) ), &
            PRI_ICE ( I_ICE_MASK( :I_NUM ) ), &
            ZH      ( I_ICE_MASK( :I_NUM ) ), &

            XZON10M_ICE( :I_NUM ),            &
            XMER10M_ICE( :I_NUM )             )

        XT2M_ICE   ( I_ICE_MASK( :I_NUM ) ) = XT2M_ICE   ( :I_NUM )
        XQ2M_ICE   ( I_ICE_MASK( :I_NUM ) ) = XQ2M_ICE   ( :I_NUM )
        XHU2M_ICE  ( I_ICE_MASK( :I_NUM ) ) = XHU2M_ICE  ( :I_NUM )

        XZON10M_ICE( I_ICE_MASK( :I_NUM ) ) = XZON10M_ICE( :I_NUM )
        XMER10M_ICE( I_ICE_MASK( :I_NUM ) ) = XMER10M_ICE( :I_NUM )

        WHERE( PSIC == 0. )
            XT2M_ICE    = XUNDEF
            XQ2M_ICE    = XUNDEF
            XHU2M_ICE   = XUNDEF
            XZON10M_ICE = XUNDEF
            XMER10M_ICE = XUNDEF
        END WHERE
    ENDIF
  END IF

!
  IF (N2M>=1) THEN
     IF (OHANDLE_SIC) THEN
        XT2M    = XT2M    * (1 - PSIC) + XT2M_ICE    * PSIC
        XQ2M    = XQ2M    * (1 - PSIC) + XQ2M_ICE    * PSIC
        XHU2M   = XHU2M   * (1 - PSIC) + XHU2M_ICE   * PSIC
        XZON10M = XZON10M * (1 - PSIC) + XZON10M_ICE * PSIC
        XMER10M = XMER10M * (1 - PSIC) + XMER10M_ICE * PSIC

        !
        ZRI     = PRI     * (1 - PSIC) + PRI_ICE     * PSIC

        IF(LNEW_AVG_DRAG) THEN
          CALL AVG_DRAG( PZ0, PCD, PCDN, PCD_ICE, PCDN_ICE, PSIC, ZCD_AVG, ZCDN_AVG )
          CALL CLS_WIND(PZONA, PMERA, PHW, ZCD_AVG, ZCDN_AVG, ZRI, ZH, XZON10M, XMER10M)
        ENDIF
        XWIND10M_ICE(:) = SQRT(XZON10M_ICE**2+XMER10M_ICE**2)
     ELSE
        ZRI=PRI
     ENDIF
    !
    XT2M_MIN(:)     = MIN(XT2M_MIN(:),XT2M(:))
    XT2M_MAX(:)     = MAX(XT2M_MAX(:),XT2M(:))
    !
    XHU2M_MIN(:)    = MIN(XHU2M_MIN(:),XHU2M(:))
    XHU2M_MAX(:)    = MAX(XHU2M_MAX(:),XHU2M(:))
    !
    XWIND10M    (:) = SQRT(XZON10M**2+XMER10M**2)
    XWIND10M_MAX(:) = MAX(XWIND10M_MAX(:),XWIND10M(:))
    !
    !* Richardson number
    XRI     = ZRI
    XRI_ICE = PRI_ICE
    !
  ENDIF
!
ELSE
  IF (N2M>=1) THEN
    XT2M    = XUNDEF
    XQ2M    = XUNDEF
    XHU2M   = XUNDEF
    XZON10M = XUNDEF
    XMER10M = XUNDEF
    XRI     = PRI
  ENDIF
ENDIF
!
IF (LSURF_BUDGET.OR.LSURF_BUDGETC) THEN
!
  CALL  DIAG_SURF_BUDGET_SEA   (XTTS, ZSST, PRHOA, PSFTH, PSFTH_ICE,    &
                                  PSFTQ, PSFTQ_ICE,                     &
                                  PDIR_SW, PSCA_SW, PLW,                &
                                  PDIR_ALB, PSCA_ALB,PICE_ALB, PEMIS, PTRAD,&
                                  PSFZON, PSFZON_ICE, PSFMER,PSFMER_ICE,&
                                  OHANDLE_SIC, PSIC, PTICE,            &
                                  XRN, XH, XLE, XLEI, XGFLUX,           &
                                  XSWD, XSWU, XSWBD, XSWBU, XLWD, XLWU, &
                                  XFMU, XFMV, XEVAP, XSUBL,             &
                                  XRN_ICE, XH_ICE, XGFLUX_ICE,          &
                                  XSWU_ICE, XSWBU_ICE, XLWU_ICE,        &
                                  XFMU_ICE, XFMV_ICE                    )
!
END IF
!
IF(LSURF_BUDGETC)THEN
  CALL DIAG_SURF_BUDGETC_SEA(PTSTEP, XRN, XH, XLE, XLEI, XGFLUX,  &
                               XSWD, XSWU, XLWD, XLWU, XFMU, XFMV,&
                               XEVAP, XSUBL,                      &
                               XRN_ICE, XH_ICE, XGFLUX_ICE,       &
                               XSWU_ICE, XLWU_ICE, XFMU_ICE, XFMV_ICE)
ENDIF
!
IF (LCOEF) THEN
   IF (OHANDLE_SIC) THEN
      !
      !* Transfer coefficients
      !
      IF(LNEW_AVG_DRAG)THEN
        XCD  = ZCD_AVG
      ELSE
        XCD  = (1 - PSIC) * PCD + PSIC * PCD_ICE
      ENDIF
      XCH  = (1 - PSIC) * PCH + PSIC * PCH_ICE
      XCE  = (1 - PSIC) * PCE + PSIC * PCE_ICE

      XCD_ICE  = PCD_ICE
      XCH_ICE  = PCH_ICE
      XZ0_ICE  = PZ0_ICE
      XZ0H_ICE = PZ0H_ICE
      !
      !* Roughness lengths
      !
      ZZ0W = ( 1 - PSIC ) * 1.0/(LOG(PHW/PZ0)    **2)  +  &
                   PSIC   * 1.0/(LOG(PHW/PZ0_ICE)**2)
      XZ0  = PHW  * EXP ( - SQRT ( 1./  ZZ0W ))
      ZZ0W = ( 1 - PSIC ) * 1.0/(LOG(PHW/PZ0H)    **2)  +  &
                   PSIC   * 1.0/(LOG(PHW/PZ0H_ICE)**2)
      XZ0H = PHW  * EXP ( - SQRT ( 1./  ZZ0W ))
      !
   ELSE
      !
      !* Transfer coefficients
      !
      XCD  = PCD
      XCH  = PCH
      XCE  = PCE
      !
      !* Roughness lengths
      !
      XZ0  = PZ0
      XZ0H = PZ0H
   ENDIF
   !
ENDIF
!
IF (LSURF_VARS) THEN
  !
  !* Humidity at saturation
  !
   IF (OHANDLE_SIC) THEN
      XQS = (1 - PSIC) * PQSAT + PSIC * PQSAT_ICE
      XQS_ICE = PQSAT_ICE
   ELSE
      XQS = PQSAT
   ENDIF
ENDIF
!
! Diags from embedded Seaice model
! CALL DIAG_INLINE_SEAICE() : simply  :
!
!IF (LDIAG_SEAICE) THEN
!  IF (TRIM(CSEAICE_SCHEME) == 'GELATO') THEN
!      GELATO_DIM=SIZE(PTA)
!      XSIT  = RESHAPE(glt_avhicem(TPGLT%dom,TPGLT%sit),(/GELATO_DIM/))
!      XSND  = RESHAPE(glt_avhsnwm(TPGLT%dom,TPGLT%sit),(/GELATO_DIM/))
!      XMLT  = TPGLT%oce_all(:,1)%tml
!   ELSE
!      ! Placeholder for an alternate seaice scheme
!   ENDIF
!ENDIF
!
! Diags for Earth System Model coupling or for embedded Seaice model
! (we are actually using XCPL_.. variables for feeding the seaice model)
!
IF (LCPL_ESM) THEN
!
  CALL DIAG_CPL_ESM_SEA(PTSTEP,XZON10M,XMER10M,XFMU,XFMV,  &
                          XSWD,XSWU,XGFLUX,PSFTQ,PRAIN,    &
                          PSNOW,PLW,PTICE,PSFTH_ICE,       &
                          PSFTQ_ICE,PDIR_SW,PSCA_SW          )
!
ENDIF
IF (LHOOK) CALL DR_HOOK('DIAG_INLINE_SEAFLUX_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_INLINE_SEAFLUX_n
