!     ###############################################################################
SUBROUTINE COUPLING_SEAFLUX_n(HPROGRAM, HCOUPLING,                                           &
                 PTSTEP, KYEAR, KMONTH, KDAY, PTIME, KI, KSV, KSW, PTSUN, PZENITH, PZENITH2, &
                 PAZIM, PZREF, PUREF, PZS, PU, PV, PQA, PTA, PRHOA, PSV, PCO2, HSV,          &
                 PRAIN, PSNOW, PLW, PDIR_SW, PSCA_SW, PSW_BANDS, PPS, PPA,                   &
                 PSFTQ, PSFTH, PSFTS, PSFCO2, PSFU, PSFV,                                    &
                 PTRAD, PDIR_ALB, PSCA_ALB, PEMIS,                                           &
                 PPEW_A_COEF, PPEW_B_COEF,                                                   &
                 PPET_A_COEF, PPEQ_A_COEF, PPET_B_COEF, PPEQ_B_COEF,                         &
                 HTEST                                                                       )
!     ###############################################################################
!
!!****  *COUPLING_SEAFLUX_n * - Driver of the WATER_FLUX scheme for sea
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!     V. Masson
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!      Modified    09/2006 : P. Tulet Introduce Sea salt aerosol Emission/Deposition
!!      Modified    03/2009 : B. Decharme SST could change during a run => ALB and EMIS
!!      Modified    05/2009 : V. Masson : implicitation of momentum fluxes
!!      Modified    09/2009 : B. Decharme Radiative properties at time t+1
!!      Modified    01/2010 : B. Decharme Add XTTS
!!      Modified    04/2014 : Y. Batrak Provide atmospheric radiation to ecume scheme,
!!                  06/2014             introduced ice fraction
!!---------------------------------------------------------------------
!
USE MODD_CSTS,              ONLY :  &
    XRD,                            &
    XCPD,                           &
    XP00,                           &
    XLVTT,                          &
    XTTS,                           &
    XDAY,                           &
    XTTSI,                          &
    XTT
USE MODD_SURF_PAR,          ONLY :  &
    XUNDEF
USE MODD_SURF_ATM,          ONLY :  &
    LCPL_ESM
USE MODD_DATA_SEAFLUX_n,    ONLY :  &
    LSST_DATA
USE MODD_SEAFLUX_n,         ONLY :  &
    XSST,                           &
    XTICE,                          &
    XZ0,                            &
    XDIR_ALB,                       &
    XSCA_ALB,                       &
    XEMIS,                          &
    TTIME,                          &
    CSEA_ALB,                       &
    CSEA_FLUX,                      &
    XUMER,                          &
    XVMER,                          &
    LINTERPOL_SST,                  &
    CSEA_ICE,                       &
    NICE_LAYER,                     &
    XICE,                           &
    LHANDLE_SIC,                    &
    XSIC,                           &
    LSIC_FROM_FILE,                 &
    XSIC_MAX,                       &
    XSIC_MIN

USE MODD_OCEAN_n,           ONLY :  &
    LMERCATOR
USE MODD_CH_SEAFLUX_n,      ONLY :  &
    CSV,                            &
    CCH_DRY_DEP,                    &
    XDEP,                           &
    NBEQ,                           &
    NSV_CHSBEG,                     &
    NSV_CHSEND,                     &
    NSV_DSTBEG,                     &
    NSV_DSTEND,                     &
    NAEREQ,                         &
    NDSTEQ,                         &
    NSLTEQ,                         &
    NSV_AERBEG,                     &
    NSV_AEREND,                     &
    NSV_SLTBEG,                     &
    NSV_SLTEND
USE MODN_SEAFLUX_n,         ONLY :  &
    LNEW_AVG_DRAG
!
USE MODI_WATER_FLUX
USE MODI_MR98
USE MODI_ECUME_SEAFLUX
USE MODI_COARE30_SEAFLUX
USE MODI_ADD_FORECAST_TO_DATE_SURF
USE MODI_MOD1D_n
USE MODI_DIAG_INLINE_SEAFLUX_n
USE MODI_CH_AER_DEP
USE MODI_CH_DEP_WATER
USE MODI_DSLT_DEP
USE MODI_SST_UPDATE
USE MODI_INTERPOL_SST_MTH
USE MODI_UPDATE_RAD_SEAWAT
!
USE MODE_DSLT_SURF
USE MODD_DST_SURF
USE MODD_SLT_SURF
USE MODD_DST_n,             ONLY: XEMISRADIUS_DST, XEMISSIG_DST
USE MODD_SLT_n,             ONLY: XEMISRADIUS_SLT, XEMISSIG_SLT
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
USE MODI_COUPLING_SEA_ICE
!
USE MODI_COUPLING_SLT_n
USE MODI_AVG_DRAG
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
CHARACTER(LEN=6),                    INTENT(IN) :: HPROGRAM   ! program calling surf. schemes
CHARACTER(LEN=1),                    INTENT(IN) :: HCOUPLING  ! type of coupling
                                                              ! 'E' : explicit
                                                              ! 'I' : implicit
INTEGER,                             INTENT(IN) :: KYEAR      ! current year (UTC)
INTEGER,                             INTENT(IN) :: KMONTH     ! current month (UTC)
INTEGER,                             INTENT(IN) :: KDAY       ! current day (UTC)
REAL,                                INTENT(IN) :: PTIME      ! current time since midnight (UTC, s)
INTEGER,                             INTENT(IN) :: KI         ! number of points
INTEGER,                             INTENT(IN) :: KSV        ! number of scalars
INTEGER,                             INTENT(IN) :: KSW        ! number of short-wave spectral bands
REAL,             DIMENSION(KI    ), INTENT(IN) :: PTSUN      ! solar time                    (s from midnight)
REAL,                                INTENT(IN) :: PTSTEP     ! atmospheric time-step                 (s)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PZREF      ! height of T,q forcing                 (m)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PUREF      ! height of wind forcing                (m)
!
REAL,             DIMENSION(KI    ), INTENT(IN) :: PTA        ! air temperature forcing               (K)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PQA        ! air humidity forcing                  (kg/m3)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PRHOA      ! air density                           (kg/m3)
REAL,             DIMENSION(KI,KSV), INTENT(IN) :: PSV        ! scalar variables
!                                                             ! chemistry:   first char. in HSV: '#'  (molecule/m3)
!                                                             !
CHARACTER(LEN=6), DIMENSION(KSV   ), INTENT(IN) :: HSV        ! name of all scalar variables
REAL,             DIMENSION(KI    ), INTENT(IN) :: PU         ! zonal wind                            (m/s)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PV         ! meridian wind                         (m/s)
REAL,             DIMENSION(KI,KSW), INTENT(IN) :: PDIR_SW    ! direct  solar radiation (on horizontal surf.)
!                                             !                                       (W/m2)
REAL,             DIMENSION(KI,KSW), INTENT(IN) :: PSCA_SW    ! diffuse solar radiation (on horizontal surf.)
!                                             !                                       (W/m2)
REAL,             DIMENSION(KSW   ), INTENT(IN) :: PSW_BANDS  ! mean wavelength of each shortwave band (m)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PZENITH    ! zenithal angle at t  (radian from the vertical)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PZENITH2   ! zenithal angle at t+1(radian from the vertical)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PAZIM      ! azimuthal angle      (radian from North, clockwise)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PLW        ! longwave radiation (on horizontal surf.)
!                                             !                                       (W/m2)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPS        ! pressure at atmospheric model surface (Pa)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPA        ! pressure at forcing level             (Pa)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PZS        ! atmospheric model orography           (m)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PCO2       ! CO2 concentration in the air          (kg/m3)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PSNOW      ! snow precipitation                    (kg/m2/s)
REAL,             DIMENSION(KI    ), INTENT(IN) :: PRAIN      ! liquid precipitation                  (kg/m2/s)
!
!
REAL,             DIMENSION(KI    ), INTENT(OUT):: PSFTH      ! flux of heat                          (W/m2)
REAL,             DIMENSION(KI    ), INTENT(OUT):: PSFTQ      ! flux of water vapor                   (kg/m2/s)
REAL,             DIMENSION(KI    ), INTENT(OUT):: PSFU       ! zonal momentum flux                   (Pa)
REAL,             DIMENSION(KI    ), INTENT(OUT):: PSFV       ! meridian momentum flux                (Pa)
REAL,             DIMENSION(KI    ), INTENT(OUT):: PSFCO2     ! flux of CO2                           (kg/m2/s)
REAL,             DIMENSION(KI,KSV), INTENT(OUT):: PSFTS      ! flux of scalar var.                   (kg/m2/s)
!
REAL,             DIMENSION(KI    ), INTENT(OUT):: PTRAD      ! radiative temperature                 (K)
REAL,             DIMENSION(KI,KSW), INTENT(OUT):: PDIR_ALB   ! direct albedo for each spectral band  (-)
REAL,             DIMENSION(KI,KSW), INTENT(OUT):: PSCA_ALB   ! diffuse albedo for each spectral band (-)
REAL,             DIMENSION(KI    ), INTENT(OUT):: PEMIS      ! emissivity                            (-)
!
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPEW_A_COEF! implicit coefficients
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPEW_B_COEF! needed if HCOUPLING='I'
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPET_A_COEF
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPEQ_A_COEF
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPET_B_COEF
REAL,             DIMENSION(KI    ), INTENT(IN) :: PPEQ_B_COEF
CHARACTER(LEN=2),                    INTENT(IN) :: HTEST      ! must be equal to 'OK'
!
!*      0.2    declarations of local variables
!
REAL, DIMENSION(KI) :: ZEXNA      ! Exner function at forcing level
REAL, DIMENSION(KI) :: ZEXNS      ! Exner function at surface level
REAL, DIMENSION(KI) :: ZU         ! zonal wind
REAL, DIMENSION(KI) :: ZV         ! meridian wind
REAL, DIMENSION(KI) :: ZWIND      ! Wind
REAL, DIMENSION(KI) :: ZCD        ! Drag coefficient
REAL, DIMENSION(KI) :: ZCDN       ! Neutral Drag coefficient
REAL, DIMENSION(KI) :: ZCH        ! Heat transfer coefficient
REAL, DIMENSION(KI) :: ZCE        ! Vaporization heat transfer coefficient
REAL, DIMENSION(KI) :: ZRI        ! Richardson number
REAL, DIMENSION(KI) :: ZHU        ! Near surface relative humidity
REAL, DIMENSION(KI) :: ZRESA_SEA  ! aerodynamical resistance
REAL, DIMENSION(KI) :: ZUSTAR     ! friction velocity (m/s)
REAL, DIMENSION(KI) :: ZZ0H       ! heat roughness length over sea
REAL, DIMENSION(KI) :: ZQSAT      ! humidity at saturation
REAL, DIMENSION(KI) :: ZQA        ! specific humidity (kg/kg)
REAL, DIMENSION(KI) :: ZEMIS      ! Emissivity at time t
REAL, DIMENSION(KI) :: ZTRAD      ! Radiative temperature at time t
REAL, DIMENSION(KI) :: ZSFTH_ICE  ! Sea ice flux of heat
REAL, DIMENSION(KI) :: ZSFTQ_ICE  ! Sea ice flux of ice sublimation
!
REAL, DIMENSION(KI,KSW) :: ZDIR_ALB   ! Direct albedo at time t
REAL, DIMENSION(KI,KSW) :: ZSCA_ALB   ! Diffuse albedo at time t
!
REAL, DIMENSION(KI), TARGET      :: ZMASK ! Sea/ice mask
REAL                             :: ZCONVERTFACM0_SLT, ZCONVERTFACM0_DST
REAL                             :: ZCONVERTFACM3_SLT, ZCONVERTFACM3_DST
REAL                             :: ZCONVERTFACM6_SLT, ZCONVERTFACM6_DST
INTEGER                          :: ISIZE_WATER  ! number of points of sea water
INTEGER                          :: ISIZE_ICE    ! and of sea ice
!
INTEGER                          :: ISWB       ! number of shortwave spectral bands
INTEGER                          :: JSWB       ! loop counter on shortwave spectral bands
INTEGER                          :: ISLT       ! number of sea salt variable

REAL, DIMENSION(KI)              :: ZALBEDO, ZSURF_TMP
REAL, DIMENSION(KI)      :: &
    ZQSAT_ICE,              &   ! Humidity at saturation over sea ice.
    ZZ0_ICE,                &   ! Roughness length for momentum over sea ice.
    ZUSTAR_ICE,             &   ! Friction velocity over sea ice.
    ZCD_ICE,                &   ! Drag coefficient over sea ice.
    ZCDN_ICE,               &   ! Neutral drag coefficient over sea ice.
    ZCH_ICE,                &   ! Heat transfer coefficient over sea ice.
    ZRI_ICE,                &   ! Richardson number over sea ice.
    ZRESA_ICE,              &   ! Aerodynamical resistance over sea ice.
    ZZ0H_ICE,               &   ! Roughness length for heat over sea ice.

    ZSFU,                   &   ! Zonal momentum flux.
    ZSFV,                   &   ! Meredianal momentum flux.
    ZSFTH,                  &   ! Heat flux.
    ZSFTQ,                  &   ! Water vapour flux.

    ZSFU_ICE,               &   ! Zonal momentum flux over sea ice.
    ZSFV_ICE,               &   ! Meredianal momentum flux over sea ice.

    ZZ0W,                   &
    ZCD_AVG,                &
    ZCDN_AVG,               &
    ZTOTAL_SW
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------------
! Preliminaries:
!-------------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('COUPLING_SEAFLUX_N',0,ZHOOK_HANDLE)
IF (HTEST/='OK') THEN
  CALL ABOR1_SFX('COUPLING_SEAFLUXN: FATAL ERROR DURING ARGUMENT TRANSFER')
END IF
!-------------------------------------------------------------------------------------
!
ZEXNA    (:)    = XUNDEF
ZEXNS    (:)    = XUNDEF
ZU       (:)    = XUNDEF
ZV       (:)    = XUNDEF
ZWIND    (:)    = XUNDEF
ZCD      (:)    = XUNDEF
ZCDN     (:)    = XUNDEF
ZCH      (:)    = XUNDEF
ZCE      (:)    = XUNDEF
ZRI      (:)    = XUNDEF
ZHU      (:)    = XUNDEF
ZRESA_SEA(:)    = XUNDEF
ZUSTAR   (:)    = XUNDEF
ZZ0H     (:)    = XUNDEF
ZQSAT    (:)    = XUNDEF
ZEMIS    (:)    = XUNDEF
ZTRAD    (:)    = XUNDEF
ZDIR_ALB (:,:)  = XUNDEF
ZSCA_ALB (:,:)  = XUNDEF
!
IF(LCPL_ESM)THEN
  ZSFTQ_ICE(:) = XUNDEF
  ZSFTH_ICE(:) = XUNDEF
ENDIF
!
!-------------------------------------------------------------------------------------
!
ZEXNS(:)     = (PPS(:)/XP00)**(XRD/XCPD)
ZEXNA(:)     = (PPA(:)/XP00)**(XRD/XCPD)
!
IF(LCPL_ESM)THEN
  !Sea currents are taken into account
  ZU(:)=PU(:)-XUMER(:)
  ZV(:)=PV(:)-XVMER(:)
ELSE
  ZU(:)=PU(:)
  ZV(:)=PV(:)
ENDIF
!
ZWIND(:) = SQRT(ZU(:)**2+ZV(:)**2)
!
PSFTS(:,:) = 0.
!
ZHU = 1.
!
ZQA(:) = PQA(:) / PRHOA(:)
!
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! update sea surface temperature
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
IF (LSST_DATA) THEN
   CALL SST_UPDATE(XSST, TTIME)
ENDIF
!
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Time evolution
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
TTIME%TIME = TTIME%TIME + PTSTEP
CALL ADD_FORECAST_TO_DATE_SURF(TTIME%TDATE%YEAR,TTIME%TDATE%MONTH,TTIME%TDATE%DAY,TTIME%TIME)
!
!--------------------------------------------------------------------------------------
! Fluxes over water according to Charnock formulae
!--------------------------------------------------------------------------------------
!
IF( LHANDLE_SIC ) THEN
    IF( .NOT. LSIC_FROM_FILE ) THEN
        WHERE( XSST(:) > XTT - 1 )
            ZMASK = 0.
        ELSEWHERE
            ZMASK = (XTT - 1.0 - XSST)/0.6
        END WHERE
        WHERE( ZMASK > 1. ) ZMASK = 1.

        ISIZE_WATER = COUNT( ZMASK(:) < 1. )
        ISIZE_ICE   = COUNT( ZMASK(:) > 0. )

        XSIC = ZMASK
    ELSE
        !XTICE(:,1) = XSST(:)
        WHERE( XSIC > XSIC_MAX ) XSIC = 1.0
        WHERE( XSIC < 1.E-6 ) XSIC = XSIC_MIN

        IF(index(CSEA_ICE,'NONE')==0) &
            WHERE( XSST(:) < XTTSI ) XSST = XTTSI
        ISIZE_WATER = COUNT( XSIC(:) < 1. )
        ISIZE_ICE   = COUNT( XSIC(:) > 0. )

        ZMASK = XSIC
    END IF
    CALL XICE%REM( .NOT. XSIC > 0 )
ELSE
    ZMASK(:)    = XSST(:) - XTTS
    ISIZE_WATER = COUNT(ZMASK(:)>=0.)
    ISIZE_ICE   = SIZE(XSST) - ISIZE_WATER
    CALL XICE%REM( ZMASK >= 0. )
END IF
!
SELECT CASE (CSEA_FLUX)
  CASE ('DIRECT')
    CALL WATER_FLUX(XZ0,                                              &
                      PTA, ZEXNA, PRHOA, XSST, ZEXNS, ZQA, PRAIN,     &
                      PSNOW, XTTS,                                    &
                      ZWIND, PZREF, PUREF,                            &
                      PPS, ZQSAT,                                     &
                      ZSFTH, ZSFTQ, ZUSTAR,                           &
                      ZCD, ZCDN, ZCH, ZRI, ZRESA_SEA, ZZ0H            )
  CASE ('ITERAT')
    CALL MR98      (XZ0,                                              &
                      PTA, ZEXNA, PRHOA, XSST, ZEXNS, ZQA,            &
                      XTTS,                                           &
                      ZWIND, PZREF, PUREF,                            &
                      PPS, ZQSAT,                                     &
                      ZSFTH, ZSFTQ, ZUSTAR,                           &
                      ZCD, ZCDN, ZCH, ZRI, ZRESA_SEA, ZZ0H            )

  CASE ('ECUME ')
    ZTOTAL_SW = sum(PDIR_SW,2)+sum(PSCA_SW,2)
    CALL ECUME_SEAFLUX(PTSTEP, XZ0, ZMASK, ISIZE_WATER, ISIZE_ICE,    &
                      PTA, ZEXNA ,PRHOA, XSST, ZEXNS, ZQA, PRAIN,     &
                      PSNOW,                                          &
                      ZWIND, PZREF, PUREF,                            &
                      PPS, ZQSAT,                                     &
                      ZSFTH, ZSFTQ, ZUSTAR,                           &
                      ZCD, ZCDN, ZCH, ZCE, ZRI, ZRESA_SEA, ZZ0H,      &
                      NICE_LAYER,XTICE, ZTOTAL_SW, PLW,               &
                      PPEW_A_COEF ,PPEW_B_COEF ,PPET_A_COEF ,PPEQ_A_COEF ,PPET_B_COEF ,PPEQ_B_COEF )

  CASE ('COARE3')
    CALL COARE30_SEAFLUX(XZ0, ZMASK, ISIZE_WATER, ISIZE_ICE,            &
                      PTA, ZEXNA ,PRHOA, XSST, ZEXNS, ZQA, PRAIN,       &
                      PSNOW,                                            &
                      ZWIND, PZREF, PUREF,                              &
                      PPS, ZQSAT,                                       &
                      ZSFTH, ZSFTQ, ZUSTAR,                             &
                      ZCD, ZCDN, ZCH, ZCE, ZRI, ZRESA_SEA, ZZ0H       )
END SELECT
!
!-------------------------------------------------------------------------------------
! Outputs:
!-------------------------------------------------------------------------------------
!
! Momentum fluxes
!

ZUSTAR(:) = SQRT(  (ZCD(:)*ZWIND(:)*PPEW_B_COEF(:))/                &
                    (1.0 - PRHOA(:)*ZCD(:)*ZWIND(:)*PPEW_A_COEF(:))     )

CALL SEA_MOMENTUM_FLUXES(ZCD, ZSFU, ZSFV)

!
! CO2 flux
!
PSFCO2(:)       =  0.0    !! Assumes no emission over oceans !!!!!
!
!-------------------------------------------------------------------------------------
!radiative properties at time t
!-------------------------------------------------------------------------------------
!
ISWB = SIZE(PSW_BANDS)
!
DO JSWB=1,ISWB
  ZDIR_ALB(:,JSWB) = XDIR_ALB(:)
  ZSCA_ALB(:,JSWB) = XSCA_ALB(:)
END DO
!
ZEMIS  = XEMIS
ZTRAD  = XSST
!
!-------------------------------------------------------------------------------------
!Specific fields for GELATO when using earth system model
!(intermediate step before explicit sea and ice fluxes comutation)
!-------------------------------------------------------------------------------------
!
IF(LCPL_ESM .OR. LHANDLE_SIC )THEN
  CALL COUPLING_SEA_ICE(PTSTEP, KI, XSIC, PTA, ZEXNA, PRHOA, XTICE, ZEXNS, &
                            ZQA, PRAIN, PSNOW, ZWIND, PZREF, PUREF,    &
                            PPS, XSST, XTTS, ZSFTH_ICE, ZSFTQ_ICE,     &
                            NICE_LAYER, sum(PDIR_SW,2)+sum(PSCA_SW,2), PLW, &
                            ZQSAT_ICE, ZZ0_ICE, ZUSTAR_ICE, ZCD_ICE, ZCDN_ICE, ZCH_ICE, ZRI_ICE, ZRESA_ICE, ZZ0H_ICE,   &
                            PPEW_A_COEF ,PPEW_B_COEF ,PPET_A_COEF ,PPEQ_A_COEF ,PPET_B_COEF ,PPEQ_B_COEF   )
  CALL SEA_MOMENTUM_FLUXES(ZCD_ICE, ZSFU_ICE, ZSFV_ICE)
  ZTRAD =  (((1 - XSIC(:))* XSST (:)**4 + XSIC(:) * XTICE(:,1)**4)) ** 0.25
  CALL COMPLEMENT_EACH_OTHER_FLUX
ENDIF
!
!-------------------------------------------------------------------------------------
! Scalar fluxes:
!-------------------------------------------------------------------------------------
!
IF (NBEQ>0) THEN
  IF (CCH_DRY_DEP == "WES89") THEN

    CALL CH_DEP_WATER  (ZRESA_SEA, ZUSTAR, PTA, ZTRAD,      &
                          PSV(:,NSV_CHSBEG:NSV_CHSEND),       &
                          CSV(NSV_CHSBEG:NSV_CHSEND),         &
                          XDEP(:,1:NBEQ) )

   PSFTS(:,NSV_CHSBEG:NSV_CHSEND) = - PSV(:,NSV_CHSBEG:NSV_CHSEND)  &
                                               * XDEP(:,1:NBEQ)
     IF (NAEREQ > 0 ) THEN
        CALL CH_AER_DEP(PSV(:,NSV_AERBEG:NSV_AEREND),&
                          PSFTS(:,NSV_AERBEG:NSV_AEREND),&
                          ZUSTAR,ZRESA_SEA,PTA,PRHOA)
      END IF

  ELSE
    PSFTS(:,NSV_CHSBEG:NSV_CHSEND) =0.
    IF (NSV_AEREND.GT.NSV_AERBEG)     PSFTS(:,NSV_AERBEG:NSV_AEREND) =0.
  ENDIF
ENDIF
!
IF (NSLTEQ>0) THEN
  ISLT = NSV_SLTEND - NSV_SLTBEG + 1

  CALL COUPLING_SLT_n(           &
       SIZE(ZUSTAR,1),           & !I [nbr] number of sea point
       ISLT,                     & !I [nbr] number of sea salt variables
       ZWIND,                    & !I [m/s] wind velocity
       PSFTS(:,NSV_SLTBEG:NSV_SLTEND) )
ENDIF
!
IF (NDSTEQ>0) THEN
  CALL DSLT_DEP(PSV(:,NSV_DSTBEG:NSV_DSTEND), PSFTS(:,NSV_DSTBEG:NSV_DSTEND),   &
                ZUSTAR, ZRESA_SEA, PTA, PRHOA, XEMISSIG_DST, XEMISRADIUS_DST,   &
                JPMODE_DST, XDENSITY_DST, XMOLARWEIGHT_DST, ZCONVERTFACM0_DST,  &
                ZCONVERTFACM6_DST, ZCONVERTFACM3_DST, LVARSIG_DST, LRGFIX_DST,  &
                CVERMOD  )

  CALL MASSFLUX2MOMENTFLUX(         &
    PSFTS(:,NSV_DSTBEG:NSV_DSTEND), & !I/O ![kg/m2/sec] In: flux of only mass, out: flux of moments
    PRHOA,                          & !I [kg/m3] air density
    XEMISRADIUS_DST,                &!I [um] emitted radius for the modes (max 3)
    XEMISSIG_DST,                   &!I [-] emitted sigma for the different modes (max 3)
    NDSTMDE,                        &
    ZCONVERTFACM0_DST,              &
    ZCONVERTFACM6_DST,              &
    ZCONVERTFACM3_DST,              &
    LVARSIG_DST, LRGFIX_DST         )
ENDIF


IF (NSLTEQ>0) THEN
  CALL DSLT_DEP(PSV(:,NSV_SLTBEG:NSV_SLTEND), PSFTS(:,NSV_SLTBEG:NSV_SLTEND),   &
                ZUSTAR, ZRESA_SEA, PTA, PRHOA, XEMISSIG_SLT, XEMISRADIUS_SLT,   &
                JPMODE_SLT, XDENSITY_SLT, XMOLARWEIGHT_SLT, ZCONVERTFACM0_SLT,  &
                ZCONVERTFACM6_SLT, ZCONVERTFACM3_SLT, LVARSIG_SLT, LRGFIX_SLT,  &
                CVERMOD  )

  CALL MASSFLUX2MOMENTFLUX(         &
    PSFTS(:,NSV_SLTBEG:NSV_SLTEND), & !I/O ![kg/m2/sec] In: flux of only mass, out: flux of moments
    PRHOA,                          & !I [kg/m3] air density
    XEMISRADIUS_SLT,                &!I [um] emitted radius for the modes (max 3)
    XEMISSIG_SLT,                   &!I [-] emitted sigma for the different modes (max 3)
    NSLTMDE,                        &
    ZCONVERTFACM0_SLT,              &
    ZCONVERTFACM6_SLT,              &
    ZCONVERTFACM3_SLT,              &
    LVARSIG_SLT, LRGFIX_SLT         )
ENDIF
!
!-------------------------------------------------------------------------------
! OCEANIC COUPLING
!-------------------------------------------------------------------------------
  IF (LMERCATOR) THEN
    CALL MOD1D_n(PTIME,PLW(:),PSCA_SW(:,1:KSW),PDIR_SW(:,1:KSW),PSFTH(:),&
                   PSFTQ(:),PSFU(:),PSFV(:),PRAIN(:),XSST(:))
  ENDIF
!
!-------------------------------------------------------------------------------
! Inline diagnostics at time t
!-------------------------------------------------------------------------------
!
IF (LHANDLE_SIC) THEN
   PSFTH  (:) = ZSFTH (:) * ( 1 - XSIC (:)) + ZSFTH_ICE(:) * XSIC(:)
   PSFTQ  (:) = ZSFTQ (:) * ( 1 - XSIC (:)) + ZSFTQ_ICE(:) * XSIC(:)
   PSFU   (:) = ZSFU  (:) * ( 1 - XSIC (:)) +  ZSFU_ICE(:) * XSIC(:)
   PSFV   (:) = ZSFV  (:) * ( 1 - XSIC (:)) +  ZSFV_ICE(:) * XSIC(:)

   IF (LNEW_AVG_DRAG) THEN
       CALL AVG_DRAG( XZ0, ZCD, ZCDN, ZCD_ICE, ZCDN_ICE, XSIC, ZCD_AVG, ZCDN_AVG )
       CALL SEA_MOMENTUM_FLUXES( ZCD_AVG, PSFU, PSFV)
   ENDIF
ELSE
   PSFTH  (:) = ZSFTH (:)
   PSFTQ  (:) = ZSFTQ (:)
   PSFU   (:) = ZSFU  (:)
   PSFV   (:) = ZSFV  (:)
ENDIF

CALL XICE%SURF_ALB        ( ZALBEDO   )
CALL XICE%SURF_TEMPERATURE( ZSURF_TMP )

CALL DIAG_INLINE_SEAFLUX_n(                                    &
        PTSTEP, PTA, XSST, ZQA, PPA, PPS, PRHOA, PU,           &
        PV, PZREF, PUREF, ZCD, ZCDN, ZCH, ZCE, ZRI, ZHU,       &
        XZ0, ZZ0H, ZQSAT, ZSFTH, ZSFTQ, ZSFU, ZSFV,            &
        PDIR_SW, PSCA_SW, PLW, ZDIR_ALB, ZSCA_ALB, ZALBEDO,    &
        ZEMIS, ZTRAD, PRAIN, PSNOW,                            &
        XSIC, LHANDLE_SIC, ZSURF_TMP,                          &
        ZCD_ICE, ZCDN_ICE, ZCH_ICE, ZCH_ICE, ZRI_ICE,          &
        ZZ0_ICE, ZZ0H_ICE, ZQSAT_ICE, ZSFTH_ICE, ZSFTQ_ICE,    &
        ZSFU_ICE, ZSFV_ICE)
!
!IF (LHANDLE_SIC) THEN
!   PSFTH  (:) = ZSFTH (:) * ( 1 - XSIC (:)) + ZSFTH_ICE(:) * XSIC(:)
!   PSFTQ  (:) = ZSFTQ (:) * ( 1 - XSIC (:)) + ZSFTQ_ICE(:) * XSIC(:)
!   PSFU   (:) = ZSFU  (:) * ( 1 - XSIC (:)) +  ZSFU_ICE(:) * XSIC(:)
!   PSFV   (:) = ZSFV  (:) * ( 1 - XSIC (:)) +  ZSFV_ICE(:) * XSIC(:)
!ELSE
!   PSFTH  (:) = ZSFTH (:)
!   PSFTQ  (:) = ZSFTQ (:)
!   PSFU   (:) = ZSFU  (:)
!   PSFV   (:) = ZSFV  (:)
!ENDIF

!-------------------------------------------------------------------------------
!Radiative properties at time t+1 (see by the atmosphere) in order to close
!the energy budget between surfex and the atmosphere
!-------------------------------------------------------------------------------
!
IF (LINTERPOL_SST.AND.MOD(TTIME%TIME,XDAY) == 0.) THEN
   CALL INTERPOL_SST_MTH(TTIME%TDATE%YEAR,TTIME%TDATE%MONTH,TTIME%TDATE%DAY,XSST)
ENDIF

!
CALL UPDATE_RAD_SEAWAT(CSEA_ALB,XSST,PZENITH2,XTTS,XEMIS,XDIR_ALB, &
                         XSCA_ALB,PDIR_ALB,PSCA_ALB,PEMIS,PTRAD      )


IF(LHANDLE_SIC) THEN
    DO JSWB = 1, KSW
        PDIR_ALB(:,JSWB) = ( 1. - XSIC(:) )*PDIR_ALB(:,JSWB) + XSIC(:)*ZALBEDO(:)
        PSCA_ALB(:,JSWB) = ( 1. - XSIC(:) )*PSCA_ALB(:,JSWB) + XSIC(:)*ZALBEDO(:)
    END DO
    PTRAD =  (((1 - XSIC(:))* XSST (:)**4 + XSIC(:) * ZSURF_TMP(:)**4)) ** 0.25
ELSE
    DO JSWB = 1, KSW
        WHERE (ZSURF_TMP /= XUNDEF)
            PDIR_ALB(:,JSWB) = ZALBEDO
            PSCA_ALB(:,JSWB) = ZALBEDO
        END  WHERE
    END DO
    WHERE (ZSURF_TMP /= XUNDEF) PTRAD    = ZSURF_TMP
END IF
!
!=======================================================================================
!
IF (LHOOK) CALL DR_HOOK('COUPLING_SEAFLUX_N',1,ZHOOK_HANDLE)
CONTAINS

SUBROUTINE SEA_MOMENTUM_FLUXES(PCD, PSFU, PSFV)
!
IMPLICIT NONE
REAL, DIMENSION(KI), INTENT(IN)  :: PCD       ! Drag coefficient (on open sea or seaice)
REAL, DIMENSION(KI), INTENT(OUT) :: PSFU      ! zonal momentum flux                   (Pa)
REAL, DIMENSION(KI), INTENT(OUT) :: PSFV      ! meridian momentum flux                (Pa)
!
REAL, DIMENSION(KI) :: ZUSTAR2    ! square of friction velocity (m2/s2)
REAL, DIMENSION(KI) :: ZWORK      ! Work array
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('COUPLING_SEAFLUX_N: SEA_MOMENTUM_FLUXES',0,ZHOOK_HANDLE)
!
ZWORK  (:) = XUNDEF
ZUSTAR2(:) = XUNDEF

WHERE( PCD /= XUNDEF )
    ZUSTAR2(:) = (PCD(:)*ZWIND(:)*PPEW_B_COEF(:)) /            &
              (1.0-PRHOA(:)*PCD(:)*ZWIND(:)*PPEW_A_COEF(:))

    PSFU = 0.
    PSFV = 0.
    WHERE (ZWIND(:)>0.)
        PSFU(:) = - PRHOA(:) * ZUSTAR2(:) * ZU(:) / ZWIND(:)
        PSFV(:) = - PRHOA(:) * ZUSTAR2(:) * ZV(:) / ZWIND(:)
    END WHERE
END WHERE
IF (LHOOK) CALL DR_HOOK('COUPLING_SEAFLUX_N: SEA_MOMENTUM_FLUXES',1,ZHOOK_HANDLE)
END SUBROUTINE SEA_MOMENTUM_FLUXES

SUBROUTINE COMPLEMENT_EACH_OTHER_FLUX
!
! Provide dummy fluxes on places with no open-sea or no sea-ice
! Allows a smooth computing of CLS parameters in all cases while avoiding
! having to pack arrays (in routines PARAM_CLS and CLS_TQ)
!
IMPLICIT NONE
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('COUPLING_SEAFLUX_N: COMPLEMENT_EACH_OTHER_FLUX',0,ZHOOK_HANDLE)
!
  WHERE (XSIC(:) == 1.)
     ZSFTH      = ZSFTH_ICE
     ZSFTQ      = ZSFTQ_ICE
     ZSFU       = ZSFU_ICE
     ZSFV       = ZSFV_ICE
     ZQSAT      = ZQSAT_ICE
     ZCD        = ZCD_ICE
     ZCDN       = ZCDN_ICE
     ZCH        = ZCH_ICE
     !ZCE=ZCE_ICE
     ZRI        = ZRI_ICE
     ZZ0H       = ZZ0H_ICE
  END WHERE
  WHERE (XSIC(:) == 0.)
     ZSFTH_ICE  = ZSFTH
     ZSFTQ_ICE  = ZSFTQ
     ZSFU_ICE   = ZSFU
     ZSFV_ICE   = ZSFV
     ZQSAT_ICE  = ZQSAT
     ZCD_ICE    = ZCD
     ZCDN_ICE   = ZCDN
     ZCH_ICE    = ZCH
     !ZCE_ICE=ZCE
     ZRI_ICE    =ZRI
     ZZ0H_ICE   =ZZ0H
     ZZ0_ICE    =XZ0
  END WHERE
!
IF (LHOOK) CALL DR_HOOK('COUPLING_SEAFLUX_N: COMPLEMENT_EACH_OTHER_FLUX',1,ZHOOK_HANDLE)
!
END SUBROUTINE COMPLEMENT_EACH_OTHER_FLUX
END SUBROUTINE COUPLING_SEAFLUX_n
