subroutine avg_drag( pz0, pcd_sea, pcdn_sea, pcd_ice, pcdn_ice, psic, pcd, pcdn )
implicit none
real, dimension(:), intent(in) :: &
    pz0,        &
    pcd_sea,    &
    pcdn_sea,   &
    pcd_ice,    &
    pcdn_ice,   &
    psic
real, dimension(:), intent(out):: &
    pcd,        &
    pcdn


real, dimension(size(pcd_sea)) :: &
    zcd_df

zcd_df(:) = 7.68e-3*(log(0.41/pz0(:))/log(10.0/pz0(:)))**2.0*(1.0 - psic(:))**1.0*psic(:)

pcdn  (:) = (1.-psic(:))*pcdn_sea(:) + psic(:)*pcdn_ice(:) + zcd_df
pcd   (:) = ((1.-psic(:))*pcd_sea(:)/pcdn_sea(:) + psic(:)*pcd_ice(:)/pcdn_ice(:))*pcdn(:)
end subroutine