module abstract_snow
! Basic intrface for implementation snow scheme
!
! AUTHOR
! Y. Batrak
!
! MODIFICATIONS
! Original 04/2014
  use abstract_model, only: tAbstract_model, tForcing, tIce_diag
  implicit none
  private

    type, public, abstract, extends( tAbstract_model ) :: tAbstract_snow
        logical :: locked !< Flag for indication of locked state.
      contains
        procedure( run_model  ), deferred, pass :: run                            !< Preform model run through the snow layer for one time step.
        procedure( get_temp   ), deferred, pass :: surf_temperature               !< Return temperature of uppermost layer of snow.

        procedure( is_snow_exist ), deferred, pass( snow ) :: exists              !< Checks snow existence. If we have no snow, or
                                                                                  !! snow scheme should be disabled for some reason,
                                                                                  !! this function returns .FALSE.
        procedure( heat_out      ), deferred, pass( snow ) :: heat_flux_from_snow !< Fill passed array by values of heat flux from the snow to
                                                                                  !! ice interface. Used for coupling with ice layer.

        procedure, pass, non_overridable :: lock   !< Lock snow model.   Locked snow model has no albedo degradation.
        procedure, pass, non_overridable :: unlock !< Unlock snow model. Locked snow model has no albedo degradation.

        procedure, pass :: surf_albedo
    end type

    abstract interface
        subroutine run_model( snow, T_ice, forc, diag )
          import :: tAbstract_snow, tForcing, tIce_diag
          implicit none
            class( tAbstract_snow )                  :: snow
            real,                   intent( in     ) :: T_ice( : )
            type ( tForcing      ), intent( in     ) :: forc
            type ( tIce_diag     ), intent( in out ) :: diag
        end subroutine

        subroutine rem_snow( snow, msk )
          import :: tAbstract_snow
          implicit none
            class( tAbstract_snow ) :: snow
            logical, intent( in  )  :: msk( : )
        end subroutine

        subroutine get_temp( snow, temp )
          import :: tAbstract_snow
          implicit none
            class( tAbstract_snow ) :: snow
            real, intent( out )     :: temp( : )
        end subroutine

        function is_snow_exist( snow ) result( res )
          import :: tAbstract_snow
          implicit none
            class( tAbstract_snow ) :: snow
            logical                 :: res( snow%num_points )
        end function

        subroutine heat_out( snow, flux )
          import :: tAbstract_snow
          implicit none
            class( tAbstract_snow ) :: snow
            real,     intent( out ) :: flux( : )
        end subroutine
    end interface
  contains

    subroutine lock( snow )
      implicit none
        class( tAbstract_snow ) :: snow

        snow%locked = .TRUE.
    end subroutine

    subroutine unlock( snow )
      implicit none
        class( tAbstract_snow ) :: snow

        snow%locked = .FALSE.
    end subroutine

    subroutine surf_albedo( snow, alb )
        implicit none
        class( tAbstract_snow ) :: snow
        real, intent( out )     :: alb( : )
    end subroutine
end module
