module abstract_ice
! This module defines basic interface for implementation ice scheme.
!
! AUTHOR
! Y. Batrak
!
! MODIFICATIONS
! Original  04/2014
  !
  use abstract_snow,  only: tAbstract_snow
  use abstract_model, only: tAbstract_model, tForcing, tIce_diag
  implicit none
  private

    type, public, abstract, extends( tAbstract_model ) :: tAbstract_ice
        class( tAbstract_snow ), pointer :: snow !< Pointer to snow model, which represent snow layer upon the ice.
                                                 !! This model prepared and initialized in bind_snow() routine. But
                                                 !! it is possible to explicitly bind allocated snow model to this pointer
                                                 !! through pointer assignment.
      contains
        procedure( run_model    ), deferred, pass :: run                !< Perform model run for one time step for whole grid.
        procedure( get_temp     ), deferred, pass :: surf_temperature   !< Extract surface temperature from ice model to explicit array.


        procedure(albedo),deferred,pass :: surf_alb
    end type

    abstract interface
        subroutine run_model( ice, forc, diag )
          import :: tAbstract_ice, tForcing, tIce_diag
          implicit none
            class( tAbstract_ice )                   :: ice
            type ( tForcing      ), intent( in     ) :: forc
            type ( tIce_diag     ), intent( in out ) :: diag
        end subroutine

        subroutine get_temp( ice, temp )
          import :: tAbstract_ice
          implicit none
            class( tAbstract_ice ) :: ice
            real, intent( out )    :: temp( : )
        end subroutine

        subroutine albedo( ice, alb )
          import :: tAbstract_ice
          implicit none
            class( tAbstract_ice ) :: ice
            real, intent( out )    :: alb( : )
        end subroutine
    end interface

end module
