!     ###############################################################################
SUBROUTINE ASSIM_SEA_n(YPROGRAM,KI,PTS_IN,PSST_IN,PSIC_IN,PITM,HTEST)

!     ###############################################################################
!
!!****  *ASSIM_SEA_n * - Chooses the surface assimilation schemes for SEA tile
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!     T. Aspelien
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       04/2012
!!      Trygve Aspelien, Separating IO  06/2013
!!--------------------------------------------------------------------
!
USE MODD_ASSIM,          ONLY : NPRINTLEV,LAESST,LEXTRAP_SEA
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_SURF_ATM_n,     ONLY : CSEA,NR_SEA,XZS,XNATURE
USE MODD_SEAFLUX_n,      ONLY : XSST, XICE, LHANDLE_SIC, LSIC_FROM_FILE
USE MODD_SURF_ATM_GRID_n,ONLY : XLAT, XLON
USE MODN_IO_OFFLINE,     ONLY : CPGDFILE,CPREPFILE
USE YOMHOOK,             ONLY : LHOOK,DR_HOOK
USE PARKIND1,            ONLY : JPRB

USE MODD_PREP_SEAFLUX,   ONLY : CFILE_SIC,CTYPE_SIC
USE MODN_PREP_SURF_ATM,  ONLY : CFILE, CFILETYPE, CFILEPGD, CFILEPGDTYPE

USE MODD_SEAFLUX_GRID_n, ONLY : CGRID_SEA     => CGRID,     &
                                XGRID_PAR_SEA => XGRID_PAR, &
                                XLAT_SEA      => XLAT,      &
                                XLON_SEA      => XLON

USE MODI_GET_LUOUT
USE MODI_PREP_OUTPUT_GRID
USE MODI_CLEAN_PREP_OUTPUT_GRID

USE MODI_ABOR1_SFX
USE MODI_OI_HOR_EXTRAPOL_SURF
USE MODI_READ_NAM_PREP_SEAFLUX_n
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
CHARACTER(LEN=6),   INTENT(IN) :: YPROGRAM  ! program calling surf. schemes
INTEGER,            INTENT(IN) :: KI
REAL,DIMENSION(KI), INTENT(IN) :: PTS_IN
REAL,DIMENSION(KI), INTENT(IN) :: PSST_IN
REAL,DIMENSION(KI), INTENT(IN) :: PSIC_IN
REAL,DIMENSION(KI), INTENT(IN) :: PITM
CHARACTER(LEN=2),   INTENT(IN) :: HTEST ! must be equal to 'OK'
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
REAL(KIND=JPRB)             :: ZHOOK_HANDLE
INTEGER                     :: IRESP,I
REAL                                            :: ZFMAX,  &
                                                   ZFMIN,  &
                                                   ZFMEAN
REAL,               DIMENSION( KI )             :: ZT2INC, &
                                                   ZTCLS,  &
                                                   ZSST,   &
                                                   PSST,   &
                                                   PTS,    &
                                                   ZSSTINC
REAL,   ALLOCATABLE,DIMENSION( : )              :: PLON,   &
                                                   PLAT,   &
                                                   ZALT
LOGICAL,ALLOCATABLE,DIMENSION(:) :: OINTERP_SST

CHARACTER( LEN = 28 ), SAVE      :: YPGDFILE     = '                            '
CHARACTER( LEN = 6  ), SAVE      :: YPGDFILETYPE = '      '

INTEGER                          :: ILUOUT

IF (LHOOK) CALL DR_HOOK('ASSIM_SEA_N',0,ZHOOK_HANDLE)

IF (HTEST/='OK') THEN
  CALL ABOR1_SFX('ASSIM_SEA_n: FATAL ERROR DURING ARGUMENT TRANSFER')
END IF

WRITE(*,*) 'UPDATING SST FOR SCHEME: ',TRIM(CSEA)

IF ( LEXTRAP_SEA ) THEN
  ALLOCATE(ZALT(KI))

  ! Set local array from global
  DO I=1,KI
    ZALT(I)=XZS(NR_SEA(I))
  ENDDO

  ALLOCATE(OINTERP_SST(KI))
  ALLOCATE(PLON(KI))
  ALLOCATE(PLAT(KI))

  ! Set longitudes/latitudes for sea point
  DO I=1,KI
    PLON(I)=XLON(NR_SEA(I))
    PLAT(I)=XLAT(NR_SEA(I))
  ENDDO

  OINTERP_SST(:) = .FALSE.
ENDIF

! Set SST from watfluxn
PSST=XSST

! Read SST from file or set it to input SST
IF ( .NOT. LAESST ) THEN

  ! Set SST to input
  ZSST(:) = PSST_IN(:)
ELSE

  ! SST analysed in CANARI
  ZSST(:)    = XUNDEF
  DO I=1,KI
    IF (PITM(I)< 0.5 .AND. XNATURE(NR_SEA(I)) == XUNDEF ) THEN
     ZSST(:) = PTS_IN(:)   ! set SST analysis from CANARI
    ENDIF
  END DO
  !
  ZFMIN = MINVAL(ZSST)
  ZFMAX = MAXVAL(ZSST)
  ZFMEAN = SUM(ZSST)/FLOAT(KI)
  WRITE(*,*) '  SST analysis from CANARI '
  WRITE(*,'("  ZSST            - min, mean, max: ",3E13.4)') ZFMIN, ZFMEAN, ZFMAX
ENDIF

ZSSTINC(:) = PSST(:)

!*     PSST updated at all sea points with ZSST where ZSST is available

DO I=1,KI
  IF (ZSST(I)/=XUNDEF) THEN
    PSST(I) = ZSST(I)
  ELSE
    IF ( LEXTRAP_SEA ) THEN
      OINTERP_SST(I) = .TRUE.
    PSST(I) = XUNDEF
  ENDIF
  ENDIF
ENDDO

IF ( LEXTRAP_SEA ) THEN
  !
  !*     Extrapolation
  !
  ZSST(:) = PSST(:)
  CALL OI_HOR_EXTRAPOL_SURF(KI,PLAT,PLON,ZSST,PLAT,PLON,PSST,OINTERP_SST,ZALT)

  !
  !*     Print values produced by OI_HO_EXTRAPOL_SURF
  !
  IF ( NPRINTLEV > 2 ) THEN
    DO I=1,KI
      IF (OINTERP_SST(I)) THEN
        PRINT *,'Sea surface temperature set to ',PSST(I),'from nearest neighbour at I=',NR_SEA(I)
      ENDIF
    ENDDO
  ENDIF

  DEALLOCATE(OINTERP_SST)
  DEALLOCATE(PLON)
  DEALLOCATE(PLAT)
  DEALLOCATE(ZALT)
ENDIF

! Sum the increments
  ZSSTINC(:) = PSST(:) - ZSSTINC(:)

WRITE(*,*) 'Mean SST increments over SEA   ',SUM(ZSSTINC)/KI

! Setting modified variables
XSST=PSST

IF( LHANDLE_SIC .AND. LSIC_FROM_FILE ) THEN
    WRITE(*,*) 'UPDATE SIC FIELDS...'
    CFILE        = ''
    CFILETYPE    = ''
    CFILEPGD     = ''
    CFILEPGDTYPE = ''
    CALL READ_NAM_PREP_SEAFLUX_n( YPROGRAM )

    CALL GET_LUOUT(YPROGRAM,ILUOUT)
    CALL PREP_OUTPUT_GRID(ILUOUT,CGRID_SEA,XGRID_PAR_SEA,XLAT_SEA,XLON_SEA)

    CALL PREP_HOR_SEAFLUX_FIELD( YPROGRAM,'SIC    ',CFILE_SIC,CTYPE_SIC,YPGDFILE,YPGDFILETYPE)

    CALL CLEAN_PREP_OUTPUT_GRID
END IF
!FIXME: Hack for updating ice surface temperature from SST
write(*,*) 'RePREP for SEA ICE scheme.'
CALL XICE%PREP( YPROGRAM, '', '', '', '' )

IF (LHOOK) CALL DR_HOOK('ASSIM_SEA_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE ASSIM_SEA_n
