MODULE SFXFLDDESC_MOD
!**** *SFXFLDDESC_MOD*  - SURFEX fields info : name, igrid, type, comment

!     Author.
!     -------
!      Philippe Marguinaud *METEO FRANCE*
!      Original : 11-09-2012

!     History.
!     --------
!      Philippe Marguinaud : 08-Mar-2013 : Add return code to lookup function

USE PARKIND1, ONLY : JPRB, JPIM
USE YOMHOOK, ONLY : LHOOK, DR_HOOK
IMPLICIT NONE

PRIVATE
PUBLIC :: SFXFLDDESC_LOOKUP, SFXFLDDESC

TYPE SFXFLDDESC
  CHARACTER (LEN=2)   :: CTYPE ! type
  CHARACTER (LEN=16)  :: CNAME ! name
  INTEGER (KIND=JPIM) :: IGRID ! grid type number
  CHARACTER (LEN=100) :: CCOMM ! comment
END TYPE SFXFLDDESC

CHARACTER (LEN=128) :: CDESC (478)
INTEGER (KIND=JPIM) :: I

DATA (CDESC (I), I = 1, 10) / &
"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567",&
".AOSIM.............4..X1..X_Y_AOSIM.(-)........................................................................................",&
".AOSIP.............4..X1..X_Y_AOSIP.(-)........................................................................................",&
".AOSJM.............4..X1..X_Y_AOSJM.(-)........................................................................................",&
".AOSJP.............4..X1..X_Y_AOSJP.(-)........................................................................................",&
".ASNOW_ROAD........4..X2..X_Y_ASNOW_ROAD.(no.unit).............................................................................",&
".ASNOW_ROOF........4..X2..X_Y_ASNOW_ROOF.(no.unit).............................................................................",&
".ASNOW_VEG.........4..X2..X_Y_ASNOW_VEG.(no.unit)..............................................................................",&
".AVG_ZS............4..X1..X_Y_AVG_ZS.(M).......................................................................................",&
".BATHY.............4..X1..BATHY................................................................................................" /









DATA (CDESC (I), I = 11, 20) / &
".BETA..............4..X0.......................................................................................................",&
".BIBUSER...........4..C0.......................................................................................................",&
".BUDC..............0..L0..flag.for.accumulated.variables.......................................................................",&
".BUG...............4..N0..(-)..................................................................................................",&
".BUGFIX............4..N0.......................................................................................................",&
".CARTESIAN.........0..L0..(-)..................................................................................................",&
".CH_EMIS...........4..L0..CH_EMIS..............................................................................................",&
".CLAY..............4..X1..X_Y_CLAY.............................................................................................",&
".COVER_LIST........4..L1..(LOGICAL.LIST).......................................................................................",&
".COVER_PACKED......4..N0..(-).................................................................................................." /









DATA (CDESC (I), I = 21, 30) / &
".CTI...............4..L0.......................................................................................................",&
".DAD_NAME..........4..C0.......................................................................................................",&
".DATA_IRRIG........4..L0..FLAG.TO.READ.USER.IRRIGATION.DATA.FOR.ECOCLIMAP2.....................................................",&
".DIM_FULL..........4..N0..(-)..................................................................................................",&
".DIM_NATURE........4..N0..(-)..................................................................................................",&
".DIM_SEA...........4..N0..(-)..................................................................................................",&
".DIM_TOWN..........4..N0..(-)..................................................................................................",&
".DIM_WATER.........4..N0..(-)..................................................................................................",&
".DTCUR.............0..T0..s....................................................................................................",&
".DTCUR%TDATE.......0..N1..s...................................................................................................." /









DATA (CDESC (I), I = 31, 40) / &
".DTCUR%TIME........0..X0..s....................................................................................................",&
".DUMMY_GR_NBR......4..N0.......................................................................................................",&
".DX................4..X1.......................................................................................................",&
".DY................4..X1.......................................................................................................",&
".ECOCLIMAP.........4..L0..(-)..................................................................................................",&
".FRAC_NATURE.......4..X1..(-)..................................................................................................",&
".FRAC_SEA..........4..X1..(-)..................................................................................................",&
".FRAC_TOWN.........4..X1..(-)..................................................................................................",&
".FRAC_WATER........4..X1..(-)..................................................................................................",&
".GARDEN............4..L0..(-).................................................................................................." /









DATA (CDESC (I), I = 41, 50) / &
".GRID_TYPE.........4..C0..GRID.TYPE............................................................................................",&
".GROUND_LAYER......4..N0..GROUND_LAYER.........................................................................................",&
".HO2IM.............4..X1..X_Y_HO2IM.(M)........................................................................................",&
".HO2IP.............4..X1..X_Y_HO2IP.(M)........................................................................................",&
".HO2JM.............4..X1..X_Y_HO2JM.(M)........................................................................................",&
".HO2JP.............4..X1..X_Y_HO2JP.(M)........................................................................................",&
".IMAX..............4..N0.......................................................................................................",&
".ISBA..............4..C0..ISBA.................................................................................................",&
".ISBA_CANOPY.......0..L0..flag.to.use.canopy.levels............................................................................",&
".ISBA_CAN_LVL......0..N0..number.of.canopy.levels.............................................................................." /









DATA (CDESC (I), I = 51, 60) / &
".ISBA_CAN_Z01......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".ISBA_CAN_Z02......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".ISBA_CAN_Z03......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".ISBA_CAN_Z04......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".ISBA_CAN_Z05......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".ISBA_CAN_Z06......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".JMAX..............4..N0.......................................................................................................",&
".KMAX..............4..N0.......................................................................................................",&
".LAT0..............4..X0.......................................................................................................",&
".LATORI............4..X0......................................................................................................." /









DATA (CDESC (I), I = 61, 70) / &
".LCLIM_LAI.........4..L0..FLAG.TO.USE.CLIMATOLOGICAL.LAI.......................................................................",&
".LON0..............4..X0.......................................................................................................",&
".LONORI............4..X0.......................................................................................................",&
".LSNOW_FRAC_T......0..L0..(LOGICAL)............................................................................................",&
".L_ALBNIR_SOI......4..L0..L_ALBNIR_SOI.........................................................................................",&
".L_ALBNIR_VEG......4..L0..L_ALBNIR_VEG.........................................................................................",&
".L_ALBUV_SOI.......4..L0..L_ALBUV_SOI..........................................................................................",&
".L_ALBUV_VEG.......4..L0..L_ALBUV_VEG..........................................................................................",&
".L_ALBVIS_SOI......4..L0..L_ALBVIS_SOI.........................................................................................",&
".L_ALBVIS_VEG......4..L0..L_ALBVIS_VEG........................................................................................." /









DATA (CDESC (I), I = 71, 80) / &
".L_ALB_ROAD........4..L0..L_ALB_ROAD...........................................................................................",&
".L_ALB_ROOF........4..L0..L_ALB_ROOF...........................................................................................",&
".L_ALB_WALL........4..L0..L_ALB_WALL...........................................................................................",&
".L_BLD.............4..L0..L_BLD................................................................................................",&
".L_BLD_HEIGHT......4..L0..L_BLD_HEIGHT.........................................................................................",&
".L_BSLAI...........4..L0..L_BSLAI..............................................................................................",&
".L_CE_NITRO........4..L0..L_CE_NITRO...........................................................................................",&
".L_CF_NITRO........4..L0..L_CF_NITRO...........................................................................................",&
".L_CNA_NITRO.......4..L0..L_CNA_NITRO..........................................................................................",&
".L_CV..............4..L0..L_CV................................................................................................." /









DATA (CDESC (I), I = 81, 90) / &
".L_DG..............4..L0..L_DG.................................................................................................",&
".L_DICE............4..L0..L_DICE...............................................................................................",&
".L_DMAX............4..L0..L_DMAX...............................................................................................",&
".L_D_ROAD..........4..L0..L_D_ROAD.............................................................................................",&
".L_D_ROOF..........4..L0..L_D_ROOF.............................................................................................",&
".L_D_WALL..........4..L0..L_D_WALL.............................................................................................",&
".L_EMIS............4..L0..L_EMIS...............................................................................................",&
".L_EMIS_ROAD.......4..L0..L_EMIS_ROAD..........................................................................................",&
".L_EMIS_ROOF.......4..L0..L_EMIS_ROOF..........................................................................................",&
".L_EMIS_WALL.......4..L0..L_EMIS_WALL.........................................................................................." /









DATA (CDESC (I), I = 91, 100) / &
".L_F2I.............4..L0..L_F2I................................................................................................",&
".L_GAMMA...........4..L0..L_GAMMA..............................................................................................",&
".L_GARDEN..........4..L0..L_GARDEN.............................................................................................",&
".L_GC..............4..L0..L_GC.................................................................................................",&
".L_GMES............4..L0..L_GMES...............................................................................................",&
".L_GROUND_DPT......4..L0..L_GROUND_DPT.........................................................................................",&
".L_HC_ROAD.........4..L0..L_HC_ROAD............................................................................................",&
".L_HC_ROOF.........4..L0..L_HC_ROOF............................................................................................",&
".L_HC_WALL.........4..L0..L_HC_WALL............................................................................................",&
".L_H_IND...........4..L0..L_H_IND.............................................................................................." /









DATA (CDESC (I), I = 101, 110) / &
".L_H_TRAF..........4..L0..L_H_TRAF.............................................................................................",&
".L_H_TREE..........4..L0..L_H_TREE.............................................................................................",&
".L_IRRIG...........4..L0..L_IRRIG..............................................................................................",&
".L_LAI.............4..L0..L_LAI................................................................................................",&
".L_LAIMIN..........4..L0..L_LAIMIN.............................................................................................",&
".L_LE_IND..........4..L0..L_LE_IND.............................................................................................",&
".L_LE_TRAF.........4..L0..L_LE_TRAF............................................................................................",&
".L_RE25............4..L0..L_RE25...............................................................................................",&
".L_RGL.............4..L0..L_RGL................................................................................................",&
".L_ROOTFRAC........4..L0..L_ROOTFRAC..........................................................................................." /









DATA (CDESC (I), I = 111, 120) / &
".L_ROOT_DEPTH......4..L0..L_ROOT_DEPTH.........................................................................................",&
".L_ROOT_EXT........4..L0..L_ROOT_EXT...........................................................................................",&
".L_ROOT_LIN........4..L0..L_ROOT_LIN...........................................................................................",&
".L_RSMIN...........4..L0..L_RSMIN..............................................................................................",&
".L_SEFOLD..........4..L0..L_SEFOLD.............................................................................................",&
".L_STRESS..........4..L0..L_STRESS.............................................................................................",&
".L_TC_ROAD.........4..L0..L_TC_ROAD............................................................................................",&
".L_TC_ROOF.........4..L0..L_TC_ROOF............................................................................................",&
".L_TC_WALL.........4..L0..L_TC_WALL............................................................................................",&
".L_URBTYPE.........4..L0..L_URBTYPE............................................................................................" /









DATA (CDESC (I), I = 121, 130) / &
".L_VEG.............4..L0..L_VEG................................................................................................",&
".L_VEGTYPE.........4..L0..L_VEGTYPE............................................................................................",&
".L_VEG_ROOF........4..L0..L_VEG_ROOF...........................................................................................",&
".L_WALL_O_HOR......4..L0..L_WALL_O_HOR.........................................................................................",&
".L_WATSUP..........4..L0..L_WATSUP.............................................................................................",&
".L_WRMAX_CF........4..L0..L_WRMAX_CF...........................................................................................",&
".L_Z0..............4..L0..L_Z0.................................................................................................",&
".L_Z0_O_Z0H........4..L0..L_Z0_O_Z0H...........................................................................................",&
".L_Z0_TOWN.........4..L0..L_Z0_TOWN............................................................................................",&
".MASDEV............4..N0......................................................................................................." /









DATA (CDESC (I), I = 131, 140) / &
".MAX_ZS............4..X1..X_Y_MAX_ZS.(M).......................................................................................",&
".MIN_ZS............4..X1..X_Y_MIN_ZS.(M).......................................................................................",&
".MY_NAME...........4..C0.......................................................................................................",&
".NATURE............4..C0..(-)..................................................................................................",&
".NBIOMASS..........4..N0..NBIOMASS.............................................................................................",&
".NLITTER...........0..N0..NLITTER..............................................................................................",&
".NLITTLEVS.........0..N0..NLITTLEVS............................................................................................",&
".NSOILCARB.........0..N0..NSOILCARB............................................................................................",&
".OM................4..L0.......................................................................................................",&
".PAR_GARDEN........4..L0..FLAG.FOR.SPECIFIED.GARDEN.PARAMETERS................................................................." /









DATA (CDESC (I), I = 141, 150) / &
".PATCH_NUMBER......4..N0..PATCH_NUMBER.........................................................................................",&
".PEDOTF............4..C0..PEDOTF...............................................................................................",&
".PHOTO.............4..C0..PHOTO................................................................................................",&
".PROGRAM...........4..C0.......................................................................................................",&
".Q_CANYON..........4..X1..Q_CANYON.(kg/kg).....................................................................................",&
".RESA..............4..X2..X_Y_RESA.(s/m).......................................................................................",&
".RESPSL............0..C0..RESPSL...............................................................................................",&
".ROAD_LAYER........4..N0..ROAD_LAYER...........................................................................................",&
".ROOF_LAYER........4..N0..ROOF_LAYER...........................................................................................",&
".RPK...............4..X0......................................................................................................." /









DATA (CDESC (I), I = 151, 160) / &
".RSNOW_ROAD1.......4..X2..X_Y_RSNOW_ROAD1.(kg/m2)..............................................................................",&
".RSNOW_ROOF1.......4..X2..X_Y_RSNOW_ROOF1.(kg/m2)..............................................................................",&
".RSNOW_VEG1........4..X2..X_Y_RSNOW_VEG1.(kg/m2)...............................................................................",&
".RUNOFFB...........4..X1..X_Y_RUNOFFB..........................................................................................",&
".RW_PRECIP.........0..L0..flag.to.store.precip.fields.in.restart.file..........................................................",&
".SAND..............4..X1..X_Y_SAND.............................................................................................",&
".SEA...............4..C0..(-)..................................................................................................",&
".SEA_OCEAN.........0..L0..flag.to.use.OCEAN.model..............................................................................",&
".SEA_SBL...........0..L0..flag.to.use.SBL.levels...............................................................................",&
".SEA_SBL_LVL.......0..N0..number.of.SBL.levels................................................................................." /









DATA (CDESC (I), I = 161, 170) / &
".SEA_SBL_Z01.......4..X1..altitudes.of.SBL.levels.(m)..........................................................................",&
".SEA_SBL_Z02.......4..X1..altitudes.of.SBL.levels.(m)..........................................................................",&
".SEA_SBL_Z03.......4..X1..altitudes.of.SBL.levels.(m)..........................................................................",&
".SEA_SBL_Z04.......4..X1..altitudes.of.SBL.levels.(m)..........................................................................",&
".SEA_SBL_Z05.......4..X1..altitudes.of.SBL.levels.(m)..........................................................................",&
".SEA_SBL_Z06.......4..X1..altitudes.of.SBL.levels.(m)..........................................................................",&
".SIL_ZS............4..X1..X_Y_SIL_ZS.(M).......................................................................................",&
".SN_ROAD...........0..L0..(LOGICAL)............................................................................................",&
".SN_ROAD_N.........0..N0..(INTEGER)............................................................................................",&
".SN_ROAD_TYPE......0..C0......................................................................................................." /









DATA (CDESC (I), I = 171, 180) / &
".SN_ROOF...........0..L0..(LOGICAL)............................................................................................",&
".SN_ROOF_N.........0..N0..(INTEGER)............................................................................................",&
".SN_ROOF_TYPE......0..C0.......................................................................................................",&
".SN_VEG............0..L0..(LOGICAL)............................................................................................",&
".SN_VEG_N..........0..N0..(INTEGER)............................................................................................",&
".SN_VEG_TYPE.......0..C0.......................................................................................................",&
".SSO_ANIS..........4..X1..X_Y_SSO_ANIS.(-).....................................................................................",&
".SSO_CANOPY........0..L0..flag.to.use.canopy.levels............................................................................",&
".SSO_CAN_LVL.......0..N0..number.of.canopy.levels..............................................................................",&
".SSO_CAN_Z01.......4..X1..altitudes.of.canopy.levels.(m)......................................................................." /









DATA (CDESC (I), I = 181, 190) / &
".SSO_CAN_Z02.......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".SSO_CAN_Z03.......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".SSO_CAN_Z04.......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".SSO_CAN_Z05.......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".SSO_CAN_Z06.......4..X1..altitudes.of.canopy.levels.(m).......................................................................",&
".SSO_DIR...........4..X1..X_Y_SSO_DIR.(DEG)....................................................................................",&
".SSO_SLOPE.........4..X1..X_Y_SSO_SLOPE.(-)....................................................................................",&
".SSO_STDEV.........4..X1..X_Y_SSO_STDEV.(M)....................................................................................",&
".SST...............4..X1..SST..................................................................................................",&
".SST_DATA..........4..L0..(LOGICAL)............................................................................................" /









DATA (CDESC (I), I = 191, 200) / &
".STORAGETYPE.......4..C0..(-)..................................................................................................",&
".STORAGE_TYPE......4..C0.......................................................................................................",&
".TEB_CANOPY........0..L0..flag.to.use.canopy.levels............................................................................",&
".TG1...............4..X2..X_Y_TG1.(K)..........................................................................................",&
".TG2...............4..X2..X_Y_TG2.(K)..........................................................................................",&
".TG3...............4..X2..X_Y_TG3.(K)..........................................................................................",&
".THINSHELL.........4..L0.......................................................................................................",&
".TI_BLD............4..X1..TI_BLD.(K)...........................................................................................",&
".TI_ROAD...........4..X1..TI_ROAD.(K)..........................................................................................",&
".TOWN..............4..C0..(-).................................................................................................." /









DATA (CDESC (I), I = 201, 210) / &
".TOWN_TO_ROCK......4..L0..(-)..................................................................................................",&
".TR_ML.............4..L0..TR_ML................................................................................................",&
".TSNOW_ROAD1.......4..X2..X_Y_TSNOW_ROAD1.(kg/m2)..............................................................................",&
".TSNOW_ROOF1.......4..X2..X_Y_TSNOW_ROOF1.(kg/m2)..............................................................................",&
".TSRAD_NAT.........4..X1..X_TSRAD_NAT.(K)......................................................................................",&
".TS_WATER..........4..X1..TS_WATER.(K).........................................................................................",&
".T_CANYON..........4..X1..T_CANYON.(K).........................................................................................",&
".T_ROAD1...........4..X1..X_Y_T_ROAD1.(K)......................................................................................",&
".T_ROAD2...........4..X1..X_Y_T_ROAD2.(K)......................................................................................",&
".T_ROAD3...........4..X1..X_Y_T_ROAD3.(K)......................................................................................" /









DATA (CDESC (I), I = 211, 220) / &
".T_ROOF1...........4..X1..X_Y_T_ROOF1.(K)......................................................................................",&
".T_ROOF2...........4..X1..X_Y_T_ROOF2.(K)......................................................................................",&
".T_ROOF3...........4..X1..X_Y_T_ROOF3.(K)......................................................................................",&
".T_WALL1...........4..X1..X_Y_T_WALL1.(K)......................................................................................",&
".T_WALL2...........4..X1..X_Y_T_WALL2.(K)......................................................................................",&
".T_WALL3...........4..X1..X_Y_T_WALL3.(K)......................................................................................",&
".VERSION...........4..N0..(-)..................................................................................................",&
".WALL_LAYER........4..N0..WALL_LAYER...........................................................................................",&
".WATER.............4..C0..(-)..................................................................................................",&
".WATER_TO_NAT......4..L0..(-).................................................................................................." /









DATA (CDESC (I), I = 221, 230) / &
".WAT_SBL...........0..L0..flag.to.use.SBL.levels...............................................................................",&
".WDRAIN............4..X1..X_Y_WDRAIN...........................................................................................",&
".WG1...............4..X2..X_Y_WG1.(m3/m3)......................................................................................",&
".WG2...............4..X2..X_Y_WG2.(m3/m3)......................................................................................",&
".WG3...............4..X2..X_Y_WG3.(m3/m3)......................................................................................",&
".WGI1..............4..X2..X_Y_WGI1.(m3/m3).....................................................................................",&
".WGI2..............4..X2..X_Y_WGI2.(m3/m3).....................................................................................",&
".WGI3..............4..X2..X_Y_WGI3.(m3/m3).....................................................................................",&
".WR................4..X2..X_Y_WR.(kg/m2).......................................................................................",&
".WSNOW_ROAD1.......4..X2..X_Y_WSNOW_ROAD1.(kg/m2).............................................................................." /









DATA (CDESC (I), I = 231, 240) / &
".WSNOW_ROOF1.......4..X2..X_Y_WSNOW_ROOF1.(kg/m2)..............................................................................",&
".WSNOW_VEG1........4..X2..X_Y_WSNOW_VEG1.(kg/m2)...............................................................................",&
".WS_ROAD...........4..X1..WS_ROAD.(kg/m2)......................................................................................",&
".WS_ROOF...........4..X1..WS_ROOF.(kg/m2)......................................................................................",&
".XHAT..............4..X1.......................................................................................................",&
".XX................4..X1.......................................................................................................",&
".YHAT..............4..X1.......................................................................................................",&
".YY................4..X1.......................................................................................................",&
".Z0SEA.............4..X1..Z0SEA.(m)............................................................................................",&
".Z0WATER...........4..X1..Z0WATER.(m).........................................................................................." /









DATA (CDESC (I), I = 241, 250) / &
".ZS................4..X1..X_Y_ZS.(M)...........................................................................................",&
".ISBA_CAN_LMO......4..X1.......................................................................................................",&
".SURF..............0..C0.......................................................................................................",&
".L1D...............0..L0.......................................................................................................",&
".L2D...............0..L0.......................................................................................................",&
".PACK..............0..L0.......................................................................................................",&
".RI_WAT............4..X1..Bulk-Richardson.number.for.water.....................................................................",&
".RN_WAT............4..X1..net.radiation.for.water.(W/m2).......................................................................",&
".LE_WAT............4..X1..total.latent.heat.flux.for.water.(W/m2)..............................................................",&
".LEI_WAT...........4..X1..sublimation.latent.heat.flux.for.water-ice.(W/m2)...................................................."/









DATA (CDESC (I), I = 251, 260) / &
".GFLUX_WAT.........4..X1..conduction.flux.for.water.(W/m2).....................................................................",&
".SWD_WAT...........4..X1..short.wave.downward.radiation.for.water.(W/m2).......................................................",&
".SWU_WAT...........4..X1..short.wave.upward.radiation.for.water.(W/m2).........................................................",&
".H_WAT.............4..X1..sensible.heat.flux.for.water.(W/m2)..................................................................",&
".GFLUX_WAT.........4..X1..conduction.flux.for.water.(W/m2).....................................................................",&
".LWD_WAT...........4..X1..downward.long.wave.radiation.(W/m2)..................................................................",&
".LWU_WAT...........4..X1..upward.long.wave.radiation.(W/m2)....................................................................",&
".FMU_WAT...........4..X1..u-component.of.momentum.flux.for.water.(kg/ms2)......................................................",&
".FMV_WAT...........4..X1..v-component.of.momentum.flux.for.water.(kg/ms2)......................................................",&
".CD_WAT............4..X1..drag.coefficient.for.wind.over.water.(W/s2).........................................................."/









DATA (CDESC (I), I = 261, 270) / &
".CH_WAT............4..X1..drag.coefficient.for.heat.(W/s)......................................................................",&
".CE_WAT............4..X1..drag.coefficient.for.vapor.(W/s/K)...................................................................",&
".Z0_WAT............4..X1..roughness.length.over.water.(m)......................................................................",&
".Z0H_WAT...........4..X1..thermal.roughness.length.over.water.(m)..............................................................",&
".QS_WAT............4..X1..specific.humidity.over.water.(KG/KG).................................................................",&
".T2M_WAT...........4..X1..2.meters.temperature.(K).............................................................................",&
".Q2M_WAT...........4..X1..2.meters.specific.humidity.(KG/KG)...................................................................",&
".HU2M_WAT..........4..X1..2.meters.relative.humidity.(KG/KG)...................................................................",&
".ZON10M_WAT........4..X1..10.meters.zonal.wind.(M/S)...........................................................................",&
".MER10M_WAT........4..X1..10.meters.meridian.wind.(M/S)........................................................................"/









DATA (CDESC (I), I = 271, 280) / &
".SWD_WAT_1.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_2.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_3.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_4.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_5.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_6.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_7.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_8.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWD_WAT_9.........4..X1..downward.short.wave.radiation.by.spectral.band..(W/m2)...............................................",&
".SWU_WAT_1.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2).................................................."/









DATA (CDESC (I), I = 281, 290) / &
".SWU_WAT_2.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_3.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_4.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_5.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_6.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_7.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_8.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".SWU_WAT_9.........4..X1..upward.short.wave.radiation.by.spectral.band.(W/m2)..................................................",&
".DSNOW_T_ISBA......4..X1..Total_snow_depth.(m).................................................................................",&
".EMIS..............4..X1..X_Y_EMIS.............(-)............................................................................."/









DATA (CDESC (I), I = 291, 300) / &
".FMU...............4..X1..X_Y_FMU..............(kg/ms2)........................................................................",&
".FMU_ISBA..........4..X1..u.component.of.wind.stress.(kg/ms2)..................................................................",&
".FMUNOSSO..........4..X1..X_Y_FMUNOSSO.........(kg/ms2)........................................................................",&
".FMV...............4..X1..X_Y_FMV..............(kg/ms2)........................................................................",&
".FMV_ISBA..........4..X1..v.component.of.wind.stress.(kg/ms2)..................................................................",&
".FMVNOSSO..........4..X1..X_Y_FMVNOSSO.........(kg/ms2)........................................................................",&
".GFLUX.............4..X1..X_Y_GFLUX............(W/m2)..........................................................................",&
".GFLUX_ISBA........4..X1..Ground.flux.over.tile.nature.(W/m2)..................................................................",&
".H.................4..X1..X_Y_H................(W/m2)..........................................................................",&
".H_ISBA............4..X1..Sensible.heat.flux.over.tile.nature.(W/m2)..........................................................."/









DATA (CDESC (I), I = 301, 310) / &
".HU2M..............4..X1..X_Y_HU2M.............(-).............................................................................",&
".HU2M_ISBA.........4..X1..X_Y_HU2M_ISBA........(-).............................................................................",&
".HU2MMAX...........4..X1..X_Y_HU2MMAX..........(-).............................................................................",&
".HU2MMAX_ISBA......4..X1..X_Y_HU2MMAX_ISBA.....(-).............................................................................",&
".HU2MMAX_WAT.......4..X1..X_Y_HU2MMAX_WAT......(-).............................................................................",&
".HU2MMIN...........4..X1..X_Y_HU2MMIN..........(-).............................................................................",&
".HU2MMIN_ISBA......4..X1..X_Y_HU2MMIN_ISBA.....(-).............................................................................",&
".HU2MMIN_WAT.......4..X1..X_Y_HU2MMIN_WAT......(-).............................................................................",&
".HV_ISBA...........4..X1..Halstead.coefficient.averaged.over.tile.nature.(-)...................................................",&
".LE................4..X1..X_Y_LE...............(W/m2).........................................................................."/









DATA (CDESC (I), I = 311, 320) / &
".LEI...............4..X1..X_Y_LEI..............(W/m2)..........................................................................",&
".LEI_ISBA..........4..X1..sublimation.latent.heat.flux.over.tile.nature.(W/m2).................................................",&
".LE_ISBA...........4..X1..total.latent.heat.flux.over.tile.nature.(W/m2).......................................................",&
".MER10M............4..X1..X_Y_MER10M...........(M/S)...........................................................................",&
".MER10M_ISBA.......4..X1..X_Y_MER10M_ISBA......(M/S)...........................................................................",&
".PSNG_ISBA.........4..X1..snow.fraction.over.ground.averaged.over.tile.nature.(-)..............................................",&
".PSN_ISBA..........4..X1..total.snow.fraction.averaged.over.tile.nature.(-)....................................................",&
".PSNV_ISBA.........4..X1..snow.fraction.over.vegetation.averaged.over.tile.nature.(-)..........................................",&
"...............................................................................................................................",&
".Q2M...............4..X1..X_Y_Q2M..............(KG/KG)........................................................................."/









DATA (CDESC (I), I = 321, 330) / &
".Q2M_ISBA..........4..X1..X_Y_Q2M_ISBA.........(KG/KG).........................................................................",&
".RI................4..X1..X_Y_RI...............................................................................................",&
".RI_ISBA...........4..X1..Richardson.number.over.tile.nature...................................................................",&
".RN................4..X1..X_Y_RN...............(W/m2)..........................................................................",&
".RN_ISBA...........4..X1..Net.radiation.over.tile.nature.(W/m2)................................................................",&
".SWI1_ISBA.........4..X1..soil.wetness.index.for.layer.1.(-)...................................................................",&
".SWI2_ISBA.........4..X1..soil.wetness.index.for.layer.2.(-)...................................................................",&
".T2M...............4..X1..X_Y_T2M..............(K).............................................................................",&
".T2M_ISBA..........4..X1..X_Y_T2M_ISBA.........(K).............................................................................",&
".T2MMAX............4..X1..X_Y_T2MMAX...........(K)............................................................................."/









DATA (CDESC (I), I = 331, 340) / &
".T2MMAX_ISBA.......4..X1..X_Y_T2MMAX_ISBA......(K).............................................................................",&
".T2MMAX_WAT........4..X1..X_Y_T2MMAX_WAT.......(K).............................................................................",&
".T2MMIN............4..X1..X_Y_T2MMIN...........(K).............................................................................",&
".T2MMIN_ISBA.......4..X1..X_Y_T2MMIN_ISBA......(K).............................................................................",&
".T2MMIN_WAT........4..X1..X_Y_T2MMIN_WAT.......(K).............................................................................",&
".TALB_ISBA.........4..X1..total.albedo.over.tile.nature.(-)....................................................................",&
".TS................4..X1..X_Y_TS...............(K).............................................................................",&
".TSNOW_T_ISBA......4..X1..Total_snow_temperature.(K)...........................................................................",&
".TSRAD.............4..X1..X_Y_TSRAD............(K).............................................................................",&
".TSWI1_ISBA........4..X1..total.swi.(liquid+solid).for.1.(-)..................................................................."/









DATA (CDESC (I), I = 341, 350) / &
".TSWI_T_ISBA.......4..X1..total.soil.wetness.index.over.the.soil.column.(-)....................................................",&
".W10M..............4..X1..X_Y_W10M.............(M/S)...........................................................................",&
".W10M_ISBA.........4..X1..X_Y_W10M_ISBA........(M/S)...........................................................................",&
".W10MMAX...........4..X1..X_Y_W10MMAX..........(M/S)...........................................................................",&
".W10MMAX_ISBA......4..X1..X_Y_W10MMAX_ISBA.....(M/S)...........................................................................",&
".W10MMAX_WAT.......4..X1..X_Y_W10MMAX_WAT......(M/S)...........................................................................",&
".W10M_WAT..........4..X1..X_Y_W10M_WAT.........(M/S)...........................................................................",&
".WFC1..............4..X1..field.capacity.by.layer.(m3/m3)......................................................................",&
".WFC2..............4..X1..field.capacity.by.layer.(m3/m3)......................................................................",&
".WGI_T_ISBA........4..X1..total.ice.content.(solid).over.the.soil.column.(kg/m2)..............................................."/









DATA (CDESC (I), I = 351, 360) / &
".WGTOT_T_ISBA......4..X1..total.water.content.(liquid+solid).over.the.soil.column.(kg/m2)......................................",&
".WSAT1.............4..X1..soil.porosity.by.layer.(m3/m3).......................................................................",&
".WSAT2.............4..X1..soil.porosity.by.layer.(m3/m3).......................................................................",&
".WSNOW_T_ISBA......4..X1..Total_snow_reservoir.(kg/m2).........................................................................",&
".WWILT1............4..X1..wilting.point.by.layer.(m3/m3).......................................................................",&
".WWILT2............4..X1..wilting.point.by.layer.(m3/m3).......................................................................",&
".Z0REL.............4..X1..orography.roughness.length.(M).......................................................................",&
".ZON10M............4..X1..X_Y_ZON10M...........(M/S)...........................................................................",&
".ZON10M_ISBA.......4..X1..X_Y_ZON10M_ISBA......(M/S)...........................................................................",&
".TSWI2_ISBA........4..X1..total.swi.(liquid+solid).for.2.(-)..................................................................."/









DATA (CDESC (I), I = 361, 370) / &
".ALBNIR_ISBA.......4..X2..total.near-infra-red.albedo.(-)......................................................................",&
".ALBNIR_SOIL.......4..X2..soil.near-infra-red.albedo.(-).......................................................................",&
".ALBUV_ISBA........4..X2..total.UV.albedo.(-)..................................................................................",&
".ALBUV_SOIL........4..X2..soil.UV.albedo.(-)...................................................................................",&
".ALBVIS_ISBA.......4..X2..total.visible.albedo.(-).............................................................................",&
".ALBVIS_SOIL.......4..X2..soil.visible.albedo.(-)..............................................................................",&
".CV................4..X2..vegetation.thermal.inertia.coefficient.(-)...........................................................",&
".DG1...............4..X2..soil.depth.(M).......................................................................................",&
".DG2...............4..X2..soil.depth.(M).......................................................................................",&
".EMIS_ISBA.........4..X2..surface.emissivity.(-)..............................................................................."/









DATA (CDESC (I), I = 371, 380) / &
".GAMMA.............4..X2..coefficient.for.RSMIN.calculation.(-)................................................................",&
".LAI...............4..X2..leaf.area.index.(-)..................................................................................",&
".PATCH.............4..X2..fraction.for.each.patch.(-)..........................................................................",&
".RGL...............4..X2..maximum.solar.radiation.usable.in.photosynthesis.(-).................................................",&
".RSMIN.............4..X2..minimum.stomatal.resistance.(SM-1)...................................................................",&
".VEG...............4..X2..vegetation.fraction.(-)..............................................................................",&
".VEGTYPE_P1........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P2........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P3........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P4........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-).................................................."/









DATA (CDESC (I), I = 381, 390) / &
".VEGTYPE_P5........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P6........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P7........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P8........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P9........4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P10.......4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P11.......4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".VEGTYPE_P12.......4..X2..fraction.of.each.vegetation.type.for.each.patch.(-)..................................................",&
".WRMAX_CF..........4..X2..coefficient.for.maximum.water.interception.(-).......................................................",&
".Z0VEG.............4..X2..surface.roughness.length.(without.snow).(M).........................................................."/









DATA (CDESC (I), I = 391, 400) / &
".COVER.............4..L1..(LOGICAL LIST).......................................................................................",&
".PHIS..............4..X1..ZS.(Model)...........................................................................................",&
".NLATI.............4..N0.......................................................................................................",&
".LAPO..............4..X0.......................................................................................................",&
".LOPO..............4..X0.......................................................................................................",&
".CODIL.............4..X0.......................................................................................................",&
".NLOPA.............4..N1.......................................................................................................",&
".LATGAUSS..........4..X1.......................................................................................................",&
".LONGAUSS..........4..X1.......................................................................................................",&
".LAT_G_XY..........4..X1......................................................................................................."/









DATA (CDESC (I), I = 401, 410) / &
".LON_G_XY..........4..X1.......................................................................................................",&
".MESHGAUSS.........4..X1.......................................................................................................",&
".RI_SEA............4..X1..Bulk-Richardson.number.for.sea.......................................................................",&
".RN_SEA............4..X1..net.radiation.for.sea.(W/m2).........................................................................",&
".H_SEA.............4..X1..sensible.heat.flux.for.sea.(W/m2)....................................................................",&
".LE_SEA............4..X1..total.latent.heat.flux.for.sea.(W/m2)................................................................",&
".LEI_SEA...........4..X1..sublimation.latent.heat.flux.for.sea-ice.(W/m2)......................................................",&
".GFLUX_SEA.........4..X1..Ground.flux.over.tile.sea.(W/m2).....................................................................",&
".FMU_SEA...........4..X1.......................................................................................................",&
".FMV_SEA...........4..X1......................................................................................................."/

DATA (CDESC (I), I = 411, 420) / &
".T2M_SEA...........4..X1.......................................................................................................",&
".T2MMIN_SEA........4..X1.......................................................................................................",&
".T2MMAX_SEA........4..X1.......................................................................................................",&
".Q2M_SEA...........4..X1.......................................................................................................",&
".HU2M_SEA..........4..X1.......................................................................................................",&
".HU2MMIN_SEA.......4..X1.......................................................................................................",&
".HU2MMAX_SEA.......4..X1.......................................................................................................",&
".ZON10M_SEA........4..X1.......................................................................................................",&
".MER10M_SEA........4..X1.......................................................................................................",&
".W10M_SEA..........4..X1......................................................................................................."/

DATA (CDESC (I), I = 421, 430) / &

".W10MMAX_SEA.......4..X1.......................................................................................................",&
".SWI3_ISBA.........4..X1..soil.wetness.index.for.layer.3.(-)...................................................................",&
".TSWI3_ISBA........4..X1..total.swi.(liquid+solid).for.3.(-)...................................................................",&
".DG3...............4..X2..soil.depth.(M).......................................................................................",&
".WFC3..............4..X1..field.capacity.by.layer.(m3/m3)......................................................................",&
".WSAT3.............4..X1..soil.porosity.by.layer.(m3/m3).......................................................................",&
".WWILT3............4..X1..wilting.point.by.layer.(m3/m3).......................................................................",&
".RI_TEB............4..X1..Ri num town..........................................................................................",&
".RN_TEB............4..X1..Net radiation town...................................................................................",&
".H_TEB.............4..X1..Sens heat flux town.................................................................................."/

DATA (CDESC (I), I = 431, 440) / &
".LE_TEB............4..X1..Latent heat flux town................................................................................",&
".GFLUX_TEB.........4..X1..Conduct flux town....................................................................................",&
".FMU_TEB...........4..X1..Momentum flux U-comp.................................................................................",&
".FMV_TEB...........4..X1..Momentum flux V-comp.................................................................................",&
".T2M_TEB...........4..X1..T2m town.............................................................................................",&
".Q2M_TEB...........4..X1..Q2m town.............................................................................................",&
".HU2M_TEB..........4..X1..RH2m.................................................................................................",&
".ZON10M_TEB........4..X1..U10m town............................................................................................",&
".MER10M_TEB........4..X1..V10m town............................................................................................",&
".TI_BLD............4..X1......................................................................................................."/

DATA (CDESC (I), I = 441, 450) / &
".XTI_BLD...........4..X1.......................................................................................................",&
".SSO_CAN_U01.......4..X1.......................................................................................................",&
".SSO_CAN_U02.......4..X1.......................................................................................................",&
".SSO_CAN_U03.......4..X1.......................................................................................................",&
".SSO_CAN_U04.......4..X1.......................................................................................................",&
".SSO_CAN_U05.......4..X1.......................................................................................................",&
".SSO_CAN_U06.......4..X1.......................................................................................................",&
".SSO_CAN_E01.......4..X1.......................................................................................................",&
".SSO_CAN_E02.......4..X1.......................................................................................................",&
".SSO_CAN_E03.......4..X1......................................................................................................."/
DATA (CDESC (I), I = 451, 461) / &
".SSO_CAN_E04.......4..X1.......................................................................................................",&
".SSO_CAN_E05.......4..X1.......................................................................................................",&
".SSO_CAN_E06.......4..X1.......................................................................................................",&
".CD_SEA............4..X1..drag.coefficient.for.wind.over.sea...(W/s2)..........................................................",&
".CD_ISBA...........4..X1..drag.coefficient.for.wind.over.nature.(W/s2).........................................................",&
".CD_TEB............4..X1..drag.coefficient.for.wind.over.town(W/s2)............................................................",&
".CD................4..X1..drag.coefficient.for.wind.(W/s2).....................................................................",&
".CH_SEA............4..X1..drag.coefficient.for.heat.over.sea...(W/s)...........................................................",&
".CE_SEA............4..X1..drag.coefficient.for.vapor.over.sea...(W/s/K)........................................................",&
".Z0_SEA............4..X1..roughness.length.over.sea.(m).  .....................................................................",&
".Z0H_SEA...........4..X1..thermal.roughness.length.over.sea.(m).  ............................................................."/

DATA (CDESC (I), I = 462, 473) / &
".CH_ISBA...........4..X1..drag.coefficient.for.heat.over.nature...(W/s)........................................................",&
".CH_TEB............4..X1..drag.coefficient.for.heat.over.town.....(W/s)........................................................",&
".CE_ISBA...........4..X1..drag.coefficient.for.vapor.over.nature...(W/s/K).....................................................",&
".CE_TEB............4..X1..drag.coefficient.for.vapor.over.town.....(W/s/K).....................................................",&
".Z0_ISBA...........4..X1..roughness.length.over.nature.(m).  ..................................................................",&
".Z0_TEB............4..X1..roughness.length.over.town.(m).  ....................................................................",&
".Z0H_ISBA..........4..X1..thermal.roughness.length.over.nature.(m).............................................................",&
".Z0H_TEB...........4..X1..thermal.roughness.length.over.town.(m)...............................................................",&
".CH................4..X1..drag.coefficient.for.heat...(W/s)....................................................................",&
".CE................4..X1..drag.coefficient.for.vapor...(W/s/K).................................................................",&
".Z0................4..X1..roughness.length...(m).  ............................................................................",&
".Z0H...............4..X1..thermal.roughness.length...(m)......................................................................."/

DATA (CDESC (I), I = 474, 478) / &
".UREF..............4..X1.......................................................................................................",&
".VREF..............4..X1.......................................................................................................",&
".ZREF..............4..X1.......................................................................................................",&
".SIC...............4..X1..Sea.ice.concentration................................................................................",&
"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567"/


SAVE

CONTAINS

LOGICAL FUNCTION LISDIGIT (LDC)

CHARACTER, INTENT (IN) :: LDC

LISDIGIT = ('0' <= LDC) .AND. (LDC <= '9')

END FUNCTION LISDIGIT

LOGICAL FUNCTION LISUCALPHA (LDC)

CHARACTER, INTENT (IN) :: LDC

LISUCALPHA = ('A' <= LDC) .AND. (LDC <= 'Z')

END FUNCTION LISUCALPHA

SUBROUTINE SFXFLDDESC_LOOKUP (CDNAME, YDDESC, CDDESC, KERR)

CHARACTER (LEN=*),  INTENT (IN)            :: CDNAME
TYPE (SFXFLDDESC),  INTENT (OUT)           :: YDDESC
CHARACTER (LEN=*),  POINTER,      OPTIONAL :: CDDESC (:)
INTEGER (KIND=JPIM),INTENT (OUT), OPTIONAL :: KERR

#include "abor1.intfb.h"

INTEGER (KIND=JPIM) :: IERR

IERR = 1

IF (PRESENT (CDDESC)) THEN
  IF (ASSOCIATED (CDDESC)) THEN
    CALL SFXFLDDESC_LOOKUP1 (CDDESC, CDNAME, YDDESC, IERR)
    IF (IERR == 0) GOTO 200
  ENDIF
ENDIF

IF ( INDEX(CDNAME, 'SNOW_ICE') /= 0 ) THEN
  YDDESC%IGRID = 4
  YDDESC%CTYPE = 'X1'
  YDDESC%CCOMM = 'SNOW_ICE'
  YDDESC%CNAME = CDNAME
  IERR = 0
  GOTO 200
ENDIF

IF ( CDNAME (1:4) == 'TICE' ) THEN
  YDDESC%IGRID = 4
  YDDESC%CTYPE = 'X1'
  YDDESC%CCOMM = 'TICE'
  YDDESC%CNAME = CDNAME
  IERR = 0
  GOTO 200
ENDIF

IF ((CDNAME (1:5) == 'COVER') .AND. LISDIGIT (CDNAME (6:6)) .AND. &
  & LISDIGIT (CDNAME (7:7)) .AND. LISDIGIT (CDNAME (8:8)) .AND. &
  & (CDNAME (9:9) == ' ')) THEN
  YDDESC%IGRID = 4
  YDDESC%CTYPE = 'X1'
  YDDESC%CCOMM = 'X_Y_COVER'//CDNAME (7:9)//&
 &'                                                                                         '
  YDDESC%CNAME = CDNAME
  IERR = 0
  GOTO 200
ENDIF

IF ((CDNAME (1:9) == 'ISBA_CAN_') .AND. LISUCALPHA (CDNAME (10:10)) .AND. &
  & LISDIGIT (CDNAME (11:11)) .AND. LISDIGIT (CDNAME (12:12)) .AND. (CDNAME (13:13) == ' ')) THEN
  YDDESC%IGRID = 4
  YDDESC%CTYPE = 'X1'
  SELECT CASE (CDNAME (10:10))
    CASE ('Q') ; YDDESC%CCOMM = 'humidity at canopy levels (kg/m3)'
    CASE ('Z') ; YDDESC%CCOMM = 'altitudes of canopy levels (m)'
    CASE ('T') ; YDDESC%CCOMM = 'temperature at canopy levels (K)'
    CASE ('E') ; YDDESC%CCOMM = 'Tke at canopy levels (m2/s2)'
    CASE ('U') ; YDDESC%CCOMM = 'wind at canopy levels (m/s)'
    CASE ('P') ; YDDESC%CCOMM = 'Pressure at canopy levels (Pa)'
    CASE DEFAULT
      GOTO 100
  END SELECT
  YDDESC%CNAME = CDNAME
  IERR = 0
  GOTO 200
ENDIF

100 CONTINUE

CALL SFXFLDDESC_LOOKUP1 (CDESC, CDNAME, YDDESC, IERR)

200 CONTINUE

IF (PRESENT (KERR)) THEN
  KERR = IERR
ELSEIF (IERR /= 0) THEN
  CALL ABOR1 ('SFXFLDDESC_LOOKUP: '//CDNAME//' WAS NOT FOUND')
ENDIF

END SUBROUTINE SFXFLDDESC_LOOKUP

SUBROUTINE SFXFLDDESC_LOOKUP1 (CDDESC, CDNAME, YDDESC, KERR)

CHARACTER (LEN=*),   INTENT (IN)  :: CDDESC (:)
CHARACTER (LEN=*),   INTENT (IN)  :: CDNAME
TYPE (SFXFLDDESC),   INTENT (OUT) :: YDDESC
INTEGER (KIND=JPIM), INTENT (OUT) :: KERR


INTEGER (KIND=JPIM), PARAMETER :: INAMEI1 =   2_JPIM, INAMEI2 =  17_JPIM, &
                                & IGRIDI1 =  19_JPIM, IGRIDI2 =  20_JPIM, &
                                & ITYPEI1 =  23_JPIM, ITYPEI2 =  24_JPIM, &
                                & ICOMMI1 =  27_JPIM, ICOMMI2 = 126_JPIM

CHARACTER (LEN=128) :: CLDESC

INTEGER (KIND=JPIM) :: I, J

KERR = 0

DO I = 1, SIZE (CDDESC)

  CLDESC = CDDESC (I)

  DO J = 2, LEN (CLDESC)
    IF (CLDESC (J:J) == CLDESC (1:1)) CLDESC (J:J) = ' '
  ENDDO

  IF (CLDESC (INAMEI1:INAMEI2) == CDNAME) THEN

    READ (CLDESC (IGRIDI1:IGRIDI2), '(I2)') YDDESC%IGRID
    YDDESC%CTYPE = CLDESC (ITYPEI1:ITYPEI2)
    YDDESC%CCOMM = CLDESC (ICOMMI1:ICOMMI2)
    YDDESC%CNAME = CDNAME

    RETURN
  ENDIF

ENDDO

KERR = 1

END SUBROUTINE SFXFLDDESC_LOOKUP1

END MODULE SFXFLDDESC_MOD

