#
# SURFEX namelist dictionary
#
# Each namelist are generated by gen_namelist.pl. The rules
# for this generation are defined in the Makefile.
#
# To generate all possible namelists run "gmake all"
# in the current directory. Run "gmake clean" to clean.
#
# Note that changes may be done to the namelists in the scripts
#


###########################################################
# PGD                                                     #
###########################################################

# 2 layer ISBA scheme
%isba_2L=(
 NAM_ISBA=>{
  CISBA          => '"2-L",',
  NGROUND_LAYER  => '2,',
 },
);

# 3 layer ISBA scheme
%isba_3L=(
 NAM_ISBA=>{
  CISBA          => '"3-L",',
  NGROUND_LAYER  => '3,',
 },
);

%isba_pgd=(
 NAM_ISBA=>{
   YCLAY         => 'YCLAY,',
   YCLAYFILETYPE => '"DIRECT",' ,
   YSAND         => 'YSAND,',
   YSANDFILETYPE => '"DIRECT",'
 },
);

%pgd=(
 NAM_IO_OFFLINE=>{
  CSURF_FILETYPE => 'CSURF_FILETYPE,',
   CPGDFILE      => 'CPGDFILE,',
 },
 NAM_PGD_GRID=>{
   CGRID         => '"CONF PROJ",',
 },
 NAM_CONF_PROJ=>{
   XLAT0         => $ENV{LAT0},
   XLON0         => $ENV{LON0},
   XRPK          => $ENV{SINLAT0},
   XBETA         => 0.0,
 },
 NAM_CONF_PROJ_GRID=>{
   XLATCEN       => $ENV{LATC},
   XLONCEN       => $ENV{LONC},
   NIMAX         => NIMAX,
   NJMAX         => NJMAX,
   XDX           => $ENV{GSIZE},
   XDY           => $ENV{GSIZE},
 },
 NAM_COVER=> {
   YCOVER        => 'YCOVER,',
   YFILETYPE     => '"DIRECT",',
 },
 NAM_ZS=>{
   YZS           => '"gtopo30",',
   YFILETYPE     => '"DIRECT",',
 },
 NAM_SEABATHY=>{
   XUNIF_SEABATHY=>'0.,',
 },
 NAM_PGD_SCHEMES=>{
    CNATURE => '"ISBA ",',
    CSEA    => '"SEAFLX",',
    CWATER  => '"WATFLX",',
    CTOWN   => '"TEB ",',
 },
);

# ALARO SPECIFICS
%alaro_pgd=(
 NAM_PGD_ARRANGE_COVER=>{
   LTOWN_TO_ROCK=>'.TRUE.',
 },
 NAM_PGD_SCHEMES=>{
    CTOWN   => '"NONE  ",',
 },
);

###########################################################
# PREP                                                    #
###########################################################

%isba_prep=(
 NAM_PREP_ISBA=>{
   LISBA_CANOPY  => '.TRUE.,',
   LEXTRAP_TG    => '.TRUE.,',
   LEXTRAP_WG    => '.TRUE.,',
   LEXTRAP_WGI   => '.TRUE.,',
   LEXTRAP_SN    => '.TRUE.,',
   NDIM_EXTRAP   => '20,',
 },
 NAM_PREP_ISBA_SNOW=>{
   LSWEMAX       => '.TRUE.,',
 },
 NAM_DIAG_ISBAn=>{
   LPATCH_BUDGET=>'.TRUE.,',
 },
 NAM_PREP_SEAFLUX=>{
    CFILE_SIC           =>'CFILE_SIC,',
    CTYPE_SIC           =>'"GRIB  "',
 },
 NAM_SEAFLUXn=>{
    CSEA_ICE            =>'"SICE",',
    NICE_LAYER          =>'4,',
    LHANDLE_SIC         =>'.TRUE.,',
    LSIC_FROM_FILE      =>'.TRUE.,',
 },
 NAM_SIMPLE_ICE=>{
    XICE_THICKNESS      =>'.75,',
    LICE_HAS_SNOW       =>'.FALSE.,',
    CICE_SNOW           =>'"3-L",',
    NICE_SNOW_NLAYERS   =>'4,',
    XICE_SNOW_HEIGHT    =>'.3,',
    LSIC_DRIVEN_THICKNESS=>'.FALSE.',
    XSIC_DRIVEN_MAX_THICKNESS=>'1.',
 },
 NAM_PREP_SIMPLE_ICE=>{
    LINIT_FROM_SST => '.TRUE.,',
 },
);

%fullpos_prep=(
NAM_FILE_NAMES=>{
   HPGDFILE      =>'"PGDFILE",',
   CINIFILE      =>'"SURFXINI",',
 },
);

%offline_prep=(
 NAM_IO_OFFLINE=>{
   CSURF_FILETYPE       => '"LFI   ",',
   CPREPFILE            => '"SURFXINI",',
   CPGDFILE             => '"PGD",',
 },
 NAM_PREP_SURF_ATM=>{
   CFILEPGD      =>'"PGD_host",',
   CFILEPGDTYPE  =>'"LFI",',
   CFILE      =>'"INFILE",',
   CFILETYPE  =>'CFILETYPE,',
   NYEAR      =>'NYEAR,',
   NMONTH     =>'NMONTH,',
   NDAY       =>'NDAY,',
   XTIME      =>'XTIME,',
 },
);

# AROME SPECIFICS
%alaro_prep=(
 NAM_PREP_SEAFLUX=>{
   LSEA_SBL     => '.FALSE.,',
 },
);

%arome_prep=(
 NAM_PREP_SEAFLUX=>{
   LSEA_SBL     => '.FALSE.,',
 },
);

###########################################################
# FORECAST                                                #
###########################################################

%isba_forecast=(
 NAM_ISBAn=>{
   CROUGH        => '"NONE",',
 },
 NAM_DIAG_ISBAn=>{
   LPGD     => '.TRUE.,',
   LSURF_MISC_BUDGET=> '.TRUE.,',
 },
);

%forecast=(
 NAM_IO_OFFLINE=>{
  'CSURF_FILETYPE'      => '"LFI    ",',
  'CFORCING_FILETYPE'   => '"ASCII",',
  'CTIMESERIES_FILETYPE'=> '"LFI",',
  'XTSTEP_SURF'         => $ENV{TSTEP}.",",
  'XTSTEP_OUTPUT'       => '3600.,',
  'LRESTART'            => '.TRUE.,',
  'CPREPFILE'           => '"PREP",',
  'CPGDFILE'            => '"PGD",',
 },
 NAM_SURF_ATM=>{
   XRIMAX=>'0.0,',
 },
 NAM_DIAG_SURFn=>{
   N2M               => '2,',
   LSURF_BUDGET      => '.TRUE.,',
   LCOEF             => '.TRUE.,',
   LSURF_VARS        => '.TRUE.,',
 },
 NAM_DIAG_SURF_ATMn=>{
   LT2MMW            => '.TRUE.,',
 },
 NAM_DIAG_ISBAn=>{
   LPATCH_BUDGET  => '.TRUE.,',
 },
 NAM_SSOn=>{
   CROUGH   => "'".$ENV{CROUGH}."'",
   XFRACZ0  => '15.,',
 },
 NAM_SEAFLUXn=>{
  CSEA_FLUX             => '"ECUME",',
  LPWG                  => '.FALSE.,',
  LPRECIP               => '.FALSE.,',
  LPWEBB                => '.FALSE.,',
  CSEA_ICE              => '"SICE",',
  NICE_LAYER            => '4,',
  LHANDLE_SIC           => '.TRUE.,',
  LSIC_FROM_FILE        => '.TRUE.,',
 },
 NAM_SIMPLE_ICE=>{
    XICE_THICKNESS      =>'.75,',
    LICE_HAS_SNOW       =>'.FALSE.,',
    CICE_SNOW           =>'"3-L",',
    NICE_SNOW_NLAYERS   =>'4,',
    XICE_SNOW_HEIGHT    =>'.3,',
    LSIC_DRIVEN_THICKNESS    =>'.FALSE.',
    XSIC_DRIVEN_MAX_THICKNESS=>'1.',
 },
 NAM_ISBAn=>{
  LCANOPY_DRAG => '.TRUE.,',
  XCDRAG       => '0.01',
 },
);

%alaro_forecast=(
 NAM_DIAG_SURFn=>{
   LCOEF             => '.TRUE.,',
 },
);

######################################################################################
#     ASSIMILATION SETTINGS                                                          #
######################################################################################

%assim_surfex=(
 NAM_NACVEG=>{
   NECHGU      => ''.$ENV{FCINT}.',',
   RCLIMCA     => '0.,',
   RCLISST     => '0.05,',
   SIGH2MO     => '0.10,',
   SIGT2MO     => '1.0,',
   LOBS2M      => '.TRUE.,',
   LOBSWG      => '.FALSE.,',
 },
 NAM_IO_OFFLINE=>{
   CSURF_FILETYPE       => 'CSURF_FILETYPE,',
   CTIMESERIES_FILETYPE => '"LFI ",',
   CFORCING_FILETYPE    => '"ASCII",',
   LRESTART             => '.TRUE.,',
   XTSTEP_SURF          => '3600.,',
   XTSTEP_OUTPUT        => '3600.,',
 },
 NAM_ASSIM=>{
   LASSIM              => '.TRUE.,',
   LEXTRAP_WATER       => '.TRUE.,',
   LEXTRAP_SEA         => '.FALSE.,',
   LEXTRAP_NATURE      => '.FALSE.',
   LREAD_SST_FROM_FILE => '.TRUE.,',
   LWATERTG2           => '.TRUE.,',
   LAESNM      => 'LAESNM,',
   LECSST      => 'LECSST,',
   LAROME              => 'LAROME,',
   NPRINTLEV           => '1,',
 },
 NAM_SEAFLUXn=>{
   CSEA_ICE               =>'"SICE",',
   NICE_LAYER             =>'4,',
   LHANDLE_SIC            =>'.TRUE.,',
   LSIC_FROM_FILE         =>'.TRUE.,',
   LMISSING_ICE_VARIABLES =>'.FALSE.,',
 },
 NAM_SIMPLE_ICE=>{
   LICE_HAS_SNOW       =>'.FALSE.,',
   XICE_THICKNESS      =>'.75,',
   CICE_SNOW           =>'"3-L",',
   NICE_SNOW_NLAYERS   =>'4,',
   XICE_SNOW_HEIGHT    =>'.3,',
   LSIC_DRIVEN_THICKNESS      =>'.FALSE.',
   XSIC_DRIVEN_MAX_THICKNESS  =>'1.',

},
 NAM_PREP_SEAFLUX=>{
    CFILE_SIC          => 'CFILE_SIC,',
    CTYPE_SIC          => '"GRIB  "',
    LSEA_SBL           => '.FALSE.',
 },
 NAM_PREP_SIMPLE_ICE=>{
    LINIT_FROM_SST             =>'.TRUE.,',
    LPREP_ONLY_NEW_ICE         =>'.TRUE.,',
    LEXTRAPOLATE_FROM_FORECAST =>'.TRUE.,',
    CFORECAST_GRIB             =>'CFORECAST_GRIB',
 },

);

%oi_main=(
 NAM_ASSIM=>{
   CASSIM_ISBA         => '"OI",',
 },
);

%ekf_main=(
 NAM_ASSIM=>{
   CASSIM_ISBA         => '"EKF",',
 },
 NAM_DIAG_ISBAn=>{
   LSURF_MISC_BUDGET => '.TRUE.,',
 },
 NAM_IO_VARASSIM=>{
   LPRT         =>  'LPRT',
   LSIM         =>  'LSIM',
   LBEV         =>  'LBEV',
   LBFIXED      =>  'LBFIXED',
 },
 NAM_OBS=>{
   NOBSTYPE     => '2,',
   YERROBS      => '1.0,0.1,0.4,',
   INCO         => 'INCO',
 },
 NAM_VAR=>{
   IVAR         => 'VV,',
   NVAR         => 'NV,',
   XVAR_M       => '"WG2","WG1","TG2","TG1",',
   XSIGMA_M     => '0.15,0.1,2.0,2.0,',
   TPRT_M       => '0.0001,0.0001,0.00001,0.00001,',
   INCV         => 'INCV',
   SCALE_Q      => '0.125,',
 },
);
