#!/usr/bin/env python
# -*- coding: utf-8 -*- Time-stamp: <2018-03-07 13:58:51 sander>

# rstools
# Rolf Sander, 2018

##############################################################################

import os, sys, shutil
import subprocess

HLINE  = '-' * 78
HLINE2 = '*' * 78

##############################################################################

def runcmd(cmd, logfilename, verbosity=1):
    # verbosity = 0 --> no output
    # verbosity = 1 --> print command and logfile
    # verbosity = 2 --> print also HLINEs
    CMDLOGFILE = open(logfilename,'w+', 1)
    if (verbosity>0):
        print
        if (verbosity>1): print HLINE
        print '%s > %s ' % (cmd, os.path.basename(logfilename)),
        sys.stdout.flush() # print now, don't wait till cmd has finished
    exitstatus = subprocess.call(
        'time -p '+cmd, stdout=CMDLOGFILE, stderr=CMDLOGFILE, shell=True)
    if (verbosity>0): print 'DONE'
    if (verbosity>1): print HLINE
    CMDLOGFILE.close()
    if (exitstatus != 0):
        print '\n\n%s' % (HLINE2)
        tail(logfilename, 20)
        print '%s\nsee: %s\nERROR: exitstatus = %d\n%s' % (
            HLINE2, logfilename, exitstatus, HLINE2)
        sys.exit(1)

##############################################################################

# https://gist.github.com/amitsaha/5990310
def tail(filename,lines):
    with open(filename) as f:
        content = f.read().splitlines()
    count = len(content)
    #print 'The file %s has %d lines.' % (filename, count)
    for i in range(max(0,count-int(lines)),count):
        print content[i]

##############################################################################

# - not tested yet
# - provide alternative if $TRASH does not exist?

# def rm(filename):
#     import datetime
#     if (os.getenv('TRASH')):
#         # $TRASH exists, move old data to trash directory:
#         trashsubdir = os.getenv(
#             'TRASH') + '/' + datetime.datetime.now().strftime('%Y-%m-%d-%H:%M:%S')
#         os.mkdir(trashsubdir)
#         shutil.move(filename, trashsubdir)
#     else:
#         sys.exit('ERROR')

##############################################################################

if __name__ == '__main__':

    # test tail:
    tail(sys.argv[1], sys.argv[2])

