! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Rates.f90
! Time                 : Tue Aug  7 17:33:28 2018
! Working directory    : /home/sander/e2/messy_d2.53.0.24_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Rates

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  ELEMENTAL REAL(dp) FUNCTION k_SIV_H2O2 (k_298,tdep,cHp,temp)
    ! special rate function for S(IV) + H2O2
    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(dp), INTENT(IN) :: cHp   ! c(H+)
    REAL(dp), INTENT(IN) :: temp  ! temperature
    INTRINSIC :: EXP
    k_SIV_H2O2 = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) &
      * cHp / (cHp+0.1_dp)
  END FUNCTION k_SIV_H2O2
  ELEMENTAL REAL(dp) FUNCTION k_3rd_iupac(temp,cair,k0_300K,n,kinf_300K,m,fc)
    ! IUPAC three body reaction formula (iupac.pole-ether.fr)
    INTRINSIC :: LOG10
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL,     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL,     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL,     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL,     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL,     INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL                 :: nu        ! N
    REAL                 :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k_3rd_iupac = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k_3rd_iupac
  ELEMENTAL REAL(dp) FUNCTION alpha_AN(n,ro2type,bcarb,gcarb,abic,temp,cair)
  ! Alkyl nitrate yields dependent on T and P according to
  ! Arey. ref3202 and Teng, ref3189
    INTRINSIC :: LOG10
    INTEGER,  INTENT(IN) :: n         ! number of heavy atoms (C, O, N) except the O atom of beta-carbonyls
    INTEGER,  INTENT(IN) :: ro2type   ! 1, 2 or 3 for primary, secondary and tertiary RO2
    INTEGER,  INTENT(IN) :: bcarb     ! 1 for beta-carbonyl group, 0 for none
    INTEGER,  INTENT(IN) :: gcarb     ! 1 for gamma-carbonyl group, 0 for none
    INTEGER,  INTENT(IN) :: abic      ! 1 for bicyclic peroxy from aromatics, 0 for none
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), PARAMETER  :: alpha=2.E-22, beta=1.0, Yinf_298K=0.43, F=0.41, m0=0., minf=8.0
    REAL(dp)             :: m           ! factor for primary, secondary and tertiary RO2
    REAL(dp)             :: bcf,gcf,abf ! reduction factors for the presence of beta-carbonyl and gamma-carbonyl group and a bicyclic peroxy from aromatics
    REAL(dp)             :: Y0_298K, Y0_298K_tp, Yinf_298K_t, zeta, k_ratio
    m = 1. ! According to Teng, ref3189
    IF (bcarb .EQ. 1) THEN
      bcf = 0.19 ! derived from Praske, ref3190: alpha_AN = 0.03 for the secondary HMKO2 relative to alpha_AN for 6C RO2 (0.16)
    ELSE IF (bcarb .EQ. 0) THEN
      bcf = 1.
    ELSE
      bcf = 1.
    ENDIF
    IF (gcarb .EQ. 1) THEN
      gcf = 0.44 ! derived from Praske, ref3190: alpha_AN = 0.07 for the primary HMKO2 relative to alpha_AN for 6C RO2 (0.16)
    ELSE IF (gcarb .EQ. 0) THEN
      gcf = 1.
    ELSE
      gcf = 1.
    ENDIF
    IF (abic .EQ. 1) THEN
      abf = 0.24 ! derived from the ratio of AN-yield for toluene from Elrod et al. (ref3180), 5.5 0x0.0000001161f22p-1022t 200 torr, and this SAR for linear alkyl RO2 with 9 heavy atoms, 23.3%
    ELSE IF (abic .EQ. 0) THEN
      abf = 1.
    ENDIF
    Y0_298K     = alpha*EXP(beta*n)
    Y0_298K_tp  = Y0_298K * cair * (temp/298)**(-m0)
    Yinf_298K_t = Yinf_298K * (temp/298)**(-minf)
    zeta        = 1/(1+LOG10(Y0_298K_tp/Yinf_298K_t)**2)
    k_ratio     = (Y0_298K_tp/(1+Y0_298K_tp/Yinf_298K_t))*F**zeta
    alpha_AN    = k_ratio/(1+k_ratio) * m * bcf * gcf * abf
  END FUNCTION alpha_AN
  ELEMENTAL REAL(dp) FUNCTION k_limited (k3rd,cHp)
    ! diffusion limitation caps 3rd order rate coefficients
    REAL(dp), INTENT(IN) :: k3rd  ! 3rd order rate coefficient
    REAL(dp), INTENT(IN) :: cHp   ! c(H+)
    REAL(dp), PARAMETER  :: DiffLimit = 1E10 ! diffusion limitation [M-1s-1]
    INTRINSIC :: EXP
    k_limited = 1._dp / ( 1._dp/k3rd + cHp/DiffLimit)
  END FUNCTION k_limited
  ELEMENTAL REAL(dp) FUNCTION k_N2_O(temp,temp_ion)
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: temp_ion  ! ion temperature [K]
    REAL                 :: temp_mean
    temp_mean = (temp_ion + temp)/2
    k_N2_O = 1.4E-10*(300./temp_mean)**0.44
  END FUNCTION k_N2_O
  ELEMENTAL REAL(dp) FUNCTION k_Op_O2(temp,temp_ion)
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: temp_ion  ! ion temperature [K]
    REAL(dp)             :: temp_mean
    temp_mean  = .667*temp_ion + .333*temp
    k_Op_O2  = 2.82E-11 - 7.74E-12*(temp_mean/300.) + &
      1.073E-12*(temp_mean/300.)**2 - 5.17E-14*(temp_mean/300.)**3 + &
      9.65E-16*(temp_mean/300.)**4
  END FUNCTION k_Op_O2
  ELEMENTAL REAL(dp) FUNCTION k_Op_N2(temp,temp_ion)
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: temp_ion  ! ion temperature [K]
    REAL(dp)             :: temp_mean
    temp_mean = .6363*temp_ion + .3637*temp
    k_Op_N2 = 1.533E-12 - 5.92E-13*(temp_mean/300.) + 8.6E-14*(temp_mean/300.)**2
  END FUNCTION k_Op_N2

! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE messy_mecca_kpp_Parameters
      !USE messy_mecca_kpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


  USE messy_main_constants_mem ! atm2Pa, N_A, R_gas
  USE messy_cmn_photol_mem     ! IP_MAX, ip_*, jname
  ! end of USE statements

  ! start of executable statements
  ! define some rate constants here if the expressions are too long
  ! for kpp or if they are used more than once
  ! --------------------------------------------------------------------------
  ! inorganic and C1 chemistry:
  k_HO2_HO2    = (3.0E-13*EXP(460./temp)+2.1E-33*EXP(920./temp)*cair)* &
                 (1.+1.4E-21*EXP(2200./temp)*C(ind_H2O))
  k_NO3_NO2    = k_3rd(temp,cair,2.4E-30,3.0,1.6E-12,-0.1,0.6)
  k_NO2_HO2    = k_3rd(temp,cair,1.9E-31,3.4,4.0E-12,0.3,0.6)
  k_HNO3_OH    = 1.32E-14*EXP(527./temp) + 1./ & ! "All data" in Tab. 1 of ref3325
                 ( 1./(7.39E-32*EXP(453./temp)*cair) + &
                 1./(9.73E-17*EXP(1910./temp)) ) ! 15 % (Pozzer, pers. comm.)
  k_CH3OOH_OH  = 5.3E-12*EXP(190./temp)
  k_ClO_ClO    = k_3rd(temp,cair,1.9E-32,3.6,3.7E-12,1.6,0.6)
  k_BrO_NO2    = k_3rd_iupac(temp,cair,4.7E-31,3.1,1.8E-11,0.0,0.4)
  ! JPL: k_BrO_NO2   = k_3rd(temp,cair,5.2E-31,3.2,6.9E-12,2.9,0.6)
  k_I_NO2      = k_3rd_iupac(temp,cair,3.0E-31,1.0,6.6E-11,0.0,0.63)
  ! for numerical reasons, the expression is multiplied by 1e30/1e30
  k_DMS_OH     = 1.E-9*EXP(5820./temp)*C(ind_O2)/ &
                 (1.E30+5.*EXP(6280./temp)*C(ind_O2))
  k_CH2OO_SO2  = 3.66E-11 ! average of 3.9E-11 + 3.42E-11
  k_O3s = (1.7E-12*EXP(-940./temp)) * C(ind_OH) &  ! <G2104>
        + (1.E-14*EXP(-490./temp)) * C(ind_HO2) &  ! <G2107>
        + jx(ip_O1D) * 2.2E-10 * C(ind_H2O) &      !
        / ( 3.2E-11*EXP(70./temp)*C(ind_O2)   &
           + 1.8E-11*EXP(110./temp)*C(ind_N2) &
           + 2.2E-10*C(ind_H2O) )
  ! new methane chemistry:
  ! branching ratio for methyl nitrate according to Butkovskaya et al.,
  ! (ref3177) but reduced according to Flocke et al. (ref3164)
  ! fit of data according to Lindemann-Hinshelwood scheme by J. Crowley
  ! http://iupac.pole-ether.fr/datasheets/pdf/ROO_1_CH3O2_NO.pdf
  beta_null_CH3NO3 = 0.00295 + 5.15E-22*cair*(temp/298)**7.4
  beta_inf_CH3NO3  = 0.022
  beta_CH3NO3      = (beta_null_CH3NO3 * beta_inf_CH3NO3) /&
                     (beta_null_CH3NO3 + beta_inf_CH3NO3) / 10.
  k_NO2_CH3O2      = k_3rd(temp,cair,1.0E-30,4.8,7.2E-12,2.1,0.6)
  k_C6H5O2_NO2     = k_NO2_CH3O2 ! Consistent with ref3167 that set 1E-12 as lower limit at 298 K and 1 bar.
  k_CH2OO_NO2          = 4.25E-12 ! average of 7.E-12 and 1.5E-12
  ! branching ratio for ethylnitrate formation according to Butkovskaya ref3170
  ! ratio transformed from beta = k1b/k1a to beta_C2H5NO3 = (1-(1+beta)^(-1))
  beta_C2H5NO3    = (1-1/(1+1.E-2*(3.88e-3*cair/2.46e19*760.+.365)*(1+1500.*(1/temp -1/298.))))
  ! --------------------------------------------------------------------------
  ! only for mim1, see mim1.rpl:
  ! op_kg_20110805+ for HO2 + NO -> HNO3 (butkovskaya_*.rpl)
  alpha_NO_HO2 = C(ind_H2O)*6.6E-27*temp*EXP(3700./temp)
  beta_NO_HO2  = MAX(((530./temp)+(press*4.8004E-6)-1.73)*0.01,0._dp)
  k0_NO_HO2    = 3.5E-12*EXP(250./temp)
  ! without humidity correction
  k2d_NO_HO2   = (beta_NO_HO2*k0_NO_HO2)/(1.+beta_NO_HO2)
  k1d_NO_HO2   = k0_NO_HO2 - k2d_NO_HO2
  ! with humidity correction
  k2w_NO_HO2   = (beta_NO_HO2*k0_NO_HO2*(1.+42.*alpha_NO_HO2))/ &
                 ((1.+alpha_NO_HO2)*(1.+beta_NO_HO2))
  k1w_NO_HO2   = k0_NO_HO2 - k2w_NO_HO2
  ! op_kg_20110805-
  k_PrO2_HO2   = 1.9E-13*EXP(1300./temp)
  k_PrO2_NO    = 2.7E-12*EXP(360./temp)
  k_PrO2_CH3O2 = 9.46E-14*EXP(431./temp)
  G7402a_yield = 0.8/1.1 ! 0.8+/-0.2
  ! end of mim1 block
  ! --------------------------------------------------------------------------
  k_CH3CO3_NO2 = k_3rd(temp,cair,9.7E-29,5.6,9.3E-12,1.5,0.6)
  k_PAN_M      = k_CH3CO3_NO2/(9.0E-29*EXP(14000./temp))
  ! rate coefficients from the MCM:
  KRO2NO  = 2.54E-12*EXP(360./temp)
  KRO2HO2(:) = 2.91E-13*EXP(1300./temp)*(1.-EXP(-0.245*REAL(nC(:),dp))) ! ref1630
  KAPNO   = 8.10E-12*EXP(270./temp)  ! CH3CO3 + NO
  KRO2NO3 = 2.30E-12 ! ref2419
  KNO3AL  = 1.4E-12*EXP(-1900./temp)
  ! updated rate constant for the RCO3+HO2 reactions
  ! (GroC, PhD Thesis, ref3195)
  ! except CH3CO3+HO2 that is taken from GroC ref3156
  KAPHO2  = 5.20E-13*EXP(980./temp)*1.865 ! at 298K k(hoch2co3 + ho2) = 2.6(+-0.4)E-11 scaled with IUPAC T-dependent expression
  ! Rate constants for the permutation reaction formalism
  ! calculated as in the permutation reaction formalism of MCM
  ! k_RO2 = 2.*(KRO2self*k_CH3O2)^0.5
  ! k_RO2self are taken from IUPAC recommendations unless noted otherwise
  k_CH3O2     = 1.03E-13*EXP(365./temp) ! CH3O2 + CH3O2 (IUPAC)
  ! Acyl peroxy radicals
  k_RO2RCO3   = 2.*2.E-12*EXP(500./temp) ! K17 for the CH3O2 + CH3CO3 reaction directly taken from ref. 1759. Old MCM value 1.00E-11 at 298 K.
  ! Alkyl radicals (unsubstituted, > C3)
  k_RO2pRO2   = 2.*(1.E-12*k_CH3O2)**(.5)                      ! Model compound (CH3)2CHCH2O2 (isobutyl, ref3210). Old MCM value 1.30E-12 at 298 K.
  k_RO2sRO2   = 2.*(1.6E-12*EXP(-2200./temp)*k_CH3O2)**(.5)! Model compound i-C3H7O2 (ref3175). Old MCM value 2.50E-13 at 298 K.
  k_RO2tRO2   = 2.*3.8E-13*EXP(-1430./temp)                ! Model reaction t-C4H9O2 + CH3O2. Old MCM value 6.70E-15 at 298 K.
  ! Alkyl radical with either O or Cl in beta
  k_RO2pORO2  = 2.*7.5E-13*EXP(500./temp)                      ! Model reaction CH3COCH2O2 + CH3O2 (ref3175). Old MCM value 2.00E-12
  k_RO2sORO2  = 2.*(7.7E-15*EXP(1330./temp)*k_CH3O2)**(.5) ! Model compound CH3CH(OH)CH(O2)CH3 (ref3175). Old MCM value 8.80E-13 at 298 K.
  k_RO2tORO2  = 2.*(4.7E-13*EXP(-1420./temp)*k_CH3O2)**(.5)    ! Model compound (CH3)2C(OH)CO2(CH3)2 (ref3175). Old MCM value 9.20E-14 at 298 K.
  ! Allyl- and beta-hydroxy alkyl radicals
  k_RO2LISOPACO2 = 2.*((2.8E-12+3.9E-12)/2.*k_CH3O2)**(.5)  ! Model compound ISOPAO2 and ISOPCO2. Old MCM value 2.0E-12 at 298 K. K15 average from MCM ref. 2419
  k_RO2ISOPBO2   = 2.*(6.9E-14*k_CH3O2)**(.5)                  ! Model compound ISOPBO2. Old MCM value 2.9E-12 at 298 K. K15 from MCM ref. 2419
  k_RO2ISOPDO2   = 2.*(4.8E-12*k_CH3O2)**(.5)                  ! Model compound ISOPDO2. Old MCM value 8.0E-13 at 298 K. K15 from MCM ref. 2419
  ! T-dependent H-abstraction group rate constants
  k_p          = 4.49E-18*temp*temp*EXP(-320./temp) ! Kwok and Atkinson, ref3194
  k_s          = 4.50E-18*temp*temp*EXP(253./temp)  ! Kwok and Atkinson, ref3194
  k_t          = 2.12E-18*temp*temp*EXP(696./temp)  ! Kwok and Atkinson, ref3194
  k_rohro      = 2.1E-18*temp*temp*EXP(-85./temp)   ! Kwok and Atkinson, ref3194
  k_co2h       = .7*4.2E-14*EXP(850./temp)          ! CH3CO2H + OH = CH3CO2, ref1759
  ! T-dependent OH-addition rate constants
  k_adp        = 4.5E-12*(temp/300.)**(-0.85)                        ! 1/2 k(OH + C2H4), high pressure limit IUPAC as in Peeters et al. 2007
  k_ads        = .25*(1.1E-11*EXP(485./temp)+1.0E-11*EXP(553./temp)) ! 1/2 * k_av(OH + cis/trans 2-butene) as in Peeters et al. 2007
  k_adt        = 1.922E-11*EXP(450./temp) - k_ads                    ! k(OH + 2-methyl-2-butene) - k_ads
  KHSB         = 1.52E11*EXP(-9512./temp)*1. ! 1,5-H-shift Peeters et al(2009) 0.003533 s-1 at 303K
  KHSD         = 6.08E10*EXP(-8893./temp)*1. ! 1,5-H-shift Peeters et al(2009) 0.0109 s-1 at 303K
  ! 1,6-H-shift for ZISOPAO2 and ZISOPCO2
  K16HSZ14     = 2.28E9 * exp(-6764/temp) * 0.28 ! 0.07035 s-1 at 295K ! as in SI Taraborrelli et al., Nat. Geosc. 2012
  K16HSZ41     = 1.23E9 * exp(-6186/temp) * 0.28 ! 0.2692 s-1 at 295K
  K16HS        = (K16HSZ14*K16HSZ41)**(.5)
  K15HSDHB     = 5.                              ! 1,5-H-shift assisted by double H-bonding after Peeters and MC<ller(2010)
  ! 1,4-H-shift involving an aldehydic hydrogen
  !  K14HSAL = 2.9E7*exp(-5297/temp) ! Crounse et al. JPC A (2012) barrier 19.0 kcal/mol => ~ 0.5 s-1 at 295K
  K14HSAL      = 2.9E7*exp(-1*(5297+705)/temp) ! CCSD(T)/aug-Schartz4(DT)//M05-2X/6-311G(d,p)) yields a barrier of 20.39 (L. Vereecken 2013) => ~ 0.04 s-1 at 295K
  K15HS24VYNAL = K16HSZ14 * exp(-3500/(1.987*temp)) ! adding 3.5 kcal to the barrier of 1,6-H-shift as from SAR by L. Vereecken
  K15HS42VYNAL = K16HSZ41 * exp(-3500/(1.987*temp))
  KHYDEC       = 6.e14*exp(-16000./(1.98588*temp)) ! in cal Ea from Nguyen et al(2009) A from Baulch et al(2005)
  ! Rate constants for the formic acid production via vinyl alcohol. Also used for some bigger and saturated aldehydes.
  k_CH2CHOH_OH_HCOOH = 4.3E-11 ! ref3179
  k_CH2CHOH_OH_ALD   = 2.4E-11 ! ref3179
  k_CH2CHOH_HCOOH    = 4.67E-26*temp**3.286*EXP(4509./(1.987*temp)) ! ref3162
  k_ALD_HCOOH        = 1.17E-19*temp**1.209*EXP(-556./(1.987*temp)) ! ref3162
  J_IC3H7NO3   = 3.7*jx(ip_PAN)
  J_ACETOL     = 0.65*0.11*jx(ip_CHOH)
  J_HPALD      = (JX(IP_CH3OOH)+ JX(ip_MACR)/(2.*1.95E-3)) ! mcm.leeds.ac.uk/MCM/parameters/photolysis.htt
  J_KETENE     = jx(ip_MVK)/0.004
  RO2 = 0.
  IF (ind_LISOPACO2>0)            RO2 = RO2 + C(ind_LISOPACO2)
  IF (ind_LDISOPACO2>0)           RO2 = RO2 + C(ind_LDISOPACO2)
  IF (ind_ISOPBO2>0)              RO2 = RO2 + C(ind_ISOPBO2)
  IF (ind_ISOPDO2>0)              RO2 = RO2 + C(ind_ISOPDO2)
  IF (ind_LISOPEFO2>0)            RO2 = RO2 + C(ind_LISOPEFO2)
  IF (ind_NISOPO2>0)              RO2 = RO2 + C(ind_NISOPO2)
  IF (ind_LHC4ACCO3>0)            RO2 = RO2 + C(ind_LHC4ACCO3)
  IF (ind_LC578O2>0)              RO2 = RO2 + C(ind_LC578O2)
  IF (ind_C59O2>0)                RO2 = RO2 + C(ind_C59O2)
  IF (ind_LNISO3>0)               RO2 = RO2 + C(ind_LNISO3)
  IF (ind_CH3O2>0)                RO2 = RO2 + C(ind_CH3O2)
  IF (ind_HOCH2O2>0)              RO2 = RO2 + C(ind_HOCH2O2)
  IF (ind_CH3CO3>0)               RO2 = RO2 + C(ind_CH3CO3)
  IF (ind_C2H5O2>0)               RO2 = RO2 + C(ind_C2H5O2)
  IF (ind_HOCH2CO3>0)             RO2 = RO2 + C(ind_HOCH2CO3)
  IF (ind_HYPROPO2>0)             RO2 = RO2 + C(ind_HYPROPO2)
  IF (ind_LBUT1ENO2>0)            RO2 = RO2 + C(ind_LBUT1ENO2)
  IF (ind_BUT2OLO2>0)             RO2 = RO2 + C(ind_BUT2OLO2)
  IF (ind_HCOCO3>0)               RO2 = RO2 + C(ind_HCOCO3)
  IF (ind_CO2H3CO3>0)             RO2 = RO2 + C(ind_CO2H3CO3)
  IF (ind_LHMVKABO2>0)            RO2 = RO2 + C(ind_LHMVKABO2)
  IF (ind_MACO3>0)                RO2 = RO2 + C(ind_MACO3)
  IF (ind_MACRO2>0)               RO2 = RO2 + C(ind_MACRO2)
  IF (ind_PRONO3BO2>0)            RO2 = RO2 + C(ind_PRONO3BO2)
  IF (ind_HOCH2CH2O2>0)           RO2 = RO2 + C(ind_HOCH2CH2O2)
  IF (ind_CH3COCH2O2>0)           RO2 = RO2 + C(ind_CH3COCH2O2)
  IF (ind_IC3H7O2>0)              RO2 = RO2 + C(ind_IC3H7O2)
  IF (ind_NC3H7O2>0)              RO2 = RO2 + C(ind_NC3H7O2)
  IF (ind_LC4H9O2>0)              RO2 = RO2 + C(ind_LC4H9O2)
  IF (ind_TC4H9O2>0)              RO2 = RO2 + C(ind_TC4H9O2)
  IF (ind_LMEKO2>0)               RO2 = RO2 + C(ind_LMEKO2)
  IF (ind_HCOCH2O2>0)             RO2 = RO2 + C(ind_HCOCH2O2)
  IF (ind_EZCH3CO2CHCHO>0)        RO2 = RO2 + C(ind_EZCH3CO2CHCHO)
  IF (ind_EZCHOCCH3CHO2>0)        RO2 = RO2 + C(ind_EZCHOCCH3CHO2)
  IF (ind_CH3COCHO2CHO>0)         RO2 = RO2 + C(ind_CH3COCHO2CHO)
  IF (ind_HCOCO2CH3CHO>0)         RO2 = RO2 + C(ind_HCOCO2CH3CHO)
  IF (ind_C1ODC3O2C4OOH>0)        RO2 = RO2 + C(ind_C1ODC3O2C4OOH)
  IF (ind_C1OOHC2O2C4OD>0)        RO2 = RO2 + C(ind_C1OOHC2O2C4OD)
  IF (ind_C1ODC2O2C4OD>0)         RO2 = RO2 + C(ind_C1ODC2O2C4OD)
  IF (ind_ISOPBDNO3O2>0)          RO2 = RO2 + C(ind_ISOPBDNO3O2)
  IF (ind_LISOPACNO3O2>0)         RO2 = RO2 + C(ind_LISOPACNO3O2)
  IF (ind_DB1O2>0)                RO2 = RO2 + C(ind_DB1O2)
  IF (ind_DB2O2>0)                RO2 = RO2 + C(ind_DB2O2)
  IF (ind_LME3FURANO2>0)          RO2 = RO2 + C(ind_LME3FURANO2)
  IF (ind_NO3CH2CO3>0)            RO2 = RO2 + C(ind_NO3CH2CO3)
  IF (ind_CH3COCO3>0)             RO2 = RO2 + C(ind_CH3COCO3)
  IF (ind_ZCO3C23DBCOD>0)         RO2 = RO2 + C(ind_ZCO3C23DBCOD)
  IF (ind_IBUTOLBO2>0)            RO2 = RO2 + C(ind_IBUTOLBO2)
  IF (ind_IPRCO3>0)               RO2 = RO2 + C(ind_IPRCO3)
  IF (ind_IC4H9O2>0)              RO2 = RO2 + C(ind_IC4H9O2)
  ! MBO-related
  IF (ind_LMBOABO2>0)             RO2 = RO2 + C(ind_LMBOABO2)
  IF (ind_IPRHOCO3>0)             RO2 = RO2 + C(ind_IPRHOCO3)
  IF (ind_LNMBOABO2>0)            RO2 = RO2 + C(ind_LNMBOABO2)
  IF (ind_NC4OHCO3>0)             RO2 = RO2 + C(ind_NC4OHCO3)
  ! APINENE-related:
  IF (ind_LAPINABO2>0)            RO2 = RO2 + C(ind_LAPINABO2)
  IF (ind_C96O2>0)                RO2 = RO2 + C(ind_C96O2)
  IF (ind_C97O2>0)                RO2 = RO2 + C(ind_C97O2)
  IF (ind_C98O2>0)                RO2 = RO2 + C(ind_C98O2)
  IF (ind_C85O2>0)                RO2 = RO2 + C(ind_C85O2)
  IF (ind_C86O2>0)                RO2 = RO2 + C(ind_C86O2)
  IF (ind_PINALO2>0)              RO2 = RO2 + C(ind_PINALO2)
  IF (ind_C96CO3>0)               RO2 = RO2 + C(ind_C96CO3)
  IF (ind_C89CO3>0)               RO2 = RO2 + C(ind_C89CO3)
  IF (ind_C85CO3>0)               RO2 = RO2 + C(ind_C85CO3)
  IF (ind_OHMENTHEN6ONEO2>0)      RO2 = RO2 + C(ind_OHMENTHEN6ONEO2)
  IF (ind_C511O2>0)               RO2 = RO2 + C(ind_C511O2)
  IF (ind_C106O2>0)               RO2 = RO2 + C(ind_C106O2)
  IF (ind_CO235C6CO3>0)           RO2 = RO2 + C(ind_CO235C6CO3)
  IF (ind_CHOC3COCO3>0)           RO2 = RO2 + C(ind_CHOC3COCO3)
  IF (ind_CO235C6O2>0)            RO2 = RO2 + C(ind_CO235C6O2)
  IF (ind_C716O2>0)               RO2 = RO2 + C(ind_C716O2)
  IF (ind_C614O2>0)               RO2 = RO2 + C(ind_C614O2)
  IF (ind_HCOCH2CO3>0)            RO2 = RO2 + C(ind_HCOCH2CO3)
  IF (ind_BIACETO2>0)             RO2 = RO2 + C(ind_BIACETO2)
  IF (ind_CO23C4CO3>0)            RO2 = RO2 + C(ind_CO23C4CO3)
  IF (ind_C109O2>0)               RO2 = RO2 + C(ind_C109O2)
  IF (ind_C811CO3>0)              RO2 = RO2 + C(ind_C811CO3)
  IF (ind_C89O2>0)                RO2 = RO2 + C(ind_C89O2)
  IF (ind_C812O2>0)               RO2 = RO2 + C(ind_C812O2)
  IF (ind_C813O2>0)               RO2 = RO2 + C(ind_C813O2)
  IF (ind_C721CO3>0)              RO2 = RO2 + C(ind_C721CO3)
  IF (ind_C721O2>0)               RO2 = RO2 + C(ind_C721O2)
  IF (ind_C722O2>0)               RO2 = RO2 + C(ind_C722O2)
  IF (ind_C44O2>0)                RO2 = RO2 + C(ind_C44O2)
  IF (ind_C512O2>0)               RO2 = RO2 + C(ind_C512O2)
  IF (ind_C513O2>0)               RO2 = RO2 + C(ind_C513O2)
  IF (ind_CHOC3COO2>0)            RO2 = RO2 + C(ind_CHOC3COO2)
  IF (ind_C312COCO3>0)            RO2 = RO2 + C(ind_C312COCO3)
  IF (ind_HOC2H4CO3>0)            RO2 = RO2 + C(ind_HOC2H4CO3)
  IF (ind_LNAPINABO2>0)           RO2 = RO2 + C(ind_LNAPINABO2)
  IF (ind_C810O2>0)               RO2 = RO2 + C(ind_C810O2)
  IF (ind_C514O2>0)               RO2 = RO2 + C(ind_C514O2)
  IF (ind_CHOCOCH2O2>0)           RO2 = RO2 + C(ind_CHOCOCH2O2)
  ! BPINENE-related:
  IF (ind_ROO6R1O2>0)             RO2 = RO2 + C(ind_ROO6R1O2)
  IF (ind_ROO6R3O2>0)             RO2 = RO2 + C(ind_ROO6R3O2)
  IF (ind_RO6R1O2>0)              RO2 = RO2 + C(ind_RO6R1O2)
  IF (ind_RO6R3O2>0)              RO2 = RO2 + C(ind_RO6R3O2)
  IF (ind_BPINAO2>0)              RO2 = RO2 + C(ind_BPINAO2)
  IF (ind_C8BCO2>0)               RO2 = RO2 + C(ind_C8BCO2)
  IF (ind_NOPINDO2>0)             RO2 = RO2 + C(ind_NOPINDO2)
  IF (ind_LNBPINABO2>0)           RO2 = RO2 + C(ind_LNBPINABO2)
  ! aromatics-related:
  IF (ind_BZBIPERO2>0)            RO2 = RO2 + C(ind_BZBIPERO2)
  IF (ind_C6H5CH2O2>0)            RO2 = RO2 + C(ind_C6H5CH2O2)
  IF (ind_TLBIPERO2>0)            RO2 = RO2 + C(ind_TLBIPERO2)
  IF (ind_BZEMUCCO3>0)            RO2 = RO2 + C(ind_BZEMUCCO3)
  IF (ind_BZEMUCO2>0)             RO2 = RO2 + C(ind_BZEMUCO2)
  IF (ind_C5DIALO2>0)             RO2 = RO2 + C(ind_C5DIALO2)
  IF (ind_NPHENO2>0)              RO2 = RO2 + C(ind_NPHENO2)
  IF (ind_PHENO2>0)               RO2 = RO2 + C(ind_PHENO2)
  IF (ind_CRESO2>0)               RO2 = RO2 + C(ind_CRESO2)
  IF (ind_NCRESO2>0)              RO2 = RO2 + C(ind_NCRESO2)
  IF (ind_TLEMUCCO3>0)            RO2 = RO2 + C(ind_TLEMUCCO3)
  IF (ind_TLEMUCO2>0)             RO2 = RO2 + C(ind_TLEMUCO2)
  IF (ind_C615CO2O2>0)            RO2 = RO2 + C(ind_C615CO2O2)
  IF (ind_MALDIALCO3>0)           RO2 = RO2 + C(ind_MALDIALCO3)
  IF (ind_EPXDLCO3>0)             RO2 = RO2 + C(ind_EPXDLCO3)
  IF (ind_C3DIALO2>0)             RO2 = RO2 + C(ind_C3DIALO2)
  IF (ind_MALDIALO2>0)            RO2 = RO2 + C(ind_MALDIALO2)
  IF (ind_C6H5O2>0)               RO2 = RO2 + C(ind_C6H5O2)
  IF (ind_C6H5CO3>0)              RO2 = RO2 + C(ind_C6H5CO3)
  IF (ind_OXYL1O2>0)              RO2 = RO2 + C(ind_OXYL1O2)
  IF (ind_C5CO14O2>0)             RO2 = RO2 + C(ind_C5CO14O2)
  IF (ind_NBZFUO2>0)              RO2 = RO2 + C(ind_NBZFUO2)
  IF (ind_BZFUO2>0)               RO2 = RO2 + C(ind_BZFUO2)
  IF (ind_HCOCOHCO3>0)            RO2 = RO2 + C(ind_HCOCOHCO3)
  IF (ind_CATEC1O2>0)             RO2 = RO2 + C(ind_CATEC1O2)
  IF (ind_MCATEC1O2>0)            RO2 = RO2 + C(ind_MCATEC1O2)
  IF (ind_C5DICARBO2>0)           RO2 = RO2 + C(ind_C5DICARBO2)
  IF (ind_NTLFUO2>0)              RO2 = RO2 + C(ind_NTLFUO2)
  IF (ind_TLFUO2>0)               RO2 = RO2 + C(ind_TLFUO2)
  IF (ind_NPHEN1O2>0)             RO2 = RO2 + C(ind_NPHEN1O2)
  IF (ind_NNCATECO2>0)            RO2 = RO2 + C(ind_NNCATECO2)
  IF (ind_NCATECO2>0)             RO2 = RO2 + C(ind_NCATECO2)
  IF (ind_NBZQO2>0)               RO2 = RO2 + C(ind_NBZQO2)
  IF (ind_PBZQO2>0)               RO2 = RO2 + C(ind_PBZQO2)
  IF (ind_NPTLQO2>0)              RO2 = RO2 + C(ind_NPTLQO2)
  IF (ind_PTLQO2>0)               RO2 = RO2 + C(ind_PTLQO2)
  IF (ind_NCRES1O2>0)             RO2 = RO2 + C(ind_NCRES1O2)
  IF (ind_MNNCATECO2>0)           RO2 = RO2 + C(ind_MNNCATECO2)
  IF (ind_MNCATECO2>0)            RO2 = RO2 + C(ind_MNCATECO2)
  IF (ind_MECOACETO2>0)           RO2 = RO2 + C(ind_MECOACETO2)
  IF (ind_CO2H3CO3>0)             RO2 = RO2 + C(ind_CO2H3CO3)
  IF (ind_MALANHYO2>0)            RO2 = RO2 + C(ind_MALANHYO2)
  IF (ind_NDNPHENO2>0)            RO2 = RO2 + C(ind_NDNPHENO2)
  IF (ind_DNPHENO2>0)             RO2 = RO2 + C(ind_DNPHENO2)
  IF (ind_NDNCRESO2>0)            RO2 = RO2 + C(ind_NDNCRESO2)
  IF (ind_DNCRESO2>0)             RO2 = RO2 + C(ind_DNCRESO2)
  IF (ind_C5CO2OHCO3>0)           RO2 = RO2 + C(ind_C5CO2OHCO3)
  IF (ind_C6CO2OHCO3>0)           RO2 = RO2 + C(ind_C6CO2OHCO3)
  IF (ind_MMALANHYO2>0)           RO2 = RO2 + C(ind_MMALANHYO2)
  IF (ind_ACCOMECO3>0)            RO2 = RO2 + C(ind_ACCOMECO3)
  IF (ind_C4CO2DBCO3>0)           RO2 = RO2 + C(ind_C4CO2DBCO3)
  IF (ind_C5CO2DBCO3>0)           RO2 = RO2 + C(ind_C5CO2DBCO3)
  IF (ind_NSTYRENO2>0)            RO2 = RO2 + C(ind_NSTYRENO2)
  IF (ind_STYRENO2>0)             RO2 = RO2 + C(ind_STYRENO2)
  ! pseudo first order rate constants    ! occurence
  k1_RO2RCO3      = RO2 * k_RO2RCO3      ! 51
  k1_RO2pRO2      = RO2 * k_RO2pRO2      ! 5
  k1_RO2sRO2      = RO2 * k_RO2sRO2      ! 11+1
  k1_RO2tRO2      = RO2 * k_RO2tRO2      ! 13+1
  k1_RO2pORO2     = RO2 * k_RO2pORO2     ! 11+2
  k1_RO2sORO2     = RO2 * k_RO2sORO2     ! 33+2
  k1_RO2tORO2     = RO2 * k_RO2tORO2     ! 17
  k1_RO2LISOPACO2 = RO2 * k_RO2LISOPACO2 ! 3
  k1_RO2ISOPBO2   = RO2 * k_RO2ISOPBO2   ! 1
  k1_RO2ISOPDO2   = RO2 * k_RO2ISOPDO2   ! 13

! End INLINED RCONST

  RCONST(1) = (3.3E-11*EXP(55./temp))
  RCONST(2) = (6.0E-34*((temp/300.)**(-2.4))*cair)
  RCONST(3) = (k_3rd(temp,cair,4.4E-32,1.3,7.5E-11,-0.2,0.6))
  RCONST(4) = (1.7E-12*EXP(-940./temp))
  RCONST(5) = (2.8E-12*EXP(-1800./temp))
  RCONST(6) = (1.E-14*EXP(-490./temp))
  RCONST(7) = (4.8E-11*EXP(250./temp))
  RCONST(8) = (k_HO2_HO2)
  RCONST(9) = (1.63E-10*EXP(60./temp))
! RCONST(10) = constant rate coefficient
  RCONST(11) = (6.521E-26*temp*EXP(1851.09/temp)*EXP(-5.10485E-3*temp))
! RCONST(12) = constant rate coefficient
  RCONST(13) = (2.15E-11*EXP(110./temp))
  RCONST(14) = (3.0E-12*EXP(-1500./temp))
  RCONST(15) = (1.2E-13*EXP(-2450./temp))
  RCONST(16) = (1.5E-11*EXP(170./temp))
  RCONST(17) = (k_NO3_NO2)
  RCONST(18) = (k_NO3_NO2/(5.8E-27*EXP(10840./temp)))
  RCONST(19) = (k_3rd(temp,cair,7.0E-31,2.6,3.6E-11,0.1,0.6))
  RCONST(20) = (3.3E-12*EXP(270./temp))
  RCONST(21) = (k_3rd(temp,cair,1.8E-30,3.0,2.8E-11,0.,0.6))
  RCONST(22) = (k_NO2_HO2)
! RCONST(23) = constant rate coefficient
  RCONST(24) = (1.8E-11*EXP(-390./temp))
  RCONST(25) = (k_HNO3_OH)
  RCONST(26) = (k_NO2_HO2/(2.1E-27*EXP(10900./temp)))
  RCONST(27) = (1.3E-12*EXP(380./temp))
  RCONST(28) = (1.7E-12*EXP(-710./temp))
  RCONST(29) = (4.3E-12*EXP(-930./temp))
  RCONST(30) = (4.8E-07*EXP(-628./temp)*temp**(-1.32))
  RCONST(31) = (9.4E-09*EXP(-356./temp)*temp**(-1.12))
  RCONST(32) = (1.92E-12*((temp/298.)**(-1.5)))
  RCONST(33) = (1.41E-11*((temp/298.)**(-1.5)))
  RCONST(34) = (1.2E-11*((temp/298.)**(-2.0)))
  RCONST(35) = (0.8E-11*((temp/298.)**(-2.0)))
! RCONST(36) = constant rate coefficient
! RCONST(37) = constant rate coefficient
  RCONST(38) = (8.0E-11*EXP(-500./temp))
  RCONST(39) = (1.66E-12*EXP(-1500./temp))
  RCONST(40) = (1.0E-12*EXP(-1000./temp))
! RCONST(41) = constant rate coefficient
  RCONST(42) = (4.13E-11*EXP(-2138./temp))
  RCONST(43) = (3.65E-14*EXP(-4600./temp))
  RCONST(44) = (1.85E-20*EXP(2.82*LOG(temp)-987./temp))
  RCONST(45) = (6.38E-18*(temp**2)*EXP(144./temp))
  RCONST(46) = (3.8E-13*EXP(780./temp)/(1.+1./498.*EXP(1160./temp)))
  RCONST(47) = (3.8E-13*EXP(780./temp)/(1.+498.*EXP(-1160./temp)))
  RCONST(48) = (2.3E-12*EXP(360./temp)*(1.-beta_CH3NO3))
  RCONST(49) = (2.3E-12*EXP(360./temp)*beta_CH3NO3)
! RCONST(50) = constant rate coefficient
  RCONST(51) = (7.4E-13*EXP(-520./temp)*RO2*2.)
  RCONST(52) = ((k_CH3O2-7.4E-13*EXP(-520./temp))*RO2*2.)
  RCONST(53) = (k_CH3OOH_OH)
  RCONST(54) = (9.52E-18*EXP(2.03*LOG(temp)+636./temp))
  RCONST(55) = (3.4E-13*EXP(-1900./temp))
  RCONST(56) = ((1.57E-13+cair*3.54E-33))
  RCONST(57) = (2.94E-14*exp(786./temp)+9.85E-13*EXP(-1036./temp))
  RCONST(58) = (k_NO2_CH3O2)
  RCONST(59) = (k_NO2_CH3O2/(9.5E-29*EXP(11234./temp)))
! RCONST(60) = constant rate coefficient
  RCONST(61) = (4.0E-13*EXP(-845./temp))
  RCONST(62) = (1.3E-14*exp(-663./temp)*c(ind_O2))
  RCONST(63) = (k_3rd_iupac(temp,cair,8.1E-29,4.5,2.1E-11,0.,0.44))
  RCONST(64) = (9.6E-12*EXP(-1150./temp))
  RCONST(65) = (k_3rd_iupac(temp,cair,2.6E-29,2.8,3.3E-11,0.6,REAL(EXP(-temp/900.),SP)))
  RCONST(66) = (2.3E-12*(temp/300.)**0.7)
  RCONST(67) = (2.9E-16*exp(-1000./temp))
  RCONST(68) = (1.E-10*exp(-1764./temp))
  RCONST(69) = (9.7E-15*EXP(625./temp))
  RCONST(70) = (2.4E12*EXP(-7000./temp))
  RCONST(71) = (5.6E-15*EXP(2300./temp))
  RCONST(72) = (0.7275*2.3E-12*EXP(360./temp))
! RCONST(73) = constant rate coefficient
  RCONST(74) = ((k_CH3O2*5.5E-12)**0.5*RO2*2.)
  RCONST(75) = ((k_CH3O2*5.7E-14*EXP(750./temp))**0.5*RO2*2.)
  RCONST(76) = (0.6*k_CH3OOH_OH)
  RCONST(77) = (k_rohro+k_s*f_sooh*f_soh)
  RCONST(78) = (2.*k_rohro+k_s*f_soh*f_soh)
! RCONST(79) = constant rate coefficient
  RCONST(80) = (1.124E+14*EXP(-10000/temp))
  RCONST(81) = (k_CH2OO_NO2*3.6E-6)
! RCONST(82) = constant rate coefficient
! RCONST(83) = constant rate coefficient
  RCONST(84) = (k_CH2OO_NO2)
! RCONST(85) = constant rate coefficient
! RCONST(86) = constant rate coefficient
! RCONST(87) = constant rate coefficient
! RCONST(88) = constant rate coefficient
! RCONST(89) = constant rate coefficient
! RCONST(90) = constant rate coefficient
! RCONST(91) = constant rate coefficient
! RCONST(92) = constant rate coefficient
  RCONST(93) = (k_NO2_CH3O2)
  RCONST(94) = (k_NO2_CH3O2/(9.5E-29*EXP(11234./temp)))
  RCONST(95) = (9.50E-13*EXP(-650./temp)*f_soh)
  RCONST(96) = (k_3rd_iupac(temp,cair,7.0E-31,3.,1.8E-12,-1.1,0.33))
  RCONST(97) = (5.1E-12*exp(-210./temp))
! RCONST(98) = constant rate coefficient
! RCONST(99) = constant rate coefficient
! RCONST(100) = constant rate coefficient
! RCONST(101) = constant rate coefficient
  RCONST(102) = (3.4E-11*EXP(-1600./temp))
  RCONST(103) = (KDEC)
  RCONST(104) = (k_3rd(temp,cair,4.28E-33,1.0,REAL(4.25E-13*EXP(-1150./temp),SP),1.0,0.8))
  RCONST(105) = (1.08E-10*EXP(105./temp)*0.15*EXP(200/temp))
  RCONST(106) = (1.08E-10*EXP(105./temp)*0.68/2.)
  RCONST(107) = (1.08E-10*EXP(105./temp)*(1.-(0.68/2.+0.15*EXP(200/temp))))
  RCONST(108) = (1.0E-11*EXP(-4000./temp))
  RCONST(109) = (1.2E-11*EXP(210./temp)*0.75)
  RCONST(110) = (1.2E-11*EXP(210./temp)*0.25)
! RCONST(111) = constant rate coefficient
  RCONST(112) = (jx(ip_O2))
  RCONST(113) = (jx(ip_O1D))
  RCONST(114) = (jx(ip_O3P))
  RCONST(115) = (jx(ip_H2O2))
  RCONST(116) = (jx(ip_NO2))
  RCONST(117) = (jx(ip_NO2O))
  RCONST(118) = (jx(ip_NOO2))
  RCONST(119) = (jx(ip_N2O5))
  RCONST(120) = (jx(ip_HONO))
  RCONST(121) = (jx(ip_HNO3))
  RCONST(122) = (jx(ip_HNO4))
  RCONST(123) = (jx(ip_CH3OOH))
  RCONST(124) = (jx(ip_COH2))
  RCONST(125) = (jx(ip_CHOH))
  RCONST(126) = (jx(ip_CH3ONO))
  RCONST(127) = (jx(ip_CH3NO3))
  RCONST(128) = (jx(ip_CH3O2NO2))
  RCONST(129) = (jx(ip_CH3OOH))
  RCONST(130) = (jx(ip_CH3O2))
  RCONST(131) = (jx(ip_HCOOH))
  RCONST(132) = (jx(ip_CH3O2NO2))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE messy_mecca_kpp_Global

  RCONST(112) = (jx(ip_O2))
  RCONST(113) = (jx(ip_O1D))
  RCONST(114) = (jx(ip_O3P))
  RCONST(115) = (jx(ip_H2O2))
  RCONST(116) = (jx(ip_NO2))
  RCONST(117) = (jx(ip_NO2O))
  RCONST(118) = (jx(ip_NOO2))
  RCONST(119) = (jx(ip_N2O5))
  RCONST(120) = (jx(ip_HONO))
  RCONST(121) = (jx(ip_HNO3))
  RCONST(122) = (jx(ip_HNO4))
  RCONST(123) = (jx(ip_CH3OOH))
  RCONST(124) = (jx(ip_COH2))
  RCONST(125) = (jx(ip_CHOH))
  RCONST(126) = (jx(ip_CH3ONO))
  RCONST(127) = (jx(ip_CH3NO3))
  RCONST(128) = (jx(ip_CH3O2NO2))
  RCONST(129) = (jx(ip_CH3OOH))
  RCONST(130) = (jx(ip_CH3O2))
  RCONST(131) = (jx(ip_HCOOH))
  RCONST(132) = (jx(ip_CH3O2NO2))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Rates

