! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Global Data Module File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Global.f90
! Time                 : Tue Aug  7 17:33:28 2018
! Working directory    : /home/sander/e2/messy_d2.53.0.24_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Global

  USE messy_cmn_photol_mem ! IP_MAX, ip_*, jname
  USE messy_mecca_kpp_Parameters, ONLY: dp, NSPEC, NVAR, NFIX, NREACT
  PUBLIC
  SAVE


! Declaration of global variables

! C - Concentration of all species
  REAL(kind=dp) :: C(NSPEC)
! VAR - Concentrations of variable species (global)
  REAL(kind=dp) :: VAR(NVAR)
! FIX - Concentrations of fixed species (global)
  REAL(kind=dp) :: FIX(NFIX)
! VAR, FIX are chunks of array C
      EQUIVALENCE( C(1),VAR(1) )
      EQUIVALENCE( C(47),FIX(1) )
! RCONST - Rate constants (global)
  REAL(kind=dp) :: RCONST(NREACT)
! TIME - Current integration time
  REAL(kind=dp) :: TIME
! SUN - Sunlight intensity between [0,1]
  REAL(kind=dp) :: SUN
! TEMP - Temperature
  REAL(kind=dp) :: TEMP
! TSTART - Integration start time
  REAL(kind=dp) :: TSTART
! TEND - Integration end time
  REAL(kind=dp) :: TEND
! DT - Integration step
  REAL(kind=dp) :: DT
! ATOL - Absolute tolerance
  REAL(kind=dp) :: ATOL(NVAR)
! RTOL - Relative tolerance
  REAL(kind=dp) :: RTOL(NVAR)
! STEPMIN - Lower bound for integration step
  REAL(kind=dp) :: STEPMIN
! STEPMAX - Upper bound for integration step
  REAL(kind=dp) :: STEPMAX
! CFACTOR - Conversion factor for concentration units
  REAL(kind=dp) :: CFACTOR

! INLINED global variable declarations

  ! MECCA info from xmecca:
  CHARACTER(LEN=*), PUBLIC, PARAMETER :: &
    timestamp            = 'xmecca was run on 2018-08-07 at 17:33:27 by sander on machine fluorine', &
    batchfile            = 'simple', &
    gas_spc_file         = '-rw------- 1 sander sander 76122 Jul 23 11:37 gas.spc', &
    aqueous_spc_file     = '-rw------- 1 sander sander 10517 Jun 27 13:34 aqueous.spc', &
    gas_eqn_file         = '-rw------- 1 sander sander 316670 Jul 23 11:40 gas.eqn', &
    aqueous_eqn_file     = '-rw------- 1 sander sander 61462 Aug  7 17:28 aqueous.eqn', &
    gas_spc_file_sum     = '51385    75', &
    aqueous_spc_file_sum = '51484    11', &
    gas_eqn_file_sum     = '42858   310', &
    aqueous_eqn_file_sum = '15670    61', &
    rplfile              = '', &
    wanted               = 'Tr && G && !C && !S && !Cl && !Br && !I && !Hg', &
    diagtracfile         = '', &
    rxnrates             = 'n', &
    tag                  = 'n'
  LOGICAL, PARAMETER :: REQ_MCFCT = .FALSE.

  ! from xmecca for aerosol:
  INTEGER, PARAMETER, PUBLIC :: APN = 1
  ! from aerosol.awk:
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_O2_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_O3_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_OH_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HO2_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_H2O_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_H2O2_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NH3_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NO_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NO2_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NO3_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HONO_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HNO3_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HNO4_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3OH_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HCOOH_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HCHO_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3O2_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3OOH_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CO2_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3CO2H_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_PAN_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3CHO_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3COCH3_a  = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Cl_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Cl2_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HCl_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HOCl_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Br_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Br2_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HBr_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HOBr_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_BrCl_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_I2_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_IO_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HOI_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_ICl_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_IBr_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_SO2_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_H2SO4_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_DMS_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_DMSO_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Hg_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgO_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgOHOH_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgOHCl_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgCl2_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgBr2_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgSO3_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_ClHgBr_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_BrHgOBr_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_ClHgOBr_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOH3_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeCl3_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeF3_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_O2m_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_OHm_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HO2m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_O2mm_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Hp_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NH4p_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NO2m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NO3m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_NO4m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CO3m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HCOOm_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HCO3m_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3COOm_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Clm_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Cl2m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_ClOm_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_ClOHm_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Brm_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Br2m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_BrOm_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_BrOHm_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_BrCl2m_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Br2Clm_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Im_a        = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_IO2m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_IO3m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_ICl2m_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_IBr2m_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_SO3m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_SO3mm_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_SO4m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_SO4mm_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_SO5m_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HSO3m_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HSO4m_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HSO5m_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH3SO3m_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_CH2OHSO3m_a = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Hgp_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Hgpp_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgOHp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgClp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgBrp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_HgSO32mm_a  = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Fepp_a      = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOpp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOHp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOH2p_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeClp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Feppp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeHOpp_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeHO2pp_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOHpp_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOH4m_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOHHO2p_a  = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeClpp_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeCl2p_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeBrpp_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeBr2p_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeFpp_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeF2p_a     = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeSO3p_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeSO4p_a    = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeSO42m_a   = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_FeOH2Fepppp_a = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_D1O_a       = 0
  INTEGER, PUBLIC, DIMENSION(APN) :: ind_Nap_a       = 0

  ! variable declarations from gas.eqn:
  ! --------------------------------------------------------------------------
  ! inorganic and C1 chemistry:
  REAL :: k_HO2_HO2, k_NO3_NO2, k_NO2_HO2, k_HNO3_OH, k_CH3OOH_OH, &
          k_ClO_ClO, k_BrO_NO2, k_I_NO2, k_DMS_OH, k_CH2OO_SO2
  REAL :: k_O3s ! used in some *.rpl files
  ! new methane chemistry:
  REAL :: beta_null_CH3NO3, beta_inf_CH3NO3, beta_CH3NO3, &
          k_NO2_CH3O2, k_CH2OO_NO2, beta_C2H5NO3, k_C6H5O2_NO2
  ! --------------------------------------------------------------------------
  ! only for mim1, see mim1.rpl:
  REAL :: k_PrO2_HO2, k_PrO2_NO, k_PrO2_CH3O2
  REAL :: k0_NO_HO2, k1d_NO_HO2, k1w_NO_HO2, k2d_NO_HO2, k2w_NO_HO2, &
          alpha_NO_HO2, beta_NO_HO2, G7402a_yield
  ! end of mim1 block
  ! --------------------------------------------------------------------------
  ! organic chemistry (MIM, MAM, MOM...):
  REAL :: k_CH3CO3_NO2, k_PAN_M
  REAL(dp) :: KRO2NO, KAPHO2, KAPNO, KRO2NO3, KNO3AL
  ! maximum no. of C atoms the rate coefficients are calculated for:
  INTEGER,  PARAMETER :: MAXnC = 12
  INTEGER :: nCi ! nC index runner
  ! carbon nos. to calculate the lookup table for RO2+HO2 rate coeffs., etc.:
  INTEGER,  PARAMETER :: nC(MAXnC) = (/ (nCi,nCi=1,MAXnC) /)
  REAL(dp) :: KRO2HO2(MAXnC)
  REAL :: KHSB, KHSD, K16HS, K16HSZ14, K16HSZ41, K15HSDHB, K14HSAL, &
          K15HS24VYNAL, K15HS42VYNAL, KHYDEC
  REAL :: J_IC3H7NO3, J_ACETOL, J_HPALD, J_KETENE
  REAL(dp) :: RO2      ! sum of peroxy radicals
  REAL(dp) :: k_CH3O2   ! CH3O2 self-reaction
  REAL(dp) :: k_RO2RCO3, k_RO2pRO2, k_RO2sRO2, k_RO2tRO2, &
              k_RO2pORO2, k_RO2sORO2, k_RO2tORO2, &
              k_RO2LISOPACO2, k_RO2ISOPBO2, k_RO2ISOPDO2
  REAL(dp) :: k_CH2CHOH_OH_HCOOH, k_CH2CHOH_OH_ALD, k_CH2CHOH_HCOOH, k_ALD_HCOOH
  REAL(dp) :: k1_RO2RCO3, k1_RO2pRO2, k1_RO2sRO2, k1_RO2tRO2, &
              k1_RO2pORO2, k1_RO2sORO2, k1_RO2tORO2, &
              k1_RO2LISOPACO2, k1_RO2ISOPBO2, k1_RO2ISOPDO2
  REAL(dp), PARAMETER :: k_C6H5O_NO2  = 2.08E-12 ! ref3172
  REAL(dp), PARAMETER :: k_C6H5O_O3   = 2.86E-13 ! ref3171
  ! SAR for OH reactions (ref3030 with introduction of temperature dependency)
  ! parameters for the SAR on H-abstraction OH:
  REAL(dp) :: k_p, k_s, k_t, k_rohro, k_co2h
  REAL(dp), PARAMETER :: &
    f_soh = 3.44, f_toh = 2.68, &
    f_sooh = 7.,  f_tooh = 7., & ! from Wang and Chen, ref3196
    f_ono2 = 0.04 , f_ch2ono2 = 0.2, &
    f_cpan= .25, f_allyl = 3.6, f_alk= 1.23, &
    f_cho = 0.55, f_co2h = 1.67, f_co = 0.73, &
    f_o = 8.15, f_pch2oh = 1.29, f_tch2oh = 0.53
  ! parameters for the SAR on OH-addtion to alkenes
  ! Note for ach2ooh calculated
  ! assuming RO2 distribution in ref3159
  ! B, E, D, F, AC are .41, .02, .22, .05, .30 respectively
  REAL(dp) :: k_adp, k_ads, k_adt
  REAL(dp), PARAMETER :: &
    k_adsecprim = 3.0E-11, k_adtertprim = 5.7E-11 &
   , a_pan = 0.56      , a_cho = 0.31   , a_coch3 = 0.76 &
   , a_ch2ono2 = 0.64  , a_ch2oh = 1.7  , a_ch2ooh = 1.7 &
   , a_coh = 2.2       , a_cooh = 2.2   , a_co2h = 0.25
  REAL(dp), PARAMETER :: KDEC = 1.E6
  ! Branching ratios for RO2 + HO2 reactions
  ! CH3CO3 + HO2 has unique branching ratios (see reaction)
  ! beta-hydroxy acyl peroxy radicals, e.g. HOCH2CO3
  ! (GroC, PhD Thesis, ref3195)
  REAL(dp), PARAMETER :: rco3_oh  = 0.69, rco3_o3  = 0.10, rco3_ooh = 0.21
  ! beta-keto peroxy radicals equal or bigger than CH3COCHO2CH3 (Dillon and Crowley, ref3192)
  REAL(dp), PARAMETER :: rcoch2o2_oh  = 0.15, rcoch2o2_ooh = 0.85
  REAL(dp), PARAMETER :: rchohch2o2_oh = 0.10 ! derived from Liu ref3193 for ISOPBO2 and ISOPDO2. Consistent with exp. data by C. GroC (MPIC)
  REAL(dp), PARAMETER :: rch2och2o2_oh  = 0.4 ! ref3175 for CH3OCH2O2
  REAL(dp), PARAMETER :: rbipero2_oh = 0.40 ! ref3188 for toluene
  REAL(dp), PARAMETER :: fhpal = 0.5 ! HPALD-yield after 1,6-H-shift
  ! --------------------------------------------------------------------------
  ! Parameters included for acid-base equilibria calculation
  ! used to enable the double use of the aqueous.eqn for liquid
  ! and aerosol phase.
  REAL(dp), PARAMETER :: &
    testfac_HO2   = 1.e5_dp, testfac_HONO   = 1.e5_dp, &
    testfac_HNO3  = 1.e7_dp, testfac_HNO4   = 1.e5_dp, &
    testfac_HCOOH = 1.e5_dp, testfac_SO2    = 1.e9_dp, &
    testfac_HSO3m = 1.e9_dp, testfac_HSO4m  = 1.e7_dp, &
    testfac_NH3   = 1.e7_dp, testfac_H2O    = 1.e9_dp, &
    testfac_CO2   = 1.e5_dp, testfac_HCl    = 1.e2_dp, &
    testfac_HBr   = 1.e6_dp,                           &
    testfac_HOCl  = 1.e2_dp, testfac_HOBr   = 1.e2_dp, &
    testfac_ICl   = 1.e2_dp, testfac_IBr    = 1.e2_dp, &
    testfac_IClBr = 1.e2_dp, testfac_H2SO4  = 1.e7_dp

  ! from xmecca:
  LOGICAL, PARAMETER :: REQ_HET     = .FALSE.
  LOGICAL, PARAMETER :: REQ_PHOTRAT = .TRUE.
  LOGICAL, PARAMETER :: REQ_AEROSOL = .FALSE.

  ! from xmecca:
  INTEGER, PARAMETER, PUBLIC :: MAX_MCEXP = 1
!KPPPP_DIRECTIVE vector variable definition start
  REAL :: mcexp(MAX_MCEXP) ! dummy Monte-Carlo factor
!KPPPP_DIRECTIVE vector variable definition end

  ! iht_ = index of troposheric heterogeneous reactions
  INTEGER, PARAMETER, PUBLIC :: &
    iht_N2O5      =  1, iht_HNO3      =  2, iht_Hg      =  3, iht_RGM       = 4
  INTEGER, PARAMETER, PUBLIC :: IHT_MAX = 4
  ! ihs_ = index of stratospheric heterogeneous reactions
  ! (must be the same as in messy_msbm.f90!)
  INTEGER, PARAMETER :: &
    ihs_N2O5_H2O  =  1, ihs_HOCl_HCl  =  2, ihs_ClNO3_HCl =  3, &
    ihs_ClNO3_H2O =  4, ihs_N2O5_HCl  =  5, ihs_ClNO3_HBr =  6, &
    ihs_BrNO3_HCl =  7, ihs_HOCl_HBr  =  8, ihs_HOBr_HCl  =  9, &
    ihs_HOBr_HBr  = 10, ihs_BrNO3_H2O = 11, ihs_Hg        = 12, &
    ihs_RGM       = 13
  INTEGER, PARAMETER, PUBLIC :: IHS_MAX = 13
!KPPPP_DIRECTIVE vector variable definition start
  ! IMPORTANT NOTES ABOUT TEMP, PRESS, AND CAIR:
  ! - The KPP variable "temp" is already defined automatically by KPP in
  !   messy_mecca_kpp_global.f90. The KPP variables "press" and "cair" are
  !   defined here.
  ! - The 3 variables temp, press, and cair are only used inside KPP.
  !   They are different from the variables with the same names in the base
  !   model (as used in the SMIL files *_si.f90 and *_box.f90)
  ! - Data transfer between the SMIL and the KPP variables is done via the
  !   fill subroutines in messy_mecca_kpp.f90:
  !   - fill_temp transfers temperature
  !   - fill_press transfers pressure
  !   - fill_cair transfers cair (this is redundant because cair could be
  !     calculated from temp and press; nevertheless, redundant transfer to
  !     KPP is preferred to avoid potential numerical differences when
  !     recalculating cair inside KPP)
  REAL(dp) :: cair      ! c(air) (wet) [mcl/cm^3]
  REAL(dp) :: press     ! pressure [Pa]
  REAL(dp) :: temp_ion  ! ion temperature [K]
  REAL(dp) :: temp_elec ! electron temperature [K]
  REAL(dp) :: xaer(APN)
  REAL(dp) :: cvfac(APN)    ! unit conversion factor
  REAL(dp) :: lwc(APN)      ! liquid water content
  REAL(dp) :: k_exf(APN,NSPEC) = 0.
  REAL(dp) :: k_exb(APN,NSPEC) = 0.
  REAL(dp) :: k_exf_N2O5(APN)  = 0.
  REAL(dp) :: k_exf_ClNO3(APN) = 0.
  REAL(dp) :: k_exf_BrNO3(APN) = 0.
  REAL(dp) :: jx(IP_MAX) = 0.
  REAL(dp) :: khet_Tr(IHT_MAX) = 0.
  REAL(dp) :: khet_St(IHS_MAX) = 0.
!KPPPP_DIRECTIVE vector variable definition end
  INTEGER, PUBLIC  :: xnom7sulf = 1 ! = 1-xm7sulf

  ! KPP info from xmecca (via integr.kpp):
  CHARACTER(LEN=*), PUBLIC, PARAMETER :: &
    mecca_spc_file     = '-rw------- 1 sander sander 88838 Aug  7 17:33 mecca.spc', &
    mecca_eqn_file     = '-rw------- 1 sander sander 55291 Aug  7 17:33 mecca.eqn', &
    mecca_spc_file_sum = '22474    87', &
    mecca_eqn_file_sum = '64028    54', &
    kppoption          = 'k', &
    KPP_HOME           = '/home/sander/e2/messy_d2.53.0.24_rs/messy/tools/kpp', &
    KPP_version        = '2.2.3_rs3', &
    integr             = 'rosenbrock_posdef'

! INLINED global variable declarations


END MODULE messy_mecca_kpp_Global

