! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Function.f90
! Time                 : Tue Aug  7 17:33:28 2018
! Working directory    : /home/sander/e2/messy_d2.53.0.24_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Function

  USE messy_mecca_kpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(22)*F(1)
  A(2) = RCT(2)*V(35)*F(1)
  A(3) = RCT(3)*V(11)*F(1)
  A(4) = RCT(4)*V(42)*V(46)
  A(5) = RCT(5)*V(15)*V(42)
  A(6) = RCT(6)*V(44)*V(46)
  A(7) = RCT(7)*V(42)*V(44)
  A(8) = RCT(8)*V(44)*V(44)
  A(9) = RCT(9)*V(22)*V(37)
  A(10) = 1.8e-12*V(8)*V(42)
  A(11) = RCT(11)*V(37)*V(37)
  A(12) = V(9)
  A(13) = RCT(13)*V(22)*F(2)
  A(14) = RCT(14)*V(39)*V(46)
  A(15) = RCT(15)*V(41)*V(46)
  A(16) = RCT(16)*V(39)*V(40)
  A(17) = RCT(17)*V(40)*V(41)
  A(18) = RCT(18)*V(6)
  A(19) = RCT(19)*V(39)*V(42)
  A(20) = RCT(20)*V(39)*V(44)
  A(21) = RCT(21)*V(41)*V(42)
  A(22) = RCT(22)*V(41)*V(44)
  A(23) = 3.5e-12*V(40)*V(44)
  A(24) = RCT(24)*V(21)*V(42)
  A(25) = RCT(25)*V(19)*V(42)
  A(26) = RCT(26)*V(16)
  A(27) = RCT(27)*V(16)*V(42)
  A(28) = RCT(28)*V(4)*V(42)
  A(29) = RCT(29)*V(30)*V(46)
  A(30) = RCT(30)*V(30)*V(44)
  A(31) = RCT(31)*V(30)*V(44)
  A(32) = RCT(32)*V(30)*V(39)
  A(33) = RCT(33)*V(30)*V(39)
  A(34) = RCT(34)*V(30)*V(41)
  A(35) = RCT(35)*V(30)*V(41)
  A(36) = 1.2e-14*V(25)*V(46)
  A(37) = 1300*V(25)
  A(38) = RCT(38)*V(29)*V(42)
  A(39) = RCT(39)*V(14)*V(29)
  A(40) = RCT(40)*V(29)*V(41)
  A(41) = 1.66e-12*V(14)*V(42)
  A(42) = RCT(42)*V(12)*V(42)
  A(43) = RCT(43)*V(29)*F(1)
  A(44) = RCT(44)*V(5)*V(42)
  A(45) = RCT(45)*V(20)*V(42)
  A(46) = RCT(46)*V(38)*V(44)
  A(47) = RCT(47)*V(38)*V(44)
  A(48) = RCT(48)*V(38)*V(39)
  A(49) = RCT(49)*V(38)*V(39)
  A(50) = 1.2e-12*V(38)*V(40)
  A(51) = RCT(51)*V(38)
  A(52) = RCT(52)*V(38)
  A(53) = RCT(53)*V(17)*V(42)
  A(54) = RCT(54)*V(42)*V(45)
  A(55) = RCT(55)*V(40)*V(45)
  A(56) = RCT(56)*V(31)*V(42)
  A(57) = RCT(57)*V(33)*V(42)
  A(58) = RCT(58)*V(38)*V(41)
  A(59) = RCT(59)*V(23)
  A(60) = 3e-14*V(23)*V(42)
  A(61) = RCT(61)*V(28)*V(42)
  A(62) = RCT(62)*V(36)
  A(63) = RCT(63)*V(36)*V(41)
  A(64) = RCT(64)*V(36)*V(41)
  A(65) = RCT(65)*V(36)*V(39)
  A(66) = RCT(66)*V(36)*V(39)
  A(67) = RCT(67)*V(38)*V(46)
  A(68) = RCT(68)*V(18)*V(42)
  A(69) = RCT(69)*V(44)*V(45)
  A(70) = RCT(70)*V(34)
  A(71) = RCT(71)*V(34)*V(44)
  A(72) = RCT(72)*V(34)*V(39)
  A(73) = 1.2e-12*V(34)*V(40)
  A(74) = RCT(74)*V(34)
  A(75) = RCT(75)*V(34)
  A(76) = RCT(76)*V(27)*V(42)
  A(77) = RCT(77)*V(27)*V(42)
  A(78) = RCT(78)*V(10)*V(42)
  A(79) = 1.4e-10*V(38)*V(42)
  A(80) = RCT(80)*V(43)
  A(81) = RCT(81)*V(37)*V(43)
  A(82) = 5.2e-12*V(9)*V(43)
  A(83) = 6e-14*V(39)*V(43)
  A(84) = RCT(84)*V(41)*V(43)
  A(85) = 3.6e-14*V(31)*V(43)
  A(86) = 1e-10*V(33)*V(43)
  A(87) = 1.7e-12*V(43)*V(45)
  A(88) = 5e-12*V(20)*V(43)
  A(89) = 5e-12*V(38)*V(43)
  A(90) = 5e-12*V(43)*V(44)
  A(91) = 1e-12*V(43)*V(46)
  A(92) = 6e-11*V(43)*V(43)
  A(93) = RCT(93)*V(34)*V(41)
  A(94) = RCT(94)*V(24)
  A(95) = RCT(95)*V(24)*V(42)
  A(96) = RCT(96)*V(32)*F(1)
  A(97) = RCT(97)*V(32)*V(46)
  A(98) = 1.3e-10*V(32)*V(35)
  A(99) = 2.53e-14*V(36)*V(46)
  A(100) = 2.5e-11*V(35)*V(36)
  A(101) = 4.3e-11*V(35)*V(38)
  A(102) = RCT(102)*V(35)*V(45)
  A(103) = RCT(103)*V(1)
  A(104) = RCT(104)*V(26)*V(42)
  A(105) = RCT(105)*V(22)*V(26)
  A(106) = RCT(106)*V(22)*V(26)
  A(107) = RCT(107)*V(22)*V(26)
  A(108) = RCT(108)*V(26)*V(35)
  A(109) = RCT(109)*V(13)*F(1)
  A(110) = RCT(110)*V(13)*F(1)
  A(111) = 7e-15*V(7)*F(1)
  A(112) = RCT(112)*F(1)
  A(113) = RCT(113)*V(46)
  A(114) = RCT(114)*V(46)
  A(115) = RCT(115)*V(8)
  A(116) = RCT(116)*V(41)
  A(117) = RCT(117)*V(40)
  A(118) = RCT(118)*V(40)
  A(119) = RCT(119)*V(6)
  A(120) = RCT(120)*V(21)
  A(121) = RCT(121)*V(19)
  A(122) = RCT(122)*V(16)
  A(123) = RCT(123)*V(17)
  A(124) = RCT(124)*V(45)
  A(125) = RCT(125)*V(45)
  A(126) = RCT(126)*V(18)
  A(127) = RCT(127)*V(28)
  A(128) = RCT(128)*V(23)
  A(129) = RCT(129)*V(27)
  A(130) = RCT(130)*V(38)
  A(131) = RCT(131)*V(33)
  A(132) = RCT(132)*V(24)

! Aggregate function
  Vdot(1) = -A(103)
  Vdot(2) = A(34)
  Vdot(3) = 2*A(87)+2*A(88)+2*A(89)+A(90)
  Vdot(4) = -A(28)
  Vdot(5) = -A(44)
  Vdot(6) = A(17)-A(18)-A(119)
  Vdot(7) = A(106)+A(108)+A(109)-A(111)
  Vdot(8) = A(8)-A(10)-A(115)
  Vdot(9) = A(11)-A(12)-A(82)
  Vdot(10) = 0.5*A(75)-A(78)
  Vdot(11) = -A(3)+A(5)+A(56)+0.956*A(97)+A(98)+0.3*A(102)+A(106)+A(108)+A(125)
  Vdot(12) = A(39)-A(42)
  Vdot(13) = A(104)+A(107)-A(109)-A(110)
  Vdot(14) = A(37)-A(39)-A(41)+A(42)
  Vdot(15) = -A(5)+0.17*A(98)+A(124)
  Vdot(16) = A(22)-A(26)-A(27)-A(122)
  Vdot(17) = A(46)-A(53)-A(123)
  Vdot(18) = A(65)-A(68)-A(126)
  Vdot(19) = A(21)-A(25)+A(55)-A(121)
  Vdot(20) = -A(45)+0.5*A(52)-A(88)
  Vdot(21) = A(19)-A(24)+A(40)+A(64)-A(120)
  Vdot(22) = -A(1)-A(9)-A(13)-A(105)-A(106)-A(107)+A(113)
  Vdot(23) = A(58)-A(59)-A(60)-A(128)
  Vdot(24) = A(93)-A(94)-A(95)-A(132)
  Vdot(25) = A(29)+A(30)+A(35)-A(36)-A(37)
  Vdot(26) = -A(104)-A(106)-A(107)-A(108)
  Vdot(27) = 0.5*A(71)-A(76)-A(77)+A(81)+A(82)-A(129)
  Vdot(28) = A(49)-A(61)+A(63)-A(127)
  Vdot(29) = A(31)-A(38)-A(39)-A(40)+A(41)-A(43)+A(66)
  Vdot(30) = A(28)-A(29)-A(30)-A(31)-A(32)-A(33)-A(34)-A(35)+A(36)
  Vdot(31) = A(54)+A(55)-A(56)+A(80)-A(85)+0.17*A(98)+0.7*A(102)+0.63*A(103)+A(110)+A(124)+A(125)+A(131)
  Vdot(32) = A(44)-A(96)-A(97)-A(98)+0.75*A(100)
  Vdot(33) = -A(57)+0.5*A(71)+A(72)+A(73)+A(74)+0.5*A(75)+A(77)+A(78)+A(86)+A(95)+A(129)-A(131)+0.333*A(132)
  Vdot(34) = A(69)-A(70)-A(71)-A(72)-A(73)-A(74)-A(75)+A(76)-A(93)+A(94)+0.667*A(132)
  Vdot(35) = A(1)-A(2)+A(13)-A(98)-A(100)-A(101)-A(102)+A(105)-A(108)+A(109)+2*A(112)+A(114)+A(116)+A(117)
  Vdot(36) = 0.15*A(45)+A(48)+A(50)+A(51)-A(62)-A(63)-A(64)-A(65)-A(66)+A(67)+A(79)+0.044*A(97)-A(99)-A(100)+A(101)&
               &+A(123)+A(126)+A(127)+0.333*A(128)
  Vdot(37) = A(5)+A(7)-A(9)+A(10)-2*A(11)+2*A(12)+A(24)+A(25)+A(27)+A(28)+A(31)+A(33)+A(34)+A(38)+A(41)+A(42)+A(44)&
               &+A(45)+A(47)+A(53)+A(54)+A(57)+A(60)+A(61)+A(68)+0.3*A(71)+A(76)+A(77)+A(78)-A(81)+A(82)+A(95)+0.47*A(103)&
               &+A(104)
  Vdot(38) = -A(46)-A(47)-A(48)-A(49)-A(50)-A(51)-A(52)+0.6*A(53)-A(58)+A(59)-A(67)-A(79)-A(89)+A(96)+A(99)-A(101)+0.667&
               &*A(128)-A(130)
  Vdot(39) = -A(14)-A(16)-A(19)-A(20)-A(32)-A(33)+A(35)+A(38)+A(39)+A(40)+A(43)-A(48)-A(49)-A(65)-A(66)+A(68)-A(72)&
               &-A(83)+A(110)+A(111)+A(116)+A(118)+A(120)+A(126)
  Vdot(40) = A(15)-A(16)-A(17)+A(18)-A(23)+A(25)-A(50)-A(55)+A(60)-A(73)+A(84)+A(95)-A(117)-A(118)+A(119)+0.333*A(122)&
               &+0.333*A(128)+0.333*A(132)
  Vdot(41) = A(14)-A(15)+2*A(16)-A(17)+A(18)+A(20)-A(21)-A(22)+A(23)+A(24)+A(26)+A(27)-A(34)-A(35)-A(40)+A(48)+A(50)&
               &-A(58)+A(59)+A(61)-A(63)-A(64)+A(72)+A(73)+A(83)-A(84)-A(93)+A(94)-A(116)+A(117)+A(119)+A(121)+0.667*A(122)&
               &+A(127)+0.667*A(128)+0.667*A(132)
  Vdot(42) = -A(4)-A(5)+A(6)-A(7)+2*A(9)-A(10)-A(19)+A(20)-A(21)+A(23)-A(24)-A(25)-A(27)-A(28)+A(30)+A(32)-A(38)-A(41)&
               &-A(42)-A(44)-A(45)-0.6*A(53)-A(54)-A(56)-A(57)-A(60)-A(61)-A(68)+0.2*A(71)-A(76)-A(78)-A(79)+A(80)-A(95)&
               &+0.25*A(100)+0.7*A(102)+0.16*A(103)-A(104)+A(107)+2*A(115)+A(120)+A(121)+0.333*A(122)+A(123)+A(129)+A(130)&
               &+A(131)
  Vdot(43) = -A(80)-A(81)-A(82)-A(83)-A(84)-A(85)-A(86)-A(87)-A(88)-A(89)-A(90)-A(91)-2*A(92)+0.37*A(103)
  Vdot(44) = A(3)+A(4)-A(6)-A(7)-2*A(8)+A(10)-A(20)-A(22)-A(23)+A(26)-A(30)-A(31)+A(32)+A(43)+0.85*A(45)-A(46)-A(47)&
               &+A(54)+A(55)+A(57)+A(62)-A(69)+A(70)-0.8*A(71)+A(72)+A(73)+A(74)+A(78)+A(79)+A(80)-A(90)+A(102)+0.16*A(103)&
               &+0.667*A(122)+A(125)+A(129)+A(131)+0.333*A(132)
  Vdot(45) = 0.85*A(45)+A(47)+0.5*A(52)+0.4*A(53)-A(54)-A(55)+A(60)+A(61)+A(62)+A(64)+A(66)+A(68)-A(69)+A(70)+A(83)&
               &+A(84)+A(85)-A(87)+A(91)+2*A(92)+0.956*A(97)+0.83*A(98)+0.25*A(100)-A(102)-A(124)-A(125)+A(130)
  Vdot(46) = A(2)-A(4)-A(6)-A(14)-A(15)-A(29)-A(36)-A(67)-A(91)-A(97)-A(99)-A(113)-A(114)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun_SPLIT - time derivatives of variables - Split form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      P_VAR     - Production term
!      D_VAR     - Destruction term
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun_SPLIT ( V, F, RCT, P_VAR, D_VAR )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! P_VAR - Production term
  REAL(kind=dp) :: P_VAR(NVAR)
! D_VAR - Destruction term
  REAL(kind=dp) :: D_VAR(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(22)*F(1)
  A(2) = RCT(2)*V(35)*F(1)
  A(3) = RCT(3)*V(11)*F(1)
  A(4) = RCT(4)*V(42)*V(46)
  A(5) = RCT(5)*V(15)*V(42)
  A(6) = RCT(6)*V(44)*V(46)
  A(7) = RCT(7)*V(42)*V(44)
  A(8) = RCT(8)*V(44)*V(44)
  A(9) = RCT(9)*V(22)*V(37)
  A(10) = 1.8e-12*V(8)*V(42)
  A(11) = RCT(11)*V(37)*V(37)
  A(12) = V(9)
  A(13) = RCT(13)*V(22)*F(2)
  A(14) = RCT(14)*V(39)*V(46)
  A(15) = RCT(15)*V(41)*V(46)
  A(16) = RCT(16)*V(39)*V(40)
  A(17) = RCT(17)*V(40)*V(41)
  A(18) = RCT(18)*V(6)
  A(19) = RCT(19)*V(39)*V(42)
  A(20) = RCT(20)*V(39)*V(44)
  A(21) = RCT(21)*V(41)*V(42)
  A(22) = RCT(22)*V(41)*V(44)
  A(23) = 3.5e-12*V(40)*V(44)
  A(24) = RCT(24)*V(21)*V(42)
  A(25) = RCT(25)*V(19)*V(42)
  A(26) = RCT(26)*V(16)
  A(27) = RCT(27)*V(16)*V(42)
  A(28) = RCT(28)*V(4)*V(42)
  A(29) = RCT(29)*V(30)*V(46)
  A(30) = RCT(30)*V(30)*V(44)
  A(31) = RCT(31)*V(30)*V(44)
  A(32) = RCT(32)*V(30)*V(39)
  A(33) = RCT(33)*V(30)*V(39)
  A(34) = RCT(34)*V(30)*V(41)
  A(35) = RCT(35)*V(30)*V(41)
  A(36) = 1.2e-14*V(25)*V(46)
  A(37) = 1300*V(25)
  A(38) = RCT(38)*V(29)*V(42)
  A(39) = RCT(39)*V(14)*V(29)
  A(40) = RCT(40)*V(29)*V(41)
  A(41) = 1.66e-12*V(14)*V(42)
  A(42) = RCT(42)*V(12)*V(42)
  A(43) = RCT(43)*V(29)*F(1)
  A(44) = RCT(44)*V(5)*V(42)
  A(45) = RCT(45)*V(20)*V(42)
  A(46) = RCT(46)*V(38)*V(44)
  A(47) = RCT(47)*V(38)*V(44)
  A(48) = RCT(48)*V(38)*V(39)
  A(49) = RCT(49)*V(38)*V(39)
  A(50) = 1.2e-12*V(38)*V(40)
  A(51) = RCT(51)*V(38)
  A(52) = RCT(52)*V(38)
  A(53) = RCT(53)*V(17)*V(42)
  A(54) = RCT(54)*V(42)*V(45)
  A(55) = RCT(55)*V(40)*V(45)
  A(56) = RCT(56)*V(31)*V(42)
  A(57) = RCT(57)*V(33)*V(42)
  A(58) = RCT(58)*V(38)*V(41)
  A(59) = RCT(59)*V(23)
  A(60) = 3e-14*V(23)*V(42)
  A(61) = RCT(61)*V(28)*V(42)
  A(62) = RCT(62)*V(36)
  A(63) = RCT(63)*V(36)*V(41)
  A(64) = RCT(64)*V(36)*V(41)
  A(65) = RCT(65)*V(36)*V(39)
  A(66) = RCT(66)*V(36)*V(39)
  A(67) = RCT(67)*V(38)*V(46)
  A(68) = RCT(68)*V(18)*V(42)
  A(69) = RCT(69)*V(44)*V(45)
  A(70) = RCT(70)*V(34)
  A(71) = RCT(71)*V(34)*V(44)
  A(72) = RCT(72)*V(34)*V(39)
  A(73) = 1.2e-12*V(34)*V(40)
  A(74) = RCT(74)*V(34)
  A(75) = RCT(75)*V(34)
  A(76) = RCT(76)*V(27)*V(42)
  A(77) = RCT(77)*V(27)*V(42)
  A(78) = RCT(78)*V(10)*V(42)
  A(79) = 1.4e-10*V(38)*V(42)
  A(80) = RCT(80)*V(43)
  A(81) = RCT(81)*V(37)*V(43)
  A(82) = 5.2e-12*V(9)*V(43)
  A(83) = 6e-14*V(39)*V(43)
  A(84) = RCT(84)*V(41)*V(43)
  A(85) = 3.6e-14*V(31)*V(43)
  A(86) = 1e-10*V(33)*V(43)
  A(87) = 1.7e-12*V(43)*V(45)
  A(88) = 5e-12*V(20)*V(43)
  A(89) = 5e-12*V(38)*V(43)
  A(90) = 5e-12*V(43)*V(44)
  A(91) = 1e-12*V(43)*V(46)
  A(92) = 6e-11*V(43)*V(43)
  A(93) = RCT(93)*V(34)*V(41)
  A(94) = RCT(94)*V(24)
  A(95) = RCT(95)*V(24)*V(42)
  A(96) = RCT(96)*V(32)*F(1)
  A(97) = RCT(97)*V(32)*V(46)
  A(98) = 1.3e-10*V(32)*V(35)
  A(99) = 2.53e-14*V(36)*V(46)
  A(100) = 2.5e-11*V(35)*V(36)
  A(101) = 4.3e-11*V(35)*V(38)
  A(102) = RCT(102)*V(35)*V(45)
  A(103) = RCT(103)*V(1)
  A(104) = RCT(104)*V(26)*V(42)
  A(105) = RCT(105)*V(22)*V(26)
  A(106) = RCT(106)*V(22)*V(26)
  A(107) = RCT(107)*V(22)*V(26)
  A(108) = RCT(108)*V(26)*V(35)
  A(109) = RCT(109)*V(13)*F(1)
  A(110) = RCT(110)*V(13)*F(1)
  A(111) = 7e-15*V(7)*F(1)
  A(112) = RCT(112)*F(1)
  A(113) = RCT(113)*V(46)
  A(114) = RCT(114)*V(46)
  A(115) = RCT(115)*V(8)
  A(116) = RCT(116)*V(41)
  A(117) = RCT(117)*V(40)
  A(118) = RCT(118)*V(40)
  A(119) = RCT(119)*V(6)
  A(120) = RCT(120)*V(21)
  A(121) = RCT(121)*V(19)
  A(122) = RCT(122)*V(16)
  A(123) = RCT(123)*V(17)
  A(124) = RCT(124)*V(45)
  A(125) = RCT(125)*V(45)
  A(126) = RCT(126)*V(18)
  A(127) = RCT(127)*V(28)
  A(128) = RCT(128)*V(23)
  A(129) = RCT(129)*V(27)
  A(130) = RCT(130)*V(38)
  A(131) = RCT(131)*V(33)
  A(132) = RCT(132)*V(24)

! Production function
  P_VAR(1) = 0
  P_VAR(2) = A(34)
  P_VAR(3) = 2*A(87)+2*A(88)+2*A(89)+A(90)
  P_VAR(4) = 0
  P_VAR(5) = 0
  P_VAR(6) = A(17)
  P_VAR(7) = A(106)+A(108)+A(109)
  P_VAR(8) = A(8)
  P_VAR(9) = A(11)
  P_VAR(10) = 0.5*A(75)
  P_VAR(11) = A(5)+A(56)+0.956*A(97)+A(98)+0.3*A(102)+A(106)+A(108)+A(125)
  P_VAR(12) = A(39)
  P_VAR(13) = A(104)+A(107)
  P_VAR(14) = A(37)+A(42)
  P_VAR(15) = 0.17*A(98)+A(124)
  P_VAR(16) = A(22)
  P_VAR(17) = A(46)
  P_VAR(18) = A(65)
  P_VAR(19) = A(21)+A(55)
  P_VAR(20) = 0.5*A(52)
  P_VAR(21) = A(19)+A(40)+A(64)
  P_VAR(22) = A(113)
  P_VAR(23) = A(58)
  P_VAR(24) = A(93)
  P_VAR(25) = A(29)+A(30)+A(35)
  P_VAR(26) = A(105)
  P_VAR(27) = 0.5*A(71)+A(81)+A(82)
  P_VAR(28) = A(49)+A(63)
  P_VAR(29) = A(31)+A(41)+A(66)
  P_VAR(30) = A(28)+A(36)
  P_VAR(31) = A(54)+A(55)+A(80)+0.17*A(98)+0.7*A(102)+0.63*A(103)+A(110)+A(124)+A(125)+A(131)
  P_VAR(32) = A(44)+0.75*A(100)
  P_VAR(33) = 0.5*A(71)+A(72)+A(73)+A(74)+0.5*A(75)+A(77)+A(78)+2*A(86)+A(95)+A(129)+0.333*A(132)
  P_VAR(34) = A(69)+A(76)+A(94)+0.667*A(132)
  P_VAR(35) = A(1)+A(13)+A(105)+A(109)+2*A(112)+A(114)+A(116)+A(117)
  P_VAR(36) = 0.15*A(45)+A(48)+A(50)+A(51)+A(67)+A(79)+0.044*A(97)+A(101)+A(123)+A(126)+A(127)+0.333*A(128)
  P_VAR(37) = A(5)+A(7)+A(10)+2*A(12)+A(24)+A(25)+A(27)+A(28)+A(31)+A(33)+A(34)+A(38)+A(41)+A(42)+A(44)+A(45)+A(47)&
                &+A(53)+A(54)+A(57)+A(60)+A(61)+A(68)+0.3*A(71)+A(76)+A(77)+A(78)+A(82)+A(95)+0.47*A(103)+A(104)
  P_VAR(38) = 0.6*A(53)+A(59)+A(96)+A(99)+0.667*A(128)
  P_VAR(39) = A(35)+A(38)+A(39)+A(40)+A(43)+A(68)+A(110)+A(111)+A(116)+A(118)+A(120)+A(126)
  P_VAR(40) = A(15)+A(18)+A(25)+A(60)+A(84)+A(95)+A(119)+0.333*A(122)+0.333*A(128)+0.333*A(132)
  P_VAR(41) = A(14)+2*A(16)+A(18)+A(20)+A(23)+A(24)+A(26)+A(27)+A(48)+A(50)+A(59)+A(61)+A(72)+A(73)+A(83)+A(94)+A(117)&
                &+A(119)+A(121)+0.667*A(122)+A(127)+0.667*A(128)+0.667*A(132)
  P_VAR(42) = A(6)+2*A(9)+A(20)+A(23)+A(30)+A(32)+0.4*A(53)+0.2*A(71)+A(77)+A(80)+0.25*A(100)+0.7*A(102)+0.16*A(103)&
                &+A(107)+2*A(115)+A(120)+A(121)+0.333*A(122)+A(123)+A(129)+A(130)+A(131)
  P_VAR(43) = 0.37*A(103)
  P_VAR(44) = A(3)+A(4)+A(10)+A(26)+A(32)+A(43)+0.85*A(45)+A(54)+A(55)+A(57)+A(62)+A(70)+0.2*A(71)+A(72)+A(73)+A(74)&
                &+A(78)+A(79)+A(80)+A(102)+0.16*A(103)+0.667*A(122)+A(125)+A(129)+A(131)+0.333*A(132)
  P_VAR(45) = 0.85*A(45)+A(47)+0.5*A(52)+0.4*A(53)+A(60)+A(61)+A(62)+A(64)+A(66)+A(68)+A(70)+A(83)+A(84)+A(85)+A(91)+2&
                &*A(92)+0.956*A(97)+0.83*A(98)+0.25*A(100)+A(130)
  P_VAR(46) = A(2)

! Destruction function
  D_VAR(1) = RCT(103)
  D_VAR(2) = 0
  D_VAR(3) = 0
  D_VAR(4) = RCT(28)*V(42)
  D_VAR(5) = RCT(44)*V(42)
  D_VAR(6) = RCT(18)+RCT(119)
  D_VAR(7) = 7e-15*F(1)
  D_VAR(8) = 1.8e-12*V(42)+RCT(115)
  D_VAR(9) = 1+5.2e-12*V(43)
  D_VAR(10) = RCT(78)*V(42)
  D_VAR(11) = RCT(3)*F(1)
  D_VAR(12) = RCT(42)*V(42)
  D_VAR(13) = RCT(109)*F(1)+RCT(110)*F(1)
  D_VAR(14) = RCT(39)*V(29)+1.66e-12*V(42)
  D_VAR(15) = RCT(5)*V(42)
  D_VAR(16) = RCT(26)+RCT(27)*V(42)+RCT(122)
  D_VAR(17) = RCT(53)*V(42)+RCT(123)
  D_VAR(18) = RCT(68)*V(42)+RCT(126)
  D_VAR(19) = RCT(25)*V(42)+RCT(121)
  D_VAR(20) = RCT(45)*V(42)+5e-12*V(43)
  D_VAR(21) = RCT(24)*V(42)+RCT(120)
  D_VAR(22) = RCT(1)*F(1)+RCT(9)*V(37)+RCT(13)*F(2)+RCT(105)*V(26)+RCT(106)*V(26)+RCT(107)*V(26)
  D_VAR(23) = RCT(59)+3e-14*V(42)+RCT(128)
  D_VAR(24) = RCT(94)+RCT(95)*V(42)+RCT(132)
  D_VAR(25) = 1.2e-14*V(46)+1300
  D_VAR(26) = RCT(104)*V(42)+RCT(105)*V(22)+RCT(106)*V(22)+RCT(107)*V(22)+RCT(108)*V(35)
  D_VAR(27) = RCT(76)*V(42)+RCT(77)*V(42)+RCT(129)
  D_VAR(28) = RCT(61)*V(42)+RCT(127)
  D_VAR(29) = RCT(38)*V(42)+RCT(39)*V(14)+RCT(40)*V(41)+RCT(43)*F(1)
  D_VAR(30) = RCT(29)*V(46)+RCT(30)*V(44)+RCT(31)*V(44)+RCT(32)*V(39)+RCT(33)*V(39)+RCT(34)*V(41)+RCT(35)*V(41)
  D_VAR(31) = RCT(56)*V(42)+3.6e-14*V(43)
  D_VAR(32) = RCT(96)*F(1)+RCT(97)*V(46)+1.3e-10*V(35)
  D_VAR(33) = RCT(57)*V(42)+1e-10*V(43)+RCT(131)
  D_VAR(34) = RCT(70)+RCT(71)*V(44)+RCT(72)*V(39)+1.2e-12*V(40)+RCT(74)+RCT(75)+RCT(93)*V(41)
  D_VAR(35) = RCT(2)*F(1)+1.3e-10*V(32)+2.5e-11*V(36)+4.3e-11*V(38)+RCT(102)*V(45)+RCT(108)*V(26)
  D_VAR(36) = RCT(62)+RCT(63)*V(41)+RCT(64)*V(41)+RCT(65)*V(39)+RCT(66)*V(39)+2.53e-14*V(46)+2.5e-11*V(35)
  D_VAR(37) = RCT(9)*V(22)+RCT(11)*2*V(37)+RCT(81)*V(43)
  D_VAR(38) = RCT(46)*V(44)+RCT(47)*V(44)+RCT(48)*V(39)+RCT(49)*V(39)+1.2e-12*V(40)+RCT(51)+RCT(52)+RCT(58)*V(41)&
                &+RCT(67)*V(46)+1.4e-10*V(42)+5e-12*V(43)+4.3e-11*V(35)+RCT(130)
  D_VAR(39) = RCT(14)*V(46)+RCT(16)*V(40)+RCT(19)*V(42)+RCT(20)*V(44)+RCT(32)*V(30)+RCT(33)*V(30)+RCT(48)*V(38)+RCT(49)&
                &*V(38)+RCT(65)*V(36)+RCT(66)*V(36)+RCT(72)*V(34)+6e-14*V(43)
  D_VAR(40) = RCT(16)*V(39)+RCT(17)*V(41)+3.5e-12*V(44)+1.2e-12*V(38)+RCT(55)*V(45)+1.2e-12*V(34)+RCT(117)+RCT(118)
  D_VAR(41) = RCT(15)*V(46)+RCT(17)*V(40)+RCT(21)*V(42)+RCT(22)*V(44)+RCT(34)*V(30)+RCT(35)*V(30)+RCT(40)*V(29)+RCT(58)&
                &*V(38)+RCT(63)*V(36)+RCT(64)*V(36)+RCT(84)*V(43)+RCT(93)*V(34)+RCT(116)
  D_VAR(42) = RCT(4)*V(46)+RCT(5)*V(15)+RCT(7)*V(44)+1.8e-12*V(8)+RCT(19)*V(39)+RCT(21)*V(41)+RCT(24)*V(21)+RCT(25)&
                &*V(19)+RCT(27)*V(16)+RCT(28)*V(4)+RCT(38)*V(29)+1.66e-12*V(14)+RCT(42)*V(12)+RCT(44)*V(5)+RCT(45)*V(20)&
                &+RCT(53)*V(17)+RCT(54)*V(45)+RCT(56)*V(31)+RCT(57)*V(33)+3e-14*V(23)+RCT(61)*V(28)+RCT(68)*V(18)+RCT(76)&
                &*V(27)+RCT(77)*V(27)+RCT(78)*V(10)+1.4e-10*V(38)+RCT(95)*V(24)+RCT(104)*V(26)
  D_VAR(43) = RCT(80)+RCT(81)*V(37)+5.2e-12*V(9)+6e-14*V(39)+RCT(84)*V(41)+3.6e-14*V(31)+1e-10*V(33)+1.7e-12*V(45)+5e-12&
                &*V(20)+5e-12*V(38)+5e-12*V(44)+1e-12*V(46)+6e-11*2*V(43)
  D_VAR(44) = RCT(6)*V(46)+RCT(7)*V(42)+RCT(8)*2*V(44)+RCT(20)*V(39)+RCT(22)*V(41)+3.5e-12*V(40)+RCT(30)*V(30)+RCT(31)&
                &*V(30)+RCT(46)*V(38)+RCT(47)*V(38)+RCT(69)*V(45)+RCT(71)*V(34)+5e-12*V(43)
  D_VAR(45) = RCT(54)*V(42)+RCT(55)*V(40)+RCT(69)*V(44)+1.7e-12*V(43)+RCT(102)*V(35)+RCT(124)+RCT(125)
  D_VAR(46) = RCT(4)*V(42)+RCT(6)*V(44)+RCT(14)*V(39)+RCT(15)*V(41)+RCT(29)*V(30)+1.2e-14*V(25)+RCT(67)*V(38)+1e-12&
                &*V(43)+RCT(97)*V(32)+2.53e-14*V(36)+RCT(113)+RCT(114)
      
END SUBROUTINE Fun_SPLIT

! End of Fun_SPLIT function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! CalcStoichNum - calculate stoichiometric numbers
!   Arguments :
!      StoichNum - Stoichiometric numbers
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE CalcStoichNum ( StoichNum )

! StoichNum - Stoichiometric numbers
  REAL(kind=dp) :: StoichNum(NVAR,NREACT)

  StoichNum(:,:) = 0.
  StoichNum(1,103) = -1
  StoichNum(2,34) = 1
  StoichNum(3,87) = 2
  StoichNum(3,88) = 2
  StoichNum(3,89) = 2
  StoichNum(3,90) = 1
  StoichNum(4,28) = -1
  StoichNum(5,44) = -1
  StoichNum(6,17) = 1
  StoichNum(6,18) = -1
  StoichNum(6,119) = -1
  StoichNum(7,106) = 1
  StoichNum(7,108) = 1
  StoichNum(7,109) = 1
  StoichNum(7,111) = -1
  StoichNum(8,8) = 1
  StoichNum(8,10) = -1
  StoichNum(8,115) = -1
  StoichNum(9,11) = 1
  StoichNum(9,12) = -1
  StoichNum(9,82) = -1
  StoichNum(10,75) = 0.5
  StoichNum(10,78) = -1
  StoichNum(11,3) = -1
  StoichNum(11,5) = 1
  StoichNum(11,56) = 1
  StoichNum(11,97) = 0.956
  StoichNum(11,98) = 1
  StoichNum(11,102) = 0.3
  StoichNum(11,106) = 1
  StoichNum(11,108) = 1
  StoichNum(11,125) = 1
  StoichNum(12,39) = 1
  StoichNum(12,42) = -1
  StoichNum(13,104) = 1
  StoichNum(13,107) = 1
  StoichNum(13,109) = -1
  StoichNum(13,110) = -1
  StoichNum(14,37) = 1
  StoichNum(14,39) = -1
  StoichNum(14,41) = -1
  StoichNum(14,42) = 1
  StoichNum(15,5) = -1
  StoichNum(15,98) = 0.17
  StoichNum(15,124) = 1
  StoichNum(16,22) = 1
  StoichNum(16,26) = -1
  StoichNum(16,27) = -1
  StoichNum(16,122) = -1
  StoichNum(17,46) = 1
  StoichNum(17,53) = -1
  StoichNum(17,123) = -1
  StoichNum(18,65) = 1
  StoichNum(18,68) = -1
  StoichNum(18,126) = -1
  StoichNum(19,21) = 1
  StoichNum(19,25) = -1
  StoichNum(19,55) = 1
  StoichNum(19,121) = -1
  StoichNum(20,45) = -1
  StoichNum(20,52) = 0.5
  StoichNum(20,88) = -1
  StoichNum(21,19) = 1
  StoichNum(21,24) = -1
  StoichNum(21,40) = 1
  StoichNum(21,64) = 1
  StoichNum(21,120) = -1
  StoichNum(22,1) = -1
  StoichNum(22,9) = -1
  StoichNum(22,13) = -1
  StoichNum(22,105) = -1
  StoichNum(22,106) = -1
  StoichNum(22,107) = -1
  StoichNum(22,113) = 1
  StoichNum(23,58) = 1
  StoichNum(23,59) = -1
  StoichNum(23,60) = -1
  StoichNum(23,128) = -1
  StoichNum(24,93) = 1
  StoichNum(24,94) = -1
  StoichNum(24,95) = -1
  StoichNum(24,132) = -1
  StoichNum(25,29) = 1
  StoichNum(25,30) = 1
  StoichNum(25,35) = 1
  StoichNum(25,36) = -1
  StoichNum(25,37) = -1
  StoichNum(26,104) = -1
  StoichNum(26,106) = -1
  StoichNum(26,107) = -1
  StoichNum(26,108) = -1
  StoichNum(27,71) = 0.5
  StoichNum(27,76) = -1
  StoichNum(27,77) = -1
  StoichNum(27,81) = 1
  StoichNum(27,82) = 1
  StoichNum(27,129) = -1
  StoichNum(28,49) = 1
  StoichNum(28,61) = -1
  StoichNum(28,63) = 1
  StoichNum(28,127) = -1
  StoichNum(29,31) = 1
  StoichNum(29,38) = -1
  StoichNum(29,39) = -1
  StoichNum(29,40) = -1
  StoichNum(29,41) = 1
  StoichNum(29,43) = -1
  StoichNum(29,66) = 1
  StoichNum(30,28) = 1
  StoichNum(30,29) = -1
  StoichNum(30,30) = -1
  StoichNum(30,31) = -1
  StoichNum(30,32) = -1
  StoichNum(30,33) = -1
  StoichNum(30,34) = -1
  StoichNum(30,35) = -1
  StoichNum(30,36) = 1
  StoichNum(31,54) = 1
  StoichNum(31,55) = 1
  StoichNum(31,56) = -1
  StoichNum(31,80) = 1
  StoichNum(31,85) = -1
  StoichNum(31,98) = 0.17
  StoichNum(31,102) = 0.7
  StoichNum(31,103) = 0.63
  StoichNum(31,110) = 1
  StoichNum(31,124) = 1
  StoichNum(31,125) = 1
  StoichNum(31,131) = 1
  StoichNum(32,44) = 1
  StoichNum(32,96) = -1
  StoichNum(32,97) = -1
  StoichNum(32,98) = -1
  StoichNum(32,100) = 0.75
  StoichNum(33,57) = -1
  StoichNum(33,71) = 0.5
  StoichNum(33,72) = 1
  StoichNum(33,73) = 1
  StoichNum(33,74) = 1
  StoichNum(33,75) = 0.5
  StoichNum(33,77) = 1
  StoichNum(33,78) = 1
  StoichNum(33,86) = 1
  StoichNum(33,95) = 1
  StoichNum(33,129) = 1
  StoichNum(33,131) = -1
  StoichNum(33,132) = 0.333
  StoichNum(34,69) = 1
  StoichNum(34,70) = -1
  StoichNum(34,71) = -1
  StoichNum(34,72) = -1
  StoichNum(34,73) = -1
  StoichNum(34,74) = -1
  StoichNum(34,75) = -1
  StoichNum(34,76) = 1
  StoichNum(34,93) = -1
  StoichNum(34,94) = 1
  StoichNum(34,132) = 0.667
  StoichNum(35,1) = 1
  StoichNum(35,2) = -1
  StoichNum(35,13) = 1
  StoichNum(35,98) = -1
  StoichNum(35,100) = -1
  StoichNum(35,101) = -1
  StoichNum(35,102) = -1
  StoichNum(35,105) = 1
  StoichNum(35,108) = -1
  StoichNum(35,109) = 1
  StoichNum(35,112) = 2
  StoichNum(35,114) = 1
  StoichNum(35,116) = 1
  StoichNum(35,117) = 1
  StoichNum(36,45) = 0.15
  StoichNum(36,48) = 1
  StoichNum(36,50) = 1
  StoichNum(36,51) = 1
  StoichNum(36,62) = -1
  StoichNum(36,63) = -1
  StoichNum(36,64) = -1
  StoichNum(36,65) = -1
  StoichNum(36,66) = -1
  StoichNum(36,67) = 1
  StoichNum(36,79) = 1
  StoichNum(36,97) = 0.044
  StoichNum(36,99) = -1
  StoichNum(36,100) = -1
  StoichNum(36,101) = 1
  StoichNum(36,123) = 1
  StoichNum(36,126) = 1
  StoichNum(36,127) = 1
  StoichNum(36,128) = 0.333
  StoichNum(37,5) = 1
  StoichNum(37,7) = 1
  StoichNum(37,9) = -1
  StoichNum(37,10) = 1
  StoichNum(37,11) = -2
  StoichNum(37,12) = 2
  StoichNum(37,24) = 1
  StoichNum(37,25) = 1
  StoichNum(37,27) = 1
  StoichNum(37,28) = 1
  StoichNum(37,31) = 1
  StoichNum(37,33) = 1
  StoichNum(37,34) = 1
  StoichNum(37,38) = 1
  StoichNum(37,41) = 1
  StoichNum(37,42) = 1
  StoichNum(37,44) = 1
  StoichNum(37,45) = 1
  StoichNum(37,47) = 1
  StoichNum(37,53) = 1
  StoichNum(37,54) = 1
  StoichNum(37,57) = 1
  StoichNum(37,60) = 1
  StoichNum(37,61) = 1
  StoichNum(37,68) = 1
  StoichNum(37,71) = 0.3
  StoichNum(37,76) = 1
  StoichNum(37,77) = 1
  StoichNum(37,78) = 1
  StoichNum(37,81) = -1
  StoichNum(37,82) = 1
  StoichNum(37,95) = 1
  StoichNum(37,103) = 0.47
  StoichNum(37,104) = 1
  StoichNum(38,46) = -1
  StoichNum(38,47) = -1
  StoichNum(38,48) = -1
  StoichNum(38,49) = -1
  StoichNum(38,50) = -1
  StoichNum(38,51) = -1
  StoichNum(38,52) = -1
  StoichNum(38,53) = 0.6
  StoichNum(38,58) = -1
  StoichNum(38,59) = 1
  StoichNum(38,67) = -1
  StoichNum(38,79) = -1
  StoichNum(38,89) = -1
  StoichNum(38,96) = 1
  StoichNum(38,99) = 1
  StoichNum(38,101) = -1
  StoichNum(38,128) = 0.667
  StoichNum(38,130) = -1
  StoichNum(39,14) = -1
  StoichNum(39,16) = -1
  StoichNum(39,19) = -1
  StoichNum(39,20) = -1
  StoichNum(39,32) = -1
  StoichNum(39,33) = -1
  StoichNum(39,35) = 1
  StoichNum(39,38) = 1
  StoichNum(39,39) = 1
  StoichNum(39,40) = 1
  StoichNum(39,43) = 1
  StoichNum(39,48) = -1
  StoichNum(39,49) = -1
  StoichNum(39,65) = -1
  StoichNum(39,66) = -1
  StoichNum(39,68) = 1
  StoichNum(39,72) = -1
  StoichNum(39,83) = -1
  StoichNum(39,110) = 1
  StoichNum(39,111) = 1
  StoichNum(39,116) = 1
  StoichNum(39,118) = 1
  StoichNum(39,120) = 1
  StoichNum(39,126) = 1
  StoichNum(40,15) = 1
  StoichNum(40,16) = -1
  StoichNum(40,17) = -1
  StoichNum(40,18) = 1
  StoichNum(40,23) = -1
  StoichNum(40,25) = 1
  StoichNum(40,50) = -1
  StoichNum(40,55) = -1
  StoichNum(40,60) = 1
  StoichNum(40,73) = -1
  StoichNum(40,84) = 1
  StoichNum(40,95) = 1
  StoichNum(40,117) = -1
  StoichNum(40,118) = -1
  StoichNum(40,119) = 1
  StoichNum(40,122) = 0.333
  StoichNum(40,128) = 0.333
  StoichNum(40,132) = 0.333
  StoichNum(41,14) = 1
  StoichNum(41,15) = -1
  StoichNum(41,16) = 2
  StoichNum(41,17) = -1
  StoichNum(41,18) = 1
  StoichNum(41,20) = 1
  StoichNum(41,21) = -1
  StoichNum(41,22) = -1
  StoichNum(41,23) = 1
  StoichNum(41,24) = 1
  StoichNum(41,26) = 1
  StoichNum(41,27) = 1
  StoichNum(41,34) = -1
  StoichNum(41,35) = -1
  StoichNum(41,40) = -1
  StoichNum(41,48) = 1
  StoichNum(41,50) = 1
  StoichNum(41,58) = -1
  StoichNum(41,59) = 1
  StoichNum(41,61) = 1
  StoichNum(41,63) = -1
  StoichNum(41,64) = -1
  StoichNum(41,72) = 1
  StoichNum(41,73) = 1
  StoichNum(41,83) = 1
  StoichNum(41,84) = -1
  StoichNum(41,93) = -1
  StoichNum(41,94) = 1
  StoichNum(41,116) = -1
  StoichNum(41,117) = 1
  StoichNum(41,119) = 1
  StoichNum(41,121) = 1
  StoichNum(41,122) = 0.667
  StoichNum(41,127) = 1
  StoichNum(41,128) = 0.667
  StoichNum(41,132) = 0.667
  StoichNum(42,4) = -1
  StoichNum(42,5) = -1
  StoichNum(42,6) = 1
  StoichNum(42,7) = -1
  StoichNum(42,9) = 2
  StoichNum(42,10) = -1
  StoichNum(42,19) = -1
  StoichNum(42,20) = 1
  StoichNum(42,21) = -1
  StoichNum(42,23) = 1
  StoichNum(42,24) = -1
  StoichNum(42,25) = -1
  StoichNum(42,27) = -1
  StoichNum(42,28) = -1
  StoichNum(42,30) = 1
  StoichNum(42,32) = 1
  StoichNum(42,38) = -1
  StoichNum(42,41) = -1
  StoichNum(42,42) = -1
  StoichNum(42,44) = -1
  StoichNum(42,45) = -1
  StoichNum(42,53) = -0.6
  StoichNum(42,54) = -1
  StoichNum(42,56) = -1
  StoichNum(42,57) = -1
  StoichNum(42,60) = -1
  StoichNum(42,61) = -1
  StoichNum(42,68) = -1
  StoichNum(42,71) = 0.2
  StoichNum(42,76) = -1
  StoichNum(42,78) = -1
  StoichNum(42,79) = -1
  StoichNum(42,80) = 1
  StoichNum(42,95) = -1
  StoichNum(42,100) = 0.25
  StoichNum(42,102) = 0.7
  StoichNum(42,103) = 0.16
  StoichNum(42,104) = -1
  StoichNum(42,107) = 1
  StoichNum(42,115) = 2
  StoichNum(42,120) = 1
  StoichNum(42,121) = 1
  StoichNum(42,122) = 0.333
  StoichNum(42,123) = 1
  StoichNum(42,129) = 1
  StoichNum(42,130) = 1
  StoichNum(42,131) = 1
  StoichNum(43,80) = -1
  StoichNum(43,81) = -1
  StoichNum(43,82) = -1
  StoichNum(43,83) = -1
  StoichNum(43,84) = -1
  StoichNum(43,85) = -1
  StoichNum(43,86) = -1
  StoichNum(43,87) = -1
  StoichNum(43,88) = -1
  StoichNum(43,89) = -1
  StoichNum(43,90) = -1
  StoichNum(43,91) = -1
  StoichNum(43,92) = -2
  StoichNum(43,103) = 0.37
  StoichNum(44,3) = 1
  StoichNum(44,4) = 1
  StoichNum(44,6) = -1
  StoichNum(44,7) = -1
  StoichNum(44,8) = -2
  StoichNum(44,10) = 1
  StoichNum(44,20) = -1
  StoichNum(44,22) = -1
  StoichNum(44,23) = -1
  StoichNum(44,26) = 1
  StoichNum(44,30) = -1
  StoichNum(44,31) = -1
  StoichNum(44,32) = 1
  StoichNum(44,43) = 1
  StoichNum(44,45) = 0.85
  StoichNum(44,46) = -1
  StoichNum(44,47) = -1
  StoichNum(44,54) = 1
  StoichNum(44,55) = 1
  StoichNum(44,57) = 1
  StoichNum(44,62) = 1
  StoichNum(44,69) = -1
  StoichNum(44,70) = 1
  StoichNum(44,71) = -0.8
  StoichNum(44,72) = 1
  StoichNum(44,73) = 1
  StoichNum(44,74) = 1
  StoichNum(44,78) = 1
  StoichNum(44,79) = 1
  StoichNum(44,80) = 1
  StoichNum(44,90) = -1
  StoichNum(44,102) = 1
  StoichNum(44,103) = 0.16
  StoichNum(44,122) = 0.667
  StoichNum(44,125) = 1
  StoichNum(44,129) = 1
  StoichNum(44,131) = 1
  StoichNum(44,132) = 0.333
  StoichNum(45,45) = 0.85
  StoichNum(45,47) = 1
  StoichNum(45,52) = 0.5
  StoichNum(45,53) = 0.4
  StoichNum(45,54) = -1
  StoichNum(45,55) = -1
  StoichNum(45,60) = 1
  StoichNum(45,61) = 1
  StoichNum(45,62) = 1
  StoichNum(45,64) = 1
  StoichNum(45,66) = 1
  StoichNum(45,68) = 1
  StoichNum(45,69) = -1
  StoichNum(45,70) = 1
  StoichNum(45,83) = 1
  StoichNum(45,84) = 1
  StoichNum(45,85) = 1
  StoichNum(45,87) = -1
  StoichNum(45,91) = 1
  StoichNum(45,92) = 2
  StoichNum(45,97) = 0.956
  StoichNum(45,98) = 0.83
  StoichNum(45,100) = 0.25
  StoichNum(45,102) = -1
  StoichNum(45,124) = -1
  StoichNum(45,125) = -1
  StoichNum(45,130) = 1
  StoichNum(46,2) = 1
  StoichNum(46,4) = -1
  StoichNum(46,6) = -1
  StoichNum(46,14) = -1
  StoichNum(46,15) = -1
  StoichNum(46,29) = -1
  StoichNum(46,36) = -1
  StoichNum(46,67) = -1
  StoichNum(46,91) = -1
  StoichNum(46,97) = -1
  StoichNum(46,99) = -1
  StoichNum(46,113) = -1
  StoichNum(46,114) = -1
      
END SUBROUTINE CalcStoichNum

! End of CalcStoichNum function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Function

