! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_LinearAlgebra.f90
! Time                 : Tue Aug  7 17:33:28 2018
! Working directory    : /home/sander/e2/messy_d2.53.0.24_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_LinearAlgebra

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
        ! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
          X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
        END DO
      END DO

      DO i=NVAR, 1, -1
        ! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
          X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
        END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
        ! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
          X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
        END DO
      END DO

      DO i=NVAR, 1, -1
        ! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
          X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
        END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
        ! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
          XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
          XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
        END DO
      END DO

      DO i=NVAR, 1, -1
        ! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
          XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
          XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
        END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE messy_mecca_kpp_Parameters
!  USE messy_mecca_kpp_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE messy_mecca_kpp_Parameters
!  USE messy_mecca_kpp_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!              X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!              sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE messy_mecca_kpp_Parameters
!  USE messy_mecca_kpp_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!         !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!              X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!       END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!         !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!              X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!       END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(14) = X(14)-JVS(50)*X(12)
  X(26) = X(26)-JVS(104)*X(22)
  X(27) = X(27)-JVS(110)*X(9)
  X(29) = X(29)-JVS(123)*X(14)-JVS(124)*X(25)
  X(30) = X(30)-JVS(133)*X(4)-JVS(134)*X(25)
  X(31) = X(31)-JVS(141)*X(1)-JVS(142)*X(13)-JVS(143)*X(22)-JVS(144)*X(26)
  X(32) = X(32)-JVS(155)*X(5)
  X(33) = X(33)-JVS(161)*X(10)-JVS(162)*X(24)-JVS(163)*X(27)
  X(34) = X(34)-JVS(173)*X(24)-JVS(174)*X(27)
  X(35) = X(35)-JVS(184)*X(13)-JVS(185)*X(22)-JVS(186)*X(26)-JVS(187)*X(32)
  X(36) = X(36)-JVS(197)*X(17)-JVS(198)*X(18)-JVS(199)*X(20)-JVS(200)*X(23)-JVS(201)*X(28)-JVS(202)*X(32)-JVS(203)*X(35)
  X(37) = X(37)-JVS(215)*X(1)-JVS(216)*X(4)-JVS(217)*X(5)-JVS(218)*X(8)-JVS(219)*X(9)-JVS(220)*X(10)-JVS(221)*X(12)&
            &-JVS(222)*X(14)-JVS(223)*X(15)-JVS(224)*X(16)-JVS(225)*X(17)-JVS(226)*X(18)-JVS(227)*X(19)-JVS(228)*X(20)&
            &-JVS(229)*X(21)-JVS(230)*X(22)-JVS(231)*X(23)-JVS(232)*X(24)-JVS(233)*X(25)-JVS(234)*X(26)-JVS(235)*X(27)&
            &-JVS(236)*X(28)-JVS(237)*X(29)-JVS(238)*X(30)-JVS(239)*X(32)-JVS(240)*X(33)-JVS(241)*X(34)-JVS(242)*X(35)&
            &-JVS(243)*X(36)
  X(38) = X(38)-JVS(254)*X(17)-JVS(255)*X(23)-JVS(256)*X(32)-JVS(257)*X(35)-JVS(258)*X(36)-JVS(259)*X(37)
  X(39) = X(39)-JVS(269)*X(7)-JVS(270)*X(13)-JVS(271)*X(14)-JVS(272)*X(18)-JVS(273)*X(21)-JVS(274)*X(22)-JVS(275)*X(25)&
            &-JVS(276)*X(26)-JVS(277)*X(29)-JVS(278)*X(30)-JVS(279)*X(34)-JVS(280)*X(35)-JVS(281)*X(36)-JVS(282)*X(37)&
            &-JVS(283)*X(38)
  X(40) = X(40)-JVS(292)*X(6)-JVS(293)*X(16)-JVS(294)*X(19)-JVS(295)*X(23)-JVS(296)*X(24)-JVS(297)*X(34)-JVS(298)*X(37)&
            &-JVS(299)*X(38)-JVS(300)*X(39)
  X(41) = X(41)-JVS(308)*X(6)-JVS(309)*X(16)-JVS(310)*X(19)-JVS(311)*X(21)-JVS(312)*X(23)-JVS(313)*X(24)-JVS(314)*X(28)&
            &-JVS(315)*X(29)-JVS(316)*X(30)-JVS(317)*X(34)-JVS(318)*X(36)-JVS(319)*X(37)-JVS(320)*X(38)-JVS(321)*X(39)&
            &-JVS(322)*X(40)
  X(42) = X(42)-JVS(329)*X(1)-JVS(330)*X(4)-JVS(331)*X(5)-JVS(332)*X(8)-JVS(333)*X(10)-JVS(334)*X(12)-JVS(335)*X(14)&
            &-JVS(336)*X(15)-JVS(337)*X(16)-JVS(338)*X(17)-JVS(339)*X(18)-JVS(340)*X(19)-JVS(341)*X(20)-JVS(342)*X(21)&
            &-JVS(343)*X(22)-JVS(344)*X(23)-JVS(345)*X(24)-JVS(346)*X(25)-JVS(347)*X(26)-JVS(348)*X(27)-JVS(349)*X(28)&
            &-JVS(350)*X(29)-JVS(351)*X(30)-JVS(352)*X(31)-JVS(353)*X(32)-JVS(354)*X(33)-JVS(355)*X(34)-JVS(356)*X(35)&
            &-JVS(357)*X(36)-JVS(358)*X(37)-JVS(359)*X(38)-JVS(360)*X(39)-JVS(361)*X(40)-JVS(362)*X(41)
  X(43) = X(43)-JVS(368)*X(1)-JVS(369)*X(9)-JVS(370)*X(20)-JVS(371)*X(31)-JVS(372)*X(32)-JVS(373)*X(33)-JVS(374)*X(34)&
            &-JVS(375)*X(35)-JVS(376)*X(36)-JVS(377)*X(37)-JVS(378)*X(38)-JVS(379)*X(39)-JVS(380)*X(40)-JVS(381)*X(41)&
            &-JVS(382)*X(42)
  X(44) = X(44)-JVS(387)*X(1)-JVS(388)*X(8)-JVS(389)*X(10)-JVS(390)*X(11)-JVS(391)*X(15)-JVS(392)*X(16)-JVS(393)*X(20)&
            &-JVS(394)*X(22)-JVS(395)*X(24)-JVS(396)*X(26)-JVS(397)*X(27)-JVS(398)*X(29)-JVS(399)*X(30)-JVS(400)*X(31)&
            &-JVS(401)*X(32)-JVS(402)*X(33)-JVS(403)*X(34)-JVS(404)*X(35)-JVS(405)*X(36)-JVS(406)*X(37)-JVS(407)*X(38)&
            &-JVS(408)*X(39)-JVS(409)*X(40)-JVS(410)*X(41)-JVS(411)*X(42)-JVS(412)*X(43)
  X(45) = X(45)-JVS(416)*X(17)-JVS(417)*X(18)-JVS(418)*X(20)-JVS(419)*X(23)-JVS(420)*X(28)-JVS(421)*X(31)-JVS(422)*X(32)&
            &-JVS(423)*X(33)-JVS(424)*X(34)-JVS(425)*X(35)-JVS(426)*X(36)-JVS(427)*X(37)-JVS(428)*X(38)-JVS(429)*X(39)&
            &-JVS(430)*X(40)-JVS(431)*X(41)-JVS(432)*X(42)-JVS(433)*X(43)-JVS(434)*X(44)
  X(46) = X(46)-JVS(437)*X(25)-JVS(438)*X(30)-JVS(439)*X(32)-JVS(440)*X(35)-JVS(441)*X(36)-JVS(442)*X(37)-JVS(443)*X(38)&
            &-JVS(444)*X(39)-JVS(445)*X(40)-JVS(446)*X(41)-JVS(447)*X(42)-JVS(448)*X(43)-JVS(449)*X(44)-JVS(450)*X(45)
  X(46) = X(46)/JVS(451)
  X(45) = (X(45)-JVS(436)*X(46))/(JVS(435))
  X(44) = (X(44)-JVS(414)*X(45)-JVS(415)*X(46))/(JVS(413))
  X(43) = (X(43)-JVS(384)*X(44)-JVS(385)*X(45)-JVS(386)*X(46))/(JVS(383))
  X(42) = (X(42)-JVS(364)*X(43)-JVS(365)*X(44)-JVS(366)*X(45)-JVS(367)*X(46))/(JVS(363))
  X(41) = (X(41)-JVS(324)*X(42)-JVS(325)*X(43)-JVS(326)*X(44)-JVS(327)*X(45)-JVS(328)*X(46))/(JVS(323))
  X(40) = (X(40)-JVS(302)*X(41)-JVS(303)*X(42)-JVS(304)*X(43)-JVS(305)*X(44)-JVS(306)*X(45)-JVS(307)*X(46))/(JVS(301))
  X(39) = (X(39)-JVS(285)*X(40)-JVS(286)*X(41)-JVS(287)*X(42)-JVS(288)*X(43)-JVS(289)*X(44)-JVS(290)*X(45)-JVS(291)&
            &*X(46))/(JVS(284))
  X(38) = (X(38)-JVS(261)*X(39)-JVS(262)*X(40)-JVS(263)*X(41)-JVS(264)*X(42)-JVS(265)*X(43)-JVS(266)*X(44)-JVS(267)&
            &*X(45)-JVS(268)*X(46))/(JVS(260))
  X(37) = (X(37)-JVS(245)*X(38)-JVS(246)*X(39)-JVS(247)*X(40)-JVS(248)*X(41)-JVS(249)*X(42)-JVS(250)*X(43)-JVS(251)&
            &*X(44)-JVS(252)*X(45)-JVS(253)*X(46))/(JVS(244))
  X(36) = (X(36)-JVS(205)*X(37)-JVS(206)*X(38)-JVS(207)*X(39)-JVS(208)*X(40)-JVS(209)*X(41)-JVS(210)*X(42)-JVS(211)&
            &*X(43)-JVS(212)*X(44)-JVS(213)*X(45)-JVS(214)*X(46))/(JVS(204))
  X(35) = (X(35)-JVS(189)*X(36)-JVS(190)*X(37)-JVS(191)*X(38)-JVS(192)*X(40)-JVS(193)*X(41)-JVS(194)*X(42)-JVS(195)&
            &*X(45)-JVS(196)*X(46))/(JVS(188))
  X(34) = (X(34)-JVS(176)*X(37)-JVS(177)*X(39)-JVS(178)*X(40)-JVS(179)*X(41)-JVS(180)*X(42)-JVS(181)*X(43)-JVS(182)&
            &*X(44)-JVS(183)*X(45))/(JVS(175))
  X(33) = (X(33)-JVS(165)*X(34)-JVS(166)*X(37)-JVS(167)*X(39)-JVS(168)*X(40)-JVS(169)*X(41)-JVS(170)*X(42)-JVS(171)&
            &*X(43)-JVS(172)*X(44))/(JVS(164))
  X(32) = (X(32)-JVS(157)*X(35)-JVS(158)*X(36)-JVS(159)*X(42)-JVS(160)*X(46))/(JVS(156))
  X(31) = (X(31)-JVS(146)*X(32)-JVS(147)*X(33)-JVS(148)*X(35)-JVS(149)*X(37)-JVS(150)*X(40)-JVS(151)*X(42)-JVS(152)&
            &*X(43)-JVS(153)*X(45)-JVS(154)*X(46))/(JVS(145))
  X(30) = (X(30)-JVS(136)*X(39)-JVS(137)*X(41)-JVS(138)*X(42)-JVS(139)*X(44)-JVS(140)*X(46))/(JVS(135))
  X(29) = (X(29)-JVS(126)*X(30)-JVS(127)*X(36)-JVS(128)*X(39)-JVS(129)*X(41)-JVS(130)*X(42)-JVS(131)*X(44)-JVS(132)&
            &*X(46))/(JVS(125))
  X(28) = (X(28)-JVS(118)*X(36)-JVS(119)*X(38)-JVS(120)*X(39)-JVS(121)*X(41)-JVS(122)*X(42))/(JVS(117))
  X(27) = (X(27)-JVS(112)*X(34)-JVS(113)*X(37)-JVS(114)*X(42)-JVS(115)*X(43)-JVS(116)*X(44))/(JVS(111))
  X(26) = (X(26)-JVS(106)*X(35)-JVS(107)*X(37)-JVS(108)*X(42)-JVS(109)*X(46))/(JVS(105))
  X(25) = (X(25)-JVS(100)*X(30)-JVS(101)*X(41)-JVS(102)*X(44)-JVS(103)*X(46))/(JVS(99))
  X(24) = (X(24)-JVS(96)*X(34)-JVS(97)*X(41)-JVS(98)*X(42))/(JVS(95))
  X(23) = (X(23)-JVS(92)*X(38)-JVS(93)*X(41)-JVS(94)*X(42))/(JVS(91))
  X(22) = (X(22)-JVS(88)*X(26)-JVS(89)*X(37)-JVS(90)*X(46))/(JVS(87))
  X(21) = (X(21)-JVS(82)*X(29)-JVS(83)*X(36)-JVS(84)*X(39)-JVS(85)*X(41)-JVS(86)*X(42))/(JVS(81))
  X(20) = (X(20)-JVS(78)*X(38)-JVS(79)*X(42)-JVS(80)*X(43))/(JVS(77))
  X(19) = (X(19)-JVS(73)*X(40)-JVS(74)*X(41)-JVS(75)*X(42)-JVS(76)*X(45))/(JVS(72))
  X(18) = (X(18)-JVS(69)*X(36)-JVS(70)*X(39)-JVS(71)*X(42))/(JVS(68))
  X(17) = (X(17)-JVS(65)*X(38)-JVS(66)*X(42)-JVS(67)*X(44))/(JVS(64))
  X(16) = (X(16)-JVS(61)*X(41)-JVS(62)*X(42)-JVS(63)*X(44))/(JVS(60))
  X(15) = (X(15)-JVS(56)*X(32)-JVS(57)*X(35)-JVS(58)*X(42)-JVS(59)*X(45))/(JVS(55))
  X(14) = (X(14)-JVS(52)*X(25)-JVS(53)*X(29)-JVS(54)*X(42))/(JVS(51))
  X(13) = (X(13)-JVS(47)*X(22)-JVS(48)*X(26)-JVS(49)*X(42))/(JVS(46))
  X(12) = (X(12)-JVS(43)*X(14)-JVS(44)*X(29)-JVS(45)*X(42))/(JVS(42))
  X(11) = (X(11)-JVS(33)*X(15)-JVS(34)*X(22)-JVS(35)*X(26)-JVS(36)*X(31)-JVS(37)*X(32)-JVS(38)*X(35)-JVS(39)*X(42)&
            &-JVS(40)*X(45)-JVS(41)*X(46))/(JVS(32))
  X(10) = (X(10)-JVS(30)*X(34)-JVS(31)*X(42))/(JVS(29))
  X(9) = (X(9)-JVS(27)*X(37)-JVS(28)*X(43))/(JVS(26))
  X(8) = (X(8)-JVS(24)*X(42)-JVS(25)*X(44))/(JVS(23))
  X(7) = (X(7)-JVS(19)*X(13)-JVS(20)*X(22)-JVS(21)*X(26)-JVS(22)*X(35))/(JVS(18))
  X(6) = (X(6)-JVS(16)*X(40)-JVS(17)*X(41))/(JVS(15))
  X(5) = (X(5)-JVS(14)*X(42))/(JVS(13))
  X(4) = (X(4)-JVS(12)*X(42))/(JVS(11))
  X(3) = (X(3)-JVS(6)*X(20)-JVS(7)*X(38)-JVS(8)*X(43)-JVS(9)*X(44)-JVS(10)*X(45))/(JVS(5))
  X(2) = (X(2)-JVS(3)*X(30)-JVS(4)*X(41))/(JVS(2))
  X(1) = X(1)/JVS(1)
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(2)
  XX(3) = X(3)/JVS(5)
  XX(4) = X(4)/JVS(11)
  XX(5) = X(5)/JVS(13)
  XX(6) = X(6)/JVS(15)
  XX(7) = X(7)/JVS(18)
  XX(8) = X(8)/JVS(23)
  XX(9) = X(9)/JVS(26)
  XX(10) = X(10)/JVS(29)
  XX(11) = X(11)/JVS(32)
  XX(12) = X(12)/JVS(42)
  XX(13) = (X(13)-JVS(19)*XX(7))/(JVS(46))
  XX(14) = (X(14)-JVS(43)*XX(12))/(JVS(51))
  XX(15) = (X(15)-JVS(33)*XX(11))/(JVS(55))
  XX(16) = X(16)/JVS(60)
  XX(17) = X(17)/JVS(64)
  XX(18) = X(18)/JVS(68)
  XX(19) = X(19)/JVS(72)
  XX(20) = (X(20)-JVS(6)*XX(3))/(JVS(77))
  XX(21) = X(21)/JVS(81)
  XX(22) = (X(22)-JVS(20)*XX(7)-JVS(34)*XX(11)-JVS(47)*XX(13))/(JVS(87))
  XX(23) = X(23)/JVS(91)
  XX(24) = X(24)/JVS(95)
  XX(25) = (X(25)-JVS(52)*XX(14))/(JVS(99))
  XX(26) = (X(26)-JVS(21)*XX(7)-JVS(35)*XX(11)-JVS(48)*XX(13)-JVS(88)*XX(22))/(JVS(105))
  XX(27) = X(27)/JVS(111)
  XX(28) = X(28)/JVS(117)
  XX(29) = (X(29)-JVS(44)*XX(12)-JVS(53)*XX(14)-JVS(82)*XX(21))/(JVS(125))
  XX(30) = (X(30)-JVS(3)*XX(2)-JVS(100)*XX(25)-JVS(126)*XX(29))/(JVS(135))
  XX(31) = (X(31)-JVS(36)*XX(11))/(JVS(145))
  XX(32) = (X(32)-JVS(37)*XX(11)-JVS(56)*XX(15)-JVS(146)*XX(31))/(JVS(156))
  XX(33) = (X(33)-JVS(147)*XX(31))/(JVS(164))
  XX(34) = (X(34)-JVS(30)*XX(10)-JVS(96)*XX(24)-JVS(112)*XX(27)-JVS(165)*XX(33))/(JVS(175))
  XX(35) = (X(35)-JVS(22)*XX(7)-JVS(38)*XX(11)-JVS(57)*XX(15)-JVS(106)*XX(26)-JVS(148)*XX(31)-JVS(157)*XX(32))&
             &/(JVS(188))
  XX(36) = (X(36)-JVS(69)*XX(18)-JVS(83)*XX(21)-JVS(118)*XX(28)-JVS(127)*XX(29)-JVS(158)*XX(32)-JVS(189)*XX(35))&
             &/(JVS(204))
  XX(37) = (X(37)-JVS(27)*XX(9)-JVS(89)*XX(22)-JVS(107)*XX(26)-JVS(113)*XX(27)-JVS(149)*XX(31)-JVS(166)*XX(33)-JVS(176)&
             &*XX(34)-JVS(190)*XX(35)-JVS(205)*XX(36))/(JVS(244))
  XX(38) = (X(38)-JVS(7)*XX(3)-JVS(65)*XX(17)-JVS(78)*XX(20)-JVS(92)*XX(23)-JVS(119)*XX(28)-JVS(191)*XX(35)-JVS(206)&
             &*XX(36)-JVS(245)*XX(37))/(JVS(260))
  XX(39) = (X(39)-JVS(70)*XX(18)-JVS(84)*XX(21)-JVS(120)*XX(28)-JVS(128)*XX(29)-JVS(136)*XX(30)-JVS(167)*XX(33)-JVS(177)&
             &*XX(34)-JVS(207)*XX(36)-JVS(246)*XX(37)-JVS(261)*XX(38))/(JVS(284))
  XX(40) = (X(40)-JVS(16)*XX(6)-JVS(73)*XX(19)-JVS(150)*XX(31)-JVS(168)*XX(33)-JVS(178)*XX(34)-JVS(192)*XX(35)-JVS(208)&
             &*XX(36)-JVS(247)*XX(37)-JVS(262)*XX(38)-JVS(285)*XX(39))/(JVS(301))
  XX(41) = (X(41)-JVS(4)*XX(2)-JVS(17)*XX(6)-JVS(61)*XX(16)-JVS(74)*XX(19)-JVS(85)*XX(21)-JVS(93)*XX(23)-JVS(97)*XX(24)&
             &-JVS(101)*XX(25)-JVS(121)*XX(28)-JVS(129)*XX(29)-JVS(137)*XX(30)-JVS(169)*XX(33)-JVS(179)*XX(34)-JVS(193)&
             &*XX(35)-JVS(209)*XX(36)-JVS(248)*XX(37)-JVS(263)*XX(38)-JVS(286)*XX(39)-JVS(302)*XX(40))/(JVS(323))
  XX(42) = (X(42)-JVS(12)*XX(4)-JVS(14)*XX(5)-JVS(24)*XX(8)-JVS(31)*XX(10)-JVS(39)*XX(11)-JVS(45)*XX(12)-JVS(49)*XX(13)&
             &-JVS(54)*XX(14)-JVS(58)*XX(15)-JVS(62)*XX(16)-JVS(66)*XX(17)-JVS(71)*XX(18)-JVS(75)*XX(19)-JVS(79)*XX(20)&
             &-JVS(86)*XX(21)-JVS(94)*XX(23)-JVS(98)*XX(24)-JVS(108)*XX(26)-JVS(114)*XX(27)-JVS(122)*XX(28)-JVS(130)*XX(29)&
             &-JVS(138)*XX(30)-JVS(151)*XX(31)-JVS(159)*XX(32)-JVS(170)*XX(33)-JVS(180)*XX(34)-JVS(194)*XX(35)-JVS(210)&
             &*XX(36)-JVS(249)*XX(37)-JVS(264)*XX(38)-JVS(287)*XX(39)-JVS(303)*XX(40)-JVS(324)*XX(41))/(JVS(363))
  XX(43) = (X(43)-JVS(8)*XX(3)-JVS(28)*XX(9)-JVS(80)*XX(20)-JVS(115)*XX(27)-JVS(152)*XX(31)-JVS(171)*XX(33)-JVS(181)&
             &*XX(34)-JVS(211)*XX(36)-JVS(250)*XX(37)-JVS(265)*XX(38)-JVS(288)*XX(39)-JVS(304)*XX(40)-JVS(325)*XX(41)&
             &-JVS(364)*XX(42))/(JVS(383))
  XX(44) = (X(44)-JVS(9)*XX(3)-JVS(25)*XX(8)-JVS(63)*XX(16)-JVS(67)*XX(17)-JVS(102)*XX(25)-JVS(116)*XX(27)-JVS(131)&
             &*XX(29)-JVS(139)*XX(30)-JVS(172)*XX(33)-JVS(182)*XX(34)-JVS(212)*XX(36)-JVS(251)*XX(37)-JVS(266)*XX(38)&
             &-JVS(289)*XX(39)-JVS(305)*XX(40)-JVS(326)*XX(41)-JVS(365)*XX(42)-JVS(384)*XX(43))/(JVS(413))
  XX(45) = (X(45)-JVS(10)*XX(3)-JVS(40)*XX(11)-JVS(59)*XX(15)-JVS(76)*XX(19)-JVS(153)*XX(31)-JVS(183)*XX(34)-JVS(195)&
             &*XX(35)-JVS(213)*XX(36)-JVS(252)*XX(37)-JVS(267)*XX(38)-JVS(290)*XX(39)-JVS(306)*XX(40)-JVS(327)*XX(41)&
             &-JVS(366)*XX(42)-JVS(385)*XX(43)-JVS(414)*XX(44))/(JVS(435))
  XX(46) = (X(46)-JVS(41)*XX(11)-JVS(90)*XX(22)-JVS(103)*XX(25)-JVS(109)*XX(26)-JVS(132)*XX(29)-JVS(140)*XX(30)-JVS(154)&
             &*XX(31)-JVS(160)*XX(32)-JVS(196)*XX(35)-JVS(214)*XX(36)-JVS(253)*XX(37)-JVS(268)*XX(38)-JVS(291)*XX(39)&
             &-JVS(307)*XX(40)-JVS(328)*XX(41)-JVS(367)*XX(42)-JVS(386)*XX(43)-JVS(415)*XX(44)-JVS(436)*XX(45))/(JVS(451))
  XX(46) = XX(46)
  XX(45) = XX(45)-JVS(450)*XX(46)
  XX(44) = XX(44)-JVS(434)*XX(45)-JVS(449)*XX(46)
  XX(43) = XX(43)-JVS(412)*XX(44)-JVS(433)*XX(45)-JVS(448)*XX(46)
  XX(42) = XX(42)-JVS(382)*XX(43)-JVS(411)*XX(44)-JVS(432)*XX(45)-JVS(447)*XX(46)
  XX(41) = XX(41)-JVS(362)*XX(42)-JVS(381)*XX(43)-JVS(410)*XX(44)-JVS(431)*XX(45)-JVS(446)*XX(46)
  XX(40) = XX(40)-JVS(322)*XX(41)-JVS(361)*XX(42)-JVS(380)*XX(43)-JVS(409)*XX(44)-JVS(430)*XX(45)-JVS(445)*XX(46)
  XX(39) = XX(39)-JVS(300)*XX(40)-JVS(321)*XX(41)-JVS(360)*XX(42)-JVS(379)*XX(43)-JVS(408)*XX(44)-JVS(429)*XX(45)&
             &-JVS(444)*XX(46)
  XX(38) = XX(38)-JVS(283)*XX(39)-JVS(299)*XX(40)-JVS(320)*XX(41)-JVS(359)*XX(42)-JVS(378)*XX(43)-JVS(407)*XX(44)&
             &-JVS(428)*XX(45)-JVS(443)*XX(46)
  XX(37) = XX(37)-JVS(259)*XX(38)-JVS(282)*XX(39)-JVS(298)*XX(40)-JVS(319)*XX(41)-JVS(358)*XX(42)-JVS(377)*XX(43)&
             &-JVS(406)*XX(44)-JVS(427)*XX(45)-JVS(442)*XX(46)
  XX(36) = XX(36)-JVS(243)*XX(37)-JVS(258)*XX(38)-JVS(281)*XX(39)-JVS(318)*XX(41)-JVS(357)*XX(42)-JVS(376)*XX(43)&
             &-JVS(405)*XX(44)-JVS(426)*XX(45)-JVS(441)*XX(46)
  XX(35) = XX(35)-JVS(203)*XX(36)-JVS(242)*XX(37)-JVS(257)*XX(38)-JVS(280)*XX(39)-JVS(356)*XX(42)-JVS(375)*XX(43)&
             &-JVS(404)*XX(44)-JVS(425)*XX(45)-JVS(440)*XX(46)
  XX(34) = XX(34)-JVS(241)*XX(37)-JVS(279)*XX(39)-JVS(297)*XX(40)-JVS(317)*XX(41)-JVS(355)*XX(42)-JVS(374)*XX(43)&
             &-JVS(403)*XX(44)-JVS(424)*XX(45)
  XX(33) = XX(33)-JVS(240)*XX(37)-JVS(354)*XX(42)-JVS(373)*XX(43)-JVS(402)*XX(44)-JVS(423)*XX(45)
  XX(32) = XX(32)-JVS(187)*XX(35)-JVS(202)*XX(36)-JVS(239)*XX(37)-JVS(256)*XX(38)-JVS(353)*XX(42)-JVS(372)*XX(43)&
             &-JVS(401)*XX(44)-JVS(422)*XX(45)-JVS(439)*XX(46)
  XX(31) = XX(31)-JVS(352)*XX(42)-JVS(371)*XX(43)-JVS(400)*XX(44)-JVS(421)*XX(45)
  XX(30) = XX(30)-JVS(238)*XX(37)-JVS(278)*XX(39)-JVS(316)*XX(41)-JVS(351)*XX(42)-JVS(399)*XX(44)-JVS(438)*XX(46)
  XX(29) = XX(29)-JVS(237)*XX(37)-JVS(277)*XX(39)-JVS(315)*XX(41)-JVS(350)*XX(42)-JVS(398)*XX(44)
  XX(28) = XX(28)-JVS(201)*XX(36)-JVS(236)*XX(37)-JVS(314)*XX(41)-JVS(349)*XX(42)-JVS(420)*XX(45)
  XX(27) = XX(27)-JVS(163)*XX(33)-JVS(174)*XX(34)-JVS(235)*XX(37)-JVS(348)*XX(42)-JVS(397)*XX(44)
  XX(26) = XX(26)-JVS(144)*XX(31)-JVS(186)*XX(35)-JVS(234)*XX(37)-JVS(276)*XX(39)-JVS(347)*XX(42)-JVS(396)*XX(44)
  XX(25) = XX(25)-JVS(124)*XX(29)-JVS(134)*XX(30)-JVS(233)*XX(37)-JVS(275)*XX(39)-JVS(346)*XX(42)-JVS(437)*XX(46)
  XX(24) = XX(24)-JVS(162)*XX(33)-JVS(173)*XX(34)-JVS(232)*XX(37)-JVS(296)*XX(40)-JVS(313)*XX(41)-JVS(345)*XX(42)&
             &-JVS(395)*XX(44)
  XX(23) = XX(23)-JVS(200)*XX(36)-JVS(231)*XX(37)-JVS(255)*XX(38)-JVS(295)*XX(40)-JVS(312)*XX(41)-JVS(344)*XX(42)&
             &-JVS(419)*XX(45)
  XX(22) = XX(22)-JVS(104)*XX(26)-JVS(143)*XX(31)-JVS(185)*XX(35)-JVS(230)*XX(37)-JVS(274)*XX(39)-JVS(343)*XX(42)&
             &-JVS(394)*XX(44)
  XX(21) = XX(21)-JVS(229)*XX(37)-JVS(273)*XX(39)-JVS(311)*XX(41)-JVS(342)*XX(42)
  XX(20) = XX(20)-JVS(199)*XX(36)-JVS(228)*XX(37)-JVS(341)*XX(42)-JVS(370)*XX(43)-JVS(393)*XX(44)-JVS(418)*XX(45)
  XX(19) = XX(19)-JVS(227)*XX(37)-JVS(294)*XX(40)-JVS(310)*XX(41)-JVS(340)*XX(42)
  XX(18) = XX(18)-JVS(198)*XX(36)-JVS(226)*XX(37)-JVS(272)*XX(39)-JVS(339)*XX(42)-JVS(417)*XX(45)
  XX(17) = XX(17)-JVS(197)*XX(36)-JVS(225)*XX(37)-JVS(254)*XX(38)-JVS(338)*XX(42)-JVS(416)*XX(45)
  XX(16) = XX(16)-JVS(224)*XX(37)-JVS(293)*XX(40)-JVS(309)*XX(41)-JVS(337)*XX(42)-JVS(392)*XX(44)
  XX(15) = XX(15)-JVS(223)*XX(37)-JVS(336)*XX(42)-JVS(391)*XX(44)
  XX(14) = XX(14)-JVS(123)*XX(29)-JVS(222)*XX(37)-JVS(271)*XX(39)-JVS(335)*XX(42)
  XX(13) = XX(13)-JVS(142)*XX(31)-JVS(184)*XX(35)-JVS(270)*XX(39)
  XX(12) = XX(12)-JVS(50)*XX(14)-JVS(221)*XX(37)-JVS(334)*XX(42)
  XX(11) = XX(11)-JVS(390)*XX(44)
  XX(10) = XX(10)-JVS(161)*XX(33)-JVS(220)*XX(37)-JVS(333)*XX(42)-JVS(389)*XX(44)
  XX(9) = XX(9)-JVS(110)*XX(27)-JVS(219)*XX(37)-JVS(369)*XX(43)
  XX(8) = XX(8)-JVS(218)*XX(37)-JVS(332)*XX(42)-JVS(388)*XX(44)
  XX(7) = XX(7)-JVS(269)*XX(39)
  XX(6) = XX(6)-JVS(292)*XX(40)-JVS(308)*XX(41)
  XX(5) = XX(5)-JVS(155)*XX(32)-JVS(217)*XX(37)-JVS(331)*XX(42)
  XX(4) = XX(4)-JVS(133)*XX(30)-JVS(216)*XX(37)-JVS(330)*XX(42)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)-JVS(141)*XX(31)-JVS(215)*XX(37)-JVS(329)*XX(42)-JVS(368)*XX(43)-JVS(387)*XX(44)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE messy_mecca_kpp_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE messy_mecca_kpp_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE messy_mecca_kpp_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_LinearAlgebra

