! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3_rs3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Jacobian.f90
! Time                 : Tue Aug  7 17:33:28 2018
! Working directory    : /home/sander/e2/messy_d2.53.0.24_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Jacobian

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(226)

! B(1) = dA(1)/dV(22)
  B(1) = RCT(1)*F(1)
! B(3) = dA(2)/dV(35)
  B(3) = RCT(2)*F(1)
! B(5) = dA(3)/dV(11)
  B(5) = RCT(3)*F(1)
! B(7) = dA(4)/dV(42)
  B(7) = RCT(4)*V(46)
! B(8) = dA(4)/dV(46)
  B(8) = RCT(4)*V(42)
! B(9) = dA(5)/dV(15)
  B(9) = RCT(5)*V(42)
! B(10) = dA(5)/dV(42)
  B(10) = RCT(5)*V(15)
! B(11) = dA(6)/dV(44)
  B(11) = RCT(6)*V(46)
! B(12) = dA(6)/dV(46)
  B(12) = RCT(6)*V(44)
! B(13) = dA(7)/dV(42)
  B(13) = RCT(7)*V(44)
! B(14) = dA(7)/dV(44)
  B(14) = RCT(7)*V(42)
! B(15) = dA(8)/dV(44)
  B(15) = RCT(8)*2*V(44)
! B(16) = dA(9)/dV(22)
  B(16) = RCT(9)*V(37)
! B(17) = dA(9)/dV(37)
  B(17) = RCT(9)*V(22)
! B(18) = dA(10)/dV(8)
  B(18) = 1.8e-12*V(42)
! B(19) = dA(10)/dV(42)
  B(19) = 1.8e-12*V(8)
! B(20) = dA(11)/dV(37)
  B(20) = RCT(11)*2*V(37)
! B(21) = dA(12)/dV(9)
  B(21) = 1
! B(22) = dA(13)/dV(22)
  B(22) = RCT(13)*F(2)
! B(24) = dA(14)/dV(39)
  B(24) = RCT(14)*V(46)
! B(25) = dA(14)/dV(46)
  B(25) = RCT(14)*V(39)
! B(26) = dA(15)/dV(41)
  B(26) = RCT(15)*V(46)
! B(27) = dA(15)/dV(46)
  B(27) = RCT(15)*V(41)
! B(28) = dA(16)/dV(39)
  B(28) = RCT(16)*V(40)
! B(29) = dA(16)/dV(40)
  B(29) = RCT(16)*V(39)
! B(30) = dA(17)/dV(40)
  B(30) = RCT(17)*V(41)
! B(31) = dA(17)/dV(41)
  B(31) = RCT(17)*V(40)
! B(32) = dA(18)/dV(6)
  B(32) = RCT(18)
! B(33) = dA(19)/dV(39)
  B(33) = RCT(19)*V(42)
! B(34) = dA(19)/dV(42)
  B(34) = RCT(19)*V(39)
! B(35) = dA(20)/dV(39)
  B(35) = RCT(20)*V(44)
! B(36) = dA(20)/dV(44)
  B(36) = RCT(20)*V(39)
! B(37) = dA(21)/dV(41)
  B(37) = RCT(21)*V(42)
! B(38) = dA(21)/dV(42)
  B(38) = RCT(21)*V(41)
! B(39) = dA(22)/dV(41)
  B(39) = RCT(22)*V(44)
! B(40) = dA(22)/dV(44)
  B(40) = RCT(22)*V(41)
! B(41) = dA(23)/dV(40)
  B(41) = 3.5e-12*V(44)
! B(42) = dA(23)/dV(44)
  B(42) = 3.5e-12*V(40)
! B(43) = dA(24)/dV(21)
  B(43) = RCT(24)*V(42)
! B(44) = dA(24)/dV(42)
  B(44) = RCT(24)*V(21)
! B(45) = dA(25)/dV(19)
  B(45) = RCT(25)*V(42)
! B(46) = dA(25)/dV(42)
  B(46) = RCT(25)*V(19)
! B(47) = dA(26)/dV(16)
  B(47) = RCT(26)
! B(48) = dA(27)/dV(16)
  B(48) = RCT(27)*V(42)
! B(49) = dA(27)/dV(42)
  B(49) = RCT(27)*V(16)
! B(50) = dA(28)/dV(4)
  B(50) = RCT(28)*V(42)
! B(51) = dA(28)/dV(42)
  B(51) = RCT(28)*V(4)
! B(52) = dA(29)/dV(30)
  B(52) = RCT(29)*V(46)
! B(53) = dA(29)/dV(46)
  B(53) = RCT(29)*V(30)
! B(54) = dA(30)/dV(30)
  B(54) = RCT(30)*V(44)
! B(55) = dA(30)/dV(44)
  B(55) = RCT(30)*V(30)
! B(56) = dA(31)/dV(30)
  B(56) = RCT(31)*V(44)
! B(57) = dA(31)/dV(44)
  B(57) = RCT(31)*V(30)
! B(58) = dA(32)/dV(30)
  B(58) = RCT(32)*V(39)
! B(59) = dA(32)/dV(39)
  B(59) = RCT(32)*V(30)
! B(60) = dA(33)/dV(30)
  B(60) = RCT(33)*V(39)
! B(61) = dA(33)/dV(39)
  B(61) = RCT(33)*V(30)
! B(62) = dA(34)/dV(30)
  B(62) = RCT(34)*V(41)
! B(63) = dA(34)/dV(41)
  B(63) = RCT(34)*V(30)
! B(64) = dA(35)/dV(30)
  B(64) = RCT(35)*V(41)
! B(65) = dA(35)/dV(41)
  B(65) = RCT(35)*V(30)
! B(66) = dA(36)/dV(25)
  B(66) = 1.2e-14*V(46)
! B(67) = dA(36)/dV(46)
  B(67) = 1.2e-14*V(25)
! B(68) = dA(37)/dV(25)
  B(68) = 1300
! B(69) = dA(38)/dV(29)
  B(69) = RCT(38)*V(42)
! B(70) = dA(38)/dV(42)
  B(70) = RCT(38)*V(29)
! B(71) = dA(39)/dV(14)
  B(71) = RCT(39)*V(29)
! B(72) = dA(39)/dV(29)
  B(72) = RCT(39)*V(14)
! B(73) = dA(40)/dV(29)
  B(73) = RCT(40)*V(41)
! B(74) = dA(40)/dV(41)
  B(74) = RCT(40)*V(29)
! B(75) = dA(41)/dV(14)
  B(75) = 1.66e-12*V(42)
! B(76) = dA(41)/dV(42)
  B(76) = 1.66e-12*V(14)
! B(77) = dA(42)/dV(12)
  B(77) = RCT(42)*V(42)
! B(78) = dA(42)/dV(42)
  B(78) = RCT(42)*V(12)
! B(79) = dA(43)/dV(29)
  B(79) = RCT(43)*F(1)
! B(81) = dA(44)/dV(5)
  B(81) = RCT(44)*V(42)
! B(82) = dA(44)/dV(42)
  B(82) = RCT(44)*V(5)
! B(83) = dA(45)/dV(20)
  B(83) = RCT(45)*V(42)
! B(84) = dA(45)/dV(42)
  B(84) = RCT(45)*V(20)
! B(85) = dA(46)/dV(38)
  B(85) = RCT(46)*V(44)
! B(86) = dA(46)/dV(44)
  B(86) = RCT(46)*V(38)
! B(87) = dA(47)/dV(38)
  B(87) = RCT(47)*V(44)
! B(88) = dA(47)/dV(44)
  B(88) = RCT(47)*V(38)
! B(89) = dA(48)/dV(38)
  B(89) = RCT(48)*V(39)
! B(90) = dA(48)/dV(39)
  B(90) = RCT(48)*V(38)
! B(91) = dA(49)/dV(38)
  B(91) = RCT(49)*V(39)
! B(92) = dA(49)/dV(39)
  B(92) = RCT(49)*V(38)
! B(93) = dA(50)/dV(38)
  B(93) = 1.2e-12*V(40)
! B(94) = dA(50)/dV(40)
  B(94) = 1.2e-12*V(38)
! B(95) = dA(51)/dV(38)
  B(95) = RCT(51)
! B(96) = dA(52)/dV(38)
  B(96) = RCT(52)
! B(97) = dA(53)/dV(17)
  B(97) = RCT(53)*V(42)
! B(98) = dA(53)/dV(42)
  B(98) = RCT(53)*V(17)
! B(99) = dA(54)/dV(42)
  B(99) = RCT(54)*V(45)
! B(100) = dA(54)/dV(45)
  B(100) = RCT(54)*V(42)
! B(101) = dA(55)/dV(40)
  B(101) = RCT(55)*V(45)
! B(102) = dA(55)/dV(45)
  B(102) = RCT(55)*V(40)
! B(103) = dA(56)/dV(31)
  B(103) = RCT(56)*V(42)
! B(104) = dA(56)/dV(42)
  B(104) = RCT(56)*V(31)
! B(105) = dA(57)/dV(33)
  B(105) = RCT(57)*V(42)
! B(106) = dA(57)/dV(42)
  B(106) = RCT(57)*V(33)
! B(107) = dA(58)/dV(38)
  B(107) = RCT(58)*V(41)
! B(108) = dA(58)/dV(41)
  B(108) = RCT(58)*V(38)
! B(109) = dA(59)/dV(23)
  B(109) = RCT(59)
! B(110) = dA(60)/dV(23)
  B(110) = 3e-14*V(42)
! B(111) = dA(60)/dV(42)
  B(111) = 3e-14*V(23)
! B(112) = dA(61)/dV(28)
  B(112) = RCT(61)*V(42)
! B(113) = dA(61)/dV(42)
  B(113) = RCT(61)*V(28)
! B(114) = dA(62)/dV(36)
  B(114) = RCT(62)
! B(115) = dA(63)/dV(36)
  B(115) = RCT(63)*V(41)
! B(116) = dA(63)/dV(41)
  B(116) = RCT(63)*V(36)
! B(117) = dA(64)/dV(36)
  B(117) = RCT(64)*V(41)
! B(118) = dA(64)/dV(41)
  B(118) = RCT(64)*V(36)
! B(119) = dA(65)/dV(36)
  B(119) = RCT(65)*V(39)
! B(120) = dA(65)/dV(39)
  B(120) = RCT(65)*V(36)
! B(121) = dA(66)/dV(36)
  B(121) = RCT(66)*V(39)
! B(122) = dA(66)/dV(39)
  B(122) = RCT(66)*V(36)
! B(123) = dA(67)/dV(38)
  B(123) = RCT(67)*V(46)
! B(124) = dA(67)/dV(46)
  B(124) = RCT(67)*V(38)
! B(125) = dA(68)/dV(18)
  B(125) = RCT(68)*V(42)
! B(126) = dA(68)/dV(42)
  B(126) = RCT(68)*V(18)
! B(127) = dA(69)/dV(44)
  B(127) = RCT(69)*V(45)
! B(128) = dA(69)/dV(45)
  B(128) = RCT(69)*V(44)
! B(129) = dA(70)/dV(34)
  B(129) = RCT(70)
! B(130) = dA(71)/dV(34)
  B(130) = RCT(71)*V(44)
! B(131) = dA(71)/dV(44)
  B(131) = RCT(71)*V(34)
! B(132) = dA(72)/dV(34)
  B(132) = RCT(72)*V(39)
! B(133) = dA(72)/dV(39)
  B(133) = RCT(72)*V(34)
! B(134) = dA(73)/dV(34)
  B(134) = 1.2e-12*V(40)
! B(135) = dA(73)/dV(40)
  B(135) = 1.2e-12*V(34)
! B(136) = dA(74)/dV(34)
  B(136) = RCT(74)
! B(137) = dA(75)/dV(34)
  B(137) = RCT(75)
! B(138) = dA(76)/dV(27)
  B(138) = RCT(76)*V(42)
! B(139) = dA(76)/dV(42)
  B(139) = RCT(76)*V(27)
! B(140) = dA(77)/dV(27)
  B(140) = RCT(77)*V(42)
! B(141) = dA(77)/dV(42)
  B(141) = RCT(77)*V(27)
! B(142) = dA(78)/dV(10)
  B(142) = RCT(78)*V(42)
! B(143) = dA(78)/dV(42)
  B(143) = RCT(78)*V(10)
! B(144) = dA(79)/dV(38)
  B(144) = 1.4e-10*V(42)
! B(145) = dA(79)/dV(42)
  B(145) = 1.4e-10*V(38)
! B(146) = dA(80)/dV(43)
  B(146) = RCT(80)
! B(147) = dA(81)/dV(37)
  B(147) = RCT(81)*V(43)
! B(148) = dA(81)/dV(43)
  B(148) = RCT(81)*V(37)
! B(149) = dA(82)/dV(9)
  B(149) = 5.2e-12*V(43)
! B(150) = dA(82)/dV(43)
  B(150) = 5.2e-12*V(9)
! B(151) = dA(83)/dV(39)
  B(151) = 6e-14*V(43)
! B(152) = dA(83)/dV(43)
  B(152) = 6e-14*V(39)
! B(153) = dA(84)/dV(41)
  B(153) = RCT(84)*V(43)
! B(154) = dA(84)/dV(43)
  B(154) = RCT(84)*V(41)
! B(155) = dA(85)/dV(31)
  B(155) = 3.6e-14*V(43)
! B(156) = dA(85)/dV(43)
  B(156) = 3.6e-14*V(31)
! B(157) = dA(86)/dV(33)
  B(157) = 1e-10*V(43)
! B(158) = dA(86)/dV(43)
  B(158) = 1e-10*V(33)
! B(159) = dA(87)/dV(43)
  B(159) = 1.7e-12*V(45)
! B(160) = dA(87)/dV(45)
  B(160) = 1.7e-12*V(43)
! B(161) = dA(88)/dV(20)
  B(161) = 5e-12*V(43)
! B(162) = dA(88)/dV(43)
  B(162) = 5e-12*V(20)
! B(163) = dA(89)/dV(38)
  B(163) = 5e-12*V(43)
! B(164) = dA(89)/dV(43)
  B(164) = 5e-12*V(38)
! B(165) = dA(90)/dV(43)
  B(165) = 5e-12*V(44)
! B(166) = dA(90)/dV(44)
  B(166) = 5e-12*V(43)
! B(167) = dA(91)/dV(43)
  B(167) = 1e-12*V(46)
! B(168) = dA(91)/dV(46)
  B(168) = 1e-12*V(43)
! B(169) = dA(92)/dV(43)
  B(169) = 6e-11*2*V(43)
! B(170) = dA(93)/dV(34)
  B(170) = RCT(93)*V(41)
! B(171) = dA(93)/dV(41)
  B(171) = RCT(93)*V(34)
! B(172) = dA(94)/dV(24)
  B(172) = RCT(94)
! B(173) = dA(95)/dV(24)
  B(173) = RCT(95)*V(42)
! B(174) = dA(95)/dV(42)
  B(174) = RCT(95)*V(24)
! B(175) = dA(96)/dV(32)
  B(175) = RCT(96)*F(1)
! B(177) = dA(97)/dV(32)
  B(177) = RCT(97)*V(46)
! B(178) = dA(97)/dV(46)
  B(178) = RCT(97)*V(32)
! B(179) = dA(98)/dV(32)
  B(179) = 1.3e-10*V(35)
! B(180) = dA(98)/dV(35)
  B(180) = 1.3e-10*V(32)
! B(181) = dA(99)/dV(36)
  B(181) = 2.53e-14*V(46)
! B(182) = dA(99)/dV(46)
  B(182) = 2.53e-14*V(36)
! B(183) = dA(100)/dV(35)
  B(183) = 2.5e-11*V(36)
! B(184) = dA(100)/dV(36)
  B(184) = 2.5e-11*V(35)
! B(185) = dA(101)/dV(35)
  B(185) = 4.3e-11*V(38)
! B(186) = dA(101)/dV(38)
  B(186) = 4.3e-11*V(35)
! B(187) = dA(102)/dV(35)
  B(187) = RCT(102)*V(45)
! B(188) = dA(102)/dV(45)
  B(188) = RCT(102)*V(35)
! B(189) = dA(103)/dV(1)
  B(189) = RCT(103)
! B(190) = dA(104)/dV(26)
  B(190) = RCT(104)*V(42)
! B(191) = dA(104)/dV(42)
  B(191) = RCT(104)*V(26)
! B(192) = dA(105)/dV(22)
  B(192) = RCT(105)*V(26)
! B(193) = dA(105)/dV(26)
  B(193) = RCT(105)*V(22)
! B(194) = dA(106)/dV(22)
  B(194) = RCT(106)*V(26)
! B(195) = dA(106)/dV(26)
  B(195) = RCT(106)*V(22)
! B(196) = dA(107)/dV(22)
  B(196) = RCT(107)*V(26)
! B(197) = dA(107)/dV(26)
  B(197) = RCT(107)*V(22)
! B(198) = dA(108)/dV(26)
  B(198) = RCT(108)*V(35)
! B(199) = dA(108)/dV(35)
  B(199) = RCT(108)*V(26)
! B(200) = dA(109)/dV(13)
  B(200) = RCT(109)*F(1)
! B(202) = dA(110)/dV(13)
  B(202) = RCT(110)*F(1)
! B(204) = dA(111)/dV(7)
  B(204) = 7e-15*F(1)
! B(207) = dA(113)/dV(46)
  B(207) = RCT(113)
! B(208) = dA(114)/dV(46)
  B(208) = RCT(114)
! B(209) = dA(115)/dV(8)
  B(209) = RCT(115)
! B(210) = dA(116)/dV(41)
  B(210) = RCT(116)
! B(211) = dA(117)/dV(40)
  B(211) = RCT(117)
! B(212) = dA(118)/dV(40)
  B(212) = RCT(118)
! B(213) = dA(119)/dV(6)
  B(213) = RCT(119)
! B(214) = dA(120)/dV(21)
  B(214) = RCT(120)
! B(215) = dA(121)/dV(19)
  B(215) = RCT(121)
! B(216) = dA(122)/dV(16)
  B(216) = RCT(122)
! B(217) = dA(123)/dV(17)
  B(217) = RCT(123)
! B(218) = dA(124)/dV(45)
  B(218) = RCT(124)
! B(219) = dA(125)/dV(45)
  B(219) = RCT(125)
! B(220) = dA(126)/dV(18)
  B(220) = RCT(126)
! B(221) = dA(127)/dV(28)
  B(221) = RCT(127)
! B(222) = dA(128)/dV(23)
  B(222) = RCT(128)
! B(223) = dA(129)/dV(27)
  B(223) = RCT(129)
! B(224) = dA(130)/dV(38)
  B(224) = RCT(130)
! B(225) = dA(131)/dV(33)
  B(225) = RCT(131)
! B(226) = dA(132)/dV(24)
  B(226) = RCT(132)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = -B(189)
! JVS(2) = Jac_FULL(2,2)
  JVS(2) = 0
! JVS(3) = Jac_FULL(2,30)
  JVS(3) = B(62)
! JVS(4) = Jac_FULL(2,41)
  JVS(4) = B(63)
! JVS(5) = Jac_FULL(3,3)
  JVS(5) = 0
! JVS(6) = Jac_FULL(3,20)
  JVS(6) = 2*B(161)
! JVS(7) = Jac_FULL(3,38)
  JVS(7) = 2*B(163)
! JVS(8) = Jac_FULL(3,43)
  JVS(8) = 2*B(159)+2*B(162)+2*B(164)+B(165)
! JVS(9) = Jac_FULL(3,44)
  JVS(9) = B(166)
! JVS(10) = Jac_FULL(3,45)
  JVS(10) = 2*B(160)
! JVS(11) = Jac_FULL(4,4)
  JVS(11) = -B(50)
! JVS(12) = Jac_FULL(4,42)
  JVS(12) = -B(51)
! JVS(13) = Jac_FULL(5,5)
  JVS(13) = -B(81)
! JVS(14) = Jac_FULL(5,42)
  JVS(14) = -B(82)
! JVS(15) = Jac_FULL(6,6)
  JVS(15) = -B(32)-B(213)
! JVS(16) = Jac_FULL(6,40)
  JVS(16) = B(30)
! JVS(17) = Jac_FULL(6,41)
  JVS(17) = B(31)
! JVS(18) = Jac_FULL(7,7)
  JVS(18) = -B(204)
! JVS(19) = Jac_FULL(7,13)
  JVS(19) = B(200)
! JVS(20) = Jac_FULL(7,22)
  JVS(20) = B(194)
! JVS(21) = Jac_FULL(7,26)
  JVS(21) = B(195)+B(198)
! JVS(22) = Jac_FULL(7,35)
  JVS(22) = B(199)
! JVS(23) = Jac_FULL(8,8)
  JVS(23) = -B(18)-B(209)
! JVS(24) = Jac_FULL(8,42)
  JVS(24) = -B(19)
! JVS(25) = Jac_FULL(8,44)
  JVS(25) = B(15)
! JVS(26) = Jac_FULL(9,9)
  JVS(26) = -B(21)-B(149)
! JVS(27) = Jac_FULL(9,37)
  JVS(27) = B(20)
! JVS(28) = Jac_FULL(9,43)
  JVS(28) = -B(150)
! JVS(29) = Jac_FULL(10,10)
  JVS(29) = -B(142)
! JVS(30) = Jac_FULL(10,34)
  JVS(30) = 0.5*B(137)
! JVS(31) = Jac_FULL(10,42)
  JVS(31) = -B(143)
! JVS(32) = Jac_FULL(11,11)
  JVS(32) = -B(5)
! JVS(33) = Jac_FULL(11,15)
  JVS(33) = B(9)
! JVS(34) = Jac_FULL(11,22)
  JVS(34) = B(194)
! JVS(35) = Jac_FULL(11,26)
  JVS(35) = B(195)+B(198)
! JVS(36) = Jac_FULL(11,31)
  JVS(36) = B(103)
! JVS(37) = Jac_FULL(11,32)
  JVS(37) = 0.956*B(177)+B(179)
! JVS(38) = Jac_FULL(11,35)
  JVS(38) = B(180)+0.3*B(187)+B(199)
! JVS(39) = Jac_FULL(11,42)
  JVS(39) = B(10)+B(104)
! JVS(40) = Jac_FULL(11,45)
  JVS(40) = 0.3*B(188)+B(219)
! JVS(41) = Jac_FULL(11,46)
  JVS(41) = 0.956*B(178)
! JVS(42) = Jac_FULL(12,12)
  JVS(42) = -B(77)
! JVS(43) = Jac_FULL(12,14)
  JVS(43) = B(71)
! JVS(44) = Jac_FULL(12,29)
  JVS(44) = B(72)
! JVS(45) = Jac_FULL(12,42)
  JVS(45) = -B(78)
! JVS(46) = Jac_FULL(13,13)
  JVS(46) = -B(200)-B(202)
! JVS(47) = Jac_FULL(13,22)
  JVS(47) = B(196)
! JVS(48) = Jac_FULL(13,26)
  JVS(48) = B(190)+B(197)
! JVS(49) = Jac_FULL(13,42)
  JVS(49) = B(191)
! JVS(50) = Jac_FULL(14,12)
  JVS(50) = B(77)
! JVS(51) = Jac_FULL(14,14)
  JVS(51) = -B(71)-B(75)
! JVS(52) = Jac_FULL(14,25)
  JVS(52) = B(68)
! JVS(53) = Jac_FULL(14,29)
  JVS(53) = -B(72)
! JVS(54) = Jac_FULL(14,42)
  JVS(54) = -B(76)+B(78)
! JVS(55) = Jac_FULL(15,15)
  JVS(55) = -B(9)
! JVS(56) = Jac_FULL(15,32)
  JVS(56) = 0.17*B(179)
! JVS(57) = Jac_FULL(15,35)
  JVS(57) = 0.17*B(180)
! JVS(58) = Jac_FULL(15,42)
  JVS(58) = -B(10)
! JVS(59) = Jac_FULL(15,45)
  JVS(59) = B(218)
! JVS(60) = Jac_FULL(16,16)
  JVS(60) = -B(47)-B(48)-B(216)
! JVS(61) = Jac_FULL(16,41)
  JVS(61) = B(39)
! JVS(62) = Jac_FULL(16,42)
  JVS(62) = -B(49)
! JVS(63) = Jac_FULL(16,44)
  JVS(63) = B(40)
! JVS(64) = Jac_FULL(17,17)
  JVS(64) = -B(97)-B(217)
! JVS(65) = Jac_FULL(17,38)
  JVS(65) = B(85)
! JVS(66) = Jac_FULL(17,42)
  JVS(66) = -B(98)
! JVS(67) = Jac_FULL(17,44)
  JVS(67) = B(86)
! JVS(68) = Jac_FULL(18,18)
  JVS(68) = -B(125)-B(220)
! JVS(69) = Jac_FULL(18,36)
  JVS(69) = B(119)
! JVS(70) = Jac_FULL(18,39)
  JVS(70) = B(120)
! JVS(71) = Jac_FULL(18,42)
  JVS(71) = -B(126)
! JVS(72) = Jac_FULL(19,19)
  JVS(72) = -B(45)-B(215)
! JVS(73) = Jac_FULL(19,40)
  JVS(73) = B(101)
! JVS(74) = Jac_FULL(19,41)
  JVS(74) = B(37)
! JVS(75) = Jac_FULL(19,42)
  JVS(75) = B(38)-B(46)
! JVS(76) = Jac_FULL(19,45)
  JVS(76) = B(102)
! JVS(77) = Jac_FULL(20,20)
  JVS(77) = -B(83)-B(161)
! JVS(78) = Jac_FULL(20,38)
  JVS(78) = 0.5*B(96)
! JVS(79) = Jac_FULL(20,42)
  JVS(79) = -B(84)
! JVS(80) = Jac_FULL(20,43)
  JVS(80) = -B(162)
! JVS(81) = Jac_FULL(21,21)
  JVS(81) = -B(43)-B(214)
! JVS(82) = Jac_FULL(21,29)
  JVS(82) = B(73)
! JVS(83) = Jac_FULL(21,36)
  JVS(83) = B(117)
! JVS(84) = Jac_FULL(21,39)
  JVS(84) = B(33)
! JVS(85) = Jac_FULL(21,41)
  JVS(85) = B(74)+B(118)
! JVS(86) = Jac_FULL(21,42)
  JVS(86) = B(34)-B(44)
! JVS(87) = Jac_FULL(22,22)
  JVS(87) = -B(1)-B(16)-B(22)-B(192)-B(194)-B(196)
! JVS(88) = Jac_FULL(22,26)
  JVS(88) = -B(193)-B(195)-B(197)
! JVS(89) = Jac_FULL(22,37)
  JVS(89) = -B(17)
! JVS(90) = Jac_FULL(22,46)
  JVS(90) = B(207)
! JVS(91) = Jac_FULL(23,23)
  JVS(91) = -B(109)-B(110)-B(222)
! JVS(92) = Jac_FULL(23,38)
  JVS(92) = B(107)
! JVS(93) = Jac_FULL(23,41)
  JVS(93) = B(108)
! JVS(94) = Jac_FULL(23,42)
  JVS(94) = -B(111)
! JVS(95) = Jac_FULL(24,24)
  JVS(95) = -B(172)-B(173)-B(226)
! JVS(96) = Jac_FULL(24,34)
  JVS(96) = B(170)
! JVS(97) = Jac_FULL(24,41)
  JVS(97) = B(171)
! JVS(98) = Jac_FULL(24,42)
  JVS(98) = -B(174)
! JVS(99) = Jac_FULL(25,25)
  JVS(99) = -B(66)-B(68)
! JVS(100) = Jac_FULL(25,30)
  JVS(100) = B(52)+B(54)+B(64)
! JVS(101) = Jac_FULL(25,41)
  JVS(101) = B(65)
! JVS(102) = Jac_FULL(25,44)
  JVS(102) = B(55)
! JVS(103) = Jac_FULL(25,46)
  JVS(103) = B(53)-B(67)
! JVS(104) = Jac_FULL(26,22)
  JVS(104) = -B(194)-B(196)
! JVS(105) = Jac_FULL(26,26)
  JVS(105) = -B(190)-B(195)-B(197)-B(198)
! JVS(106) = Jac_FULL(26,35)
  JVS(106) = -B(199)
! JVS(107) = Jac_FULL(26,37)
  JVS(107) = 0
! JVS(108) = Jac_FULL(26,42)
  JVS(108) = -B(191)
! JVS(109) = Jac_FULL(26,46)
  JVS(109) = 0
! JVS(110) = Jac_FULL(27,9)
  JVS(110) = B(149)
! JVS(111) = Jac_FULL(27,27)
  JVS(111) = -B(138)-B(140)-B(223)
! JVS(112) = Jac_FULL(27,34)
  JVS(112) = 0.5*B(130)
! JVS(113) = Jac_FULL(27,37)
  JVS(113) = B(147)
! JVS(114) = Jac_FULL(27,42)
  JVS(114) = -B(139)-B(141)
! JVS(115) = Jac_FULL(27,43)
  JVS(115) = B(148)+B(150)
! JVS(116) = Jac_FULL(27,44)
  JVS(116) = 0.5*B(131)
! JVS(117) = Jac_FULL(28,28)
  JVS(117) = -B(112)-B(221)
! JVS(118) = Jac_FULL(28,36)
  JVS(118) = B(115)
! JVS(119) = Jac_FULL(28,38)
  JVS(119) = B(91)
! JVS(120) = Jac_FULL(28,39)
  JVS(120) = B(92)
! JVS(121) = Jac_FULL(28,41)
  JVS(121) = B(116)
! JVS(122) = Jac_FULL(28,42)
  JVS(122) = -B(113)
! JVS(123) = Jac_FULL(29,14)
  JVS(123) = -B(71)+B(75)
! JVS(124) = Jac_FULL(29,25)
  JVS(124) = 0
! JVS(125) = Jac_FULL(29,29)
  JVS(125) = -B(69)-B(72)-B(73)-B(79)
! JVS(126) = Jac_FULL(29,30)
  JVS(126) = B(56)
! JVS(127) = Jac_FULL(29,36)
  JVS(127) = B(121)
! JVS(128) = Jac_FULL(29,39)
  JVS(128) = B(122)
! JVS(129) = Jac_FULL(29,41)
  JVS(129) = -B(74)
! JVS(130) = Jac_FULL(29,42)
  JVS(130) = -B(70)+B(76)
! JVS(131) = Jac_FULL(29,44)
  JVS(131) = B(57)
! JVS(132) = Jac_FULL(29,46)
  JVS(132) = 0
! JVS(133) = Jac_FULL(30,4)
  JVS(133) = B(50)
! JVS(134) = Jac_FULL(30,25)
  JVS(134) = B(66)
! JVS(135) = Jac_FULL(30,30)
  JVS(135) = -B(52)-B(54)-B(56)-B(58)-B(60)-B(62)-B(64)
! JVS(136) = Jac_FULL(30,39)
  JVS(136) = -B(59)-B(61)
! JVS(137) = Jac_FULL(30,41)
  JVS(137) = -B(63)-B(65)
! JVS(138) = Jac_FULL(30,42)
  JVS(138) = B(51)
! JVS(139) = Jac_FULL(30,44)
  JVS(139) = -B(55)-B(57)
! JVS(140) = Jac_FULL(30,46)
  JVS(140) = -B(53)+B(67)
! JVS(141) = Jac_FULL(31,1)
  JVS(141) = 0.63*B(189)
! JVS(142) = Jac_FULL(31,13)
  JVS(142) = B(202)
! JVS(143) = Jac_FULL(31,22)
  JVS(143) = 0
! JVS(144) = Jac_FULL(31,26)
  JVS(144) = 0
! JVS(145) = Jac_FULL(31,31)
  JVS(145) = -B(103)-B(155)
! JVS(146) = Jac_FULL(31,32)
  JVS(146) = 0.17*B(179)
! JVS(147) = Jac_FULL(31,33)
  JVS(147) = B(225)
! JVS(148) = Jac_FULL(31,35)
  JVS(148) = 0.17*B(180)+0.7*B(187)
! JVS(149) = Jac_FULL(31,37)
  JVS(149) = 0
! JVS(150) = Jac_FULL(31,40)
  JVS(150) = B(101)
! JVS(151) = Jac_FULL(31,42)
  JVS(151) = B(99)-B(104)
! JVS(152) = Jac_FULL(31,43)
  JVS(152) = B(146)-B(156)
! JVS(153) = Jac_FULL(31,45)
  JVS(153) = B(100)+B(102)+0.7*B(188)+B(218)+B(219)
! JVS(154) = Jac_FULL(31,46)
  JVS(154) = 0
! JVS(155) = Jac_FULL(32,5)
  JVS(155) = B(81)
! JVS(156) = Jac_FULL(32,32)
  JVS(156) = -B(175)-B(177)-B(179)
! JVS(157) = Jac_FULL(32,35)
  JVS(157) = -B(180)+0.75*B(183)
! JVS(158) = Jac_FULL(32,36)
  JVS(158) = 0.75*B(184)
! JVS(159) = Jac_FULL(32,42)
  JVS(159) = B(82)
! JVS(160) = Jac_FULL(32,46)
  JVS(160) = -B(178)
! JVS(161) = Jac_FULL(33,10)
  JVS(161) = B(142)
! JVS(162) = Jac_FULL(33,24)
  JVS(162) = B(173)+0.333*B(226)
! JVS(163) = Jac_FULL(33,27)
  JVS(163) = B(140)+B(223)
! JVS(164) = Jac_FULL(33,33)
  JVS(164) = -B(105)+B(157)-B(225)
! JVS(165) = Jac_FULL(33,34)
  JVS(165) = 0.5*B(130)+B(132)+B(134)+B(136)+0.5*B(137)
! JVS(166) = Jac_FULL(33,37)
  JVS(166) = 0
! JVS(167) = Jac_FULL(33,39)
  JVS(167) = B(133)
! JVS(168) = Jac_FULL(33,40)
  JVS(168) = B(135)
! JVS(169) = Jac_FULL(33,41)
  JVS(169) = 0
! JVS(170) = Jac_FULL(33,42)
  JVS(170) = -B(106)+B(141)+B(143)+B(174)
! JVS(171) = Jac_FULL(33,43)
  JVS(171) = B(158)
! JVS(172) = Jac_FULL(33,44)
  JVS(172) = 0.5*B(131)
! JVS(173) = Jac_FULL(34,24)
  JVS(173) = B(172)+0.667*B(226)
! JVS(174) = Jac_FULL(34,27)
  JVS(174) = B(138)
! JVS(175) = Jac_FULL(34,34)
  JVS(175) = -B(129)-B(130)-B(132)-B(134)-B(136)-B(137)-B(170)
! JVS(176) = Jac_FULL(34,37)
  JVS(176) = 0
! JVS(177) = Jac_FULL(34,39)
  JVS(177) = -B(133)
! JVS(178) = Jac_FULL(34,40)
  JVS(178) = -B(135)
! JVS(179) = Jac_FULL(34,41)
  JVS(179) = -B(171)
! JVS(180) = Jac_FULL(34,42)
  JVS(180) = B(139)
! JVS(181) = Jac_FULL(34,43)
  JVS(181) = 0
! JVS(182) = Jac_FULL(34,44)
  JVS(182) = B(127)-B(131)
! JVS(183) = Jac_FULL(34,45)
  JVS(183) = B(128)
! JVS(184) = Jac_FULL(35,13)
  JVS(184) = B(200)
! JVS(185) = Jac_FULL(35,22)
  JVS(185) = B(1)+B(22)+B(192)
! JVS(186) = Jac_FULL(35,26)
  JVS(186) = B(193)-B(198)
! JVS(187) = Jac_FULL(35,32)
  JVS(187) = -B(179)
! JVS(188) = Jac_FULL(35,35)
  JVS(188) = -B(3)-B(180)-B(183)-B(185)-B(187)-B(199)
! JVS(189) = Jac_FULL(35,36)
  JVS(189) = -B(184)
! JVS(190) = Jac_FULL(35,37)
  JVS(190) = 0
! JVS(191) = Jac_FULL(35,38)
  JVS(191) = -B(186)
! JVS(192) = Jac_FULL(35,40)
  JVS(192) = B(211)
! JVS(193) = Jac_FULL(35,41)
  JVS(193) = B(210)
! JVS(194) = Jac_FULL(35,42)
  JVS(194) = 0
! JVS(195) = Jac_FULL(35,45)
  JVS(195) = -B(188)
! JVS(196) = Jac_FULL(35,46)
  JVS(196) = B(208)
! JVS(197) = Jac_FULL(36,17)
  JVS(197) = B(217)
! JVS(198) = Jac_FULL(36,18)
  JVS(198) = B(220)
! JVS(199) = Jac_FULL(36,20)
  JVS(199) = 0.15*B(83)
! JVS(200) = Jac_FULL(36,23)
  JVS(200) = 0.333*B(222)
! JVS(201) = Jac_FULL(36,28)
  JVS(201) = B(221)
! JVS(202) = Jac_FULL(36,32)
  JVS(202) = 0.044*B(177)
! JVS(203) = Jac_FULL(36,35)
  JVS(203) = -B(183)+B(185)
! JVS(204) = Jac_FULL(36,36)
  JVS(204) = -B(114)-B(115)-B(117)-B(119)-B(121)-B(181)-B(184)
! JVS(205) = Jac_FULL(36,37)
  JVS(205) = 0
! JVS(206) = Jac_FULL(36,38)
  JVS(206) = B(89)+B(93)+B(95)+B(123)+B(144)+B(186)
! JVS(207) = Jac_FULL(36,39)
  JVS(207) = B(90)-B(120)-B(122)
! JVS(208) = Jac_FULL(36,40)
  JVS(208) = B(94)
! JVS(209) = Jac_FULL(36,41)
  JVS(209) = -B(116)-B(118)
! JVS(210) = Jac_FULL(36,42)
  JVS(210) = 0.15*B(84)+B(145)
! JVS(211) = Jac_FULL(36,43)
  JVS(211) = 0
! JVS(212) = Jac_FULL(36,44)
  JVS(212) = 0
! JVS(213) = Jac_FULL(36,45)
  JVS(213) = 0
! JVS(214) = Jac_FULL(36,46)
  JVS(214) = B(124)+0.044*B(178)-B(182)
! JVS(215) = Jac_FULL(37,1)
  JVS(215) = 0.47*B(189)
! JVS(216) = Jac_FULL(37,4)
  JVS(216) = B(50)
! JVS(217) = Jac_FULL(37,5)
  JVS(217) = B(81)
! JVS(218) = Jac_FULL(37,8)
  JVS(218) = B(18)
! JVS(219) = Jac_FULL(37,9)
  JVS(219) = 2*B(21)+B(149)
! JVS(220) = Jac_FULL(37,10)
  JVS(220) = B(142)
! JVS(221) = Jac_FULL(37,12)
  JVS(221) = B(77)
! JVS(222) = Jac_FULL(37,14)
  JVS(222) = B(75)
! JVS(223) = Jac_FULL(37,15)
  JVS(223) = B(9)
! JVS(224) = Jac_FULL(37,16)
  JVS(224) = B(48)
! JVS(225) = Jac_FULL(37,17)
  JVS(225) = B(97)
! JVS(226) = Jac_FULL(37,18)
  JVS(226) = B(125)
! JVS(227) = Jac_FULL(37,19)
  JVS(227) = B(45)
! JVS(228) = Jac_FULL(37,20)
  JVS(228) = B(83)
! JVS(229) = Jac_FULL(37,21)
  JVS(229) = B(43)
! JVS(230) = Jac_FULL(37,22)
  JVS(230) = -B(16)
! JVS(231) = Jac_FULL(37,23)
  JVS(231) = B(110)
! JVS(232) = Jac_FULL(37,24)
  JVS(232) = B(173)
! JVS(233) = Jac_FULL(37,25)
  JVS(233) = 0
! JVS(234) = Jac_FULL(37,26)
  JVS(234) = B(190)
! JVS(235) = Jac_FULL(37,27)
  JVS(235) = B(138)+B(140)
! JVS(236) = Jac_FULL(37,28)
  JVS(236) = B(112)
! JVS(237) = Jac_FULL(37,29)
  JVS(237) = B(69)
! JVS(238) = Jac_FULL(37,30)
  JVS(238) = B(56)+B(60)+B(62)
! JVS(239) = Jac_FULL(37,32)
  JVS(239) = 0
! JVS(240) = Jac_FULL(37,33)
  JVS(240) = B(105)
! JVS(241) = Jac_FULL(37,34)
  JVS(241) = 0.3*B(130)
! JVS(242) = Jac_FULL(37,35)
  JVS(242) = 0
! JVS(243) = Jac_FULL(37,36)
  JVS(243) = 0
! JVS(244) = Jac_FULL(37,37)
  JVS(244) = -B(17)-2*B(20)-B(147)
! JVS(245) = Jac_FULL(37,38)
  JVS(245) = B(87)
! JVS(246) = Jac_FULL(37,39)
  JVS(246) = B(61)
! JVS(247) = Jac_FULL(37,40)
  JVS(247) = 0
! JVS(248) = Jac_FULL(37,41)
  JVS(248) = B(63)
! JVS(249) = Jac_FULL(37,42)
  JVS(249) = B(10)+B(13)+B(19)+B(44)+B(46)+B(49)+B(51)+B(70)+B(76)+B(78)+B(82)+B(84)+B(98)+B(99)+B(106)+B(111)+B(113)&
               &+B(126)+B(139)+B(141)+B(143)+B(174)+B(191)
! JVS(250) = Jac_FULL(37,43)
  JVS(250) = -B(148)+B(150)
! JVS(251) = Jac_FULL(37,44)
  JVS(251) = B(14)+B(57)+B(88)+0.3*B(131)
! JVS(252) = Jac_FULL(37,45)
  JVS(252) = B(100)
! JVS(253) = Jac_FULL(37,46)
  JVS(253) = 0
! JVS(254) = Jac_FULL(38,17)
  JVS(254) = 0.6*B(97)
! JVS(255) = Jac_FULL(38,23)
  JVS(255) = B(109)+0.667*B(222)
! JVS(256) = Jac_FULL(38,32)
  JVS(256) = B(175)
! JVS(257) = Jac_FULL(38,35)
  JVS(257) = -B(185)
! JVS(258) = Jac_FULL(38,36)
  JVS(258) = B(181)
! JVS(259) = Jac_FULL(38,37)
  JVS(259) = 0
! JVS(260) = Jac_FULL(38,38)
  JVS(260) = -B(85)-B(87)-B(89)-B(91)-B(93)-B(95)-B(96)-B(107)-B(123)-B(144)-B(163)-B(186)-B(224)
! JVS(261) = Jac_FULL(38,39)
  JVS(261) = -B(90)-B(92)
! JVS(262) = Jac_FULL(38,40)
  JVS(262) = -B(94)
! JVS(263) = Jac_FULL(38,41)
  JVS(263) = -B(108)
! JVS(264) = Jac_FULL(38,42)
  JVS(264) = 0.6*B(98)-B(145)
! JVS(265) = Jac_FULL(38,43)
  JVS(265) = -B(164)
! JVS(266) = Jac_FULL(38,44)
  JVS(266) = -B(86)-B(88)
! JVS(267) = Jac_FULL(38,45)
  JVS(267) = 0
! JVS(268) = Jac_FULL(38,46)
  JVS(268) = -B(124)+B(182)
! JVS(269) = Jac_FULL(39,7)
  JVS(269) = B(204)
! JVS(270) = Jac_FULL(39,13)
  JVS(270) = B(202)
! JVS(271) = Jac_FULL(39,14)
  JVS(271) = B(71)
! JVS(272) = Jac_FULL(39,18)
  JVS(272) = B(125)+B(220)
! JVS(273) = Jac_FULL(39,21)
  JVS(273) = B(214)
! JVS(274) = Jac_FULL(39,22)
  JVS(274) = 0
! JVS(275) = Jac_FULL(39,25)
  JVS(275) = 0
! JVS(276) = Jac_FULL(39,26)
  JVS(276) = 0
! JVS(277) = Jac_FULL(39,29)
  JVS(277) = B(69)+B(72)+B(73)+B(79)
! JVS(278) = Jac_FULL(39,30)
  JVS(278) = -B(58)-B(60)+B(64)
! JVS(279) = Jac_FULL(39,34)
  JVS(279) = -B(132)
! JVS(280) = Jac_FULL(39,35)
  JVS(280) = 0
! JVS(281) = Jac_FULL(39,36)
  JVS(281) = -B(119)-B(121)
! JVS(282) = Jac_FULL(39,37)
  JVS(282) = 0
! JVS(283) = Jac_FULL(39,38)
  JVS(283) = -B(89)-B(91)
! JVS(284) = Jac_FULL(39,39)
  JVS(284) = -B(24)-B(28)-B(33)-B(35)-B(59)-B(61)-B(90)-B(92)-B(120)-B(122)-B(133)-B(151)
! JVS(285) = Jac_FULL(39,40)
  JVS(285) = -B(29)+B(212)
! JVS(286) = Jac_FULL(39,41)
  JVS(286) = B(65)+B(74)+B(210)
! JVS(287) = Jac_FULL(39,42)
  JVS(287) = -B(34)+B(70)+B(126)
! JVS(288) = Jac_FULL(39,43)
  JVS(288) = -B(152)
! JVS(289) = Jac_FULL(39,44)
  JVS(289) = -B(36)
! JVS(290) = Jac_FULL(39,45)
  JVS(290) = 0
! JVS(291) = Jac_FULL(39,46)
  JVS(291) = -B(25)
! JVS(292) = Jac_FULL(40,6)
  JVS(292) = B(32)+B(213)
! JVS(293) = Jac_FULL(40,16)
  JVS(293) = 0.333*B(216)
! JVS(294) = Jac_FULL(40,19)
  JVS(294) = B(45)
! JVS(295) = Jac_FULL(40,23)
  JVS(295) = B(110)+0.333*B(222)
! JVS(296) = Jac_FULL(40,24)
  JVS(296) = B(173)+0.333*B(226)
! JVS(297) = Jac_FULL(40,34)
  JVS(297) = -B(134)
! JVS(298) = Jac_FULL(40,37)
  JVS(298) = 0
! JVS(299) = Jac_FULL(40,38)
  JVS(299) = -B(93)
! JVS(300) = Jac_FULL(40,39)
  JVS(300) = -B(28)
! JVS(301) = Jac_FULL(40,40)
  JVS(301) = -B(29)-B(30)-B(41)-B(94)-B(101)-B(135)-B(211)-B(212)
! JVS(302) = Jac_FULL(40,41)
  JVS(302) = B(26)-B(31)+B(153)
! JVS(303) = Jac_FULL(40,42)
  JVS(303) = B(46)+B(111)+B(174)
! JVS(304) = Jac_FULL(40,43)
  JVS(304) = B(154)
! JVS(305) = Jac_FULL(40,44)
  JVS(305) = -B(42)
! JVS(306) = Jac_FULL(40,45)
  JVS(306) = -B(102)
! JVS(307) = Jac_FULL(40,46)
  JVS(307) = B(27)
! JVS(308) = Jac_FULL(41,6)
  JVS(308) = B(32)+B(213)
! JVS(309) = Jac_FULL(41,16)
  JVS(309) = B(47)+B(48)+0.667*B(216)
! JVS(310) = Jac_FULL(41,19)
  JVS(310) = B(215)
! JVS(311) = Jac_FULL(41,21)
  JVS(311) = B(43)
! JVS(312) = Jac_FULL(41,23)
  JVS(312) = B(109)+0.667*B(222)
! JVS(313) = Jac_FULL(41,24)
  JVS(313) = B(172)+0.667*B(226)
! JVS(314) = Jac_FULL(41,28)
  JVS(314) = B(112)+B(221)
! JVS(315) = Jac_FULL(41,29)
  JVS(315) = -B(73)
! JVS(316) = Jac_FULL(41,30)
  JVS(316) = -B(62)-B(64)
! JVS(317) = Jac_FULL(41,34)
  JVS(317) = B(132)+B(134)-B(170)
! JVS(318) = Jac_FULL(41,36)
  JVS(318) = -B(115)-B(117)
! JVS(319) = Jac_FULL(41,37)
  JVS(319) = 0
! JVS(320) = Jac_FULL(41,38)
  JVS(320) = B(89)+B(93)-B(107)
! JVS(321) = Jac_FULL(41,39)
  JVS(321) = B(24)+2*B(28)+B(35)+B(90)+B(133)+B(151)
! JVS(322) = Jac_FULL(41,40)
  JVS(322) = 2*B(29)-B(30)+B(41)+B(94)+B(135)+B(211)
! JVS(323) = Jac_FULL(41,41)
  JVS(323) = -B(26)-B(31)-B(37)-B(39)-B(63)-B(65)-B(74)-B(108)-B(116)-B(118)-B(153)-B(171)-B(210)
! JVS(324) = Jac_FULL(41,42)
  JVS(324) = -B(38)+B(44)+B(49)+B(113)
! JVS(325) = Jac_FULL(41,43)
  JVS(325) = B(152)-B(154)
! JVS(326) = Jac_FULL(41,44)
  JVS(326) = B(36)-B(40)+B(42)
! JVS(327) = Jac_FULL(41,45)
  JVS(327) = 0
! JVS(328) = Jac_FULL(41,46)
  JVS(328) = B(25)-B(27)
! JVS(329) = Jac_FULL(42,1)
  JVS(329) = 0.16*B(189)
! JVS(330) = Jac_FULL(42,4)
  JVS(330) = -B(50)
! JVS(331) = Jac_FULL(42,5)
  JVS(331) = -B(81)
! JVS(332) = Jac_FULL(42,8)
  JVS(332) = -B(18)+2*B(209)
! JVS(333) = Jac_FULL(42,10)
  JVS(333) = -B(142)
! JVS(334) = Jac_FULL(42,12)
  JVS(334) = -B(77)
! JVS(335) = Jac_FULL(42,14)
  JVS(335) = -B(75)
! JVS(336) = Jac_FULL(42,15)
  JVS(336) = -B(9)
! JVS(337) = Jac_FULL(42,16)
  JVS(337) = -B(48)+0.333*B(216)
! JVS(338) = Jac_FULL(42,17)
  JVS(338) = -0.6*B(97)+B(217)
! JVS(339) = Jac_FULL(42,18)
  JVS(339) = -B(125)
! JVS(340) = Jac_FULL(42,19)
  JVS(340) = -B(45)+B(215)
! JVS(341) = Jac_FULL(42,20)
  JVS(341) = -B(83)
! JVS(342) = Jac_FULL(42,21)
  JVS(342) = -B(43)+B(214)
! JVS(343) = Jac_FULL(42,22)
  JVS(343) = 2*B(16)+B(196)
! JVS(344) = Jac_FULL(42,23)
  JVS(344) = -B(110)
! JVS(345) = Jac_FULL(42,24)
  JVS(345) = -B(173)
! JVS(346) = Jac_FULL(42,25)
  JVS(346) = 0
! JVS(347) = Jac_FULL(42,26)
  JVS(347) = -B(190)+B(197)
! JVS(348) = Jac_FULL(42,27)
  JVS(348) = -B(138)+B(223)
! JVS(349) = Jac_FULL(42,28)
  JVS(349) = -B(112)
! JVS(350) = Jac_FULL(42,29)
  JVS(350) = -B(69)
! JVS(351) = Jac_FULL(42,30)
  JVS(351) = B(54)+B(58)
! JVS(352) = Jac_FULL(42,31)
  JVS(352) = -B(103)
! JVS(353) = Jac_FULL(42,32)
  JVS(353) = 0
! JVS(354) = Jac_FULL(42,33)
  JVS(354) = -B(105)+B(225)
! JVS(355) = Jac_FULL(42,34)
  JVS(355) = 0.2*B(130)
! JVS(356) = Jac_FULL(42,35)
  JVS(356) = 0.25*B(183)+0.7*B(187)
! JVS(357) = Jac_FULL(42,36)
  JVS(357) = 0.25*B(184)
! JVS(358) = Jac_FULL(42,37)
  JVS(358) = 2*B(17)
! JVS(359) = Jac_FULL(42,38)
  JVS(359) = -B(144)+B(224)
! JVS(360) = Jac_FULL(42,39)
  JVS(360) = -B(33)+B(35)+B(59)
! JVS(361) = Jac_FULL(42,40)
  JVS(361) = B(41)
! JVS(362) = Jac_FULL(42,41)
  JVS(362) = -B(37)
! JVS(363) = Jac_FULL(42,42)
  JVS(363) = -B(7)-B(10)-B(13)-B(19)-B(34)-B(38)-B(44)-B(46)-B(49)-B(51)-B(70)-B(76)-B(78)-B(82)-B(84)-0.6*B(98)-B(99)&
               &-B(104)-B(106)-B(111)-B(113)-B(126)-B(139)-B(143)-B(145)-B(174)-B(191)
! JVS(364) = Jac_FULL(42,43)
  JVS(364) = B(146)
! JVS(365) = Jac_FULL(42,44)
  JVS(365) = B(11)-B(14)+B(36)+B(42)+B(55)+0.2*B(131)
! JVS(366) = Jac_FULL(42,45)
  JVS(366) = -B(100)+0.7*B(188)
! JVS(367) = Jac_FULL(42,46)
  JVS(367) = -B(8)+B(12)
! JVS(368) = Jac_FULL(43,1)
  JVS(368) = 0.37*B(189)
! JVS(369) = Jac_FULL(43,9)
  JVS(369) = -B(149)
! JVS(370) = Jac_FULL(43,20)
  JVS(370) = -B(161)
! JVS(371) = Jac_FULL(43,31)
  JVS(371) = -B(155)
! JVS(372) = Jac_FULL(43,32)
  JVS(372) = 0
! JVS(373) = Jac_FULL(43,33)
  JVS(373) = -B(157)
! JVS(374) = Jac_FULL(43,34)
  JVS(374) = 0
! JVS(375) = Jac_FULL(43,35)
  JVS(375) = 0
! JVS(376) = Jac_FULL(43,36)
  JVS(376) = 0
! JVS(377) = Jac_FULL(43,37)
  JVS(377) = -B(147)
! JVS(378) = Jac_FULL(43,38)
  JVS(378) = -B(163)
! JVS(379) = Jac_FULL(43,39)
  JVS(379) = -B(151)
! JVS(380) = Jac_FULL(43,40)
  JVS(380) = 0
! JVS(381) = Jac_FULL(43,41)
  JVS(381) = -B(153)
! JVS(382) = Jac_FULL(43,42)
  JVS(382) = 0
! JVS(383) = Jac_FULL(43,43)
  JVS(383) = -B(146)-B(148)-B(150)-B(152)-B(154)-B(156)-B(158)-B(159)-B(162)-B(164)-B(165)-B(167)-2*B(169)
! JVS(384) = Jac_FULL(43,44)
  JVS(384) = -B(166)
! JVS(385) = Jac_FULL(43,45)
  JVS(385) = -B(160)
! JVS(386) = Jac_FULL(43,46)
  JVS(386) = -B(168)
! JVS(387) = Jac_FULL(44,1)
  JVS(387) = 0.16*B(189)
! JVS(388) = Jac_FULL(44,8)
  JVS(388) = B(18)
! JVS(389) = Jac_FULL(44,10)
  JVS(389) = B(142)
! JVS(390) = Jac_FULL(44,11)
  JVS(390) = B(5)
! JVS(391) = Jac_FULL(44,15)
  JVS(391) = 0
! JVS(392) = Jac_FULL(44,16)
  JVS(392) = B(47)+0.667*B(216)
! JVS(393) = Jac_FULL(44,20)
  JVS(393) = 0.85*B(83)
! JVS(394) = Jac_FULL(44,22)
  JVS(394) = 0
! JVS(395) = Jac_FULL(44,24)
  JVS(395) = 0.333*B(226)
! JVS(396) = Jac_FULL(44,26)
  JVS(396) = 0
! JVS(397) = Jac_FULL(44,27)
  JVS(397) = B(223)
! JVS(398) = Jac_FULL(44,29)
  JVS(398) = B(79)
! JVS(399) = Jac_FULL(44,30)
  JVS(399) = -B(54)-B(56)+B(58)
! JVS(400) = Jac_FULL(44,31)
  JVS(400) = 0
! JVS(401) = Jac_FULL(44,32)
  JVS(401) = 0
! JVS(402) = Jac_FULL(44,33)
  JVS(402) = B(105)+B(225)
! JVS(403) = Jac_FULL(44,34)
  JVS(403) = B(129)-0.8*B(130)+B(132)+B(134)+B(136)
! JVS(404) = Jac_FULL(44,35)
  JVS(404) = B(187)
! JVS(405) = Jac_FULL(44,36)
  JVS(405) = B(114)
! JVS(406) = Jac_FULL(44,37)
  JVS(406) = 0
! JVS(407) = Jac_FULL(44,38)
  JVS(407) = -B(85)-B(87)+B(144)
! JVS(408) = Jac_FULL(44,39)
  JVS(408) = -B(35)+B(59)+B(133)
! JVS(409) = Jac_FULL(44,40)
  JVS(409) = -B(41)+B(101)+B(135)
! JVS(410) = Jac_FULL(44,41)
  JVS(410) = -B(39)
! JVS(411) = Jac_FULL(44,42)
  JVS(411) = B(7)-B(13)+B(19)+0.85*B(84)+B(99)+B(106)+B(143)+B(145)
! JVS(412) = Jac_FULL(44,43)
  JVS(412) = B(146)-B(165)
! JVS(413) = Jac_FULL(44,44)
  JVS(413) = -B(11)-B(14)-2*B(15)-B(36)-B(40)-B(42)-B(55)-B(57)-B(86)-B(88)-B(127)-0.8*B(131)-B(166)
! JVS(414) = Jac_FULL(44,45)
  JVS(414) = B(100)+B(102)-B(128)+B(188)+B(219)
! JVS(415) = Jac_FULL(44,46)
  JVS(415) = B(8)-B(12)
! JVS(416) = Jac_FULL(45,17)
  JVS(416) = 0.4*B(97)
! JVS(417) = Jac_FULL(45,18)
  JVS(417) = B(125)
! JVS(418) = Jac_FULL(45,20)
  JVS(418) = 0.85*B(83)
! JVS(419) = Jac_FULL(45,23)
  JVS(419) = B(110)
! JVS(420) = Jac_FULL(45,28)
  JVS(420) = B(112)
! JVS(421) = Jac_FULL(45,31)
  JVS(421) = B(155)
! JVS(422) = Jac_FULL(45,32)
  JVS(422) = 0.956*B(177)+0.83*B(179)
! JVS(423) = Jac_FULL(45,33)
  JVS(423) = 0
! JVS(424) = Jac_FULL(45,34)
  JVS(424) = B(129)
! JVS(425) = Jac_FULL(45,35)
  JVS(425) = 0.83*B(180)+0.25*B(183)-B(187)
! JVS(426) = Jac_FULL(45,36)
  JVS(426) = B(114)+B(117)+B(121)+0.25*B(184)
! JVS(427) = Jac_FULL(45,37)
  JVS(427) = 0
! JVS(428) = Jac_FULL(45,38)
  JVS(428) = B(87)+0.5*B(96)+B(224)
! JVS(429) = Jac_FULL(45,39)
  JVS(429) = B(122)+B(151)
! JVS(430) = Jac_FULL(45,40)
  JVS(430) = -B(101)
! JVS(431) = Jac_FULL(45,41)
  JVS(431) = B(118)+B(153)
! JVS(432) = Jac_FULL(45,42)
  JVS(432) = 0.85*B(84)+0.4*B(98)-B(99)+B(111)+B(113)+B(126)
! JVS(433) = Jac_FULL(45,43)
  JVS(433) = B(152)+B(154)+B(156)-B(159)+B(167)+2*B(169)
! JVS(434) = Jac_FULL(45,44)
  JVS(434) = B(88)-B(127)
! JVS(435) = Jac_FULL(45,45)
  JVS(435) = -B(100)-B(102)-B(128)-B(160)-B(188)-B(218)-B(219)
! JVS(436) = Jac_FULL(45,46)
  JVS(436) = B(168)+0.956*B(178)
! JVS(437) = Jac_FULL(46,25)
  JVS(437) = -B(66)
! JVS(438) = Jac_FULL(46,30)
  JVS(438) = -B(52)
! JVS(439) = Jac_FULL(46,32)
  JVS(439) = -B(177)
! JVS(440) = Jac_FULL(46,35)
  JVS(440) = B(3)
! JVS(441) = Jac_FULL(46,36)
  JVS(441) = -B(181)
! JVS(442) = Jac_FULL(46,37)
  JVS(442) = 0
! JVS(443) = Jac_FULL(46,38)
  JVS(443) = -B(123)
! JVS(444) = Jac_FULL(46,39)
  JVS(444) = -B(24)
! JVS(445) = Jac_FULL(46,40)
  JVS(445) = 0
! JVS(446) = Jac_FULL(46,41)
  JVS(446) = -B(26)
! JVS(447) = Jac_FULL(46,42)
  JVS(447) = -B(7)
! JVS(448) = Jac_FULL(46,43)
  JVS(448) = -B(167)
! JVS(449) = Jac_FULL(46,44)
  JVS(449) = -B(11)
! JVS(450) = Jac_FULL(46,45)
  JVS(450) = 0
! JVS(451) = Jac_FULL(46,46)
  JVS(451) = -B(8)-B(12)-B(25)-B(27)-B(53)-B(67)-B(124)-B(168)-B(178)-B(182)-B(207)-B(208)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)
  JUV(2) = JVS(2)*UV(2)+JVS(3)*UV(30)+JVS(4)*UV(41)
  JUV(3) = JVS(5)*UV(3)+JVS(6)*UV(20)+JVS(7)*UV(38)+JVS(8)*UV(43)+JVS(9)*UV(44)+JVS(10)*UV(45)
  JUV(4) = JVS(11)*UV(4)+JVS(12)*UV(42)
  JUV(5) = JVS(13)*UV(5)+JVS(14)*UV(42)
  JUV(6) = JVS(15)*UV(6)+JVS(16)*UV(40)+JVS(17)*UV(41)
  JUV(7) = JVS(18)*UV(7)+JVS(19)*UV(13)+JVS(20)*UV(22)+JVS(21)*UV(26)+JVS(22)*UV(35)
  JUV(8) = JVS(23)*UV(8)+JVS(24)*UV(42)+JVS(25)*UV(44)
  JUV(9) = JVS(26)*UV(9)+JVS(27)*UV(37)+JVS(28)*UV(43)
  JUV(10) = JVS(29)*UV(10)+JVS(30)*UV(34)+JVS(31)*UV(42)
  JUV(11) = JVS(32)*UV(11)+JVS(33)*UV(15)+JVS(34)*UV(22)+JVS(35)*UV(26)+JVS(36)*UV(31)+JVS(37)*UV(32)+JVS(38)*UV(35)&
              &+JVS(39)*UV(42)+JVS(40)*UV(45)+JVS(41)*UV(46)
  JUV(12) = JVS(42)*UV(12)+JVS(43)*UV(14)+JVS(44)*UV(29)+JVS(45)*UV(42)
  JUV(13) = JVS(46)*UV(13)+JVS(47)*UV(22)+JVS(48)*UV(26)+JVS(49)*UV(42)
  JUV(14) = JVS(50)*UV(12)+JVS(51)*UV(14)+JVS(52)*UV(25)+JVS(53)*UV(29)+JVS(54)*UV(42)
  JUV(15) = JVS(55)*UV(15)+JVS(56)*UV(32)+JVS(57)*UV(35)+JVS(58)*UV(42)+JVS(59)*UV(45)
  JUV(16) = JVS(60)*UV(16)+JVS(61)*UV(41)+JVS(62)*UV(42)+JVS(63)*UV(44)
  JUV(17) = JVS(64)*UV(17)+JVS(65)*UV(38)+JVS(66)*UV(42)+JVS(67)*UV(44)
  JUV(18) = JVS(68)*UV(18)+JVS(69)*UV(36)+JVS(70)*UV(39)+JVS(71)*UV(42)
  JUV(19) = JVS(72)*UV(19)+JVS(73)*UV(40)+JVS(74)*UV(41)+JVS(75)*UV(42)+JVS(76)*UV(45)
  JUV(20) = JVS(77)*UV(20)+JVS(78)*UV(38)+JVS(79)*UV(42)+JVS(80)*UV(43)
  JUV(21) = JVS(81)*UV(21)+JVS(82)*UV(29)+JVS(83)*UV(36)+JVS(84)*UV(39)+JVS(85)*UV(41)+JVS(86)*UV(42)
  JUV(22) = JVS(87)*UV(22)+JVS(88)*UV(26)+JVS(89)*UV(37)+JVS(90)*UV(46)
  JUV(23) = JVS(91)*UV(23)+JVS(92)*UV(38)+JVS(93)*UV(41)+JVS(94)*UV(42)
  JUV(24) = JVS(95)*UV(24)+JVS(96)*UV(34)+JVS(97)*UV(41)+JVS(98)*UV(42)
  JUV(25) = JVS(99)*UV(25)+JVS(100)*UV(30)+JVS(101)*UV(41)+JVS(102)*UV(44)+JVS(103)*UV(46)
  JUV(26) = JVS(104)*UV(22)+JVS(105)*UV(26)+JVS(106)*UV(35)+JVS(108)*UV(42)
  JUV(27) = JVS(110)*UV(9)+JVS(111)*UV(27)+JVS(112)*UV(34)+JVS(113)*UV(37)+JVS(114)*UV(42)+JVS(115)*UV(43)+JVS(116)&
              &*UV(44)
  JUV(28) = JVS(117)*UV(28)+JVS(118)*UV(36)+JVS(119)*UV(38)+JVS(120)*UV(39)+JVS(121)*UV(41)+JVS(122)*UV(42)
  JUV(29) = JVS(123)*UV(14)+JVS(125)*UV(29)+JVS(126)*UV(30)+JVS(127)*UV(36)+JVS(128)*UV(39)+JVS(129)*UV(41)+JVS(130)&
              &*UV(42)+JVS(131)*UV(44)
  JUV(30) = JVS(133)*UV(4)+JVS(134)*UV(25)+JVS(135)*UV(30)+JVS(136)*UV(39)+JVS(137)*UV(41)+JVS(138)*UV(42)+JVS(139)&
              &*UV(44)+JVS(140)*UV(46)
  JUV(31) = JVS(141)*UV(1)+JVS(142)*UV(13)+JVS(145)*UV(31)+JVS(146)*UV(32)+JVS(147)*UV(33)+JVS(148)*UV(35)+JVS(150)&
              &*UV(40)+JVS(151)*UV(42)+JVS(152)*UV(43)+JVS(153)*UV(45)
  JUV(32) = JVS(155)*UV(5)+JVS(156)*UV(32)+JVS(157)*UV(35)+JVS(158)*UV(36)+JVS(159)*UV(42)+JVS(160)*UV(46)
  JUV(33) = JVS(161)*UV(10)+JVS(162)*UV(24)+JVS(163)*UV(27)+JVS(164)*UV(33)+JVS(165)*UV(34)+JVS(167)*UV(39)+JVS(168)&
              &*UV(40)+JVS(170)*UV(42)+JVS(171)*UV(43)+JVS(172)*UV(44)
  JUV(34) = JVS(173)*UV(24)+JVS(174)*UV(27)+JVS(175)*UV(34)+JVS(177)*UV(39)+JVS(178)*UV(40)+JVS(179)*UV(41)+JVS(180)&
              &*UV(42)+JVS(182)*UV(44)+JVS(183)*UV(45)
  JUV(35) = JVS(184)*UV(13)+JVS(185)*UV(22)+JVS(186)*UV(26)+JVS(187)*UV(32)+JVS(188)*UV(35)+JVS(189)*UV(36)+JVS(191)&
              &*UV(38)+JVS(192)*UV(40)+JVS(193)*UV(41)+JVS(195)*UV(45)+JVS(196)*UV(46)
  JUV(36) = JVS(197)*UV(17)+JVS(198)*UV(18)+JVS(199)*UV(20)+JVS(200)*UV(23)+JVS(201)*UV(28)+JVS(202)*UV(32)+JVS(203)&
              &*UV(35)+JVS(204)*UV(36)+JVS(206)*UV(38)+JVS(207)*UV(39)+JVS(208)*UV(40)+JVS(209)*UV(41)+JVS(210)*UV(42)&
              &+JVS(214)*UV(46)
  JUV(37) = JVS(215)*UV(1)+JVS(216)*UV(4)+JVS(217)*UV(5)+JVS(218)*UV(8)+JVS(219)*UV(9)+JVS(220)*UV(10)+JVS(221)*UV(12)&
              &+JVS(222)*UV(14)+JVS(223)*UV(15)+JVS(224)*UV(16)+JVS(225)*UV(17)+JVS(226)*UV(18)+JVS(227)*UV(19)+JVS(228)&
              &*UV(20)+JVS(229)*UV(21)+JVS(230)*UV(22)+JVS(231)*UV(23)+JVS(232)*UV(24)+JVS(234)*UV(26)+JVS(235)*UV(27)&
              &+JVS(236)*UV(28)+JVS(237)*UV(29)+JVS(238)*UV(30)+JVS(240)*UV(33)+JVS(241)*UV(34)+JVS(244)*UV(37)+JVS(245)&
              &*UV(38)+JVS(246)*UV(39)+JVS(248)*UV(41)+JVS(249)*UV(42)+JVS(250)*UV(43)+JVS(251)*UV(44)+JVS(252)*UV(45)
  JUV(38) = JVS(254)*UV(17)+JVS(255)*UV(23)+JVS(256)*UV(32)+JVS(257)*UV(35)+JVS(258)*UV(36)+JVS(260)*UV(38)+JVS(261)&
              &*UV(39)+JVS(262)*UV(40)+JVS(263)*UV(41)+JVS(264)*UV(42)+JVS(265)*UV(43)+JVS(266)*UV(44)+JVS(268)*UV(46)
  JUV(39) = JVS(269)*UV(7)+JVS(270)*UV(13)+JVS(271)*UV(14)+JVS(272)*UV(18)+JVS(273)*UV(21)+JVS(277)*UV(29)+JVS(278)&
              &*UV(30)+JVS(279)*UV(34)+JVS(281)*UV(36)+JVS(283)*UV(38)+JVS(284)*UV(39)+JVS(285)*UV(40)+JVS(286)*UV(41)&
              &+JVS(287)*UV(42)+JVS(288)*UV(43)+JVS(289)*UV(44)+JVS(291)*UV(46)
  JUV(40) = JVS(292)*UV(6)+JVS(293)*UV(16)+JVS(294)*UV(19)+JVS(295)*UV(23)+JVS(296)*UV(24)+JVS(297)*UV(34)+JVS(299)&
              &*UV(38)+JVS(300)*UV(39)+JVS(301)*UV(40)+JVS(302)*UV(41)+JVS(303)*UV(42)+JVS(304)*UV(43)+JVS(305)*UV(44)&
              &+JVS(306)*UV(45)+JVS(307)*UV(46)
  JUV(41) = JVS(308)*UV(6)+JVS(309)*UV(16)+JVS(310)*UV(19)+JVS(311)*UV(21)+JVS(312)*UV(23)+JVS(313)*UV(24)+JVS(314)&
              &*UV(28)+JVS(315)*UV(29)+JVS(316)*UV(30)+JVS(317)*UV(34)+JVS(318)*UV(36)+JVS(320)*UV(38)+JVS(321)*UV(39)&
              &+JVS(322)*UV(40)+JVS(323)*UV(41)+JVS(324)*UV(42)+JVS(325)*UV(43)+JVS(326)*UV(44)+JVS(328)*UV(46)
  JUV(42) = JVS(329)*UV(1)+JVS(330)*UV(4)+JVS(331)*UV(5)+JVS(332)*UV(8)+JVS(333)*UV(10)+JVS(334)*UV(12)+JVS(335)*UV(14)&
              &+JVS(336)*UV(15)+JVS(337)*UV(16)+JVS(338)*UV(17)+JVS(339)*UV(18)+JVS(340)*UV(19)+JVS(341)*UV(20)+JVS(342)&
              &*UV(21)+JVS(343)*UV(22)+JVS(344)*UV(23)+JVS(345)*UV(24)+JVS(347)*UV(26)+JVS(348)*UV(27)+JVS(349)*UV(28)&
              &+JVS(350)*UV(29)+JVS(351)*UV(30)+JVS(352)*UV(31)+JVS(354)*UV(33)+JVS(355)*UV(34)+JVS(356)*UV(35)+JVS(357)&
              &*UV(36)+JVS(358)*UV(37)+JVS(359)*UV(38)+JVS(360)*UV(39)+JVS(361)*UV(40)+JVS(362)*UV(41)+JVS(363)*UV(42)&
              &+JVS(364)*UV(43)+JVS(365)*UV(44)+JVS(366)*UV(45)+JVS(367)*UV(46)
  JUV(43) = JVS(368)*UV(1)+JVS(369)*UV(9)+JVS(370)*UV(20)+JVS(371)*UV(31)+JVS(373)*UV(33)+JVS(377)*UV(37)+JVS(378)&
              &*UV(38)+JVS(379)*UV(39)+JVS(381)*UV(41)+JVS(383)*UV(43)+JVS(384)*UV(44)+JVS(385)*UV(45)+JVS(386)*UV(46)
  JUV(44) = JVS(387)*UV(1)+JVS(388)*UV(8)+JVS(389)*UV(10)+JVS(390)*UV(11)+JVS(392)*UV(16)+JVS(393)*UV(20)+JVS(395)&
              &*UV(24)+JVS(397)*UV(27)+JVS(398)*UV(29)+JVS(399)*UV(30)+JVS(402)*UV(33)+JVS(403)*UV(34)+JVS(404)*UV(35)&
              &+JVS(405)*UV(36)+JVS(407)*UV(38)+JVS(408)*UV(39)+JVS(409)*UV(40)+JVS(410)*UV(41)+JVS(411)*UV(42)+JVS(412)&
              &*UV(43)+JVS(413)*UV(44)+JVS(414)*UV(45)+JVS(415)*UV(46)
  JUV(45) = JVS(416)*UV(17)+JVS(417)*UV(18)+JVS(418)*UV(20)+JVS(419)*UV(23)+JVS(420)*UV(28)+JVS(421)*UV(31)+JVS(422)&
              &*UV(32)+JVS(424)*UV(34)+JVS(425)*UV(35)+JVS(426)*UV(36)+JVS(428)*UV(38)+JVS(429)*UV(39)+JVS(430)*UV(40)&
              &+JVS(431)*UV(41)+JVS(432)*UV(42)+JVS(433)*UV(43)+JVS(434)*UV(44)+JVS(435)*UV(45)+JVS(436)*UV(46)
  JUV(46) = JVS(437)*UV(25)+JVS(438)*UV(30)+JVS(439)*UV(32)+JVS(440)*UV(35)+JVS(441)*UV(36)+JVS(443)*UV(38)+JVS(444)&
              &*UV(39)+JVS(446)*UV(41)+JVS(447)*UV(42)+JVS(448)*UV(43)+JVS(449)*UV(44)+JVS(451)*UV(46)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)+JVS(141)*UV(31)+JVS(215)*UV(37)+JVS(329)*UV(42)+JVS(368)*UV(43)+JVS(387)*UV(44)
  JTUV(2) = JVS(2)*UV(2)
  JTUV(3) = JVS(5)*UV(3)
  JTUV(4) = JVS(11)*UV(4)+JVS(133)*UV(30)+JVS(216)*UV(37)+JVS(330)*UV(42)
  JTUV(5) = JVS(13)*UV(5)+JVS(155)*UV(32)+JVS(217)*UV(37)+JVS(331)*UV(42)
  JTUV(6) = JVS(15)*UV(6)+JVS(292)*UV(40)+JVS(308)*UV(41)
  JTUV(7) = JVS(18)*UV(7)+JVS(269)*UV(39)
  JTUV(8) = JVS(23)*UV(8)+JVS(218)*UV(37)+JVS(332)*UV(42)+JVS(388)*UV(44)
  JTUV(9) = JVS(26)*UV(9)+JVS(110)*UV(27)+JVS(219)*UV(37)+JVS(369)*UV(43)
  JTUV(10) = JVS(29)*UV(10)+JVS(161)*UV(33)+JVS(220)*UV(37)+JVS(333)*UV(42)+JVS(389)*UV(44)
  JTUV(11) = JVS(32)*UV(11)+JVS(390)*UV(44)
  JTUV(12) = JVS(42)*UV(12)+JVS(50)*UV(14)+JVS(221)*UV(37)+JVS(334)*UV(42)
  JTUV(13) = JVS(19)*UV(7)+JVS(46)*UV(13)+JVS(142)*UV(31)+JVS(184)*UV(35)+JVS(270)*UV(39)
  JTUV(14) = JVS(43)*UV(12)+JVS(51)*UV(14)+JVS(123)*UV(29)+JVS(222)*UV(37)+JVS(271)*UV(39)+JVS(335)*UV(42)
  JTUV(15) = JVS(33)*UV(11)+JVS(55)*UV(15)+JVS(223)*UV(37)+JVS(336)*UV(42)
  JTUV(16) = JVS(60)*UV(16)+JVS(224)*UV(37)+JVS(293)*UV(40)+JVS(309)*UV(41)+JVS(337)*UV(42)+JVS(392)*UV(44)
  JTUV(17) = JVS(64)*UV(17)+JVS(197)*UV(36)+JVS(225)*UV(37)+JVS(254)*UV(38)+JVS(338)*UV(42)+JVS(416)*UV(45)
  JTUV(18) = JVS(68)*UV(18)+JVS(198)*UV(36)+JVS(226)*UV(37)+JVS(272)*UV(39)+JVS(339)*UV(42)+JVS(417)*UV(45)
  JTUV(19) = JVS(72)*UV(19)+JVS(227)*UV(37)+JVS(294)*UV(40)+JVS(310)*UV(41)+JVS(340)*UV(42)
  JTUV(20) = JVS(6)*UV(3)+JVS(77)*UV(20)+JVS(199)*UV(36)+JVS(228)*UV(37)+JVS(341)*UV(42)+JVS(370)*UV(43)+JVS(393)*UV(44)&
               &+JVS(418)*UV(45)
  JTUV(21) = JVS(81)*UV(21)+JVS(229)*UV(37)+JVS(273)*UV(39)+JVS(311)*UV(41)+JVS(342)*UV(42)
  JTUV(22) = JVS(20)*UV(7)+JVS(34)*UV(11)+JVS(47)*UV(13)+JVS(87)*UV(22)+JVS(104)*UV(26)+JVS(185)*UV(35)+JVS(230)*UV(37)&
               &+JVS(343)*UV(42)
  JTUV(23) = JVS(91)*UV(23)+JVS(200)*UV(36)+JVS(231)*UV(37)+JVS(255)*UV(38)+JVS(295)*UV(40)+JVS(312)*UV(41)+JVS(344)&
               &*UV(42)+JVS(419)*UV(45)
  JTUV(24) = JVS(95)*UV(24)+JVS(162)*UV(33)+JVS(173)*UV(34)+JVS(232)*UV(37)+JVS(296)*UV(40)+JVS(313)*UV(41)+JVS(345)&
               &*UV(42)+JVS(395)*UV(44)
  JTUV(25) = JVS(52)*UV(14)+JVS(99)*UV(25)+JVS(134)*UV(30)+JVS(437)*UV(46)
  JTUV(26) = JVS(21)*UV(7)+JVS(35)*UV(11)+JVS(48)*UV(13)+JVS(88)*UV(22)+JVS(105)*UV(26)+JVS(186)*UV(35)+JVS(234)*UV(37)&
               &+JVS(347)*UV(42)
  JTUV(27) = JVS(111)*UV(27)+JVS(163)*UV(33)+JVS(174)*UV(34)+JVS(235)*UV(37)+JVS(348)*UV(42)+JVS(397)*UV(44)
  JTUV(28) = JVS(117)*UV(28)+JVS(201)*UV(36)+JVS(236)*UV(37)+JVS(314)*UV(41)+JVS(349)*UV(42)+JVS(420)*UV(45)
  JTUV(29) = JVS(44)*UV(12)+JVS(53)*UV(14)+JVS(82)*UV(21)+JVS(125)*UV(29)+JVS(237)*UV(37)+JVS(277)*UV(39)+JVS(315)&
               &*UV(41)+JVS(350)*UV(42)+JVS(398)*UV(44)
  JTUV(30) = JVS(3)*UV(2)+JVS(100)*UV(25)+JVS(126)*UV(29)+JVS(135)*UV(30)+JVS(238)*UV(37)+JVS(278)*UV(39)+JVS(316)&
               &*UV(41)+JVS(351)*UV(42)+JVS(399)*UV(44)+JVS(438)*UV(46)
  JTUV(31) = JVS(36)*UV(11)+JVS(145)*UV(31)+JVS(352)*UV(42)+JVS(371)*UV(43)+JVS(421)*UV(45)
  JTUV(32) = JVS(37)*UV(11)+JVS(56)*UV(15)+JVS(146)*UV(31)+JVS(156)*UV(32)+JVS(187)*UV(35)+JVS(202)*UV(36)+JVS(256)&
               &*UV(38)+JVS(422)*UV(45)+JVS(439)*UV(46)
  JTUV(33) = JVS(147)*UV(31)+JVS(164)*UV(33)+JVS(240)*UV(37)+JVS(354)*UV(42)+JVS(373)*UV(43)+JVS(402)*UV(44)
  JTUV(34) = JVS(30)*UV(10)+JVS(96)*UV(24)+JVS(112)*UV(27)+JVS(165)*UV(33)+JVS(175)*UV(34)+JVS(241)*UV(37)+JVS(279)&
               &*UV(39)+JVS(297)*UV(40)+JVS(317)*UV(41)+JVS(355)*UV(42)+JVS(403)*UV(44)+JVS(424)*UV(45)
  JTUV(35) = JVS(22)*UV(7)+JVS(38)*UV(11)+JVS(57)*UV(15)+JVS(106)*UV(26)+JVS(148)*UV(31)+JVS(157)*UV(32)+JVS(188)*UV(35)&
               &+JVS(203)*UV(36)+JVS(257)*UV(38)+JVS(356)*UV(42)+JVS(404)*UV(44)+JVS(425)*UV(45)+JVS(440)*UV(46)
  JTUV(36) = JVS(69)*UV(18)+JVS(83)*UV(21)+JVS(118)*UV(28)+JVS(127)*UV(29)+JVS(158)*UV(32)+JVS(189)*UV(35)+JVS(204)&
               &*UV(36)+JVS(258)*UV(38)+JVS(281)*UV(39)+JVS(318)*UV(41)+JVS(357)*UV(42)+JVS(405)*UV(44)+JVS(426)*UV(45)&
               &+JVS(441)*UV(46)
  JTUV(37) = JVS(27)*UV(9)+JVS(89)*UV(22)+JVS(113)*UV(27)+JVS(244)*UV(37)+JVS(358)*UV(42)+JVS(377)*UV(43)
  JTUV(38) = JVS(7)*UV(3)+JVS(65)*UV(17)+JVS(78)*UV(20)+JVS(92)*UV(23)+JVS(119)*UV(28)+JVS(191)*UV(35)+JVS(206)*UV(36)&
               &+JVS(245)*UV(37)+JVS(260)*UV(38)+JVS(283)*UV(39)+JVS(299)*UV(40)+JVS(320)*UV(41)+JVS(359)*UV(42)+JVS(378)&
               &*UV(43)+JVS(407)*UV(44)+JVS(428)*UV(45)+JVS(443)*UV(46)
  JTUV(39) = JVS(70)*UV(18)+JVS(84)*UV(21)+JVS(120)*UV(28)+JVS(128)*UV(29)+JVS(136)*UV(30)+JVS(167)*UV(33)+JVS(177)&
               &*UV(34)+JVS(207)*UV(36)+JVS(246)*UV(37)+JVS(261)*UV(38)+JVS(284)*UV(39)+JVS(300)*UV(40)+JVS(321)*UV(41)&
               &+JVS(360)*UV(42)+JVS(379)*UV(43)+JVS(408)*UV(44)+JVS(429)*UV(45)+JVS(444)*UV(46)
  JTUV(40) = JVS(16)*UV(6)+JVS(73)*UV(19)+JVS(150)*UV(31)+JVS(168)*UV(33)+JVS(178)*UV(34)+JVS(192)*UV(35)+JVS(208)&
               &*UV(36)+JVS(262)*UV(38)+JVS(285)*UV(39)+JVS(301)*UV(40)+JVS(322)*UV(41)+JVS(361)*UV(42)+JVS(409)*UV(44)&
               &+JVS(430)*UV(45)
  JTUV(41) = JVS(4)*UV(2)+JVS(17)*UV(6)+JVS(61)*UV(16)+JVS(74)*UV(19)+JVS(85)*UV(21)+JVS(93)*UV(23)+JVS(97)*UV(24)&
               &+JVS(101)*UV(25)+JVS(121)*UV(28)+JVS(129)*UV(29)+JVS(137)*UV(30)+JVS(179)*UV(34)+JVS(193)*UV(35)+JVS(209)&
               &*UV(36)+JVS(248)*UV(37)+JVS(263)*UV(38)+JVS(286)*UV(39)+JVS(302)*UV(40)+JVS(323)*UV(41)+JVS(362)*UV(42)&
               &+JVS(381)*UV(43)+JVS(410)*UV(44)+JVS(431)*UV(45)+JVS(446)*UV(46)
  JTUV(42) = JVS(12)*UV(4)+JVS(14)*UV(5)+JVS(24)*UV(8)+JVS(31)*UV(10)+JVS(39)*UV(11)+JVS(45)*UV(12)+JVS(49)*UV(13)&
               &+JVS(54)*UV(14)+JVS(58)*UV(15)+JVS(62)*UV(16)+JVS(66)*UV(17)+JVS(71)*UV(18)+JVS(75)*UV(19)+JVS(79)*UV(20)&
               &+JVS(86)*UV(21)+JVS(94)*UV(23)+JVS(98)*UV(24)+JVS(108)*UV(26)+JVS(114)*UV(27)+JVS(122)*UV(28)+JVS(130)&
               &*UV(29)+JVS(138)*UV(30)+JVS(151)*UV(31)+JVS(159)*UV(32)+JVS(170)*UV(33)+JVS(180)*UV(34)+JVS(210)*UV(36)&
               &+JVS(249)*UV(37)+JVS(264)*UV(38)+JVS(287)*UV(39)+JVS(303)*UV(40)+JVS(324)*UV(41)+JVS(363)*UV(42)+JVS(411)&
               &*UV(44)+JVS(432)*UV(45)+JVS(447)*UV(46)
  JTUV(43) = JVS(8)*UV(3)+JVS(28)*UV(9)+JVS(80)*UV(20)+JVS(115)*UV(27)+JVS(152)*UV(31)+JVS(171)*UV(33)+JVS(250)*UV(37)&
               &+JVS(265)*UV(38)+JVS(288)*UV(39)+JVS(304)*UV(40)+JVS(325)*UV(41)+JVS(364)*UV(42)+JVS(383)*UV(43)+JVS(412)&
               &*UV(44)+JVS(433)*UV(45)+JVS(448)*UV(46)
  JTUV(44) = JVS(9)*UV(3)+JVS(25)*UV(8)+JVS(63)*UV(16)+JVS(67)*UV(17)+JVS(102)*UV(25)+JVS(116)*UV(27)+JVS(131)*UV(29)&
               &+JVS(139)*UV(30)+JVS(172)*UV(33)+JVS(182)*UV(34)+JVS(251)*UV(37)+JVS(266)*UV(38)+JVS(289)*UV(39)+JVS(305)&
               &*UV(40)+JVS(326)*UV(41)+JVS(365)*UV(42)+JVS(384)*UV(43)+JVS(413)*UV(44)+JVS(434)*UV(45)+JVS(449)*UV(46)
  JTUV(45) = JVS(10)*UV(3)+JVS(40)*UV(11)+JVS(59)*UV(15)+JVS(76)*UV(19)+JVS(153)*UV(31)+JVS(183)*UV(34)+JVS(195)*UV(35)&
               &+JVS(252)*UV(37)+JVS(306)*UV(40)+JVS(366)*UV(42)+JVS(385)*UV(43)+JVS(414)*UV(44)+JVS(435)*UV(45)
  JTUV(46) = JVS(41)*UV(11)+JVS(90)*UV(22)+JVS(103)*UV(25)+JVS(140)*UV(30)+JVS(160)*UV(32)+JVS(196)*UV(35)+JVS(214)&
               &*UV(36)+JVS(268)*UV(38)+JVS(291)*UV(39)+JVS(307)*UV(40)+JVS(328)*UV(41)+JVS(367)*UV(42)+JVS(386)*UV(43)&
               &+JVS(415)*UV(44)+JVS(436)*UV(45)+JVS(451)*UV(46)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Jacobian

