
#INCLUDE atoms
Min; {minus (negative charge as pseudo-atom for charge balance)}
Pls; {plus  (positive charge as pseudo-atom for charge balance)}
{}
#DEFVAR

{------------------------------------------------------------------------}
ACBZO2           =                     5H + 7C + 3O ; {@C_7H_5O_3}             {acyl peroxy radical from benzaldehyde}
ALKNO3           =               11H + 5C + 3O + 1N ; {@C_5H_<11>NO_3}         {nitrate from BIGALKANE}
ALKO2            =                    11H + 5C + 2O ; {@C_5H_<11>O_2}          {peroxy radical from large alkanes}
ALKOH            =                    12H + 5C + 1O ; {@C_5H_<12>O}            {alcohol from BIGALKANE}
ALKOOH           =                    12H + 5C + 2O ; {@C_5H_<12>O_2}          {peroxide from large alkanes}
APINENE          =                        16H + 10C ; {@C_<10>H_<16>}          {4,6,6-trimethylbicyclo[3.1.1]hept-3-ene}
BCARY            =                        24H + 15C ; {@C_<15>H_<24>}          {(1R,4E,9S)-4,11,11-trimethyl-8-methylidenebicyclo[7.2.0]undec-4-ene}
BENZENE          =                          6H + 6C ; {@C_6H_6}                {benzene}
BENZO2           =                     7H + 6C + 5O ; {@C_6H_7O_5}             {peroxy radical from benzene}
BENZOOH          =                     8H + 6C + 5O ; {@C_6H_8O_5}             {peroxide from BENZO2}
BEPOMUC          =                     6H + 6C + 3O ; {@C_6H_6O_3}             {benzene eopoxy diol}
BIACETOH         =                     6H + 4C + 3O ; {@C_4H_6O_3}             {1-hydroxybutane-2,3-dione}
BIGALD1          =                     4H + 4C + 2O ; {@C_4H_4O_2}             {but-2-enedial}
BIGALD2          =                     6H + 5C + 2O ; {@C_5H_6O_2}             {4-oxopent-2-enal}
BIGALD3          =                     6H + 5C + 2O ; {@C_5H_6O_2}             {2-methylbut-2-enedial}
BIGALD4          =                     8H + 6C + 2O ; {@C_6H_8O_2}             {aldehyde from xylene oxidation}
BIGALKANE        =                         12H + 5C ; {@C_5H_<12>}             {large alkanes}
BIGENE           =                          8H + 4C ; {@C_4H_8}                {large alkenes}
BPINENE          =                        16H + 10C ; {@C_<10>H_<16>}          {6,6-dimethyl-4-methylidenebicyclo[3.1.1]heptane}
Br               =                              1Br ; {@Br}                    {atomic bromine}
Br2              = ignore ; {@Br2}
BrCl             =                        1Br + 1Cl ; {@ClBr}                  {bromine chloride}
BrNO2            = ignore ; {@BrNO2}
BrO              =                         1O + 1Br ; {@BrO}                   {hypobromite}
BrONO            = ignore ; {@BrONO}
BrNO3            =                    3O + 1Br + 1N ; {@BrNO_3}                {bromo nitrate}
BZALD            =                     6H + 7C + 1O ; {@C_7H_6O}               {benzaldehyde}
BZOO             =                     7H + 7C + 2O ; {@C_7H_7O_2}             {peroxy radical from toluene}
BZOOH            =                     8H + 7C + 2O ; {@C_7H_8O_2}             {peroxide from BZOO}
C2H2             =                          2H + 2C ; {@C_2H_2}                {acetylene}
C2H4             =                          4H + 2C ; {@C_2H_4}                {ethene}
C2H5O2           =                     5H + 2C + 2O ; {@C_2H_5O_2}             {ethyl peroxy radical}
C2H5OH           =                     6H + 2C + 1O ; {@C_2H_6O}               {ethanol}
C2H5OOH          =                     6H + 2C + 2O ; {@C_2H_6O_2}             {hydroperoxyethane}
C2H6             =                          6H + 2C ; {@C_2H_6}                {ethane}
C3H6             =                          6H + 3C ; {@C_3H_6}                {prop-1-ene}
C3H7O2           =                     7H + 3C + 2O ; {@C_3H_7O_2}             {lumped peroxy radical from propane}
C3H7OOH          =                     8H + 3C + 2O ; {@C_3H_8O_2}             {lumped propyl hydro peroxide}
C3H8             =                          8H + 3C ; {@C_3H_8}                {propane}
C59O2            =                     9H + 5C + 5O ; {@C_5H_9O_5}             {alkyl peroxy radicals from HCOC5}
C59OOH           =                    10H + 5C + 5O ; {@C_5H_<10>O_5}          {peroxide from C59O2}
C5H8             =                          8H + 5C ; {@C_5H_8}                {2-methylbuta-1,3-diene}
C6H5O            =                     5H + 6C + 1O ; {@C_6H_5O}               {oxy radical from phenol}
C6H5O2           =                     5H + 6C + 2O ; {@C_6H_5O_2}             {peroxy radical from C6H5O}
C6H5OOH          =                     6H + 6C + 2O ; {@C_6H_6O_2}             {peroxide from C6H5O2}
CATEC1O          = ignore ; {@CATEC1O}
CATEC1O2         = ignore ; {@CATEC1O2}
CATEC1OOH        = ignore ; {@CATEC1OOH}
CATECHOL         =                     6H + 6C + 2O ; {@C_6H_6O_2}             {benzene-1,2-diol}
CCl4             =                         1C + 4Cl ; {@CCl_4}                 {tetrachloromethane}
CF2ClBr          =              1C + 2F + 1Br + 1Cl ; {@CF_2ClBr}              {bromo-chloro-difluoromethane}
CF3Br            =                    1C + 1Br + 3F ; {@CF_3Br}                {bromo(trifluoro)methane}
CFCl3            =                    1C + 1F + 3Cl ; {@CFCl_3}                {trichloro(fluoro)methane}
CFC113           =                    2C + 3F + 3Cl ; {@C_2F_3Cl_3}            {1,1,2-trichloro-1,2,2-trifluoroethane}
CFC114           =                    2C + 4F + 2Cl ; {@C_2F_4Cl_2}            {1,2-dichloro-1,1,2,2-tetrafluoro-ethane}
CFC115           =                    2C + 5F + 1Cl ; {@C_2F_5Cl}              {1-chloro-1,1,2,2,2-pentafluoro-ethane}
CF2Cl2           =                    1C + 2F + 2Cl ; {@CF_2Cl_2}              {dichloro(difluoro)methan}
CH2Br2           =                    2H + 1C + 2Br ; {@CH_2Br_2}              {CH2Br2}
HCHO             =                     2H + 1C + 1O ; {@CH_2O}                 {formaldehyde}
CH3Br            =                    3H + 1C + 1Br ; {@CH_3Br}                {bromomethane}
CH3CCl3          =                    3H + 2C + 3Cl ; {@C_2H_3Cl_3}            {1,1,1-trichloroethane}
CH3CHO           =                     4H + 2C + 1O ; {@C_2H_4O}               {acetaldehyde}
CH3Cl            =                    3H + 1C + 1Cl ; {@CH_3Cl}                {chloromethane}
CH3CN            =                     3H + 2C + 1N ; {@C_2H_3N}               {acetonitrile}
CH3CO3           =                     3H + 2C + 3O ; {@C_2H_3O_3}             {peroxyacetyl radical}
CH3COCH2O2       =                     5H + 3C + 3O ; {@C_3H_5O_3}             {2-oxypropylperoxy radical}
CH3COCH3         =                     6H + 3C + 1O ; {@C_3H_6O}               {propan-2-one}
MGLYOX           =                     4H + 3C + 2O ; {@C_3H_4O_2}             {2-oxopropanal}
CH3CO2H          =                     4H + 2C + 2O ; {@C_2H_4O_2}             {acetic acid}
CH3CO3H          =                     4H + 2C + 3O ; {@C_2H_4O_3}             {ethaneperoxoic acid}
CH3O2            =                     3H + 1C + 2O ; {@CH_3O_2}               {methylperoxy radical}
CH3O2NO2         = ignore ; {@CH3O2NO2}
CH3OH            =                     4H + 1C + 1O ; {@CH_4O}                 {methanol}
CH3OOH           =                     4H + 1C + 2O ; {@CH_4O_2}               {hydroperoxymethane}
CH3SO2           = ignore ; {@CH3SO2}
CH3SO3           = ignore ; {@CH3SO3}
CH3SO3H          = ignore ; {@CH3SO3H}
CH4              =                          4H + 1C ; {@CH_4}                  {methane}
CHBr3            =                    1H + 1C + 3Br ; {@CHBr_3}                {CHBr3}
Cl               =                              1Cl ; {@Cl}                    {atomic chlorine}
Cl2              =                              2Cl ; {@Cl_2}                  {molecular chlorine}
Cl2O2            =                         2O + 2Cl ; {@Cl_2O_2}               {chlorooxy hypochlorite}
ClO              =                         1O + 1Cl ; {@ClO}                   {chlorine oxide}
ClNO3            =                    1N + 3O + 1Cl ; {@ClNO_3}                {chloro nitrate}
CO               =                          1C + 1O ; {@CO}                    {carbon monoxide}
CO2              =                          1C + 2O ; {@CO_2}                  {carbon dioxide}
CO2H3CHO         =                     6H + 4C + 3O ; {@C_4H_6O_3}             {2-hydroxy-3-oxobutanal}
CO2H3CO3         =                     5H + 4C + 5O ; {@C_4H_5O_5}             {peroxy radical from 2-hydroxy-3-oxobutanal}
CO2H3CO3H        =                     6H + 4C + 5O ; {@C_4H_6O_5}             {peroxide from CO2H3CO3}
COF2             =                     1C + 1O + 2F ; {@CF_2O}                 {carbonyl difluoride}
COFCL            =               1C + 1F + 1O + 1Cl ; {@CFClO}                 {carbonyl chloride fluoride}
CRESOL           =                     8H + 7C + 1O ; {@C_7H_8O}               {2-methylphenol}
DICARBO2         =                     5H + 5C + 4O ; {@C_5H_5O_4}             {dicarbonyl from photolysis of BIGALD2}
DMS              =                     6H + 2C + 1S ; {@C_2H_6S}               {methylsulfanylmethane}
DMSO             = ignore ; {@DMSO}
ELVOC            = ignore ; {@ELVOC}
ENEO2            =                     9H + 4C + 3O ; {@C_4H_9O_3}             {peroxy radical from BIGENE/OLTP}
HOCH2CH2O        =                     5H + 2C + 2O ; {@C_2H_5O_2}             {(2-hydroxyethyl)oxidanyl}
HOCH2CH2O2       =                     5H + 2C + 3O ; {@C_2H_5O_3}             {(2-hydroxyethyl)dioxidanyl}
EOOH             =                     6H + 2C + 3O ; {@C_2H_6O_3}             {2-hydroperoxyethanol}
F                =                               1F ; {@F}                     {fluoride}
HOCH2CHO         =                     4H + 2C + 2O ; {@C_2H_4O_2}             {2-hydroxyacetaldehyde}
GLYOX            =                     2H + 2C + 2O ; {@C_2H_2O_2}             {oxaldehyde}
H                =                               1H ; {@H}                     {atomic hydrogen}
H1202            =                    1C + 2Br + 2F ; {@CF_2Br_2}              {dibromo(difluoro)methane}
H2               =                               2H ; {@H_2}                   {molecular hydrogen}
H2402            =                    2C + 2Br + 4F ; {@C_2F_4Br_2}            {1,2-dibromo-1,1,2,2-tetrafluoroethane}
H2O              =                          2H + 1O ; {@H_2O}                  {oxidane}
H2O2             =                          2H + 2O ; {@H_2O_2}                {hydrogen peroxide}
H2SO4            = ignore ; {@H2SO4}
HBr              =                         1H + 1Br ; {@HBr}                   {bromane}
HCFC141B         =               3H + 2C + 1F + 2Cl ; {@C_2H_3FCl_2}           {1,1-dichloro-1-fluoroethane}
HCFC142B         =               3H + 2C + 2F + 1Cl ; {@C_2H_3F_2Cl}           {1-chloro-1,1-difluoroethane}
HCFC22           =               1H + 1C + 2F + 1Cl ; {@CHF_2Cl}               {chloro(difluoro)methane}
HCl              =                         1H + 1Cl ; {@HCl}                   {chlorane}
HCN              =                     1H + 1C + 1N ; {@CHN}                   {formonitrile}
HCOC5            =                     8H + 5C + 2O ; {@C_5H_8O_2}             {1-hydroxy-3-methylbut-3-en-2-one}
HCOCO2H          =                     2H + 2C + 3O ; {@C_2H_2O_3}             {oxaldehydic acid}
HCOCO3           =                     1H + 2C + 4O ; {@C_2HO_4}               {peroxy acyl radical from GLYOXAL}
HCOCO3H          =                     2H + 2C + 4O ; {@C_2H_2O_4}             {2-oxoethaneperoxoic acid}
HCOOH            =                     2H + 1C + 2O ; {@CH_2O_2}               {formic acid}
HF               =                          1H + 1F ; {@HF}                    {fluorane}
HNO3             =                     1H + 3O + 1N ; {@HNO_3}                 {nitric acid}
HO2              =                          1H + 2O ; {@HO_2}                  {hydroperoxy radical}
HNO4             =                     1H + 4O + 1N ; {@HNO_4}                 {pernitric acid}
HOBr             =                    1H + 1O + 1Br ; {@HBrO}                  {hypobromous acid}
HOCH2CO2H        =                     4H + 2C + 3O ; {@C_2H_4O_3}             {2-hydroxyacetic acid}
HOCH2CO3         =                     3H + 2C + 4O ; {@C_2H_3O_4}             {peroxy acyl radical from GLYALD}
HOCH2CO3H        =                     4H + 2C + 4O ; {@C_2H_4O_4}             {2-hydroxyethaneperoxoic acid}
HOCH2OO          =                     3H + 1C + 3O ; {@CH_3O_3}               {(hydroxymethyl)dioxidanyl}
HOCl             =                    1H + 1O + 1Cl ; {@HClO}                  {hypochlorous acid}
HONO             =                     1H + 2O + 1N ; {@HNO_2}                 {nitrous acid}
HPALD            = ignore ; {@HPALD}
ACETOL           =                     6H + 3C + 2O ; {@C_3H_6O_2}             {1-hydroxypropan-2-one}
IBUTALOH         =                     8H + 4C + 2O ; {@C_4H_8O_2}             {2-hydroxy-2-methylpropanal}
IPRHOCO3         =                     7H + 4C + 4O ; {@C_4H_7O_4}             {peroxy radical from IBUTALOH}
IPRHOCO3H        =                     8H + 4C + 4O ; {@C_4H_8O_4}             {peroxide from IBUTALOH}
IEC1O2           =                     9H + 5C + 5O ; {@C_5H_9O_5}             {peroxy radical from LIEPOX+OH}
ISOPAOH          =                    10H + 5C + 2O ; {@C_5H_<10>O_2}          {2-methylbut-2-ene-1,4-diol}
ISOPBNO3         =                9H + 5C + 4O + 1N ; {@C_5H_9NO_4}            {alkyl nitrate from ISOPBO2}
ISOPBO2          =                     9H + 5C + 3O ; {@C_5H_9O_3}             {beta-hydroperoxy-radical from isoprene (1-OH-2-OO)}
ISOPBOH          =                    10H + 5C + 2O ; {@C_5H_<10>O_2}          {2-methylbut-3-ene-1,2-diol}
ISOPBOOH         =                    10H + 5C + 3O ; {@C_5H_<10>O_3}          {peroxide from ISOPBO2}
ISOPDNO3         =                9H + 5C + 4O + 1N ; {@C_5H_9NO_4}            {alkyl nitrate from ISOPDNO3}
ISOPDO2          =                     9H + 5C + 3O ; {@C_5H_9O_3}             {beta-hydroperoxy-radical from isoprene (4-OH-3-OO)}
ISOPDOH          =                    10H + 5C + 2O ; {@C_5H_<10>O_2}          {3-methylbut-3-ene-1,2-diol}
ISOPDOOH         =                    10H + 5C + 3O ; {@C_5H_<10>O_3}          {peroxide from ISOPDO2}
LC578O2          =                     9H + 5C + 5O ; {@C_5H_9O_5}             {peroxy radicals from C5-hydroxy aldehydes}
LC578OOH         =                    10H + 5C + 5O ; {@C_5H_<10>O_5}          {lumped hydro-peroxide from LC578O2}
LC5PAN1719       =                7H + 5C + 6O + 1N ; {@C_5H_7NO_6}            {homologues of PAN from LHC4ACCO3}
LHC4ACCHO        =                     8H + 5C + 2O ; {@C_5H_8O_2}             {4-hydroxy-3-methylbut-2-enal and 4-hydroxy-2-methylbut-2-enal}
LHC4ACCO2H       =                     8H + 5C + 3O ; {@C_5H_8O_3}             {hydroxy-methylbutenoic acid}
LHC4ACCO3        =                     7H + 5C + 4O ; {@C_5H_7O_4}             {acyl peroxy radical from LHC4ACCHO}
LHC4ACCO3H       =                     8H + 5C + 4O ; {@C_5H_8O_4}             {peroxide from LHC4ACCO3}
LHMVKABO2        =                     7H + 4C + 4O ; {@C_4H_7O_4}             {peroxy radicals from MVK}
LHMVKABOOH       =                     8H + 4C + 4O ; {@C_4H_8O_4}             {hydroperoxides from LHMVKABO2}
LIECHO           =                     8H + 5C + 3O ; {@C_5H_8O_3}             {aldehyde from LIEPOX}
LIECO3           =                     7H + 5C + 5O ; {@C_5H_7O_5}             {peroxy radical from LIECHO}
LIECO3H          =                     8H + 5C + 5O ; {@C_5H_8O_5}             {peroxide from LIECO3}
LIEPOX           =                    10H + 5C + 3O ; {@C_5H_<10>O_3}          {epoxides from LISOPACOOH}
LIMON            =                        16H + 10C ; {@C_<10>H_<16>}          {1-methyl-4-prop-1-en-2-ylcyclohexene}
LISOPACNO3       =                9H + 5C + 4O + 1N ; {@C_5H_9NO_4}            {nitrate from LISOPACO2}
LISOPACO2        =                     9H + 5C + 3O ; {@C_5H_9O_3}             {delta-hydroperoxy-radical from isoprene}
LISOPACOOH       =                    10H + 5C + 3O ; {@C_5H_<10>O_3}          {peroxide from LISOPACO2}
LISOPNO3NO3      = ignore ; {@LISOPNO3NO3}
LISOPNO3O2       = ignore ; {@LISOPNO3O2}
LISOPNO3OOH      = ignore ; {@LISOPNO3OOH}
LISOPOOHO2       = ignore ; {@LISOPOOHO2}
LISOPOOHOOH      = ignore ; {@LISOPOOHOOH}
LNISO3           =                6H + 5C + 6O + 1N ; {@C_5H_6NO_6}            {nitro-peroxy-radical}
LNISOOH          =                7H + 5C + 6O + 1N ; {@C_5H_7NO_6}            {lumped nitro-peroxide from LNISO3}
MACO2H           =                     6H + 4C + 2O ; {@C_4H_6O_2}             {2-methylprop-2-enoic acid}
MACO3H           =                     6H + 4C + 3O ; {@C_4H_6O_3}             {2-methylprop-2-eneperoxoic acid}
MACR             =                     6H + 4C + 1O ; {@C_4H_6O}               {2-methylprop-2-enal}
MACRN            = ignore ; {@MACRN}
MACRO2           =                     7H + 4C + 4O ; {@C_4H_7O_4}             {peroxy radical from methacrolein}
MACROH           =                     8H + 4C + 3O ; {@C_4H_8O_3}             {2,3-dihydroxy-2-methylpropanal}
MACROOH          =                     8H + 4C + 4O ; {@C_4H_8O_4}             {2-hydroperoxy-3-hydroxy-2-methylpropanal}
MALO2            =                     3H + 4C + 4O ; {@C_4H_3O_4}             {peroxy radical from photolysis of BIGALD1}
MBO              =                    10H + 5C + 1O ; {@C_5H_<10>O}            {2-methylbut-3-en-2-ol}
MBONO3O2         =               10H + 5C + 6O + 1N ; {@C_5H_<10>NO_6}         {peroxy nitrate radical from MBO+NO3}
MBOO2            =                    11H + 5C + 4O ; {@C_5H_<11>O_4}          {peroxy radical from MBO}
MBOOOH           =                    12H + 5C + 4O ; {@C_5H_<12>O_4}          {peroxide from MBO}
MACO3            =                     5H + 4C + 3O ; {@C_4H_5O_3}             {peroxy radical from methacrolein}
MDIALO2          =                     5H + 5C + 4O ; {@C_5H_5O_4}             {peroxy radical from photolysis of BIGALD3}
MEK              =                     8H + 4C + 1O ; {@C_4H_8O}               {butan-2-one}
MEKNO3           = ignore ; {@MEKNO3}
LMEKO2           =                     7H + 4C + 3O ; {@C_4H_7O_3}             {peroxy radical from MEK}
LMEKOOH          =                     8H + 4C + 3O ; {@C_4H_8O_3}             {4-hydroperoxybutan-2-one}
MPAN             =                5H + 4C + 5O + 1N ; {@C_4H_5NO_5}            {nitro 2-methylprop-2-eneperoxoate}
MVK              =                     6H + 4C + 1O ; {@C_4H_6O}               {but-3-en-2-one}
MVKN             = ignore ; {@MVKN}
MYRC             =                        16H + 10C ; {@C_<10>H_<16>}          {2-methyl-6-methylideneocta-1,7-diene}
N                =                               1N ; {@N}                     {atomic nitrogen}
N2               =                               2N ; {@N_2}                   {molecular nitrogen}
N2O              =                          1O + 2N ; {@N_2O}                  {nitrous oxide}
N2O5             =                          5O + 2N ; {@N_2O_5}                {nitro nitrate}
NC4CHO           =                7H + 5C + 4O + 1N ; {@C_5H_7NO_4}            {(2-methyl-4-oxobut-2-enyl) nitrate}
NH3              =                          3H + 1N ; {@H_3N}                  {azane}
NISOPO2          =                8H + 5C + 5O + 1N ; {@C_5H_8NO_5}            {nitro-peroxy-radical from C5H8+NO3}
NISOPOOH         =                9H + 5C + 5O + 1N ; {@C_5H_9NO_5}            {nitro-hydro-peroxide}
NO               =                          1O + 1N ; {@NO}                    {nitric oxide}
NO2              =                          2O + 1N ; {@NO_2}                  {nitrogen dioxide}
NO3              =                          3O + 1N ; {@NO_3}                  {nitrate}
NOA              =                5H + 3C + 4O + 1N ; {@C_3H_5NO_4}            {2-oxopropyl nitrate}
NTERPNO3         = ignore ; {@NTERPNO3}
NTERPO2          =              16H + 10C + 5O + 1N ; {@C_<10>H_<16>NO_5}      {nitro peroxy radical from terpenes}
O3P              =                               1O ; {@O}                     {O triplet P}
O1D              =                               1O ; {@O}                     {O singlett D}
O2               =                               2O ; {@O_2}                   {molecular oxygen}
O3               =                               3O ; {@O_3}                   {ozone}
OClO             =                         2O + 1Cl ; {@ClO_2}                 {chlorine dioxide}
OH               =                          1H + 1O ; {@HO}                    {hydroxide}
PACALD           = ignore ; {@PACALD}
PAN              =                3H + 2C + 5O + 1N ; {@C_2H_3NO_5}            {nitro ethaneperoxoate}
PBZNIT           =                5H + 7C + 5O + 1N ; {@C_7H_5NO_5}            {nitrate from benzaldehyde}
PHENO2           =                     7H + 6C + 6O ; {@C_6H_7O_6}             {peroxy radical from phenol}
PHENOL           =                     6H + 6C + 1O ; {@C_6H_6O}               {phenol}
PHENOOH          =                     8H + 6C + 6O ; {@C_6H_8O_6}             {peroxide from PHENO2}
HYPROPO2         =                     7H + 3C + 3O ; {@C_3H_7O_3}             {beta-hydroxy-peroxy-radical from propene}
HYPROPO2H        =                     8H + 3C + 3O ; {@C_3H_8O_3}             {2-hydroperoxypropan-1-ol}
PR2O2HNO3        =                7H + 3C + 5O + 1N ; {@C_3H_7NO_5}            {hydroperoxy propylnitrate}
PRONO3BO2        =                6H + 3C + 5O + 1N ; {@C_3H_6NO_5}            {nitro-peroxy radical from C3H6}
HYPERACET        =                     6H + 3C + 3O ; {@C_3H_6O_3}             {1-hydroperoxypropan-2-one}
SF6              =                          1S + 6F ; {@SF_6}                  {hexafluoro-lambda6-sulfane}
SO2              =                          1S + 2O ; {@SO_2}                  {sulfur dioxide}
TEPOMUC          =                     8H + 7C + 3O ; {@C_7H_8O_3}             {epoxide from toluene}
TERP2O2          =                   15H + 10C + 4O ; {@C_<10>H_<15>O_4}       {peroxy radical from TERPROD1}
TERP2OOH         =                   16H + 10C + 4O ; {@C_<10>H_<16>O_4}       {peroxide from TERP2O2}
TERPNO3          =              17H + 10C + 4O + 1N ; {@C_<10>H_<17>NO_4}      {nitrate from terpenes}
TERPO2           =                   17H + 10C + 3O ; {@C_<10>H_<17>O_3}       {peroxy radical from terpenes}
TERPOOH          =                   18H + 10C + 3O ; {@C_<10>H_<18>O_3}       {peroxide from terpenes}
TERPROD1         =                   16H + 10C + 2O ; {@C_<10>H_<16>O_2}       {terpene oxidation product C10}
TERPROD2         =                    10H + 7C + 2O ; {@C_7H_<10>O_2}          {terpene oxidation product C9}
TOLUENE          =                          8H + 7C ; {@C_7H_8}                {toluene}
TOLO2            =                     9H + 7C + 5O ; {@C_7H_9O_5}             {peroxy radical from toluene}
TOLOOH           =                    10H + 7C + 5O ; {@C_7H_<10>O_5}          {peroxide from toluene}
LXYL             =                         10H + 8C ; {@C_8H_<10>}             {1,2-xylene}
XYLENO2          =                    11H + 8C + 5O ; {@C_8H_<11>O_5}          {peroxy radical from xylene}
XYLENOOH         =                    12H + 8C + 5O ; {@C_8H_<12>O_5}          {peroxide from XYLENO2}
XYLOL            =                    10H + 8C + 1O ; {@C_8H_<10>O}            {2,3-dimethylphenol}
XYLOLO2          =                    11H + 8C + 6O ; {@C_8H_<11>O_6}          {peroxy radical from xylol}
XYLOLOOH         =                    12H + 8C + 6O ; {@C_8H_<12>O_6}          {peroxide from xylol}

PRODUCTS = ignore;
M = ignore;
