;*******************************************************************
; procedure to draw the VFE Diagram Metrics Table
; This script is adapted from taylor_metrics_table.ncl
;
; AWWG METRICS 0.3 ;;;
; 27 Jun 06   ASP
;  5 Jul 06   DJS 
;  6 Apr 17   ZXu
; Arguments:
;     mfname     : name of the output table
;     modelNames : model names [metrics]
;     stats      : statistical quantity names
;     varNames   : variable names
;     values     : array containing the statitical values for individual variable
;     values2    : array containing RMSL, VSC, RMSVD, RMS_std, and MIEI
;     opt        : used to pass optional arguments
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
procedure VFE_metrics_table(mfname[1]:string        \           ; plot name
                              ,modelNames[*]:string  \          ; model names
                              ,zoom[*]:numeric        \         ; scaling the width of the table colomn
                              ,varNames[*]:string       \
                              ,values[*][*][*]:numeric  \
                              ,values2[*][*]:numeric  \
                              ,opt:logical              )


;;;
;;; Output of metrics to a table [grid]

begin  
    if (.not.isatt(opt,"pltType") .or. \
       (opt@pltType.eq."eps" .or. opt@pltType.eq."png" .or. opt@pltType.eq."gif")) then
        wks = gsn_open_wks("eps",mfname)    ; default 
    else
        wks_type = opt@pltType
        wks_type@wkOrientation = opt@wkOrientation
        wks = gsn_open_wks(wks_type,mfname)   
    end if
    
    xbox0  = (/0.0,1.0,1.0,0.0,0.0/) ; Box template.
    ybox0  = (/0.0,0.0,1.0,1.0,0.0/)
    
    stats  = (/"RMS", "CORR","RMSD"/)
    nmodel = dimsizes(modelNames)
    nstats = dimsizes(stats)
    nvars  = dimsizes(varNames)
    
    dimt   = dimsizes(values)        ; table dimensions to plot the statistics for individual variable
    dimt2  = dimsizes(values2)       ; table dimensions to plot the multi-variable integrated statistics
; *** set each value bin to a color
    RMSlevs  = (/0.65, 0.70, 0.75, 0.80, 0.85, 0.90, 0.95, 1.00, 1.05, 1.10, 1.15, 1.20, 1.25, 1.30, 1.35, 1.40, 1.45/)
    CORRlevs = (/0.84, 0.86, 0.88, 0.90, 0.91, 0.92, 0.93, 0.94,0.95, 0.96, 0.98/)
    RMSDlevs = (/0.10, 0.15, 0.20, 0.25, 0.30, 0.35, 0.40, 0.45, 0.5/)
    
    vstats  = (/"RMSL", "Rv", "RMSVD"/)
    if (nstats.ne.dimt(0)) then
       print("vfe_metrics_table fatal error: Number of case names ("+nstats+ \
             ") does not match the number of stats passed in ("+dimt(0)+")")
       exit
    end if
    if (nvars.ne.dimt(1)) then
       print("vfe_metrics_table fatal error: Number of season names ("+nvars+ \
             ") does not match the number of varNames passed in ("+dimt(1)+")")
       exit
    end if
    if (dimsizes(modelNames).ne.dimt(2)) then
       print("vfe_metrics_table fatal error: Number of metric variables names ("+dimsizes(modelNames)+ \
             ") does not match the number of metric variables passed in ("+dimt(2)+")")
       exit
    end if
    
    ncolm1 = dimt(0)*dimt(1)
    if (ncolm1.le.12) then
       if (ncolm1.le.6) then
          tt_width = .2
       end if
       if (ncolm1.ge.7.and.ncolm1.le.12) then
          tt_width = .1
       end if
       tt_height     = 0.1
       tt_theight    = 0.015
       mn_height     = 0.03  
       mn_theight    = 0.015  
    else
       if (ncolm1.le.20) then
          tt_width   = .15
          tt_height  = 0.06
          tt_theight = 0.012
          mn_height  = 0.018  
          mn_theight = 0.0072
       else
          tt_width   = .1
          tt_height  = 0.05
          tt_theight = 0.01
          mn_height  = 0.015  
          mn_theight = 0.006
       end if
    end if
    if (ncolm1.gt.26.or.dimt(2).gt.63) then
       print("Warning: Recommended maximium size of array passed into vfe_metrics_table is "+ \
             "26 columns (#stats * #varNames) by 63 rows (#variables), continuing")
    end if

    mn_width   = tt_width
    mv_height  = mn_height
    mv_width   = 0.1
    mv_theight = mn_theight
    
    tt_pRes = True
    tt_pRes@gsFillColor   = "CornflowerBlue"      ; background color for + values
    tt_tRes  = True
    tt_tRes@txFontHeightF = tt_theight
    
    mn_pRes = True
    mn_pRes@gsFillColor   = "Gray70"              ; background color for variable names
    
    mn_tRes = True
    mn_tRes@txFontHeightF = mn_theight
    
    mv_tRes = True
    mv_tRes@txFontHeightF = mn_theight     
    
; Title
    
    xbox   = tt_width*xbox0
    ybox   = 1.-tt_height*ybox0
    
    ixtbox = xbox(0)+0.5*(xbox(1)-xbox(0))
    iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
  
    gsn_polygon_ndc(wks,xbox,ybox,tt_pRes)
    if (isatt(opt,"tableTitle") ) then
        gsn_text_ndc(wks, opt@tableTitle ,ixtbox,iytbox, tt_tRes)
    else
        gsn_text_ndc(wks,"METRICS",ixtbox,iytbox, tt_tRes)
    end if
    gsn_polyline_ndc(wks,xbox,ybox,False)
    
    do im = 0,nmodel-1                                ; for the left column, model identifer
      ybox   = min(ybox)-(ybox0*mn_height)
      ixtbox = xbox(0)+0.5*(xbox(1)-xbox(0))
      iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
      
      gsn_polygon_ndc(wks,xbox,ybox,mn_pRes)
      gsn_polyline_ndc(wks,xbox,ybox,False)
      gsn_text_ndc(wks,modelNames(im),ixtbox,iytbox, mn_tRes)
    end do
   
    gridWidth = (zoom-tt_width)/(nstats*nvars) 
    do istat = 0, nstats-1
      ybox   = 1.-0.5*tt_height*ybox0
      xbox   = ((zoom-tt_width)/nstats)*(xbox0+istat)+tt_width+istat*gridWidth
      xboxi  = min(xbox)
      ixtbox = xbox(0)+0.5*(xbox(1)-xbox(0))
      iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
      gsn_polygon_ndc(wks,xbox,ybox,mn_pRes)
      gsn_polyline_ndc(wks,xbox,ybox,False)
    mn_tRes@txAngleF = 0
      gsn_text_ndc(wks,stats(istat),ixtbox,iytbox, mn_tRes)
       
           mv_pRes = True

      do iseas = 0, nvars-1
      ybox     = 1.-0.5*tt_height-0.5*tt_height*ybox0
      xbox     = xboxi +  ((zoom-tt_width)/(nstats*nvars))*(xbox0+iseas)
      ixtbox   = xbox(0)+0.5*(xbox(1)-xbox(0))
      iytbox   = ybox(0)+0.5*(ybox(2)-ybox(0))
      gsn_polygon_ndc(wks,xbox,ybox,mn_pRes)
      gsn_polyline_ndc(wks,xbox,ybox,False)
      gsn_text_ndc(wks,varNames(iseas),ixtbox,iytbox, mn_tRes) 
      
      do im=0,nmodel-1
          if (im .eq. 0) then
            ybox = 1.-tt_height-mv_height*ybox0
          else
            ybox = ybox - mv_height
          end if
          iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))

      if(istat .eq. 0) then
    gsn_define_colormap (wks,"BlueDarkRed18")                ;xuzf
    cmap1 = gsn_retrieve_colormap(wks)               ;xuzf
    mv_pRes@gsFillColor   = GetFillColor(RMSlevs,cmap1,values(istat,iseas,im))       ; xuzf
      end if
      if(istat .eq. 1) then
    gsn_define_colormap (wks,"GreenWhite11")                ;xuzf
    cmap2 = gsn_retrieve_colormap(wks)               ;xuzf
    mv_pRes@gsFillColor   = GetFillColor(CORRlevs,cmap2,values(istat,iseas,im))       ; xuzf
      end if
      if(istat .eq. 2) then
    gsn_define_colormap (wks,"sunshine_9lev")                ;xuzf
    cmap3 = gsn_retrieve_colormap(wks)               ;xuzf
    mv_pRes@gsFillColor   = GetFillColor(RMSDlevs,cmap3,values(istat,iseas,im))       ; xuzf
      end if
          if (istat .gt. 0) then
            if (ismissing(values(istat,iseas,im)) .or. \    ; ???
                ismissing(values(istat,iseas,im)))then 
    ;          print ("Missing values skipped")
            else
              if (values(istat,iseas,im).le.values(0,iseas,im)) then
;    		  if (isatt(opt,"color0")) then
;                   mv_pRes@gsFillColor = opt@color0
;                else
;                   mv_pRes@gsFillColor = "DarkOliveGreen3"
;    		  end if
              else
;    		  if (isatt(opt,"color1")) then
;                   mv_pRes@gsFillColor = opt@color1
;    		  else	
;    		   mv_pRes@gsFillColor = "IndianRed1"
;    		  end if
              end if
            end if
          end if
          gsn_polygon_ndc(wks,xbox,ybox,mv_pRes)
          gsn_polyline_ndc(wks,xbox,ybox,False)
          gsn_text_ndc(wks,sprintf("%3.2f",values(istat,iseas,im)),ixtbox,iytbox, mv_tRes)     
      end do
      end do
; ******** show RMSL, VSC, and RMSVD  added by xuzf
      ybox   = 1.-tt_height*ybox0
      xbox   = xboxi +  ((zoom-tt_width)/(nstats*nvars))*(xbox0+nvars)
      xboxi  = min(xbox)
      ixtbox = xbox(0)+0.5*(xbox(1)-xbox(0))
      iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
    mn_tRes@txAngleF = -90
      gsn_polygon_ndc(wks,xbox,ybox,mn_pRes)
      gsn_polyline_ndc(wks,xbox,ybox,False)
      gsn_text_ndc(wks,vstats(istat),ixtbox,iytbox, mn_tRes)

      do im=0,nmodel-1
          if (im .eq. 0) then
            ybox = 1.-tt_height-mv_height*ybox0
          else
            ybox = ybox - mv_height
          end if
          iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
           mv_pRes = True
           if(istat .eq. 0) then
           mv_pRes@gsFillColor   = GetFillColor(RMSlevs,cmap1,values2(istat,im))       
           end if
           if(istat .eq. 1) then
           mv_pRes@gsFillColor   = GetFillColor(CORRlevs,cmap2,values2(istat,im))     
           end if
           if(istat .eq. 2) then
           mv_pRes@gsFillColor   = GetFillColor(RMSDlevs,cmap3,values2(istat,im))     
           end if
          gsn_polygon_ndc(wks,xbox,ybox,mv_pRes)
          gsn_polyline_ndc(wks,xbox,ybox,False)
          gsn_text_ndc(wks,sprintf("%3.2f",values2(istat,im)),ixtbox,iytbox, mv_tRes)    
      end do
    end do

; ******** show RMS_std  added by xuzf
      ybox   = 1.-tt_height*ybox0
      xbox   = xboxi +  ((zoom-tt_width)/(nstats*nvars))*(xbox0+1)
      xboxi  = min(xbox)
      ixtbox = xbox(0)+0.5*(xbox(1)-xbox(0))
      iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
      gsn_polygon_ndc(wks,xbox,ybox,mn_pRes)
      gsn_polyline_ndc(wks,xbox,ybox,False)
      gsn_text_ndc(wks,"RMS_std",ixtbox,iytbox, mn_tRes)

      do im=0,nmodel-1
          if (im .eq. 0) then
            ybox = 1.-tt_height-mv_height*ybox0
          else
            ybox = ybox - mv_height
          end if
          iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
           mv_pRes = True
           mv_pRes@gsFillColor   = GetFillColor(RMSDlevs,cmap3,values2(3,im)) 
          gsn_polygon_ndc(wks,xbox,ybox,mv_pRes)
          gsn_polyline_ndc(wks,xbox,ybox,False)
          gsn_text_ndc(wks,sprintf("%3.2f",values2(3,im)),ixtbox,iytbox, mv_tRes)
      end do

; ******** show MIEI  added by xuzf
      ybox   = 1.-tt_height*ybox0
      xbox   = xboxi +  ((zoom-tt_width)/(nstats*nvars))*(xbox0+1)
      xboxi  = min(xbox)
      ixtbox = xbox(0)+0.5*(xbox(1)-xbox(0))
      iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
      gsn_polygon_ndc(wks,xbox,ybox,mn_pRes)
      gsn_polyline_ndc(wks,xbox,ybox,False)
      gsn_text_ndc(wks,"MIEI",ixtbox,iytbox, mn_tRes)

      do im=0,nmodel-1
          if (im .eq. 0) then
            ybox = 1.-tt_height-mv_height*ybox0
          else
            ybox = ybox - mv_height
          end if
          iytbox = ybox(0)+0.5*(ybox(2)-ybox(0))
           mv_pRes = True
           mv_pRes@gsFillColor   = GetFillColor(RMSDlevs,cmap3,values2(4,im)) 
          gsn_polygon_ndc(wks,xbox,ybox,mv_pRes)
          gsn_polyline_ndc(wks,xbox,ybox,False)
          gsn_text_ndc(wks,sprintf("%3.2f",values2(4,im)),ixtbox,iytbox, mv_tRes)
      end do
    
    draw(wks)
  ;; activate the ;; lines if this is made a function
  ;;if (.not.isatt(opt,"gsnFrame") .or. opt@gsnFrame) then
        frame(wks)
                             ; if png or gif then use convert
        if (isatt(opt,"pltType")    .and. \ 
           (opt@pltType.eq."png" .or. opt@pltType.eq."gif")) then
            system("convert -trim +repage "+mfname+".eps "+mfname+"."+opt@pltType)
        end if
  ;;end if
    
end
