;**********************************
; VFE diagram and table metrics for individual variables
;**********************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"   
load "./VFE_diagram.ncl"
load "./VFE_metrics_table.ncl"
;**********************************
begin
;**********************************
; Assume the following have already been computed:
;   _ratio are the ratio:  Model_RMSL/Reference_RMSL
;   _cc    are the vector similarity coefficient of model to Reference
;   _std   are the standard deviation of RMS values of various scalar fields 
;
;  RMSvar  are the RMS values of various scalar fields
;  CORRvar are the uncentered/centered correlation coefficient of various fields to reference ones
;  RMSDvar are the RMSD of various fields to reference ones
;  MIEI    are the multi-variable integrated evaluation index
;**********************************


; Cases [Model]
  case      = (/ "CMIP5", "Observations"/)
  nCase     = dimsizes(case )                 ; # of Cases [Cases]

  statistics  = (/ "RMS", "CORR","RMSD"/)
  nStatistics = dimsizes(statistics)                 ; # of Cases [Cases]

; models compared
  model      = (/"Model 1", "Model 2", "Model 3", "Model 4", "Model 5", "Model 6", "Model 7", "Model 8", "Model 9"/) 
  nmodel      = dimsizes(model)                   ; # of Variables


; "Case A"                        
  CA_ratio   = (/1.038, 1.058, 1.000, 0.959, 1.148, 0.971, 1.091, 1.028, 0.892/)
  CA_cc      = (/0.946, 0.907, 0.912, 0.923, 0.903, 0.942, 0.935, 0.934, 0.912/)
  CA_std     = (/0.076, 0.069, 0.227, 0.200, 0.213, 0.090, 0.020, 0.056, 0.137/)

  CB_ratio   = (/1.008, 1.003, 1.015, 3,3,3,3,3,3/)   ; we only use and show three observation data here
  CB_cc      = (/0.989, 0.992, 0.989, 1,1,1,1,1,1/)
  CB_std     = (/0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0/)

  MIEI    = (/0.34,0.44,0.48,0.44,0.51,0.35,0.37,0.37,0.46/)

; arrays to be passed to taylor_diagram. It will calculate the x xnd y coordinates.
  ratio      = new ((/nCase, nmodel/),typeof(CA_cc) )  
  cc         = new ((/nCase, nmodel/),typeof(CA_cc) ) 
  std        = new ((/nCase, nmodel/),typeof(CA_std) )

  ratio(0,:) = CA_ratio 
  ratio(1,:) = CB_ratio

  cc(0,:)    = CA_cc 
  cc(1,:)    = CB_cc

  std(0,:)    = CA_std
  std(1,:)    = CB_std
;**********************************
; create VFE plot
;**********************************
  MIEIs = "MIEI = " + MIEI                      ; Print MIEI values on the VFE diagram

  ty_opt   = True                               ; taylor diagram with options
        
  ty_opt@Markers       = (/20, 6/)              ; make all solid fill
  ty_opt@modelLabels     = MIEIs
  ty_opt@caseLabels    = case
  ty_opt@Colors  = (/"blue","orangered","darkgreen","black","cyan4",\
                     "purple3","steelblue","red1","brown"/)  ;one also use different color represent the variance of various RMS value

  ty_opt@modelLabelsYloc = 0.66                 ; Move location of model labels. negetative => not showing model name 
  ty_opt@caseLabelsFontHeightF = 0.12           ; make slight larger        [default=0.12 ]
  ty_opt@modelLabelsFontHeightF  = 0.013        ; font size of model name   [default=0.013]
  ty_opt@gsMarkerSizeF         = 0.016          ; marker size               [default=0.0085]
  ty_opt@gsMarkerThicknessF    = 0.5
  ty_opt@NumberSizeF           = 0.013          ; font size of model number
  ty_opt@txFontHeightF         = 0.018          ; text size of axises
  ty_opt@markerTxYOffset       = 0.0            ; [default=0.0175]
 
  ty_opt@tiMainString  = ""                     ; title
  ty_opt@stnRad        = (/ 0.5,1.5 /)          ; additional standard radii
  ty_opt@ccRays        = (/ 0.7,0.95 /)         ; correllation rays
  ty_opt@centerDiffRMS = True                   ; RMS 'circles'
  ty_opt@centerDiffRMS_color = "LightGray"      ; default is "black"
;  ty_opt@ccRays_color    = "LightGray"         ; default is "black"

  wks   = gsn_open_wks("ps","./graph/VFE.T-P.uncentered.3obs.9models.withbars")
  plot  = VFE_diagram(wks,ratio,cc,std,ty_opt)

;**************************************************
; fill arrays for a "VFE metrics table"
;**************************************************

  vars    = (/ "Tm", "Pm", "Ta", "Pa" /)
  nVars   = dimsizes(vars)
  RMSvar      = new ((/nVars, nmodel/),typeof(CA_cc) )  
  RMSvar(0,:) = (/1.01, 1.04, 1.06, 0.97, 0.99, 1.06, 1.08, 1.01, 0.92/)
  RMSvar(1,:) = (/1.00, 1.00, 0.81, 0.86, 0.95, 0.98, 1.10, 0.99, 0.93/)
  RMSvar(2,:) = (/1.15, 1.16, 1.27, 1.21, 1.42, 0.99, 1.11, 1.11, 1.00/)
  RMSvar(3,:) = (/0.98, 1.03, 0.79, 0.74, 1.17, 0.84, 1.07, 1.00, 0.69/)

  CORRvar      = new ((/nVars, nmodel/),typeof(CA_cc) )  
  CORRvar(0,:) = (/1.00, 0.99, 0.99, 1.00, 0.99, 1.00, 0.99, 1.00, 0.99/)
  CORRvar(1,:) = (/0.92, 0.84, 0.89, 0.91, 0.87, 0.91, 0.90, 0.90, 0.87/)
  CORRvar(2,:) = (/0.96, 0.94, 0.95, 0.96, 0.95, 0.96, 0.95, 0.96, 0.94/)
  CORRvar(3,:) = (/0.92, 0.85, 0.86, 0.87, 0.84, 0.90, 0.90, 0.88, 0.87/)

  RMSDvar      = new ((/nVars, nmodel/),typeof(CA_cc) )  
  RMSDvar(0,:) = (/0.10, 0.11, 0.12, 0.09, 0.10, 0.10, 0.13, 0.08, 0.14/)
  RMSDvar(1,:) = (/0.41, 0.56, 0.47, 0.42, 0.50, 0.42, 0.47, 0.45, 0.50/)
  RMSDvar(2,:) = (/0.35, 0.40, 0.45, 0.38, 0.57, 0.27, 0.36, 0.31, 0.35/)
  RMSDvar(3,:) = (/0.39, 0.56, 0.52, 0.50, 0.63, 0.43, 0.47, 0.49, 0.53/)

  table     = new ( (/nStatistics,nVars,nmodel/), typeof(ratio) )
;*** NOTE: the RMS values, CORR, and RMSD should be assigned to the 0, 1, 2 dimension, respectively.
  table(0,:,:) = RMSvar
  table(1,:,:) = CORRvar
  table(2,:,:) = RMSDvar
;**************************************************
; fill arrays of RMS_std and MIEI "
;**************************************************
    RMSL    = CA_ratio
    VSC     = CA_cc
    RMSVD   = (/0.33,0.45,0.42,0.38,0.49,0.33,0.39,0.37,0.41/)
    RMSstd  = CA_std
;    MIEI    = (/0.34,0.44,0.48,0.44,0.51,0.35,0.37,0.37,0.46/)

    VFEvalues      = new ((/5, nmodel/),typeof(CA_cc) )
    VFEvalues(0,:) = RMSL
    VFEvalues(1,:) = VSC 
    VFEvalues(2,:) = RMSVD
    VFEvalues(3,:) = RMSstd
    VFEvalues(4,:) = MIEI
 
    tt_opt         = True
    tt_opt@pltType = "ps"                           ; "eps" [default], "pdf", "ps"
;   tt_opt@wkOrientation  = "landscape"
    tt_opt@wkOrientation  = "portrait"

    zoom = 0.73           ; scaling the width of the table colomn
    VFE_metrics_table("./graph/VFE.metrics.T-P.uncentered",model,zoom,vars,table,VFEvalues,tt_opt)
end 

