!#################################################################
!
!**** Global Atmospheric Tracer Model TM5
!
! purpose
! -------
! Solves the tracer continuitiy equation on an eulerian grid for
! an arbitrary no. of tracers.
! Allow zoom regions with higher resolution.
! Perform advection, vertical transport, emissions, chemistry, deposition, ....
!
! interface
! ---------
! main program
!
! method
! ------
! Initialize the model and then cycle continuously through
! the main model time loop.
!
! externals
! ---------
!
! reference
! --------- 
! See the main website :  www.phys.uu.nl/~tm5/
!
!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

program Tracer

  use GO, only : gol, goPr, goErr
  use GO, only : goExit
  
  use TM5, only : TM5_Comm_Init, TM5_Comm_Done, TM5_Comm_Abort
  use TM5, only : TM5_Model_Init, TM5_Model_Run, TM5_Model_Done
  
  implicit none
 
  ! --- const ---------------------------------------
  
  character(len=*), parameter  ::  rname = 'tracer'
   
  ! --- local ---------------------------------------

  integer           ::  status

  ! --- begin ---------------------------------------
  
  ! setup communication:
  call TM5_Comm_Init( status )
  if (status==0) then

    ! setup model:
    call TM5_Model_Init( status )
    if (status==0) then

      ! run model:
      call TM5_Model_Run( status )
      if (status==0) then
      
        ! done with model:
        call TM5_Model_Done( status )
        if (status==0) then

          ! done with communication:
          call TM5_Comm_Done( status )
          if (status==0) then

            ! clean exit with zero return code:
            call goExit(0)
            
          end if  ! comm done ok

        end if  ! model done ok
        
      end if   ! model run ok

    end if   ! model  init ok

    ! emergency break with return code 1 :
    call TM5_Comm_Abort( 1, status )
    if (status/=0) then
      write (*,'("ERROR from communication abort")')
      ! try again to exit:
      call goExit(1)
    end if      

  end if   ! comm init ok

end program Tracer

