!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

module reaction_data

  use GO, only : gol, goPr, goErr
  
  implicit none

  ! --- in/out ---------------------------------------
  
  public
  
  
  ! --- const ----------------------------------------

  !
  ! thermal reactions
  !
  
  ! number of reactions:
  integer, parameter              ::  nreac  = 1
  
  ! reaction names:
  character(len=8 ), parameter    ::  ratnam(nreac) = (/'dummy   '/)

  ! temperature bins
  integer, parameter  ::  nthigh = 320
  integer, parameter  ::  ntlow  = 165
  integer, parameter  ::  ntemp  = nthigh-ntlow


  !
  ! queous phase reactions
  !
  
  ! number of reactions:
  integer, parameter              ::  nreacw = 1

  ! reaction names:
  character(len=8 ), parameter    ::  rwnam  (nreacw) = (/'dummy   '/)


  !
  ! hetrogeneous reactions
  !
  
  ! number of reactions:
  integer, parameter              ::  nhet   = 1

  ! reaction names:
  character(len=12), parameter    ::  rhetnam(nhet  ) = (/'dummy   '/)


end module reaction_data
