!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

module photolysis_data

  use GO, only : gol, goPr, goErr
  
  use dims, only : nregions
  
  implicit none


  ! --- in/out ---------------------------------
  
  public
  

  ! --- const ------------------------------------
  
  integer, parameter              ::  nj = 1
  character(len=8 ), parameter    ::  jnam(nj) = (/'dummy   '/)


  ! --- types ------------------------------------
  
  type phot_data
     !
     ! albedo      : surface albedo (UV spectral region)
     ! ags_av      : statistics: contains average albedo
     ! nalb_av     : counter for statistics
     !
     real,dimension(:,:),pointer    :: albedo
     !JEW: real,dimension(:,:),pointer    :: ags_av
     !JEW: integer                        :: nalb_av 
  end type phot_data
  
  
  ! --- var ---------------------------------------

  type(phot_data), target     ::  phot_dat(nregions)


end module photolysis_data
