!#################################################################
!
! Type definitions.
!
! Extracted from 'dims.F90'.
!
!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

module global_types

  use GO, only : gol, goPr, goErr
  
  implicit none
  
  ! --- in/out ------------------------------
  
  public
  
  
  ! --- types -------------------------------
  
  ! define structures to contain dimensionolized data:

  type region_data
     integer,dimension(:,:),pointer  :: zoomed
     integer,dimension(:,:),pointer  :: edge
     real,dimension(:),pointer       :: dxyp    ! area (m2)
  end type region_data


  type wind_data

!#ifdef MPI   
!     !
!     ! am_k       westward mass flux through east (kg/s)   (halo = 1)
!     ! bm_k       northward mass flux through south (kg/s) (halo = 1)
!     ! cm_k       upward flux through bottom (kg/s) (halo = 1)
!     ! pu_k,pv_k  to read in the pre-calculated fluxes (halo = 1)
!     ! 
!     real,dimension(:,:,:),pointer   :: am_k 
!     real,dimension(:,:,:),pointer   :: bm_k 
!     real,dimension(:,:,:),pointer   :: cm_k 
!     real,dimension(:,:,:),pointer   :: pu_k
!     real,dimension(:,:,:),pointer   :: pv_k
!#endif
     ! 
     ! am_t       westward mass flux through east (kg/s)   (halo = 1)
     ! bm_t       northward mass flux through south (kg/s) (halo = 1)
     ! cm_t       upward flux through bottom (kg/s) (halo = 1)
     ! pu_t,pv_t  to read in the pre-calculated fluxes (halo = 1)
     ! 
     real,dimension(:,:,:),pointer   :: am_t
     real,dimension(:,:,:),pointer   :: bm_t
     real,dimension(:,:,:),pointer   :: cm_t

  end type wind_data


#ifndef without_convection
  type conv_data
     ! 
     ! entd        entrainement downdraft (im,jm,lmax_conv)
     ! entu        entrainement updraft
     ! detd        detrainement downdraft
     ! detu        detrainement updraft
     ! dkg         diffusion coefs.
     ! cloud_base  bottom updraft
     ! cloud_top   top updraft
     ! cloud_lfs   level of free sinking (downdraft)
     ! blh         boundary layer height
     !
#ifndef without_diffusion
     real,dimension(:,:,:),pointer      :: dkg
#endif
     integer,dimension(:,:),pointer     :: cloud_base
     integer,dimension(:,:),pointer     :: cloud_top 
     integer,dimension(:,:),pointer     :: cloud_lfs
     real,dimension(:,:),pointer        :: blh

  end type conv_data
#endif
  

  ! emis_data%surf  : any type of surface data
  type emis_data
    real,dimension(:,:),pointer     :: surf
  end type emis_data

  ! any type of mode surface data in all resolutions
  type aerosol_emis_data
     real,dimension(:,:,:),pointer   :: surf   
  end type aerosol_emis_data

  ! d3_data%d3   : 3D data, e.g. nox emissions
  type d3_data
    real,dimension(:,:,:),pointer   :: d3
  end type d3_data

  ! d23_data%d23  : lat/pres fields, e.g. o3 climatology in ppmv  
  type d23_data
    real,dimension(:,:),pointer     :: d23
  end type d23_data

  ! d2_data%d2  : lat fields, e.g. hno3/o3 ratios at 10 hPa
  type d2_data
    real,dimension(:),pointer       :: d2
  end type d2_data

  ! isop_data%scalef_isop  : (jm,ntim) scalefactor isoprene emissions
  type isop_data
    real,dimension(:,:),pointer   :: scalef_isop
  end type isop_data

  ! chem_data%rm_k  : 'chemistry' tracers are parallel over layers...
  type chem_data 
    real,dimension(:,:,:,:),pointer :: rm_k
  end type chem_data


end module global_types
