!### macros #####################################################
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
                                                                                                                                                     
#include "tm5.inc"
!#################################################################

module emission_co2_all
  !-----------------------------------------------------------------------
  !       purpose
  !       -------
  !       perform co2 emissions all
  !
  !       interface_
  !       ---------
  !       call emission_apply_all
  !
  !       method
  !       ------
  !       subroutine is called from its general parent routine apply_emission
  !-----------------------------------------------------------------------
  use chem_param ,         only: xmco2, xmc
  use global_types,        only: emis_data
  use Dims,                only: nregions, nlon360,nlat180
  use emission_data,       only: do_add_2d, flux_to_gridbox_per_month
  use emission_common,     only: co2_ocean, co2_bio, co2_ff, co2_fires, co2_all, co2_all_m, co2_all_n, flux_means_are_priors, fluxmultiplier

  implicit none

  private

  ! public routines:
  public   :: emission_apply_co2_all, declare_emission_co2_all, free_emission_co2_all, calc_emission_co2_all
  public   :: co2_flux, emis_data, pseudo

  type(emis_data),dimension(:,:),allocatable,target       :: co2_flux

  logical                                                         :: flux_unallocated=.true.
  logical                                                         :: pseudo=.false.

contains

  subroutine declare_emission_co2_all
   use dims,       only: im,jm,nregions
   use ParTools,   only: ntracetloc
   use chem_param, only: nmembersloc
   implicit none
   integer                                          :: region, imr, jmr, n


   allocate(co2_flux(nregions,ntracetloc))
   do region=1,nregions
      imr=im(region)
      jmr=jm(region)
      do n=1,nmembersloc !ntracetloc
         allocate(co2_flux(region,n)%surf(imr,jmr))
      end do
   enddo

  end subroutine declare_emission_co2_all

  subroutine calc_emission_co2_all
   use dims,       only: nlon360, nlat180, im,jm, sec_month, newsrun, idate, newday,nregions, itau, staggered, nread
   use toolbox,    only: coarsen_emission_2d
   use ParTools,   only: tracer_active, ntracetloc
   use chem_param, only: xmc,nmembersloc
   use partools,   only : myid,root_t
   implicit none
   integer                                          :: region, imr, jmr, n, mem
   integer, parameter                               :: add_field=0

    if(mod(itau,nread) /= 0) return  ! only every nread hours

    !WP! put full flux into emission array for each member

    do mem=1,nmembersloc !ntracetloc

       co2_all=((co2_bio+co2_ocean)*fluxmultiplier(:,:,mem)+co2_ff+co2_fires) ! create full emissions in mol/m2/s
       co2_all=co2_all*xmc/1.e3 ! full emissions in kgC/m2/s

       call flux_to_gridbox_per_month(co2_all) ! to kgC/area/month
       call coarsen_emission_2d('co2',360,180,co2_all,co2_flux(:,mem),add_field)

    end do

    ! accumulate weekly average
    if(flux_means_are_priors .eqv. .TRUE.) then
       if(allocated(co2_all_m)) then
          co2_all_m=co2_all_m+(co2_bio+co2_ocean+co2_ff+co2_fires)
          co2_all_n=co2_all_n+1
       end if
    else
       if(allocated(co2_all_m)) then
          co2_all_m=co2_all_m+((co2_bio+co2_ocean)*fluxmultiplier(:,:,1)+co2_ff+co2_fires)
          co2_all_n=co2_all_n+1
       end if
    end if


  end subroutine calc_emission_co2_all

  subroutine emission_apply_co2_all(region)
  !
    use GO,            only: goLoCase
    use dims,          only: okdebug
    use ParTools,      only: tracer_active, ntracetloc, myid, ntracet_ar
    use chem_param, only: nmembersloc,names
    implicit none
    ! io        
    integer, intent(in)        :: region
    ! local
    integer                    :: n, offsetn=0
    ! start
    if(myid > 0) offsetn=sum(ntracet_ar(0:myid-1))
    if (goLoCase(trim(names(offsetn+1)))=='co2'.or.goLoCase(trim(names(offsetn+1)))=='co2_bg') then
    do n=1,ntracetloc
      call do_add_2d(region,offsetn+n,1,co2_flux(region,n)%surf,xmco2,xmc)
    enddo
    endif
    if(okdebug) write(*,*) 'end of emission_apply_co2_casm'

   end subroutine emission_apply_co2_all

!==================================================================

   subroutine free_emission_co2_all
   use dims,       only: nregions_max
   use ParTools,   only: ntracetloc
   use chem_param, only: nmembersloc
   implicit none
   integer                                          :: region, n

   do region=1,nregions
     do n=1,nmembersloc !ntracetloc
       deallocate(co2_flux(region,n)%surf)
     end do
   enddo


   end subroutine free_emission_co2_all

end module emission_co2_all
