!#################################################################
!
! Levels.
!
!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

module dims_levels

  use GO, only : gol, goPr, goErr
  
  use const_ec_v, only : lme, a_ec, b_ec
  use dims_grid, only : nregions_all
  
  implicit none
  
  ! --- in/out ------------------------------
  
  public
  
  
  ! --- const -------------------------------
  
  
  integer, parameter ::  lm(0:nregions_all) = 25

  ! lmax_conv determines to what level the clouds and convection 
  ! are stored in the meteo files...

  integer,parameter :: lmax_conv = 19   ! can be lowered to tropopause...

  integer,parameter :: echlevs(0:25) = (/ &
       60,     58,       &
       56,     54,       &
       52,     50,       &
       48,     46,       &
       44,     42,       &
       40,     38,       &
       36,     34,       &
       32,     30,       &
       28,     26,       &
       24,     22,       &
       20,               &
       16,               &
       12,               &
       8,               &
       4,               &
       0 /)

  ! values filled in module geometry ...
  real  :: bt(1:25+1)
  real  :: at(1:25+1)

end module dims_levels
