!#################################################################
!
! Grids.
!
!### macro's #####################################################
!
#include "tm5.inc"
!
!#################################################################

module dims_grid

  implicit none
  
  ! --- in/out ------------------------------
  
  public
  
  
  ! --- const -------------------------------
  
  
  ! Basic model definition: resolution etc. including some routines
  ! to fill the data structure.

  ! basic (coarsest) resolution in degrees for x and y (dz default 1.0)

  real, parameter     ::  dx = 6.0
  real, parameter     ::  dy = 4.0
  real, parameter     ::  dz = 1.0


  ! Maximum number of zoom regions, 
  ! including the basic (coarsest grid) region;
  ! arrays are allocated for each of these regions:
  integer, parameter  ::  nregions_max = 1
  
  ! extra grid:
  integer, parameter  ::  nregions_all = nregions_max + 1
  integer, parameter  ::  iglbsfc = nregions_max + 1

  ! Actual number of zoom regions,
  ! during testing this could be set to 1 to quickly run the model.
  integer, parameter :: nregions = nregions_max

  ! region_name is used to recognise the METEO files
  ! region_name is also used in the HDF output file name
  ! region 1 should always be the global domain

  integer, parameter  ::  len_region_name = 10
  character(len=len_region_name), parameter  ::  region_name(0:nregions_all) = &
       (/ 'globe     ', 'glb600x400', 'glb100x100'/)

  ! coordinates (in degrees) for each region:
  ! xcyc = 1 if the region has cyclic x-boundary conditions
  ! touch_np = 1 if region touches the north pole
  ! touch_sp = 1 if region touches the south pole
  ! xbeg : the westmost border of the region
  ! xend : the eastmost border of the region
  ! ybeg : the southmost border of the region
  ! yend : the northmost border of the region

  integer, parameter  ::  xcyc    (0:nregions_all) = (/    1,    1,    1 /)
  integer, parameter  ::  touch_np(0:nregions_all) = (/    1,    1,    1 /)
  integer, parameter  ::  touch_sp(0:nregions_all) = (/    1,    1,    1 /)
  integer, parameter  ::  xbeg    (0:nregions_all) = (/ -180, -180, -180 /)
  integer, parameter  ::  xend    (0:nregions_all) = (/  180,  180,  180 /)
  integer, parameter  ::  ybeg    (0:nregions_all) = (/  -90,  -90,  -90 /)
  integer, parameter  ::  yend    (0:nregions_all) = (/   90,   90,   90 /)
  integer, parameter  ::  im      (0:nregions_all) = (/    1,   60,  360 /)
  integer, parameter  ::  jm      (0:nregions_all) = (/    1,   45,  180 /)


  ! maximum refinement factor (can be arbitrary in principle):

  integer, parameter :: maxref = 10

  ! refinement factors for each region (<= maxref)
  ! tref may differ from xref/yref. In the current 
  ! implementation it should be 1,2,4,6,...

  integer, parameter  :: xref(0:nregions_max) = (/    1,    1 /)
  integer, parameter  :: yref(0:nregions_max) = (/    1,    1 /)
  integer, parameter  :: zref(0:nregions_max) = (/    1,    1 /)
  integer, parameter  :: tref(0:nregions_max) = (/    1,    1 /)

  ! Define the parent of each region. 
  ! Global region 1 should have parent 0 (globe single cell);
  ! global surface region should have parent 1 (global region).
  integer, parameter  ::  parent(1:nregions_all) = (/ 0, 1 /)

end module dims_grid
