!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

!------------------------------------------------------------------------------
!                    TM5                                                      !
!------------------------------------------------------------------------------
!BOP
!
! !MODULE:  deposition_data
!
! !DESCRIPTION: Dry Deposition Constants
!\\
!\\
! !INTERFACE: 
!
module deposition_data
!
! !USES:
!
  use GO, only : gol, goPr, goErr
  
  implicit none
  public
!
! !PUBLIC DATA MEMBERS:
!
  !
  !  -- definition of terms which correct for the diffusivity 
  ! for the computation of the boundary layer resistance, (v/D)**2/3
  ! v = 0.189 cm2 s-1 (heat) and D from DH2O/DX where DH2O=0.212
  !
  integer, parameter  ::  diffrb_o3       =   1.2
  integer, parameter  ::  diffrb_hno3     =   1.4
  integer, parameter  ::  diffrb_no       =   1.1
  integer, parameter  ::  diffrb_no2      =   1.2
  integer, parameter  ::  diffrb_so2      =   1.4
  integer, parameter  ::  diffrb_so4      =   999.
  integer, parameter  ::  diffrb_h2o2     =   1.2
  integer, parameter  ::  diffrb_ald2     =   1.4
  integer, parameter  ::  diffrb_mald     =   1.4
  integer, parameter  ::  diffrb_ch2o     =   1.1
  integer, parameter  ::  diffrb_ch3o2h   =   1.3
  integer, parameter  ::  diffrb_nh3      =   0.9
  integer, parameter  ::  diffrb_pan      =   1.7
  integer, parameter  ::  diffrb_co       =   1.2
  integer, parameter  ::  diffrb_ch3coo2h =   1.5
  integer, parameter  ::  diffrb_hcooh    =   1.3
  integer, parameter  ::  diffrb_hno2     =   1.3
  integer, parameter  ::  diffrb_hno4     =   0.0     ! <--- dummy
  !
  !  -- parallel soil resistance, the resistances of the trace gases
  ! of the Wesely scheme are calculated assuming a O3 soil resistance
  ! of 400 s m-1, for SO2 rsoil=100 s m-1 and the wet skin resistance of
  ! O3 is 2000 s m-1 whereas rws SO2 is 100 s m-1.
  !
  integer, parameter  ::  rsoil_o3       =  400.0
  integer, parameter  ::  rsoil_hno3     =    1.0
  integer, parameter  ::  rsoil_no       =    1.0e+5
  integer, parameter  ::  rsoil_no2      =  600.0
  integer, parameter  ::  rsoil_so2      =  100.0
  integer, parameter  ::  rsoil_so4      =  999.
  integer, parameter  ::  rsoil_h2o2     =   80.0
  integer, parameter  ::  rsoil_mald     = 1.e+5
  integer, parameter  ::  rsoil_ald2     =    1.0e+5
  integer, parameter  ::  rsoil_ch2o     = 1666.0
  integer, parameter  ::  rsoil_ch3o2h   = 3650.0
  integer, parameter  ::  rsoil_nh3      =  100.0
  integer, parameter  ::  rsoil_pan      = 3994.0
  integer, parameter  ::  rsoil_co       = 5000.0
  integer, parameter  ::  rsoil_ch3coo2h = 3290.0
  integer, parameter  ::  rsoil_hcooh    =    1.0
  integer, parameter  ::  rsoil_hno2     =   97.0
  integer, parameter  ::  rsoil_hno4     =    0.0     ! <--- dummy
  !
  !  -- sea water resistance, which is generally similar to the wet skin
  ! resistance except of that for SO2 due to a different pH of sea water
  ! compared to the pH of a wet canopy 
  ! note for ammonia ocean emissions we use 2-way exchange approach FD
  !
  integer, parameter  ::  rwat_o3       = 2000.0
  integer, parameter  ::  rwat_hno3     =    1.0
  integer, parameter  ::  rwat_no       =    1.0e+5
  integer, parameter  ::  rwat_no2      = 3000.0
  integer, parameter  ::  rwat_so2      =    1.0
  integer, parameter  ::  rwat_so4      =  999.0
  integer, parameter  ::  rwat_h2o2     =   72.0
  integer, parameter  ::  rwat_mald     =  300.0
  integer, parameter  ::  rwat_ald2     =  300.0
  integer, parameter  ::  rwat_ch2o     =  254.0
  integer, parameter  ::  rwat_ch3o2h   =  293.0
  integer, parameter  ::  rwat_nh3      =    1.0
  integer, parameter  ::  rwat_pan      =  295.0
  integer, parameter  ::  rwat_co       =    1.0e+5
  integer, parameter  ::  rwat_ch3coo2h =  291.0
  integer, parameter  ::  rwat_hcooh    =    1.0
  integer, parameter  ::  rwat_hno2     =   75.0
  integer, parameter  ::  rwat_hno4     =    0.0     ! <--- dummy
  !
  !  -- wet skin reservoir resistance
  !
  integer, parameter  ::  rws_o3        = 2000.0
  integer, parameter  ::  rws_hno3      =    1.0
  integer, parameter  ::  rws_no        =    1.0e+5
  integer, parameter  ::  rws_no2       = 3000.0
  integer, parameter  ::  rws_so2       =  100.0
  integer, parameter  ::  rws_so4       =  999.0
  integer, parameter  ::  rws_h2o2      =   72.0
  integer, parameter  ::  rws_mald      =  300.0
  integer, parameter  ::  rws_ald2      =  300.0
  integer, parameter  ::  rws_ch2o      =  254.0
  integer, parameter  ::  rws_ch3o2h    =  293.0
  integer, parameter  ::  rws_nh3       =    1.0
  integer, parameter  ::  rws_pan       =  295.0
  integer, parameter  ::  rws_co        =    1.0e+5
  integer, parameter  ::  rws_ch3coo2h  =  291.0
  integer, parameter  ::  rws_hno2      =   75.0
  integer, parameter  ::  rws_hcooh     =    1.0
  integer, parameter  ::  rws_hno4      =    0.0     ! <--- dummy
  !
  !  -- snow resistance, the snow/ice resistances of the trace gases
  ! of Wesely's scheme are taken same as that of the rsoil and corrected
  ! for temperatures smaller than 271 K
  !
  integer, parameter  ::  rsnow_o3       = 2000.0
  integer, parameter  ::  rsnow_hno3     =    1.0
  integer, parameter  ::  rsnow_no       =    1.0e+5
  integer, parameter  ::  rsnow_no2      = 3000.0
  integer, parameter  ::  rsnow_so2      =    1.0
  integer, parameter  ::  rsnow_so4      =  999.0
  integer, parameter  ::  rsnow_h2o2     =   80.0
  integer, parameter  ::  rsnow_mald     =    1.0e+5
  integer, parameter  ::  rsnow_ald2     =    1.0e+5
  integer, parameter  ::  rsnow_ch2o     = 1666.0
  integer, parameter  ::  rsnow_ch3o2h   = 3650.0
  integer, parameter  ::  rsnow_nh3      =    1.0e5
  integer, parameter  ::  rsnow_pan      = 3394.0
  integer, parameter  ::  rsnow_co       =    1.0e5
  integer, parameter  ::  rsnow_ch3coo2h = 3290.0
  integer, parameter  ::  rsnow_hcooh    =    1.0e+5
  integer, parameter  ::  rsnow_hno2     =   97.0
  integer, parameter  ::  rsnow_hno4     =    0.0     ! <--- dummy
  !
  !  -- mesophyll resistance
  !
  integer, parameter  ::  rmes_o3       =    1.0
  integer, parameter  ::  rmes_hno3     =    1.0
  integer, parameter  ::  rmes_no       =  500.0
  integer, parameter  ::  rmes_no2      =    1.0   
  integer, parameter  ::  rmes_so2      =    1.0
  integer, parameter  ::  rmes_so4      =  999.0
  integer, parameter  ::  rmes_h2o2     =    1.0
  integer, parameter  ::  rmes_mald     =  200.0
  integer, parameter  ::  rmes_ald2     =  200.0
  integer, parameter  ::  rmes_ch2o     =    1.0
  integer, parameter  ::  rmes_ch3o2h   =    1.0
  integer, parameter  ::  rmes_nh3      =    1.0
  integer, parameter  ::  rmes_pan      =    1.0
  integer, parameter  ::  rmes_co       = 5000.0
  integer, parameter  ::  rmes_ch3coo2h =    1.0
  integer, parameter  ::  rmes_hcooh    =    1.0
  integer, parameter  ::  rmes_hno2     =    1.0
  integer, parameter  ::  rmes_hno4     =    0.0     ! <--- dummy
  !
  !  -- cuticle resistance
  !
  integer, parameter  ::  rcut_o3       =    1.0e+5
  integer, parameter  ::  rcut_hno3     =    1.0
  integer, parameter  ::  rcut_no       =    1.0e+5
  integer, parameter  ::  rcut_no2      =    1.0e+5
  integer, parameter  ::  rcut_so2      =    1.0e+5
  integer, parameter  ::  rcut_so4      =    999.
  integer, parameter  ::  rcut_h2o2     =    1.0e+5
  integer, parameter  ::  rcut_mald     =    1.0e+5
  integer, parameter  ::  rcut_ald2     =    1.0e+5
  integer, parameter  ::  rcut_ch2o     =    1.0e+5
  integer, parameter  ::  rcut_ch3o2h   =    1.0e+5
  integer, parameter  ::  rcut_nh3      =    1.0e+5
  integer, parameter  ::  rcut_pan      =    1.0e+5
  integer, parameter  ::  rcut_co       =    1.0e+5
  integer, parameter  ::  rcut_ch3coo2h =    1.0e+5
  integer, parameter  ::  rcut_hcooh    = 2500.0
  integer, parameter  ::  rcut_hno2     =    1.0e+5
  integer, parameter  ::  rcut_hno4     =    0.0     ! <--- dummy
  ! 
  !  -- Diffusivity coefficent, to correct stomatal resistance for differences
  ! in diffusivity between water vapour and the specific trace gas
  !
  integer, parameter  ::  diffcf_o3       =   1.6
  integer, parameter  ::  diffcf_hno3     =   1.9
  integer, parameter  ::  diffcf_no       =   1.3
  integer, parameter  ::  diffcf_no2      =   1.6
  integer, parameter  ::  diffcf_so2      =   1.9
  integer, parameter  ::  diffcf_so4      =   999.
  integer, parameter  ::  diffcf_h2o2     =   1.4
  integer, parameter  ::  diffcf_mald     =   1.6
  integer, parameter  ::  diffcf_ald2     =   1.6
  integer, parameter  ::  diffcf_ch2o     =   1.3
  integer, parameter  ::  diffcf_ch3o2h   =   1.6
  integer, parameter  ::  diffcf_nh3      =   1.0
  integer, parameter  ::  diffcf_pan      =   2.6
  integer, parameter  ::  diffcf_co       =   1.2
  integer, parameter  ::  diffcf_ch3coo2h =   2.0
  integer, parameter  ::  diffcf_hcooh    =   1.6
  integer, parameter  ::  diffcf_hno2     =   1.6
  integer, parameter  ::  diffcf_hno4     =   0.0     ! <--- dummy
!
! !REVISION HISTORY: 
!   25 Mar 2010 - P. Le Sager - reintroduced SO4 parameters, added
!                               protex tags. 
!
! !REMARKS:
!  o extracted from dry_deposition.F90 codes;
!  o dummy values for HNO4, actual deposition velocity is computed from:
!       vd(HNO4) = ( vd(NO2) + vd(H2O2) )/2
!
!EOP
!------------------------------------------------------------------------------

end module deposition_data
