!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################
module chem_param

  use binas, only : xmair
  use reaction_data
#ifndef without_photolysis
  use photolysis_data
#endif
  use deposition_data

  implicit none

  !
  ! definition of the chemistry: #reactions, order of species, etc.
  ! parameters needed for chemistry and rate constants 
  !

  ! nmark: number of 'marked' tracers 
  integer, parameter :: nmark = 1
  character(len=8),dimension(nmark) :: marknam = (/ 'test    ' /)

  ! ntrace: number of tracers for chemistry
  integer, parameter :: ntrace  = 300
  ! ntracet: number of transported tracers
  integer, parameter :: ntracet = 300
  ! ntrace_chem: non-transported tracers   
  integer, parameter :: ntrace_chem  = ntrace-ntracet
  ! maxtrace: total number of tracers
  integer, parameter :: maxtrace = ntrace + 0 

  !
  ! components numbers
  !
  integer, parameter :: ico2=1 !CO2 mixing ratio
  integer, parameter :: ico2_bg=1  !CO2 fossil fuel emissions
  integer, parameter :: ico2_ff=1  !CO2 fossil fuel emissions
  integer, parameter :: ico2_bio=1
  integer, parameter :: ico2_oce=1
  integer, parameter :: ico2_fires=1
  integer, parameter :: ico2_gpp=1
  integer, parameter :: ic13_bg=2 
  integer, parameter :: ic13=2
  integer, parameter :: ic13_ff=2 
  integer, parameter :: ic13_fires=2 
  integer, parameter :: ic13_bio=2 
  integer, parameter :: ic13_oce=2
  integer, parameter :: ic13_biodis=2
  integer, parameter :: ic13_oceandis=2
  integer, parameter :: ic13_gpp=2
  integer, parameter :: ic13_res=2
  !
  ! additional fields used in chemistry routine alone 
  ! (more meteo-like files in units different from #/cm3)
  !
  integer,parameter                   :: n_extra = 0
  integer,parameter                   :: nstd    = 2
  !integer, dimension(nstd), parameter :: istd    = (/ ico2_ff, ico2_bio, ico2_oce, ico2_fires, ico2_bg, ic13_bg, ic13_ff, ic13_fires, ic13_bio, ic13_oce, ic13_biodis, ic13_ocedis /)
  integer, dimension(nstd), parameter :: istd    = (/ ico2,ic13/)
  !
  ! species name
  !
  integer, parameter              ::  tracer_name_len = 20
  character(len=tracer_name_len),dimension(maxtrace/2),parameter :: namesco2 = 'co2'
  character(len=tracer_name_len),dimension(maxtrace/2),parameter :: namesco2c13 = 'co2c13'
  
  character(len=tracer_name_len),dimension(maxtrace) :: names=(/namesco2,namesco2c13/)



  !character(len=tracer_name_len), dimension(maxtrace) :: names = (/ 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2','co2c13','co2c13','co2c13','co2c13','co2c13','co2c13','co2c13','co2c13','co2c13','co2c13'/)


  !character(len=tracer_name_len), dimension(maxtrace) :: names = (/ 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2','co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2', 'co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2','13co2'/)



!  character(len=tracer_name_len), dimension(maxtrace) :: names = (/ 'co2', 'co2', 'co2', 'co2', 'co2','13co2','13co2','13co2','13co2','13co2'/)

  !character(len=tracer_name_len), dimension(maxtrace) :: names(31:60)= '13co2'
!  character(len=tracer_name_len), dimension(maxtrace) :: names

   

  !data names(ico2_ff)      /'CO2_FF     '/
  !data names(ico2_bio)     /'CO2_BIO      '/
  !data names(ico2_oce)     /'CO2_OCE      '/
  !data names(ico2_fires)   /'CO2_FIRES    '/
  !data names(ic13_bg)      /'13CO2_BG     '/
  !data names(ic13_ff)      /'13CO2_FF     '/
  !data names(ic13_fires)   /'13CO2_FIRES  '/
  !data names(ic13_bio)     /'13CO2_BIO    '/
  !data names(ic13_oce)     /'13CO2_OCE    '/
  !data names(ic13_biodis)  /'13CO2_BIODIS '/
  !data names(ic13_ocedis)  /'13CO2_OCEDIS '/


  ! extra array to hold member number for each ensemble member

  character(len=3)         :: my_member_no = '000'
  integer                  :: nmembersloc   !WP! to become equal to ntracetloc


  integer, parameter           :: njnum = 1

  ! molar weights of components

  real,    parameter :: xmh  =  1.0079
  real,    parameter :: xmn  = 14.0067
  real,    parameter :: xmc  = 12.01115
  real,    parameter :: xmc13 = 13.00335   !new added carbon 13 isotope
  real,    parameter :: xms  = 32.064
  real,    parameter :: xmo  = 15.9994
  real,    parameter :: xmcl = 35.453


  real,    parameter :: xmco2 = xmc+2*xmo  !new added co2
  real,    parameter :: xm13co2=xmc13+2*xmo
  
!  real,    parameter :: xmo3=xmo*3
!  real,    parameter :: xmnox=xmn
!  real,    parameter :: xmh2o2=xmo*2.+xmh*2.
!  real,    parameter :: xmch4=xmc+xmh*4.
!  real,    parameter :: xmco=xmc+xmo
!  real,    parameter :: xmhno3=xmh+xmn+xmo*3.
!  real,    parameter :: xmmepe=xmc+xmh*4.+xmo*2.
!  real,    parameter :: xmch2o=xmc+xmh*2.+xmo
!  real,    parameter :: xmno=xmn+xmo
!  real,    parameter :: xmho2=xmh+xmo*2.
!  real,    parameter :: xmch3o2=xmc+2.*xmo+3.*xmh
!  real,    parameter :: xmoh=xmo+xmh
!  real,    parameter :: xmno2=xmn+2.*xmo
!  real,    parameter :: xmno3=xmn+3.*xmo
!  real,    parameter :: xmn2o5=2.*xmn+5.*xmo
!  real,    parameter :: xmhno4=xmn+4.*xmo+xmh
!  !FD real,    parameter :: xmair=28.94 
!  real,    parameter :: xmh2o=xmh*2+xmo
!  ! xmpar is the results of the CBM4 implementation...calculate as C
!  real,    parameter :: xmpar=xmc 
!  real,    parameter :: xmeth=2.*xmc 
!  real,    parameter :: xmole=2.*xmc 
!  real,    parameter :: xmisop=5.*xmc+8.*xmh
!  real,    parameter :: xmgly=3.*xmc
!  real,    parameter :: xmald2=2.*xmc 
!  real,    parameter :: xmc2o3=2.*xmc+3.*xmo+3.*xmh 
!  ! xmpan: ch3co-o2-no2 
!  real,    parameter :: xmpan=2.*xmc+3.*xmh+3.*xmo+xmn+2.*xmo
!  real,    parameter :: xmror=2.*xmc+4.*xmh
!  real,    parameter :: xmrxpar=xmc 
!  real,    parameter :: xmrooh=xmc+3.*xmh+2*xmo
!  real,    parameter :: xmorgntr=xmn
!  real,    parameter :: xmxo2=2.*xmo+xmc
!  real,    parameter :: xmxo2n=2.*xmo+xmc
!  ! attention xmso2: conversion emissions done when added...
!  real,    parameter :: xmso2=xms+2.*xmo 
!  real,    parameter :: xmdms=xms+2*xmc+6*xmh
!  ! attention xmnh3: conversion emissions when added...
!  real,    parameter :: xmnh3=xmn+3.*xmh
!  ! attention xmnh4: conversion emissions when added...
!  real,    parameter :: xmnh4=xmn+4.*xmh 
!  real,    parameter :: xmmsa=xms+xmc+3*xmo+4*xmh
!  real,    parameter :: xmnh2=xmn+xmh*2.
!  real,    parameter :: xmso4=xms+4.*xmo
!  real,    parameter :: xmno3_a=xmn+xmo*3
!  real,    parameter :: xmrn222=222.
!  real,    parameter :: xmpb210=210.
!  ! xmnmv: this is a dummy molecular mass
!  real,    parameter :: xmnmv=999. 

  ! used in wet_depos ...
  real, parameter     ::  xmhno3 = xmh + xmn + xmo*3.0

  real,dimension(maxtrace/2),parameter :: raco2 =xmco2
  real,dimension(maxtrace/2),parameter :: raco2c13 =xm13co2
  real,dimension(maxtrace),parameter :: ra =  (/raco2,raco2c13/)





!  real,dimension(maxtrace),parameter :: ra = (/xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2/)

!  real,dimension(maxtrace),parameter :: ra = (/xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xmco2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2/)



 ! real,dimension(maxtrace),parameter :: ra = (/xmco2,xmco2,xmco2,xmco2,xmco2,xm13co2,xm13co2,xm13co2,xm13co2,xm13co2/)


  real,dimension(maxtrace),parameter :: fscale = xmair/ra
  real,dimension(maxtrace),parameter      :: uscale = 1.e6


  !   fscale(ntrace): scaling factor for conversion of mixing ratios 
  !   in kg tracer per kg air to practical mixing ratio units (e.g. ppm)
  !   In this version: ratio of molecular weight  of tracer to that of air 


  ! ********************************************************************
  ! rates
  ! ********************************************************************

  ! heterogeneous removal rates
  real                    :: henry(ntracet,ntemp)


  ! ********************************************************************
  ! dummy tracers
  ! ********************************************************************

  ! dummy indices for tracers not included in this chemistry;
  ! comparision of tracer index with this numbers will fail ...
  
  integer, parameter   ::  iso2  = -999
  integer, parameter   ::  iso4  = -998
  integer, parameter   ::  inh3  = -997
  integer, parameter   ::  ihno3 = -996
  integer, parameter   ::  ino   = -995
  integer, parameter   ::  ino2  = -994
  integer, parameter   ::  io3   = -993
  integer, parameter   ::  ihno4 = -992
  integer, parameter   ::  ih2o2 = -991


  ! ********************************************************************
  ! aerosol
  ! ********************************************************************

  real, parameter         :: density_ref = 1800.0   ! for 'reference' density calculations


  ! ********************************************************************
  ! dry deposition
  ! ********************************************************************

  ! number of tracers on which dry depositions should be applied:
  integer, parameter  ::  ndep = 0

  ! tracer indices on which dry depositions should be applied:
  integer, parameter  ::  idep(1) = (/ -999 /)

  ! deposition parameters:
  
  real, parameter  ::  ddep_diffrb(1) = (/ -999.9 /)

  real, parameter  ::  ddep_rsoil(1) = (/ -999.9 /)

  real, parameter  ::  ddep_rwat(1) = (/ -999.9 /)

  real, parameter  ::  ddep_rws(1) = (/ -999.9 /)

  real, parameter  ::  ddep_rsnow(1) = (/ -999.9 /)

  real, parameter  ::  ddep_rmes(1) = (/ -999.9 /)

  real, parameter  ::  ddep_rcut(1) = (/ -999.9 /)

  real, parameter  ::  ddep_diffcf(1) = (/ -999.9 /)

  ! some vd fields are copies:
  integer, parameter  ::  vd_ncopy = 0   ! dummy
  integer, parameter  ::  vd_copy_itarget(1) = (/ -999 /)
  integer, parameter  ::  vd_copy_isource(1) = (/ -999 /)


  ! number of aerosol bins used for deposition:
  integer, parameter  ::  nrdep = 0
  
  ! aerosol radii used for each bin:
  real, parameter     ::  lur(1) = (/ -999.9 /)


  ! ********************************************************************
  ! wet deposition
  ! ********************************************************************

  !
  ! nscav       : selected species for scavenging
  ! nscav_index : index for scavenging:
  ! nscav_type  : type of scavenging:
  !               0 no scavenging
  !               1 scavenging 100 % solubility assumed
  !               2 scavenging henry solubility assumed
  !               3 scavenging, aerosol removal assumed
  !               4 scavenging, special case for SO2 with aq phase diss.
  !

  integer, parameter  ::  nscav = 0

  integer, parameter  ::  nscav_index(1) = (/ -999 /)

  ! note CMK CFD: wetS accounts for removal of SO2, so nscav_type = 0
  !               nh3 is taken out anyhow, since most will be scavenged
  !               by acidic falling frops below cloud
  integer, parameter  :: nscav_type(1) =  (/ -999 /)




end module chem_param

