!#################################################################
!
! Boundary conditions
!
!### macro's #####################################################
!
#define TRACEBACK write (gol,'("in ",a," (",a,", line",i5,")")') rname, __FILE__, __LINE__; call goErr
#define IF_NOTOK_RETURN(action) if (status/=0) then; TRACEBACK; action; return; end if
#define IF_ERROR_RETURN(action) if (status> 0) then; TRACEBACK; action; return; end if
!
#include "tm5.inc"
!
!#################################################################

module boundary

  use GO          , only : gol, goPr, goErr, goLabel
  
  implicit none
  
  
  ! --- in/out ------------------------------------
  
  private
  
  public  ::  Boundary_Init, Boundary_Done
  public  ::  Boundary_Apply
  

  ! --- const --------------------------------------

  character(len=*), parameter  ::  mname = 'boundary'

  
contains


  ! ===================================================================
  
  
  subroutine Boundary_Init( status )
  
    ! --- in/out ---------------------------------------
    
    integer, intent(out)          ::  status
    
    ! --- const ---------------------------------------

    character(len=*), parameter ::  rname = mname//'/Boundary_Init'
    
    ! --- local ----------------------------------------
    
    ! --- begin ----------------------------------------
    
    ! nothing to init

    ! ok
    status = 0
    
  end subroutine Boundary_Init
  
  
  ! ***
  
    
  subroutine Boundary_Done( status )
  
    ! --- in/out ---------------------------------------
    
    integer, intent(out)          ::  status
    
    ! --- const ---------------------------------------

    character(len=*), parameter ::  rname = mname//'/Boundary_Done'
    
    ! --- local ----------------------------------------
    
    ! --- begin ----------------------------------------
    
    ! nothing to be done
    
    ! ok
    status = 0

  end subroutine Boundary_Done


  ! ***
  
  
  subroutine Boundary_Apply( region, status )

    ! --- in/out --------------------------------
    
    integer, intent(in)     ::  region
    integer, intent(out)    ::  status
    
    ! --- const --------------------------------
    
    character(len=*), parameter  ::  rname = mname//'/Boundary_Apply'
    
    ! --- local ---------------------------------

    ! --- begin ----------------------------------

    ! nothing to be applied
        
    ! ok
    status = 0

  end subroutine Boundary_Apply


end module boundary
