#!/usr/bin/env python
# model.py

"""
.. module:: observationoperator
.. moduleauthor:: Wouter Peters 

Revision History:
File created on 30 Aug 2010.

"""

import logging

identifier = 'GeneralObservationOperator'
version = '0.0'

################### Begin Class ObservationOperator ###################
class ObservationOperator(object):
    """
    Testing
    =======
    This is a class that defines an ObervationOperator. This object is used to control the sampling of
    a statevector in the ensemble Kalman filter framework. The methods of this class specify which (external) code
    is called to perform the sampling, and which files should be read for input and are written for output.

    The baseclasses consist mainly of empty methods that require an application specific application

    """

    def __init__(self, rcfilename, dacycle=None):
        """ The instance of an ObservationOperator is application dependent """
        self.ID = identifier
        self.version = version
        self.restart_filelist = []
        self.outputdir = None # Needed for opening the samples.nc files created 

        self.load_rc(rcfilename)   # load the specified rc-file
        self.validate_rc()         # validate the contents

        logging.info('Observation Operator object initialized: %s' % self.ID)

        # The following code allows the object to be initialized with a dacycle object already present. Otherwise, it can
        # be added at a later moment.

        if dacycle != None:
            self.dacycle = dacycle
        else:
            self.dacycle = {}

    
    def get_initial_data(self):
        """ This method places all initial data needed by an ObservationOperator in the proper folder for the model """

    def setup(self):
        """ Perform all steps necessary to start the observation operator through a simple Run() call """

    def validate_input(self):
        """ Make sure that data needed for the ObservationOperator (such as observation input lists, or parameter files)
            are present.
        """
    def save_data(self):
        """ Write the data that is needed for a restart or recovery of the Observation Operator to the save directory """



################### End Class ObservationOperator ###################



if __name__ == "__main__":
    pass
