!     #########
      SUBROUTINE WRITE_DIAG_MISC_TEB_n (DTCO, DGU, U, DGCT, DGMT, DGMTO, T, TOP, &
                                        HPROGRAM,KTEB_PATCH)
!     #################################
!
!!****  *WRITE_DIAG_MISC_TEB* - writes the TEB diagnostic fields
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    10/2004
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_DIAG_CUMUL_TEB_n, ONLY : DIAG_CUMUL_TEB_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTION_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODI_END_IO_SURF_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(DIAG_CUMUL_TEB_t), INTENT(INOUT) :: DGCT
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DGMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DGMTO
TYPE(TEB_t), INTENT(INOUT) :: T
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM   ! program calling
INTEGER,           INTENT(IN)  :: KTEB_PATCH ! patch number being written
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER            :: IRESP          ! IRESP  : return-code if a problem appears
INTEGER            :: JCOMP
 CHARACTER(LEN=3)  :: YPATCH         ! Prefix for current patch
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!           Initialisation for IO
!           ---------------------
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_MISC_TEB_N',0,ZHOOK_HANDLE)
CALL INIT_IO_SURF_n(DTCO, DGU, U, &
                     HPROGRAM,'TOWN  ','TEB   ','WRITE')
!
YPATCH = '   '
IF (TOP%NTEB_PATCH>1) WRITE(YPATCH,FMT='(A,I1,A)') 'T',KTEB_PATCH,'_'
!-------------------------------------------------------------------------------
!
IF (DGMTO%LSURF_MISC_BUDGET) THEN
!
!*       Miscellaneous fields :
!        ----------------------
!
YRECFM='D_RD'
YCOMMENT='Road fraction'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,T%CUR%XROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='Z0_TOWN'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='town roughness length'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,T%CUR%XZ0_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='XQF_BLD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='domestic heating'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XQF_BLD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='XQF_TOWN'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='total anthropogenic heat'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XQF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='XDQS_TOWN'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='heat storage inside building'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XDQS_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='RUNOFF_TW'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='aggregated runoff for town'//' (kg/m2/s)'
!
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='RN_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT=' net radiation at road'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='H_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='road sensible heat flux'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LE_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='road latent heat flux'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='GFLUX_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='net road conduction flux'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='RUNOFF_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='road surface runoff'//' (kg/m2/s)'
!
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
IF (TOP%CWALL_OPT=='UNIF') THEN
  !
  YRECFM='RN_WL'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for wall '//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_WL'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='wall sensible heat flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_WL'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net wall conduction flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
ELSE
  !
  YRECFM='RN_WLA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for wall A'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_WLA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='wall A sensible heat flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_WLA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net wall A conduction flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RN_WLB'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for wall B'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_WLB'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='wall B sensible heat flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_WLB'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net wall B conduction flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
YRECFM='RN_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='net radiation for roof'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='H_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='roof sensible heat flux'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LE_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='roof latent heat flux'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='GFLUX_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='net roof conduction flux'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='RUNOFF_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='aggregated roof runoff'//' (kg/m2/s)'
!
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
!
IF (TOP%LGARDEN) THEN
  !
  YRECFM='RN_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for GARDEN areas'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='GARDEN area sensible heat flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='GARDEN area latent heat flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net GARDEN area conduction flux'//YRECFM//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !
  YRECFM='RUNOFF_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='garden surface runoff'//' (kg/m2/s)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !
  IF (TOP%LURBHYDRO) THEN
     YRECFM='RUNOFF_SW'
     YRECFM=ADJUSTL(YPATCH//YRECFM)
     YCOMMENT='sewer runoff from groundwater'//' (kg/m2/s)'
!
     CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_SEWER(:),IRESP,HCOMMENT=YCOMMENT)
  ENDIF
!
ENDIF
!
YRECFM='RN_BLT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='net radiation for built surfaces'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_BLT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='H_BLT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='built surface sensible heat flux'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_BLT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LE_BLT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='built surface latent heat flux'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_BLT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='H_TRAACT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Traffic sensible heat flux'//YRECFM//' (W/m2(urb))'
!
CALL WRITE_SURF(DGU, U, &
                HPROGRAM,YRECFM,DGMT%CUR%XH_TRAFFIC_OUT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LE_TRAACT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Traffic latent heat flux'//YRECFM//' (W/m2(urb))'
!
CALL WRITE_SURF(DGU, U, & 
                HPROGRAM,YRECFM,DGMT%CUR%XLE_TRAFFIC_OUT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='H_INDACT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Industry sensible heat flux'//YRECFM//' (W/m2(urb))'
!
CALL WRITE_SURF(DGU, U, &
                HPROGRAM,YRECFM,DGMT%CUR%XH_INDUSTRY_OUT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LE_INDACT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Industry latent heat flux'//YRECFM//' (W/m2(urb))'
!
CALL WRITE_SURF(DGU, U, &
                HPROGRAM,YRECFM,DGMT%CUR%XLE_INDUSTRY_OUT(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='GFLUX_BLT'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='built surface conduction flux'//YRECFM//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_BLT(:),IRESP,HCOMMENT=YCOMMENT)
!
!
YRECFM='SWA_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Sdown absorbed by roofs'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='SWA_SN_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Sdown absorbed by snow on roofs'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_SNOW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LWA_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Ldown absorbed by roofs'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LWA_SN_RF'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Ldown absorbed by snow on roofs'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_SNOW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='SWA_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Sdown absorbed by roads'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='SWA_SN_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Sdown absorbed by snow on roads'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_SNOW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LWA_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Ldown absorbed by roads'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LWA_SN_RD'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Ldown absorbed by snow on roads'//' (W/m2)'
!
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_SNOW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
!
IF (TOP%CWALL_OPT=='UNIF') THEN
  !
  YRECFM='SWA_WL'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by wall'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_WL'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by wall '//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
ELSE
  !
  YRECFM='SWA_WLA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by wall A'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_WLA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by wall A'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_WLB'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by wall B'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_WLB'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by wall B'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
IF (TOP%LGARDEN) THEN
  !
  YRECFM='SWA_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by GARDEN areas'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_GD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by GARDEN areas'//' (W/m2)'
  !
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
!
  IF (TOP%CURBTREE/='NONE') THEN
    !
    YRECFM='SWA_HV'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by urban high vegetation'//' (W/m2)'
    !
    CALL WRITE_SURF(DGU, U, &
                   HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_HV'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by urban high vegetation'//' (W/m2)'
    !
    CALL WRITE_SURF(DGU, U, &
                   HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
ENDIF
!
YRECFM='REF_SW_GO'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Total solar rad reflected by ground '//' (W/m2)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XREF_SW_GRND(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LWE_GO'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='LW emitted by ground'//' (W/m2)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XEMIT_LW_GRND(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='REF_SW_FA'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='Total solar rad reflected by facade '//' (W/m2)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XREF_SW_FAC(:),IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LWE_FA'
YRECFM=ADJUSTL(YPATCH//YRECFM)
YCOMMENT='LW emitted by facade'//' (W/m2)'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XEMIT_LW_FAC(:),IRESP,HCOMMENT=YCOMMENT)
!
!
  IF (TOP%CBEM=='BEM') THEN
    !
    YRECFM='XFLX_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heat flux from bld'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XFLX_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible cooling demand'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='T_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total cooling demand'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XT_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !  
    YRECFM='H_BLD_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible heating demand'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_BLD_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent cooling demand'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_BLD_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent heating demand'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_BLD_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WASTE_CANY'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible waste heat to canyon'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_WASTE_CANY(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WASTE_CANY'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent waste heat to canyon'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_WASTE_CANY(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='H_WASTE_ROOF'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible waste heat at roof level'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_WASTE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WASTE_ROOF'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent waste heat at roof level'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_WASTE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='HVAC_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cooling energy consumption'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XHVAC_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XCOMP_HVAC_COOL,2)
       WRITE(YRECFM,'(A8,I1.1)') 'HVAC_CL_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='cooling energy consumption'//' (W/m2)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XCOMP_HVAC_COOL(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='HVAC_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XHVAC_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XCOMP_HVAC_HEAT,2)
       WRITE(YRECFM,'(A8,I1.1)') 'HVAC_HT_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='heating energy consumption'//' (W/m2)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XCOMP_HVAC_HEAT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='QINACT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual internal energy release'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XQINOUT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XCOMP_QINOUT,2)
       !
       WRITE(YRECFM,'(A7,I1.1)') 'QINACT_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Actual internal energy release'//' (W/m2)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XCOMP_QINOUT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
       !
    ENDDO
    !
    YRECFM='INFCALC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Calculated infiltration rate'//' (Vol/h)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XINFCALC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XDIAGSHAD,2)
       WRITE(YRECFM,'(A8,I1.1)') 'DIAGSHAD',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Shading usage'//' (1)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XDIAGSHAD(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
       !
    ENDDO
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XDIAGVENT,2)
       WRITE(YRECFM,'(A8,I1.1)') 'DIAGVENT',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Ventilation usage'//' (1)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XDIAGVENT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XDIAGVEFL,2)
       WRITE(YRECFM,'(A8,I1.1)') 'DIAGVEFL',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Ventilation echange rate'//' (1/h)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XDIAGVEFL(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    DO JCOMP=1,SIZE(DGMT%CUR%XBLDOCC,2)
       WRITE(YRECFM,'(A6,I1.1)') 'BLDOCC',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Building occupation status'//' (1)'
       CALL WRITE_SURF(DGU, U, &
                       HPROGRAM,YRECFM,DGMT%CUR%XBLDOCC(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='SENFABSTOR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sensible heat stored in urban fabric'//' (W m-2 (urb))'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XSENFABSTOR(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LATFABSTOR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Latent heat stored on urban fabric'//' (W m-2 (urb))'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XLATFABSTOR(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='ROOFTK'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total roof thickness'//' (m)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XROOFTK(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='WALLTK'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total wall thickness'//' (m)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XWALLTK(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='MASSTK'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total mass thickness'//' (m)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XMASSTK(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='U_LOWCAN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Wind speed at lowest level of canyon'//' (m/s)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XU_LOWCAN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='ROAD_SHADE'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Fraction of road shaded'//' (1)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XROAD_SHADE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='QIN_KWH'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Internal heat release'//' (kWh/m²(floor)/s)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XQIN_KWH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT_KWH'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Heating energy demand'//' (kWh/m²(floor)/s)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XHVAC_HT_KWH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_CL_KWH'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cooling energy demand'//' (kWh/m²(floor)/s)'
    CALL WRITE_SURF(DGU, U, &
                    HPROGRAM,YRECFM,DGMT%CUR%XHVAC_CL_KWH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='CAP_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual capacity of the cooling system'//' (W m-2(bld))'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XCAP_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='M_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual HVAC mass flow rate'//' (kg s-1 m-2(bld))'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XM_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='COP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual COP of the cooling system'//' ()'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XCOP(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='Q_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Supply air specific humidity'//' (kg kg-1)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XQ_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='T_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Supply air temperature'//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XT_SYS(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='TR_SW_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Solar radiation transmitted through windows'//' (W m-2(bld))'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XTR_SW_WIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='FAN_POWER'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='HVAC fan power'//' (W m-2(bld))'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XFAN_POWER(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='T_RAD_IND'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Indoor mean radiant temperature'//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XT_RAD_IND(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by windows'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_WIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by windows'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_WIN(:),IRESP,HCOMMENT=YCOMMENT)    
    !
  ENDIF
  !
  IF (TOP%LGREENROOF) THEN
  !
    WHERE (T%CUR%XGREENROOF(:) == 0.)
      DGMT%CUR%XRN_GREENROOF    (:) = XUNDEF   
      DGMT%CUR%XH_GREENROOF     (:) = XUNDEF 
      DGMT%CUR%XLE_GREENROOF    (:) = XUNDEF 
      DGMT%CUR%XGFLUX_GREENROOF (:) = XUNDEF 
      DGMT%CUR%XABS_SW_GREENROOF(:) = XUNDEF 
      DGMT%CUR%XABS_LW_GREENROOF(:) = XUNDEF 
      DGMT%CUR%XG_GREENROOF_ROOF(:) = XUNDEF 
      DGMT%CUR%XRUNOFF_GREENROOF(:) = XUNDEF 
      DGMT%CUR%XDRAIN_GREENROOF (:) = XUNDEF 
    END WHERE
    !
    YRECFM='RN_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible heat flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent heat flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net conduction flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='G_GR_ROOF'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heat flux between GREENROOF and ROOF'//' (W/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XG_GREENROOF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF soil surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAIN_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF total vertical drainage'//' (kg/m2/s)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XDRAIN_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
    WHERE (T%CUR%XGREENROOF(:) == 1.)
      DGMT%CUR%XRN_STRLROOF(:)     = XUNDEF   
      DGMT%CUR%XH_STRLROOF(:)      = XUNDEF   
      DGMT%CUR%XLE_STRLROOF(:)     = XUNDEF   
      DGMT%CUR%XGFLUX_STRLROOF(:)  = XUNDEF   
      DGMT%CUR%XRUNOFF_STRLROOF(:) = XUNDEF   
    END WHERE
    !
    YRECFM='RN_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof net radiation'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof sensible heat flux'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof latent heat flux'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XLE_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof conduction flux'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XGFLUX_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof surface runoff'//' (kg/m2/s)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRUNOFF_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  !* solar panels
  IF (TOP%LSOLAR_PANEL) THEN
    YRECFM='SWA_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Shortwave absorbed by solar panels on roofs'//' (W/m2 panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_SW_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Longwave  absorbed by solar panels on roofs'//' (W/m2 panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XABS_LW_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RN_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Net radiation of solar panels on roofs'//' (W/m2 panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XRN_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sensible Heat flux  from solar panels on roofs'//' (W/m2 panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XH_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='PHOT_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Photovolatic production '//' (W/m2 photovoltaic panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XPHOT_PROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THER_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Hot Water production '//' (W/m2 thermal panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XTHER_PROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='PROD_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Production by solar panels on roofs'//' (W/m2 panel)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XPROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
        !
    YRECFM='PHOT_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Photovolatic production '//' (W/m2 bld)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XPHOT_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THER_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Hot Water production '//' (W/m2 bld)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGMT%CUR%XTHER_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
!
!*
!*       3. Cumulated fields
!           ----------------
!
!
  IF  (TOP%CBEM=='BEM') THEN
  !
  YRECFM='HVACC_CL'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated cooling energy consumption'//' (J/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XHVACC_COOL(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HVACC_HT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated heating energy consumption'//' (J/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XHVACC_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QINACTCUM'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated internal energy release'//' (J/m2)'
  CALL WRITE_SURF(DGU, U, &
                  HPROGRAM,YRECFM,DGCT%CUR%XQINOUTCUM(:),IRESP,HCOMMENT=YCOMMENT)
  !
  END IF
  !
  YRECFM='RUNOFFC_TW'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated aggregated runoff for town'//' (kg/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFFC_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated road surface runoff'//' (kg/m2 road)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFFC_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated aggregated roof runoff'//' (kg/m2 roof)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='IRRIGC_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated road irrigation'//' (kg/m2 road)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XIRRIGC_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='RUNOFFC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden surface runoff'//' (kg/m2 garden)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAINC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden surface drainage'//' (kg/m2 garden)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XDRAINC_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='IRRIGC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden irrigation'//' (kg/m2 garden)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XIRRIGC_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (TOP%LURBHYDRO) THEN
       YRECFM='RUNOFFC_SW'
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='cumulated groundwater drainage to sewer pipes'//' (kg/m2)'
       CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_SEWER(:),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
  END IF
  !
  IF (TOP%LGREENROOF) THEN
    !
    WHERE (T%CUR%XGREENROOF(:) == 0.)
      DGCT%CUR%XRUNOFFC_GREENROOF (:) = XUNDEF   
      DGCT%CUR%XDRAINC_GREENROOF  (:) = XUNDEF 
      DGCT%CUR%XIRRIGC_GREENROOF  (:) = XUNDEF 
    END WHERE
    !  
    YRECFM='RUNOFFC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated soil surface runoff'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAINC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated total vertical drainage'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XDRAINC_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    !
    YRECFM='IRRIGC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated irrigation'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XIRRIGC_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    WHERE (T%CUR%XGREENROOF(:) == 1.)
      DGCT%CUR%XRUNOFFC_STRLROOF  (:) = XUNDEF   
    END WHERE 
    !
    YRECFM='RUNOFFC_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated structural roof surface runoff'//' (kg/m2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XRUNOFFC_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !  
  !* solar panels
  IF (TOP%LSOLAR_PANEL) THEN
    !
    YRECFM='PHOTC_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cumulated Photovolatic production '//' (J/m2 bld)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XPHOT_PROD_BLDC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THERC_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cumulated Hot water production '//' (J/m2 bld)'
    !
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DGCT%CUR%XTHER_PROD_BLDC(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
!
END IF
!
!
!-------------------------------------------------------------------------------
!
!         End of IO
!
 CALL END_IO_SURF_n(HPROGRAM)
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_MISC_TEB_N',1,ZHOOK_HANDLE)
!
END SUBROUTINE WRITE_DIAG_MISC_TEB_n
