!     #########################
SUBROUTINE WRITE_BLD_DESCRIPTION_n(DGU, U, BDD, HPROGRAM)
  !     #########################
  !
  !!
  !!    PURPOSE
  !!    -------
  !!
  !!    METHOD
  !!    ------
  !!
  !!
  !!    EXTERNAL
  !!    --------
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!    AUTHOR
  !!    ------
  !!
  !!    V. Masson        Meteo-France
  !!
  !!    MODIFICATION
  !!    ------------
  !!
  !!    Original    05/2012 
  !
  !----------------------------------------------------------------------------
  !
  !*    0.     DECLARATION
  !            -----------
  !
  USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
  USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
  !
  USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
  !
  USE MODI_WRITE_SURF
  USE MODI_ABOR1_SFX
  !
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  IMPLICIT NONE
  !
  !*    0.1    Declaration of arguments
  !            ------------------------
  !
  TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
  TYPE(SURF_ATM_t), INTENT(INOUT)      :: U
  TYPE(BLD_DESC_t), INTENT(INOUT)      :: BDD
  CHARACTER(LEN=6),  INTENT(IN)        :: HPROGRAM
  !
  !
  !*    0.2    Declaration of local variables
  !      ------------------------------
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  REAL, DIMENSION(:), ALLOCATABLE :: ZWORK
  INTEGER                         :: IRESP
  INTEGER                         :: I1, I2
  INTEGER                         :: JL
  INTEGER                         :: ITOT
  CHARACTER(LEN=100)              :: YCOMMENT
  !-------------------------------------------------------------------------------
  !-------------------------------------------------------------------------------
  !
  IF (LHOOK) CALL DR_HOOK('WRITE_BLD_DESCRIPTION_n',0,ZHOOK_HANDLE)
  !
  !-------------------------------------------------------------------------------
  !
  !*    1.   Writes configuration variables of the descriptive data
  !          ------------------------------------------------------
  !
  ALLOCATE(ZWORK(20))
  ZWORK(:)=-7777.0
  !
  ZWORK(01) = FLOAT(BDD%NDESC_BLD)
  ZWORK(02) = FLOAT(BDD%NDESC_AGE)
  ZWORK(03) = FLOAT(BDD%NDESC_USE)
  ZWORK(04) = FLOAT(BDD%NDESC_TER)
  ZWORK(05) = FLOAT(BDD%NDESC_CODE)
  ZWORK(06) = FLOAT(BDD%NDESC_CASE_SCHED)
  ZWORK(07) = FLOAT(BDD%NDESC_CASE_HOLIDAY)
  ZWORK(08) = FLOAT(BDD%NDESC_NDAY_SCHED)
  ZWORK(09) = FLOAT(BDD%NDESC_NCRE_SCHED)
  ZWORK(10) = FLOAT(BDD%NDESC_HOLIDAY)
  ZWORK(11) = FLOAT(BDD%NDESC_HEAT)
  ZWORK(12) = FLOAT(BDD%NDESC_COOL)
  ZWORK(13) = FLOAT(BDD%NDESC_OCC)    
  ZWORK(14) = FLOAT(BDD%NDESC_QIN)    
  ZWORK(15) = FLOAT(BDD%NDESC_VENT)  
  ZWORK(16) = FLOAT(BDD%NDESC_WALL_LAYER)
  ZWORK(17) = FLOAT(BDD%NDESC_ROOF_LAYER)
  ZWORK(18) = FLOAT(BDD%NDESC_ROAD_LAYER)
  ZWORK(19) = FLOAT(BDD%NDESC_FLOOR_LAYER)
  ZWORK(20) = FLOAT(BDD%NDESC_MASS_LAYER)
  !
  YCOMMENT='Configuration numbers for descriptive building data'
  CALL WRITE_SURF(DGU, U, HPROGRAM,'BLD_DESC_CNF',ZWORK,IRESP,YCOMMENT,'-','Bld_dimensions  ')
  DEALLOCATE(ZWORK)
  !
  !-------------------------------------------------------------------------------
  !
  !*    3.   Writes descriptive data
  !          -----------------------
  !
  ITOT = BDD%NDESC_CODE * ( 27  + 3 * BDD%NDESC_ROOF_LAYER  + 3 * BDD%NDESC_ROAD_LAYER               + &
       3 * BDD%NDESC_WALL_LAYER + 3 * BDD%NDESC_FLOOR_LAYER + 3 * BDD%NDESC_MASS_LAYER )             + &
       10 * BDD%NDESC_COOL + 10 * BDD%NDESC_HEAT + 7 * BDD%NDESC_QIN + 12 * BDD%NDESC_VENT           + &
       BDD%NDESC_CASE_SCHED   * (BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED + BDD%NDESC_NDAY_SCHED + 1) + &
       BDD%NDESC_CASE_HOLIDAY * (2* BDD%NDESC_HOLIDAY + 2) + &
       BDD%NDESC_OCC*(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED + 1)
  !
  ALLOCATE(ZWORK(ITOT))
  !
  I1=0 ; I2=0
  !
  ! Indices
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_BLD_LIST(:))
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_AGE_LIST(:))
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_USE_LIST(:))
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_TER_LIST(:))
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_CODE_LIST(:))
  !
  ! Building architectural characteristics
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_ALB_ROOF(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_EMIS_ROOF(:)
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_HC_ROOF(:,JL)
  END DO
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_TC_ROOF(:,JL)
  END DO
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_D_ROOF (:,JL) 
  END DO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_ALB_ROAD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_EMIS_ROAD(:)
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_HC_ROAD(:,JL)
  END DO
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_TC_ROAD(:,JL) 
  END DO
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_D_ROAD (:,JL)
  END DO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_ALB_WALL(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_EMIS_WALL(:)
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_HC_WALL(:,JL)
  END DO
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_TC_WALL(:,JL) 
  END DO
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_D_WALL (:,JL)
  END DO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_ISOROOFPOS(:))
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_ISOWALLPOS(:))
  !
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_HC_FLOOR(:,JL)
  END DO
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_TC_FLOOR(:,JL) 
  END DO
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_D_FLOOR (:,JL)
  END DO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_ISMASS(:)
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_HC_MASS(:,JL)
  END DO
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_TC_MASS(:,JL) 
  END DO
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_D_MASS (:,JL)
  END DO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_N50(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_GR(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_U_WIN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_SHGC(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_SHGC_SH(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_SHADEARCHI(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_ISMECH(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_MECHRATE(:)
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_GREENROOF(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_EMIS_PANEL(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_ALB_PANEL(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_EFF_PANEL(:)
  CALL UP_DESC_IND_W(BDD%NDESC_CODE) ; ZWORK(I1:I2) = BDD%XDESC_FRAC_PANEL(:)
  !
  ! Behavioural characteristics
  !
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_HEATUSEV(:))
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_FLDT(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_FIDT(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_FHDT(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_THEAT_OCCD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_THEAT_OCCN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_THEAT_VCDD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_THEAT_VCDN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_THEAT_VCLD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_HEAT) ; ZWORK(I1:I2) = BDD%XDESC_FNOHEAT   (:)
  !
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_COOLUSEV(:))
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_TCOOL_OCCD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_TCOOL_OCCN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_TCOOL_VCDD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_TCOOL_VCDN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_TCOOL_VCLD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_F_WATER_COND(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_F_WASTE_CAN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_COP_RAT(:)
  CALL UP_DESC_IND_W(BDD%NDESC_COOL) ; ZWORK(I1:I2) = BDD%XDESC_HR_TARGET(:)
  !
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_QINUSEV(:))
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = BDD%XDESC_QIN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = BDD%XDESC_QIN_FRAD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = BDD%XDESC_QIN_FLAT(:)
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = BDD%XDESC_MODQIN_VCD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = BDD%XDESC_MODQIN_VLD(:)
  CALL UP_DESC_IND_W(BDD%NDESC_QIN)  ; ZWORK(I1:I2) = BDD%XDESC_MODQIN_NIG(:)
  !
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_VENTUSEV(:))
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_NATVENT(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FVSUM(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FVNIG(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FVSHO(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_TDESV(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FVVAC(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FOPEN(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FSSUM(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FSNIG(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_FSVAC(:)
  CALL UP_DESC_IND_W(BDD%NDESC_VENT) ; ZWORK(I1:I2) = BDD%XDESC_WIN_SW_MAX(:)
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CASE_SCHED) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_SCEUSEV(:))
  !
  DO JL=1,BDD%NDESC_NDAY_SCHED
     CALL UP_DESC_IND_W(BDD%NDESC_CASE_SCHED) ; ZWORK(I1:I2) = BDD%XDESC_DAYWBEG_SCHED(:,JL)
  ENDDO
  !
  DO JL=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
     CALL UP_DESC_IND_W(BDD%NDESC_CASE_SCHED) ; ZWORK(I1:I2) = BDD%XDESC_HOURBEG_SCHED(:,JL)
  ENDDO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_CASE_HOLIDAY) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_HOLUSEV(:))
  CALL UP_DESC_IND_W(BDD%NDESC_CASE_HOLIDAY) ; ZWORK(I1:I2) = BDD%XDESC_MOD_HOLIDAY(:)
  !
  DO JL=1,BDD%NDESC_HOLIDAY
     CALL UP_DESC_IND_W(BDD%NDESC_CASE_HOLIDAY) ; ZWORK(I1:I2) = BDD%XDESC_BEG_HOLIDAY(:,JL)
  ENDDO
  !
  DO JL=1,BDD%NDESC_HOLIDAY
     CALL UP_DESC_IND_W(BDD%NDESC_CASE_HOLIDAY) ; ZWORK(I1:I2) = BDD%XDESC_END_HOLIDAY(:,JL)
  ENDDO
  !
  CALL UP_DESC_IND_W(BDD%NDESC_OCC) ; ZWORK(I1:I2) = FLOAT(BDD%NDESC_OCCUSEV(:))
  !
  DO JL=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
     CALL UP_DESC_IND_W(BDD%NDESC_OCC) ; ZWORK(I1:I2) = BDD%XDESC_PROBOCC(:,JL)
  ENDDO
  !
  YCOMMENT='Descriptive building data'
  CALL WRITE_SURF(DGU, U, HPROGRAM,'BLD_DESC_DAT',ZWORK,IRESP,YCOMMENT,'-','Bld_parameters  ')
  !
  DEALLOCATE(ZWORK)
  !
  IF (LHOOK) CALL DR_HOOK('WRITE_BLD_DESCRIPTION_n',1,ZHOOK_HANDLE)
  !-------------------------------------------------------------------------------
CONTAINS
  SUBROUTINE UP_DESC_IND_W(K)
    INTEGER, INTENT(IN) :: K
    I1=I2+1
    I2=I2+K
  END SUBROUTINE UP_DESC_IND_W
  !-------------------------------------------------------------------------------
  !
END SUBROUTINE WRITE_BLD_DESCRIPTION_n
