!     #########
      SUBROUTINE URBTREE_PROPERTIES(TM, GDM,                                   &
                                    NCAN,                                      &
                                    PLEAF_ASP_RATIO, PTRANS_HVEG, PTRANS_HVCR  )
!     ##########################################################################
!
!!****  *URBTREE_PROPERTIES*  
!!
!!    PURPOSE
!!    -------
!
!     Calculates leaf area density profile for urban trees thanks to 
!!    effective LAI and shape of crown
!         
!!    EXTERNAL
!!    --------
!!
!!    none
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------ 
!!      
!!    AUTHOR
!!    ------
!!
!!    E. Redon & A. Lemonsu           * Meteo-France *
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_SURFEX_n ,ONLY : TEB_MODEL_t, TEB_GARDEN_MODEL_t
!
USE MODD_SURF_PAR ,ONLY : XUNDEF
!
USE MODD_URBTREE  ,ONLY : XTAU_SWHV
!
USE MODD_CSTS     ,ONLY : XPI
!
USE YOMHOOK       ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1      ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
TYPE(TEB_MODEL_t)       , INTENT(INOUT) :: TM
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
!
INTEGER,              INTENT(IN)   :: NCAN            ! Number of layers in the canyon
                                                      ! (only even number)
REAL, DIMENSION(:),   INTENT(OUT)  :: PLEAF_ASP_RATIO ! leaf aspect ratio
REAL, DIMENSION(:,:), INTENT(OUT)  :: PTRANS_HVEG     ! transmissivity profile by layer trough urban trees crown
                                                      ! within 3 urban layers
                                                      ! (0,1/4) : first level
                                                      ! (1/4,3/4) : second level
                                                      ! (3/4,PBLD_HEIGHT) : third level
REAL, DIMENSION(:),   INTENT(OUT)  :: PTRANS_HVCR     ! transmissivity profile by layer trough all urban trees crown
!-------------------------------------------------------------------------------
!
!*      0.2    Local variables
!              ---------------
!
INTEGER                                          :: JL,JI           ! Loop variable
INTEGER                                          :: JIND1,JIND2     ! Number of crown layers (JL) included in
!
REAL, DIMENSION(4)                               :: ZINF,ZSUP       ! Vertical grid inside canyon (intermediate variables for calculation)
REAL, DIMENSION(SIZE(GDM%TGDP%XLAI_HVEG),4)      :: ZH              ! Foliage thickness in vertical layers of canyon
!
REAL, DIMENSION(SIZE(GDM%TGDP%XLAI_HVEG))        :: ZLAI_EFF        ! Effective LAI
REAL, DIMENSION(SIZE(GDM%TGDP%XLAI_HVEG),NCAN)   :: ZLAD_HVEG       ! leaf area density
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!*     1.     INITIALIZATION
!             --------------
!
ZLAI_EFF    (:)   = XUNDEF
PTRANS_HVEG (:,:) = XUNDEF
ZLAD_HVEG   (:,:) = XUNDEF
!
!
!-------------------------------------------------------------------------------
!
!*     2.     EFFECTIVE LAI 
!             -------------
!
ZLAI_EFF(:) = 1/XTAU_SWHV * (1 - EXP(-XTAU_SWHV * GDM%TGDP%XLAI_HVEG(:)))
!
!-------------------------------------------------------------------------------
!
!
!*     3.     LEAF ASPECT RATIO 
!             ------------------
!
PLEAF_ASP_RATIO(:) = ZLAI_EFF(:)*GDM%TGDP%XFRAC_HVEG(:)
!
!-------------------------------------------------------------------------------
!
!
!*     4.     TRANSMISSIVITY PROFILE
!             -------------------------
!
! Nouvelle hypothèse
! Discretization of height of crown between 3 canyon layers
! LAYER1=[0;1/2h] , LAYER2=[1/4h;3/4h] , LAYER3=[1/2h;h] 
!
ZH(:,:) = 0.
!
DO JI = 1,SIZE(GDM%TGDP%XLAI_HVEG)
!
  ZINF(1) = 0.
  ZINF(2) = TM%T%CUR%XBLD_HEIGHT(JI)*1./4.
  ZINF(3) = TM%T%CUR%XBLD_HEIGHT(JI)*1./2.
  ZINF(4) = TM%T%CUR%XBLD_HEIGHT(JI)*3./4.
!
  ZSUP(1) = TM%T%CUR%XBLD_HEIGHT(JI)*1./4.
  ZSUP(2) = TM%T%CUR%XBLD_HEIGHT(JI)*1./2.
  ZSUP(3) = TM%T%CUR%XBLD_HEIGHT(JI)*3./4.
  ZSUP(4) = TM%T%CUR%XBLD_HEIGHT(JI)
!
  DO JL = 1,4
!
    IF (GDM%TGDP%XHTRUNK_HVEG(JI) .GT. ZSUP(JL)) THEN
      ZH(JI,JL) = 0.
    ELSE IF (GDM%TGDP%XH_TREE(JI) .LE. ZINF(JL)) THEN
      ZH(JI,JL) = 0.
    ELSE
      IF (GDM%TGDP%XHTRUNK_HVEG(JI) .GT. ZINF(JL)) THEN
        IF (GDM%TGDP%XH_TREE(JI) .GT. ZSUP(JL)) THEN
          ZH(JI,JL) = ZSUP(JL)-GDM%TGDP%XHTRUNK_HVEG(JI)
        ELSE
          ZH(JI,JL) = GDM%TGDP%XH_TREE(JI)-GDM%TGDP%XHTRUNK_HVEG(JI)
        ENDIF
      ELSE
        IF (GDM%TGDP%XH_TREE(JI) .GT. ZSUP(JL)) THEN
          ZH(JI,JL) = ZSUP(JL)-ZINF(JL)
        ELSE
          ZH(JI,JL) = GDM%TGDP%XH_TREE(JI)-ZINF(JL)
        ENDIF
      ENDIF
    ENDIF
!
  ENDDO
!
  ZLAD_HVEG(JI,1)   = GDM%TGDP%XLAI_HVEG(JI) * ( (ZH(JI,1)+ZH(JI,2))/ (GDM%TGDP%XH_TREE(JI)-GDM%TGDP%XHTRUNK_HVEG(JI)) )
  ZLAD_HVEG(JI,2)   = GDM%TGDP%XLAI_HVEG(JI) * ( (ZH(JI,2)+ZH(JI,3))/ (GDM%TGDP%XH_TREE(JI)-GDM%TGDP%XHTRUNK_HVEG(JI)) )
  ZLAD_HVEG(JI,3)   = GDM%TGDP%XLAI_HVEG(JI) * ( (ZH(JI,3)+ZH(JI,4))/ (GDM%TGDP%XH_TREE(JI)-GDM%TGDP%XHTRUNK_HVEG(JI)) )
  ! Case SOLENE
  PTRANS_HVEG(JI,:) = 1. - 0.5 * ZLAD_HVEG(JI,:) / GDM%TGDP%XLAI_HVEG(JI)
!
ENDDO
!
!Calculation of transmissivity through all crown (vertically)
  PTRANS_HVCR(:) = EXP(-XTAU_SWHV * GDM%TGDP%XLAI_HVEG(:) )
  ! Case SOLENE
  PTRANS_HVCR(:) = 0.5
!
IF (LHOOK) CALL DR_HOOK('URBTREE_PROPERTIES',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE URBTREE_PROPERTIES
