!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE READ_PGD_ISBA_PAR_n (DTCO, U, &
                                       DTI, IG, I, &
                                      HPROGRAM,KSIZE,OLAND_USE,HDIR)
!     ################################################
!
!!****  *READ_PGD_ISBA_PAR_n* - reads ISBA physiographic fields                     
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      P. Le Moigne 12/2004 : add type of photosynthesis 
!!      P. Samuelsson 02/2012 : MEB
!!      M.Moge    01/2016  using READ_SURF_FIELD2D/3D for 2D/3D surfex fields reads
!!      B. Decharme    01/16 : Bug when vegetation veg, z0 and emis are imposed whith interactive vegetation
!!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_GRID_n, ONLY : ISBA_GRID_t
USE MODD_ISBA_n, ONLY : ISBA_t
!
USE MODD_ASSIM, ONLY : LREAD_ALL, LASSIM
!
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE
USE MODD_PREP,           ONLY : LINTERP
!
!
USE MODI_GET_LUOUT
USE MODI_READ_SURF
USE MODI_READ_SURF_FIELD2D
USE MODI_HOR_INTERPOL
USE MODI_READ_SURF_ISBA_PAR_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
TYPE(ISBA_GRID_t), INTENT(INOUT) :: IG
TYPE(ISBA_t), INTENT(INOUT) :: I
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
INTEGER,           INTENT(IN)  :: KSIZE
LOGICAL,           INTENT(IN)  :: OLAND_USE ! 
 CHARACTER(LEN=1),OPTIONAL,INTENT(IN)  :: HDIR       ! type of field :
!                                                   ! 'H' : field with
!                                                   !       horizontal spatial dim.
!                                                   ! '-' : no horizontal dim.
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
REAL, DIMENSION(KSIZE,NVEGTYPE) :: ZFIELD
REAL,    DIMENSION(:,:), ALLOCATABLE :: ZWORK
INTEGER           :: ILUOUT
INTEGER           :: ITIME
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=16) :: YRECFM2
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
 CHARACTER(LEN=1)  :: YDIR
INTEGER           :: JTIME          ! loop index
INTEGER           :: JLAYER         ! loop index
INTEGER           :: JPATCH         ! loop index
INTEGER           :: IVERSION       ! surface version
INTEGER           :: IBUGFIX
INTEGER           :: ISIZE_LMEB_PATCH
!
LOGICAL :: GREAD_ALL
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_ISBA_PAR_N',0,ZHOOK_HANDLE)
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
YDIR = 'H'
IF (PRESENT(HDIR)) YDIR = HDIR
!
IF (LASSIM) THEN
  GREAD_ALL = LREAD_ALL
  LREAD_ALL = .TRUE.
ENDIF
!
YRECFM='VERSION'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,IVERSION,IRESP)
WRITE(ILUOUT,*) 'read version ',IVERSION
!
YRECFM='BUG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,IBUGFIX,IRESP)
!
ISIZE_LMEB_PATCH=COUNT(I%LMEB_PATCH(:))
!
DTI%LDATA_MIXPAR = .FALSE. 
!
IF (IVERSION<7 .AND. .NOT.I%LECOCLIMAP) THEN
  !
  DTI%LDATA_VEGTYPE=.TRUE.
  DTI%LDATA_VEG=.TRUE.
  DTI%LDATA_LAI=.TRUE.
  DTI%LDATA_Z0=.TRUE.
  DTI%LDATA_EMIS=.TRUE.
  DTI%LDATA_RSMIN=.TRUE.
  DTI%LDATA_GAMMA=.TRUE.
  DTI%LDATA_WRMAX_CF=.TRUE.
  DTI%LDATA_RGL=.TRUE.
  DTI%LDATA_CV=.TRUE.
  DTI%LDATA_Z0_O_Z0H=.TRUE.
  DTI%LDATA_DG=.TRUE.
  DTI%LDATA_ROOTFRAC=.TRUE.
  !
  DTI%LDATA_DICE=.FALSE.
  DTI%LDATA_GROUND_DEPTH=.FALSE.
  DTI%LDATA_ROOT_DEPTH=.FALSE.
  DTI%LDATA_ROOT_LIN=.FALSE.
  DTI%LDATA_ROOT_EXTINCTION=.FALSE.  
  !
  DTI%LDATA_ALBNIR_VEG=.TRUE.
  DTI%LDATA_ALBVIS_VEG=.TRUE.
  DTI%LDATA_ALBUV_VEG=.TRUE.
  DTI%LDATA_ALBNIR_SOIL=.TRUE.
  DTI%LDATA_ALBVIS_SOIL=.TRUE.
  DTI%LDATA_ALBUV_SOIL=.TRUE.
  DTI%LDATA_GMES=.TRUE.
  DTI%LDATA_BSLAI=.TRUE.
  DTI%LDATA_LAIMIN=.TRUE.
  DTI%LDATA_SEFOLD=.TRUE.
  DTI%LDATA_GC=.TRUE.
  DTI%LDATA_DMAX=.TRUE.
  DTI%LDATA_F2I=.TRUE.
  DTI%LDATA_STRESS=.TRUE.
  DTI%LDATA_H_TREE=.TRUE.
  DTI%LDATA_RE25=.TRUE.
  DTI%LDATA_CE_NITRO=.TRUE.
  DTI%LDATA_CF_NITRO=.TRUE.
  DTI%LDATA_CNA_NITRO=.TRUE.
  !
  DTI%LDATA_IRRIG=.FALSE.
  DTI%LDATA_WATSUP=.FALSE.
  !
ENDIF
!
IF ((IVERSION<8.AND..NOT.I%LECOCLIMAP).OR.ISIZE_LMEB_PATCH==0.0) THEN
  !
  DTI%LDATA_GNDLITTER=.FALSE.
  DTI%LDATA_RGLGV=.FALSE.
  DTI%LDATA_GAMMAGV=.FALSE.
  DTI%LDATA_RSMINGV=.FALSE.
  DTI%LDATA_ROOTFRACGV=.FALSE.
  DTI%LDATA_WRMAX_CFGV=.FALSE.
  DTI%LDATA_LAIGV=.FALSE.
  DTI%LDATA_Z0LITTER=.FALSE.
  DTI%LDATA_H_VEG=.FALSE.
  DTI%LDATA_ROOT_DEPTHGV=.FALSE.
  DTI%LDATA_ROOT_EXTINCTIONGV=.FALSE.
  !
ENDIF
!
DTI%LIMP_VEG=.FALSE.
DTI%LIMP_Z0=.FALSE.
DTI%LIMP_EMIS=.FALSE.
!
IF (.NOT.OLAND_USE) THEN
  !
  IF (IVERSION>=7) THEN
    !
    YRECFM='L_VEGTYPE'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_VEGTYPE,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_VEGTYPE) DTI%LDATA_MIXPAR = .TRUE.
    !
    YRECFM='L_VEG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_VEG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_VEG) THEN
        DTI%LDATA_MIXPAR = .TRUE.
        DTI%LIMP_VEG     = .TRUE.
    ENDIF
    YRECFM='L_LAI'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_LAI,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_LAI) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_Z0'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_Z0,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_Z0) THEN
        DTI%LDATA_MIXPAR = .TRUE.
        DTI%LIMP_Z0      = .TRUE.
    ENDIF
    YRECFM='L_EMIS'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_EMIS,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_EMIS) THEN
        DTI%LDATA_MIXPAR = .TRUE.
        DTI%LIMP_EMIS    = .TRUE.
    ENDIF
    !
    YRECFM='L_RSMIN'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_RSMIN,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_RSMIN) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GAMMA'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_GAMMA,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_GAMMA) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_WRMAX_CF'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_WRMAX_CF,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_WRMAX_CF) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RGL'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_RGL,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_RGL) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_CV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_CV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_Z0_O_Z0H'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_Z0_O_Z0H,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_Z0_O_Z0H) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_DG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_DG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_DG) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ROOTFRAC'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOTFRAC,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ROOTFRAC) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_DICE'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_DICE,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_DICE) DTI%LDATA_MIXPAR = .TRUE.
    !
    IF ( (IVERSION==7 .AND. IBUGFIX>=2) .OR. IVERSION>7 ) THEN
      YRECFM2='L_GROUND_DPT'
      YCOMMENT=YRECFM
      CALL READ_SURF(&
               HPROGRAM,YRECFM2,DTI%LDATA_GROUND_DEPTH,IRESP,HCOMMENT=YCOMMENT)
      IF (DTI%LDATA_GROUND_DEPTH) DTI%LDATA_MIXPAR = .TRUE.
      YRECFM='L_ROOT_DEPTH'
      YCOMMENT=YRECFM
      CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOT_DEPTH,IRESP,HCOMMENT=YCOMMENT)
      IF (DTI%LDATA_ROOT_DEPTH) DTI%LDATA_MIXPAR = .TRUE.
      YRECFM='L_ROOT_EXT'
      YCOMMENT=YRECFM
      CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOT_EXTINCTION,IRESP,HCOMMENT=YCOMMENT)
      IF (DTI%LDATA_ROOT_EXTINCTION) DTI%LDATA_MIXPAR = .TRUE.
      YRECFM='L_ROOT_LIN'
      YCOMMENT=YRECFM
      CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOT_LIN,IRESP,HCOMMENT=YCOMMENT)
      IF (DTI%LDATA_ROOT_LIN) DTI%LDATA_MIXPAR = .TRUE.
    ELSE
      DTI%LDATA_GROUND_DEPTH = .FALSE.
      DTI%LDATA_ROOT_DEPTH   = .FALSE.
      DTI%LDATA_ROOT_EXTINCTION = .FALSE.
      DTI%LDATA_ROOT_LIN = .FALSE.
    ENDIF
    !
    YRECFM='L_ALBNIR_VEG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ALBNIR_VEG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ALBNIR_VEG) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBVIS_VEG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ALBVIS_VEG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ALBVIS_VEG) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBUV_VEG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ALBUV_VEG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ALBUV_VEG) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBNIR_SOI'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ALBNIR_SOIL,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ALBNIR_SOIL) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBVIS_SOI'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ALBVIS_SOIL,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ALBVIS_SOIL) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBUV_SOI'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ALBUV_SOIL,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ALBUV_SOIL) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GMES'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_GMES,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_GMES) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_BSLAI'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_BSLAI,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_BSLAI) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_LAIMIN'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_LAIMIN,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_LAIMIN) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_SEFOLD'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_SEFOLD,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_SEFOLD) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GC'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_GC,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_GC) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_DMAX'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_DMAX,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_DMAX) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_F2I'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_F2I,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_F2I) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_STRESS'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_STRESS,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_STRESS) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_H_TREE'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_H_TREE,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_H_TREE) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RE25'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_RE25,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_RE25) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CE_NITRO'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_CE_NITRO,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_CE_NITRO) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CF_NITRO'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_CF_NITRO,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_CF_NITRO) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CNA_NITRO'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_CNA_NITRO,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_CNA_NITRO) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_IRRIG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_IRRIG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_IRRIG) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_WATSUP'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_WATSUP,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_WATSUP) DTI%LDATA_MIXPAR = .TRUE.
    !
  ENDIF
  !
  IF (IVERSION>=8.AND.ISIZE_LMEB_PATCH>0) THEN
    !
    YRECFM='L_LAIGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_LAIGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_LAIGV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_H_VEG'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_H_VEG,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_H_VEG) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_Z0LITTER'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_Z0LITTER,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_Z0LITTER) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GNDLITTER'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_GNDLITTER,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_GNDLITTER) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RSMINGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_RSMINGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_RSMINGV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GAMMAGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_GAMMAGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_GAMMAGV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_WRMAX_CFGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_WRMAX_CFGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_WRMAX_CFGV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RGLGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_RGLGV,IRESP,HCOMMENT=YCOMMENT)
    YRECFM='L_RTFRACGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOTFRACGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ROOTFRACGV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RT_DEPTHGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOT_DEPTHGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ROOT_DEPTHGV) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RT_EXTGV'
    YCOMMENT=YRECFM
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%LDATA_ROOT_EXTINCTIONGV,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_ROOT_EXTINCTIONGV) DTI%LDATA_MIXPAR = .TRUE.    
    !
  ELSE
    !
    DTI%LDATA_GNDLITTER=.FALSE.
    DTI%LDATA_RGLGV=.FALSE.
    DTI%LDATA_GAMMAGV=.FALSE.
    DTI%LDATA_RSMINGV=.FALSE.
    DTI%LDATA_ROOTFRACGV=.FALSE.
    DTI%LDATA_WRMAX_CFGV=.FALSE.
    DTI%LDATA_LAIGV=.FALSE.
    DTI%LDATA_Z0LITTER=.FALSE.
    DTI%LDATA_H_VEG=.FALSE.
    DTI%LDATA_ROOT_DEPTHGV=.FALSE.
    DTI%LDATA_ROOT_EXTINCTIONGV=.FALSE.
    !
  ENDIF          
  !
  IF (ALLOCATED(LINTERP)) LINTERP(:) = .TRUE.
  !
  IF (DTI%LDATA_VEGTYPE) THEN
    YRECFM='D_VEGTYPE'
    CALL READ_SURF_FIELD2D(HPROGRAM,ZFIELD(:,:),YRECFM,HCOMMENT=YCOMMENT,HDIR=YDIR)
    ALLOCATE(DTI%XPAR_VEGTYPE   (IG%NDIM,NVEGTYPE))
    IF (IG%NDIM/=KSIZE) THEN
      CALL HOR_INTERPOL(DTCO, U, &
                        ILUOUT,ZFIELD,DTI%XPAR_VEGTYPE)
    ELSE
      DTI%XPAR_VEGTYPE(:,:) = ZFIELD(:,:)
    ENDIF
  ENDIF
!
  IF (DTI%LDATA_LAI .OR. DTI%LDATA_VEG .OR. DTI%LDATA_Z0 .OR. DTI%LDATA_EMIS) THEN
    YRECFM='NDATA_TIME'
    CALL READ_SURF(&
               HPROGRAM,YRECFM,DTI%NTIME,IRESP,HCOMMENT=YCOMMENT)
    ITIME = DTI%NTIME
  ELSE
    DTI%NTIME = 1
  ENDIF
!  
  IF (DTI%LDATA_VEG) THEN
    ALLOCATE(DTI%XPAR_VEG(IG%NDIM,DTI%NTIME,NVEGTYPE))           
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A7,I2.2)') 'D_VEG_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_VEG(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)       
    END DO
  ENDIF
!
  IF (DTI%LDATA_LAI) THEN
    ALLOCATE(DTI%XPAR_LAI(IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A7,I2.2)') 'D_LAI_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_LAI(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_LAIGV) THEN
    ALLOCATE(DTI%XPAR_LAIGV(IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A9,I2.2)') 'D_LAIGV_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_LAIGV(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_H_VEG) THEN
    ALLOCATE(DTI%XPAR_H_VEG(IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A9,I2.2)') 'D_H_VEG_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_H_VEG(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_GNDLITTER) THEN
    ALLOCATE(DTI%XPAR_GNDLITTER(IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A7,I2.2)') 'D_GNDLITTER',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_GNDLITTER(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_Z0) THEN
    ALLOCATE(DTI%XPAR_Z0        (IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A6,I2.2)') 'D_Z0_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_Z0(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_Z0LITTER) THEN
    ALLOCATE(DTI%XPAR_Z0LITTER        (IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A8,I2.2)') 'D_Z0LITTER_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_Z0LITTER(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_EMIS) THEN
    ALLOCATE(DTI%XPAR_EMIS      (IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A8,I2.2)') 'D_EMIS_T',JTIME
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_EMIS(:,JTIME,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_RSMIN) THEN
    ALLOCATE(DTI%XPAR_RSMIN     (IG%NDIM,NVEGTYPE))
    YRECFM='D_RSMIN'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_RSMIN(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_RSMINGV) THEN
    ALLOCATE(DTI%XPAR_RSMINGV     (IG%NDIM,NVEGTYPE))
    YRECFM='D_RSMINGV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_RSMINGV(:,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_GAMMA) THEN
    ALLOCATE(DTI%XPAR_GAMMA     (IG%NDIM,NVEGTYPE))
    YRECFM='D_GAMMA'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_GAMMA(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_GAMMAGV) THEN
    ALLOCATE(DTI%XPAR_GAMMAGV     (IG%NDIM,NVEGTYPE))
    YRECFM='D_GAMMAGV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_GAMMAGV(:,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_WRMAX_CF) THEN
    ALLOCATE(DTI%XPAR_WRMAX_CF  (IG%NDIM,NVEGTYPE))
    YRECFM='D_WRMAX_CF'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_WRMAX_CF(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_WRMAX_CFGV) THEN
    ALLOCATE(DTI%XPAR_WRMAX_CFGV  (IG%NDIM,NVEGTYPE))
    YRECFM='D_WRMAX_CFGV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_WRMAX_CFGV(:,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_RGL) THEN
    ALLOCATE(DTI%XPAR_RGL       (IG%NDIM,NVEGTYPE))
    YRECFM='D_RGL'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_RGL(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_RGLGV) THEN
    ALLOCATE(DTI%XPAR_RGLGV       (IG%NDIM,NVEGTYPE))
    YRECFM='D_RGLGV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_RGLGV(:,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_CV) THEN
    ALLOCATE(DTI%XPAR_CV        (IG%NDIM,NVEGTYPE))
    YRECFM='D_CV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_CV(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_Z0_O_Z0H) THEN
    ALLOCATE(DTI%XPAR_Z0_O_Z0H  (IG%NDIM,NVEGTYPE))
    YRECFM='D_Z0_O_Z0H'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_Z0_O_Z0H(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_DG) THEN
    ALLOCATE(DTI%XPAR_DG        (IG%NDIM,I%NGROUND_LAYER,NVEGTYPE))
    ALLOCATE(ZWORK(SIZE(DTI%XPAR_DG,1),SIZE(DTI%XPAR_DG,3)))
    DO JLAYER=1,SIZE(DTI%XPAR_DG,2)
      IF (JLAYER<10)  WRITE(YRECFM,FMT='(A4,I1.1)') 'D_DG',JLAYER
      IF (JLAYER>=10) WRITE(YRECFM,FMT='(A4,I2.2)') 'D_DG',JLAYER
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,ZWORK,IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
      DO JPATCH=1,SIZE(DTI%XPAR_DG,3)
        DTI%XPAR_DG(:,JLAYER,JPATCH) = ZWORK(:,JPATCH)
      END DO
    END DO
    DEALLOCATE(ZWORK)
  ENDIF
!
  IF (DTI%LDATA_ROOTFRAC) THEN
    ALLOCATE(DTI%XPAR_ROOTFRAC  (IG%NDIM,I%NGROUND_LAYER,NVEGTYPE))
    ALLOCATE(ZWORK(SIZE(DTI%XPAR_ROOTFRAC,1),SIZE(DTI%XPAR_ROOTFRAC,3)))
    DO JLAYER=1,SIZE(DTI%XPAR_ROOTFRAC,2)
      IF (JLAYER<10)  WRITE(YRECFM,FMT='(A10,I1.1)') 'D_ROOTFRAC',JLAYER
      IF (JLAYER>=10) WRITE(YRECFM,FMT='(A10,I2.2)') 'D_ROOTFRAC',JLAYER
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,ZWORK,IRESP,IVERSION,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      DO JPATCH=1,SIZE(DTI%XPAR_ROOTFRAC,3)
        DTI%XPAR_ROOTFRAC(:,JLAYER,JPATCH) = ZWORK(:,JPATCH)
      END DO
    END DO
    DEALLOCATE(ZWORK)
  ENDIF
!
  IF (DTI%LDATA_ROOTFRACGV) THEN
    ALLOCATE(DTI%XPAR_ROOTFRACGV  (IG%NDIM,I%NGROUND_LAYER,NVEGTYPE))
    ALLOCATE(ZWORK(SIZE(DTI%XPAR_ROOTFRACGV,1),SIZE(DTI%XPAR_ROOTFRACGV,3)))
    DO JLAYER=1,SIZE(DTI%XPAR_ROOTFRACGV,2)
      IF (JLAYER<10)  WRITE(YRECFM,FMT='(A10,I1.1)') 'D_RTFRACGV',JLAYER
      IF (JLAYER>=10) WRITE(YRECFM,FMT='(A10,I2.2)') 'D_RTFRACGV',JLAYER
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,ZWORK,IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
      DO JPATCH=1,SIZE(DTI%XPAR_ROOTFRACGV,3)
        DTI%XPAR_ROOTFRACGV(:,JLAYER,JPATCH) = ZWORK(:,JPATCH)
      END DO
    END DO
    DEALLOCATE(ZWORK)
  ENDIF
!
  IF (DTI%LDATA_DICE) THEN
    ALLOCATE(DTI%XPAR_DICE      (IG%NDIM,NVEGTYPE))
    YRECFM='D_DICE'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_DICE(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_GROUND_DEPTH) THEN
    ALLOCATE(DTI%XPAR_GROUND_DEPTH(IG%NDIM,NVEGTYPE))
    YRECFM2='D_GROUND_DEPTH'
    IF (IVERSION>7 .OR. IVERSION==7 .AND. IBUGFIX>=3) YRECFM2='D_GROUND_DPT'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM2,ILUOUT,KSIZE,DTI%XPAR_GROUND_DEPTH(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ROOT_DEPTH) THEN
    ALLOCATE(DTI%XPAR_ROOT_DEPTH(IG%NDIM,NVEGTYPE))
    YRECFM='D_ROOT_DEPTH'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ROOT_DEPTH(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ROOT_DEPTHGV) THEN
    ALLOCATE(DTI%XPAR_ROOT_DEPTHGV(IG%NDIM,NVEGTYPE))
    YRECFM='D_RT_DEPTHGV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ROOT_DEPTHGV(:,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ROOT_EXTINCTION) THEN
    ALLOCATE(DTI%XPAR_ROOT_EXTINCTION(IG%NDIM,NVEGTYPE))
    YRECFM='D_ROOT_EXT'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ROOT_EXTINCTION(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ROOT_EXTINCTIONGV) THEN
    ALLOCATE(DTI%XPAR_ROOT_EXTINCTIONGV(IG%NDIM,NVEGTYPE))
    YRECFM='D_RT_EXTGV'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ROOT_EXTINCTIONGV(:,:),IRESP,IVERSION,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF

  IF (DTI%LDATA_ROOT_LIN) THEN
    ALLOCATE(DTI%XPAR_ROOT_LIN(IG%NDIM,NVEGTYPE))
    YRECFM='D_ROOT_LIN'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ROOT_LIN(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ALBNIR_VEG) THEN
    ALLOCATE(DTI%XPAR_ALBNIR_VEG(IG%NDIM,NVEGTYPE))
    YRECFM='D_ALBNIR_VEG'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ALBNIR_VEG(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ALBVIS_VEG) THEN
    ALLOCATE(DTI%XPAR_ALBVIS_VEG(IG%NDIM,NVEGTYPE))
    YRECFM='D_ALBVIS_VEG'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ALBVIS_VEG(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ALBUV_VEG) THEN
    ALLOCATE(DTI%XPAR_ALBUV_VEG (IG%NDIM,NVEGTYPE))
    YRECFM='D_ALBUV_VEG'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ALBUV_VEG(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ALBNIR_SOIL) THEN
    ALLOCATE(DTI%XPAR_ALBNIR_SOIL(IG%NDIM,NVEGTYPE))
    YRECFM='D_ALBNIR_SOI'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ALBNIR_SOIL(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ALBVIS_SOIL) THEN
    ALLOCATE(DTI%XPAR_ALBVIS_SOIL(IG%NDIM,NVEGTYPE))
    YRECFM='D_ALBVIS_SOI'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ALBVIS_SOIL(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_ALBUV_SOIL) THEN
    ALLOCATE(DTI%XPAR_ALBUV_SOIL (IG%NDIM,NVEGTYPE))
    YRECFM='D_ALBUV_SOI'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_ALBUV_SOIL(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_GMES) THEN
    ALLOCATE(DTI%XPAR_GMES      (IG%NDIM,NVEGTYPE))
    YRECFM='D_GMES'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_GMES(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_BSLAI) THEN
    ALLOCATE(DTI%XPAR_BSLAI     (IG%NDIM,NVEGTYPE))
    YRECFM='D_BSLAI'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_BSLAI(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_LAIMIN) THEN
    ALLOCATE(DTI%XPAR_LAIMIN    (IG%NDIM,NVEGTYPE))
    YRECFM='D_LAIMIN'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_LAIMIN(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_SEFOLD) THEN
    ALLOCATE(DTI%XPAR_SEFOLD    (IG%NDIM,NVEGTYPE))
    YRECFM='D_SEFOLD'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_SEFOLD(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_GC) THEN
    ALLOCATE(DTI%XPAR_GC        (IG%NDIM,NVEGTYPE))
    YRECFM='D_GC'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_GC(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_DMAX) THEN
    ALLOCATE(DTI%XPAR_DMAX      (IG%NDIM,NVEGTYPE))
    YRECFM='D_DMAX'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_DMAX(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_F2I) THEN
    ALLOCATE(DTI%XPAR_F2I       (IG%NDIM,NVEGTYPE))
    YRECFM='D_F2I'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_F2I(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_STRESS) THEN
    ALLOCATE(DTI%LPAR_STRESS   (IG%NDIM,NVEGTYPE))
    ALLOCATE(ZWORK(SIZE(DTI%LPAR_STRESS,1),SIZE(DTI%LPAR_STRESS,2)))
    YRECFM='D_STRESS'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,ZWORK(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
    DTI%LPAR_STRESS = .FALSE.
    WHERE(ZWORK==1.) DTI%LPAR_STRESS = .TRUE.
    DEALLOCATE(ZWORK)
  ENDIF
!
  IF (DTI%LDATA_H_TREE) THEN
    ALLOCATE(DTI%XPAR_H_TREE    (IG%NDIM,NVEGTYPE))
    YRECFM='D_H_TREE'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_H_TREE(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_RE25) THEN
    ALLOCATE(DTI%XPAR_RE25      (IG%NDIM,NVEGTYPE))
    YRECFM='D_RE25'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_RE25(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_CE_NITRO) THEN
    ALLOCATE(DTI%XPAR_CE_NITRO  (IG%NDIM,NVEGTYPE))
    YRECFM='D_CE_NITRO'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_CE_NITRO(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_CF_NITRO) THEN
    ALLOCATE(DTI%XPAR_CF_NITRO  (IG%NDIM,NVEGTYPE))
    YRECFM='D_CF_NITRO'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_CF_NITRO(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_CNA_NITRO) THEN
    ALLOCATE(DTI%XPAR_CNA_NITRO (IG%NDIM,NVEGTYPE))
    YRECFM='D_CNA_NITRO'
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_CNA_NITRO(:,:),IRESP,IVERSION,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (DTI%LDATA_IRRIG) THEN
    ALLOCATE(DTI%XPAR_IRRIG     (IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A9,I2.2)') 'D_IRRIG_T',JTIME
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_IRRIG(:,JTIME,:),IRESP,IVERSION,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (DTI%LDATA_WATSUP) THEN
    ALLOCATE(DTI%XPAR_WATSUP     (IG%NDIM,DTI%NTIME,NVEGTYPE))
    DO JTIME=1,ITIME
      WRITE(YRECFM,FMT='(A10,I2.2)') 'D_WATSUP_T',JTIME
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, I, &
                                HPROGRAM,YRECFM,ILUOUT,KSIZE,DTI%XPAR_WATSUP(:,JTIME,:),IRESP,IVERSION,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
ENDIF
!
IF (LASSIM) LREAD_ALL = GREAD_ALL
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_ISBA_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_PGD_ISBA_PAR_n
