!     #########################
SUBROUTINE READ_CSVDATA_COMPO_TEB(BDD, HPROGRAM, HFILE)
  !     #########################
  !
  !!
  !!    PURPOSE
  !!    -------
  !!
  !!    METHOD
  !!    ------
  !!
  !!
  !!    EXTERNAL
  !!    --------
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!    AUTHOR
  !!    ------
  !!
  !!    R. Schoetter        Meteo-France
  !!
  !!    MODIFICATION
  !!    ------------
  !!
  !
  !----------------------------------------------------------------------------
  !
  !*    0.     DECLARATIONS
  !            -----------
  !
  USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
  !
  USE MODD_CSTS,     ONLY : XTT
  USE MODD_SURF_PAR, ONLY : XUNDEF
  !
  USE MODI_OPEN_NAMELIST
  USE MODI_CLOSE_NAMELIST
  !
  USE MODI_GET_LUOUT
  USE MODI_ABOR1_SFX
  !
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  IMPLICIT NONE
  !
  !*    0.1    Declaration of arguments
  !            ------------------------
  !
  TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
  CHARACTER(LEN=6),  INTENT(IN) :: HPROGRAM
  CHARACTER(LEN=28), INTENT(IN) :: HFILE    ! file to read
  !
  !*    0.2    Declaration of local variables
  !      ------------------------------
  !
  INTEGER :: NAUX    ! Auxiliary variable
  INTEGER :: ILUNAM  ! Unit of the file
  INTEGER :: ILUOUT  ! Unit of the output listing file
  INTEGER :: KK,LL,MM,II,OO
  !
  CHARACTER(LEN=2000) :: YSTRING ! One line of .csv file
  CHARACTER(LEN=2000) :: YSTREAD ! One line of .csv file
  !
  CHARACTER(LEN=50), ALLOCATABLE :: COCCUSEV(:)
  CHARACTER(LEN=50), ALLOCATABLE :: CSCEUSEV(:)
  CHARACTER(LEN=50), ALLOCATABLE :: CHOLUSEV(:)
  CHARACTER(LEN=50), ALLOCATABLE :: CQINUSEV(:)
  CHARACTER(LEN=50), ALLOCATABLE :: CHEATUSEV(:)
  CHARACTER(LEN=50), ALLOCATABLE :: CCOOLUSEV(:)
  CHARACTER(LEN=50), ALLOCATABLE :: CVENTUSEV(:)
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  ! -------------------------------------------------------------------------------
  !
  IF (LHOOK) CALL DR_HOOK('READ_CSVDATA_COMPO_TEB',0,ZHOOK_HANDLE)
  !-------------------------------------------------------------------------------
  IF (LEN_TRIM(HFILE)==0) THEN
     IF (LHOOK) CALL DR_HOOK('READ_CSVDATA_COMPO_TEB',1,ZHOOK_HANDLE)
     RETURN
  ENDIF
  !
  CALL GET_LUOUT(HPROGRAM,ILUOUT)
  !
  ! Open .csv-file
  !
  CALL OPEN_NAMELIST(HPROGRAM,ILUNAM,HFILE)
  !
  ! Loop over lines in .csv-file
  !
  DO KK=1,1000
     !
     READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
     !
     ! Loop over all entries in one line
     !
     DO LL=1,1000
        !
        YSTREAD=YSTRING(1:(INDEX(YSTRING,",")-1))
        YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
        !
        ! #####################################################
        ! Read time schedules
        ! #####################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR LES PLAGES HORAIRES") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_CASE_SCHED
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           DO OO=1,1000
              YSTREAD=YSTRING(1:(INDEX(YSTRING,",")-1))
              IF (YSTREAD.EQ."NOMBRE DE JOURS DISTINGUES") THEN
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 READ(YSTREAD,*) BDD%NDESC_NDAY_SCHED
              ENDIF
              YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
           ENDDO
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           DO OO=1,1000
              YSTREAD=YSTRING(1:(INDEX(YSTRING,",")-1))
              IF (YSTREAD.EQ."NOMBRE DE CRENEAUX PAR JOUR") THEN
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 READ(YSTREAD,*) BDD%NDESC_NCRE_SCHED
              ENDIF
              YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
           ENDDO
           !
           ALLOCATE(CSCEUSEV(BDD%NDESC_CASE_SCHED))
           ALLOCATE(BDD%XDESC_DAYWBEG_SCHED(BDD%NDESC_CASE_SCHED,BDD%NDESC_NDAY_SCHED))
           ALLOCATE(BDD%XDESC_HOURBEG_SCHED(BDD%NDESC_CASE_SCHED,BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED))
           !
           CSCEUSEV(:) = "   "
           BDD%XDESC_DAYWBEG_SCHED(:,:) = -9999.0
           BDD%XDESC_HOURBEG_SCHED(:,:) = -9999.0
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_CASE_SCHED
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
              YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
              !
              CSCEUSEV(MM) = TRIM(YSTREAD)
              !
              DO II=1,BDD%NDESC_NDAY_SCHED
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 READ(YSTREAD,*) NAUX
                 BDD%XDESC_DAYWBEG_SCHED(MM,II) = NAUX
                 !
                 DO OO=1,BDD%NDESC_NCRE_SCHED
                    !
                    YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                    IF (INDEX(YSTRING,",").EQ.0) YSTREAD=TRIM(YSTRING)
                    YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                    !
                    READ(YSTREAD,*) BDD%XDESC_HOURBEG_SCHED(MM,((II-1)*BDD%NDESC_NCRE_SCHED+OO))
                    !
                 ENDDO
              ENDDO
              !
              DO OO=1,BDD%NDESC_NDAY_SCHED
                 IF ((BDD%XDESC_DAYWBEG_SCHED(MM,OO).LT.0.999).OR.(BDD%XDESC_DAYWBEG_SCHED(MM,OO).GT.07.001)) THEN
                    CALL ABOR1_SFX('Wrong schedule')
                 ENDIF
              ENDDO
              !
              DO OO=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
                 IF ((BDD%XDESC_HOURBEG_SCHED(MM,OO).LT.-0.01).OR.(BDD%XDESC_HOURBEG_SCHED(MM,OO).GT.24.001)) THEN
                    CALL ABOR1_SFX('Wrong schedule')
                 ENDIF
              ENDDO
              !
           ENDDO
           !
           ! Convert usage string to usage code number
           !
           ALLOCATE(BDD%NDESC_SCEUSEV(BDD%NDESC_CASE_SCHED))
           CALL GETPOS(BDD%YDESC_USENAME,CSCEUSEV,BDD%NDESC_SCEUSEV)
           !
        ENDIF
        !
        ! #####################################################
        ! Read information related to holidays
        ! #####################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR LES VACANCES") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_CASE_HOLIDAY
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           DO OO=1,1000
              YSTREAD=YSTRING(1:(INDEX(YSTRING,",")-1))
              IF (YSTREAD.EQ."NOMBRE DE PERIODES DE VACANCES") THEN
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 READ(YSTREAD,*) BDD%NDESC_HOLIDAY
              ENDIF
              YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
           ENDDO
           !
           ALLOCATE(CHOLUSEV(BDD%NDESC_CASE_HOLIDAY))
           ALLOCATE(BDD%NDESC_HOLUSEV(BDD%NDESC_CASE_HOLIDAY))
           ALLOCATE(BDD%XDESC_MOD_HOLIDAY(BDD%NDESC_CASE_HOLIDAY))
           ALLOCATE(BDD%XDESC_BEG_HOLIDAY(BDD%NDESC_CASE_HOLIDAY,BDD%NDESC_HOLIDAY))
           ALLOCATE(BDD%XDESC_END_HOLIDAY(BDD%NDESC_CASE_HOLIDAY,BDD%NDESC_HOLIDAY))
           !
           CHOLUSEV(:) = "   "
           BDD%XDESC_MOD_HOLIDAY(:)   = -9999.0
           BDD%XDESC_BEG_HOLIDAY(:,:) = -9999.0
           BDD%XDESC_END_HOLIDAY(:,:) = -9999.0
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_CASE_HOLIDAY
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
              YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
              !
              CHOLUSEV(MM) = TRIM(YSTREAD)
              !
              DO II=1,BDD%NDESC_HOLIDAY
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 READ(YSTREAD,*) BDD%XDESC_BEG_HOLIDAY(MM,II)
                 !
                 IF ((BDD%XDESC_BEG_HOLIDAY(MM,II).LT.0).OR.(BDD%XDESC_BEG_HOLIDAY(MM,II).GT.401)) THEN
                    CALL ABOR1_SFX('Wrong schedule for holidays')
                 ENDIF
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 READ(YSTREAD,*) BDD%XDESC_END_HOLIDAY(MM,II)
                 !
                 IF ((BDD%XDESC_END_HOLIDAY(MM,II).LT.0).OR.(BDD%XDESC_END_HOLIDAY(MM,II).GT.401)) THEN
                    CALL ABOR1_SFX('Wrong schedule for holidays')
                 ENDIF
                 !
              ENDDO
              !
              YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
              YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
              !
              READ(YSTREAD,*) BDD%XDESC_MOD_HOLIDAY(MM)
              !
              IF ((BDD%XDESC_MOD_HOLIDAY(MM).LT.-0.00001).OR.(BDD%XDESC_MOD_HOLIDAY(MM).GT.1.0001)) THEN
                 CALL ABOR1_SFX('Wrong modulation factor for holidays')
              ENDIF
              !
           ENDDO
           !
           ! Convert usage string to usage code number
           !
           CALL GETPOS(BDD%YDESC_USENAME,CHOLUSEV,BDD%NDESC_HOLUSEV)
           !
        ENDIF
        !
        ! #####################################################
        ! Read building occupation probabilities
        ! CAUTION: At the moment only the building use is read
        !          Further informations need to be considered
        !          if more sociological data are available.
        ! #####################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR L'OCCUPPATION") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_OCC
           !
           ALLOCATE(BDD%XDESC_PROBOCC(BDD%NDESC_OCC,BDD%NDESC_NCRE_SCHED*BDD%NDESC_NDAY_SCHED))
           ALLOCATE(COCCUSEV(1:BDD%NDESC_OCC))
           BDD%XDESC_PROBOCC(:,:) = -9999.0
           COCCUSEV(:)   = "    "
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_OCC
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              DO II=1,(BDD%NDESC_NCRE_SCHED*BDD%NDESC_NDAY_SCHED+3)
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 ! The positions of the entries are hardcoded,
                 ! only the building use is read as additional information
                 !
                 IF (II.EQ.1) COCCUSEV(MM) = TRIM(YSTREAD)
                 IF (II.GE.4) READ(YSTREAD,*) BDD%XDESC_PROBOCC(MM,II-3)
                 !
              ENDDO
              !
           ENDDO
           !
           ! Check all entries
           !
           DO MM=1,BDD%NDESC_OCC
              DO II=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
                 IF ((BDD%XDESC_PROBOCC(MM,II).LT.-0.001).OR.(BDD%XDESC_PROBOCC(MM,II).GT.1.001)) THEN
                    CALL ABOR1_SFX('Wrong occupation probability')
                 ENDIF
              ENDDO
           ENDDO
           !
           ! Convert usage string to usage code number
           !
           ALLOCATE(BDD%NDESC_OCCUSEV(BDD%NDESC_OCC))
           CALL GETPOS(BDD%YDESC_USENAME,COCCUSEV,BDD%NDESC_OCCUSEV)
           !
        ENDIF
        !
        ! #####################################################
        ! Read design temperature for heating
        ! CAUTION: At the moment only the building use is read
        !          Further informations need to be considered
        !          if more sociological data are available.
        ! #####################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR LA CONSIGNE DE CHAUFFAGE") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_HEAT
           !
           ALLOCATE(BDD%XDESC_FLDT      (1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_FIDT      (1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_FHDT      (1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_THEAT_OCCD(1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_THEAT_OCCN(1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_THEAT_VCDD(1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_THEAT_VCDN(1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_THEAT_VCLD(1:BDD%NDESC_HEAT))
           ALLOCATE(BDD%XDESC_FNOHEAT   (1:BDD%NDESC_HEAT))
           !
           BDD%XDESC_FLDT(:)       = -9999.0
           BDD%XDESC_FIDT(:)       = -9999.0
           BDD%XDESC_FHDT(:)       = -9999.0
           BDD%XDESC_THEAT_OCCD(:) = -9999.0
           BDD%XDESC_THEAT_OCCN(:) = -9999.0
           BDD%XDESC_THEAT_VCDD(:) = -9999.0
           BDD%XDESC_THEAT_VCDN(:) = -9999.0
           BDD%XDESC_THEAT_VCLD(:) = -9999.0
           BDD%XDESC_FNOHEAT(:)    = -9999.0
           !
           ALLOCATE(CHEATUSEV(1:BDD%NDESC_HEAT))
           CHEATUSEV(:)   = "    "
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_HEAT
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              DO II=1,11
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 ! The positions of the entries are hardcoded,
                 ! only the building use is read as additional information
                 !
                 IF (II.EQ.01) CHEATUSEV(MM) = TRIM(YSTREAD)
                 IF (II.EQ.03) READ(YSTREAD,*) BDD%XDESC_FLDT(MM)
                 IF (II.EQ.04) READ(YSTREAD,*) BDD%XDESC_FIDT(MM)
                 IF (II.EQ.05) READ(YSTREAD,*) BDD%XDESC_FHDT(MM)
                 IF (II.EQ.06) READ(YSTREAD,*) BDD%XDESC_THEAT_OCCD(MM)
                 IF (II.EQ.07) READ(YSTREAD,*) BDD%XDESC_THEAT_OCCN(MM)
                 IF (II.EQ.08) READ(YSTREAD,*) BDD%XDESC_THEAT_VCDD(MM)
                 IF (II.EQ.09) READ(YSTREAD,*) BDD%XDESC_THEAT_VCDN(MM)
                 IF (II.EQ.10) READ(YSTREAD,*) BDD%XDESC_THEAT_VCLD(MM)
                 IF (II.EQ.11) READ(YSTREAD,*) BDD%XDESC_FNOHEAT(MM)
                 !
              ENDDO
              !
           ENDDO
           !
           ! Check all entries
           !
           DO MM=1,BDD%NDESC_HEAT
              !
              IF ((BDD%XDESC_FLDT(MM).LT.0.0).OR.(BDD%XDESC_FLDT(MM).GT.1.0)) CALL ABOR1_SFX('Wrong compartiment fraction')
              IF ((BDD%XDESC_FIDT(MM).LT.0.0).OR.(BDD%XDESC_FIDT(MM).GT.1.0)) CALL ABOR1_SFX('Wrong compartiment fraction')
              IF ((BDD%XDESC_FHDT(MM).LT.0.0).OR.(BDD%XDESC_FHDT(MM).GT.1.0)) CALL ABOR1_SFX('Wrong compartiment fraction')
              !
              IF (ABS(1.0-BDD%XDESC_FLDT(MM)-BDD%XDESC_FIDT(MM)-BDD%XDESC_FHDT(MM)).GT.1.0E-10) THEN
                 CALL ABOR1_SFX('Wrong sum of compartiment fractions')
              ENDIF
              !
              IF ( (BDD%XDESC_THEAT_OCCD(MM).LT.-100.0).OR.(BDD%XDESC_THEAT_OCCD(MM).GT.60.0).OR. &
                   (BDD%XDESC_THEAT_OCCN(MM).LT.-100.0).OR.(BDD%XDESC_THEAT_OCCN(MM).GT.60.0).OR. &
                   (BDD%XDESC_THEAT_VCDD(MM).LT.-100.0).OR.(BDD%XDESC_THEAT_VCDD(MM).GT.60.0).OR. &
                   (BDD%XDESC_THEAT_VCDN(MM).LT.-100.0).OR.(BDD%XDESC_THEAT_VCDN(MM).GT.60.0).OR. &
                   (BDD%XDESC_THEAT_VCLD(MM).LT.-100.0).OR.(BDD%XDESC_THEAT_VCLD(MM).GT.60.0)) THEN
                 CALL ABOR1_SFX('Wrong heating design temperature')
              ENDIF
              !
              IF ((BDD%XDESC_FNOHEAT(MM).LT.0.0).OR.(BDD%XDESC_FNOHEAT(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong non heated fraction')
              ENDIF
              !
           ENDDO
           !
           ! Conversion °C -> K
           !
           BDD%XDESC_THEAT_OCCD(:) = BDD%XDESC_THEAT_OCCD(:) + 273.16
           BDD%XDESC_THEAT_OCCN(:) = BDD%XDESC_THEAT_OCCN(:) + 273.16
           BDD%XDESC_THEAT_VCDD(:) = BDD%XDESC_THEAT_VCDD(:) + 273.16
           BDD%XDESC_THEAT_VCDN(:) = BDD%XDESC_THEAT_VCDN(:) + 273.16
           BDD%XDESC_THEAT_VCLD(:) = BDD%XDESC_THEAT_VCLD(:) + 273.16
           !
           ! Convert usage string to usage code number
           !
           ALLOCATE(BDD%NDESC_HEATUSEV(BDD%NDESC_HEAT))
           CALL GETPOS(BDD%YDESC_USENAME,CHEATUSEV,BDD%NDESC_HEATUSEV)
           !
        ENDIF
        !
        ! #####################################################
        ! Read design temperature for cooling
        ! CAUTION: At the moment only the building use is read
        !          Further informations need to be considered
        !          if more sociological data are available.
        ! #####################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR LA CONSIGNE DE CLIMATISATION") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_COOL
           !
           ALLOCATE(BDD%XDESC_TCOOL_OCCD(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_TCOOL_OCCN(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_TCOOL_VCDD(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_TCOOL_VCDN(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_TCOOL_VCLD(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_F_WATER_COND(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_F_WASTE_CAN(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_COP_RAT(1:BDD%NDESC_COOL))
           ALLOCATE(BDD%XDESC_HR_TARGET(1:BDD%NDESC_COOL))
           !
           BDD%XDESC_TCOOL_OCCD(:)   = -9999.0
           BDD%XDESC_TCOOL_OCCN(:)   = -9999.0
           BDD%XDESC_TCOOL_VCDD(:)   = -9999.0
           BDD%XDESC_TCOOL_VCDN(:)   = -9999.0
           BDD%XDESC_TCOOL_VCLD(:)   = -9999.0
           BDD%XDESC_F_WATER_COND(:) = -9999.0
           BDD%XDESC_F_WASTE_CAN(:)  = -9999.0
           BDD%XDESC_COP_RAT(:)      = -9999.0
           BDD%XDESC_HR_TARGET(:)    = -9999.0
           !
           ALLOCATE(CCOOLUSEV(1:BDD%NDESC_COOL))
           CCOOLUSEV(:)   = "    "
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_COOL
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              DO II=1,11
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 ! The positions of the entries are hardcoded,
                 ! only the building use is read as additional information
                 !
                 IF (II.EQ.01) CCOOLUSEV(MM) = TRIM(YSTREAD)
                 IF (II.EQ.03) READ(YSTREAD,*) BDD%XDESC_TCOOL_OCCD(MM)
                 IF (II.EQ.04) READ(YSTREAD,*) BDD%XDESC_TCOOL_OCCN(MM)
                 IF (II.EQ.05) READ(YSTREAD,*) BDD%XDESC_TCOOL_VCDD(MM)
                 IF (II.EQ.06) READ(YSTREAD,*) BDD%XDESC_TCOOL_VCDN(MM)
                 IF (II.EQ.07) READ(YSTREAD,*) BDD%XDESC_TCOOL_VCLD(MM)
                 IF (II.EQ.08) READ(YSTREAD,*) BDD%XDESC_F_WATER_COND(MM)
                 IF (II.EQ.09) READ(YSTREAD,*) BDD%XDESC_F_WASTE_CAN(MM)
                 IF (II.EQ.10) READ(YSTREAD,*) BDD%XDESC_COP_RAT(MM)
                 IF (II.EQ.11) READ(YSTREAD,*) BDD%XDESC_HR_TARGET(MM)
                 !
              ENDDO
              !
           ENDDO
           !
           ! Check all entries
           !
           DO MM=1,BDD%NDESC_COOL
              IF ( (BDD%XDESC_TCOOL_OCCD(MM).LT.0.0).OR.(BDD%XDESC_TCOOL_OCCD(MM).GT.100.0).OR. &
                   (BDD%XDESC_TCOOL_OCCN(MM).LT.0.0).OR.(BDD%XDESC_TCOOL_OCCN(MM).GT.100.0).OR. &
                   (BDD%XDESC_TCOOL_VCDD(MM).LT.0.0).OR.(BDD%XDESC_TCOOL_VCDD(MM).GT.100.0).OR. &
                   (BDD%XDESC_TCOOL_VCDN(MM).LT.0.0).OR.(BDD%XDESC_TCOOL_VCDN(MM).GT.100.0).OR. &
                   (BDD%XDESC_TCOOL_VCLD(MM).LT.0.0).OR.(BDD%XDESC_TCOOL_VCLD(MM).GT.100.0)) THEN 
                 CALL ABOR1_SFX('Wrong cooling design temperature')
              ENDIF
              !
              IF ((BDD%XDESC_F_WATER_COND(MM).LT.0.0).OR.(BDD%XDESC_F_WATER_COND(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong evaporative fraction')
              ENDIF
              !
              IF ((BDD%XDESC_F_WASTE_CAN(MM).LT.0.0).OR.(BDD%XDESC_F_WASTE_CAN(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong fraction for waste heat')
              ENDIF
              !
              IF ((BDD%XDESC_COP_RAT(MM).LT.0.0).OR.(BDD%XDESC_COP_RAT(MM).GT.10.0)) THEN
                 CALL ABOR1_SFX('Wrong COP for climatisation')
              ENDIF
              !
              IF ((BDD%XDESC_HR_TARGET(MM).LT.0.0).OR.(BDD%XDESC_HR_TARGET(MM).GT.100.0)) THEN
                 CALL ABOR1_SFX('Wrong cooling design relative humidity')
              ENDIF
              !
           ENDDO
           !
           ! Conversion °C -> K
           !
           BDD%XDESC_TCOOL_OCCD(:) = BDD%XDESC_TCOOL_OCCD(:) + 273.16
           BDD%XDESC_TCOOL_OCCN(:) = BDD%XDESC_TCOOL_OCCN(:) + 273.16
           BDD%XDESC_TCOOL_VCDD(:) = BDD%XDESC_TCOOL_VCDD(:) + 273.16
           BDD%XDESC_TCOOL_VCDN(:) = BDD%XDESC_TCOOL_VCDN(:) + 273.16
           BDD%XDESC_TCOOL_VCLD(:) = BDD%XDESC_TCOOL_VCLD(:) + 273.16
           !
           ! Conversion % -> fraction
           !
           BDD%XDESC_HR_TARGET(:) = 0.01*BDD%XDESC_HR_TARGET(:)
           !
           ! Convert usage string to usage code number
           !
           ALLOCATE(BDD%NDESC_COOLUSEV(BDD%NDESC_COOL))
           CALL GETPOS(BDD%YDESC_USENAME,CCOOLUSEV,BDD%NDESC_COOLUSEV)
           !
        ENDIF
        !
        ! #####################################################
        ! Read internal heat release
        ! CAUTION: At the moment only the building use is read
        !          Further informations need to be considered
        !          if more sociological data are available.
        ! #####################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR LES CHARGES INTERNES") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_QIN
           !
           ALLOCATE(BDD%XDESC_QIN(1:BDD%NDESC_QIN))
           ALLOCATE(BDD%XDESC_QIN_FRAD(1:BDD%NDESC_QIN))
           ALLOCATE(BDD%XDESC_QIN_FLAT(1:BDD%NDESC_QIN))
           ALLOCATE(BDD%XDESC_MODQIN_VCD(1:BDD%NDESC_QIN))
           ALLOCATE(BDD%XDESC_MODQIN_VLD(1:BDD%NDESC_QIN))
           ALLOCATE(BDD%XDESC_MODQIN_NIG(1:BDD%NDESC_QIN))
           !
           BDD%XDESC_QIN(:)        = -9999.0
           BDD%XDESC_QIN_FRAD(:)   = -9999.0
           BDD%XDESC_QIN_FLAT(:)   = -9999.0
           BDD%XDESC_MODQIN_VCD(:) = -9999.0
           BDD%XDESC_MODQIN_VLD(:) = -9999.0
           BDD%XDESC_MODQIN_NIG(:) = -9999.0
           !
           ALLOCATE(CQINUSEV(1:BDD%NDESC_QIN))
           CQINUSEV(:)   = "    "
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_QIN
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              DO II=1,8
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 ! The positions of the entries are hardcoded
                 !
                 IF (II.EQ.1) CQINUSEV(MM) = TRIM(YSTREAD)
                 IF (II.EQ.3) READ(YSTREAD,*) BDD%XDESC_QIN(MM)
                 IF (II.EQ.4) READ(YSTREAD,*) BDD%XDESC_QIN_FRAD(MM)
                 IF (II.EQ.5) READ(YSTREAD,*) BDD%XDESC_QIN_FLAT(MM)
                 IF (II.EQ.6) READ(YSTREAD,*) BDD%XDESC_MODQIN_VCD(MM)
                 IF (II.EQ.7) READ(YSTREAD,*) BDD%XDESC_MODQIN_VLD(MM)
                 IF (II.EQ.8) READ(YSTREAD,*) BDD%XDESC_MODQIN_NIG(MM)
                 !
              ENDDO
              !
           ENDDO
           !
           ! Check all entries
           !
           DO MM=1,BDD%NDESC_QIN
              !
              IF ((BDD%XDESC_QIN(MM).LT.0.0).OR.(BDD%XDESC_QIN(MM).GT.20.0)) THEN
                 CALL ABOR1_SFX('Wrong value for nominative heat release')
              ENDIF
              !
              IF ((BDD%XDESC_QIN_FRAD(MM).LT.0.0).OR.(BDD%XDESC_QIN_FRAD(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong value for radiative fraction')
              ENDIF
              !
              IF ((BDD%XDESC_QIN_FLAT(MM).LT.0.0).OR.(BDD%XDESC_QIN_FLAT(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong value for latent fraction')
              ENDIF
              !
              IF ( (BDD%XDESC_MODQIN_VCD(MM).LT.0.0).OR.(BDD%XDESC_MODQIN_VCD(MM).GT.1.0).OR. & 
                   (BDD%XDESC_MODQIN_VLD(MM).LT.0.0).OR.(BDD%XDESC_MODQIN_VLD(MM).GT.1.0).OR. & 
                   (BDD%XDESC_MODQIN_NIG(MM).LT.0.0).OR.(BDD%XDESC_MODQIN_NIG(MM).GT.1.0) ) THEN
                 CALL ABOR1_SFX('Wrong value for modulation factor')
              ENDIF
              !
           ENDDO
           !
           ! Convert usage string to usage code number
           !
           ALLOCATE(BDD%NDESC_QINUSEV(BDD%NDESC_QIN))
           CALL GETPOS(BDD%YDESC_USENAME,CQINUSEV,BDD%NDESC_QINUSEV)
           !
        ENDIF
        !
        ! ###############################################################
        ! Read entries related to the use of windows and shading elements
        ! CAUTION: At the moment only the building use is read
        !          Further informations need to be considered
        !          if more sociological data are available.
        ! ###############################################################
        !
        IF (YSTREAD.EQ."NOMBRE DE CAS POUR LES FENETRES ET VOLETS") THEN
           !
           YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
           READ(YSTREAD,*) BDD%NDESC_VENT
           !
           ALLOCATE(BDD%XDESC_NATVENT(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FVSUM(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FVNIG(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FVSHO(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_TDESV(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FVVAC(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FOPEN(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FSSUM(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FSNIG(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_FSVAC(1:BDD%NDESC_VENT))
           ALLOCATE(BDD%XDESC_WIN_SW_MAX(1:BDD%NDESC_VENT))
           !
           BDD%XDESC_NATVENT(:) = -9999.0
           BDD%XDESC_FVSUM(:) = -9999.0
           BDD%XDESC_FVNIG(:) = -9999.0
           BDD%XDESC_FVSHO(:) = -9999.0
           BDD%XDESC_TDESV(:) = -9999.0
           BDD%XDESC_FVVAC(:) = -9999.0
           BDD%XDESC_FOPEN(:) = -9999.0
           BDD%XDESC_FSSUM(:) = -9999.0
           BDD%XDESC_FSNIG(:) = -9999.0
           BDD%XDESC_FSVAC(:) = -9999.0
           BDD%XDESC_WIN_SW_MAX(:) = -9999.0
           !
           ALLOCATE(CVENTUSEV(1:BDD%NDESC_VENT))
           CVENTUSEV(:)   = "    "
           !
           READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
           !
           DO MM=1,BDD%NDESC_VENT
              !
              READ(ILUNAM,END=9999,FMT='(A1000)') YSTRING
              !
              DO II=1,12
                 !
                 YSTREAD=TRIM(YSTRING(1:(INDEX(YSTRING,",")-1)))
                 YSTRING=YSTRING((INDEX(YSTRING,",")+1):LEN(YSTRING))
                 !
                 ! The positions of the entries are hardcoded,
                 ! only the building use is read as additional information
                 !
                 IF (II.EQ.01) CVENTUSEV(MM) = TRIM(YSTREAD)
                 IF (II.EQ.02) READ(YSTREAD,*) BDD%XDESC_NATVENT(MM)
                 IF (II.EQ.03) READ(YSTREAD,*) BDD%XDESC_FVSUM(MM)
                 IF (II.EQ.04) READ(YSTREAD,*) BDD%XDESC_FVNIG(MM)
                 IF (II.EQ.05) READ(YSTREAD,*) BDD%XDESC_FVSHO(MM)
                 IF (II.EQ.06) READ(YSTREAD,*) BDD%XDESC_TDESV(MM)
                 IF (II.EQ.07) READ(YSTREAD,*) BDD%XDESC_FVVAC(MM)
                 IF (II.EQ.08) READ(YSTREAD,*) BDD%XDESC_FOPEN(MM)
                 IF (II.EQ.09) READ(YSTREAD,*) BDD%XDESC_FSSUM(MM)
                 IF (II.EQ.10) READ(YSTREAD,*) BDD%XDESC_FSNIG(MM)
                 IF (II.EQ.11) READ(YSTREAD,*) BDD%XDESC_FSVAC(MM)
                 IF (II.EQ.12) READ(YSTREAD,*) BDD%XDESC_WIN_SW_MAX(MM)
                 !
              ENDDO
              !
           ENDDO
           !
           ! Check all entries
           !
           DO MM=1,BDD%NDESC_VENT
              !
              IF ( (BDD%XDESC_NATVENT(MM).LT.-1.0E-6).OR.(BDD%XDESC_NATVENT(MM).GT.3.001)) THEN
                 CALL ABOR1_SFX('Wrong value for NATVENT switch')
              ENDIF
              !
              IF ( (BDD%XDESC_FVSUM(MM).LT.0.0).OR.(BDD%XDESC_FVSUM(MM).GT.1.0).OR. &
                   (BDD%XDESC_FVNIG(MM).LT.0.0).OR.(BDD%XDESC_FVNIG(MM).GT.1.0).OR. &
                   (BDD%XDESC_FVSHO(MM).LT.0.0).OR.(BDD%XDESC_FVSHO(MM).GT.1.0).OR. &
                   (BDD%XDESC_FVVAC(MM).LT.0.0).OR.(BDD%XDESC_FVVAC(MM).GT.1.0).OR. &
                   (BDD%XDESC_FOPEN(MM).LT.0.0).OR.(BDD%XDESC_FOPEN(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong value for ventilation use')
              ENDIF
              !
              IF ( (BDD%XDESC_FSSUM(MM).LT.0.0).OR.(BDD%XDESC_FSSUM(MM).GT.1.0).OR. &
                   (BDD%XDESC_FSNIG(MM).LT.0.0).OR.(BDD%XDESC_FSNIG(MM).GT.1.0).OR. & 
                   (BDD%XDESC_FSVAC(MM).LT.0.0).OR.(BDD%XDESC_FSVAC(MM).GT.1.0)) THEN
                 CALL ABOR1_SFX('Wrong value for shading use')
              ENDIF
              !
              IF ((BDD%XDESC_TDESV(MM).LT.15.0).OR.(BDD%XDESC_TDESV(MM).GT.35.0)) THEN
                 CALL ABOR1_SFX('Wrong value for ventilation design temperature')
              ENDIF
              !
              IF ((BDD%XDESC_WIN_SW_MAX(MM).LT.0.0).OR.(BDD%XDESC_WIN_SW_MAX(MM).GT.10000.0)) THEN
                 CALL ABOR1_SFX('Wrong value for radiation threshold')
              ENDIF
              !
           ENDDO
           !
           ! Conversion °C -> K
           !
           BDD%XDESC_TDESV(:) = BDD%XDESC_TDESV(:) + 273.16
           !
           ! Convert usage string to usage code number
           !
           ALLOCATE(BDD%NDESC_VENTUSEV(BDD%NDESC_VENT))
           CALL GETPOS(BDD%YDESC_USENAME,CVENTUSEV,BDD%NDESC_VENTUSEV)
           !
        ENDIF
        !
        ! Exit inner loop when entire line read
        !
        IF (INDEX(YSTRING,",").EQ.0) EXIT
        !
     ENDDO
     !
     ! Exit outer loop when all fields have been read
     !
     IF ((BDD%NDESC_OCC.GT.0).AND.(BDD%NDESC_QIN.GT.0).AND.(BDD%NDESC_VENT.GT.0).AND. &
          (BDD%NDESC_CASE_SCHED.GT.0).AND.(BDD%NDESC_HEAT.GT.0).AND.(BDD%NDESC_COOL.GT.0)) EXIT
     !
  ENDDO
  !
  ! Close file
  !
  CALL CLOSE_NAMELIST(HPROGRAM,ILUNAM)
  !
  IF (LHOOK) CALL DR_HOOK('READ_CSVDATA_COMPO_TEB',1,ZHOOK_HANDLE)
  !
  RETURN
  !
9999 CONTINUE
  !
  CALL ABOR1_SFX('End of file in read of .csv file')
  !
CONTAINS
  !
  SUBROUTINE GETPOS(YDEFFIELD,YFIELD,NPOSOUT)
    !
    ! Find position in vector
    !
    IMPLICIT NONE
    !
    ! I/O
    !
    CHARACTER(LEN=50), INTENT(IN)  :: YDEFFIELD(:)
    CHARACTER(LEN=50), INTENT(IN)  :: YFIELD(:)
    INTEGER, INTENT(OUT) :: NPOSOUT(:)
    !
    ! Local variables
    !
    INTEGER :: II,JJ
    !
    NPOSOUT(:)=-9999
    !
    DO JJ=1,SIZE(YFIELD)
       DO II=1,SIZE(YDEFFIELD)
          IF (TRIM(YFIELD(JJ)).EQ.TRIM(YDEFFIELD(II))) NPOSOUT(JJ)=II
       ENDDO
    ENDDO
    !
    IF (MINVAL(NPOSOUT).LT.1) CALL ABOR1_SFX('Position not found')
    !
    RETURN
    !
  END SUBROUTINE GETPOS
  !
END SUBROUTINE READ_CSVDATA_COMPO_TEB
