!     #########################
SUBROUTINE READ_BLD_DESCRIPTION_n(BDD,HPROGRAM)
  !     #########################
  !
  !!
  !!    PURPOSE
  !!    -------
  !!
  !!    METHOD
  !!    ------
  !!
  !!
  !!    EXTERNAL
  !!    --------
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!    AUTHOR
  !!    ------
  !!
  !!    V. Masson        Meteo-France
  !!
  !!    MODIFICATION
  !!    ------------
  !!
  !!    Original    05/2012 
  !
  !----------------------------------------------------------------------------
  !
  !*    0.     DECLARATION
  !            -----------
  !
  USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
  !
  USE MODI_READ_SURF
  USE MODI_ABOR1_SFX
  !
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  IMPLICIT NONE
  !
  !*    0.1    Declaration of arguments
  !            ------------------------
  !
  TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
  CHARACTER(LEN=6),  INTENT(IN) :: HPROGRAM
  !
  !
  !*    0.2    Declaration of local variables
  !      ------------------------------
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  REAL, DIMENSION(:), ALLOCATABLE :: ZWORK
  INTEGER                         :: IRESP
  INTEGER                         :: I1, I2
  INTEGER                         :: JL
  INTEGER                         :: ITOT
  INTEGER           :: IVERSION       ! surface version
  INTEGER           :: IBUGFIX        ! surface bugfix version
  !-------------------------------------------------------------------------------
  !-------------------------------------------------------------------------------
  !
  IF (LHOOK) CALL DR_HOOK('READ_BLD_DESCRIPTION_n',0,ZHOOK_HANDLE)
  !
  !-------------------------------------------------------------------------------
  !
  !*    1.   Read file version
  !          -----------------
  !
  CALL READ_SURF(HPROGRAM,'VERSION',IVERSION,IRESP)
  CALL READ_SURF(HPROGRAM,'BUG',IBUGFIX,IRESP)
  !-------------------------------------------------------------------------------
  !
  !*    1.   Read configuration variables of the descriptive data
  !          ----------------------------------------------------
  !
  ALLOCATE(ZWORK(20))
  ZWORK(:)=-7777.0
  !
  CALL READ_SURF(HPROGRAM,'BLD_DESC_CNF',ZWORK,IRESP,HDIR='-')
  !
  BDD%NDESC_BLD         = NINT(ZWORK(01))
  BDD%NDESC_AGE         = NINT(ZWORK(02))
  BDD%NDESC_USE         = NINT(ZWORK(03))
  BDD%NDESC_TER         = NINT(ZWORK(04))
  BDD%NDESC_CODE        = NINT(ZWORK(05))
  BDD%NDESC_CASE_SCHED  = NINT(ZWORK(06))
  BDD%NDESC_CASE_HOLIDAY= NINT(ZWORK(07))
  BDD%NDESC_NDAY_SCHED  = NINT(ZWORK(08))
  BDD%NDESC_NCRE_SCHED  = NINT(ZWORK(09))
  BDD%NDESC_HOLIDAY     = NINT(ZWORK(10))
  BDD%NDESC_HEAT        = NINT(ZWORK(11))
  BDD%NDESC_COOL        = NINT(ZWORK(12))
  BDD%NDESC_OCC         = NINT(ZWORK(13))
  BDD%NDESC_QIN         = NINT(ZWORK(14))    
  BDD%NDESC_VENT        = NINT(ZWORK(15)) 
  BDD%NDESC_WALL_LAYER  = NINT(ZWORK(16))
  BDD%NDESC_ROOF_LAYER  = NINT(ZWORK(17))
  BDD%NDESC_ROAD_LAYER  = NINT(ZWORK(18))
  BDD%NDESC_FLOOR_LAYER = NINT(ZWORK(19))
  BDD%NDESC_MASS_LAYER  = NINT(ZWORK(20))
  !
  DEALLOCATE(ZWORK)
  !
  !-------------------------------------------------------------------------------
  !
  !*    2.   Allocates descriptive data
  !          --------------------------
  !
  ALLOCATE(BDD%NDESC_BLD_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_USE_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_AGE_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_TER_LIST(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_CODE_LIST(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_ALB_ROOF(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_ROOF(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_ROOF(BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
  ALLOCATE(BDD%XDESC_TC_ROOF(BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
  ALLOCATE(BDD%XDESC_D_ROOF (BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
  !
  ALLOCATE(BDD%XDESC_ALB_ROAD(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_ROAD(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_ROAD(BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
  ALLOCATE(BDD%XDESC_TC_ROAD(BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
  ALLOCATE(BDD%XDESC_D_ROAD (BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
  !
  ALLOCATE(BDD%XDESC_ALB_WALL(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_WALL(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_WALL(BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
  ALLOCATE(BDD%XDESC_TC_WALL(BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
  ALLOCATE(BDD%XDESC_D_WALL (BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
  !
  ALLOCATE(BDD%NDESC_ISOROOFPOS(BDD%NDESC_CODE))
  ALLOCATE(BDD%NDESC_ISOWALLPOS(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_HC_FLOOR(BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
  ALLOCATE(BDD%XDESC_TC_FLOOR(BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
  ALLOCATE(BDD%XDESC_D_FLOOR (BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
  !
  ALLOCATE(BDD%XDESC_ISMASS(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_HC_MASS(BDD%NDESC_CODE,BDD%NDESC_MASS_LAYER))
  ALLOCATE(BDD%XDESC_TC_MASS(BDD%NDESC_CODE,BDD%NDESC_MASS_LAYER))
  ALLOCATE(BDD%XDESC_D_MASS (BDD%NDESC_CODE,BDD%NDESC_MASS_LAYER))
  !
  ALLOCATE(BDD%XDESC_N50(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_GR(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_U_WIN(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_SHGC(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_SHGC_SH(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_SHADEARCHI(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_ISMECH  (BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_MECHRATE(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_GREENROOF(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EMIS_PANEL(BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_ALB_PANEL (BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_EFF_PANEL (BDD%NDESC_CODE))
  ALLOCATE(BDD%XDESC_FRAC_PANEL(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%XDESC_F_WATER_COND(BDD%NDESC_CODE))
  !
  ALLOCATE(BDD%NDESC_HEATUSEV(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_FLDT(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_FIDT(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_FHDT(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_THEAT_OCCD(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_THEAT_OCCN(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_THEAT_VCDD(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_THEAT_VCDN(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_THEAT_VCLD(BDD%NDESC_HEAT))
  ALLOCATE(BDD%XDESC_FNOHEAT(BDD%NDESC_HEAT))
  !
  ALLOCATE(BDD%NDESC_COOLUSEV(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_TCOOL_OCCD(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_TCOOL_OCCN(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_TCOOL_VCDD(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_TCOOL_VCDN(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_TCOOL_VCLD(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_F_WATER_COND(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_F_WASTE_CAN(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_COP_RAT(BDD%NDESC_COOL))
  ALLOCATE(BDD%XDESC_HR_TARGET(BDD%NDESC_COOL))
  !
  ALLOCATE(BDD%NDESC_QINUSEV(BDD%NDESC_QIN))
  ALLOCATE(BDD%XDESC_QIN(BDD%NDESC_QIN))
  ALLOCATE(BDD%XDESC_QIN_FRAD(BDD%NDESC_QIN))
  ALLOCATE(BDD%XDESC_QIN_FLAT(BDD%NDESC_QIN))
  ALLOCATE(BDD%XDESC_MODQIN_VCD(BDD%NDESC_QIN))
  ALLOCATE(BDD%XDESC_MODQIN_VLD(BDD%NDESC_QIN))
  ALLOCATE(BDD%XDESC_MODQIN_NIG(BDD%NDESC_QIN))
  !
  ALLOCATE(BDD%NDESC_VENTUSEV(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_NATVENT(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FVSUM(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FVNIG(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FVSHO(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_TDESV(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FVVAC(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FOPEN(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FSSUM(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FSNIG(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_FSVAC(BDD%NDESC_VENT))
  ALLOCATE(BDD%XDESC_WIN_SW_MAX(BDD%NDESC_VENT))
  !
  ALLOCATE(BDD%NDESC_SCEUSEV(BDD%NDESC_CASE_SCHED))
  ALLOCATE(BDD%XDESC_DAYWBEG_SCHED(BDD%NDESC_CASE_SCHED,BDD%NDESC_NDAY_SCHED))
  ALLOCATE(BDD%XDESC_HOURBEG_SCHED(BDD%NDESC_CASE_SCHED,BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED))
  !
  ALLOCATE(BDD%NDESC_HOLUSEV(BDD%NDESC_CASE_HOLIDAY))
  ALLOCATE(BDD%XDESC_MOD_HOLIDAY(BDD%NDESC_CASE_HOLIDAY))
  ALLOCATE(BDD%XDESC_BEG_HOLIDAY(BDD%NDESC_CASE_HOLIDAY,BDD%NDESC_HOLIDAY))
  ALLOCATE(BDD%XDESC_END_HOLIDAY(BDD%NDESC_CASE_HOLIDAY,BDD%NDESC_HOLIDAY))
  !
  ALLOCATE(BDD%NDESC_OCCUSEV(BDD%NDESC_OCC))
  ALLOCATE(BDD%XDESC_PROBOCC(BDD%NDESC_OCC,BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED))
  !
  !-------------------------------------------------------------------------------
  !
  !*    3.   Read descriptive data
  !          ---------------------
  !
  ITOT = BDD%NDESC_CODE * ( 27 + 3 * BDD%NDESC_ROOF_LAYER  + 3 * BDD%NDESC_ROAD_LAYER              + &
       3 * BDD%NDESC_WALL_LAYER + 3 * BDD%NDESC_FLOOR_LAYER + 3 * BDD%NDESC_MASS_LAYER )           + &
       10 * BDD%NDESC_COOL + 10 * BDD%NDESC_HEAT + 7 * BDD%NDESC_QIN + 12 * BDD%NDESC_VENT         + &
       BDD%NDESC_CASE_SCHED*(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED + BDD%NDESC_NDAY_SCHED + 1) + &
       BDD%NDESC_CASE_HOLIDAY * (2* BDD%NDESC_HOLIDAY + 2)                                        + &
       BDD%NDESC_OCC*(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED+1)
  !
  ALLOCATE(ZWORK(ITOT))
  !
  CALL READ_SURF(HPROGRAM,'BLD_DESC_DAT',ZWORK,IRESP,HDIR='-')
  !
  I1=0 ; I2=0
  !
  ! Indices
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_BLD_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_AGE_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_USE_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_TER_LIST(:)  = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_CODE_LIST(:) = NINT(ZWORK(I1:I2))
  !
  ! Building architectural characteristics
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_ROOF(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_ROOF(:) = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_ROOF(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_ROOF(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROOF_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_ROOF (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_ROAD(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_ROAD(:) = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_ROAD(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_ROAD(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_ROAD_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_ROAD (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_WALL(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_WALL(:) = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_WALL(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_WALL(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_WALL_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_WALL (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_ISOROOFPOS(:) = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_ISOWALLPOS(:) = NINT(ZWORK(I1:I2))
  !
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_FLOOR(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_FLOOR(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_FLOOR_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_FLOOR (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ISMASS(:)       = ZWORK(I1:I2)
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_MASS(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_MASS(:,JL) = ZWORK(I1:I2)
  END DO
  DO JL=1,BDD%NDESC_MASS_LAYER
     CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_MASS (:,JL) = ZWORK(I1:I2)
  END DO
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_N50(:)        = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_GR(:)         = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_U_WIN(:)      = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHGC(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHGC_SH(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHADEARCHI(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ISMECH(:)     = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_MECHRATE(:)   = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_GREENROOF(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_PANEL(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_PANEL(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EFF_PANEL(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_FRAC_PANEL(:) = ZWORK(I1:I2)
  !
  ! Behavioural characteristics
  !
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%NDESC_HEATUSEV(:)   = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_FLDT(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_FIDT(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_FHDT(:)       = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_THEAT_OCCD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_THEAT_OCCN(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_THEAT_VCDD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_THEAT_VCDN(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_THEAT_VCLD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_HEAT) ; BDD%XDESC_FNOHEAT   (:) = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%NDESC_COOLUSEV(:)     = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_TCOOL_OCCD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_TCOOL_OCCN(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_TCOOL_VCDD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_TCOOL_VCDN(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_TCOOL_VCLD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_F_WATER_COND(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_F_WASTE_CAN(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_COP_RAT(:)      = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_COOL) ; BDD%XDESC_HR_TARGET(:)    = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%NDESC_QINUSEV(:)    = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%XDESC_QIN(:)        = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%XDESC_QIN_FRAD(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%XDESC_QIN_FLAT(:)   = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%XDESC_MODQIN_VCD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%XDESC_MODQIN_VLD(:) = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_QIN)  ; BDD%XDESC_MODQIN_NIG(:) = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%NDESC_VENTUSEV(:) = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_NATVENT(:)  = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FVSUM(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FVNIG(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FVSHO(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_TDESV(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FVVAC(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FOPEN(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FSSUM(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FSNIG(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_FSVAC(:)    = ZWORK(I1:I2)
  CALL UP_DESC_IND(BDD%NDESC_VENT) ; BDD%XDESC_WIN_SW_MAX(:) = ZWORK(I1:I2)
  !
  CALL UP_DESC_IND(BDD%NDESC_CASE_SCHED) ; BDD%NDESC_SCEUSEV(:) = NINT(ZWORK(I1:I2))
  DO JL=1,BDD%NDESC_NDAY_SCHED
     CALL UP_DESC_IND(BDD%NDESC_CASE_SCHED) ; BDD%XDESC_DAYWBEG_SCHED(:,JL) = ZWORK(I1:I2)
  ENDDO
  DO JL=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
     CALL UP_DESC_IND(BDD%NDESC_CASE_SCHED) ; BDD%XDESC_HOURBEG_SCHED(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  CALL UP_DESC_IND(BDD%NDESC_CASE_HOLIDAY) ; BDD%NDESC_HOLUSEV(:) = NINT(ZWORK(I1:I2))
  CALL UP_DESC_IND(BDD%NDESC_CASE_HOLIDAY) ; BDD%XDESC_MOD_HOLIDAY(:) = ZWORK(I1:I2)
  !
  DO JL=1,BDD%NDESC_HOLIDAY
     CALL UP_DESC_IND(BDD%NDESC_CASE_SCHED) ; BDD%XDESC_BEG_HOLIDAY(:,JL) = ZWORK(I1:I2)
  ENDDO
  DO JL=1,BDD%NDESC_HOLIDAY
     CALL UP_DESC_IND(BDD%NDESC_CASE_SCHED) ; BDD%XDESC_END_HOLIDAY(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  CALL UP_DESC_IND(BDD%NDESC_OCC) ; BDD%NDESC_OCCUSEV(:) = NINT(ZWORK(I1:I2))
  DO JL=1,(BDD%NDESC_NDAY_SCHED*BDD%NDESC_NCRE_SCHED)
     CALL UP_DESC_IND(BDD%NDESC_OCC) ; BDD%XDESC_PROBOCC(:,JL) = ZWORK(I1:I2)
  ENDDO
  !
  DEALLOCATE(ZWORK)
  !
  IF (LHOOK) CALL DR_HOOK('READ_BLD_DESCRIPTION_n',1,ZHOOK_HANDLE)
  !-------------------------------------------------------------------------------
CONTAINS
  SUBROUTINE UP_DESC_IND(K)
    INTEGER, INTENT(IN) :: K
    I1=I2+1
    I2=I2+K
  END SUBROUTINE UP_DESC_IND
  !-------------------------------------------------------------------------------
  !
END SUBROUTINE READ_BLD_DESCRIPTION_n
