!     ##########################################
      SUBROUTINE PGD_BEM_PAR (DTCO, DGU, UG, U, USS, DTB, DTI, TG, &
                              HPROGRAM,OAUTOSIZE)
!     ##########################################
!
!!**** *PGD_BEM_PAR* monitor for averaging and interpolations of BEM input data
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    G. Pigeon        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    08/2011
!!    G. Pigeon   09/2012, NPAR_FLOOR_LAYER default to 1
!!
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SURF_ATM_SSO_n, ONLY : SURF_ATM_SSO_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_GET_LUOUT
USE MODI_OPEN_NAMELIST
USE MODI_CLOSE_NAMELIST
USE MODI_TEST_NAM_VAR_SURF
USE MODI_INI_VAR_FROM_DATA_0D
USE MODI_INI_VAR_FROM_DATA
USE MODI_ABOR1_SFX
!
USE MODE_POS_SURF
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SURF_ATM_SSO_t), INTENT(INOUT) :: USS
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
TYPE(TEB_GRID_t), INTENT(INOUT) :: TG
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM     ! Type of program
LOGICAL,          INTENT(IN) :: OAUTOSIZE    ! T for automatic determination
!                                            ! of HVAC systems charcateristics
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
INTEGER               :: ILUOUT    ! output listing logical unit
INTEGER               :: ILUNAM    ! namelist file  logical unit
LOGICAL               :: GFOUND    ! true if namelist is found
INTEGER               :: JLAYER    ! loop counter on layers
INTEGER               :: JCOMP     ! Loop counter on compartiments
INTEGER               :: JSCHED    ! Loop counter on schedules
INTEGER               :: JJ        ! Loop counter on grid points
!
!
!*    0.3    Declaration of namelists
!            ------------------------
!
! bem options
!
INTEGER, PARAMETER                      :: NFLOOR_MAX  = 9
INTEGER, PARAMETER                      :: NMASS_MAX   = 9
INTEGER                                 :: NPAR_FLOOR_LAYER ! number of floor layers
INTEGER                                 :: NPAR_MASS_LAYER  ! number of floor layers
INTEGER                                 :: NPAR_BEMCOMP    ! number of bem compartments
INTEGER                                 :: NPAR_FVSHO
REAL , DIMENSION(9)                     :: XUNIF_NATVENT    ! 
CHARACTER(LEN=28)                       :: CFNAM_NATVENT    ! 
CHARACTER(LEN=6)                        :: CFTYP_NATVENT    ! 
!
REAL , DIMENSION(9)                     :: XUNIF_FRACOMP    ! 
CHARACTER(LEN=28)                       :: CFNAM_FRACOMP    ! 
CHARACTER(LEN=6)                        :: CFTYP_FRACOMP    ! 
!
REAL                                    :: XUNIF_ISMECH    !
CHARACTER(LEN=28)                       :: CFNAM_ISMECH    !
CHARACTER(LEN=6)                        :: CFTYP_ISMECH    !
!
REAL                                    :: XUNIF_MECHRATE  !
CHARACTER(LEN=28)                       :: CFNAM_MECHRATE  !
CHARACTER(LEN=6)                        :: CFTYP_MECHRATE  !
!
REAL                                    :: XUNIF_SHADEARCHI    ! 
CHARACTER(LEN=28)                       :: CFNAM_SHADEARCHI    ! 
CHARACTER(LEN=6)                        :: CFTYP_SHADEARCHI    ! 
!
! Floor parameters
!
REAL, DIMENSION(NFLOOR_MAX)             :: XUNIF_HC_FLOOR     ! floor layers heat capacity (J/K/m3)
REAL, DIMENSION(NFLOOR_MAX)             :: XUNIF_TC_FLOOR     ! floor layers thermal conduc (W/K/m)
REAL, DIMENSION(NFLOOR_MAX)             :: XUNIF_D_FLOOR      ! depth of floor layers      (m)
REAL                                    :: XUNIF_FLOOR_HEIGHT ! building floor height [m]
 CHARACTER(LEN=28), DIMENSION(NFLOOR_MAX):: CFNAM_HC_FLOOR     ! file name for HC_FLOOR   
 CHARACTER(LEN=28), DIMENSION(NFLOOR_MAX):: CFNAM_TC_FLOOR     ! file name for TC_FLOOR
 CHARACTER(LEN=28), DIMENSION(NFLOOR_MAX):: CFNAM_D_FLOOR      ! file name for D_FLOOR
 CHARACTER(LEN=28)                       :: CFNAM_FLOOR_HEIGHT ! file name for FLOOR_HEIGHT
 CHARACTER(LEN=6),  DIMENSION(NFLOOR_MAX):: CFTYP_HC_FLOOR     ! file type for HC_FLOOR   
 CHARACTER(LEN=6),  DIMENSION(NFLOOR_MAX):: CFTYP_TC_FLOOR     ! file type for TC_FLOOR
 CHARACTER(LEN=6),  DIMENSION(NFLOOR_MAX):: CFTYP_D_FLOOR      ! file type for D_FLOOR
 CHARACTER(LEN=6)                        :: CFTYP_FLOOR_HEIGHT ! file type for FLOOR_HEIGHT
!
! Mass parameters
!
REAL, DIMENSION(NMASS_MAX)              :: XUNIF_HC_MASS     ! mass layers heat capacity (J/K/m3)
REAL, DIMENSION(NMASS_MAX)              :: XUNIF_TC_MASS     ! mass layers thermal conduc (W/K/m)
REAL, DIMENSION(NMASS_MAX)              :: XUNIF_D_MASS      ! depth of mass layers      (m)
REAL                                    :: XUNIF_MASS_HEIGHT ! building mass height [m]
CHARACTER(LEN=28), DIMENSION(NMASS_MAX) :: CFNAM_HC_MASS     ! file name for HC_MASS   
CHARACTER(LEN=28), DIMENSION(NMASS_MAX) :: CFNAM_TC_MASS     ! file name for TC_MASS
CHARACTER(LEN=28), DIMENSION(NMASS_MAX) :: CFNAM_D_MASS      ! file name for D_MASS
CHARACTER(LEN=28)                       :: CFNAM_MASS_HEIGHT ! file name for MASS_HEIGHT
CHARACTER(LEN=6),  DIMENSION(NMASS_MAX) :: CFTYP_HC_MASS     ! file type for HC_MASS   
CHARACTER(LEN=6),  DIMENSION(NMASS_MAX) :: CFTYP_TC_MASS     ! file type for TC_MASS
CHARACTER(LEN=6),  DIMENSION(NMASS_MAX) :: CFTYP_D_MASS      ! file type for D_MASS
!
! AC systems parameters
!
REAL                                    :: XUNIF_F_WASTE_CAN  ! fraction of waste heat into the canyon
REAL                                    :: XUNIF_HR_TARGET    ! Relative humidity setpoint
REAL                                    :: XUNIF_CAP_SYS_HEAT ! Capacity of the heating system 
REAL                                    :: XUNIF_CAP_SYS_RAT  ! Rated capacity of the cooling system
REAL                                    :: XUNIF_T_ADP        ! Apparatus dewpoint temperature of the
REAL                                    :: XUNIF_M_SYS_RAT    ! Rated HVAC mass flow rate 
REAL                                    :: XUNIF_COP_RAT      ! Rated COP of the cooling system
REAL                                    :: XUNIF_F_WATER_COND ! fraction of evaporation of condensers
 CHARACTER(LEN=28)                       :: CFNAM_F_WASTE_CAN  ! file name for F_WASTE_CAN
 CHARACTER(LEN=28)                       :: CFNAM_HR_TARGET    ! Relative humidity setpoint
 CHARACTER(LEN=28)                       :: CFNAM_CAP_SYS_HEAT ! Capacity of the heating system 
 CHARACTER(LEN=28)                       :: CFNAM_CAP_SYS_RAT  ! Rated capacity of the cooling system
 CHARACTER(LEN=28)                       :: CFNAM_T_ADP        ! Apparatus dewpoint temperature of the
 CHARACTER(LEN=28)                       :: CFNAM_M_SYS_RAT    ! Rated HVAC mass flow rate 
 CHARACTER(LEN=28)                       :: CFNAM_COP_RAT      ! Rated COP of the cooling system
 CHARACTER(LEN=28)                       :: CFNAM_F_WATER_COND ! fraction of evaporation of condensers
 CHARACTER(LEN=6)                        :: CFTYP_F_WASTE_CAN  ! file type for F_WASTE_CAN
 CHARACTER(LEN=6)                        :: CFTYP_HR_TARGET    ! Relative humidity setpoint
 CHARACTER(LEN=6)                        :: CFTYP_CAP_SYS_HEAT ! Capacity of the heating system 
 CHARACTER(LEN=6)                        :: CFTYP_CAP_SYS_RAT  ! Rated capacity of the cooling system
 CHARACTER(LEN=6)                        :: CFTYP_T_ADP        ! Apparatus dewpoint temperature of the
 CHARACTER(LEN=6)                        :: CFTYP_M_SYS_RAT    ! Rated HVAC mass flow rate 
 CHARACTER(LEN=6)                        :: CFTYP_COP_RAT      ! Rated COP of the cooling system
 CHARACTER(LEN=6)                        :: CFTYP_F_WATER_COND ! fraction of evaporation of condensers
 REAL :: XUNIF_TDESV
 REAL, DIMENSION(9)  :: XUNIF_FVSHO
 REAL :: XUNIF_WIN_SW_MAX
 REAL :: XUNIF_FOPEN
 REAL, DIMENSION(9) :: XUNIF_FVSUM
 REAL, DIMENSION(9) :: XUNIF_FVVAC
 REAL, DIMENSION(9) :: XUNIF_FVNIG
 REAL, DIMENSION(9) :: XUNIF_FSSUM
 REAL, DIMENSION(9) :: XUNIF_FSVAC
 REAL, DIMENSION(9) :: XUNIF_FSNIG
 !
 REAL, DIMENSION(:,:), ALLOCATABLE :: XUNIF_DAYWBEG_SCHED
 REAL, DIMENSION(:,:), ALLOCATABLE :: XUNIF_HOURBEG_SCHED
 REAL, DIMENSION(:,:), ALLOCATABLE :: XUNIF_PROBOCC
 !
 REAL, DIMENSION(:,:), ALLOCATABLE :: XUNIF_END_HOLIDAY
 REAL, DIMENSION(:,:), ALLOCATABLE :: XUNIF_BEG_HOLIDAY
 REAL, DIMENSION(9)                :: XUNIF_MOD_HOLIDAY
 !
 REAL, DIMENSION(9)                     :: XUNIF_TCOOL_OCCD   
 CHARACTER(LEN=28)                      :: CFNAM_TCOOL_OCCD  
 CHARACTER(LEN=6)                       :: CFTYP_TCOOL_OCCD
 !
 REAL, DIMENSION(9)                     :: XUNIF_TCOOL_OCCN  
 CHARACTER(LEN=28)                      :: CFNAM_TCOOL_OCCN  
 CHARACTER(LEN=6)                       :: CFTYP_TCOOL_OCCN
 !
 REAL, DIMENSION(9)                     :: XUNIF_TCOOL_VCDD   
 CHARACTER(LEN=28)                      :: CFNAM_TCOOL_VCDD  
 CHARACTER(LEN=6)                       :: CFTYP_TCOOL_VCDD
 !
 REAL, DIMENSION(9)                     :: XUNIF_TCOOL_VCDN   
 CHARACTER(LEN=28)                      :: CFNAM_TCOOL_VCDN  
 CHARACTER(LEN=6)                       :: CFTYP_TCOOL_VCDN
 !
 REAL, DIMENSION(9)                     :: XUNIF_TCOOL_VCLD   
 CHARACTER(LEN=28)                      :: CFNAM_TCOOL_VCLD  
 CHARACTER(LEN=6)                       :: CFTYP_TCOOL_VCLD
 !
 REAL, DIMENSION(9)                     :: XUNIF_THEAT_OCCD   
 CHARACTER(LEN=28)                      :: CFNAM_THEAT_OCCD  
 CHARACTER(LEN=6)                       :: CFTYP_THEAT_OCCD
 !
 REAL, DIMENSION(9)                     :: XUNIF_THEAT_OCCN   
 CHARACTER(LEN=28)                      :: CFNAM_THEAT_OCCN  
 CHARACTER(LEN=6)                       :: CFTYP_THEAT_OCCN
 !
 REAL, DIMENSION(9)                     :: XUNIF_THEAT_VCDD   
 CHARACTER(LEN=28)                      :: CFNAM_THEAT_VCDD  
 CHARACTER(LEN=6)                       :: CFTYP_THEAT_VCDD
 !
 REAL, DIMENSION(9)                     :: XUNIF_THEAT_VCDN   
 CHARACTER(LEN=28)                      :: CFNAM_THEAT_VCDN  
 CHARACTER(LEN=6)                       :: CFTYP_THEAT_VCDN
 !
 REAL, DIMENSION(9)                     :: XUNIF_THEAT_VCLD   
 CHARACTER(LEN=28)                      :: CFNAM_THEAT_VCLD  
 CHARACTER(LEN=6)                       :: CFTYP_THEAT_VCLD
!
 CHARACTER(LEN=28) :: CFNAM_TDESV  
 CHARACTER(LEN=28) :: CFNAM_FVSHO
 CHARACTER(LEN=28) :: CFNAM_WIN_SW_MAX
 CHARACTER(LEN=28) :: CFNAM_FOPEN
 CHARACTER(LEN=28) :: CFNAM_FVSUM
 CHARACTER(LEN=28) :: CFNAM_FVVAC
 CHARACTER(LEN=28) :: CFNAM_FVNIG
 CHARACTER(LEN=28) :: CFNAM_FSSUM
 CHARACTER(LEN=28) :: CFNAM_FSVAC
 CHARACTER(LEN=28) :: CFNAM_FSNIG
 CHARACTER(LEN=28) :: CFNAM_DAYWBEG_SCHED
 CHARACTER(LEN=28) :: CFNAM_HOURBEG_SCHED
 CHARACTER(LEN=28) :: CFNAM_PROBOCC
 CHARACTER(LEN=28) :: CFNAM_BEG_HOLIDAY
 CHARACTER(LEN=28) :: CFNAM_END_HOLIDAY
 CHARACTER(LEN=28) :: CFNAM_MOD_HOLIDAY
 !
 CHARACTER(LEN=6) :: CFTYP_TDESV
 CHARACTER(LEN=6) :: CFTYP_FVSHO       
 CHARACTER(LEN=6) :: CFTYP_WIN_SW_MAX
 CHARACTER(LEN=6) :: CFTYP_FOPEN
 CHARACTER(LEN=6) :: CFTYP_FVSUM
 CHARACTER(LEN=6) :: CFTYP_FVVAC
 CHARACTER(LEN=6) :: CFTYP_FVNIG
 CHARACTER(LEN=6) :: CFTYP_FSSUM
 CHARACTER(LEN=6) :: CFTYP_FSVAC
 CHARACTER(LEN=6) :: CFTYP_FSNIG
 CHARACTER(LEN=6) :: CFTYP_DAYWBEG_SCHED
 CHARACTER(LEN=6) :: CFTYP_HOURBEG_SCHED
 CHARACTER(LEN=6) :: CFTYP_PROBOCC
 CHARACTER(LEN=6) :: CFTYP_BEG_HOLIDAY
 CHARACTER(LEN=6) :: CFTYP_END_HOLIDAY
 CHARACTER(LEN=6) :: CFTYP_MOD_HOLIDAY
!
! Internal heat gains
REAL, DIMENSION(9)                      :: XUNIF_QIN          ! internal heat gains [W m-2(floor)]
REAL                                    :: XUNIF_QIN_FRAD     ! radiant fraction of int heat gains
REAL                                    :: XUNIF_QIN_FLAT     ! Latent franction of internal heat gains
REAL, DIMENSION(9)                      :: XUNIF_MODQIN_VCD   ! Modulation during short-term vacancy
REAL, DIMENSION(9)                      :: XUNIF_MODQIN_VLD   ! Modulation during long-term vacancy
REAL, DIMENSION(9)                      :: XUNIF_MODQIN_NIG   ! Modulation during night
CHARACTER(LEN=28)                       :: CFNAM_QIN          ! file name for QIN
CHARACTER(LEN=28)                       :: CFNAM_QIN_FRAD     ! file name for QIN_FRAD
CHARACTER(LEN=28)                       :: CFNAM_QIN_FLAT     ! Latent franction of internal heat gains
CHARACTER(LEN=28)                       :: CFNAM_MODQIN_VCD   ! Modulation during short-term vacancy
CHARACTER(LEN=28)                       :: CFNAM_MODQIN_VLD   ! Modulation during long-term vacancy
CHARACTER(LEN=28)                       :: CFNAM_MODQIN_NIG   ! Modulation during night
CHARACTER(LEN=6)                        :: CFTYP_QIN          ! file type for QIN
CHARACTER(LEN=6)                        :: CFTYP_QIN_FRAD     ! file type for QIN_FRAD
CHARACTER(LEN=6)                        :: CFTYP_QIN_FLAT     ! Latent franction of internal heat gains
CHARACTER(LEN=6)                        :: CFTYP_MODQIN_VCD   ! Modulation during short-term vacancy
CHARACTER(LEN=6)                        :: CFTYP_MODQIN_VLD   ! Modulation during long-term vacancy
CHARACTER(LEN=6)                        :: CFTYP_MODQIN_NIG   ! Modulation during night
!
! window parameters
REAL                                    :: XUNIF_GR           ! glazing ratio
REAL                                    :: XUNIF_SHGC         ! solar transmitance of windows
REAL                                    :: XUNIF_SHGC_SH      ! solar transmitance of windows + shading
REAL                                    :: XUNIF_U_WIN        ! glazing thermal resistance[K m W-2]
 CHARACTER(LEN=28)                       :: CFNAM_GR           ! file name for GR
 CHARACTER(LEN=28)                       :: CFNAM_SHGC         ! file name for SHGC
 CHARACTER(LEN=28)                       :: CFNAM_SHGC_SH      ! file name for SHGC_SH
 CHARACTER(LEN=28)                       :: CFNAM_U_WIN        ! file name for U_WIN
 CHARACTER(LEN=6)                        :: CFTYP_GR           ! file type for GR
 CHARACTER(LEN=6)                        :: CFTYP_SHGC         ! file type for SHGC
 CHARACTER(LEN=6)                        :: CFTYP_SHGC_SH      ! file type for SHGC
 CHARACTER(LEN=6)                        :: CFTYP_U_WIN        ! file type for U_WIN
!
! air renewal
REAL                                    :: XUNIF_N50          ! infiltration/ventilation flow rate [AC/H]
CHARACTER(LEN=28)                       :: CFNAM_N50          ! file name for INF
CHARACTER(LEN=6)                        :: CFTYP_N50          ! file type for INF
!
! parameters for autosize calculation of the AC systems
REAL                                    :: XUNIF_T_SIZE_MAX   !
REAL                                    :: XUNIF_T_SIZE_MIN    !
 CHARACTER(LEN=28)                       :: CFNAM_T_SIZE_MAX    ! 
 CHARACTER(LEN=28)                       :: CFNAM_T_SIZE_MIN    ! 
 CHARACTER(LEN=6)                        :: CFTYP_T_SIZE_MAX    !
 CHARACTER(LEN=6)                        :: CFTYP_T_SIZE_MIN    !
!
REAL, DIMENSION(TG%NDIM) :: ZWORK
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
NAMELIST/NAM_DATA_BEM/ NPAR_FLOOR_LAYER, NPAR_MASS_LAYER,         &
                  NPAR_BEMCOMP,                                  &
                  XUNIF_HC_FLOOR, XUNIF_TC_FLOOR, XUNIF_D_FLOOR,  &
                  XUNIF_HC_MASS , XUNIF_TC_MASS , XUNIF_D_MASS ,  &
                  XUNIF_FLOOR_HEIGHT,                             &
                  XUNIF_F_WASTE_CAN,              &
                  XUNIF_F_WATER_COND, XUNIF_HR_TARGET,            &
                  XUNIF_QIN, XUNIF_QIN_FRAD, XUNIF_QIN_FLAT,      &   
                  XUNIF_MODQIN_VCD, XUNIF_MODQIN_VLD, XUNIF_MODQIN_NIG,     &
                  XUNIF_SHGC, XUNIF_U_WIN, XUNIF_GR,XUNIF_SHGC_SH,&
                  XUNIF_N50,                        &
                  XUNIF_CAP_SYS_HEAT,                             &
                  XUNIF_CAP_SYS_RAT, XUNIF_T_ADP, XUNIF_M_SYS_RAT,&
                  XUNIF_COP_RAT, XUNIF_T_SIZE_MAX,                &
                  XUNIF_T_SIZE_MIN,                               &
                  XUNIF_ISMECH, CFNAM_ISMECH, CFTYP_ISMECH,        &
                  XUNIF_MECHRATE, CFNAM_MECHRATE, CFTYP_MECHRATE,  &
                  XUNIF_SHADEARCHI, CFNAM_SHADEARCHI, CFTYP_SHADEARCHI,  &
                  XUNIF_NATVENT, CFNAM_NATVENT, CFTYP_NATVENT,    &
                  XUNIF_FRACOMP, CFNAM_FRACOMP, CFTYP_FRACOMP,    &
                  CFNAM_HC_FLOOR, CFNAM_TC_FLOOR, CFNAM_D_FLOOR,  &
                  CFNAM_HC_MASS, CFNAM_TC_MASS, CFNAM_D_MASS,  &
                  XUNIF_TDESV, XUNIF_FVSHO, XUNIF_WIN_SW_MAX,     &
                  XUNIF_FOPEN, XUNIF_FVSUM, XUNIF_FVVAC,          &
                  XUNIF_FVNIG, XUNIF_FSSUM, XUNIF_FSVAC, XUNIF_FSNIG, &
                  XUNIF_DAYWBEG_SCHED, XUNIF_HOURBEG_SCHED, XUNIF_PROBOCC, &
                  XUNIF_BEG_HOLIDAY, XUNIF_END_HOLIDAY, XUNIF_MOD_HOLIDAY, &
                  NPAR_FVSHO, CFNAM_FLOOR_HEIGHT,                             &
                  CFNAM_F_WASTE_CAN,              &
                  CFNAM_F_WATER_COND, CFNAM_HR_TARGET,            &
                  CFNAM_QIN, CFNAM_QIN_FRAD, CFNAM_QIN_FLAT,      &   
                  CFNAM_MODQIN_VCD, CFNAM_MODQIN_VLD, CFNAM_MODQIN_NIG, &
                  CFNAM_SHGC, CFNAM_U_WIN, CFNAM_GR,              &
                  CFNAM_SHGC_SH, CFNAM_N50,         &
                  CFNAM_CAP_SYS_HEAT,                             &
                  CFNAM_CAP_SYS_RAT, CFNAM_T_ADP, CFNAM_M_SYS_RAT,&
                  CFNAM_COP_RAT, CFNAM_T_SIZE_MAX,                &
                  CFNAM_T_SIZE_MIN, CFNAM_TDESV, CFNAM_FVSHO,     &
                  CFNAM_WIN_SW_MAX, CFNAM_FOPEN, CFNAM_FVSUM,     &
                  CFNAM_FVVAC, CFNAM_FVNIG, CFNAM_FSSUM,          &
                  CFNAM_FSVAC, CFNAM_FSNIG, CFNAM_DAYWBEG_SCHED,  &
                  CFNAM_HOURBEG_SCHED, CFNAM_PROBOCC,             &
                  CFNAM_BEG_HOLIDAY, CFNAM_END_HOLIDAY, CFNAM_MOD_HOLIDAY, &
                  CFTYP_HC_FLOOR, CFTYP_TC_FLOOR, CFTYP_D_FLOOR,  &
                  CFTYP_HC_MASS, CFTYP_TC_MASS, CFTYP_D_MASS,     &
                  CFTYP_FLOOR_HEIGHT,                             &
                  CFTYP_F_WASTE_CAN,              &
                  CFTYP_F_WATER_COND, CFTYP_HR_TARGET,            &
                  CFTYP_QIN, CFTYP_QIN_FRAD, CFTYP_QIN_FLAT,      &   
                  CFTYP_MODQIN_VCD, CFTYP_MODQIN_VLD, CFTYP_MODQIN_NIG, &
                  CFTYP_SHGC, CFTYP_U_WIN, CFTYP_GR,              &
                  CFTYP_SHGC_SH, CFTYP_N50,         &
                  CFTYP_CAP_SYS_HEAT,                             &
                  CFTYP_CAP_SYS_RAT, CFTYP_T_ADP, CFTYP_M_SYS_RAT,&
                  CFTYP_COP_RAT, CFTYP_T_SIZE_MAX,                &
                  CFTYP_T_SIZE_MIN, CFTYP_TDESV, CFTYP_FVSHO,     &
                  CFTYP_WIN_SW_MAX, CFTYP_FOPEN, CFTYP_FVSUM,     &
                  CFTYP_FVVAC, CFTYP_FVNIG, CFTYP_FSSUM,          &
                  CFTYP_FSVAC, CFTYP_FSNIG, CFTYP_DAYWBEG_SCHED,  &
                  CFTYP_HOURBEG_SCHED, CFTYP_PROBOCC,             &
                  CFTYP_BEG_HOLIDAY, CFTYP_END_HOLIDAY, CFTYP_MOD_HOLIDAY, &
                  XUNIF_FVSUM, CFNAM_FVSUM,CFTYP_FVSUM,               &
                  XUNIF_TCOOL_OCCD,CFNAM_TCOOL_OCCD,CFTYP_TCOOL_OCCD, &
                  XUNIF_TCOOL_OCCN,CFNAM_TCOOL_OCCN,CFTYP_TCOOL_OCCN, &
                  XUNIF_TCOOL_VCDD,CFNAM_TCOOL_VCDD,CFTYP_TCOOL_VCDD, &
                  XUNIF_TCOOL_VCDN,CFNAM_TCOOL_VCDN,CFTYP_TCOOL_VCDN, &
                  XUNIF_TCOOL_VCLD,CFNAM_TCOOL_VCLD,CFTYP_TCOOL_VCLD, &
                  XUNIF_THEAT_OCCD,CFNAM_THEAT_OCCD,CFTYP_THEAT_OCCD, &
                  XUNIF_THEAT_OCCN,CFNAM_THEAT_OCCN,CFTYP_THEAT_OCCN, &
                  XUNIF_THEAT_VCDD,CFNAM_THEAT_VCDD,CFTYP_THEAT_VCDD, &
                  XUNIF_THEAT_VCDN,CFNAM_THEAT_VCDN,CFTYP_THEAT_VCDN, &
                  XUNIF_THEAT_VCLD,CFNAM_THEAT_VCLD,CFTYP_THEAT_VCLD
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('PGD_BEM_PAR',0,ZHOOK_HANDLE)
!
!*    1.      Initializations
!             ---------------
!
DTB%NPAR_DAY_SCHED = 3
DTB%NPAR_CRE_SCHED = 4
DTB%NPAR_HOLIDAY   = 1
!
ALLOCATE(XUNIF_DAYWBEG_SCHED(DTB%NPAR_DAY_SCHED,9))
ALLOCATE(XUNIF_HOURBEG_SCHED(DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED,9))
ALLOCATE(XUNIF_PROBOCC      (DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED,9))
!
ALLOCATE(XUNIF_BEG_HOLIDAY(DTB%NPAR_HOLIDAY,9))
ALLOCATE(XUNIF_END_HOLIDAY(DTB%NPAR_HOLIDAY,9))
!
NPAR_FLOOR_LAYER = 1
NPAR_MASS_LAYER  = 1
NPAR_BEMCOMP    = 1
XUNIF_FRACOMP    = XUNDEF
XUNIF_ISMECH     = XUNDEF
XUNIF_MECHRATE   = XUNDEF
XUNIF_SHADEARCHI = XUNDEF
XUNIF_NATVENT    = XUNDEF
XUNIF_HC_FLOOR   = XUNDEF
XUNIF_TC_FLOOR   = XUNDEF
XUNIF_D_FLOOR    = XUNDEF
XUNIF_HC_MASS    = XUNDEF
XUNIF_TC_MASS    = XUNDEF
XUNIF_D_MASS     = XUNDEF
XUNIF_F_WASTE_CAN= XUNDEF
XUNIF_TCOOL_OCCD = XUNDEF
XUNIF_TCOOL_OCCN = XUNDEF
XUNIF_TCOOL_VCDD = XUNDEF
XUNIF_TCOOL_VCDN = XUNDEF
XUNIF_TCOOL_VCLD = XUNDEF
XUNIF_THEAT_OCCD = XUNDEF
XUNIF_THEAT_OCCN = XUNDEF
XUNIF_THEAT_VCDD = XUNDEF
XUNIF_THEAT_VCDN = XUNDEF
XUNIF_THEAT_VCLD = XUNDEF
XUNIF_QIN        = XUNDEF
XUNIF_QIN_FRAD   = XUNDEF
XUNIF_MODQIN_VCD = XUNDEF
XUNIF_MODQIN_VLD = XUNDEF
XUNIF_MODQIN_NIG = XUNDEF
XUNIF_SHGC         = XUNDEF
XUNIF_U_WIN        = XUNDEF
XUNIF_GR           = XUNDEF
XUNIF_SHGC_SH      = XUNDEF
XUNIF_FLOOR_HEIGHT = XUNDEF
XUNIF_N50          = XUNDEF
XUNIF_F_WATER_COND = XUNDEF
XUNIF_QIN_FLAT     = XUNDEF
XUNIF_HR_TARGET    = XUNDEF
XUNIF_CAP_SYS_HEAT = XUNDEF
XUNIF_CAP_SYS_RAT  = XUNDEF
XUNIF_T_ADP        = XUNDEF
XUNIF_M_SYS_RAT    = XUNDEF
XUNIF_COP_RAT      = XUNDEF
XUNIF_T_SIZE_MAX   = XUNDEF
XUNIF_T_SIZE_MIN   = XUNDEF
XUNIF_TDESV = XUNDEF
XUNIF_FVSHO = XUNDEF
XUNIF_WIN_SW_MAX = XUNDEF
XUNIF_FOPEN = XUNDEF
XUNIF_FVSUM = XUNDEF
XUNIF_FVVAC = XUNDEF
XUNIF_FVNIG = XUNDEF
XUNIF_FSSUM = XUNDEF
XUNIF_FSVAC = XUNDEF
XUNIF_FSNIG = XUNDEF
XUNIF_DAYWBEG_SCHED(:,:)= XUNDEF
XUNIF_HOURBEG_SCHED(:,:)= XUNDEF
XUNIF_PROBOCC(:,:)= XUNDEF
XUNIF_BEG_HOLIDAY(:,:)= XUNDEF
XUNIF_END_HOLIDAY(:,:)= XUNDEF
XUNIF_MOD_HOLIDAY(:)= XUNDEF
!
CFNAM_ISMECH       = '                            '
CFNAM_MECHRATE     = '                            '
CFNAM_SHADEARCHI   = '                            '
CFNAM_NATVENT      = '                            '
CFNAM_FRACOMP      = '                            '
CFNAM_HC_FLOOR (:) = '                            '
CFNAM_TC_FLOOR (:) = '                            '
CFNAM_D_FLOOR  (:) = '                            '
CFNAM_HC_MASS (:) = '                            '
CFNAM_TC_MASS (:) = '                            '
CFNAM_D_MASS  (:) = '                            '
CFNAM_F_WASTE_CAN  = '                            '
CFNAM_TCOOL_OCCD  = '                            '
CFNAM_TCOOL_OCCN  = '                            '
CFNAM_TCOOL_VCDD  = '                            '
CFNAM_TCOOL_VCDN  = '                            '
CFNAM_TCOOL_VCLD  = '                            '
CFNAM_THEAT_OCCD  = '                            '
CFNAM_THEAT_OCCN  = '                            '
CFNAM_THEAT_VCDD  = '                            '
CFNAM_THEAT_VCDN  = '                            '
CFNAM_THEAT_VCLD  = '                            '
CFNAM_QIN         = '                            '
CFNAM_QIN_FRAD    = '                            '
CFNAM_MODQIN_VCD  = '                            '
CFNAM_MODQIN_VLD  = '                            '
CFNAM_MODQIN_NIG  = '                            '
CFNAM_TCOOL_OCCD  = '                            '
CFNAM_TCOOL_OCCN  = '                            '
CFNAM_TCOOL_VCDD  = '                            '
CFNAM_TCOOL_VCDN  = '                            '
CFNAM_TCOOL_VCLD  = '                            '
CFNAM_THEAT_OCCD  = '                            '
CFNAM_THEAT_OCCN  = '                            '
CFNAM_THEAT_VCDD  = '                            '
CFNAM_THEAT_VCDN  = '                            '
CFNAM_THEAT_VCLD  = '                            '
CFNAM_SHGC         = '                            '
CFNAM_U_WIN        = '                            '
CFNAM_GR           = '                            '
CFNAM_SHGC_SH      = '                            '
CFNAM_FLOOR_HEIGHT = '                            '
CFNAM_N50          = '                            '
CFNAM_F_WATER_COND = '                            '
CFNAM_QIN_FLAT     = '                            '
CFNAM_HR_TARGET    = '                            '
CFNAM_CAP_SYS_HEAT = '                            '
CFNAM_CAP_SYS_RAT  = '                            '
CFNAM_T_ADP        = '                            '
CFNAM_M_SYS_RAT    = '                            '
CFNAM_COP_RAT      = '                            '
CFNAM_T_SIZE_MAX   = '                            '
CFNAM_T_SIZE_MIN   = '                            '
CFNAM_TDESV   = '                            '
CFNAM_FVSHO    = '                            '
CFNAM_WIN_SW_MAX  = '                            '
CFNAM_FOPEN = '                            '
CFNAM_FVSUM  = '                            ' 
CFNAM_FVVAC  = '                            ' 
CFNAM_FVNIG  = '                            ' 
CFNAM_FSSUM  = '                            ' 
CFNAM_FSVAC  = '                            '
CFNAM_FSNIG  = '                            '
CFNAM_DAYWBEG_SCHED= '                            '
CFNAM_HOURBEG_SCHED= '                            '
CFNAM_PROBOCC= '                            '
CFNAM_BEG_HOLIDAY= '                            '
CFNAM_END_HOLIDAY= '                            '
CFNAM_MOD_HOLIDAY= '                            '
!
CFTYP_ISMECH      = '      '
CFTYP_MECHRATE    = '      '
CFTYP_SHADEARCHI  = '      '
CFTYP_NATVENT      = '      '
CFTYP_FRACOMP      = '      '
CFTYP_HC_FLOOR(:)  = '      '
CFTYP_TC_FLOOR(:)  = '      '
CFTYP_D_FLOOR(:)   = '      '
CFTYP_HC_MASS(:)  = '      '
CFTYP_TC_MASS(:)  = '      '
CFTYP_D_MASS(:)   = '      '
CFTYP_F_WASTE_CAN  = '      '
CFTYP_QIN          = '      '
CFTYP_QIN_FRAD     = '      '
CFTYP_MODQIN_VCD   = '      '
CFTYP_MODQIN_VLD   = '      '
CFTYP_MODQIN_NIG   = '      '
CFTYP_SHGC         = '      '
CFTYP_U_WIN        = '      '
CFTYP_GR           = '      '
CFTYP_SHGC_SH      = '      '
CFTYP_FLOOR_HEIGHT = '      '
CFTYP_N50          = '      '
CFTYP_F_WATER_COND = '      '
CFTYP_QIN_FLAT     = '      '
CFTYP_HR_TARGET    = '      '
CFTYP_CAP_SYS_HEAT = '      '
CFTYP_CAP_SYS_RAT  = '      '
CFTYP_T_ADP        = '      '
CFTYP_M_SYS_RAT    = '      '
CFTYP_COP_RAT      = '      '
CFTYP_T_SIZE_MAX   = '      '
CFTYP_T_SIZE_MIN   = '      '
CFTYP_FVNIG   = '      '
CFTYP_TDESV   = '      '
CFTYP_FVSHO    = '      '
CFTYP_WIN_SW_MAX  = '      '
CFTYP_FOPEN    = '      '
CFTYP_FVSUM  = '      '
CFTYP_FVVAC  = '      '
CFTYP_FSSUM  = '      '
CFTYP_FSVAC  = '      '
CFTYP_FSNIG   = '      '
CFTYP_DAYWBEG_SCHED='      '
CFTYP_HOURBEG_SCHED='      '
CFTYP_PROBOCC='      '
CFTYP_BEG_HOLIDAY= '      '
CFTYP_END_HOLIDAY= '      '
CFTYP_MOD_HOLIDAY= '      '
!
!-------------------------------------------------------------------------------
!
!*    2.      Input file for cover types
!             --------------------------
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
 CALL OPEN_NAMELIST(HPROGRAM,ILUNAM)
!
 CALL POSNAM(ILUNAM,'NAM_DATA_BEM',GFOUND,ILUOUT)
IF (GFOUND) READ(UNIT=ILUNAM,NML=NAM_DATA_BEM)
!
 CALL CLOSE_NAMELIST(HPROGRAM,ILUNAM)
!
!-------------------------------------------------------------------------------
!
DTB%NPAR_FLOOR_LAYER = NPAR_FLOOR_LAYER
DTB%NPAR_MASS_LAYER  = NPAR_MASS_LAYER
DTB%NPAR_BEMCOMP     = NPAR_BEMCOMP
!
!-------------------------------------------------------------------------------
!
!* coherence check
!
IF ((     ANY(XUNIF_HC_FLOOR/=XUNDEF) .OR. ANY(LEN_TRIM(CFNAM_HC_FLOOR)>0) &
     .OR. ANY(XUNIF_TC_FLOOR/=XUNDEF) .OR. ANY(LEN_TRIM(CFNAM_TC_FLOOR)>0) &
     .OR. ANY(XUNIF_D_FLOOR /=XUNDEF) .OR. ANY(LEN_TRIM(CFNAM_D_FLOOR )>0) &
    ) .AND. NPAR_FLOOR_LAYER<1                                  ) THEN
  CALL ABOR1_SFX('In order to initialize FLOOR thermal quantities, please specify NPAR_FLOOR_LAYER in namelist NAM_DATA_BEM')
END IF
!
IF ((     ANY(XUNIF_HC_MASS/=XUNDEF) .OR. ANY(LEN_TRIM(CFNAM_HC_MASS)>0) &
     .OR. ANY(XUNIF_TC_MASS/=XUNDEF) .OR. ANY(LEN_TRIM(CFNAM_TC_MASS)>0) &
     .OR. ANY(XUNIF_D_MASS /=XUNDEF) .OR. ANY(LEN_TRIM(CFNAM_D_MASS )>0) &
     ) .AND. (NPAR_MASS_LAYER .LT.1)                                  ) THEN
   CALL ABOR1_SFX('In order to initialize MASS thermal quantities, please specify NPAR_MASS_LAYER in namelist NAM_DATA_BEM')
END IF
!
!-------------------------------------------------------------------------------
!
ALLOCATE(DTB%XPAR_HC_FLOOR    (TG%NDIM,NPAR_FLOOR_LAYER))
ALLOCATE(DTB%XPAR_TC_FLOOR    (TG%NDIM,NPAR_FLOOR_LAYER))
ALLOCATE(DTB%XPAR_D_FLOOR     (TG%NDIM,NPAR_FLOOR_LAYER))
!
ALLOCATE(DTB%XPAR_HC_MASS    (TG%NDIM,NPAR_MASS_LAYER))
ALLOCATE(DTB%XPAR_TC_MASS    (TG%NDIM,NPAR_MASS_LAYER))
ALLOCATE(DTB%XPAR_D_MASS     (TG%NDIM,NPAR_MASS_LAYER))
!
ALLOCATE(DTB%XPAR_F_WASTE_CAN   (TG%NDIM))
ALLOCATE(DTB%XPAR_QIN           (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_QIN_FRAD      (TG%NDIM))
ALLOCATE(DTB%XPAR_MODQIN_VCD    (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_MODQIN_VLD    (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_MODQIN_NIG    (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_SHGC          (TG%NDIM))
ALLOCATE(DTB%XPAR_U_WIN         (TG%NDIM))
ALLOCATE(DTB%XPAR_GR            (TG%NDIM))
ALLOCATE(DTB%XPAR_SHGC_SH       (TG%NDIM))
ALLOCATE(DTB%XPAR_FLOOR_HEIGHT  (TG%NDIM))
ALLOCATE(DTB%XPAR_N50           (TG%NDIM))
!
ALLOCATE(DTB%XPAR_F_WATER_COND (TG%NDIM))
ALLOCATE(DTB%XPAR_QIN_FLAT     (TG%NDIM))
ALLOCATE(DTB%XPAR_HR_TARGET    (TG%NDIM))
ALLOCATE(DTB%XPAR_CAP_SYS_HEAT (TG%NDIM))
ALLOCATE(DTB%XPAR_CAP_SYS_RAT  (TG%NDIM))
ALLOCATE(DTB%XPAR_T_ADP        (TG%NDIM))
ALLOCATE(DTB%XPAR_M_SYS_RAT    (TG%NDIM))
ALLOCATE(DTB%XPAR_COP_RAT      (TG%NDIM))
ALLOCATE(DTB%XPAR_T_SIZE_MAX   (TG%NDIM))
ALLOCATE(DTB%XPAR_T_SIZE_MIN   (TG%NDIM))
!
ALLOCATE(DTB%XPAR_TCOOL_OCCD   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_TCOOL_OCCN   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_TCOOL_VCDD   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_TCOOL_VCDN   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_TCOOL_VCLD   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_THEAT_OCCD   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_THEAT_OCCN   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_THEAT_VCDD   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_THEAT_VCDN   (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_THEAT_VCLD   (TG%NDIM,NPAR_BEMCOMP))
!
ALLOCATE(DTB%XPAR_FRACOMP      (TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_ISMECH  (TG%NDIM))
ALLOCATE(DTB%XPAR_MECHRATE(TG%NDIM))
ALLOCATE(DTB%XPAR_SHADEARCHI (TG%NDIM))
ALLOCATE(DTB%XPAR_NATVENT      (TG%NDIM,NPAR_BEMCOMP))
!
ALLOCATE(DTB%XPAR_TDESV(TG%NDIM))
ALLOCATE(DTB%XPAR_FVSHO(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_WIN_SW_MAX(TG%NDIM))
ALLOCATE(DTB%XPAR_FOPEN(TG%NDIM))
ALLOCATE(DTB%XPAR_FVSUM(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_FVVAC(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_FVNIG(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_FSSUM(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_FSVAC(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_FSNIG(TG%NDIM,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_DAYWBEG_SCHED(TG%NDIM,DTB%NPAR_DAY_SCHED,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_HOURBEG_SCHED(TG%NDIM,DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_PROBOCC      (TG%NDIM,DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_BEG_HOLIDAY(TG%NDIM,DTB%NPAR_HOLIDAY,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_END_HOLIDAY(TG%NDIM,DTB%NPAR_HOLIDAY,NPAR_BEMCOMP))
ALLOCATE(DTB%XPAR_MOD_HOLIDAY(TG%NDIM,NPAR_BEMCOMP))
!
!-------------------------------------------------------------------------------
IF (NFLOOR_MAX < NPAR_FLOOR_LAYER) THEN
  WRITE(ILUOUT,*) '---------------------------------------------'
  WRITE(ILUOUT,*) 'Please update pgd_bem_par.F90 routine :      '
  WRITE(ILUOUT,*) 'The maximum number of FLOOR LAYER             '
  WRITE(ILUOUT,*) 'in the declaration of the namelist variables '
  WRITE(ILUOUT,*) 'must be increased to : ', NPAR_FLOOR_LAYER
  WRITE(ILUOUT,*) '---------------------------------------------'
  CALL ABOR1_SFX('PGD_BEM_PAR: MAXIMUM NUMBER OF NPAR_FLOOR_LAYER MUST BE INCREASED')
END IF
!-------------------------------------------------------------------------------
!
!*    3.      user defined fields are prescribed
!             ----------------------------------
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'MAJ','SHADEARCHI      ','TWN', CFNAM_SHADEARCHI, CFTYP_SHADEARCHI, XUNIF_SHADEARCHI, &
        DTB%XPAR_SHADEARCHI, DTB%LDATA_SHADEARCHI )
IF (.NOT.DTB%LDATA_SHADEARCHI) DEALLOCATE(DTB%XPAR_SHADEARCHI)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'MAJ','ISMECH      ','TWN', CFNAM_ISMECH, CFTYP_ISMECH, XUNIF_ISMECH, &
        DTB%XPAR_ISMECH, DTB%LDATA_ISMECH )
IF (.NOT.DTB%LDATA_ISMECH) DEALLOCATE(DTB%XPAR_ISMECH)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'MAJ','MECHRATE      ','TWN', CFNAM_MECHRATE, CFTYP_MECHRATE, XUNIF_MECHRATE, &
        DTB%XPAR_MECHRATE, DTB%LDATA_MECHRATE )
IF (.NOT.DTB%LDATA_MECHRATE) DEALLOCATE(DTB%XPAR_MECHRATE)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
       HPROGRAM,'MAJ','FRACOMP   ','TWN', CFNAM_FRACOMP, CFTYP_FRACOMP, XUNIF_FRACOMP(JCOMP), &
       DTB%XPAR_FRACOMP(:,JCOMP), DTB%LDATA_FRACOMP )
ENDDO
IF (.NOT.DTB%LDATA_FRACOMP) THEN
   DEALLOCATE(DTB%XPAR_FRACOMP)
ELSE
   !
   ! Check sum of compartiment fractions
   !
   DO JJ=1,SIZE(DTB%XPAR_FRACOMP,1)
      IF (ABS(SUM(DTB%XPAR_FRACOMP(JJ,:))-1.0).GT.1.0E-6) STOP("Wrong sum of compartiment fractions")
   ENDDO
ENDIF
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'MAJ','NATVENT   ','TWN', CFNAM_NATVENT, CFTYP_NATVENT, XUNIF_NATVENT(JCOMP), &
        DTB%XPAR_NATVENT(:,JCOMP), DTB%LDATA_NATVENT )
ENDDO
IF (.NOT.DTB%LDATA_NATVENT) DEALLOCATE(DTB%XPAR_NATVENT)
!
CALL INI_VAR_FROM_DATA(DTCO, DGU, UG, U, USS, DTI, &
                        HPROGRAM,'INV','HC_FLOOR  ','TWN',CFNAM_HC_FLOOR,CFTYP_HC_FLOOR, &
        XUNIF_HC_FLOOR,DTB%XPAR_HC_FLOOR,DTB%LDATA_HC_FLOOR )
IF (.NOT.DTB%LDATA_HC_FLOOR) DEALLOCATE(DTB%XPAR_HC_FLOOR)
!
CALL INI_VAR_FROM_DATA(DTCO, DGU, UG, U, USS, DTI, &
                        HPROGRAM,'ARI','TC_FLOOR  ','TWN',CFNAM_TC_FLOOR,CFTYP_TC_FLOOR, &
                 XUNIF_TC_FLOOR ,DTB%XPAR_TC_FLOOR, DTB%LDATA_TC_FLOOR )
IF (.NOT.DTB%LDATA_TC_FLOOR) DEALLOCATE(DTB%XPAR_TC_FLOOR)
!
CALL INI_VAR_FROM_DATA(DTCO, DGU, UG, U, USS, DTI, &
                        HPROGRAM,'ARI','D_FLOOR   ','TWN',CFNAM_D_FLOOR,CFTYP_D_FLOOR, &
                 XUNIF_D_FLOOR  ,DTB%XPAR_D_FLOOR , DTB%LDATA_D_FLOOR )
IF (.NOT.DTB%LDATA_D_FLOOR) DEALLOCATE(DTB%XPAR_D_FLOOR)
!
CALL INI_VAR_FROM_DATA(DTCO, DGU, UG, U, USS, DTI, &
                        HPROGRAM,'INV','HC_MASS   ','TWN',CFNAM_HC_MASS,CFTYP_HC_MASS, &
        XUNIF_HC_MASS,DTB%XPAR_HC_MASS,DTB%LDATA_HC_MASS )
IF (.NOT.DTB%LDATA_HC_MASS) DEALLOCATE(DTB%XPAR_HC_MASS)
!
CALL INI_VAR_FROM_DATA(DTCO, DGU, UG, U, USS, DTI, &
                        HPROGRAM,'ARI','TC_MASS   ','TWN',CFNAM_TC_MASS,CFTYP_TC_MASS, &
                 XUNIF_TC_MASS ,DTB%XPAR_TC_MASS, DTB%LDATA_TC_MASS )
IF (.NOT.DTB%LDATA_TC_MASS) DEALLOCATE(DTB%XPAR_TC_MASS)
!
CALL INI_VAR_FROM_DATA(DTCO, DGU, UG, U, USS, DTI, &
                        HPROGRAM,'ARI','D_MASS   ','TWN',CFNAM_D_MASS,CFTYP_D_MASS, &
                 XUNIF_D_MASS  ,DTB%XPAR_D_MASS , DTB%LDATA_D_MASS )
IF (.NOT.DTB%LDATA_D_MASS) DEALLOCATE(DTB%XPAR_D_MASS)
!
DO JSCHED=1,DTB%NPAR_DAY_SCHED
   DO JCOMP=1,NPAR_BEMCOMP
      CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
         HPROGRAM,'MAJ','DAYWBEG_SCHED','TWN',CFNAM_DAYWBEG_SCHED,CFTYP_DAYWBEG_SCHED, &
         XUNIF_DAYWBEG_SCHED(JSCHED,JCOMP),DTB%XPAR_DAYWBEG_SCHED(:,JSCHED,JCOMP), DTB%LDATA_DAYWBEG_SCHED )
   ENDDO
ENDDO
IF (.NOT.DTB%LDATA_DAYWBEG_SCHED) DEALLOCATE(DTB%XPAR_DAYWBEG_SCHED)
!
DO JSCHED=1,DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED
   DO JCOMP=1,NPAR_BEMCOMP
      CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
         HPROGRAM,'MAJ','XHOURBEG_SCHED','TWN',CFNAM_HOURBEG_SCHED,CFTYP_HOURBEG_SCHED, &
         XUNIF_HOURBEG_SCHED(JSCHED,JCOMP),DTB%XPAR_HOURBEG_SCHED(:,JSCHED,JCOMP),DTB%LDATA_HOURBEG_SCHED )
   ENDDO
ENDDO
IF (.NOT.DTB%LDATA_HOURBEG_SCHED) DEALLOCATE(DTB%XPAR_HOURBEG_SCHED)
!
DO JSCHED=1,DTB%NPAR_DAY_SCHED*DTB%NPAR_CRE_SCHED
   DO JCOMP=1,NPAR_BEMCOMP
      CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
        HPROGRAM,'MAJ','PROBOCC','TWN',CFNAM_PROBOCC,CFTYP_PROBOCC, &
        XUNIF_PROBOCC(JSCHED,JCOMP),DTB%XPAR_PROBOCC(:,JSCHED,JCOMP),DTB%LDATA_PROBOCC)
   ENDDO
ENDDO
IF (.NOT.DTB%LDATA_PROBOCC) DEALLOCATE(DTB%XPAR_PROBOCC)
!
DO JSCHED=1,DTB%NPAR_HOLIDAY
   DO JCOMP=1,NPAR_BEMCOMP
      CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
         HPROGRAM,'MAJ','BEG_HOLIDAY','TWN',CFNAM_BEG_HOLIDAY,CFTYP_BEG_HOLIDAY, &
         XUNIF_BEG_HOLIDAY(JSCHED,JCOMP),DTB%XPAR_BEG_HOLIDAY(:,JSCHED,JCOMP), DTB%LDATA_BEG_HOLIDAY )
   ENDDO
ENDDO
IF (.NOT.DTB%LDATA_BEG_HOLIDAY) DEALLOCATE(DTB%XPAR_BEG_HOLIDAY)
!
DO JSCHED=1,DTB%NPAR_HOLIDAY
   DO JCOMP=1,NPAR_BEMCOMP
      CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
         HPROGRAM,'MAJ','END_HOLIDAY','TWN',CFNAM_END_HOLIDAY,CFTYP_END_HOLIDAY, &
         XUNIF_END_HOLIDAY(JSCHED,JCOMP),DTB%XPAR_END_HOLIDAY(:,JSCHED,JCOMP), DTB%LDATA_END_HOLIDAY )
   ENDDO
ENDDO
IF (.NOT.DTB%LDATA_END_HOLIDAY) DEALLOCATE(DTB%XPAR_END_HOLIDAY)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
     HPROGRAM,'ARI','MOD_HOLIDAY','TWN',CFNAM_MOD_HOLIDAY, CFTYP_MOD_HOLIDAY, XUNIF_MOD_HOLIDAY(JCOMP), &
     DTB%XPAR_MOD_HOLIDAY(:,JCOMP), DTB%LDATA_MOD_HOLIDAY)
ENDDO
IF (.NOT.DTB%LDATA_MOD_HOLIDAY) DEALLOCATE(DTB%XPAR_MOD_HOLIDAY)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
     HPROGRAM,'ARI','FSNIG','TWN',CFNAM_FSNIG, CFTYP_FSNIG, XUNIF_FSNIG(JCOMP), &
     DTB%XPAR_FSNIG(:,JCOMP), DTB%LDATA_FSNIG)
ENDDO
IF (.NOT.DTB%LDATA_FSNIG) DEALLOCATE(DTB%XPAR_FSNIG)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
      HPROGRAM,'ARI','FVNIG','TWN',CFNAM_FVNIG, CFTYP_FVNIG, XUNIF_FVNIG(JCOMP), &
      DTB%XPAR_FVNIG(:,JCOMP), DTB%LDATA_FVNIG)
ENDDO
IF (.NOT.DTB%LDATA_FVNIG) DEALLOCATE(DTB%XPAR_FVNIG)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
      HPROGRAM,'ARI','MODQIN_VCD','TWN',CFNAM_MODQIN_VCD, CFTYP_MODQIN_VCD,XUNIF_MODQIN_VCD(JCOMP), &
      DTB%XPAR_MODQIN_VCD(:,JCOMP),DTB%LDATA_MODQIN_VCD)
ENDDO
IF (.NOT.DTB%LDATA_MODQIN_VCD) DEALLOCATE(DTB%XPAR_MODQIN_VCD)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
      HPROGRAM,'ARI','MODQIN_VLD','TWN',CFNAM_MODQIN_VLD, CFTYP_MODQIN_VLD, XUNIF_MODQIN_VLD(JCOMP), &
      DTB%XPAR_MODQIN_VLD(:,JCOMP), DTB%LDATA_MODQIN_VLD)
ENDDO
IF (.NOT.DTB%LDATA_MODQIN_VLD) DEALLOCATE(DTB%XPAR_MODQIN_VLD)
!
DO JCOMP=1,NPAR_BEMCOMP
   CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
      HPROGRAM,'ARI','MODQIN_NIG','TWN',CFNAM_MODQIN_NIG, CFTYP_MODQIN_NIG, XUNIF_MODQIN_NIG(JCOMP), &
      DTB%XPAR_MODQIN_NIG(:,JCOMP), DTB%LDATA_MODQIN_NIG)
ENDDO
IF (.NOT.DTB%LDATA_MODQIN_NIG) DEALLOCATE(DTB%XPAR_MODQIN_NIG)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','TDESV','TWN',CFNAM_TDESV, CFTYP_TDESV, & 
   XUNIF_TDESV,DTB%XPAR_TDESV, DTB%LDATA_TDESV)
IF (.NOT.DTB%LDATA_TDESV) DEALLOCATE(DTB%XPAR_TDESV)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','FVSHO','TWN',CFNAM_FVSHO, CFTYP_FVSHO, &
   XUNIF_FVSHO(JCOMP), DTB%XPAR_FVSHO(:,JCOMP), DTB%LDATA_FVSHO)
ENDDO
IF (.NOT.DTB%LDATA_FVSHO) DEALLOCATE(DTB%XPAR_FVSHO)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','WIN_SW_MAX','TWN',CFNAM_WIN_SW_MAX, CFTYP_WIN_SW_MAX, XUNIF_WIN_SW_MAX, &
   DTB%XPAR_WIN_SW_MAX, DTB%LDATA_WIN_SW_MAX)
IF (.NOT.DTB%LDATA_WIN_SW_MAX) DEALLOCATE(DTB%XPAR_WIN_SW_MAX)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
    HPROGRAM,'ARI','FOPEN','TWN',CFNAM_FOPEN,CFTYP_FOPEN,XUNIF_FOPEN, &
    DTB%XPAR_FOPEN(:),DTB%LDATA_FOPEN)
IF (.NOT.DTB%LDATA_FOPEN) DEALLOCATE(DTB%XPAR_FOPEN)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','FVSUM','TWN',CFNAM_FVSUM,CFTYP_FVSUM,XUNIF_FVSUM(JCOMP), &
   DTB%XPAR_FVSUM(:,JCOMP),DTB%LDATA_FVSUM)
ENDDO
IF (.NOT.DTB%LDATA_FVSUM) DEALLOCATE(DTB%XPAR_FVSUM)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','FVVAC','TWN',CFNAM_FVVAC,CFTYP_FVVAC,XUNIF_FVVAC(JCOMP), &
   DTB%XPAR_FVVAC(:,JCOMP),DTB%LDATA_FVVAC)
ENDDO
IF (.NOT.DTB%LDATA_FVVAC) DEALLOCATE(DTB%XPAR_FVVAC)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','FSSUM','TWN',CFNAM_FSSUM,CFTYP_FSSUM,XUNIF_FSSUM(JCOMP), &
   DTB%XPAR_FSSUM(:,JCOMP),DTB%LDATA_FSSUM)
ENDDO
IF (.NOT.DTB%LDATA_FSSUM) DEALLOCATE(DTB%XPAR_FSSUM)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','FSVAC','TWN',CFNAM_FSVAC,CFTYP_FSVAC,XUNIF_FSVAC(JCOMP), &
   DTB%XPAR_FSVAC(:,JCOMP),DTB%LDATA_FSVAC)
ENDDO
IF (.NOT.DTB%LDATA_FSVAC) DEALLOCATE(DTB%XPAR_FSVAC)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','QIN','TWN',CFNAM_QIN, CFTYP_QIN, XUNIF_QIN(JCOMP), &
   DTB%XPAR_QIN(:,JCOMP), DTB%LDATA_QIN)
ENDDO
IF (.NOT.DTB%LDATA_QIN) DEALLOCATE(DTB%XPAR_QIN)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','F_WASTE_CAN','TWN',CFNAM_F_WASTE_CAN, CFTYP_F_WASTE_CAN, XUNIF_F_WASTE_CAN, &
        DTB%XPAR_F_WASTE_CAN, DTB%LDATA_F_WASTE_CAN)
IF (.NOT.DTB%LDATA_F_WASTE_CAN) DEALLOCATE(DTB%XPAR_F_WASTE_CAN)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','QIN_FRAD','TWN',CFNAM_QIN_FRAD, CFTYP_QIN_FRAD, XUNIF_QIN_FRAD, &
        DTB%XPAR_QIN_FRAD, DTB%LDATA_QIN_FRAD)
IF (.NOT.DTB%LDATA_QIN_FRAD) DEALLOCATE(DTB%XPAR_QIN_FRAD)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','SHGC','TWN',CFNAM_SHGC, CFTYP_SHGC, XUNIF_SHGC, DTB%XPAR_SHGC, DTB%LDATA_SHGC)
IF (.NOT.DTB%LDATA_SHGC) DEALLOCATE(DTB%XPAR_SHGC)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','U_WIN','TWN',CFNAM_U_WIN, CFTYP_U_WIN, XUNIF_U_WIN, DTB%XPAR_U_WIN, DTB%LDATA_U_WIN)
IF (.NOT.DTB%LDATA_U_WIN) DEALLOCATE(DTB%XPAR_U_WIN)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','GR','TWN',CFNAM_GR, CFTYP_GR, XUNIF_GR, DTB%XPAR_GR, DTB%LDATA_GR)
IF (.NOT.DTB%LDATA_GR) DEALLOCATE(DTB%XPAR_GR)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','SHGC_SH','TWN',CFNAM_SHGC_SH, CFTYP_SHGC_SH, XUNIF_SHGC_SH, &
        DTB%XPAR_SHGC_SH, DTB%LDATA_SHGC_SH)
IF (.NOT.DTB%LDATA_SHGC_SH) DEALLOCATE(DTB%XPAR_SHGC_SH)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','FLOOR_HEIGHT','TWN',CFNAM_FLOOR_HEIGHT, CFTYP_FLOOR_HEIGHT, XUNIF_FLOOR_HEIGHT, &
        DTB%XPAR_FLOOR_HEIGHT, DTB%LDATA_FLOOR_HEIGHT)
IF (.NOT.DTB%LDATA_FLOOR_HEIGHT) DEALLOCATE(DTB%XPAR_FLOOR_HEIGHT)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','N50','TWN',CFNAM_N50, CFTYP_N50, XUNIF_N50, DTB%XPAR_N50, DTB%LDATA_N50)
IF (.NOT.DTB%LDATA_N50) DEALLOCATE(DTB%XPAR_N50)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','F_WATER_COND','TWN',CFNAM_F_WATER_COND, CFTYP_F_WATER_COND, XUNIF_F_WATER_COND, &
        DTB%XPAR_F_WATER_COND, DTB%LDATA_F_WATER_COND)
IF (.NOT.DTB%LDATA_F_WATER_COND) DEALLOCATE(DTB%XPAR_F_WATER_COND)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','TCOOL_OCCD','TWN',CFNAM_TCOOL_OCCD, CFTYP_TCOOL_OCCD, XUNIF_TCOOL_OCCD(JCOMP), &
   DTB%XPAR_TCOOL_OCCD(:,JCOMP), DTB%LDATA_TCOOL_OCCD)
ENDDO
IF (.NOT.DTB%LDATA_TCOOL_OCCD) DEALLOCATE(DTB%XPAR_TCOOL_OCCD)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','TCOOL_OCCN','TWN',CFNAM_TCOOL_OCCN, CFTYP_TCOOL_OCCN, XUNIF_TCOOL_OCCN(JCOMP), &
   DTB%XPAR_TCOOL_OCCN(:,JCOMP), DTB%LDATA_TCOOL_OCCN)
ENDDO
IF (.NOT.DTB%LDATA_TCOOL_OCCN) DEALLOCATE(DTB%XPAR_TCOOL_OCCN)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','TCOOL_VCDD','TWN',CFNAM_TCOOL_VCDD, CFTYP_TCOOL_VCDD, XUNIF_TCOOL_VCDD(JCOMP), &
   DTB%XPAR_TCOOL_VCDD(:,JCOMP), DTB%LDATA_TCOOL_VCDD)
ENDDO
IF (.NOT.DTB%LDATA_TCOOL_VCDD) DEALLOCATE(DTB%XPAR_TCOOL_VCDD)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','TCOOL_VCDN','TWN',CFNAM_TCOOL_VCDN, CFTYP_TCOOL_VCDN, XUNIF_TCOOL_VCDN(JCOMP), &
   DTB%XPAR_TCOOL_VCDN(:,JCOMP), DTB%LDATA_TCOOL_VCDN)
ENDDO
IF (.NOT.DTB%LDATA_TCOOL_VCDN) DEALLOCATE(DTB%XPAR_TCOOL_VCDN)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','TCOOL_VCLD','TWN',CFNAM_TCOOL_VCLD, CFTYP_TCOOL_VCLD, XUNIF_TCOOL_VCLD(JCOMP), &
   DTB%XPAR_TCOOL_VCLD(:,JCOMP), DTB%LDATA_TCOOL_VCLD)
ENDDO
IF (.NOT.DTB%LDATA_TCOOL_VCLD) DEALLOCATE(DTB%XPAR_TCOOL_VCLD)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','THEAT_OCCD','TWN',CFNAM_THEAT_OCCD, CFTYP_THEAT_OCCD, XUNIF_THEAT_OCCD(JCOMP), &
   DTB%XPAR_THEAT_OCCD(:,JCOMP), DTB%LDATA_THEAT_OCCD)
ENDDO
IF (.NOT.DTB%LDATA_THEAT_OCCD) DEALLOCATE(DTB%XPAR_THEAT_OCCD)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','THEAT_OCCN','TWN',CFNAM_THEAT_OCCN, CFTYP_THEAT_OCCN, XUNIF_THEAT_OCCN(JCOMP), &
   DTB%XPAR_THEAT_OCCN(:,JCOMP), DTB%LDATA_THEAT_OCCN)
ENDDO
IF (.NOT.DTB%LDATA_THEAT_OCCN) DEALLOCATE(DTB%XPAR_THEAT_OCCN)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','THEAT_VCDD','TWN',CFNAM_THEAT_VCDD, CFTYP_THEAT_VCDD, XUNIF_THEAT_VCDD(JCOMP), &
   DTB%XPAR_THEAT_VCDD(:,JCOMP), DTB%LDATA_THEAT_VCDD)
ENDDO
IF (.NOT.DTB%LDATA_THEAT_VCDD) DEALLOCATE(DTB%XPAR_THEAT_VCDD)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','THEAT_VCDN','TWN',CFNAM_THEAT_VCDN, CFTYP_THEAT_VCDN, XUNIF_THEAT_VCDN(JCOMP), &
   DTB%XPAR_THEAT_VCDN(:,JCOMP), DTB%LDATA_THEAT_VCDN)
ENDDO
IF (.NOT.DTB%LDATA_THEAT_VCDN) DEALLOCATE(DTB%XPAR_THEAT_VCDN)
!
DO JCOMP=1,NPAR_BEMCOMP
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
   HPROGRAM,'ARI','THEAT_VCLD','TWN',CFNAM_THEAT_VCLD, CFTYP_THEAT_VCLD, XUNIF_THEAT_VCLD(JCOMP), &
   DTB%XPAR_THEAT_VCLD(:,JCOMP), DTB%LDATA_THEAT_VCLD)
ENDDO
IF (.NOT.DTB%LDATA_THEAT_VCLD) DEALLOCATE(DTB%XPAR_THEAT_VCLD)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','QIN_FLAT','TWN',CFNAM_QIN_FLAT, CFTYP_QIN_FLAT, XUNIF_QIN_FLAT, &
        DTB%XPAR_QIN_FLAT, DTB%LDATA_QIN_FLAT)
IF (.NOT.DTB%LDATA_QIN_FLAT) DEALLOCATE(DTB%XPAR_QIN_FLAT)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','HR_TARGET','TWN',CFNAM_HR_TARGET, CFTYP_HR_TARGET, XUNIF_HR_TARGET, &
        DTB%XPAR_HR_TARGET, DTB%LDATA_HR_TARGET)
IF (.NOT.DTB%LDATA_HR_TARGET) DEALLOCATE(DTB%XPAR_HR_TARGET)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','T_SIZE_MAX','TWN',CFNAM_T_SIZE_MAX, CFTYP_T_SIZE_MAX, XUNIF_T_SIZE_MAX, &
        DTB%XPAR_T_SIZE_MAX, DTB%LDATA_T_SIZE_MAX)
IF (.NOT.DTB%LDATA_T_SIZE_MAX) DEALLOCATE(DTB%XPAR_T_SIZE_MAX)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','T_SIZE_MIN','TWN',CFNAM_T_SIZE_MIN, CFTYP_T_SIZE_MIN, XUNIF_T_SIZE_MIN, &
        DTB%XPAR_T_SIZE_MIN, DTB%LDATA_T_SIZE_MIN)
IF (.NOT.DTB%LDATA_T_SIZE_MIN) DEALLOCATE(DTB%XPAR_T_SIZE_MIN)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','CAP_SYS_HEAT','TWN',CFNAM_CAP_SYS_HEAT, CFTYP_CAP_SYS_HEAT, XUNIF_CAP_SYS_HEAT, &
        DTB%XPAR_CAP_SYS_HEAT, DTB%LDATA_CAP_SYS_HEAT)
IF (.NOT.DTB%LDATA_CAP_SYS_HEAT) DEALLOCATE(DTB%XPAR_CAP_SYS_HEAT)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','CAP_SYS_RAT','TWN',CFNAM_CAP_SYS_RAT, CFTYP_CAP_SYS_RAT, XUNIF_CAP_SYS_RAT, &
        DTB%XPAR_CAP_SYS_RAT, DTB%LDATA_CAP_SYS_RAT)
IF (.NOT.DTB%LDATA_CAP_SYS_RAT) DEALLOCATE(DTB%XPAR_CAP_SYS_RAT)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','M_SYS_RAT','TWN',CFNAM_M_SYS_RAT, CFTYP_M_SYS_RAT, XUNIF_M_SYS_RAT, &
        DTB%XPAR_M_SYS_RAT, DTB%LDATA_M_SYS_RAT)
IF (.NOT.DTB%LDATA_M_SYS_RAT) DEALLOCATE(DTB%XPAR_M_SYS_RAT)
  !
IF (OAUTOSIZE) THEN
  IF (DTB%LDATA_CAP_SYS_HEAT .OR. DTB%LDATA_CAP_SYS_RAT .OR. DTB%LDATA_M_SYS_RAT) THEN
    WRITE(ILUOUT,*) '==> You choose LAUTOSIZE=T <=='
    WRITE(ILUOUT,*) 'Therefore HVAC systems characteristics will be computed automatically'
    IF (DTB%LDATA_CAP_SYS_HEAT) THEN
      WRITE(ILUOUT,*) 'Data you provided for CAP_SYS_HEAT are then discarded.'
      DEALLOCATE(DTB%XPAR_CAP_SYS_HEAT)
    END IF
    IF (DTB%LDATA_CAP_SYS_RAT ) THEN
      WRITE(ILUOUT,*) 'Data you provided for CAP_SYS_RAT  are then discarded.'
      DEALLOCATE(DTB%XPAR_CAP_SYS_RAT)
    END IF
    IF (DTB%LDATA_M_SYS_RAT   ) THEN
      WRITE(ILUOUT,*) 'Data you provided for M_SYS_RAT    are then discarded.'
      DEALLOCATE(DTB%XPAR_M_SYS_RAT)
    END IF
  END IF
  DTB%LDATA_CAP_SYS_HEAT = .FALSE.
  DTB%LDATA_CAP_SYS_RAT  = .FALSE.
  DTB%LDATA_M_SYS_RAT    = .FALSE.
ELSE
  IF (DTB%LDATA_T_SIZE_MAX .OR. DTB%LDATA_T_SIZE_MAX) THEN
    WRITE(ILUOUT,*) '==> You choose LAUTOSIZE=F <=='
    WRITE(ILUOUT,*) 'Therefore HVAC systems characteristics are specified'
    WRITE(ILUOUT,*) 'and you do not need the minimal and maximum temperatures'
    WRITE(ILUOUT,*) 'that would be used if you have chosen an automatic calibration.'
    IF (DTB%LDATA_T_SIZE_MAX) THEN
      WRITE(ILUOUT,*) 'Data you provided for T_SIZE_MAX are then discarded.'
      DEALLOCATE(DTB%XPAR_T_SIZE_MAX)
    END IF
    IF (DTB%LDATA_T_SIZE_MIN) THEN
      WRITE(ILUOUT,*) 'Data you provided for T_SIZE_MIN are then discarded.'
      DEALLOCATE(DTB%XPAR_T_SIZE_MIN)
    END IF
  END IF
  DTB%LDATA_T_SIZE_MAX = .FALSE.
  DTB%LDATA_T_SIZE_MIN = .FALSE.
END IF
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','T_ADP','TWN',CFNAM_T_ADP, CFTYP_T_ADP, XUNIF_T_ADP, DTB%XPAR_T_ADP, DTB%LDATA_T_ADP)
IF (.NOT.DTB%LDATA_T_ADP) DEALLOCATE(DTB%XPAR_T_ADP)
!
CALL INI_VAR_FROM_DATA_0D(DTCO, DGU, UG, U, USS, &
                           HPROGRAM,'ARI','COP_RAT','TWN',CFNAM_COP_RAT, CFTYP_COP_RAT, XUNIF_COP_RAT, &
        DTB%XPAR_COP_RAT, DTB%LDATA_COP_RAT)
IF (.NOT.DTB%LDATA_COP_RAT) DEALLOCATE(DTB%XPAR_COP_RAT)

!-------------------------------------------------------------------------------
!
!* coherence checks
!
 CALL COHERENCE_THERMAL_DATA_FL('FLOOR',DTB%LDATA_HC_FLOOR,DTB%LDATA_TC_FLOOR,DTB%LDATA_D_FLOOR)
 CALL COHERENCE_THERMAL_DATA_FL('MASS ',DTB%LDATA_HC_MASS ,DTB%LDATA_TC_MASS ,DTB%LDATA_D_MASS )
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('PGD_BEM_PAR',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
CONTAINS
SUBROUTINE COHERENCE_THERMAL_DATA_FL(HTYPE,ODATA_HC,ODATA_TC,ODATA_D)
 CHARACTER(LEN=5), INTENT(IN) :: HTYPE
LOGICAL,          INTENT(IN) :: ODATA_HC
LOGICAL,          INTENT(IN) :: ODATA_TC
LOGICAL,          INTENT(IN) :: ODATA_D
!
IF (ODATA_HC .OR. ODATA_TC .OR. ODATA_D) THEN
  IF (.NOT. (ODATA_HC .AND. ODATA_TC .AND. ODATA_D)) THEN
    WRITE(ILUOUT,*) '*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'
    WRITE(ILUOUT,*) 'When specifying data for thermal ',TRIM(HTYPE),' characteristics,'
    WRITE(ILUOUT,*) 'All three parameters MUST be defined:'
    WRITE(ILUOUT,*) 'Heat capacity, Thermal conductivity and depths of layers'
    WRITE(ILUOUT,*) ' '
    WRITE(ILUOUT,*) 'In your case :'
    IF (ODATA_HC) THEN
      WRITE(ILUOUT,*) 'Heat capacity is defined'
    ELSE
      WRITE(ILUOUT,*) 'Heat capacity is NOT defined'
    END IF
    IF (ODATA_TC) THEN
      WRITE(ILUOUT,*) 'Thermal conductivity is defined'
    ELSE
      WRITE(ILUOUT,*) 'Thermal conductivity is NOT defined'
    END IF
    IF (ODATA_D) THEN
      WRITE(ILUOUT,*) 'Depths of layers are defined'
    ELSE
      WRITE(ILUOUT,*) 'Depths of layers are NOT defined'
    END IF
    WRITE(ILUOUT,*) '*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'
    CALL ABOR1_SFX('Heat capacity, Thermal conductivity and depths of layers MUST all be defined for '//HTYPE)
  END IF
END IF
END SUBROUTINE COHERENCE_THERMAL_DATA_FL
!-------------------------------------------------------------------------------
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE PGD_BEM_PAR
