!##################
MODULE MODD_TEB_HYDRO_PGD_n
!##################
!
!!****  *MODD_TEB_HYDRO_PGD - declaration of ISBA scheme packed surface parameters for urban hydrology
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!	A. Lemonsu *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       02/2013
!!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_TYPE_SNOW
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

TYPE TEB_HYDRO_PGD_t
!-------------------------------------------------------------------------------
!
! Input Parameters, per patch:
!
! - soil: primary parameters
!
  REAL, POINTER, DIMENSION(:)    :: XRUNOFFB         ! green roof sub-grid surface runoff slope parameter (-)
  REAL, POINTER, DIMENSION(:)    :: XWDRAIN          ! green roof continuous drainage parameter           (-)
  REAL, POINTER, DIMENSION(:)    :: XTAUICE          ! soil freezing characteristic timescale  (s)
  REAL, POINTER, DIMENSION(:)    :: XRUNOFFD         ! depth over which sub-grid runoff is computed (m)
  REAL, POINTER, DIMENSION(:,:)  :: XSOILWGHT        ! ISBA-DIF: weights for vertical
  REAL, POINTER, DIMENSION(:,:)  :: XDZG             ! soil layers thicknesses (DIF option)
  REAL, POINTER, DIMENSION(:,:)  :: XDZDIF           ! distance between consecuative layer mid-points (DIF option)
  INTEGER, POINTER, DIMENSION(:) :: NWG_LAYER        ! Number of soil moisture layers for DIF
  REAL, POINTER, DIMENSION(:)    :: XDROOT           ! effective root depth for DIF (m)
  REAL, POINTER, DIMENSION(:)    :: XDG2_ROAD        ! root depth for DIF as 3-L (m)
  REAL, POINTER, DIMENSION(:)    :: XPCPS
!
!-------------------------------------------------------------------------------
!
!! - soil: Secondary parameters: thermal 
!!
!  REAL, POINTER, DIMENSION(:)    :: XCGSAT           ! soil thermal inertia coefficient at 
!                                                     ! saturation                              (K m2/J)
!  REAL, POINTER, DIMENSION(:,:)  :: XHCAPSOIL        ! soil heat capacity                      (J/K/m3)
!  REAL, POINTER, DIMENSION(:,:)  :: XCONDDRY         ! soil dry thermal conductivity           (W/m/K)
!  REAL, POINTER, DIMENSION(:,:)  :: XCONDSLD         ! soil solids thermal conductivity        (W/m/K)
!  REAL, POINTER, DIMENSION(:)    :: XTDEEP           ! prescribed deep soil temperature (optional)   (K)
!!
!! - SGH scheme
!!
!  REAL, POINTER, DIMENSION(:)    :: XD_ICE           ! depth of the soil column for the calculation
                                                     ! of the frozen soil fraction (m)
!
!-------------------------------------------------------------------------------
!
! Sewer characteristics
!
  REAL, POINTER, DIMENSION(:)    :: XDSEWER          ! Sewer depth    (m)
  REAL, POINTER, DIMENSION(:)    :: XLSEWER          ! Sewer length   (m)
  REAL, POINTER, DIMENSION(:)    :: XLSTORM          ! Sewer length   (m)
  REAL                           :: XWS_ROOF_MAX     ! Max. capacity of surface roof water storage (mm)
  REAL                           :: XWS_ROAD_MAX     ! Max. capacity of surface road water storage (mm)
  REAL                           :: XIP_SEWER        ! Parameter for parasite infiltrations into sewer (-)
  REAL                           :: XCONNEX          ! Impervious surfaces connexion rate to the sewer (-)
  REAL, POINTER, DIMENSION(:)    :: XDENSITY_SEW     ! Total sewer length density (-)
  INTEGER, POINTER, DIMENSION(:) :: NLAYER_SEWER     ! Ground layer where the sewer is located (-)
  INTEGER                        :: NSTEP_OUT        ! number of run time step in output time step
  INTEGER                        :: NSTEP_FORC       ! forcing run time step loop
  INTEGER                        :: NSTEP_SURF       ! isba run time step loop
!
! Water infiltration through pavement
!
  REAL                           :: XINFIL_ROAD      ! Water infiltration through roads (kg/m2/s)
!-------------------------------------------------------------------------------
!
END TYPE TEB_HYDRO_PGD_t

CONTAINS

SUBROUTINE TEB_HYDRO_PGD_INIT(YTEB_HYDRO_PGD)
TYPE(TEB_HYDRO_PGD_t), INTENT(INOUT) :: YTEB_HYDRO_PGD
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_TEB_HYDRO_N:TEB_HYDRO_PGD_INIT",0,ZHOOK_HANDLE)
NULLIFY(YTEB_HYDRO_PGD%XRUNOFFB)
NULLIFY(YTEB_HYDRO_PGD%XWDRAIN)
NULLIFY(YTEB_HYDRO_PGD%XTAUICE)
NULLIFY(YTEB_HYDRO_PGD%XRUNOFFD)
NULLIFY(YTEB_HYDRO_PGD%XSOILWGHT)
NULLIFY(YTEB_HYDRO_PGD%XDZG)
NULLIFY(YTEB_HYDRO_PGD%XDZDIF)
NULLIFY(YTEB_HYDRO_PGD%NWG_LAYER)
NULLIFY(YTEB_HYDRO_PGD%XDROOT)
NULLIFY(YTEB_HYDRO_PGD%XDG2_ROAD)
NULLIFY(YTEB_HYDRO_PGD%XPCPS)
!
!NULLIFY(YTEB_HYDRO_PGD%XCGSAT)
!NULLIFY(YTEB_HYDRO_PGD%XHCAPSOIL)
!NULLIFY(YTEB_HYDRO_PGD%XCONDDRY)
!NULLIFY(YTEB_HYDRO_PGD%XCONDSLD)
!NULLIFY(YTEB_HYDRO_PGD%XTDEEP)
!NULLIFY(YTEB_HYDRO_PGD%XD_ICE)
!
NULLIFY(YTEB_HYDRO_PGD%XDSEWER)
NULLIFY(YTEB_HYDRO_PGD%XLSEWER)
NULLIFY(YTEB_HYDRO_PGD%XLSTORM)
NULLIFY(YTEB_HYDRO_PGD%XDENSITY_SEW)
NULLIFY(YTEB_HYDRO_PGD%NLAYER_SEWER)
YTEB_HYDRO_PGD%XINFIL_ROAD=0
YTEB_HYDRO_PGD%NSTEP_OUT=0
YTEB_HYDRO_PGD%NSTEP_SURF=0
YTEB_HYDRO_PGD%XWS_ROOF_MAX=0.0
YTEB_HYDRO_PGD%XWS_ROAD_MAX=0.0
YTEB_HYDRO_PGD%XIP_SEWER=0.0
YTEB_HYDRO_PGD%XCONNEX=0.0
IF (LHOOK) CALL DR_HOOK("MODD_TEB_HYDRO_N:TEB_HYDRO_PGD_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE TEB_HYDRO_PGD_INIT


END MODULE MODD_TEB_HYDRO_PGD_n
