!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!#############################################################
SUBROUTINE INIT_VEG_GARDEN_n(KI, OCANOPY, HROUGH, TPSNOW, &
                         HPHOTO, PLAIMIN, PH_TREE, PVEGTYPE, PLAI, PZ0, PVEG, PEMIS, &
                         OTR_ML, PFAPARC, PFAPIRC, PLAI_EFFC, PMUS, &
                         PALBNIR_SOIL, PALBVIS_SOIL, PALBUV_SOIL, PALBNIR, PALBVIS, PALBUV, &
                         OSURF_DIAG_ALBEDO, PPSN, PPSNG, PPSNV, PPSNV_A, &
                         PDIR_ALB, PSCA_ALB, PEMIS_OUT, PTSRAD )  
!#############################################################
!
!!****  *INIT_VEG_GARDEN_n* - routine to initialize ISBA
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_TYPE_SNOW
USE MODD_DATA_COVER_PAR,  ONLY: NVEGTYPE
!
USE MODI_INIT_VEG_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
INTEGER, INTENT(IN) :: KI
LOGICAL, INTENT(IN) :: OCANOPY
 CHARACTER(LEN=4), INTENT(INOUT) :: HROUGH
TYPE(SURF_SNOW),      INTENT(INOUT) :: TPSNOW  ! snow characteristics
!
 CHARACTER(LEN=3), INTENT(IN) :: HPHOTO
REAL, DIMENSION(:), INTENT(IN) :: PLAIMIN
REAL, DIMENSION(:), INTENT(IN) :: PH_TREE
REAL, DIMENSION(:,:), INTENT(IN) :: PVEGTYPE
REAL, DIMENSION(:), INTENT(INOUT) :: PLAI
REAL, DIMENSION(:), INTENT(INOUT) :: PZ0
REAL, DIMENSION(:), INTENT(INOUT) :: PVEG
REAL, DIMENSION(:), INTENT(INOUT) :: PEMIS
!
LOGICAL, INTENT(IN) :: OTR_ML
REAL, DIMENSION(:), POINTER :: PFAPARC
REAL, DIMENSION(:), POINTER :: PFAPIRC
REAL, DIMENSION(:), POINTER :: PLAI_EFFC
REAL, DIMENSION(:), POINTER :: PMUS
!
REAL, DIMENSION(:), POINTER :: PALBNIR_SOIL
REAL, DIMENSION(:), POINTER :: PALBVIS_SOIL
REAL, DIMENSION(:), POINTER :: PALBUV_SOIL
REAL, DIMENSION(:), POINTER :: PALBNIR
REAL, DIMENSION(:), POINTER :: PALBVIS
REAL, DIMENSION(:), POINTER :: PALBUV
!
LOGICAL, INTENT(OUT) :: OSURF_DIAG_ALBEDO
!
REAL, DIMENSION(:), POINTER :: PPSN
REAL, DIMENSION(:), POINTER :: PPSNG
REAL, DIMENSION(:), POINTER :: PPSNV
REAL, DIMENSION(:), POINTER :: PPSNV_A
!
REAL, DIMENSION(:,:), INTENT(OUT) :: PDIR_ALB
REAL, DIMENSION(:,:), INTENT(OUT) :: PSCA_ALB
REAL, DIMENSION(:), INTENT(OUT) :: PEMIS_OUT
REAL, DIMENSION(:), INTENT(OUT) :: PTSRAD
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
REAL, DIMENSION(:,:), POINTER :: ZFAPARC
REAL, DIMENSION(:,:), POINTER :: ZFAPIRC
REAL, DIMENSION(:,:), POINTER :: ZLAI_EFFC
REAL, DIMENSION(:,:), POINTER :: ZMUS
!
REAL, DIMENSION(:,:), POINTER :: ZALBNIR_SOIL
REAL, DIMENSION(:,:), POINTER :: ZALBVIS_SOIL
REAL, DIMENSION(:,:), POINTER :: ZALBUV_SOIL
REAL, DIMENSION(:,:), POINTER :: ZALBNIR
REAL, DIMENSION(:,:), POINTER :: ZALBVIS
REAL, DIMENSION(:,:), POINTER :: ZALBUV
!
REAL, DIMENSION(:,:), POINTER :: ZPSN
REAL, DIMENSION(:,:), POINTER :: ZPSNG
REAL, DIMENSION(:,:), POINTER :: ZPSNV
REAL, DIMENSION(:,:), POINTER :: ZPSNV_A
!
REAL, DIMENSION(KI,NVEGTYPE,1) :: ZVEGTYPE_PATCH
!
REAL, DIMENSION(SIZE(PLAIMIN),1) :: ZLAIMIN
REAL, DIMENSION(SIZE(PH_TREE),1) :: ZH_TREE
REAL, DIMENSION(SIZE(PLAI),1) :: ZLAI
REAL, DIMENSION(SIZE(PZ0),1) :: ZZ0
REAL, DIMENSION(SIZE(PVEG),1) :: ZVEG
REAL, DIMENSION(SIZE(PEMIS),1) :: ZEMIS
!
LOGICAL :: LAGRI_TO_GRASS
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!               Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('INIT_VEG_GARDEN_n',0,ZHOOK_HANDLE)
!
NULLIFY(ZFAPARC)
NULLIFY(ZFAPIRC)
NULLIFY(ZLAI_EFFC)
NULLIFY(ZMUS)
!
NULLIFY(ZALBNIR_SOIL)
NULLIFY(ZALBVIS_SOIL)
NULLIFY(ZALBUV_SOIL)
NULLIFY(ZALBNIR)
NULLIFY(ZALBVIS)
NULLIFY(ZALBUV)
!
NULLIFY(ZPSN)
NULLIFY(ZPSNG)
NULLIFY(ZPSNV)
NULLIFY(ZPSNV_A)
!
ZLAIMIN(:,1) = PLAIMIN(:)
ZH_TREE(:,1) = PH_TREE(:)
ZLAI(:,1) = PLAI(:)
ZZ0(:,1) = PZ0(:)
ZVEG(:,1) = PVEG(:)
ZEMIS(:,1) = PEMIS(:)
!
LAGRI_TO_GRASS = .FALSE.
!
ZVEGTYPE_PATCH(:,:,1) = PVEGTYPE(:,:)
!-------------------------------------------------------------------------------
!
 CALL INIT_VEG_n(1, KI, OCANOPY, HROUGH, LAGRI_TO_GRASS, TPSNOW, &
                   HPHOTO, .FALSE., .FALSE., .FALSE., &
                   ZLAIMIN, ZH_TREE, ZVEGTYPE_PATCH, ZLAI, ZZ0, ZVEG, ZEMIS, &
                   OTR_ML, ZFAPARC, ZFAPIRC, ZLAI_EFFC, ZMUS, &
                   ZALBNIR_SOIL, ZALBVIS_SOIL, ZALBUV_SOIL, ZALBNIR, ZALBVIS, ZALBUV, &
                   OSURF_DIAG_ALBEDO, ZPSN, ZPSNG, ZPSNV, ZPSNV_A, &
                   PDIR_ALB, PSCA_ALB, PEMIS, PTSRAD )
!
PLAI(:) = ZLAI(:,1)
PZ0(:) = ZZ0(:,1)
PVEG(:) = ZVEG(:,1)
PEMIS(:) = ZEMIS(:,1)
!
ALLOCATE(PFAPARC(SIZE(ZFAPARC,1)))
IF (SIZE(ZFAPARC)>0) &
PFAPARC(:)=ZFAPARC(:,1)

ALLOCATE(PFAPIRC(SIZE(ZFAPIRC,1)))
IF (SIZE(ZFAPIRC)>0) &
PFAPIRC(:)=ZFAPIRC(:,1)

ALLOCATE(PLAI_EFFC(SIZE(ZLAI_EFFC,1)))
IF (SIZE(ZLAI_EFFC)>0) &
PLAI_EFFC(:)=ZLAI_EFFC(:,1)

ALLOCATE(PMUS(SIZE(ZMUS,1)))
IF (SIZE(ZMUS)>0) &
PMUS(:)=ZMUS(:,1)
!
ALLOCATE(PALBNIR_SOIL(SIZE(ZALBNIR_SOIL,1)))
PALBNIR_SOIL(:)=ZALBNIR_SOIL(:,1)
ALLOCATE(PALBVIS_SOIL(SIZE(ZALBVIS_SOIL,1)))
PALBVIS_SOIL(:)=ZALBVIS_SOIL(:,1)
ALLOCATE(PALBUV_SOIL(SIZE(ZALBUV_SOIL,1)))
PALBUV_SOIL(:)=ZALBUV_SOIL(:,1)
ALLOCATE(PALBNIR(SIZE(ZALBNIR,1)))
PALBNIR(:)=ZALBNIR(:,1)
ALLOCATE(PALBVIS(SIZE(ZALBVIS,1)))
PALBVIS(:)=ZALBVIS(:,1)
ALLOCATE(PALBUV(SIZE(ZALBUV,1)))
PALBUV(:)=ZALBUV(:,1)
!
ALLOCATE(PPSN(SIZE(ZPSN,1)))
IF (SIZE(ZPSN)>0) &
PPSN(:)=ZPSN(:,1)

ALLOCATE(PPSNG(SIZE(ZPSNG,1)))
IF (SIZE(ZPSNG)>0) &
PPSNG(:)=ZPSNG(:,1)

ALLOCATE(PPSNV(SIZE(ZPSNV,1)))
IF (SIZE(ZPSNV)>0) &
PPSNV(:)=ZPSNV(:,1)

ALLOCATE(PPSNV_A(SIZE(ZPSNV_A,1)))
IF (SIZE(ZPSNV_A)>0) &
PPSNV_A(:)=ZPSNV_A(:,1)
!
IF (LHOOK) CALL DR_HOOK('INIT_VEG_GARDEN_n',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_VEG_GARDEN_n
